/*
  Copyright (c) 2019, Antonio SJ Musumeci <trapexit@spawn.link>

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

#pragma once

#include "fuse.h"
#include "tofrom_string.hpp"
#include "fuse_readdir_base.hpp"

#include <memory>
#include <mutex>

#include <assert.h>


namespace FUSE
{
  int readdir(const fuse_req_ctx_t   *ctx,
              fuse_file_info_t const *ffi,
              fuse_dirents_t         *buf);
}

// The 'initialize' feature is ugly but required currently as when
// using mount.mergerfs the process will fork so if readdir needs to
// spawn threads it needs to do so after the fork. Longer term need to
// do argument/config file validation in main() and actual resource
// initialization in fuse_init().
namespace FUSE
{
  class ReadDir : public ToFromString
  {
  public:
    ReadDir(const std::string_view s_);

  public:
    std::string to_string() const;
    int from_string(const std::string_view);

  public:
    int operator()(const fuse_req_ctx_t   *ctx,
                   fuse_file_info_t const *ffi,
                   fuse_dirents_t         *buf);

  public:
    void initialize();

  private:
    bool _initialized = false;
    std::shared_ptr<std::string>       _str;
    std::shared_ptr<FUSE::ReadDirBase> _impl;
  };
}
