
#include <libintl.h>
#include "NotGenerated.h"
#include "Chord.h"
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Table.H>
#include <FL/Fl_Int_Input.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/fl_draw.H>
#include <FL/fl_message.H>
//
//Copyright (c) 2003-2004 Josep Andreu (Holborn)
//     further modified by Robert Vogel 9/20/2015. 
//Graphic Designer: Guy Daniel CLOTILDE
//License: GNU GPL version 2
//
extern GMO gmo;
extern GMORGAN gmoUI;
extern int LastBar;
extern char AName[16];
extern CHORD zing;
Fl_Scroll* thescroll;
char fundamental[4];
int kn;
int sharpswitch =0;
// Keyboard switch values.
const int Row1col1 = 49;
const int Row1col2 = 50;
const int Row1col3 = 51;
const int Row1col4 = 52;
const int Row1col5 = 53;
const int Row1col6 = 54;
const int Row1col7 = 55;
const int Row1col8 = 56;
const int Row2col1 = 113;
const int Row2col2 = 119;
const int Row2col3 = 101;
const int Row2col4 = 114;
const int Row2col5 = 116;
const int Row2col6 = 121;
const int Row2col7 = 117;
const int Row2col8 = 106;
const int Row3col1 = 97;
const int Row3col2 = 115;
const int Row3col3 = 100;
const int Row3col4 = 102;
const int Row3col5 = 103;
const int Row3col6 = 104;
const int Row3col7 = 106;
const int Row3col8 = 107;
const int Row4col1 = 122;
const int Row4col2 = 120;
const int Row4col3 = 99;
const int Row4col4 = 118;
const int Row4col5 = 98;
const int Row4col6 = 110;
const int Row4col7 = 109;
const int Row4col8 = 44;
const int MAX_COLS = 129;
const int MAX_ROWS = 61;
// Note spreadsheet from fltk examples. Modified for this. 7/29/2014.
// "$Id: table-spreadsheet-with-keyboard-nav.cxx 8864 2011-07-19 04:49:30Z greg.ercolano $"
//
// rlv
  int values[MAX_ROWS][MAX_COLS];			// array of data for cells
class Spreadsheet : public Fl_Table {
  Fl_Int_Input *input;					// single instance of Fl_Int_Input widget
  int row_edit, col_edit;				// row/col being modified
  int s_left, s_top, s_right, s_bottom;			// kb nav + mouse selection
//protected:
public:
  void draw_cell(TableContext context,int=0,int=0,int=0,int=0,int=0,int=0);
  void event_callback2();				// table's event callback (instance)
  static void event_callback(Fl_Widget*, void *v) {	// table's event callback (static)
    ((Spreadsheet*)v)->event_callback2();
  }
  static void input_cb(Fl_Widget*, void* v) {		// input widget's callback
    ((Spreadsheet*)v)->set_value_hide();
  }

public:
  Spreadsheet(int X,int Y,int W,int H,const char* L=0) : Fl_Table(X,Y,W,H,L) {
    callback(&event_callback, (void*)this);
    when(FL_WHEN_NOT_CHANGED|when());
    // Create input widget that we'll use whenever user clicks on a cell
    input = new Fl_Int_Input(W/2,H/2,0,0);
    input->hide();
    input->callback(input_cb, (void*)this);
    input->when(FL_WHEN_ENTER_KEY_ALWAYS);		// callback triggered when user hits Enter
    input->maximum_size(5);
    row_edit = col_edit = 0;
    s_left = s_top = s_right = s_bottom = 0;
//rlv loadgrid
    for (int c = 1; c < MAX_COLS; c++)
      for (int r = 1; r < MAX_ROWS; r++)
	{
	values[r-1][c-1] = (Edr[r][c]);		// initialize cells
	}
    end();
  }
  ~Spreadsheet() { }

  // Apply value from input widget to values[row][col] array and hide (done editing)
  void set_value_hide() {
    values[row_edit][col_edit] = atoi(input->value());
    input->hide();
    window()->cursor(FL_CURSOR_DEFAULT);		// XXX: if we don't do this, cursor can disappear!
  }
public:
  void reloadtable() {
    for (int c = 1; c < MAX_COLS; c++)
      for (int r = 1; r < MAX_ROWS; r++)
	{
	values[r-1][c-1] = (Edr[r][c]);		// initialize cells
	}
  }		
  // Change number of rows
  void rows(int val) {
    Fl_Table::rows(val);
  }
  // Change number of columns
  void cols(int val) {
    Fl_Table::cols(val);
  }
  // Get number of rows
  inline int rows() {
    return Fl_Table::rows();
  }
  // Get number of columns
  inline int cols() {
    return Fl_Table::cols();
  }
  // Start editing a new cell: move the Fl_Int_Input widget to specified row/column
  //    Preload the widget with the cell's current value,
  //    and make the widget 'appear' at the cell's location.
  //
  void start_editing(int R, int C) {
    row_edit = R;					// Now editing this row/col
    col_edit = C;
    int X,Y,W,H;
    find_cell(CONTEXT_CELL, R,C, X,Y,W,H);		// Find X/Y/W/H of cell
    input->resize(X,Y,W,H);				// Move Fl_Input widget there
    char s[30]; sprintf(s, "%d", values[R][C]);		// Load input widget with cell's current value
    input->value(s);
    input->position(0,strlen(s));			// Select entire input field
    input->color(FL_YELLOW);
    input->show();					// Show the input widget, now that we've positioned it
//    cout << " after show = " << s << " R= " << R << " C=" << C << endl;
    Edr[R+1][C+1] = atoi(s);
    input->take_focus();
  }
  // Tell the input widget it's done editing, and to 'hide'
  void done_editing() {
    if (input->visible()) {				// input widget visible, ie. edit in progress?
      set_value_hide();					// Transfer its current contents to cell and hide
    }
  }
  // Return the sum of all rows in this column
  int sum_rows(int C) {
    int sum = 0;
    for (int r=0; r<rows()-1; ++r)			// -1: don't include cell data in 'totals' column
      sum += values[r][C];
    return(sum);
  }
  // Return the sum of all cols in this row
  int sum_cols(int R) {
    int sum = 0;
    for (int c=0; c<cols()-1; ++c)			// -1: don't include cell data in 'totals' column
      sum += values[R][c];
    return(sum);
  }
  // Return the sum of all cells in table
  int sum_all() {
    int sum = 0;
//    for (int c=0; c<cols()-1; ++c)			// -1: don't include cell data in 'totals' column
//      for (int r=0; r<rows()-1; ++r)			// -1: ""
//	sum += values[r][c];
    return(sum);
  }
};

// Handle drawing all cells in table
void Spreadsheet::draw_cell(TableContext context, int R,int C, int X,int Y,int W,int H) {
  static char s[30]; 
  char temp[512];
  int i;
  switch ( context ) {
    case CONTEXT_STARTPAGE:			// table about to redraw
      // Get kb nav + mouse 'selection region' for use below
      get_selection(s_top, s_left, s_bottom, s_right);
      break;

    case CONTEXT_COL_HEADER:			// table wants us to draw a column heading (C is column)
      fl_font(FL_HELVETICA | FL_BOLD, 14);	// set font for heading to bold
      fl_push_clip(X,Y,W,H);			// clip region for text
      {
//	fl_draw_box(FL_THIN_UP_BOX, X,Y,W,H, col_header_color(FL_RED));
	fl_draw_box(FL_THIN_UP_BOX, X,Y,W,H, FL_YELLOW);
	fl_color(FL_DARK_MAGENTA);
	if (C == cols()-1) {			// Last column? show 'TOTAL'
	  fl_draw("ROW", X,Y,W,H, FL_ALIGN_CENTER);
	} else {				// Not last column? show column letter
	  if (C%16 == 0)
		{
		int bno = (C/16);
	  	sprintf(s, "%d", bno+1);
		}
		else
		{
		sprintf(s,"%s", "_");
		}		
	  fl_draw(s, X,Y,W,H, FL_ALIGN_CENTER);
	}
      }
      fl_pop_clip();
      return;
//rlvrow
    case CONTEXT_ROW_HEADER:			// table wants us to draw a row heading (R is row)
      fl_font(FL_HELVETICA | FL_BOLD, 14);	// set font for row heading to bold
      fl_push_clip(X,Y,W,H);
      {
	fl_draw_box(FL_THIN_UP_BOX, X,Y,W,H, row_header_color());
	fl_color(FL_BLUE);
	if (R == rows()-1) {			// Last row? Show 'Total'
	  fl_draw("COLUMN", X,Y,W,H, FL_ALIGN_CENTER);
	} else {				// Not last row? show row#
      		bzero (temp, sizeof (temp));
      		if (strcmp (gmo.PD[gmo.Rt[gmo.sp].drpc].DNN[R + 26].Nom, "") != 0)
		{
	  	for (i = 0;
		       i <=
		       (int) strlen (gmo.PD[gmo.Rt[gmo.sp].drpc].DNN[R + 26].Nom) -
		       2; i++)
			    temp[i] = gmo.PD[gmo.Rt[gmo.sp].drpc].DNN[R + 26].Nom[i];
		}
/*
      		if (strcmp (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[R + 26].Nom, "") != 0)
		{
	  	for (i = 0;
		       i <=
		       (int) strlen (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[R + 26].Nom) -
		       2; i++)
			    temp[i] = gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[R + 26].Nom[i];
		}
*/
	  sprintf(s, "%s", temp);
	  fl_draw(s, X,Y,W,H, FL_ALIGN_CENTER);
	}
      }
      fl_pop_clip();
      return;

    case CONTEXT_CELL: {			// table wants us to draw a cell
      if (R == row_edit && C == col_edit && input->visible()) {
	return;					// dont draw for cell with input widget over it
      }
      // Background
      // Keyboard nav and mouse selection highlighting
      if (R >= s_top && R <= s_bottom && C >= s_left && C <= s_right) {
	fl_draw_box(FL_THIN_UP_BOX, X,Y,W,H, FL_YELLOW);
      } else if ( C < cols()-1 && R < rows()-1 ) {
	fl_draw_box(FL_THIN_UP_BOX, X,Y,W,H, FL_WHITE);
      } else {
	fl_draw_box(FL_THIN_UP_BOX, X,Y,W,H, 0xbbddbb00);	// money green
      }
      // Text
      fl_push_clip(X+3, Y+3, W-6, H-6);
      {
	fl_color(FL_BLACK); 
	  if (C%16 == 0)
		{
		fl_color(FL_RED);
		}
		else
		{
		fl_color(FL_BLACK);
		}		
	if (C == cols()-1 || R == rows()-1) {	// Last row or col? Show total
	  fl_font(FL_HELVETICA | FL_BOLD, 14);	// ..in bold font
	  if (C == cols()-1 && R == rows()-1) {	// Last row+col? Total all cells
	    sprintf(s, "%d", sum_all());
	  } else if (C == cols()-1) {		// Row subtotal
//	    sprintf(s, "%d", sum_cols(R));
	    sprintf(s, "%d", R+1);
	  } else if (R == rows()-1) {		// Col subtotal
//	    sprintf(s, "%d", sum_rows(C));
	    sprintf(s, "%d", C+1);
	  }
	  fl_draw(s, X+3,Y+3,W-6,H-6, FL_ALIGN_RIGHT);
	} else {				// Not last row or col? Show cell contents
	  fl_font(FL_HELVETICA, 14);		// ..in regular font
	  sprintf(s, "%d", values[R][C]);
//	  cout << " new cell content: row " << R << " col " << C << " = " << values[R][C] << endl;
	  Edr[R+1][C+1] = values[R][C];
	  fl_draw(s, X+3,Y+3,W-6,H-6, FL_ALIGN_RIGHT);
	}
      }
      fl_pop_clip();
      return;
    }

    case CONTEXT_RC_RESIZE: {			// table resizing rows or columns
      if (!input->visible()) return;
      find_cell(CONTEXT_TABLE, row_edit, col_edit, X, Y, W, H);
      if (X==input->x() && Y==input->y() && W==input->w() && H==input->h()) {
	return;					// no change? ignore
      }
      input->resize(X,Y,W,H);
      return;
    }

    default:
      return;
  }
}

// Callback whenever someone clicks on different parts of the table
void Spreadsheet::event_callback2() {
  int R = callback_row();
  int C = callback_col();
  TableContext context = callback_context(); 

  switch ( context ) {
    case CONTEXT_CELL: {				// A table event occurred on a cell
      switch (Fl::event()) { 				// see what FLTK event caused it
	case FL_PUSH:					// mouse click?
	  done_editing();				// finish editing previous
	  if (R != rows()-1 && C != cols()-1 )		// only edit cells not in total's columns
	    start_editing(R,C);				// start new edit
	  return;

	case FL_KEYBOARD:				// key press in table?
	  if ( Fl::event_key() == FL_Escape ) exit(0);	// ESC closes app
	  if (C == cols()-1 || R == rows()-1) return;	// no editing of totals column
	  done_editing();				// finish any previous editing
	  set_selection(R, C, R, C);			// select the current cell
	  start_editing(R,C);				// start new edit
	  if (Fl::event() == FL_KEYBOARD && Fl::e_text[0] != '\r') {
	    input->handle(Fl::event());			// pass keypress to input widget
	  }
	  return;
      }
      return;
    }

    case CONTEXT_TABLE:					// A table event occurred on dead zone in table
    case CONTEXT_ROW_HEADER:				// A table event occurred on row/column header
    case CONTEXT_COL_HEADER:
      done_editing();					// done editing, hide
      return;
    
    default:
      return;
  }
}

// Change number of columns
void setcols_cb(Fl_Widget* w, void* v) {
  Spreadsheet* table = (Spreadsheet*)v;
  Fl_Valuator* in = (Fl_Valuator*)w;
  int cols = int(in->value()) + 1;
  table->cols(cols);
  table->redraw();
}

// Change number of rows
void setrows_cb(Fl_Widget* w, void* v) {
  Spreadsheet* table = (Spreadsheet*)v;
  Fl_Valuator* in = (Fl_Valuator*)w;
  int rows = int(in->value()) + 1;
  table->rows(rows);
  table->redraw();
}

MiValueInput::MiValueInput (int x, int y, int w, int h, const char *label):
Fl_Value_Input (x, y, w, h, label)
{
}

int
MiValueInput::handle (int event)
{
  int i;
  switch (event)
    {
    case FL_SHORTCUT:
      {
	return 0;
//	break;
      }
    case FL_KEYDOWN:
      {
 	i = Fl::event_key ();
        if (gmo.AccordionSelect) interpretkey(i);
	else
	{
	do_callback ();
	}
	return 1;
//	break;
      }

    default:
      return 1;
    }
}

void
MiValueInput::interpretkey (int keyno)
{
  kn = keyno;
  switch (keyno)
	{
	case Row1col1:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Cdim7");
			}
		else
			{
			strcpy (KbChordSymbol, "C#dim7");
			}
		break;
		}
	case Row1col2:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Ddim7");
			}
		else
			{
			strcpy (KbChordSymbol, "D#dim7");
			}
		break;
		}
	case Row1col3:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Edim7");
			}
		else
			{
			strcpy (KbChordSymbol, "Fdim7");
			}
		break;
		}
	case Row1col4:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Fdim7");
			}
		else
			{
			strcpy (KbChordSymbol, "F#dim7");
			}
		break;
		}
	case Row1col5:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Gdim7");
			}
		else
			{
			strcpy (KbChordSymbol, "G#dim7");
			}
		break;
		}
	case Row1col6:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Adim7");
			}
		else
			{
			strcpy (KbChordSymbol, "A#dim7");
			}
		break;
		}
	case Row1col7:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Bdim7");
			}
		else
			{
			strcpy (KbChordSymbol, "Cdim7");
			}
		break;
		}
	case Row2col1:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "C7");
			}
		else
			{
			strcpy (KbChordSymbol, "C#7");
			}
		break;
		}
	case Row2col2:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "D7");
			}
		else
			{
			strcpy (KbChordSymbol, "D#7");
			}
		break;
		}
	case Row2col3:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "E7");
			}
		else
			{
			strcpy (KbChordSymbol, "F7");
			}
		break;
		}
	case Row2col4:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "F7");
			}
		else
			{
			strcpy (KbChordSymbol, "F#7");
			}
		break;
		}
	case Row2col5:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "G7");
			}
		else
			{
			strcpy (KbChordSymbol, "G#7");
			}
		break;
		}
	case Row2col6:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "A7");
			}
		else
			{
			strcpy (KbChordSymbol, "A#7");
			}
		break;
		}
	case Row2col7:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "B7");
			}
		else
			{
			strcpy (KbChordSymbol, "C7");
			}
		break;
		}
	case Row3col1:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "CMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "C#Maj7");
			}
		break;
		}
	case Row3col2:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "DMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "D#Maj7");
			}
		break;
		}
	case Row3col3:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "EMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "FMaj7");
			}
		break;
		}
	case Row3col4:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "FMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "F#Maj7");
			}
		break;
		}
	case Row3col5:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "GMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "G#Maj7");
			}
		break;
		}
	case Row3col6:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "AMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "A#Maj7");
			}
		break;
		}
	case Row3col7:
		{
		if (sharpswitch == 0)
			{
  			strcpy (KbChordSymbol, "BMaj7");
			}
		else
			{
  			strcpy (KbChordSymbol, "CMaj7");
			}
		break;
		}
	case Row4col1:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Cm7");
			}
		else
			{
			strcpy (KbChordSymbol, "C#m7");
			}
		break;
		}
	case Row4col2:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Dm7");
			}
		else
			{
			strcpy (KbChordSymbol, "D#m7");
			}
		break;
		}
	case Row4col3:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Em7");
			}
		else
			{
			strcpy (KbChordSymbol, "Fm7");
			}
		break;
		}
	case Row4col4:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Fm7");
			}
		else
			{
			strcpy (KbChordSymbol, "F#m7");
			}
		break;
		}
	case Row4col5:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Gm7");
			}
		else
			{
			strcpy (KbChordSymbol, "G#m7");
			}
		break;
		}
	case Row4col6:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Am7");
			}
		else
			{
			strcpy (KbChordSymbol, "A#m7");
			}
		break;
		}
	case Row4col7:
		{
		if (sharpswitch == 0)
			{
	  		strcpy (KbChordSymbol, "Bm7");
			}
		else
			{
			strcpy (KbChordSymbol, "Cm7");
			}
		break;
		}
	case 65505:      // shift key.
		{
  		if (sharpswitch	== 0)
			{sharpswitch = 1;
			}
		else
			{sharpswitch =0;}	
		break;
		}
        default:
  		strcpy (AName, NombreAcorde);
		
	}
  strcpy (AName, KbChordSymbol);
  strcpy (NombreAcorde, KbChordSymbol);
  gmo.KeybON =1;
  gmo.GeneraChord();
  cambialo = 1;
}

void
SPLASH::cb_splashwin_i (Fl_Double_Window *, void *)
{
  clicksplash = 1;
}

void
SPLASH::cb_splashwin (Fl_Double_Window * o, void *v)
{
  ((SPLASH *) (o->user_data ()))->cb_splashwin_i (o, v);
}

void
SPLASH::cb__i (Fl_Button *, void *)
{
  clicksplash = 1;
}

void
SPLASH::cb_ (Fl_Button * o, void *v)
{
  ((SPLASH *) (o->parent ()->user_data ()))->cb__i (o, v);
}

#include <FL/Fl_Image.H>
static unsigned char idata_gmorgan_logo[] =
  { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 253, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 253,
    255, 255, 253, 255, 255,
  255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255,
    255, 253, 255, 255, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255,
    255, 253, 255, 255, 255,
  255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 255, 255, 255, 255,
    255, 254, 255, 255, 254,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 253, 255, 255, 253, 255, 255, 253, 255, 255, 253, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 253, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 253,
  255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 255, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 255, 255,
  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 254, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 253, 255, 253, 251, 255, 253, 251,
    255, 253, 253, 255, 255,
  253, 255, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    253, 253, 255, 251, 250,
  255, 238, 236, 243, 218, 214, 255, 247, 244, 255, 249, 247, 254, 250, 249,
    252, 252, 250, 253, 253,
  253, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254,
    254, 255, 255, 253, 255,
  253, 251, 255, 250, 249, 255, 247, 244, 233, 202, 199, 187, 146, 142, 175,
    136, 131, 198, 173, 169,
  239, 225, 222, 241, 237, 234, 242, 242, 240, 247, 247, 247, 251, 251, 251,
    253, 253, 253, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 255, 255, 253, 251, 255, 249, 244, 255, 218,
    212, 208, 158, 151, 192,
  133, 125, 190, 133, 124, 186, 137, 130, 170, 139, 136, 100, 82, 80, 118,
    113, 110, 213, 213, 213,
  230, 230, 230, 240, 240, 240, 247, 247, 247, 252, 252, 252, 253, 255, 254,
    254, 255, 255, 255, 255,
  255, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 255, 255, 255, 255, 254, 253, 255, 252, 251,
    255, 250, 250, 255, 235,
  232, 218, 177, 171, 193, 140, 132, 200, 137, 128, 197, 137, 127, 191, 138,
    130, 141, 100, 94, 43,
  18, 14, 10, 0, 0, 3, 0, 0, 29, 27, 28, 149, 145, 146, 222, 216, 218, 236,
    230, 232, 246, 242, 243,
  249, 249, 249, 252, 254, 253, 254, 254, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 253, 255, 251, 250,
  255, 243, 240, 239, 194, 191, 200, 142, 138, 203, 136, 128, 201, 137, 128,
    193, 138, 131, 164, 123,
  117, 70, 45, 41, 13, 0, 0, 7, 0, 0, 3, 0, 0, 1, 0, 0, 3, 0, 0, 8, 0, 0, 68,
    52, 55, 195, 179, 182, 231, 219,
  221, 239, 235, 236, 245, 245, 245, 251, 251, 251, 254, 254, 254, 254, 254,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 253, 253, 255, 251, 251,
    255, 249, 248, 247, 216,
  213, 204, 156, 152, 202, 137, 131, 209, 134, 128, 212, 133, 126, 199, 131,
    122, 117, 68, 63, 29, 0,
  0, 8, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 6, 0, 0, 8, 0, 0, 21, 2, 6, 77, 56,
    61, 96, 80, 83, 110, 98, 100, 208,
  204, 205, 227, 227, 227, 240, 239, 237, 248, 247, 245, 251, 251, 251, 254,
    254, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 253, 255, 255, 253, 254, 255, 255, 254, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 252, 255, 254, 251, 255, 250, 248, 255, 230, 228, 219, 170,
    166, 199, 138, 133, 206,
  135, 129, 211, 134, 128, 213, 133, 126, 212, 133, 126, 181, 114, 106, 70,
    25, 20, 18, 0, 0, 7, 0, 0, 0,
  0, 0, 0, 0, 0, 6, 0, 0, 16, 0, 0, 54, 27, 34, 112, 87, 93, 51, 32, 38, 7, 0,
    0, 3, 0, 0, 22, 20, 21, 134,
  133, 131, 223, 218, 215, 235, 230, 227, 243, 242, 240, 248, 248, 248, 252,
    252, 252, 254, 254, 254,
  255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 254, 254,
    254, 255, 255, 255, 255,
  255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 253, 255, 255, 253, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 253,
    255, 253, 251, 255, 250,
  250, 255, 242, 241, 231, 193, 190, 201, 143, 141, 206, 137, 132, 210, 135,
    129, 212, 133, 126, 212,
  133, 126, 212, 133, 126, 209, 135, 126, 202, 138, 129, 189, 140, 135, 122,
    87, 83, 32, 8, 6, 10, 0, 0,
  6, 0, 0, 7, 0, 0, 67, 44, 50, 86, 59, 66, 18, 0, 4, 8, 0, 0, 4, 0, 0, 3, 0,
    0, 7, 0, 0, 32, 21, 19, 167, 156,
  152, 211, 201, 199, 224, 220, 219, 235, 235, 235, 244, 244, 244, 250, 250,
    250, 255, 253, 254, 255,
  253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 254, 254, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 253, 255, 252, 251, 255, 247, 246, 250,
    209, 207, 209, 151, 149,
  206, 139, 133, 210, 135, 130, 213, 136, 130, 210, 135, 129, 209, 136, 130,
    207, 136, 130, 205, 136,
  129, 204, 137, 129, 202, 138, 129, 200, 137, 130, 197, 138, 132, 181, 128,
    122, 92, 53, 48, 17, 0, 0,
  8, 0, 0, 7, 0, 0, 6, 0, 0, 4, 0, 0, 3, 0, 0, 4, 0, 0, 14, 0, 0, 109, 82, 75,
    190, 160, 152, 153, 129, 125,
  62, 48, 45, 87, 83, 82, 198, 198, 198, 226, 226, 226, 239, 239, 239, 247,
    247, 247, 251, 251, 251,
  254, 254, 254, 255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255,
    254, 255, 255, 253, 253,
  255, 252, 251, 255, 250, 250, 255, 228, 226, 214, 168, 168, 199, 141, 139,
    206, 138, 135, 209, 138,
  134, 206, 138, 135, 198, 137, 132, 187, 129, 125, 200, 147, 143, 205, 154,
    151, 206, 158, 154, 189,
  142, 136, 172, 123, 118, 170, 117, 111, 166, 113, 107, 177, 127, 120, 186,
    143, 137, 141, 113, 109,
  46, 28, 24, 10, 0, 0, 7, 0, 0, 6, 0, 0, 8, 0, 0, 57, 42, 39, 166, 145, 140,
    179, 148, 143, 110, 79, 74,
  25, 4, 0, 10, 0, 0, 6, 0, 0, 19, 13, 15, 127, 121, 123, 219, 215, 216, 234,
    230, 231, 242, 240, 241,
  249, 247, 248, 252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    253, 253, 255, 250, 250,
  255, 240, 238, 233, 185, 183, 204, 144, 143, 208, 140, 137, 208, 140, 137,
    199, 141, 139, 180, 132,
  128, 195, 161, 159, 215, 189, 188, 231, 210, 209, 228, 210, 208, 225, 207,
    207, 222, 206, 206, 222,
  207, 204, 222, 207, 204, 222, 204, 202, 213, 193, 192, 183, 164, 160, 156,
    132, 128, 141, 113, 109,
  164, 133, 128, 113, 82, 77, 33, 4, 0, 34, 6, 2, 137, 108, 104, 191, 160,
    155, 142, 114, 110, 46, 28,
  26, 8, 0, 0, 6, 0, 0, 6, 0, 0, 8, 0, 0, 29, 13, 16, 45, 29, 32, 53, 38, 41,
    168, 158, 159, 224, 218, 218,
  236, 232, 231, 244, 243, 241, 250, 250, 250, 253, 253, 253, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255,
    255, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 254, 253, 255, 252, 253, 255, 251, 251, 255,
    248, 247, 242, 206, 206,
  204, 153, 152, 209, 141, 138, 212, 138, 135, 208, 140, 137, 187, 129, 127,
    198, 157, 155, 232, 206,
  205, 223, 209, 208, 217, 211, 211, 213, 211, 212, 211, 211, 211, 212, 212,
    212, 211, 211, 211, 210,
  212, 211, 210, 212, 211, 211, 211, 211, 212, 210, 211, 214, 210, 209, 217,
    207, 205, 217, 196, 193,
  164, 136, 132, 143, 112, 107, 166, 129, 123, 194, 151, 145, 180, 135, 129,
    97, 58, 51, 24, 0, 0, 7, 0,
  0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 8, 0, 0, 21, 2, 4, 17, 0, 0, 20, 0, 0, 57, 29,
    26, 198, 173, 168, 223, 204,
  198, 232, 221, 217, 240, 236, 233, 245, 247, 244, 251, 251, 251, 254, 254,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 254, 253, 255, 252, 251, 255, 249, 248, 255, 222, 223, 216, 165, 164,
    206, 142, 142, 211, 140,
  138, 216, 138, 136, 208, 140, 137, 180, 135, 132, 219, 189, 187, 228, 210,
    210, 218, 210, 208, 215,
  211, 210, 213, 211, 212, 212, 212, 212, 212, 212, 212, 211, 213, 212, 211,
    213, 212, 211, 211, 211,
  211, 211, 211, 211, 211, 211, 212, 212, 212, 212, 210, 211, 214, 210, 209,
    217, 209, 207, 219, 208,
  206, 193, 178, 175, 135, 106, 102, 191, 138, 130, 165, 108, 99, 58, 17, 11,
    18, 0, 0, 6, 0, 0, 0, 0, 0,
  0, 0, 0, 1, 0, 0, 3, 0, 0, 8, 0, 0, 27, 0, 0, 132, 89, 82, 212, 154, 142,
    196, 137, 121, 188, 140, 126,
  219, 190, 176, 222, 215, 205, 226, 231, 225, 240, 242, 239, 248, 248, 248,
    252, 252, 252, 254, 254,
  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 253, 255,
    255, 253, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254,
    253, 255, 252, 251, 255,
  250, 250, 255, 238, 237, 225, 183, 184, 205, 145, 145, 212, 140, 141, 218,
    138, 137, 218, 137, 134,
  213, 138, 135, 191, 131, 130, 222, 192, 190, 221, 211, 210, 216, 212, 211,
    213, 213, 213, 213, 213,
  213, 212, 212, 212, 212, 212, 212, 212, 212, 212, 211, 213, 212, 211, 213,
    212, 212, 212, 212, 212,
  212, 212, 212, 212, 212, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211,
    211, 211, 212, 210, 211,
  215, 209, 209, 197, 176, 173, 145, 95, 88, 198, 138, 128, 189, 136, 128,
    113, 74, 67, 26, 3, 0, 10, 0,
  0, 7, 0, 0, 7, 0, 0, 11, 0, 0, 68, 43, 36, 186, 146, 136, 198, 145, 131,
    199, 134, 116, 199, 138, 117,
  197, 155, 131, 176, 156, 132, 188, 191, 172, 207, 221, 206, 213, 223, 214,
    231, 236, 230, 243, 245,
  242, 250, 250, 250, 253, 253, 253, 254, 254, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255,
    255, 253, 255, 255, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 254,
    253, 255, 251, 251, 255,
  244, 243, 245, 201, 202, 209, 150, 152, 212, 142, 144, 215, 139, 139, 219,
    138, 137, 221, 135, 134,
  217, 137, 136, 206, 140, 141, 202, 158, 157, 231, 213, 213, 214, 213, 211,
    213, 213, 213, 213, 213,
  213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 211, 213,
    212, 211, 213, 212, 213,
  213, 213, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 211,
    211, 211, 211, 211, 211,
  211, 211, 211, 212, 210, 211, 220, 206, 205, 166, 129, 123, 183, 126, 117,
    206, 134, 120, 208, 134,
  121, 179, 121, 109, 83, 40, 31, 21, 0, 0, 33, 6, 0, 152, 105, 95, 212, 154,
    142, 201, 138, 123, 195,
  134, 116, 201, 150, 129, 187, 155, 130, 173, 170, 139, 192, 207, 174, 203,
    230, 197, 205, 234, 204,
  207, 231, 207, 206, 223, 207, 222, 229, 221, 238, 240, 237, 246, 246, 246,
    251, 251, 251, 254, 254,
  254, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253,
    255, 253, 253, 255, 251,
  251, 255, 249, 250, 251, 219, 220, 213, 163, 164, 208, 144, 145, 218, 139,
    142, 222, 138, 138, 222,
  136, 135, 222, 136, 135, 224, 136, 134, 216, 138, 136, 193, 135, 134, 228,
    192, 192, 221, 211, 210,
  213, 215, 214, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213,
    213, 213, 213, 213, 213,
  213, 212, 214, 213, 212, 214, 213, 212, 212, 212, 212, 212, 212, 212, 212,
    212, 212, 212, 212, 212,
  212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 211, 211, 211, 218,
    208, 207, 206, 178, 174,
  160, 107, 99, 216, 133, 119, 223, 130, 113, 215, 132, 116, 204, 136, 123,
    155, 105, 94, 201, 153,
  143, 203, 141, 126, 201, 136, 118, 202, 141, 120, 202, 156, 132, 180, 156,
    128, 187, 186, 155, 202,
  224, 188, 201, 238, 197, 200, 238, 199, 200, 238, 199, 202, 236, 203, 208,
    234, 207, 207, 224, 206,
  213, 225, 213, 227, 234, 227, 241, 243, 240, 248, 248, 246, 252, 252, 252,
    255, 253, 254, 255, 254,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 254, 255, 255, 252, 253, 255, 249, 250, 255, 233, 234, 230, 178, 182,
    209, 145, 146, 214, 142,
  145, 219, 141, 141, 222, 137, 140, 222, 136, 137, 224, 136, 135, 224, 136,
    135, 225, 135, 134, 217,
  139, 137, 186, 130, 129, 234, 203, 201, 221, 211, 210, 214, 214, 214, 201,
    201, 201, 136, 136, 136,
  126, 126, 126, 163, 163, 163, 213, 213, 213, 212, 212, 212, 213, 213, 213,
    213, 213, 213, 213, 213,
  213, 213, 213, 213, 213, 213, 213, 212, 212, 212, 212, 212, 212, 212, 212,
    212, 212, 212, 212, 212,
  212, 212, 213, 213, 213, 218, 210, 208, 218, 193, 189, 159, 109, 100, 216,
    133, 119, 226, 129, 112,
  224, 128, 112, 219, 132, 115, 212, 135, 119, 206, 137, 121, 198, 135, 118,
    201, 153, 131, 185, 158,
  129, 177, 173, 138, 196, 210, 175, 206, 232, 195, 205, 237, 200, 200, 238,
    199, 199, 240, 198, 199,
  240, 198, 200, 238, 199, 201, 237, 201, 204, 235, 203, 206, 232, 205, 210,
    229, 210, 215, 225, 214,
  234, 236, 231, 244, 243, 241, 249, 249, 249, 253, 253, 253, 254, 254, 254,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 255, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 253, 255, 252, 253, 255, 250, 251, 255,
    243, 244, 238, 198, 199,
  206, 151, 154, 211, 145, 147, 215, 143, 146, 213, 143, 145, 213, 143, 145,
    215, 141, 142, 218, 140,
  140, 222, 138, 138, 224, 136, 135, 225, 135, 134, 218, 138, 137, 193, 133,
    132, 228, 193, 191, 222,
  210, 210, 214, 214, 214, 151, 151, 151, 92, 92, 92, 94, 94, 94, 108, 108,
    108, 212, 212, 212, 214,
  214, 214, 214, 214, 214, 213, 213, 213, 213, 213, 213, 214, 214, 214, 213,
    213, 213, 213, 213, 213,
  213, 213, 213, 211, 211, 211, 211, 211, 211, 212, 212, 212, 212, 212, 212,
    219, 209, 207, 201, 170,
  165, 164, 107, 98, 217, 134, 120, 227, 130, 113, 226, 131, 113, 220, 131,
    113, 209, 132, 112, 205,
  143, 122, 202, 157, 134, 180, 159, 130, 191, 192, 158, 206, 227, 188, 203,
    238, 198, 200, 241, 201,
  201, 239, 200, 201, 239, 200, 199, 240, 198, 199, 240, 198, 200, 241, 199,
    201, 239, 198, 201, 238,
  197, 207, 234, 199, 215, 228, 202, 210, 207, 188, 217, 203, 192, 238, 221,
    214, 246, 235, 231, 250,
  245, 242, 252, 251, 249, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253,
    255, 252, 251, 255, 249,
  248, 255, 214, 216, 218, 159, 163, 211, 145, 147, 214, 144, 146, 211, 145,
    147, 207, 151, 152, 220,
  180, 180, 188, 149, 150, 196, 150, 152, 205, 145, 145, 217, 139, 139, 225,
    137, 136, 225, 135, 134,
  221, 137, 135, 209, 139, 137, 206, 158, 156, 228, 212, 212, 217, 215, 216,
    209, 209, 209, 163, 163,
  163, 160, 160, 158, 195, 195, 193, 214, 214, 214, 214, 214, 214, 214, 214,
    214, 214, 214, 214, 213,
  213, 213, 213, 213, 213, 214, 212, 213, 214, 212, 213, 213, 213, 211, 213,
    213, 211, 213, 213, 213,
  213, 213, 213, 212, 212, 212, 221, 207, 204, 157, 114, 107, 197, 129, 118,
    222, 134, 120, 225, 132,
  115, 220, 132, 118, 206, 133, 116, 206, 154, 132, 185, 158, 131, 177, 176,
    145, 198, 214, 178, 208,
  234, 195, 204, 239, 197, 202, 240, 201, 200, 241, 201, 200, 241, 199, 200,
    241, 199, 199, 240, 200,
  199, 240, 200, 199, 240, 200, 200, 238, 197, 205, 237, 198, 210, 226, 190,
    199, 185, 156, 183, 147,
  123, 199, 148, 129, 230, 181, 166, 239, 207, 196, 243, 224, 217, 246, 238,
    236, 248, 246, 247, 253,
  253, 253, 254, 254, 254, 255, 255, 255, 255, 255, 255, 254, 254, 254, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 255, 255, 255, 255,
    254, 255, 255, 254, 253,
  255, 251, 253, 255, 250, 250, 255, 232, 234, 219, 177, 179, 208, 146, 149,
    215, 144, 148, 213, 142,
  146, 209, 147, 150, 216, 166, 167, 243, 207, 207, 221, 201, 202, 177, 161,
    161, 176, 152, 152, 180,
  141, 142, 208, 148, 148, 215, 141, 140, 220, 139, 138, 222, 138, 136, 217,
    139, 137, 188, 128, 127,
  225, 194, 192, 223, 211, 211, 220, 214, 214, 216, 214, 215, 215, 215, 213,
    214, 214, 212, 214, 214,
  214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 215, 215,
    215, 215, 213, 214, 214,
  212, 213, 213, 213, 211, 213, 213, 211, 213, 213, 213, 216, 212, 211, 220,
    209, 207, 188, 159, 155,
  161, 104, 95, 213, 137, 124, 220, 134, 119, 212, 131, 112, 208, 145, 127,
    201, 159, 135, 182, 161,
  134, 194, 195, 163, 204, 229, 190, 204, 241, 200, 203, 241, 200, 201, 242,
    200, 200, 241, 201, 201,
  242, 202, 200, 241, 199, 200, 241, 199, 200, 241, 201, 202, 240, 201, 205,
    237, 198, 211, 233, 195,
  206, 213, 179, 178, 167, 135, 183, 144, 115, 214, 154, 128, 220, 148, 123,
    204, 136, 113, 183, 132,
  113, 202, 165, 149, 241, 214, 205, 245, 228, 221, 249, 239, 237, 252, 248,
    247, 254, 252, 253, 254,
  254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255,
    255, 254, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 254, 255, 255, 251, 251, 255, 239, 243, 239,
    190, 194, 211, 149, 154,
  214, 143, 149, 215, 144, 148, 211, 146, 150, 208, 159, 163, 225, 193, 196,
    255, 235, 236, 250, 240,
  239, 169, 163, 163, 148, 142, 142, 179, 170, 171, 185, 169, 169, 169, 143,
    142, 195, 151, 150, 209,
  144, 142, 219, 140, 136, 223, 140, 136, 216, 141, 136, 181, 125, 124, 226,
    190, 190, 226, 212, 212,
  218, 214, 215, 216, 214, 215, 215, 215, 215, 215, 215, 215, 214, 214, 214,
    214, 214, 214, 214, 214,
  214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214, 214,
    214, 213, 213, 213, 214,
  212, 213, 222, 208, 207, 189, 156, 151, 155, 102, 94, 209, 139, 127, 214,
    136, 123, 211, 135, 119,
  212, 155, 135, 184, 158, 131, 181, 181, 147, 202, 218, 182, 209, 237, 197,
    205, 240, 200, 203, 241,
  200, 201, 242, 200, 202, 243, 201, 201, 242, 200, 201, 242, 200, 200, 241,
    199, 200, 241, 199, 200,
  241, 201, 206, 238, 199, 212, 226, 190, 196, 190, 156, 183, 149, 121, 199,
    148, 121, 214, 150, 122,
  192, 121, 91, 187, 112, 83, 197, 126, 96, 185, 120, 92, 185, 124, 96, 208,
    146, 125, 245, 196, 179,
  241, 214, 205, 243, 232, 228, 247, 243, 242, 250, 250, 250, 253, 253, 253,
    254, 254, 254, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 252, 253, 255, 250, 253,
    255, 248, 250, 247, 211,
  215, 213, 158, 163, 212, 145, 152, 217, 144, 151, 215, 144, 150, 212, 151,
    156, 223, 177, 180, 249,
  220, 224, 255, 247, 250, 255, 254, 255, 254, 255, 255, 250, 250, 250, 181,
    181, 181, 215, 215, 215,
  218, 217, 215, 220, 212, 210, 182, 161, 160, 183, 139, 138, 208, 148, 147,
    216, 142, 139, 216, 141,
  136, 212, 142, 140, 189, 131, 129, 198, 160, 159, 231, 207, 207, 229, 211,
    211, 225, 211, 210, 222,
  212, 211, 221, 213, 211, 219, 213, 213, 219, 213, 213, 218, 213, 210, 219,
    211, 209, 220, 212, 210,
  221, 211, 210, 224, 210, 209, 226, 208, 206, 207, 183, 181, 154, 119, 115,
    167, 115, 104, 207, 141,
  127, 206, 134, 119, 215, 144, 126, 218, 151, 134, 196, 150, 127, 205, 191,
    162, 214, 228, 192, 209,
  240, 199, 204, 242, 201, 202, 243, 201, 203, 244, 202, 202, 243, 201, 201,
    242, 200, 201, 242, 200,
  201, 242, 200, 203, 241, 200, 207, 239, 200, 210, 234, 198, 205, 215, 180,
    182, 169, 137, 182, 145,
  116, 219, 153, 127, 227, 145, 121, 207, 121, 94, 202, 117, 88, 204, 124, 91,
    198, 118, 85, 195, 116,
  83, 215, 135, 102, 226, 141, 112, 214, 138, 112, 223, 167, 150, 237, 203,
    191, 240, 221, 215, 243,
  235, 233, 248, 247, 245, 251, 251, 251, 254, 254, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255,
    253, 255, 255, 253, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 255, 255, 255, 255,
    255, 255, 253, 255, 255,
  253, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 252, 253, 255,
  248, 250, 255, 226, 229, 226, 169, 175, 214, 147, 154, 218, 145, 152, 216,
    145, 151, 208, 149, 153,
  212, 167, 170, 237, 208, 210, 255, 242, 243, 255, 252, 253, 255, 254, 255,
    255, 254, 255, 255, 255,
  255, 255, 254, 255, 255, 253, 254, 243, 243, 243, 222, 222, 222, 201, 200,
    198, 146, 138, 136, 160,
  144, 144, 201, 173, 170, 207, 162, 159, 206, 145, 142, 216, 141, 136, 219,
    140, 135, 212, 138, 135,
  189, 125, 123, 210, 159, 156, 219, 179, 177, 242, 213, 209, 235, 211, 209,
    231, 211, 210, 229, 211,
  209, 229, 210, 206, 227, 206, 203, 227, 202, 198, 213, 182, 179, 185, 146,
    141, 165, 115, 108, 174,
  111, 102, 205, 137, 126, 208, 138, 126, 207, 142, 124, 214, 156, 134, 199,
    143, 120, 210, 149, 130,
  208, 157, 136, 191, 165, 138, 211, 211, 177, 213, 238, 199, 205, 242, 201,
    204, 242, 201, 202, 243,
  201, 202, 243, 201, 202, 243, 201, 202, 243, 201, 203, 241, 200, 207, 239,
    198, 211, 229, 191, 199,
  190, 159, 183, 152, 124, 199, 149, 124, 223, 156, 130, 224, 137, 110, 233,
    134, 105, 232, 133, 104,
  229, 132, 100, 203, 110, 79, 218, 125, 92, 240, 145, 113, 231, 134, 101,
    233, 133, 101, 230, 133,
  100, 225, 134, 103, 217, 145, 120, 222, 179, 163, 236, 213, 207, 236, 228,
    226, 243, 243, 243, 247,
  249, 248, 251, 253, 252, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 253, 255, 255, 253, 255, 255, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 253, 255, 255, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 255,
    255, 254, 255, 255, 254,
  253, 255, 252, 253, 255, 251, 251, 255, 240, 243, 232, 190, 194, 210, 151,
    157, 216, 145, 151, 218,
  145, 152, 214, 148, 152, 215, 159, 162, 233, 192, 196, 255, 233, 236, 255,
    251, 252, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255,
    255, 254, 255, 254, 254,
  254, 238, 238, 238, 144, 144, 144, 167, 167, 167, 169, 167, 168, 173, 165,
    163, 193, 169, 167, 211,
  170, 168, 209, 148, 145, 216, 141, 136, 222, 139, 133, 222, 139, 133, 216,
    141, 136, 203, 138, 132,
  190, 135, 130, 197, 150, 144, 203, 158, 153, 206, 163, 157, 185, 142, 135,
    166, 121, 115, 169, 119,
  112, 173, 118, 111, 195, 135, 125, 211, 143, 132, 217, 139, 126, 211, 135,
    119, 214, 152, 131, 200,
  150, 125, 200, 161, 132, 214, 179, 149, 195, 154, 126, 192, 148, 123, 201,
    161, 135, 186, 160, 133,
  188, 187, 156, 213, 229, 193, 213, 239, 200, 206, 241, 199, 204, 242, 201,
    204, 242, 201, 208, 240,
  199, 214, 236, 198, 206, 216, 181, 183, 170, 138, 186, 145, 117, 209, 147,
    122, 236, 161, 138, 225,
  139, 116, 230, 134, 109, 235, 131, 102, 236, 131, 101, 237, 132, 102, 233,
    133, 101, 234, 134, 102,
  237, 132, 100, 238, 131, 97, 238, 131, 97, 236, 132, 97, 231, 134, 101, 216,
    139, 113, 184, 138,
  123, 205, 181, 177, 213, 204, 207, 219, 220, 225, 234, 235, 237, 244, 246,
    245, 251, 251, 251, 253,
  253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 253,
  255, 255, 253, 255, 255, 255, 255, 253, 252, 255, 251, 251, 255, 246, 249,
    245, 206, 209, 211, 159,
  163, 215, 149, 153, 218, 147, 153, 214, 147, 154, 210, 155, 160, 218, 182,
    184, 248, 223, 226, 255,
  248, 248, 255, 252, 253, 255, 254, 255, 255, 255, 255, 255, 254, 255, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    244, 244, 244, 193, 193,
  193, 169, 169, 169, 168, 166, 167, 174, 165, 166, 180, 164, 164, 201, 173,
    170, 208, 163, 160, 213,
  144, 139, 223, 140, 134, 226, 137, 131, 226, 137, 129, 224, 140, 130, 222,
    139, 131, 220, 140, 131,
  220, 140, 131, 220, 140, 129, 222, 140, 129, 224, 140, 129, 221, 139, 127,
    217, 139, 127, 212, 138,
  125, 212, 145, 128, 212, 158, 134, 182, 147, 117, 212, 192, 157, 221, 207,
    170, 219, 210, 171, 233,
  219, 180, 211, 182, 148, 199, 145, 119, 209, 148, 127, 205, 160, 137, 187,
    163, 135, 204, 204, 170,
  217, 238, 199, 207, 242, 200, 208, 240, 199, 215, 229, 193, 198, 192, 158,
    185, 154, 126, 202, 148,
  122, 230, 156, 131, 225, 139, 114, 221, 133, 109, 235, 145, 121, 237, 147,
    123, 230, 136, 110, 236,
  133, 102, 239, 132, 100, 240, 133, 101, 238, 131, 97, 239, 132, 98, 239,
    132, 98, 239, 132, 98, 231,
  134, 102, 214, 138, 114, 190, 139, 122, 219, 194, 187, 218, 209, 212, 214,
    212, 226, 216, 215, 231,
  214, 215, 220, 228, 228, 228, 240, 240, 240, 248, 248, 248, 252, 252, 252,
    254, 254, 254, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 255, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 254, 253, 255, 252,
    253, 255, 249, 251, 253,
  224, 226, 212, 171, 175, 202, 147, 152, 205, 143, 148, 215, 149, 153, 214,
    152, 157, 220, 171, 175,
  243, 208, 212, 255, 243, 244, 255, 253, 253, 255, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 221, 221, 223, 174,
    174, 176, 168, 168, 168,
  169, 168, 166, 174, 166, 164, 190, 169, 166, 215, 170, 165, 214, 149, 143,
    221, 142, 137, 227, 138,
  130, 231, 137, 127, 233, 135, 124, 235, 134, 124, 235, 134, 124, 234, 136,
    123, 233, 135, 122, 232,
  136, 122, 225, 137, 123, 212, 136, 120, 216, 153, 135, 199, 147, 126, 203,
    163, 138, 230, 204, 177,
  201, 186, 153, 195, 185, 150, 245, 237, 200, 247, 238, 199, 202, 178, 144,
    199, 148, 127, 206, 144,
  131, 196, 143, 127, 201, 158, 139, 188, 164, 138, 185, 179, 147, 212, 219,
    185, 210, 216, 180, 186,
  171, 138, 185, 148, 119, 216, 156, 130, 226, 150, 126, 227, 137, 111, 231,
    135, 110, 233, 135, 110,
  230, 134, 109, 227, 135, 110, 242, 148, 122, 240, 141, 110, 236, 133, 102,
    237, 132, 100, 240, 133,
  101, 241, 133, 97, 236, 133, 100, 229, 136, 105, 210, 134, 110, 206, 155,
    138, 237, 208, 202, 211,
  200, 206, 198, 197, 211, 142, 142, 166, 184, 182, 204, 226, 225, 231, 212,
    207, 204, 230, 216, 213,
  245, 232, 226, 253, 243, 241, 255, 250, 247, 255, 254, 252, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 253, 255, 255, 253,
  255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255,
    255, 254, 255, 255, 253,
  255, 255, 250, 253, 255, 236, 240, 226, 185, 189, 201, 150, 155, 200, 143,
    149, 205, 144, 149, 207,
  150, 156, 210, 165, 168, 230, 198, 201, 255, 235, 236, 255, 250, 252, 255,
    253, 253, 255, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 245, 245, 245, 193, 193, 193, 169, 169, 169, 170,
    169, 167, 174, 166, 164,
  180, 164, 164, 203, 173, 171, 198, 150, 146, 212, 145, 139, 226, 139, 130,
    234, 137, 128, 234, 136,
  125, 234, 136, 125, 234, 138, 126, 230, 138, 125, 220, 136, 125, 215, 146,
    130, 209, 159, 134, 185,
  148, 121, 225, 190, 168, 210, 177, 158, 193, 157, 145, 213, 180, 165, 226,
    198, 174, 219, 189, 161,
  191, 155, 129, 184, 149, 129, 190, 160, 150, 234, 205, 199, 210, 180, 172,
    191, 155, 143, 196, 149,
  133, 208, 160, 138, 197, 157, 132, 193, 151, 126, 204, 148, 123, 225, 159,
    133, 199, 128, 100, 199,
  122, 94, 236, 149, 121, 231, 136, 108, 234, 133, 105, 238, 134, 105, 238,
    134, 105, 232, 133, 104,
  234, 140, 112, 244, 150, 122, 232, 137, 107, 236, 136, 104, 240, 133, 99,
    231, 136, 104, 201, 136,
  116, 223, 183, 171, 233, 210, 204, 216, 205, 211, 142, 139, 160, 168, 167,
    198, 132, 133, 163, 192,
  190, 212, 167, 162, 169, 182, 164, 160, 215, 177, 164, 238, 196, 180, 252,
    225, 216, 253, 238, 233,
  252, 247, 244, 251, 251, 251, 253, 253, 253, 254, 254, 254, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 254, 255, 255, 252, 253, 255, 249, 250, 255, 244, 248, 241, 205, 209,
    203, 154, 158, 202, 145,
  151, 204, 145, 151, 205, 148, 154, 210, 159, 164, 223, 182, 186, 249, 224,
    227, 255, 249, 249, 255,
  254, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 254, 254,
  255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 254,
  254, 254, 220, 220, 220, 174, 174, 174, 176, 176, 176, 214, 214, 214, 200,
    192, 190, 181, 153, 150,
  189, 140, 135, 223, 146, 138, 231, 139, 128, 231, 137, 127, 231, 137, 127,
    229, 139, 128, 216, 137,
  122, 218, 157, 138, 195, 149, 125, 205, 171, 143, 230, 204, 177, 206, 182,
    158, 189, 160, 142, 206,
  166, 156, 255, 213, 202, 210, 171, 154, 190, 151, 134, 186, 142, 131, 226,
    185, 181, 238, 212, 215,
  230, 209, 214, 252, 228, 226, 255, 221, 213, 219, 159, 148, 210, 138, 123,
    216, 148, 127, 226, 154,
  132, 231, 151, 128, 216, 134, 110, 217, 137, 110, 201, 120, 91, 204, 117,
    87, 246, 151, 121, 239,
  135, 106, 241, 134, 102, 242, 133, 102, 238, 133, 103, 234, 136, 107, 227,
    133, 105, 241, 146, 118,
  245, 146, 115, 237, 134, 101, 227, 138, 108, 218, 157, 138, 232, 196, 184,
    233, 214, 208, 231, 225,
  229, 191, 187, 210, 167, 164, 193, 150, 145, 167, 102, 90, 102, 153, 127,
    126, 195, 156, 141, 204,
  147, 127, 202, 147, 126, 208, 174, 162, 234, 215, 208, 240, 231, 226, 243,
    239, 236, 249, 245, 244,
  252, 251, 249, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 253, 255,
    247, 250, 255, 217, 221,
  226, 167, 173, 217, 150, 157, 217, 148, 153, 211, 146, 152, 208, 156, 160,
    215, 176, 179, 238, 213,
  216, 255, 245, 245, 255, 252, 253, 255, 254, 253, 255, 254, 255, 255, 255,
    255, 255, 255, 253, 255,
  255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 244, 244, 244, 242,
  242, 242, 181, 181, 181, 86, 82, 81, 214, 198, 198, 185, 150, 146, 195, 127,
    118, 225, 141, 131,
  227, 140, 131, 221, 139, 128, 222, 144, 131, 215, 157, 135, 185, 155, 119,
    219, 201, 165, 199, 175,
  149, 191, 166, 144, 206, 181, 159, 249, 218, 197, 238, 197, 175, 196, 153,
    134, 187, 147, 135, 197,
  160, 154, 246, 206, 214, 232, 191, 207, 208, 169, 190, 240, 203, 220, 255,
    240, 241, 234, 194, 186,
  209, 147, 134, 218, 142, 126, 236, 155, 134, 226, 142, 118, 218, 134, 108,
    226, 142, 116, 223, 142,
  115, 206, 122, 94, 207, 118, 88, 248, 151, 119, 240, 135, 105, 243, 134,
    103, 243, 132, 102, 243,
  134, 103, 241, 134, 102, 239, 134, 104, 237, 133, 104, 234, 135, 104, 244,
    149, 119, 233, 144, 114,
  223, 142, 115, 213, 148, 126, 229, 187, 173, 241, 217, 213, 228, 221, 228,
    139, 134, 141, 71, 55,
  58, 176, 139, 131, 212, 150, 129, 218, 144, 117, 214, 144, 118, 200, 145,
    124, 185, 153, 142, 182,
  163, 156, 200, 185, 178, 227, 214, 208, 236, 227, 222, 244, 239, 236, 249,
    248, 246, 252, 252, 252,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  253, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254,
    253, 255, 252, 253, 255,
  249, 251, 255, 234, 239, 229, 182, 188, 213, 152, 159, 221, 148, 157, 221,
    148, 155, 216, 151, 157,
  216, 164, 168, 237, 198, 201, 255, 236, 238, 255, 251, 252, 255, 254, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 249,
    247, 227, 211, 211, 168,
  143, 139, 190, 147, 141, 214, 147, 139, 220, 143, 135, 214, 141, 134, 224,
    156, 147, 215, 151, 139,
  197, 149, 127, 228, 209, 169, 219, 207, 167, 240, 219, 190, 231, 204, 183,
    242, 211, 191, 204, 172,
  151, 191, 153, 134, 186, 144, 132, 229, 189, 187, 234, 194, 203, 198, 159,
    178, 215, 173, 195, 247,
  199, 221, 235, 187, 201, 211, 166, 163, 197, 145, 132, 222, 153, 137, 233,
    152, 131, 226, 140, 115,
  219, 132, 105, 211, 125, 98, 226, 140, 113, 225, 138, 111, 231, 141, 114,
    238, 143, 113, 237, 136,
  106, 242, 135, 103, 244, 135, 104, 245, 135, 102, 244, 134, 101, 246, 133,
    101, 243, 134, 103, 240,
  135, 105, 234, 136, 107, 223, 136, 108, 231, 146, 117, 243, 152, 123, 225,
    141, 113, 208, 146, 125,
  208, 162, 146, 156, 123, 114, 108, 75, 66, 199, 156, 140, 206, 148, 128,
    218, 142, 116, 219, 144,
  115, 202, 141, 120, 206, 164, 148, 219, 196, 188, 213, 200, 194, 195, 182,
    174, 178, 165, 157, 204,
  193, 189, 224, 217, 211, 236, 231, 228, 245, 241, 238, 249, 248, 246, 253,
    253, 253, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 254,
  255, 255, 253, 253, 255, 250, 251, 255, 242, 244, 247, 196, 201, 219, 154,
    162, 221, 148, 157, 223,
  148, 155, 219, 149, 157, 214, 159, 164, 223, 188, 192, 201, 179, 181, 200,
    186, 186, 255, 251, 252,
  255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 253, 251, 255, 244, 242, 226, 187, 182, 211, 152, 148, 215, 146,
    139, 211, 141, 133, 217,
  150, 142, 209, 154, 149, 209, 160, 155, 209, 161, 151, 196, 153, 136, 197,
    164, 133, 242, 214, 177,
  255, 240, 207, 231, 200, 172, 195, 154, 134, 190, 148, 136, 200, 162, 161,
    244, 207, 214, 229, 186,
  205, 206, 162, 185, 207, 165, 187, 255, 213, 227, 241, 190, 195, 207, 149,
    145, 208, 146, 135, 228,
  157, 137, 227, 146, 119, 227, 142, 111, 195, 114, 84, 219, 140, 109, 189,
    108, 78, 214, 129, 100,
  239, 146, 115, 240, 141, 110, 241, 136, 107, 244, 136, 107, 244, 135, 104,
    245, 135, 102, 247, 134,
  102, 246, 133, 101, 247, 134, 100, 242, 135, 103, 236, 137, 108, 229, 139,
    112, 222, 142, 117, 222,
  142, 115, 226, 137, 107, 240, 149, 118, 232, 151, 122, 221, 144, 118, 220,
    144, 118, 226, 146, 119,
  228, 141, 111, 223, 142, 113, 209, 147, 124, 192, 146, 131, 152, 125, 116,
    150, 135, 130, 211, 203,
  200, 207, 203, 200, 207, 203, 200, 203, 198, 194, 182, 174, 171, 179, 168,
    162, 219, 206, 200, 230,
  219, 213, 240, 235, 232, 245, 245, 243, 250, 250, 250, 252, 254, 253, 254,
    254, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 252, 253, 255, 251, 251, 255, 247, 250,
    252, 216, 218, 216, 166,
  169, 220, 150, 158, 224, 147, 155, 222, 149, 156, 218, 153, 159, 224, 173,
    178, 247, 212, 216, 213,
  197, 198, 245, 241, 240, 198, 196, 197, 230, 230, 230, 234, 234, 234, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  254, 254, 254, 255, 255, 253, 255, 253, 251, 255, 249, 249, 255, 227, 224,
    218, 174, 171, 208, 150,
  146, 216, 145, 139, 214, 143, 137, 219, 160, 154, 195, 147, 143, 223, 188,
    186, 245, 216, 212, 239,
  206, 201, 217, 181, 169, 202, 157, 136, 201, 156, 127, 209, 165, 136, 195,
    153, 128, 190, 147, 131,
  230, 191, 184, 235, 206, 210, 187, 156, 171, 216, 174, 194, 255, 209, 231,
    255, 217, 230, 216, 165,
  170, 204, 144, 136, 224, 152, 138, 235, 154, 137, 204, 118, 95, 198, 109,
    79, 205, 119, 84, 184,
  101, 67, 204, 121, 89, 215, 130, 99, 245, 154, 123, 239, 140, 109, 242, 137,
    107, 245, 136, 107,
  244, 135, 106, 240, 136, 107, 238, 137, 107, 237, 138, 109, 238, 137, 107,
    241, 136, 106, 236, 138,
  109, 214, 136, 113, 221, 156, 138, 240, 184, 171, 214, 155, 141, 220, 144,
    121, 225, 140, 111, 233,
  140, 107, 249, 152, 119, 241, 142, 110, 239, 139, 105, 244, 138, 99, 232,
    139, 106, 202, 141, 120,
  223, 189, 177, 215, 201, 198, 172, 170, 171, 107, 107, 107, 169, 169, 169,
    206, 206, 206, 205, 204,
  202, 207, 202, 199, 202, 193, 188, 179, 162, 154, 195, 178, 170, 222, 213,
    208, 231, 226, 222, 242,
  238, 235, 248, 247, 245, 250, 250, 248, 254, 254, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255,
    251, 252, 255, 249, 250,
  255, 228, 232, 232, 175, 181, 218, 152, 156, 223, 151, 155, 224, 149, 156,
    218, 153, 159, 217, 168,
  172, 223, 191, 192, 230, 210, 211, 162, 150, 152, 122, 116, 116, 215, 213,
    214, 255, 253, 254, 224,
  222, 223, 139, 139, 139, 242, 242, 242, 255, 254, 255, 255, 253, 254, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 254,
  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255,
    253, 251, 255, 242, 240,
  243, 195, 191, 214, 153, 148, 215, 148, 142, 210, 141, 136, 217, 154, 149,
    205, 154, 150, 196, 165,
  162, 235, 215, 214, 229, 215, 214, 237, 226, 224, 255, 242, 239, 255, 244,
    237, 228, 176, 165, 212,
  149, 132, 216, 149, 132, 204, 145, 129, 236, 198, 189, 233, 209, 205, 240,
    224, 225, 248, 229, 233,
  247, 212, 219, 239, 193, 196, 206, 150, 149, 212, 145, 137, 238, 156, 142,
    234, 143, 125, 236, 140,
  118, 235, 139, 114, 193, 104, 74, 230, 144, 111, 226, 135, 106, 233, 138,
    110, 242, 141, 113, 242,
  137, 108, 244, 136, 107, 245, 136, 105, 246, 135, 105, 241, 137, 108, 231,
    141, 115, 220, 140, 117,
  221, 145, 122, 224, 144, 121, 232, 141, 114, 215, 135, 112, 229, 185, 174,
    215, 190, 193, 196, 176,
  188, 243, 216, 225, 238, 190, 180, 218, 148, 123, 235, 141, 107, 237, 135,
    97, 243, 146, 113, 247,
  153, 119, 240, 140, 104, 231, 141, 107, 206, 139, 113, 203, 160, 144, 210,
    193, 186, 205, 204, 202,
  203, 203, 203, 142, 142, 142, 116, 116, 116, 192, 192, 192, 202, 201, 199,
    171, 166, 162, 202, 189,
  181, 179, 162, 152, 174, 157, 149, 202, 188, 179, 227, 217, 208, 237, 230,
    224, 243, 242, 238, 248,
  248, 246, 252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 253, 255,
  252, 253, 255, 248, 250, 255, 241, 243, 237, 195, 199, 218, 156, 161, 223,
    150, 157, 225, 150, 155,
  222, 151, 157, 219, 158, 163, 232, 187, 190, 215, 189, 190, 219, 207, 207,
    151, 147, 146, 164, 164,
  164, 244, 244, 244, 219, 219, 219, 108, 106, 107, 215, 213, 214, 243, 243,
    243, 202, 202, 202, 156,
  154, 155, 249, 247, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 253, 255,
  252, 251, 255, 249, 247, 250, 222, 221, 214, 170, 167, 215, 150, 146, 218,
    145, 139, 215, 146, 139,
  221, 160, 155, 197, 147, 146, 228, 194, 193, 236, 220, 220, 225, 220, 217,
    246, 238, 236, 255, 247,
  247, 248, 233, 230, 205, 175, 173, 202, 151, 148, 206, 142, 140, 232, 167,
    161, 210, 152, 148, 196,
  157, 152, 220, 192, 189, 255, 241, 239, 255, 225, 223, 213, 169, 166, 202,
    145, 138, 219, 151, 138,
  237, 158, 143, 232, 141, 123, 239, 140, 119, 243, 138, 116, 242, 138, 113,
    230, 136, 108, 225, 131,
  103, 247, 149, 122, 242, 138, 111, 246, 136, 109, 247, 136, 108, 246, 137,
    108, 243, 138, 109, 238,
  140, 113, 225, 143, 119, 204, 139, 121, 237, 185, 171, 242, 194, 182, 220,
    167, 153, 215, 148, 129,
  209, 147, 132, 217, 184, 177, 202, 183, 187, 164, 147, 163, 255, 235, 244,
    250, 200, 189, 222, 146,
  120, 238, 140, 105, 245, 137, 99, 238, 138, 104, 235, 138, 103, 249, 151,
    114, 242, 149, 115, 222,
  145, 117, 204, 146, 124, 186, 149, 133, 199, 177, 166, 211, 198, 192, 211,
    203, 200, 194, 193, 191,
  112, 111, 109, 165, 160, 156, 207, 198, 191, 182, 168, 159, 157, 140, 130,
    223, 206, 198, 179, 165,
  156, 178, 165, 157, 214, 203, 197, 226, 219, 213, 238, 235, 230, 247, 243,
    240, 251, 250, 248, 254,
  252, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 253, 255, 252, 251, 255, 246, 248, 255, 209,
    212, 224, 162, 167, 224,
  151, 158, 229, 150, 156, 224, 151, 158, 216, 157, 161, 220, 178, 180, 244,
    215, 219, 220, 204, 205,
  215, 205, 206, 185, 181, 180, 222, 220, 221, 241, 241, 241, 139, 139, 139,
    110, 110, 110, 212, 212,
  212, 248, 248, 248, 176, 176, 176, 241, 241, 241, 209, 209, 209, 223, 223,
    223, 208, 208, 208, 254,
  254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255,
    255, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 253, 255, 252, 251, 255, 237, 235, 235, 190,
    187, 214, 153, 150, 217,
  150, 144, 211, 142, 137, 221, 158, 153, 206, 157, 153, 207, 167, 167, 245,
    212, 219, 235, 212, 220,
  237, 228, 231, 254, 246, 244, 255, 245, 244, 230, 200, 198, 197, 159, 156,
    188, 147, 145, 207, 164,
  171, 248, 207, 215, 224, 184, 192, 237, 196, 200, 210, 165, 162, 202, 153,
    146, 217, 164, 156, 212,
  152, 142, 214, 144, 132, 236, 158, 145, 228, 145, 127, 237, 150, 131, 244,
    155, 137, 236, 144, 123,
  241, 139, 116, 244, 138, 112, 243, 139, 112, 243, 139, 112, 244, 138, 112,
    246, 138, 110, 247, 137,
  110, 246, 137, 108, 245, 137, 109, 235, 141, 116, 211, 143, 124, 201, 155,
    142, 240, 211, 205, 227,
  209, 207, 235, 217, 217, 243, 222, 219, 225, 195, 187, 201, 161, 151, 199,
    153, 140, 218, 170, 158,
  255, 215, 207, 233, 175, 163, 226, 144, 120, 239, 140, 108, 245, 138, 102,
    246, 138, 100, 247, 139,
  101, 246, 140, 101, 241, 137, 98, 240, 142, 105, 243, 157, 124, 228, 149,
    119, 221, 146, 115, 204,
  142, 117, 192, 153, 136, 206, 186, 177, 181, 176, 172, 182, 179, 174, 211,
    194, 184, 168, 149, 135,
  175, 157, 145, 244, 230, 221, 235, 226, 221, 181, 176, 172, 196, 191, 187,
    177, 168, 163, 191, 178,
  170, 222, 209, 201, 232, 223, 216, 243, 238, 234, 249, 245, 244, 252, 250,
    251, 254, 254, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 253, 253, 255, 251, 251,
    255, 250, 250, 255, 227,
  228, 227, 174, 180, 220, 153, 160, 227, 150, 158, 227, 150, 156, 223, 154,
    159, 223, 166, 172, 241,
  202, 205, 233, 211, 213, 158, 149, 150, 125, 123, 124, 208, 208, 208, 248,
    248, 248, 206, 206, 206,
  148, 148, 148, 204, 204, 204, 229, 229, 229, 204, 204, 204, 126, 126, 126,
    142, 142, 142, 230, 230,
  230, 248, 248, 248, 226, 226, 226, 148, 148, 148, 229, 229, 229, 254, 254,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 254, 253, 255, 252, 251,
    255, 248, 246, 247, 216,
  213, 214, 165, 161, 212, 151, 148, 216, 145, 141, 218, 149, 144, 221, 160,
    159, 199, 149, 150, 238,
  195, 202, 237, 204, 213, 203, 175, 189, 233, 211, 223, 255, 247, 248, 248,
    230, 228, 204, 174, 172,
  194, 156, 155, 192, 148, 149, 238, 193, 198, 237, 201, 213, 190, 159, 174,
    237, 209, 221, 255, 222,
  228, 255, 212, 208, 214, 150, 140, 213, 144, 129, 230, 153, 137, 240, 154,
    137, 234, 143, 124, 236,
  141, 121, 237, 142, 122, 232, 139, 121, 248, 156, 135, 246, 146, 123, 243,
    139, 114, 244, 138, 114,
  246, 138, 112, 248, 138, 111, 247, 137, 110, 246, 138, 112, 240, 140, 114,
    228, 142, 119, 206, 139,
  122, 220, 180, 172, 238, 216, 219, 218, 210, 223, 197, 196, 212, 222, 220,
    231, 234, 229, 235, 239,
  227, 227, 250, 221, 213, 238, 182, 165, 218, 147, 125, 219, 147, 123, 228,
    144, 116, 240, 141, 109,
  245, 138, 102, 243, 139, 102, 237, 133, 96, 240, 136, 99, 241, 142, 103,
    237, 143, 107, 231, 145,
  112, 223, 142, 112, 233, 152, 122, 241, 157, 121, 226, 147, 114, 210, 150,
    124, 188, 145, 126, 177,
  149, 137, 201, 179, 166, 160, 134, 119, 206, 183, 169, 255, 238, 228, 217,
    206, 200, 171, 167, 164,
  201, 201, 199, 205, 204, 202, 206, 201, 197, 199, 186, 180, 178, 165, 156,
    201, 191, 182, 225, 216,
  209, 235, 227, 224, 245, 240, 237, 249, 248, 246, 252, 252, 252, 254, 254,
    254, 254, 254, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 253, 253,
  255, 249, 251, 255, 237, 241, 241, 189, 193, 221, 155, 159, 227, 150, 156,
    227, 150, 156, 222, 153,
  158, 217, 162, 167, 227, 191, 193, 246, 224, 226, 188, 174, 174, 168, 159,
    160, 172, 170, 171, 253,
  253, 253, 203, 203, 203, 140, 140, 140, 187, 187, 187, 253, 253, 253, 204,
    204, 204, 208, 208, 208,
  146, 146, 146, 195, 195, 195, 248, 248, 248, 192, 192, 192, 96, 96, 98, 220,
    220, 222, 255, 255,
  255, 156, 156, 156, 172, 174, 173, 247, 247, 247, 255, 255, 255, 255, 254,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 253, 255, 255, 253, 255,
    255, 255, 255, 254, 253,
  255, 251, 251, 255, 236, 233, 233, 182, 179, 217, 154, 149, 219, 150, 145,
    212, 144, 141, 221, 162,
  158, 203, 154, 150, 210, 171, 174, 247, 209, 220, 224, 176, 198, 200, 154,
    180, 240, 206, 223, 243,
  212, 220, 234, 196, 195, 198, 159, 154, 186, 151, 149, 203, 169, 170, 249,
    211, 222, 215, 178, 195,
  229, 195, 212, 250, 218, 233, 255, 232, 238, 238, 198, 196, 211, 152, 144,
    215, 145, 133, 237, 161,
  145, 228, 147, 128, 232, 144, 122, 239, 143, 119, 243, 141, 119, 244, 139,
    118, 242, 140, 118, 236,
  137, 114, 243, 148, 128, 248, 156, 133, 240, 141, 118, 244, 140, 115, 247,
    139, 111, 247, 139, 111,
  239, 141, 116, 221, 143, 121, 199, 150, 136, 235, 207, 203, 225, 209, 219,
    175, 167, 190, 156, 154,
  191, 120, 120, 158, 157, 157, 181, 230, 228, 241, 252, 243, 246, 255, 242,
    233, 245, 186, 168, 226,
  145, 118, 237, 142, 110, 243, 140, 105, 242, 139, 106, 234, 134, 100, 233,
    134, 102, 227, 133, 99,
  235, 142, 109, 227, 144, 114, 205, 138, 111, 200, 140, 116, 180, 122, 100,
    197, 137, 113, 212, 145,
  118, 233, 160, 128, 232, 156, 124, 224, 149, 118, 211, 144, 115, 179, 127,
    103, 203, 170, 155, 250,
  232, 222, 197, 188, 183, 181, 177, 174, 119, 118, 116, 137, 137, 137, 204,
    204, 204, 205, 204, 202,
  207, 203, 200, 204, 199, 195, 188, 179, 174, 181, 171, 162, 213, 198, 191,
    227, 216, 210, 236, 232,
  229, 243, 243, 243, 249, 249, 249, 253, 253, 253, 254, 254, 254, 254, 254,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 253, 255, 251, 253, 255, 246, 249, 247, 208, 211, 219,
    162, 168, 226, 151, 156,
  232, 150, 156, 229, 150, 156, 225, 156, 161, 227, 176, 181, 248, 216, 219,
    206, 192, 192, 128, 124,
  123, 164, 162, 163, 224, 224, 224, 235, 235, 235, 166, 166, 166, 135, 135,
    135, 196, 196, 196, 250,
  250, 250, 185, 185, 185, 213, 213, 213, 193, 193, 193, 222, 222, 222, 235,
    235, 235, 120, 120, 120,
  128, 128, 128, 229, 229, 231, 244, 244, 246, 157, 157, 157, 233, 233, 233,
    208, 210, 209, 212, 212,
  212, 228, 228, 228, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    253, 255, 255, 253, 255,
  255, 253, 255, 254, 253, 255, 251, 251, 255, 246, 245, 244, 210, 209, 211,
    163, 161, 219, 152, 146,
  218, 145, 139, 220, 152, 149, 218, 163, 160, 196, 155, 151, 234, 204, 204,
    231, 210, 215, 217, 191,
  204, 220, 175, 198, 252, 203, 225, 255, 214, 228, 210, 171, 176, 199, 155,
    152, 193, 149, 146, 233,
  197, 199, 236, 203, 212, 209, 175, 192, 235, 200, 220, 231, 192, 210, 255,
    219, 229, 216, 172, 171,
  204, 149, 142, 224, 154, 142, 237, 158, 143, 202, 121, 102, 207, 125, 103,
    232, 144, 120, 246, 152,
  126, 243, 141, 118, 249, 140, 119, 248, 139, 116, 245, 140, 118, 238, 142,
    120, 232, 140, 117, 250,
  154, 130, 247, 147, 123, 244, 140, 115, 243, 141, 116, 235, 141, 116, 227,
    156, 138, 249, 215, 205,
  221, 209, 209, 225, 222, 233, 149, 149, 173, 185, 185, 223, 158, 156, 193,
    229, 224, 246, 255, 246,
  255, 255, 230, 226, 214, 170, 157, 217, 151, 129, 230, 144, 117, 240, 143,
    110, 244, 141, 106, 244,
  141, 108, 235, 135, 101, 239, 141, 106, 233, 144, 112, 204, 132, 107, 221,
    166, 145, 229, 188, 168,
  224, 191, 172, 203, 170, 155, 181, 144, 128, 158, 113, 94, 177, 119, 95,
    228, 149, 116, 246, 158,
  120, 234, 149, 112, 223, 150, 118, 193, 143, 120, 182, 149, 134, 197, 177,
    168, 211, 200, 196, 207,
  203, 200, 173, 171, 172, 106, 106, 106, 166, 166, 166, 205, 205, 205, 205,
    204, 202, 207, 202, 198,
  205, 196, 189, 181, 168, 160, 190, 177, 169, 214, 206, 203, 227, 223, 220,
    238, 237, 235, 247, 245,
  246, 251, 251, 251, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251,
    251, 254, 219, 223, 227,
  172, 177, 222, 153, 158, 230, 151, 157, 234, 149, 156, 230, 151, 157, 225,
    164, 171, 229, 187, 191,
  181, 159, 161, 149, 139, 140, 142, 138, 137, 198, 196, 197, 248, 248, 248,
    187, 187, 187, 115, 115,
  115, 198, 198, 198, 241, 241, 241, 210, 210, 210, 129, 129, 131, 146, 146,
    148, 222, 222, 222, 237,
  237, 237, 209, 207, 208, 151, 149, 150, 215, 215, 215, 232, 232, 232, 187,
    187, 187, 113, 113, 113,
  157, 157, 157, 237, 237, 237, 238, 238, 238, 187, 187, 187, 121, 121, 121,
    237, 237, 237, 249, 249,
  249, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 250,
    250, 255, 229, 228, 228,
  178, 177, 217, 153, 151, 220, 150, 148, 215, 146, 141, 222, 163, 159, 200,
    155, 152, 211, 181, 179,
  240, 222, 220, 228, 218, 217, 240, 234, 236, 255, 244, 247, 255, 232, 239,
    237, 192, 199, 205, 156,
  159, 199, 155, 154, 189, 155, 153, 234, 205, 207, 220, 188, 201, 208, 174,
    191, 219, 184, 204, 250,
  212, 227, 243, 196, 202, 210, 155, 152, 214, 147, 139, 238, 162, 149, 236,
    148, 134, 235, 144, 126,
  206, 119, 99, 236, 154, 130, 218, 138, 111, 222, 138, 110, 255, 157, 132,
    246, 140, 118, 249, 139,
  116, 249, 139, 114, 247, 141, 117, 245, 141, 116, 239, 139, 115, 245, 147,
    122, 251, 157, 132, 238,
  144, 119, 237, 143, 118, 229, 152, 132, 228, 188, 176, 243, 225, 221, 236,
    230, 232, 226, 226, 234,
  206, 205, 219, 245, 239, 253, 255, 247, 252, 242, 207, 201, 218, 155, 137,
    226, 149, 123, 225, 148,
  122, 224, 147, 121, 220, 143, 117, 231, 146, 117, 243, 143, 109, 249, 141,
    103, 249, 141, 103, 225,
  140, 111, 219, 173, 158, 205, 187, 175, 165, 154, 136, 172, 165, 147, 197,
    187, 178, 200, 187, 181,
  199, 184, 177, 168, 135, 120, 186, 119, 90, 229, 144, 107, 239, 154, 115,
    242, 158, 121, 230, 150,
  115, 219, 150, 119, 196, 146, 121, 196, 164, 149, 207, 194, 188, 207, 203,
    202, 203, 201, 202, 142,
  142, 142, 112, 114, 113, 191, 191, 191, 206, 205, 203, 207, 203, 200, 205,
    201, 198, 196, 188, 185,
  176, 165, 159, 198, 187, 181, 219, 214, 210, 233, 229, 228, 242, 240, 241,
    249, 249, 249, 254, 254,
  252, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 251, 251, 233, 197, 199, 216, 157, 161, 228, 151,
    157, 235, 148, 156, 238,
  147, 154, 231, 150, 157, 231, 170, 177, 249, 210, 213, 137, 121, 122, 177,
    173, 172, 234, 232, 233,
  203, 203, 203, 141, 141, 141, 131, 131, 131, 240, 240, 240, 242, 242, 242,
    157, 157, 157, 170, 170,
  170, 190, 190, 192, 254, 254, 255, 182, 182, 182, 133, 133, 133, 200, 198,
    199, 255, 253, 254, 196,
  196, 196, 201, 201, 201, 149, 149, 149, 207, 207, 207, 247, 247, 247, 180,
    180, 180, 99, 99, 99,
  218, 218, 218, 255, 255, 255, 212, 212, 212, 142, 142, 142, 255, 254, 255,
    255, 253, 253, 255, 251,
  251, 255, 244, 246, 239, 203, 203, 214, 160, 158, 220, 152, 149, 223, 144,
    140, 229, 151, 147, 220,
  161, 157, 199, 158, 154, 236, 210, 209, 234, 220, 219, 232, 226, 226, 249,
    243, 243, 255, 250, 250,
  246, 226, 225, 203, 173, 171, 197, 157, 157, 195, 149, 151, 239, 197, 198,
    221, 200, 199, 193, 174,
  176, 225, 195, 207, 254, 216, 231, 255, 221, 235, 220, 171, 177, 208, 149,
    145, 225, 155, 145, 240,
  161, 148, 233, 147, 130, 221, 130, 111, 226, 135, 114, 240, 154, 131, 222,
    138, 114, 197, 116, 89,
  249, 162, 135, 244, 144, 120, 250, 141, 118, 249, 139, 114, 250, 138, 114,
    250, 139, 112, 249, 139,
  112, 246, 140, 116, 242, 142, 118, 235, 141, 116, 248, 156, 131, 246, 152,
    127, 229, 147, 126, 209,
  152, 135, 217, 179, 168, 243, 218, 211, 250, 232, 228, 255, 244, 242, 255,
    238, 234, 223, 183, 173,
  211, 154, 137, 226, 150, 126, 228, 148, 123, 211, 146, 124, 213, 158, 138,
    226, 175, 158, 203, 144,
  126, 220, 143, 117, 238, 145, 112, 243, 143, 109, 207, 126, 97, 233, 199,
    187, 196, 189, 181, 174,
  176, 163, 182, 186, 172, 189, 190, 185, 189, 189, 189, 189, 189, 189, 201,
    181, 172, 161, 97, 70,
  232, 147, 110, 236, 147, 107, 236, 145, 101, 252, 156, 114, 242, 154, 114,
    224, 154, 120, 206, 152,
  124, 185, 150, 131, 202, 180, 169, 211, 198, 192, 208, 203, 199, 194, 193,
    191, 116, 118, 117, 135,
  135, 135, 204, 204, 204, 204, 204, 204, 206, 202, 199, 208, 199, 194, 189,
    178, 172, 196, 191, 187,
  205, 201, 200, 225, 223, 224, 240, 240, 240, 249, 249, 247, 252, 252, 250,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 252, 252, 255, 246,
  247, 245, 211, 212, 222, 161, 166, 230, 151, 157, 237, 147, 156, 238, 148,
    157, 231, 152, 158, 231,
  170, 175, 249, 217, 220, 228, 214, 214, 107, 103, 102, 130, 130, 130, 203,
    203, 203, 250, 250, 250,
  182, 184, 183, 122, 124, 123, 172, 172, 172, 235, 235, 235, 227, 227, 227,
    151, 151, 151, 141, 141,
  141, 209, 209, 209, 245, 245, 245, 172, 172, 172, 213, 213, 213, 200, 200,
    200, 220, 222, 221, 233,
  235, 234, 115, 115, 115, 133, 133, 133, 230, 230, 230, 246, 246, 246, 147,
    147, 147, 230, 230, 230,
  228, 226, 227, 215, 209, 209, 206, 188, 188, 255, 224, 223, 228, 172, 173,
    220, 152, 151, 220, 150,
  148, 221, 146, 143, 243, 160, 156, 220, 149, 145, 219, 181, 178, 243, 225,
    223, 228, 220, 218, 242,
  236, 236, 255, 249, 249, 255, 244, 244, 227, 193, 191, 200, 160, 158, 187,
    153, 151, 206, 174, 175,
  249, 213, 223, 239, 209, 219, 242, 230, 234, 251, 237, 237, 221, 189, 190,
    220, 174, 176, 212, 156,
  155, 213, 148, 142, 240, 162, 150, 235, 152, 136, 230, 144, 127, 215, 133,
    111, 204, 124, 99, 239,
  159, 132, 203, 121, 97, 244, 158, 133, 249, 153, 129, 245, 143, 120, 248,
    139, 116, 250, 140, 115,
  251, 139, 115, 253, 139, 115, 253, 139, 113, 251, 140, 113, 251, 140, 113,
    249, 141, 113, 247, 143,
  116, 241, 141, 115, 241, 147, 122, 247, 159, 135, 230, 148, 126, 222, 150,
    128, 217, 158, 140, 255,
  208, 194, 255, 215, 201, 219, 162, 145, 227, 149, 126, 229, 149, 124, 217,
    152, 132, 192, 145, 129,
  209, 181, 170, 222, 203, 197, 223, 206, 199, 221, 198, 192, 203, 167, 155,
    199, 144, 124, 227, 147,
  120, 217, 143, 116, 208, 166, 152, 206, 189, 181, 193, 188, 182, 190, 191,
    186, 189, 189, 187, 189,
  189, 189, 190, 189, 187, 202, 180, 169, 160, 95, 67, 235, 147, 109, 242,
    146, 104, 243, 146, 103,
  237, 144, 100, 240, 151, 109, 245, 163, 123, 229, 154, 114, 225, 156, 117,
    204, 147, 117, 193, 156,
  138, 207, 187, 178, 207, 202, 198, 204, 204, 204, 173, 173, 173, 106, 106,
    106, 164, 164, 164, 206,
  205, 203, 171, 167, 166, 127, 123, 120, 141, 140, 138, 172, 170, 171, 202,
    202, 202, 228, 228, 228,
  243, 243, 243, 252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 252, 253, 252, 248, 247, 250, 231, 233,
    243, 202, 206, 223, 162,
  167, 229, 152, 158, 235, 150, 157, 236, 149, 157, 228, 151, 157, 221, 166,
    171, 239, 204, 208, 218,
  198, 200, 217, 208, 209, 168, 166, 167, 133, 133, 133, 152, 154, 153, 210,
    212, 211, 244, 244, 244,
  175, 175, 175, 111, 111, 111, 211, 211, 211, 246, 246, 246, 203, 203, 203,
    122, 122, 122, 154, 154,
  154, 227, 227, 227, 234, 234, 234, 211, 213, 212, 148, 150, 149, 216, 216,
    216, 233, 233, 233, 184,
  184, 184, 108, 108, 108, 158, 156, 157, 240, 234, 234, 244, 230, 230, 223,
    199, 199, 190, 151, 152,
  210, 159, 158, 222, 152, 152, 219, 143, 143, 223, 158, 156, 227, 163, 161,
    222, 154, 151, 212, 154,
  152, 214, 180, 178, 237, 217, 216, 255, 242, 242, 255, 249, 249, 244, 224,
    223, 201, 173, 170, 200,
  159, 157, 197, 151, 153, 241, 200, 208, 242, 206, 218, 214, 181, 198, 217,
    190, 205, 255, 244, 248,
  255, 232, 230, 218, 175, 169, 210, 151, 143, 226, 156, 146, 234, 155, 140,
    237, 150, 131, 235, 147,
  125, 198, 112, 89, 238, 154, 128, 190, 110, 83, 221, 140, 113, 237, 151,
    126, 242, 147, 125, 247,
  142, 120, 251, 141, 118, 251, 141, 116, 252, 140, 116, 252, 140, 116, 254,
    140, 116, 253, 139, 113,
  250, 140, 115, 244, 142, 119, 237, 145, 122, 232, 147, 126, 230, 149, 128,
    229, 148, 127, 226, 142,
  118, 248, 154, 128, 245, 154, 127, 230, 150, 127, 225, 150, 127, 225, 149,
    126, 229, 149, 124, 236,
  146, 119, 225, 145, 120, 198, 151, 135, 161, 136, 129, 118, 110, 107, 200,
    200, 200, 209, 209, 209,
  212, 208, 207, 216, 205, 203, 216, 189, 180, 203, 152, 133, 204, 147, 127,
    185, 143, 127, 204, 174,
  163, 216, 193, 185, 205, 186, 179, 204, 185, 178, 204, 184, 175, 201, 177,
    167, 162, 121, 103, 187,
  114, 82, 240, 148, 107, 242, 147, 103, 234, 137, 92, 234, 141, 97, 240, 149,
    104, 233, 146, 101,
  243, 159, 113, 246, 162, 116, 230, 155, 115, 213, 156, 126, 190, 149, 129,
    194, 168, 155, 208, 193,
  186, 208, 203, 199, 203, 202, 200, 143, 143, 143, 130, 130, 130, 72, 72, 72,
    90, 90, 90, 117, 117,
  117, 151, 151, 151, 187, 187, 187, 219, 219, 219, 240, 240, 240, 250, 250,
    250, 254, 254, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 253, 253, 253, 250,
  248, 249, 241, 235, 235, 225, 211, 211, 208, 178, 180, 225, 172, 178, 225,
    154, 160, 235, 150, 157,
  238, 148, 157, 232, 151, 158, 225, 158, 165, 236, 190, 193, 239, 213, 216,
    132, 123, 124, 185, 185,
  185, 234, 234, 234, 193, 193, 193, 137, 137, 137, 144, 144, 144, 242, 242,
    242, 240, 240, 240, 151,
  151, 151, 172, 172, 172, 193, 195, 194, 251, 253, 252, 179, 179, 179, 133,
    133, 133, 198, 198, 200,
  254, 254, 255, 199, 199, 199, 196, 196, 196, 153, 153, 153, 206, 204, 205,
    252, 248, 247, 198, 182,
  182, 157, 117, 117, 216, 160, 161, 220, 154, 155, 221, 151, 151, 217, 149,
    150, 226, 166, 166, 196,
  155, 153, 225, 191, 190, 230, 199, 197, 208, 170, 169, 205, 160, 157, 217,
    167, 166, 255, 217, 214,
  232, 188, 185, 204, 160, 157, 192, 152, 150, 208, 176, 179, 251, 215, 227,
    224, 174, 201, 199, 149,
  178, 234, 196, 219, 248, 215, 226, 240, 201, 202, 208, 161, 155, 214, 150,
    141, 239, 163, 150, 240,
  152, 138, 202, 114, 92, 202, 119, 89, 202, 119, 87, 187, 104, 74, 207, 122,
    93, 224, 134, 108, 251,
  157, 132, 245, 145, 122, 247, 142, 120, 251, 141, 118, 251, 141, 116, 251,
    141, 116, 251, 141, 116,
  251, 141, 116, 252, 140, 116, 252, 141, 114, 244, 144, 120, 224, 147, 129,
    202, 146, 133, 236, 199,
  193, 222, 183, 178, 214, 158, 145, 226, 151, 130, 236, 144, 119, 243, 145,
    118, 247, 160, 133, 237,
  150, 123, 241, 146, 116, 237, 146, 117, 225, 147, 124, 206, 150, 133, 224,
    199, 192, 216, 208, 205,
  191, 190, 188, 104, 104, 104, 152, 152, 152, 212, 210, 211, 212, 208, 207,
    215, 205, 203, 218, 201,
  194, 199, 172, 163, 186, 150, 136, 192, 149, 132, 197, 145, 124, 213, 157,
    134, 225, 170, 149, 181,
  123, 99, 174, 107, 78, 206, 130, 96, 238, 150, 110, 240, 147, 104, 231, 140,
    96, 235, 144, 99, 242,
  147, 101, 243, 151, 104, 239, 152, 107, 235, 152, 108, 231, 152, 109, 241,
    164, 120, 235, 160, 120,
  227, 159, 120, 212, 152, 118, 194, 152, 128, 198, 180, 170, 192, 187, 184,
    111, 110, 108, 60, 60,
  60, 71, 71, 71, 89, 89, 89, 117, 117, 117, 152, 152, 152, 189, 189, 189,
    220, 220, 220, 241, 241,
  241, 251, 251, 251, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 254, 254, 251, 251, 251, 243, 243, 243, 226, 224,
    225, 206, 196, 197, 186,
  155, 160, 213, 164, 168, 226, 157, 162, 234, 151, 159, 240, 149, 158, 236,
    150, 159, 226, 156, 164,
  228, 179, 183, 252, 223, 225, 212, 198, 198, 115, 109, 109, 131, 129, 130,
    210, 210, 210, 250, 250,
  250, 179, 179, 179, 122, 122, 122, 170, 170, 170, 237, 237, 237, 227, 229,
    228, 148, 150, 149, 141,
  141, 141, 206, 206, 206, 247, 247, 249, 177, 177, 179, 208, 208, 208, 202,
    200, 201, 227, 218, 219,
  245, 231, 230, 166, 142, 142, 197, 159, 158, 217, 159, 158, 223, 153, 153,
    218, 146, 147, 225, 159,
  160, 214, 160, 160, 205, 166, 167, 242, 218, 218, 233, 219, 218, 227, 213,
    213, 225, 199, 200, 227,
  176, 173, 219, 155, 153, 216, 155, 150, 214, 156, 152, 206, 151, 146, 246,
    202, 201, 237, 212, 216,
  213, 187, 200, 222, 176, 204, 255, 202, 230, 255, 218, 235, 220, 175, 180,
    207, 154, 150, 224, 157,
  148, 245, 163, 152, 239, 147, 134, 245, 145, 129, 239, 143, 119, 189, 102,
    72, 242, 158, 124, 229,
  140, 110, 239, 145, 119, 247, 149, 124, 246, 144, 121, 251, 142, 121, 251,
    140, 120, 251, 142, 119,
  248, 143, 121, 240, 145, 125, 232, 145, 125, 234, 149, 129, 235, 148, 128,
    242, 146, 122, 231, 144,
  124, 219, 160, 146, 248, 213, 207, 195, 182, 189, 214, 199, 204, 255, 217,
    209, 237, 170, 153, 239,
  148, 121, 247, 143, 114, 240, 142, 113, 252, 154, 125, 255, 153, 122, 241,
    146, 116, 227, 149, 126,
  199, 143, 126, 200, 170, 160, 213, 200, 194, 214, 209, 206, 209, 208, 206,
    152, 152, 152, 105, 105,
  105, 192, 192, 192, 209, 208, 206, 178, 174, 171, 199, 186, 180, 200, 171,
    157, 190, 147, 128, 200,
  145, 124, 217, 155, 130, 224, 155, 126, 229, 153, 119, 239, 151, 113, 243,
    150, 107, 241, 146, 102,
  235, 142, 98, 235, 148, 105, 234, 152, 112, 223, 147, 111, 209, 139, 105,
    221, 157, 122, 181, 121,
  87, 183, 124, 92, 206, 143, 108, 231, 159, 119, 241, 168, 127, 228, 160,
    123, 213, 164, 134, 173,
  151, 138, 74, 69, 66, 61, 60, 58, 69, 69, 69, 86, 86, 86, 110, 110, 110,
    141, 141, 141, 175, 175, 175,
  206, 206, 206, 230, 230, 230, 245, 245, 245, 252, 252, 252, 254, 254, 254,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    252, 254, 253, 248, 250,
  249, 239, 239, 239, 225, 221, 222, 204, 194, 195, 181, 159, 161, 191, 152,
    155, 224, 165, 171, 234,
  153, 160, 240, 149, 158, 237, 150, 158, 231, 154, 160, 229, 168, 173, 248,
    207, 211, 209, 190, 192,
  215, 211, 212, 169, 167, 168, 131, 131, 131, 154, 154, 154, 211, 211, 211,
    246, 246, 246, 176, 176,
  176, 110, 110, 110, 207, 207, 207, 245, 245, 245, 209, 209, 209, 126, 126,
    126, 144, 144, 144, 224,
  224, 224, 248, 239, 240, 223, 202, 201, 199, 161, 160, 224, 166, 165, 223,
    155, 154, 222, 150, 151,
  219, 153, 154, 224, 168, 169, 196, 154, 155, 225, 199, 200, 240, 226, 226,
    226, 217, 218, 215, 209,
  209, 211, 201, 202, 222, 196, 197, 225, 174, 171, 220, 155, 151, 220, 155,
    149, 216, 155, 150, 220,
  165, 162, 239, 199, 197, 249, 230, 232, 255, 245, 250, 255, 237, 245, 245,
    200, 207, 214, 160, 160,
  205, 144, 141, 236, 169, 161, 235, 157, 147, 240, 146, 134, 247, 144, 129,
    249, 143, 127, 247, 144,
  125, 230, 134, 110, 242, 146, 121, 250, 148, 126, 249, 144, 122, 251, 142,
    121, 251, 142, 121, 253,
  142, 122, 252, 143, 122, 247, 145, 123, 235, 148, 129, 207, 145, 132, 218,
    175, 166, 244, 210, 201,
  219, 176, 167, 220, 157, 142, 218, 151, 135, 229, 177, 164, 234, 200, 199,
    155, 142, 159, 200, 188,
  202, 255, 236, 232, 236, 175, 156, 241, 147, 119, 251, 142, 109, 251, 144,
    112, 246, 143, 112, 242,
  145, 113, 253, 159, 131, 237, 150, 122, 228, 151, 125, 209, 147, 126, 195,
    153, 137, 206, 187, 181,
  211, 206, 203, 211, 210, 208, 197, 197, 197, 108, 106, 107, 158, 154, 151,
    211, 200, 194, 203, 185,
  175, 161, 135, 122, 227, 198, 184, 201, 173, 161, 187, 148, 133, 214, 152,
    127, 229, 153, 119, 234,
  146, 108, 232, 141, 97, 230, 137, 94, 236, 147, 103, 236, 155, 112, 203,
    139, 104, 220, 182, 163,
  222, 198, 186, 211, 189, 178, 202, 182, 171, 192, 172, 161, 162, 133, 117,
    159, 113, 87, 205, 152,
  121, 220, 170, 143, 193, 156, 137, 86, 73, 64, 62, 61, 59, 72, 72, 72, 90,
    90, 90, 115, 115, 115, 145,
  145, 145, 176, 176, 176, 205, 205, 205, 227, 227, 227, 242, 242, 242, 250,
    250, 250, 254, 254, 254,
  255, 255, 253, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 255, 255, 252, 254, 253, 249, 249, 249, 240, 240, 240,
    224, 224, 224, 206, 200,
  200, 185, 169, 170, 186, 151, 155, 222, 161, 168, 231, 154, 160, 240, 150,
    159, 240, 150, 159, 234,
  153, 160, 226, 164, 169, 238, 197, 203, 229, 207, 210, 127, 117, 118, 184,
    180, 179, 240, 238, 239,
  199, 199, 199, 133, 133, 133, 137, 137, 137, 238, 238, 238, 245, 245, 245,
    160, 160, 160, 169, 169,
  169, 185, 183, 184, 255, 251, 252, 205, 191, 191, 161, 135, 136, 213, 171,
    172, 215, 159, 158, 226,
  154, 155, 222, 146, 146, 229, 163, 164, 214, 159, 162, 209, 169, 170, 246,
    220, 223, 231, 221, 222,
  219, 215, 214, 211, 202, 203, 212, 200, 200, 214, 194, 195, 201, 171, 171,
    206, 157, 160, 209, 150,
  152, 252, 192, 194, 224, 166, 165, 210, 160, 159, 205, 164, 162, 244, 214,
    212, 255, 231, 228, 218,
  178, 176, 208, 155, 151, 227, 157, 149, 242, 164, 154, 228, 146, 135, 247,
    159, 149, 245, 147, 134,
  247, 144, 129, 249, 143, 127, 250, 145, 126, 247, 144, 125, 249, 144, 123,
    252, 143, 123, 253, 142,
  123, 254, 142, 122, 253, 142, 122, 249, 144, 125, 242, 147, 129, 229, 147,
    133, 204, 144, 134, 237,
  203, 201, 234, 218, 221, 227, 221, 225, 243, 229, 229, 237, 200, 192, 213,
    166, 156, 204, 160, 149,
  206, 168, 165, 253, 222, 230, 253, 218, 225, 214, 164, 155, 224, 153, 131,
    242, 147, 117, 252, 143,
  110, 252, 143, 110, 249, 144, 112, 245, 146, 115, 237, 142, 112, 251, 154,
    122, 249, 158, 129, 231,
  152, 122, 219, 154, 132, 191, 149, 133, 195, 168, 159, 212, 197, 192, 195,
    185, 183, 182, 174, 172,
  214, 205, 200, 183, 169, 160, 159, 141, 129, 236, 218, 206, 255, 241, 231,
    203, 192, 188, 205, 185,
  176, 206, 163, 146, 206, 146, 120, 226, 155, 123, 230, 150, 113, 238, 150,
    110, 240, 153, 110, 226,
  151, 111, 227, 173, 145, 207, 189, 179, 190, 188, 189, 190, 188, 189, 190,
    188, 189, 190, 188, 189,
  196, 187, 182, 190, 164, 151, 145, 114, 96, 178, 149, 133, 73, 51, 38, 69,
    62, 56, 75, 75, 73, 95, 95,
  95, 122, 122, 122, 152, 152, 152, 183, 183, 183, 210, 210, 210, 230, 230,
    230, 243, 243, 243, 250,
  250, 250, 253, 253, 253, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 253, 253, 253,
  250, 250, 250, 242, 242, 242, 230, 228, 229, 212, 206, 206, 192, 178, 178,
    182, 153, 157, 214, 165,
  169, 228, 155, 162, 238, 151, 159, 241, 152, 158, 235, 153, 159, 230, 157,
    164, 235, 182, 188, 255,
  228, 230, 205, 193, 193, 117, 113, 112, 124, 124, 124, 207, 207, 207, 252,
    252, 252, 192, 192, 194,
  122, 122, 124, 159, 159, 159, 230, 228, 229, 245, 236, 237, 170, 148, 150,
    206, 162, 163, 221, 161,
  161, 224, 156, 157, 221, 151, 153, 222, 156, 157, 226, 168, 167, 198, 156,
    158, 223, 192, 197, 245,
  220, 226, 231, 214, 220, 213, 207, 209, 210, 202, 200, 220, 199, 198, 211,
    180, 178, 203, 163, 163,
  194, 152, 154, 219, 177, 187, 251, 207, 222, 222, 175, 193, 245, 199, 212,
    234, 192, 194, 211, 163,
  159, 216, 157, 151, 222, 155, 149, 219, 150, 143, 241, 164, 156, 245, 155,
    144, 245, 147, 134, 244,
  146, 133, 237, 141, 129, 244, 152, 141, 246, 154, 141, 247, 147, 131, 250,
    145, 126, 250, 143, 125,
  253, 142, 123, 254, 143, 124, 255, 143, 123, 255, 144, 124, 250, 145, 126,
    236, 149, 132, 213, 147,
  135, 208, 167, 161, 243, 221, 223, 225, 213, 227, 225, 220, 240, 235, 232,
    249, 239, 233, 243, 244,
  232, 232, 246, 223, 217, 225, 188, 179, 210, 161, 147, 222, 152, 140, 231,
    150, 133, 239, 149, 125,
  243, 148, 120, 245, 147, 118, 244, 145, 114, 242, 141, 111, 247, 144, 113,
    249, 144, 112, 249, 145,
  110, 246, 146, 112, 240, 145, 113, 247, 162, 131, 234, 155, 125, 230, 153,
    125, 214, 150, 125, 191,
  149, 133, 188, 161, 152, 215, 196, 189, 165, 151, 142, 178, 161, 151, 250,
    236, 225, 244, 235, 230,
  187, 182, 178, 198, 194, 193, 215, 207, 204, 219, 204, 199, 213, 186, 175,
    193, 155, 136, 210, 153,
  124, 237, 155, 117, 238, 153, 112, 213, 143, 107, 236, 190, 166, 203, 186,
    178, 190, 188, 189, 189,
  188, 186, 150, 149, 147, 189, 187, 188, 192, 188, 187, 183, 174, 169, 113,
    102, 96, 65, 56, 51, 72,
  64, 61, 80, 79, 77, 100, 100, 100, 128, 128, 128, 160, 160, 160, 190, 190,
    190, 216, 216, 216, 234,
  234, 234, 245, 245, 245, 251, 251, 251, 254, 254, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 254, 255, 255, 254,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 251, 251, 251,
    245, 245, 245, 233, 233,
  233, 216, 214, 215, 197, 187, 188, 177, 152, 155, 216, 166, 169, 231, 160,
    166, 236, 154, 160, 241,
  152, 158, 241, 151, 160, 231, 154, 162, 226, 176, 179, 247, 215, 218, 196,
    177, 179, 222, 213, 214,
  179, 177, 178, 143, 143, 143, 145, 145, 147, 200, 196, 197, 255, 251, 252,
    200, 184, 184, 175, 146,
  148, 212, 170, 171, 221, 159, 160, 227, 155, 156, 220, 148, 149, 231, 165,
    167, 213, 157, 160, 211,
  166, 171, 235, 199, 211, 226, 198, 212, 207, 185, 197, 214, 197, 205, 216,
    200, 201, 214, 194, 193,
  202, 171, 169, 201, 161, 161, 201, 156, 159, 248, 205, 212, 242, 208, 222,
    187, 154, 173, 250, 212,
  233, 235, 192, 209, 255, 223, 226, 220, 165, 160, 227, 150, 142, 239, 152,
    142, 250, 163, 153, 240,
  151, 137, 248, 146, 132, 252, 144, 131, 252, 144, 131, 247, 145, 131, 239,
    145, 133, 236, 144, 131,
  255, 159, 143, 247, 147, 131, 250, 144, 128, 254, 144, 127, 254, 143, 124,
    253, 144, 124, 248, 145,
  128, 235, 148, 131, 208, 146, 135, 234, 195, 190, 237, 221, 224, 198, 196,
    210, 190, 190, 216, 119,
  120, 150, 162, 163, 184, 231, 229, 242, 247, 243, 244, 255, 249, 243, 255,
    226, 215, 226, 158, 139,
  242, 148, 122, 250, 145, 115, 253, 144, 115, 248, 143, 113, 242, 143, 114,
    231, 137, 109, 235, 141,
  115, 236, 146, 119, 236, 149, 121, 231, 147, 119, 225, 145, 118, 224, 150,
    123, 220, 150, 124, 234,
  160, 131, 247, 163, 129, 233, 152, 122, 218, 156, 133, 190, 143, 125, 170,
    133, 117, 206, 177, 163,
  255, 242, 231, 230, 217, 209, 176, 172, 169, 107, 107, 107, 169, 169, 169,
    210, 210, 210, 209, 209,
  209, 213, 208, 205, 218, 199, 192, 207, 172, 153, 208, 148, 120, 225, 156,
    123, 220, 159, 128, 202,
  158, 133, 214, 192, 179, 196, 187, 182, 191, 186, 182, 109, 105, 102, 189,
    188, 186, 178, 178, 178,
  72, 72, 72, 60, 60, 60, 69, 69, 69, 85, 85, 85, 107, 107, 107, 135, 135,
    135, 166, 166, 166, 196,
  196, 196, 220, 220, 220, 237, 237, 237, 247, 247, 247, 252, 252, 252, 254,
    254, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 254, 254,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 254, 254, 254, 252, 252, 252, 247, 247, 247, 237, 237, 237, 223, 219,
    220, 204, 194, 195, 182,
  162, 163, 191, 152, 155, 230, 168, 173, 234, 155, 160, 242, 151, 158, 243,
    152, 159, 235, 154, 161,
  231, 166, 172, 244, 202, 206, 223, 201, 203, 114, 108, 108, 160, 160, 160,
    240, 240, 240, 227, 217,
  218, 167, 141, 142, 198, 154, 155, 222, 162, 164, 227, 157, 159, 220, 150,
    152, 224, 158, 159, 223,
  169, 169, 204, 158, 161, 225, 185, 194, 232, 191, 209, 221, 172, 202, 194,
    150, 177, 224, 196, 210,
  226, 201, 204, 218, 178, 179, 205, 163, 164, 190, 156, 155, 215, 183, 188,
    255, 217, 230, 213, 179,
  195, 246, 222, 236, 253, 229, 242, 255, 229, 237, 246, 204, 208, 216, 160,
    159, 219, 152, 144, 244,
  164, 155, 239, 151, 139, 231, 143, 123, 247, 155, 132, 249, 147, 132, 252,
    144, 131, 255, 145, 130,
  252, 145, 129, 251, 145, 131, 247, 145, 130, 234, 141, 126, 248, 156, 141,
    247, 154, 137, 247, 147,
  131, 252, 145, 125, 247, 146, 128, 230, 148, 134, 215, 157, 146, 248, 217,
    212, 227, 215, 217, 220,
  214, 228, 144, 144, 168, 191, 191, 227, 148, 148, 182, 207, 208, 226, 251,
    246, 252, 255, 249, 246,
  246, 209, 200, 225, 158, 141, 240, 150, 126, 249, 145, 118, 252, 144, 115,
    252, 144, 115, 241, 137,
  108, 241, 140, 110, 238, 144, 116, 232, 150, 126, 203, 137, 115, 217, 171,
    155, 210, 177, 162, 197,
  167, 157, 161, 131, 120, 157, 119, 106, 167, 119, 99, 219, 152, 125, 242,
    165, 135, 234, 157, 127,
  229, 155, 126, 217, 151, 125, 191, 140, 119, 207, 180, 169, 189, 178, 172,
    212, 208, 207, 205, 205,
  205, 132, 132, 132, 114, 114, 114, 202, 202, 202, 210, 209, 207, 213, 208,
    205, 218, 205, 199, 215,
  193, 182, 195, 159, 143, 204, 156, 133, 199, 149, 124, 205, 167, 146, 220,
    192, 178, 201, 188, 180,
  166, 161, 157, 155, 154, 152, 57, 55, 56, 62, 62, 62, 74, 74, 74, 91, 91,
    91, 115, 115, 115, 144, 144,
  144, 174, 174, 174, 201, 201, 201, 225, 225, 225, 240, 240, 240, 249, 249,
    249, 253, 253, 253, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    253, 253, 253, 249, 249,
  249, 240, 240, 240, 227, 225, 226, 207, 203, 202, 187, 171, 172, 181, 142,
    145, 226, 167, 171, 232,
  155, 161, 242, 153, 159, 244, 151, 159, 239, 154, 161, 227, 162, 168, 236,
    191, 194, 253, 227, 228,
  220, 202, 202, 131, 111, 112, 174, 144, 144, 217, 171, 173, 220, 160, 162,
    230, 155, 159, 224, 149,
  153, 229, 167, 170, 206, 158, 158, 208, 172, 172, 229, 203, 206, 216, 193,
    203, 216, 185, 203, 234,
  184, 213, 245, 192, 218, 224, 188, 198, 204, 170, 171, 204, 160, 159, 203,
    157, 159, 245, 208, 215,
  238, 206, 217, 207, 172, 192, 246, 213, 232, 249, 221, 233, 255, 232, 237,
    221, 181, 182, 211, 157,
  155, 225, 158, 150, 246, 168, 158, 238, 151, 142, 229, 140, 126, 207, 116,
    95, 228, 134, 109, 255,
  158, 140, 252, 146, 130, 254, 144, 127, 255, 144, 127, 255, 144, 127, 252,
    145, 129, 245, 148, 132,
  238, 145, 128, 241, 148, 131, 254, 159, 141, 249, 148, 130, 244, 149, 131,
    225, 147, 134, 247, 193,
  183, 236, 211, 206, 240, 231, 234, 237, 235, 249, 188, 189, 210, 166, 165,
    196, 220, 216, 241, 255,
  249, 255, 255, 241, 238, 225, 187, 178, 214, 158, 143, 230, 153, 133, 237,
    151, 128, 240, 150, 126,
  243, 149, 123, 246, 148, 119, 247, 146, 116, 247, 144, 113, 240, 149, 122,
    199, 132, 113, 243, 200,
  184, 198, 180, 168, 175, 171, 162, 196, 192, 189, 200, 192, 190, 203, 188,
    183, 186, 156, 145, 149,
  98, 77, 221, 152, 123, 242, 158, 124, 251, 163, 127, 235, 155, 122, 224,
    159, 131, 196, 151, 132,
  190, 162, 150, 211, 194, 187, 215, 207, 204, 213, 209, 208, 185, 185, 185,
    100, 100, 100, 155, 155,
  155, 212, 212, 212, 210, 208, 209, 212, 208, 207, 216, 203, 197, 209, 177,
    162, 194, 153, 133, 198,
  160, 141, 187, 155, 140, 189, 174, 167, 112, 107, 104, 58, 57, 55, 66, 64,
    65, 78, 78, 78, 98, 98, 98,
  124, 124, 124, 154, 154, 154, 184, 184, 184, 209, 209, 209, 229, 229, 229,
    242, 242, 242, 250, 250,
  250, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 255,
    255, 253, 255, 255, 253,
  255, 255, 253, 254, 254, 254, 253, 253, 253, 250, 250, 250, 243, 243, 243,
    231, 229, 230, 214, 208,
  208, 192, 180, 182, 185, 156, 160, 209, 158, 163, 229, 158, 164, 242, 152,
    161, 246, 151, 159, 240,
  153, 161, 234, 157, 163, 237, 176, 181, 255, 201, 204, 217, 157, 159, 224,
    160, 161, 228, 157, 161,
  220, 149, 153, 227, 161, 163, 223, 168, 171, 199, 163, 165, 216, 194, 196,
    228, 214, 214, 225, 215,
  216, 213, 204, 209, 222, 203, 209, 232, 192, 203, 224, 174, 183, 211, 162,
    165, 207, 166, 164, 197,
  165, 166, 245, 214, 220, 233, 199, 215, 214, 176, 197, 212, 174, 195, 252,
    214, 229, 247, 204, 211,
  214, 164, 163, 214, 153, 150, 239, 166, 159, 243, 161, 150, 239, 151, 139,
    240, 151, 137, 242, 150,
  135, 243, 152, 134, 230, 135, 117, 233, 134, 115, 255, 156, 137, 253, 146,
    128, 254, 145, 125, 254,
  144, 127, 255, 145, 128, 253, 146, 128, 249, 146, 127, 247, 146, 126, 239,
    142, 123, 250, 159, 141,
  242, 153, 137, 239, 150, 132, 226, 153, 138, 228, 181, 171, 248, 224, 220,
    244, 235, 238, 239, 238,
  246, 247, 246, 254, 255, 250, 255, 252, 221, 216, 218, 166, 153, 230, 155,
    136, 233, 152, 131, 223,
  156, 139, 207, 148, 132, 209, 157, 143, 209, 148, 130, 236, 152, 126, 247,
    148, 117, 251, 146, 114,
  236, 149, 121, 215, 167, 153, 215, 195, 186, 176, 170, 156, 156, 158, 145,
    193, 194, 189, 196, 195,
  193, 198, 193, 190, 206, 189, 182, 178, 142, 128, 185, 127, 105, 237, 153,
    119, 240, 148, 109, 249,
  165, 129, 238, 162, 128, 231, 156, 124, 218, 157, 128, 193, 150, 131, 201,
    177, 165, 211, 202, 197,
  211, 210, 208, 208, 208, 208, 144, 144, 144, 105, 105, 105, 195, 195, 195,
    210, 208, 209, 212, 208,
  205, 216, 205, 201, 214, 197, 189, 190, 168, 157, 190, 170, 159, 116, 107,
    102, 62, 58, 57, 68, 66,
  67, 82, 82, 82, 105, 105, 105, 132, 132, 132, 163, 163, 163, 192, 192, 192,
    216, 216, 216, 234,
  234, 234, 245, 245, 245, 251, 251, 251, 254, 254, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    255, 255, 255, 254, 254,
  254, 254, 254, 252, 254, 254, 252, 254, 254, 252, 254, 254, 252, 254, 254,
    254, 254, 254, 254, 253,
  253, 253, 250, 250, 250, 244, 244, 244, 233, 233, 233, 215, 215, 217, 196,
    187, 188, 181, 152, 156,
  207, 161, 164, 231, 162, 167, 237, 156, 163, 237, 154, 162, 233, 156, 162,
    226, 160, 164, 223, 161,
  164, 226, 160, 162, 223, 157, 159, 220, 154, 156, 231, 171, 173, 205, 156,
    159, 210, 176, 177, 225,
  209, 209, 226, 220, 220, 213, 211, 212, 205, 203, 204, 207, 203, 204, 208,
    194, 194, 201, 171, 171,
  202, 162, 162, 200, 159, 157, 224, 189, 187, 205, 185, 186, 200, 183, 189,
    234, 207, 224, 242, 211,
  229, 255, 229, 246, 218, 182, 192, 203, 161, 162, 214, 163, 159, 237, 174,
    169, 228, 158, 150, 227,
  153, 142, 204, 128, 114, 220, 144, 130, 230, 154, 140, 225, 147, 135, 247,
    168, 155, 236, 153, 137,
  238, 152, 135, 240, 151, 135, 241, 149, 134, 242, 150, 135, 242, 150, 135,
    242, 150, 135, 242, 151,
  133, 238, 151, 134, 234, 153, 136, 222, 149, 134, 229, 157, 143, 240, 163,
    147, 225, 156, 141, 210,
  160, 149, 204, 174, 166, 230, 219, 217, 254, 250, 249, 254, 250, 247, 222,
    204, 200, 204, 164, 154,
  218, 159, 143, 230, 155, 136, 224, 153, 135, 201, 152, 138, 222, 189, 180,
    229, 204, 197, 218, 184,
  174, 207, 148, 130, 226, 150, 126, 237, 152, 123, 225, 153, 129, 209, 176,
    167, 205, 196, 191, 195,
  195, 185, 193, 196, 185, 192, 194, 191, 193, 195, 194, 194, 194, 194, 200,
    192, 189, 194, 169, 162,
  160, 114, 98, 229, 160, 131, 235, 156, 123, 228, 155, 123, 232, 161, 129,
    243, 170, 137, 226, 161,
  129, 215, 165, 142, 189, 157, 142, 177, 164, 156, 199, 195, 192, 209, 208,
    206, 210, 210, 210, 193,
  193, 193, 106, 106, 106, 141, 141, 141, 210, 210, 210, 209, 209, 209, 212,
    208, 205, 166, 155, 151,
  81, 70, 64, 63, 58, 55, 70, 69, 67, 86, 86, 86, 109, 109, 109, 139, 139,
    139, 170, 170, 170, 199,
  199, 199, 221, 221, 221, 237, 237, 237, 246, 246, 246, 251, 251, 251, 253,
    253, 253, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    249, 249, 249, 237, 237,
  237, 237, 237, 237, 236, 236, 236, 235, 235, 235, 235, 235, 235, 235, 235,
    235, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 232,
    232, 232, 228, 228, 228,
  221, 221, 221, 210, 208, 209, 200, 190, 191, 186, 168, 168, 207, 175, 178,
    219, 177, 179, 222, 173,
  177, 222, 173, 177, 219, 174, 177, 217, 175, 177, 213, 174, 177, 212, 173,
    176, 223, 184, 187, 200,
  168, 171, 215, 195, 196, 219, 209, 208, 219, 215, 214, 207, 205, 206, 204,
    204, 204, 205, 203, 204,
  203, 195, 193, 197, 183, 182, 198, 177, 176, 200, 176, 176, 220, 202, 202,
    224, 212, 212, 218, 212,
  212, 201, 197, 198, 203, 194, 199, 229, 216, 223, 203, 181, 184, 202, 176,
    177, 209, 181, 178, 218,
  184, 182, 216, 175, 171, 211, 166, 161, 197, 154, 145, 195, 155, 145, 222,
    179, 170, 191, 148, 139,
  233, 188, 182, 221, 174, 166, 223, 173, 164, 224, 172, 161, 224, 172, 161,
    225, 171, 161, 225, 171,
  161, 224, 170, 160, 224, 170, 160, 224, 170, 158, 223, 171, 160, 221, 171,
    160, 220, 172, 162, 218,
  171, 163, 213, 169, 160, 222, 182, 174, 213, 175, 166, 207, 176, 171, 195,
    180, 177, 223, 213, 211,
  208, 197, 193, 198, 179, 173, 210, 176, 167, 214, 174, 164, 212, 172, 162,
    195, 162, 153, 224, 205,
  199, 219, 208, 206, 217, 209, 206, 218, 207, 203, 217, 197, 190, 201, 169,
    158, 215, 169, 153, 216,
  174, 158, 183, 163, 156, 215, 207, 204, 201, 197, 194, 197, 198, 193, 197,
    197, 197, 198, 198, 198,
  197, 197, 199, 201, 195, 195, 178, 163, 158, 182, 155, 144, 218, 175, 158,
    222, 174, 152, 221, 174,
  154, 220, 175, 154, 212, 171, 151, 227, 189, 170, 216, 177, 160, 211, 179,
    166, 196, 179, 171, 178,
  171, 165, 196, 195, 193, 206, 206, 206, 208, 208, 208, 206, 206, 206, 157,
    157, 157, 135, 135, 135,
  208, 208, 208, 184, 183, 181, 107, 103, 102, 110, 106, 103, 114, 113, 111,
    123, 123, 123, 139, 139,
  139, 158, 158, 158, 181, 181, 181, 199, 199, 199, 213, 213, 213, 224, 224,
    224, 230, 230, 230, 233,
  233, 233, 234, 234, 232, 234, 234, 232, 234, 234, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 236, 234, 234, 236, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234,
    234, 234, 234, 234, 234,
  235, 235, 235, 244, 244, 244, 249, 249, 249, 251, 251, 251, 252, 252, 252,
    254, 254, 254, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 238, 238, 238, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  207, 203, 202, 212, 200, 200, 217, 198, 200, 219, 197, 199, 222, 196, 199,
    222, 196, 197, 221, 196,
  199, 218, 198, 200, 218, 198, 200, 218, 198, 200, 215, 199, 200, 207, 201,
    201, 204, 204, 204, 203,
  205, 204, 203, 205, 204, 204, 204, 204, 205, 204, 202, 209, 201, 199, 212,
    200, 200, 214, 200, 200,
  212, 200, 200, 207, 203, 202, 204, 204, 204, 203, 205, 204, 203, 205, 204,
    203, 203, 203, 207, 203,
  202, 212, 201, 199, 215, 200, 197, 215, 200, 197, 218, 198, 197, 221, 197,
    195, 221, 197, 193, 219,
  200, 194, 217, 200, 192, 219, 200, 194, 219, 198, 193, 219, 198, 195, 221,
    197, 193, 224, 196, 192,
  225, 197, 193, 224, 196, 192, 224, 196, 192, 224, 196, 192, 224, 196, 192,
    224, 196, 192, 224, 196,
  192, 225, 197, 193, 224, 197, 190, 224, 196, 192, 221, 196, 191, 218, 199,
    195, 218, 199, 195, 222,
  197, 192, 221, 197, 193, 214, 200, 197, 211, 201, 199, 212, 201, 199, 215,
    200, 195, 221, 198, 192,
  221, 198, 192, 217, 199, 195, 211, 201, 199, 207, 203, 202, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 205, 204, 202, 211, 201, 199, 219, 199, 192, 221, 198, 190, 214, 200,
    197, 210, 202, 200, 207,
  203, 202, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 206, 205,
    203, 204, 210, 202, 199,
  215, 202, 196, 219, 199, 190, 224, 197, 186, 224, 197, 186, 222, 198, 186,
    218, 200, 190, 218, 200,
  190, 225, 198, 189, 222, 198, 188, 215, 200, 193, 210, 202, 199, 205, 204,
    202, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 203, 203, 203, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 203, 203, 203, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 203,
    201, 204, 204, 202, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  203, 203, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 206, 204, 204,
  206, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 203, 203, 222,
    222, 222, 234, 234, 234,
  240, 240, 240, 247, 247, 247, 251, 251, 251, 254, 254, 254, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 237, 237, 237,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 207,
    203, 202, 208, 202, 202,
  210, 201, 202, 210, 201, 202, 210, 201, 202, 211, 201, 202, 212, 200, 202,
    200, 186, 186, 171, 157,
  157, 207, 195, 195, 207, 203, 202, 204, 204, 204, 204, 204, 206, 204, 204,
    206, 204, 204, 204, 204,
  204, 204, 205, 204, 202, 207, 203, 202, 207, 203, 202, 207, 203, 202, 205,
    203, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 207, 203, 204,
    208, 202, 202, 208, 202,
  202, 208, 202, 202, 210, 202, 200, 210, 202, 200, 208, 203, 200, 209, 204,
    201, 208, 203, 200, 210,
  202, 200, 210, 202, 200, 210, 202, 200, 211, 201, 199, 211, 201, 199, 211,
    201, 200, 211, 201, 200,
  211, 201, 200, 211, 201, 200, 211, 201, 200, 212, 202, 201, 211, 201, 200,
    211, 201, 199, 211, 201,
  200, 210, 202, 200, 208, 203, 200, 208, 203, 200, 210, 202, 200, 210, 202,
    200, 207, 203, 202, 207,
  203, 202, 207, 203, 202, 208, 203, 200, 210, 202, 200, 210, 202, 200, 208,
    203, 200, 208, 204, 203,
  205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    207, 203, 202, 210, 202,
  200, 211, 201, 199, 207, 195, 195, 173, 163, 162, 189, 184, 181, 207, 203,
    202, 205, 203, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 205, 204, 202, 207, 203, 200, 210,
    202, 199, 211, 201, 199,
  211, 201, 199, 210, 202, 199, 208, 203, 199, 208, 203, 200, 211, 201, 199,
    210, 202, 200, 208, 203,
  200, 205, 204, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 205, 203, 204, 205,
  203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 203, 203, 203,
  205, 203, 204, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 200, 200, 200, 205, 205, 205, 217, 217, 217, 233,
    233, 233, 244, 244, 244,
  252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 236, 236, 236, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 203,
  203, 203, 205, 203, 204, 205, 203, 204, 205, 204, 202, 205, 203, 204, 205,
    204, 202, 207, 203, 202,
  207, 203, 202, 114, 105, 106, 25, 15, 16, 20, 10, 9, 67, 58, 59, 207, 203,
    202, 205, 203, 204, 207,
  203, 204, 207, 203, 204, 205, 203, 204, 205, 204, 202, 205, 204, 202, 205,
    204, 202, 207, 203, 202,
  207, 203, 202, 207, 203, 202, 206, 202, 201, 205, 203, 204, 204, 204, 204,
    205, 203, 204, 205, 203,
  204, 207, 203, 204, 207, 203, 204, 207, 203, 202, 207, 203, 202, 205, 203,
    204, 205, 205, 205, 204,
  204, 204, 205, 205, 205, 204, 204, 204, 203, 203, 203, 204, 204, 204, 205,
    204, 202, 207, 203, 202,
  207, 203, 202, 207, 203, 202, 207, 203, 202, 207, 203, 204, 205, 203, 204,
    205, 203, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 205, 203, 204, 207, 203,
    204, 207, 203, 202, 207,
  203, 204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 207, 203, 202, 207,
    203, 202, 205, 204, 202,
  205, 203, 204, 205, 205, 205, 204, 204, 204, 205, 203, 204, 205, 203, 204,
    205, 203, 204, 205, 203,
  204, 205, 203, 204, 207, 203, 202, 207, 203, 202, 159, 153, 153, 41, 31, 32,
    20, 10, 9, 23, 18, 15,
  186, 182, 181, 205, 203, 204, 205, 205, 205, 205, 203, 204, 205, 204, 202,
    205, 203, 204, 207, 203,
  202, 207, 203, 202, 207, 203, 202, 205, 204, 202, 205, 203, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 206, 204, 204, 204, 205, 203, 204, 205, 204, 202, 207, 203, 204, 207,
    203, 202, 205, 203, 204,
  205, 203, 204, 207, 203, 204, 207, 203, 204, 207, 203, 204, 207, 203, 202,
    207, 203, 202, 208, 204,
  203, 205, 204, 202, 204, 202, 203, 205, 203, 204, 204, 202, 203, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 170, 170, 170,
    165, 165, 165, 186, 186,
  186, 214, 214, 214, 236, 236, 236, 249, 249, 249, 254, 254, 254, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254,
    235, 235, 235, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 205, 203, 204, 204,
    204, 204, 204, 204, 204,
  205, 203, 204, 205, 203, 204, 204, 202, 203, 207, 203, 204, 196, 187, 188,
    138, 130, 128, 106, 97,
  98, 109, 101, 99, 147, 137, 136, 131, 121, 120, 55, 45, 46, 139, 130, 131,
    74, 68, 68, 116, 110,
  110, 210, 201, 202, 210, 201, 202, 199, 189, 190, 164, 154, 155, 153, 144,
    145, 208, 202, 202, 210,
  201, 202, 167, 159, 157, 117, 107, 106, 106, 94, 94, 118, 106, 106, 175,
    165, 164, 207, 203, 202,
  205, 203, 204, 208, 204, 203, 196, 188, 186, 138, 128, 127, 105, 93, 93,
    113, 101, 101, 166, 156,
  155, 208, 202, 202, 205, 203, 204, 205, 205, 205, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 205,
  204, 202, 207, 203, 202, 190, 180, 181, 133, 123, 122, 105, 95, 94, 107, 97,
    96, 138, 128, 129, 194,
  185, 186, 207, 203, 202, 205, 203, 204, 204, 204, 204, 205, 203, 204, 207,
    203, 202, 208, 202, 202,
  209, 199, 200, 180, 170, 169, 152, 142, 143, 189, 180, 181, 209, 203, 203,
    200, 191, 192, 138, 128,
  127, 105, 95, 94, 137, 129, 127, 208, 202, 202, 205, 203, 204, 205, 203,
    204, 207, 203, 204, 206,
  200, 202, 156, 147, 148, 114, 105, 106, 104, 95, 96, 130, 122, 120, 169,
    157, 157, 40, 28, 28, 130,
  121, 122, 97, 91, 91, 74, 68, 68, 198, 197, 195, 204, 204, 204, 204, 204,
    204, 208, 202, 202, 184,
  176, 174, 137, 128, 129, 110, 100, 99, 105, 95, 94, 131, 121, 120, 182, 174,
    172, 208, 202, 202,
  205, 203, 204, 204, 204, 204, 203, 205, 204, 204, 204, 204, 207, 203, 202,
    211, 203, 201, 204, 194,
  195, 175, 165, 164, 146, 137, 138, 201, 195, 195, 208, 202, 202, 205, 196,
    197, 155, 145, 146, 115,
  105, 104, 106, 94, 94, 126, 116, 115, 184, 176, 174, 207, 203, 202, 205,
    203, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 206, 204, 204, 206, 204, 204, 204,
    204, 204, 204, 204, 204,
  202, 204, 204, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 142,
  142, 142, 127, 127, 127, 159, 159, 159, 197, 197, 197, 228, 228, 228, 246,
    246, 246, 253, 253, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 254,
  254, 254, 235, 235, 235, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    205, 203, 204, 205, 203,
  204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 205, 203, 204, 208, 202,
    202, 127, 118, 119, 30,
  20, 19, 60, 50, 49, 137, 129, 127, 142, 134, 132, 73, 61, 61, 21, 9, 9, 139,
    127, 127, 210, 201, 202,
  207, 203, 202, 207, 203, 202, 79, 73, 73, 32, 22, 21, 24, 10, 10, 23, 9, 9,
    42, 30, 30, 183, 173, 172,
  64, 56, 54, 33, 25, 23, 64, 52, 52, 40, 26, 26, 24, 8, 8, 25, 11, 11, 147,
    137, 138, 206, 200, 200,
  117, 111, 111, 31, 23, 21, 60, 50, 49, 44, 32, 32, 23, 7, 7, 24, 8, 9, 115,
    105, 106, 207, 203, 204,
  205, 203, 204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 201, 195, 195,
    97, 87, 86, 22, 12, 11,
  58, 48, 47, 119, 109, 108, 117, 107, 106, 48, 38, 37, 25, 15, 14, 106, 98,
    96, 203, 197, 197, 205,
  203, 204, 205, 203, 204, 153, 149, 148, 38, 32, 32, 21, 9, 9, 23, 9, 9, 23,
    9, 9, 148, 136, 136, 164,
  154, 155, 37, 27, 28, 21, 9, 9, 22, 8, 7, 21, 9, 9, 137, 129, 127, 207, 203,
    202, 207, 203, 204, 169,
  160, 161, 51, 41, 42, 35, 25, 26, 120, 111, 112, 146, 137, 138, 106, 96, 95,
    25, 11, 10, 80, 66, 65,
  209, 199, 198, 208, 202, 202, 207, 203, 202, 204, 203, 201, 205, 204, 202,
    179, 175, 174, 66, 58,
  56, 30, 20, 19, 95, 85, 86, 126, 116, 115, 111, 101, 100, 45, 35, 34, 21, 9,
    9, 77, 67, 66, 194, 188,
  188, 205, 203, 204, 204, 204, 204, 204, 204, 204, 115, 111, 110, 36, 28, 26,
    21, 9, 9, 23, 9, 9, 21, 9,
  9, 190, 180, 179, 142, 133, 134, 40, 31, 32, 53, 43, 44, 84, 72, 72, 54, 42,
    42, 23, 9, 8, 26, 14, 14,
  146, 138, 136, 207, 203, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 206, 204, 204,
  206, 204, 204, 204, 204, 204, 204, 204, 204, 202, 204, 204, 202, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 124, 124, 124, 103, 103, 103, 140,
    140, 140, 185, 185, 185,
  223, 223, 223, 244, 244, 244, 253, 253, 253, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 253, 253, 253, 234, 234, 234, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 207,
  203, 202, 127, 115, 115, 22, 8, 7, 56, 46, 45, 201, 195, 195, 207, 203, 202,
    207, 203, 202, 208, 199,
  200, 58, 48, 47, 25, 11, 11, 158, 146, 146, 207, 203, 202, 206, 204, 205,
    194, 190, 191, 169, 160,
  161, 42, 28, 27, 26, 8, 8, 31, 15, 15, 44, 32, 32, 135, 130, 127, 205, 201,
    198, 207, 203, 202, 203,
  194, 195, 61, 47, 47, 24, 8, 8, 39, 23, 24, 73, 61, 61, 102, 93, 94, 193,
    189, 188, 207, 203, 202, 207,
  198, 199, 91, 77, 77, 25, 9, 9, 25, 11, 11, 189, 180, 181, 204, 202, 203,
    204, 204, 204, 205, 203,
  204, 208, 202, 202, 77, 63, 63, 23, 9, 8, 82, 72, 71, 206, 200, 200, 207,
    203, 202, 207, 203, 202,
  203, 197, 197, 79, 69, 68, 23, 9, 8, 82, 68, 68, 208, 202, 202, 205, 203,
    204, 199, 197, 198, 188,
  184, 183, 99, 87, 87, 24, 8, 8, 26, 8, 8, 87, 71, 71, 53, 43, 42, 116, 107,
    108, 74, 64, 63, 21, 9, 9, 20,
  10, 9, 132, 124, 122, 207, 203, 202, 177, 171, 171, 33, 19, 19, 25, 11, 11,
    170, 164, 164, 205, 203,
  204, 205, 203, 204, 208, 202, 202, 120, 109, 107, 23, 9, 8, 95, 85, 83, 208,
    203, 200, 207, 203, 202,
  208, 204, 203, 196, 187, 188, 39, 29, 28, 21, 9, 9, 163, 153, 152, 208, 202,
    204, 207, 203, 204, 207,
  203, 204, 201, 195, 195, 56, 42, 42, 23, 9, 9, 81, 71, 70, 208, 202, 202,
    205, 203, 204, 204, 204,
  204, 195, 193, 194, 182, 176, 176, 68, 54, 54, 24, 8, 8, 26, 8, 8, 80, 66,
    66, 65, 55, 56, 171, 165,
  165, 207, 203, 202, 208, 204, 203, 210, 201, 202, 83, 71, 71, 26, 8, 8, 34,
    20, 19, 201, 195, 195,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 116, 116, 116, 92, 92, 92, 132, 132, 132, 180, 180, 180, 220, 220,
    220, 242, 242, 242,
  253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 254, 254, 234, 234, 234, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 203, 203, 196, 190,
    190, 33, 17, 17, 26, 8, 8,
  136, 126, 125, 208, 204, 203, 205, 203, 204, 205, 203, 204, 208, 202, 202,
    121, 111, 110, 24, 8, 8,
  44, 30, 29, 205, 201, 200, 204, 204, 204, 205, 203, 206, 208, 202, 204, 102,
    86, 86, 26, 8, 6, 34,
  18, 18, 186, 174, 174, 207, 203, 200, 205, 204, 202, 204, 204, 204, 207,
    203, 202, 134, 120, 120,
  26, 8, 8, 26, 8, 8, 152, 138, 138, 208, 202, 202, 205, 204, 202, 204, 204,
    204, 207, 203, 202, 169,
  157, 157, 23, 7, 7, 24, 8, 9, 152, 142, 141, 207, 203, 204, 204, 204, 204,
    207, 203, 204, 142, 133,
  134, 24, 8, 8, 34, 18, 18, 196, 187, 188, 205, 204, 202, 204, 204, 204, 204,
    204, 204, 205, 204, 202,
  194, 186, 184, 31, 15, 15, 24, 8, 8, 144, 135, 136, 206, 204, 205, 204, 204,
    204, 207, 203, 202, 184,
  172, 172, 24, 8, 8, 26, 8, 8, 73, 57, 57, 204, 194, 195, 208, 202, 202, 211,
    202, 203, 169, 161, 159,
  158, 150, 148, 208, 202, 202, 208, 202, 202, 82, 72, 71, 26, 8, 8, 76, 60,
    60, 208, 202, 202, 204,
  204, 204, 204, 204, 204, 207, 203, 202, 185, 175, 173, 23, 9, 8, 20, 9, 7,
    165, 157, 155, 207, 203,
  202, 205, 203, 204, 133, 123, 124, 21, 9, 9, 20, 8, 8, 191, 183, 181, 205,
    203, 204, 204, 204, 206,
  204, 204, 204, 208, 204, 203, 122, 108, 108, 26, 8, 8, 31, 19, 19, 211, 202,
    203, 205, 204, 202, 204,
  204, 204, 204, 204, 204, 207, 203, 202, 144, 130, 130, 26, 8, 8, 26, 8, 8,
    113, 99, 99, 208, 199, 200,
  207, 203, 202, 205, 203, 204, 205, 203, 204, 207, 203, 202, 157, 147, 146,
    27, 7, 8, 26, 8, 8, 167,
  161, 161, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 113, 113, 113, 88, 88, 88, 129, 129, 129, 179, 179, 179,
    220, 220, 220, 243,
  243, 243, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 254, 254, 234, 234, 234, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 204, 202,
    153, 145, 143, 26, 8, 8,
  27, 7, 8, 167, 159, 157, 205, 204, 202, 205, 203, 204, 205, 203, 204, 207,
    203, 202, 147, 137, 136,
  26, 8, 8, 24, 8, 8, 175, 169, 169, 204, 204, 202, 204, 204, 204, 207, 203,
    202, 108, 94, 94, 24, 8, 8,
  44, 30, 30, 210, 202, 200, 207, 203, 202, 205, 205, 205, 204, 204, 204, 207,
    203, 202, 148, 136,
  136, 24, 8, 8, 23, 7, 7, 191, 179, 179, 206, 202, 201, 204, 204, 204, 204,
    204, 204, 207, 203, 202,
  191, 179, 179, 24, 8, 8, 24, 8, 9, 148, 136, 136, 207, 203, 204, 205, 203,
    204, 208, 202, 202, 60, 50,
  49, 24, 8, 8, 91, 77, 76, 208, 202, 202, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  208, 202, 202, 87, 73, 73, 24, 8, 8, 63, 53, 52, 208, 202, 202, 204, 204,
    204, 205, 204, 202, 190,
  180, 179, 24, 8, 8, 24, 8, 8, 150, 136, 135, 208, 202, 202, 205, 204, 202,
    205, 204, 202, 205, 204,
  202, 205, 204, 202, 207, 203, 202, 210, 201, 202, 28, 16, 16, 24, 8, 8, 108,
    94, 93, 207, 203, 202,
  205, 205, 203, 204, 204, 204, 207, 203, 202, 211, 201, 200, 23, 9, 8, 24, 8,
    8, 115, 103, 103, 207,
  203, 202, 205, 203, 204, 177, 171, 171, 57, 48, 49, 100, 94, 94, 208, 204,
    203, 205, 203, 204, 204,
  204, 204, 204, 204, 204, 207, 203, 202, 129, 115, 115, 24, 8, 8, 23, 9, 9,
    210, 201, 202, 205, 204,
  202, 205, 205, 203, 204, 204, 204, 207, 203, 202, 147, 135, 135, 24, 8, 9,
    23, 9, 8, 190, 180, 179,
  207, 203, 202, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 202, 203,
    167, 158, 159, 26, 8, 8,
  26, 8, 8, 167, 158, 159, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 206, 204, 204, 206, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 112, 112, 112, 88, 88, 88, 129, 129, 129,
    178, 178, 178, 220,
  220, 220, 243, 243, 243, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 234, 234, 205, 205,
    205, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205,
    205, 204, 202, 151, 142,
  143, 26, 8, 8, 27, 7, 8, 163, 155, 153, 204, 203, 201, 205, 203, 204, 205,
    203, 204, 207, 203, 202,
  145, 135, 134, 26, 8, 8, 26, 8, 8, 172, 166, 166, 204, 204, 202, 204, 204,
    204, 208, 204, 203, 108,
  94, 94, 24, 8, 8, 42, 30, 30, 210, 202, 200, 205, 203, 204, 204, 204, 204,
    204, 204, 204, 207, 203,
  202, 148, 136, 136, 24, 8, 8, 23, 9, 8, 190, 180, 179, 207, 203, 202, 204,
    204, 204, 204, 204, 204,
  207, 203, 202, 189, 179, 178, 23, 9, 8, 24, 8, 9, 148, 136, 136, 207, 203,
    202, 205, 204, 202, 198,
  190, 188, 21, 9, 9, 24, 8, 8, 131, 117, 117, 207, 203, 202, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 207, 203, 202, 124, 110, 110, 24, 8, 8, 21, 9, 9, 198,
    190, 188, 205, 203, 204,
  205, 204, 202, 191, 181, 182, 23, 9, 9, 24, 8, 8, 148, 136, 136, 207, 203,
    202, 204, 204, 204, 204,
  204, 202, 204, 204, 202, 204, 204, 204, 205, 203, 204, 208, 202, 202, 26,
    14, 14, 24, 8, 8, 103, 89,
  88, 208, 202, 202, 203, 203, 201, 204, 204, 204, 207, 203, 202, 209, 199,
    198, 22, 8, 8, 24, 8, 8,
  113, 101, 101, 207, 203, 202, 205, 203, 204, 207, 203, 202, 207, 203, 202,
    207, 203, 202, 207, 203,
  202, 207, 203, 202, 205, 204, 202, 205, 203, 204, 201, 195, 195, 118, 104,
    104, 24, 8, 8, 23, 9, 9,
  210, 201, 202, 207, 203, 202, 204, 204, 202, 204, 204, 204, 207, 203, 202,
    148, 136, 138, 23, 9, 9,
  24, 10, 9, 189, 181, 179, 207, 203, 202, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 205, 203,
  204, 167, 158, 159, 26, 8, 8, 25, 7, 7, 167, 158, 159, 205, 203, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 206, 204, 204, 206, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 112, 112,
    112, 88, 88, 88, 129,
  129, 129, 178, 178, 178, 219, 219, 219, 243, 243, 243, 253, 253, 253, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254,
    254, 234, 234, 234, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 205, 204, 203,
    205, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 206, 205, 203, 205,
  204, 203, 203, 203, 192, 186, 186, 29, 13, 14, 26, 7, 9, 131, 121, 120, 207,
    203, 202, 205, 203, 204,
  205, 203, 204, 208, 202, 202, 117, 107, 106, 26, 8, 8, 45, 29, 29, 206, 200,
    200, 204, 204, 204, 204,
  204, 204, 207, 203, 202, 107, 93, 93, 24, 8, 8, 42, 30, 30, 210, 202, 200,
    205, 203, 204, 204, 204,
  204, 204, 204, 204, 207, 203, 202, 147, 135, 135, 24, 8, 8, 23, 9, 9, 190,
    180, 179, 207, 203, 202,
  204, 204, 204, 203, 203, 203, 207, 203, 202, 190, 180, 179, 23, 9, 8, 24, 8,
    9, 148, 136, 136, 207,
  203, 202, 207, 203, 202, 170, 160, 159, 23, 9, 9, 23, 7, 7, 148, 136, 136,
    207, 203, 202, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 203, 205, 204, 207, 203, 202, 150, 136,
    135, 24, 8, 8, 23, 9, 9,
  169, 159, 158, 205, 203, 204, 207, 203, 202, 190, 180, 181, 23, 9, 9, 24, 8,
    8, 148, 136, 136, 207,
  203, 202, 204, 204, 204, 203, 205, 202, 203, 205, 202, 204, 204, 204, 206,
    204, 205, 207, 203, 202,
  72, 62, 61, 26, 8, 8, 72, 56, 56, 208, 202, 202, 205, 203, 204, 204, 204,
    204, 207, 203, 202, 181,
  169, 169, 23, 9, 8, 23, 9, 9, 166, 156, 155, 207, 203, 202, 204, 204, 204,
    205, 203, 204, 207, 203,
  202, 208, 199, 200, 157, 147, 146, 103, 93, 92, 64, 56, 54, 36, 27, 28, 46,
    36, 35, 47, 31, 31, 26, 8,
  8, 23, 9, 9, 210, 201, 202, 207, 203, 202, 204, 204, 204, 204, 204, 204,
    207, 203, 202, 148, 136,
  138, 23, 9, 9, 23, 9, 8, 189, 181, 179, 207, 203, 202, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  205, 203, 204, 168, 159, 160, 26, 8, 8, 27, 9, 9, 167, 158, 159, 205, 203,
    204, 204, 204, 202, 204,
  204, 202, 204, 204, 204, 204, 204, 204, 203, 203, 203, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    112, 112, 112, 88, 88,
  88, 129, 129, 129, 178, 178, 178, 219, 219, 219, 243, 243, 243, 253, 253,
    253, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 254, 254, 234, 234,
  234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 205,
    204, 203, 205, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 206, 205,
  203, 205, 204, 204, 204, 204, 207, 203, 202, 120, 106, 106, 24, 8, 9, 49,
    37, 37, 198, 190, 188, 207,
  203, 202, 208, 204, 203, 200, 192, 190, 48, 38, 37, 23, 9, 9, 144, 132, 132,
    207, 203, 204, 204, 204,
  204, 204, 204, 204, 207, 203, 202, 108, 94, 94, 24, 8, 8, 42, 30, 30, 210,
    202, 200, 205, 203, 204,
  204, 204, 204, 204, 204, 204, 207, 203, 202, 148, 136, 136, 24, 8, 8, 23, 9,
    9, 190, 180, 179, 207,
  203, 204, 203, 203, 203, 204, 204, 204, 205, 204, 202, 191, 181, 180, 21,
    10, 8, 24, 8, 9, 148, 136,
  136, 207, 203, 202, 207, 203, 202, 170, 160, 159, 23, 9, 9, 24, 8, 8, 148,
    136, 136, 207, 203, 202,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 205, 204, 207, 203, 202,
    151, 137, 136, 24, 9, 6,
  23, 9, 9, 168, 158, 157, 207, 203, 204, 207, 203, 202, 190, 180, 181, 23, 9,
    9, 24, 8, 8, 148, 136,
  136, 207, 203, 202, 204, 204, 204, 203, 205, 202, 203, 205, 202, 204, 204,
    204, 204, 204, 204, 205,
  204, 202, 172, 164, 162, 31, 15, 15, 26, 10, 10, 161, 152, 153, 207, 203,
    202, 207, 203, 204, 208,
  202, 202, 104, 92, 92, 21, 9, 9, 79, 69, 68, 208, 202, 202, 205, 203, 204,
    205, 203, 204, 207, 203,
  202, 144, 135, 136, 41, 31, 30, 22, 12, 11, 88, 78, 77, 158, 150, 148, 199,
    190, 191, 212, 202, 201,
  130, 114, 114, 26, 8, 8, 23, 9, 9, 210, 202, 200, 207, 203, 204, 204, 204,
    204, 204, 204, 204, 207,
  203, 202, 148, 136, 138, 23, 9, 9, 24, 10, 9, 190, 180, 179, 206, 202, 201,
    204, 204, 204, 204, 204,
  204, 205, 205, 205, 205, 203, 204, 167, 158, 159, 26, 8, 8, 26, 8, 8, 167,
    158, 159, 205, 203, 204,
  204, 204, 202, 205, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 112,
  112, 112, 88, 88, 88, 129, 129, 129, 178, 178, 178, 219, 219, 219, 243, 243,
    243, 253, 253, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 254,
  254, 254, 234, 234, 234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 207, 203, 202, 211, 201,
    200, 80, 66, 65, 23, 11,
  11, 41, 31, 30, 98, 88, 89, 98, 88, 89, 39, 29, 28, 42, 34, 32, 144, 135,
    136, 208, 202, 204, 205,
  203, 204, 204, 204, 206, 204, 204, 204, 206, 202, 201, 108, 94, 94, 24, 8,
    8, 42, 30, 30, 210, 202,
  200, 205, 203, 204, 204, 204, 204, 204, 204, 204, 207, 203, 202, 148, 136,
    136, 24, 8, 8, 23, 9, 9,
  190, 180, 179, 207, 203, 204, 205, 203, 204, 204, 204, 204, 205, 204, 202,
    190, 180, 179, 21, 10, 8,
  24, 8, 9, 148, 136, 136, 207, 203, 202, 207, 203, 202, 197, 187, 186, 23, 9,
    9, 24, 8, 8, 127, 113,
  113, 207, 203, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 203,
    203, 207, 203, 202, 134,
  120, 119, 24, 9, 6, 23, 9, 9, 197, 187, 186, 208, 204, 205, 206, 202, 201,
    190, 180, 181, 23, 9, 9, 24,
  8, 8, 148, 136, 136, 207, 203, 202, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204,
  204, 204, 204, 205, 204, 202, 209, 203, 203, 141, 129, 129, 25, 11, 11, 26,
    14, 14, 86, 76, 75, 105,
  95, 96, 60, 50, 49, 27, 17, 16, 104, 96, 94, 200, 196, 195, 205, 203, 204,
    204, 204, 204, 207, 203,
  202, 137, 125, 125, 23, 9, 9, 28, 16, 16, 163, 155, 153, 207, 203, 202, 205,
    204, 202, 205, 203, 204,
  208, 202, 202, 129, 115, 115, 24, 8, 8, 23, 9, 9, 210, 202, 200, 207, 203,
    204, 204, 204, 204, 204,
  204, 204, 207, 203, 202, 148, 136, 138, 23, 9, 9, 23, 9, 8, 190, 180, 179,
    206, 202, 201, 206, 204,
  205, 204, 204, 204, 205, 205, 205, 205, 203, 204, 167, 158, 159, 26, 8, 8,
    25, 7, 7, 167, 158, 159,
  204, 202, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 112, 112, 112, 88, 88, 88, 129, 129, 129, 178, 178, 178, 219, 219,
    219, 243, 243, 243,
  253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 254, 254, 234, 234, 234, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 205, 205, 205, 204, 204, 204, 204, 204, 204, 204, 202, 203, 186, 182,
    181, 64, 52, 52, 75, 61,
  60, 202, 190, 190, 175, 165, 164, 146, 136, 137, 149, 139, 140, 174, 165,
    166, 208, 202, 202, 207,
  203, 204, 205, 203, 204, 204, 204, 206, 204, 204, 206, 204, 204, 204, 207,
    203, 202, 108, 94, 94,
  24, 8, 8, 42, 30, 30, 211, 202, 203, 207, 203, 204, 204, 204, 204, 204, 204,
    204, 207, 203, 202,
  148, 136, 136, 24, 8, 8, 23, 9, 9, 190, 180, 179, 207, 203, 204, 205, 203,
    204, 204, 204, 204, 207,
  203, 202, 191, 181, 180, 23, 9, 8, 24, 8, 9, 148, 136, 136, 207, 203, 202,
    205, 203, 204, 210, 201,
  202, 56, 44, 44, 24, 8, 8, 87, 73, 72, 208, 202, 202, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  205, 203, 204, 208, 202, 202, 91, 77, 76, 24, 8, 8, 59, 47, 47, 210, 201,
    202, 205, 203, 204, 207,
  203, 202, 189, 179, 180, 22, 8, 8, 24, 8, 8, 148, 136, 136, 207, 203, 202,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 206, 202, 201, 102, 94,
    92, 35, 23, 23, 181, 167,
  167, 191, 179, 179, 154, 144, 143, 147, 137, 136, 163, 155, 153, 202, 197,
    194, 207, 203, 202, 205,
  203, 204, 204, 204, 204, 204, 204, 204, 208, 202, 202, 43, 27, 27, 26, 8, 8,
    94, 82, 82, 209, 201,
  199, 205, 203, 204, 204, 204, 204, 205, 203, 204, 208, 202, 202, 129, 115,
    115, 24, 8, 8, 23, 9, 9,
  211, 201, 200, 207, 203, 204, 204, 204, 204, 204, 204, 204, 207, 203, 202,
    148, 136, 136, 24, 8, 9,
  23, 9, 8, 190, 180, 179, 207, 203, 202, 205, 203, 204, 204, 204, 204, 204,
    204, 204, 205, 203, 204,
  167, 158, 159, 27, 7, 8, 26, 8, 8, 167, 158, 159, 205, 203, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 112, 112, 112,
    88, 88, 88, 129, 129,
  129, 178, 178, 178, 219, 219, 219, 243, 243, 243, 253, 253, 253, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254,
    234, 234, 234, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 205, 203, 204, 205,
  203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 205, 203, 204,
  207, 203, 202, 85, 77, 75, 24, 8, 8, 135, 119, 119, 212, 200, 200, 210, 202,
    200, 208, 202, 202, 208,
  202, 202, 207, 203, 202, 205, 203, 204, 204, 202, 203, 204, 204, 204, 205,
    205, 205, 204, 204, 204,
  205, 203, 204, 208, 202, 202, 107, 91, 92, 26, 8, 8, 42, 28, 28, 210, 201,
    202, 207, 203, 204, 205,
  203, 206, 204, 204, 204, 207, 203, 202, 148, 134, 134, 24, 8, 8, 23, 9, 9,
    187, 177, 176, 207, 203,
  204, 204, 204, 204, 204, 204, 204, 208, 204, 203, 188, 178, 177, 23, 9, 8,
    24, 8, 8, 148, 134, 134,
  207, 203, 202, 205, 203, 204, 207, 203, 204, 144, 135, 136, 24, 8, 8, 29,
    13, 13, 191, 182, 183, 205,
  204, 202, 204, 204, 204, 204, 204, 204, 207, 203, 202, 194, 186, 184, 34,
    18, 18, 24, 8, 8, 148, 139,
  140, 207, 203, 204, 205, 203, 204, 207, 203, 202, 188, 178, 179, 23, 9, 9,
    24, 8, 8, 148, 134, 134,
  207, 203, 204, 204, 204, 206, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    207, 203, 202, 149, 139,
  138, 23, 9, 8, 70, 56, 55, 214, 200, 200, 211, 201, 200, 210, 201, 202, 208,
    202, 202, 207, 203, 202,
  205, 204, 202, 204, 204, 204, 204, 204, 204, 203, 205, 204, 204, 204, 204,
    208, 202, 202, 29, 13,
  13, 26, 8, 6, 89, 78, 76, 210, 202, 200, 206, 204, 205, 205, 203, 204, 207,
    203, 202, 203, 194, 195,
  71, 55, 56, 27, 9, 9, 24, 8, 9, 206, 196, 195, 207, 203, 204, 204, 204, 204,
    205, 205, 205, 207, 203,
  202, 148, 134, 134, 24, 8, 8, 23, 9, 8, 188, 178, 177, 207, 203, 202, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 205, 204, 202, 165, 157, 155, 27, 7, 8, 27, 7, 8, 166, 156,
    155, 205, 204, 202, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 112, 112,
  112, 88, 88, 88, 129, 129, 129, 178, 178, 178, 219, 219, 219, 243, 243, 243,
    253, 253, 253, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 254,
  254, 234, 234, 234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 205, 203, 204, 207, 203, 202, 67, 57, 56, 24, 8, 8, 28, 10,
    10, 68, 54, 53, 94, 84, 83,
  119, 109, 108, 144, 136, 134, 170, 164, 164, 196, 190, 190, 208, 202, 202,
    207, 203, 202, 207, 203,
  202, 205, 204, 202, 207, 203, 202, 208, 199, 200, 59, 45, 45, 24, 8, 8, 23,
    9, 9, 180, 170, 171, 207,
  203, 204, 205, 203, 204, 205, 203, 204, 208, 202, 202, 96, 84, 84, 24, 8, 8,
    23, 9, 9, 138, 128, 127,
  207, 203, 202, 205, 203, 204, 205, 203, 204, 207, 203, 202, 133, 123, 122,
    23, 9, 8, 24, 8, 8, 98, 84,
  84, 208, 202, 202, 206, 204, 205, 205, 203, 204, 208, 204, 203, 94, 82, 82,
    23, 9, 8, 66, 56, 55,
  191, 185, 185, 208, 204, 203, 205, 204, 202, 196, 190, 190, 69, 59, 58, 23,
    9, 8, 106, 94, 94, 209,
  203, 203, 205, 203, 204, 205, 203, 204, 207, 203, 202, 138, 128, 127, 23, 9,
    9, 24, 8, 8, 94, 82, 82,
  208, 202, 204, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    205, 204, 202, 131, 121,
  120, 23, 9, 8, 24, 8, 8, 50, 34, 34, 89, 77, 77, 112, 102, 101, 138, 128,
    127, 161, 153, 151, 187, 181,
  181, 207, 203, 202, 207, 203, 202, 205, 204, 202, 205, 203, 204, 208, 202,
    202, 89, 75, 74, 24, 9, 6,
  23, 12, 10, 144, 134, 133, 208, 202, 202, 207, 203, 202, 159, 153, 153, 51,
    42, 43, 81, 67, 67, 24,
  8, 9, 23, 9, 9, 148, 136, 136, 209, 203, 203, 186, 185, 183, 205, 203, 204,
    208, 202, 202, 98, 84,
  84, 24, 8, 8, 23, 9, 8, 136, 126, 125, 207, 203, 202, 206, 204, 205, 204,
    204, 204, 205, 203, 204,
  207, 203, 202, 117, 107, 106, 26, 8, 8, 26, 8, 8, 112, 102, 101, 207, 203,
    202, 205, 203, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    112, 112, 112, 88, 88,
  88, 129, 129, 129, 178, 178, 178, 219, 219, 219, 243, 243, 243, 253, 253,
    253, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 254, 254, 234, 234,
  234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    206, 204, 204, 206, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 203, 205, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 205, 204, 202, 151, 143, 141, 29, 13, 13, 27, 7, 8, 26, 8, 8,
    26, 8, 8, 26, 8, 8, 26, 8, 8,
  26, 8, 8, 26, 8, 8, 39, 23, 23, 82, 68, 67, 154, 144, 143, 211, 203, 201,
    99, 91, 89, 43, 33, 32, 23, 9,
  8, 23, 9, 8, 21, 9, 9, 30, 20, 19, 80, 76, 75, 205, 204, 202, 142, 136, 136,
    57, 48, 49, 21, 9, 9, 23,
  9, 8, 23, 9, 9, 23, 11, 11, 62, 56, 56, 174, 170, 169, 191, 187, 186, 60,
    54, 54, 22, 12, 11, 21, 10,
  8, 23, 9, 9, 21, 9, 9, 57, 49, 47, 124, 120, 119, 205, 203, 204, 205, 203,
    204, 208, 202, 202, 129,
  121, 119, 39, 29, 28, 30, 20, 19, 77, 67, 66, 76, 68, 66, 32, 22, 21, 43,
    33, 32, 135, 127, 125, 207,
  203, 202, 205, 203, 204, 205, 203, 204, 158, 154, 153, 62, 56, 56, 23, 11,
    11, 23, 9, 9, 23, 9, 8, 21,
  9, 9, 57, 48, 49, 127, 123, 124, 205, 203, 204, 204, 204, 204, 203, 205,
    204, 204, 204, 204, 192,
  186, 186, 47, 35, 35, 26, 8, 8, 27, 7, 6, 26, 8, 8, 26, 8, 8, 26, 8, 8, 26,
    8, 8, 26, 8, 6, 31, 15, 15, 63,
  47, 47, 126, 114, 114, 201, 195, 195, 207, 203, 202, 196, 188, 186, 79, 69,
    67, 21, 10, 8, 21, 9, 9,
  36, 24, 24, 32, 22, 23, 61, 52, 53, 170, 164, 164, 208, 199, 200, 72, 62,
    61, 21, 9, 9, 26, 14, 14, 58,
  48, 47, 64, 56, 54, 121, 115, 115, 57, 49, 47, 21, 9, 9, 23, 9, 9, 23, 9, 8,
    22, 12, 11, 64, 58, 58, 158,
  154, 153, 205, 203, 204, 141, 137, 138, 62, 53, 54, 21, 9, 9, 24, 10, 9, 23,
    9, 8, 21, 9, 9, 64, 55, 56,
  141, 137, 138, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    205, 205, 205, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 112,
  112, 112, 88, 88, 88, 129, 129, 129, 178, 178, 178, 219, 219, 219, 243, 243,
    243, 253, 253, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 254,
  254, 254, 234, 234, 234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 206,
  204, 204, 206, 204, 204, 204, 204, 204, 204, 203, 205, 204, 203, 205, 204,
    204, 204, 204, 203, 203,
  203, 204, 204, 204, 205, 203, 204, 206, 202, 201, 208, 200, 198, 113, 99,
    99, 52, 36, 37, 92, 76, 76,
  69, 53, 53, 44, 26, 26, 26, 8, 8, 26, 8, 8, 26, 8, 8, 26, 8, 8, 24, 8, 8,
    23, 9, 8, 150, 138, 138, 194,
  186, 184, 190, 182, 180, 190, 180, 179, 190, 180, 179, 190, 180, 179, 189,
    180, 181, 188, 184, 183,
  205, 204, 202, 197, 193, 192, 187, 181, 181, 189, 181, 179, 190, 180, 179,
    190, 180, 179, 189, 180,
  181, 187, 181, 181, 202, 198, 197, 205, 201, 200, 187, 181, 181, 187, 182,
    179, 189, 181, 179, 190,
  180, 179, 190, 180, 179, 189, 180, 181, 195, 191, 190, 205, 203, 204, 204,
    204, 204, 206, 205, 203,
  207, 203, 202, 207, 198, 199, 174, 165, 166, 146, 137, 138, 146, 138, 136,
    174, 165, 166, 210, 201,
  202, 207, 203, 202, 205, 204, 202, 204, 204, 204, 205, 203, 204, 200, 196,
    197, 187, 181, 181, 190,
  180, 181, 190, 180, 179, 190, 180, 179, 189, 181, 179, 187, 181, 181, 195,
    191, 190, 205, 203, 204,
  204, 204, 204, 204, 204, 204, 205, 203, 204, 208, 202, 202, 157, 147, 146,
    46, 32, 31, 90, 74, 74,
  76, 60, 60, 52, 36, 36, 31, 13, 13, 26, 8, 8, 27, 9, 7, 26, 8, 6, 26, 8, 8,
    24, 8, 9, 85, 77, 75, 207, 203,
  202, 207, 203, 202, 207, 203, 200, 184, 176, 174, 149, 139, 138, 149, 139,
    138, 184, 175, 176, 209,
  203, 205, 207, 203, 204, 207, 203, 202, 207, 203, 202, 165, 157, 155, 147,
    137, 136, 167, 159, 157,
  210, 202, 200, 196, 190, 190, 189, 181, 179, 190, 180, 181, 190, 180, 179,
    190, 180, 179, 190, 182,
  180, 187, 181, 181, 200, 196, 195, 205, 203, 204, 197, 193, 194, 189, 180,
    181, 189, 180, 181, 190,
  180, 179, 189, 181, 178, 190, 180, 179, 189, 180, 181, 198, 194, 195, 205,
    203, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 112, 112, 112, 88, 88, 88,
    129, 129, 129, 178,
  178, 178, 219, 219, 219, 243, 243, 243, 253, 253, 253, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 234, 234,
    234, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    205, 203, 204, 198, 189,
  190, 59, 49, 48, 92, 83, 84, 208, 199, 200, 208, 202, 202, 208, 202, 202,
    208, 202, 202, 206, 200,
  200, 184, 176, 174, 161, 153, 151, 125, 115, 114, 47, 36, 34, 24, 8, 8, 80,
    66, 65, 208, 202, 202,
  205, 204, 202, 205, 204, 202, 207, 203, 202, 207, 203, 202, 205, 203, 204,
    205, 203, 204, 204, 204,
  204, 205, 203, 204, 205, 203, 204, 205, 204, 202, 207, 203, 202, 207, 203,
    202, 205, 203, 204, 205,
  203, 204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 204, 202, 205,
    204, 202, 207, 203, 202,
  207, 203, 202, 208, 204, 205, 204, 202, 203, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 205, 203,
  204, 204, 202, 203, 205, 203, 204, 205, 203, 204, 205, 204, 202, 205, 203,
    204, 205, 203, 204, 205,
  203, 204, 205, 203, 204, 204, 204, 206, 204, 204, 204, 205, 203, 204, 205,
    203, 204, 207, 203, 204,
  207, 203, 202, 207, 203, 202, 204, 203, 201, 205, 203, 204, 205, 203, 204,
    203, 203, 203, 204, 204,
  204, 204, 204, 204, 207, 203, 202, 112, 102, 101, 49, 37, 37, 189, 180, 181,
    208, 202, 202, 208,
  202, 202, 208, 202, 202, 208, 202, 202, 192, 186, 186, 169, 161, 159, 138,
    128, 127, 77, 63, 63, 23,
  9, 9, 22, 12, 11, 198, 192, 192, 205, 204, 202, 205, 204, 202, 206, 205,
    203, 207, 203, 202, 207,
  203, 202, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205,
    203, 204, 205, 204, 202,
  207, 203, 202, 205, 204, 202, 205, 204, 202, 205, 203, 204, 205, 204, 202,
    207, 203, 204, 207, 203,
  202, 207, 203, 202, 205, 204, 202, 205, 203, 204, 205, 203, 204, 204, 204,
    204, 205, 203, 204, 205,
  203, 204, 205, 203, 204, 207, 203, 202, 205, 204, 202, 207, 203, 202, 205,
    203, 204, 205, 203, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 112, 112, 112, 88,
  88, 88, 129, 129, 129, 178, 178, 178, 219, 219, 219, 243, 243, 243, 253,
    253, 253, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 254, 254, 254, 234,
  234, 234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 207, 203, 202, 121, 111, 110, 20, 10, 9, 196, 190, 190, 208, 204, 205,
    204, 202, 203, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 205, 204, 202, 207, 203, 202, 208, 202,
    202, 192, 182, 181, 24,
  8, 8, 70, 56, 55, 207, 203, 202, 203, 205, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 205, 203,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 203, 203, 203, 204, 204, 206, 204, 204, 206, 203,
    205, 204, 203, 205, 204,
  204, 204, 204, 204, 204, 204, 205, 203, 204, 205, 203, 204, 204, 204, 206,
    204, 204, 206, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 205, 205, 205, 205, 203, 204, 182, 176, 176, 21, 9,
    9, 137, 125, 125, 207,
  203, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 205, 204, 202,
  207, 203, 202, 212, 200, 200, 67, 53, 53, 20, 10, 9, 192, 186, 186, 205,
    203, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 112, 112, 112, 88, 88, 88, 129, 129, 129, 178, 178, 178, 219,
    219, 219, 242, 242,
  242, 253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 254, 254, 234, 234, 234, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 203, 203,
  203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 207, 203, 202, 117, 107, 106, 21, 9,
    9, 179, 170, 171, 208,
  202, 202, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 205, 204, 202,
  208, 202, 202, 180, 170, 169, 23, 9, 9, 125, 113, 113, 207, 203, 202, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  205, 205, 205, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 206, 204, 204, 206, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 203,
  203, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 203, 203, 203,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 206, 205, 205, 207,
    205, 203, 204, 177, 171,
  171, 23, 9, 9, 120, 106, 106, 207, 203, 202, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 207, 203, 202, 210, 198, 198, 59, 45, 45,
    60, 50, 51, 208, 202,
  202, 205, 203, 204, 204, 204, 204, 205, 203, 206, 205, 203, 206, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 112, 112, 112, 88, 88, 88,
    129, 129, 129, 178,
  178, 178, 219, 219, 219, 243, 243, 243, 252, 252, 252, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 234, 234,
    234, 204, 204, 204, 204,
  204, 204, 203, 203, 203, 204, 204, 204, 203, 203, 203, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 205, 205, 205, 204, 204, 204, 204, 204, 204,
    205, 204, 202, 191, 183,
  181, 43, 33, 32, 42, 33, 34, 150, 144, 144, 205, 201, 200, 205, 204, 202,
    205, 203, 204, 205, 203,
  204, 205, 203, 204, 205, 201, 202, 154, 148, 148, 42, 33, 34, 78, 68, 69,
    208, 199, 200, 205, 203,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 203, 203, 203, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 206, 203, 203, 205, 204,
    204, 204, 203, 203, 203,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 206, 204,
  204, 206, 205, 203, 204, 207, 203, 202, 88, 78, 77, 23, 11, 11, 116, 110,
    110, 193, 192, 190, 205,
  203, 204, 205, 204, 202, 205, 203, 204, 205, 204, 202, 205, 203, 204, 179,
    175, 174, 79, 69, 70, 43,
  33, 34, 177, 171, 171, 207, 203, 202, 205, 203, 204, 204, 204, 204, 206,
    204, 207, 205, 203, 206,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 112, 112, 112,
  88, 88, 88, 129, 129, 129, 178, 178, 178, 218, 218, 218, 243, 243, 243, 253,
    253, 253, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 254, 254,
  234, 234, 234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 205, 204, 202, 197, 193, 192, 121, 115, 115, 59,
    50, 51, 34, 25, 26, 66, 58,
  56, 83, 74, 75, 83, 74, 75, 64, 55, 56, 39, 30, 31, 69, 63, 63, 149, 143,
    143, 207, 203, 202, 205,
  203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 203, 203, 203, 204,
    204, 206, 204, 204, 206,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 205, 204,
    203, 205, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 204, 204, 204, 203,
    205, 204, 203, 205, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 203, 204, 206, 202, 201,
    148, 142, 142, 78, 69,
  70, 34, 26, 24, 55, 46, 47, 81, 73, 71, 83, 74, 75, 71, 63, 61, 45, 36, 37,
    53, 47, 47, 118, 112, 112,
  197, 193, 194, 205, 203, 204, 205, 203, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 112, 112,
  112, 88, 88, 88, 129, 129, 129, 178, 178, 178, 220, 220, 220, 243, 243, 243,
    253, 253, 253, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 254,
  254, 234, 234, 234, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 204, 202, 207, 203, 202,
    208, 202, 202, 204, 195,
  196, 182, 174, 172, 167, 158, 159, 167, 158, 159, 184, 175, 176, 206, 200,
    200, 208, 202, 202, 207,
  203, 202, 205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205,
    205, 205, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 204, 202, 208,
    202, 202, 207, 201, 201,
  205, 203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 203, 205,
  204, 204, 204, 204, 204, 204, 204, 207, 203, 202, 211, 201, 199, 212, 201,
    197, 211, 201, 199, 211,
  201, 199, 211, 201, 199, 211, 202, 197, 211, 201, 199, 211, 202, 197, 212,
    202, 200, 210, 202, 199,
  205, 204, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 205, 203,
  204, 205, 203, 204, 207, 201, 201, 210, 201, 202, 192, 183, 184, 167, 158,
    159, 167, 158, 159, 177,
  168, 169, 200, 191, 192, 208, 202, 202, 207, 203, 204, 204, 202, 203, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 203, 203, 203, 113, 113, 113, 88, 88, 88, 129,
    129, 129, 178, 178,
  178, 220, 220, 220, 243, 243, 243, 253, 253, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 234, 234, 234,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 202, 204, 204, 202, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 203,
  205, 204, 203, 205, 204, 204, 204, 204, 204, 204, 204, 204, 204, 206, 204,
    204, 204, 203, 203, 203,
  204, 204, 204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 204, 202,
    205, 203, 204, 205, 203,
  204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 205,
    207, 204, 204, 206, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 208, 203, 200, 215, 200, 197, 217, 199, 197, 208, 202, 202, 205,
    203, 204, 204, 204, 204,
  204, 204, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    205, 204, 202, 212, 201,
  197, 224, 197, 188, 228, 196, 185, 227, 197, 187, 225, 197, 186, 225, 197,
    186, 225, 199, 186, 225,
  197, 186, 225, 197, 185, 225, 197, 186, 221, 198, 190, 211, 201, 199, 205,
    203, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    205, 203, 204, 204, 202,
  203, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 203, 204, 205, 203,
    204, 206, 204, 205, 205,
  203, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 205, 205, 205, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204,
    204, 204, 204, 204, 204,
  116, 116, 116, 92, 92, 92, 132, 132, 132, 180, 180, 180, 221, 221, 221, 243,
    243, 243, 253, 253,
  253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  254, 254, 254, 248, 248, 248, 232, 232, 232, 199, 199, 199, 155, 155, 155,
    114, 114, 114, 86, 86,
  86, 74, 74, 74, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 68, 70, 70, 68, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 69,
    71, 70, 69, 71, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 72, 70, 70, 72, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 72, 71, 71, 73,
  70, 70, 70, 70, 70, 70, 71, 71, 71, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 74, 69, 66, 160, 142, 138, 192,
    174, 170, 154, 149, 146,
  205, 203, 204, 197, 197, 195, 183, 183, 181, 203, 203, 203, 203, 203, 203,
    203, 203, 203, 204, 203,
  201, 207, 202, 199, 140, 121, 114, 213, 170, 154, 231, 176, 156, 223, 172,
    153, 203, 154, 137, 221,
  174, 156, 245, 200, 181, 242, 197, 178, 227, 182, 163, 226, 181, 160, 213,
    174, 157, 185, 158, 149,
  204, 189, 184, 221, 213, 210, 221, 220, 218, 220, 220, 220, 192, 192, 192,
    90, 90, 90, 171, 171,
  171, 222, 222, 222, 218, 218, 218, 219, 219, 221, 165, 165, 167, 55, 55, 57,
    58, 58, 60, 63, 63, 63,
  66, 66, 66, 68, 68, 68, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
    71, 71, 71, 81, 81, 81, 102,
  102, 102, 139, 139, 139, 185, 185, 185, 223, 223, 223, 243, 243, 243, 252,
    252, 252, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 254, 254, 254, 249,
  249, 249, 235, 235, 235, 208, 208, 208, 171, 171, 171, 136, 136, 136, 113,
    113, 113, 104, 104, 104,
  101, 101, 101, 100, 100, 100, 100, 100, 100, 99, 99, 99, 100, 100, 100, 100,
    100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 101, 99, 100, 101, 99,
    100, 100, 100, 98, 100,
  100, 98, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 99, 101, 100,
    99, 101, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 101, 100, 98, 101, 96, 93, 131,
    126, 123, 147, 146,
  144, 205, 205, 205, 204, 204, 204, 204, 204, 204, 204, 204, 204, 203, 203,
    203, 204, 204, 204, 206,
  202, 201, 208, 199, 194, 143, 113, 103, 230, 169, 148, 246, 170, 144, 247,
    173, 148, 244, 172, 147,
  221, 154, 127, 229, 163, 137, 250, 189, 161, 255, 200, 172, 241, 180, 151,
    237, 180, 151, 230, 178,
  154, 197, 159, 140, 195, 177, 167, 214, 209, 205, 220, 219, 217, 220, 220,
    220, 212, 212, 212, 117,
  117, 117, 126, 126, 126, 200, 200, 200, 110, 110, 110, 57, 57, 57, 63, 65,
    64, 72, 74, 73, 83, 83, 83,
  91, 91, 91, 97, 97, 97, 99, 99, 99, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 100,
  100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
    100, 100, 100, 100, 103,
  103, 103, 109, 109, 109, 127, 127, 127, 159, 159, 159, 197, 197, 197, 228,
    228, 228, 246, 246, 246,
  253, 253, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 254, 254, 251, 251, 251, 241, 241, 241, 222, 222, 222, 196,
    196, 196, 171, 171, 171,
  155, 155, 155, 148, 148, 148, 146, 146, 146, 146, 146, 146, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 146, 144, 145, 146,
  144, 145, 145, 145, 143, 145, 145, 143, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 144, 146,
  145, 144, 146, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 144, 143,
  141, 138, 137, 135, 137, 137, 137, 182, 182, 182, 205, 205, 205, 205, 203,
    204, 207, 203, 202, 207,
  203, 202, 209, 201, 199, 214, 201, 195, 188, 161, 152, 164, 118, 102, 244,
    172, 148, 254, 171, 141,
  250, 169, 140, 248, 169, 139, 252, 173, 143, 234, 159, 127, 228, 157, 125,
    250, 181, 148, 255, 202,
  169, 253, 187, 153, 245, 181, 146, 236, 182, 154, 204, 169, 149, 187, 168,
    154, 211, 200, 194, 221,
  216, 213, 221, 220, 218, 219, 219, 219, 149, 149, 149, 79, 79, 79, 58, 58,
    58, 68, 68, 68, 81, 83, 82,
  99, 101, 100, 118, 118, 118, 133, 133, 133, 141, 141, 141, 144, 144, 144,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145, 145,
    145, 145, 145, 145, 145,
  145, 145, 145, 145, 146, 146, 146, 147, 147, 147, 152, 152, 152, 165, 165,
    165, 187, 187, 187, 214,
  214, 214, 236, 236, 236, 249, 249, 249, 254, 254, 254, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 253,
    253, 248, 248, 248, 237,
  237, 237, 222, 222, 222, 208, 208, 208, 199, 199, 199, 195, 195, 195, 194,
    194, 194, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  192, 194, 193, 192, 194, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  195, 193, 193, 193, 193, 193, 193, 193, 193, 191, 193, 193, 191, 193, 193,
    191, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 191, 191, 191, 185, 185, 185, 173, 173, 173,
    154, 154, 154, 184, 182,
  183, 212, 208, 207, 213, 203, 202, 213, 199, 196, 208, 188, 181, 176, 144,
    133, 159, 108, 89, 234,
  168, 144, 247, 173, 148, 247, 170, 142, 238, 162, 136, 240, 165, 136, 248,
    172, 140, 252, 176, 142,
  244, 169, 137, 226, 153, 120, 246, 175, 143, 255, 200, 166, 255, 196, 161,
    243, 183, 149, 241, 185,
  152, 224, 178, 152, 187, 160, 143, 204, 190, 181, 218, 213, 210, 171, 171,
    171, 76, 76, 76, 61, 61,
  61, 71, 71, 71, 89, 89, 89, 112, 112, 112, 138, 138, 138, 162, 162, 162,
    179, 179, 179, 188, 188,
  188, 193, 193, 193, 193, 193, 191, 193, 193, 191, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 193, 193,
  193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 194, 194,
    194, 195, 195, 195, 198,
  198, 198, 205, 205, 205, 217, 217, 217, 232, 232, 232, 244, 244, 244, 252,
    252, 252, 254, 254, 254,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 254, 254, 252, 252, 252, 247, 247, 247, 242, 242, 242, 236,
    236, 236, 232, 232, 232,
  230, 230, 230, 230, 230, 230, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 228, 230, 229, 228, 230, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 231, 229, 229, 229, 229, 229,
    229, 229, 229, 227, 229,
  229, 227, 229, 229, 227, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 223, 223,
  223, 213, 213, 213, 197, 197, 197, 174, 172, 173, 149, 143, 143, 168, 154,
    151, 164, 141, 135, 163,
  129, 117, 195, 146, 129, 242, 176, 152, 249, 173, 147, 245, 169, 143, 235,
    161, 134, 240, 168, 143,
  245, 175, 149, 246, 179, 150, 245, 179, 147, 245, 180, 150, 244, 179, 149,
    223, 158, 128, 236, 171,
  139, 255, 194, 159, 255, 205, 168, 250, 186, 148, 241, 187, 153, 224, 189,
    167, 184, 166, 154, 154,
  146, 143, 56, 56, 56, 63, 63, 63, 75, 75, 75, 94, 94, 94, 120, 120, 120,
    150, 150, 150, 179, 179, 179,
  203, 203, 203, 218, 218, 218, 226, 226, 226, 229, 229, 229, 229, 229, 227,
    229, 229, 227, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229, 229,
    229, 229, 229, 229, 229,
  229, 230, 230, 230, 230, 230, 230, 231, 231, 231, 234, 234, 234, 239, 239,
    239, 246, 246, 246, 251,
  251, 251, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 254,
    254, 253, 253, 253, 251,
  251, 251, 250, 250, 250, 249, 249, 249, 249, 249, 249, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 250, 248,
    248, 248, 248, 248, 248,
  248, 248, 246, 249, 247, 248, 249, 247, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 249, 247, 248, 249, 247, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 246, 246, 246, 244, 244, 244, 238, 238, 238, 227, 227, 227,
    209, 209, 209, 187, 182,
  179, 188, 173, 168, 215, 185, 175, 232, 181, 162, 242, 177, 155, 247, 175,
    151, 244, 170, 145, 243,
  167, 141, 242, 168, 141, 245, 178, 151, 240, 180, 154, 221, 171, 148, 207,
    162, 141, 192, 149, 130,
  203, 157, 134, 231, 179, 155, 227, 167, 139, 230, 165, 133, 252, 188, 152,
    255, 210, 172, 245, 196,
  163, 228, 196, 173, 160, 142, 128, 63, 55, 52, 65, 65, 65, 78, 78, 78, 99,
    99, 99, 127, 127, 127, 158,
  158, 158, 188, 188, 188, 213, 213, 213, 231, 231, 231, 241, 241, 241, 246,
    246, 246, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
    248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 249, 249, 249, 249, 249, 249,
    249, 249, 249, 249, 249,
  249, 250, 250, 250, 252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 255, 254, 254, 254, 254, 254, 252, 254, 254, 252, 255, 253, 254, 255,
    253, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 253, 254, 255, 253, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 253,
    253, 253, 250, 250, 250,
  245, 245, 245, 233, 233, 233, 218, 214, 213, 198, 187, 183, 192, 165, 156,
    227, 181, 165, 232, 174,
  152, 231, 165, 141, 238, 168, 143, 246, 175, 147, 246, 180, 154, 217, 162,
    141, 218, 175, 158, 234,
  202, 189, 239, 212, 201, 209, 185, 173, 184, 156, 144, 157, 121, 105, 167,
    122, 101, 231, 175, 148,
  218, 163, 132, 235, 188, 158, 240, 204, 178, 122, 96, 79, 69, 55, 46, 71,
    66, 63, 82, 82, 82, 104,
  104, 104, 133, 133, 133, 165, 165, 165, 195, 195, 195, 219, 219, 219, 237,
    237, 237, 246, 246, 246,
  251, 251, 251, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 255, 255,
  255, 255, 255, 255, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 253, 255, 255, 253,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 254, 254, 252, 252, 252, 247, 247, 247,
    238, 236, 237, 224, 220,
  219, 205, 196, 191, 182, 163, 156, 213, 181, 166, 228, 177, 156, 239, 177,
    152, 246, 181, 153, 214,
  160, 136, 230, 200, 189, 224, 209, 204, 211, 200, 196, 210, 200, 198, 209,
    201, 198, 210, 200, 198,
  210, 199, 193, 184, 164, 153, 146, 109, 90, 227, 189, 168, 198, 171, 154,
    88, 70, 58, 68, 57, 51, 74,
  69, 66, 87, 85, 86, 110, 110, 112, 139, 139, 139, 171, 171, 171, 201, 201,
    201, 224, 224, 224, 240,
  240, 240, 248, 248, 248, 252, 254, 253, 254, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 253, 255, 255, 253, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  252, 252, 252, 249, 249, 249, 240, 240, 240, 226, 225, 223, 205, 201, 198,
    183, 168, 161, 194, 161,
  146, 237, 192, 171, 235, 185, 162, 185, 147, 128, 229, 214, 209, 204, 202,
    203, 203, 203, 203, 203,
  203, 203, 203, 203, 203, 203, 203, 203, 203, 203, 203, 208, 200, 197, 159,
    137, 126, 156, 132, 120,
  76, 61, 54, 67, 59, 56, 74, 73, 71, 92, 92, 94, 116, 116, 118, 146, 146,
    148, 178, 178, 178, 206,
  206, 206, 228, 228, 228, 241, 241, 241, 250, 250, 250, 253, 253, 253, 254,
    255, 255, 254, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 254, 254, 254, 255, 255, 255, 253, 255, 254, 252, 254, 253,
    249, 250, 252, 242, 242,
  242, 229, 228, 226, 210, 205, 202, 185, 174, 168, 178, 160, 150, 213, 187,
    174, 169, 147, 134, 213,
  205, 202, 204, 204, 204, 204, 203, 201, 190, 189, 187, 187, 186, 184, 204,
    203, 201, 204, 203, 201,
  208, 204, 201, 113, 104, 99, 65, 56, 51, 69, 64, 61, 79, 78, 76, 98, 98, 98,
    124, 124, 124, 154, 154,
  154, 186, 186, 186, 210, 211, 213, 230, 231, 233, 244, 244, 244, 250, 250,
    250, 254, 254, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 254, 255, 255,
  254, 255, 255, 253, 254, 255, 250, 251, 253, 244, 244, 244, 232, 232, 232,
    211, 210, 208, 187, 182,
  179, 169, 158, 152, 136, 125, 119, 211, 207, 204, 204, 204, 204, 205, 204,
    202, 152, 151, 149, 153,
  152, 150, 205, 204, 202, 192, 191, 189, 73, 72, 70, 60, 59, 57, 69, 68, 66,
    83, 83, 83, 105, 105, 105,
  132, 132, 132, 163, 163, 163, 192, 192, 192, 217, 217, 217, 235, 236, 238,
    245, 246, 248, 252, 252,
  252, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254,
    254, 254, 251, 251, 251,
  245, 245, 245, 235, 233, 234, 217, 216, 214, 194, 190, 187, 166, 162, 159,
    167, 166, 164, 206, 206,
  206, 204, 204, 204, 183, 183, 183, 177, 177, 177, 158, 158, 158, 70, 70, 70,
    62, 62, 62, 72, 72, 72,
  90, 90, 90, 113, 113, 113, 143, 143, 143, 172, 172, 172, 200, 200, 200, 222,
    222, 222, 238, 238,
  238, 248, 248, 248, 252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 254, 254, 254, 252, 252, 252, 249, 247, 248,
    239, 237, 238, 222, 222,
  222, 201, 201, 201, 176, 176, 176, 168, 168, 168, 202, 202, 202, 206, 206,
    206, 144, 144, 144, 68,
  68, 68, 68, 68, 68, 78, 78, 78, 96, 96, 96, 122, 122, 122, 151, 151, 151,
    181, 181, 181, 208, 208,
  208, 228, 228, 228, 242, 242, 242, 249, 249, 249, 253, 253, 253, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 253,
  255, 255, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 253, 253, 253, 249, 249, 249, 242, 242, 242, 229, 229, 229, 211, 211,
    211, 189, 189, 189, 166,
  166, 166, 156, 156, 156, 104, 104, 104, 90, 90, 90, 91, 91, 91, 107, 107,
    107, 131, 131, 131, 162,
  162, 162, 190, 190, 190, 215, 215, 215, 233, 233, 233, 244, 244, 244, 250,
    250, 250, 254, 254, 254,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 254, 254, 254, 255, 255, 255, 255, 255, 253, 255, 255, 253, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 251, 251, 251,
  244, 244, 244, 235, 235, 235, 219, 219, 219, 196, 196, 196, 168, 168, 168,
    141, 141, 141, 126, 126,
  126, 127, 127, 127, 144, 144, 144, 171, 171, 171, 197, 197, 197, 221, 221,
    221, 237, 237, 237, 247,
  247, 247, 252, 252, 252, 254, 254, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 254, 254,
  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 253, 254, 255, 253, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 254, 254, 254, 252, 252, 252, 248,
    248, 248, 239, 239, 239,
  224, 224, 224, 205, 205, 205, 183, 183, 183, 170, 170, 170, 172, 172, 172,
    186, 186, 186, 208, 208,
  208, 227, 227, 227, 241, 241, 241, 249, 249, 249, 253, 253, 253, 255, 255,
    255, 255, 255, 255, 254,
  254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    254, 255, 253, 253, 255,
  252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 254, 254, 254, 251, 251, 251, 243, 243, 243, 231,
    231, 231, 218, 218, 218,
  212, 212, 212, 212, 212, 212, 221, 221, 221, 233, 233, 233, 244, 244, 244,
    250, 250, 250, 254, 254,
  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  254, 255, 255, 254, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 251, 251, 251, 247, 247, 247, 241, 241, 241, 237, 237, 237, 237,
    237, 237, 242, 242, 242,
  248, 248, 248, 252, 252, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255, 255, 254,
    255, 255, 254, 255, 255,
  254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 253,
    253, 253, 253, 253, 252,
  252, 252, 251, 251, 251, 251, 251, 251, 252, 252, 252, 253, 253, 253, 254,
    254, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 255,
    255, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 254, 255, 255, 254, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 253, 255, 255, 253, 254, 255, 255,
    254, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
    255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
};

static Fl_RGB_Image image_gmorgan_logo (idata_gmorgan_logo, 197, 111, 3, 0);

SPLASH::SPLASH ()
{
  Fl::visual (FL_DOUBLE | FL_INDEX);
  Fl::visual (FL_RGB);
  int posx, posy;
  posx = (Fl::w () / 2) - 134;
  posy = (Fl::h () / 2) - 152;
  make_splash ();
  splashwin->position (posx, posy);
  splash = 1;
  splashcounter = 0;
}

Fl_Double_Window *
SPLASH::make_splash ()
{
  {
    splashwin = new Fl_Double_Window (265, 310);
    splashwin->callback ((Fl_Callback *) cb_splashwin, (void *) (this));
    splashwin->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    {
      Fl_Button *o = new Fl_Button (0, 0, 265, 310);
      o->box (FL_NO_BOX);
      o->image (image_gmorgan_logo);
      o->callback ((Fl_Callback *) cb_);
      o->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      Fl_Box *o = new Fl_Box (205, 235, 45, 15, gettext ("v0.79"));
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (10);
      o->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (0, 250, 265, 10,
		    gettext ("Modifications by : Robert Vogel (10/2016)"));
      o->color ((Fl_Color) 48);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (9);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (0, 270, 270, 10,
		    gettext
		    ("Copyright (c) 2003-2004 Josep Andreu (Holborn)"));
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (9);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (0, 280, 265, 10,
		    gettext ("Graphic Designer : Guy Daniel CLOTILDE"));
      o->color ((Fl_Color) 48);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (9);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (5, 10, 255, 10, gettext ("License: Latest GNU GPL version"));
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (9);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (0, 290, 265, 10, gettext ("Documentation: Gilles Maire"));
      o->color ((Fl_Color) 48);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (9);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    splashwin->clear_border ();
    splashwin->end ();
  }				// Fl_Double_Window* splashwin
  return splashwin;
}


int
GMORGAN::GetDrumNote (int R, int C)
{
	int DrumNote = 0;
	DrumNote = Edr[R][C];
	return DrumNote;
}
// note if return from SetDrumNote is not zero, then it failed.
int
GMORGAN::SetDrumNote  (int R, int C, int DNvalue)
{
	Edr[R][C] = DNvalue; 
}

void
GMORGAN::cb_gmorganwin_i (Fl_Double_Window * o, void *)
{
  Pexitprogram = 1;
  o->hide ();
  exit (0);
}

void
GMORGAN::cb_gmorganwin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_gmorganwin_i (o, v);
}

void
GMORGAN::cb_MFile_i (Fl_Menu_ *, void *)
{
  Fl::focus (PANICO);
}

void
GMORGAN::cb_MFile (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFile_i (o, v);
}

void
GMORGAN::cb_MFilesub1_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
// changed the file extension because gmo seemed to 
// confuse autotools.
  filename = fl_file_chooser (gettext ("Load Sounds:"), "(*.gmox)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmox");
  gmo->prime = 1;
  gmo->ulti = 100;
  gmo->loadfile (filename);
  metebank ();
  PutCombi (gmo->ss);
}

void
GMORGAN::cb_MFilesub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub1_i (o, v);
}

void
GMORGAN::cb_MFilesub2_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmox"
  filename =
    fl_file_chooser (gettext ("Save Sounds:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->prime = 1;
  gmo->ulti = 100;
// expand gmo->savefile(filename);
  gmo->savesoundfile (gmo->ss, filename);
}

void
GMORGAN::cb_MFilesub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub2_i (o, v);
}

void
GMORGAN::cb_MFilesub3_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename =
    fl_file_chooser (gettext ("Load one Sound:"), "(*.gmos)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmos");
  gmo->prime = gmo->ss;
  gmo->ulti = gmo->ss;
  gmo->loadsound (filename);
  metebank ();
  PutCombi (gmo->ss);
}

void
GMORGAN::cb_MFilesub3 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub3_i (o, v);
}

void
GMORGAN::cb_MFilesub4_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmos"
  filename =
    fl_file_chooser (gettext ("Save one Sound:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->prime = gmo->ss;
  gmo->ulti = gmo->ss;
  gmo->savesoundfile (gmo->ss, filename);
}

void
GMORGAN::cb_MFilesub4 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub4_i (o, v);
}

void
GMORGAN::cb_MFilesub5_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename = fl_file_chooser (gettext ("Load Patterns:"), "(*.gmp)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmp");
  gmo->prime = 1;
  gmo->ulti = 500;
  gmo->loadpatt (filename);
  LeePatterns ();
}

void
GMORGAN::cb_MFilesub5 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub5_i (o, v);
}

void
GMORGAN::cb_MFilesub6_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmp"
  filename =
    fl_file_chooser (gettext ("Save Patterns:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->prime = 1;
  gmo->ulti = 500;
  gmo->savepatt (filename);
  metemixerpat ();
}

void
GMORGAN::cb_MFilesub6 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub6_i (o, v);
}

void
GMORGAN::cb_MFilesub7_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename =
    fl_file_chooser (gettext ("Load one Pattern:"), "(*.gmps)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmps");
  gmo->prime = gmo->sp;
  gmo->ulti = gmo->sp + 1;
  gmo->loadpatt (filename);
  LeePatterns ();
}

void
GMORGAN::cb_MFilesub7 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub7_i (o, v);
}

void
GMORGAN::cb_MFilesub8_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmps"
  filename =
    fl_file_chooser (gettext ("Save one Pattern:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->prime = gmo->sp;
  gmo->ulti = gmo->sp + 1;
  gmo->savepatt (filename);
  metemixerpat ();
}

void
GMORGAN::cb_MFilesub8 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub8_i (o, v);
}

void
GMORGAN::cb_MFilesub9_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename = fl_file_chooser (gettext ("Load Styles:"), "(*.gms)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gms");
  gmo->prime = 1;
  gmo->ulti = 100;
  gmo->loadstyl (filename);
  LeeStyles ();
  PutStyle (gmo->st);
}

void
GMORGAN::cb_MFilesub9 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub9_i (o, v);
}

void
GMORGAN::cb_MFilesub10_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gms"
  filename =
    fl_file_chooser (gettext ("Save Styles:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->prime = 1;
  gmo->ulti = 100;
  gmo->savestyl (filename);
}

void
GMORGAN::cb_MFilesub10 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub10_i (o, v);
}

void
GMORGAN::cb_MFilesub11_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename =
    fl_file_chooser (gettext ("Load one Style:"), "(*.gmss)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmss");
  gmo->prime = gmo->st;
  gmo->ulti = gmo->st;
  gmo->loadstyl (filename);
  LeeStyles ();
  PutStyle (gmo->st);
}

void
GMORGAN::cb_MFilesub11 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub11_i (o, v);
}

void
GMORGAN::cb_MFilesub12_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmss"
  filename =
    fl_file_chooser (gettext ("Save one Style:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->prime = gmo->st;
  gmo->ulti = gmo->st;
  gmo->savestyl (filename);
}

void
GMORGAN::cb_MFilesub12 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub12_i (o, v);
}

void
GMORGAN::cb_MFilesub13_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename = fl_file_chooser (gettext ("Load Song:"), "(*.play)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".play");
  gmo->prime = gmo->st;
  gmo->ulti = gmo->st;
  gmo->loadsongplay (filename);
}

void
GMORGAN::cb_MFilesub13 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub13_i (o, v);
}

void
GMORGAN::cb_MFilesub14_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".play"
  filename = fl_file_chooser (gettext ("Save Song:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->savesongplay (filename);
}

void
GMORGAN::cb_MFilesub14 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub14_i (o, v);
}

void
GMORGAN::cb_MFilesub15_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".mid"
  filename =
    fl_file_chooser (gettext ("Save MIDI file:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->saveMidiFile2 (filename);
}

void
GMORGAN::cb_MFilesub15 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub15_i (o, v);
}

void
GMORGAN::cb_MFilesub16_i (Fl_Menu_ * o, void *)
{
  Pexitprogram = 1;
  o->hide ();
  exit (0);
}

void
GMORGAN::cb_MFilesub16 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MFilesub16_i (o, v);
}

void
GMORGAN::cb_EditWinssub1_i (Fl_Menu_ *, void *)
{
  int lastblackn;
  lastblackn = gmo->Rt[gmo->sp].blackn;
  gmo->sp = (int) PtBro->value ();
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  EditPattern (PtBro->value ());
  gmo->Ending = gmo->Var1 = gmo->Var2 = gmo->Fill1 = gmo->Fill2 = gmo->Intro =
    gmo->sp;
}

void
GMORGAN::cb_EditWinssub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EditWinssub1_i (o, v);
}

void
GMORGAN::cb_EditWinssub2_i (Fl_Menu_ *, void *)
{
  if (gmo->dredit)
    return;
  gmo->sp = (int) PtBro->value ();
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  gmo->PonDrumTemp (gmo->sp);
  gmo->dredit = 1;
  make_window_drum ();
  make_drum_edit ();
}

void
GMORGAN::cb_EditWinssub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EditWinssub2_i (o, v);
}

void
GMORGAN::cb_EditWinssub3_i (Fl_Menu_ *, void *)
{
  if (gmo->ctrledit)
    return;
  gmo->sp = (int) PtBro->value ();
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  gmo->ctrledit = 1;
  make_ctrl_window ();
  make_ctrl_edit ();
}

void
GMORGAN::cb_EditWinssub3 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EditWinssub3_i (o, v);
}

void
GMORGAN::cb_EditWinssub4_i (Fl_Menu_ *, void *)
{
  gmo->st = (int) StBro->value ();
  PutStyle (gmo->st);
  EditStyle (StBro->value ());
}

void
GMORGAN::cb_EditWinssub4 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EditWinssub4_i (o, v);
}

void
GMORGAN::cb_EditWinssub5_i (Fl_Menu_ *, void *)
{
  if (strcmp (gmo->Rt[gmo->sp].Nom, "Empty") != 0)
    {
      fl_message (gettext ("Please, select an Empty pattern"));
      return;
    }

  WinMidiImport->hide ();
  PreparaMidiImport ();
  WinMidiImport->position (20, 20);
  WinMidiImport->show ();
}

void
GMORGAN::cb_EditWinssub5 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EditWinssub5_i (o, v);
}

void
GMORGAN::cb_EditWinssub6_i (Fl_Menu_ *, void *)
{
  if (gmo->veloW == 0)
    {
      gmo->veloW = 1;
      make_velo ();
    };
}

void
GMORGAN::cb_EditWinssub6 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EditWinssub6_i (o, v);
}

void
GMORGAN::cb_MBank_i (Fl_Menu_ *, void *)
{
  BankWin->hide ();
  BankWin->position (1, 1);
  BankWin->show ();
  BankBro->select (gmo->ss);
  Fl::focus (CloBank);
}

void
GMORGAN::cb_MBank (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MBank_i (o, v);
}

void
GMORGAN::cb_BPlay_i (Fl_Menu_ *, void *)
{
  if ((gmo->BPW == 0) && (gmo->stst != 1))
    {
      gmo->BPW = 1;
      make_bp ();
      Fl::focus (StartStopB);
    };
}

void
GMORGAN::cb_BPlay (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPlay_i (o, v);
}

void
GMORGAN::cb_MenuUtilssub1_i (Fl_Menu_ *, void *)
{
  gmo->KeybON = 1;
  FunnyWin->hide ();
  FunnyWin->position (900, 500);
  FunnyWin->show ();
  Fl::focus (DoC);
}

void
GMORGAN::cb_MenuUtilssub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuUtilssub1_i (o, v);
}

void
GMORGAN::cb_MenuUtilssub2_i (Fl_Menu_ *, void *)
{
  if (gmo->SoundSelect)
    SSSelector->setonly ();
  if (gmo->PatternSelect)
    PSSelector->setonly ();
  if (gmo->StyleSelect)
    YSSelector->setonly ();
  if (gmo->AccordionSelect)
    ASSelector->setonly ();	
  KBEntrywin->hide ();
  Fl::focus (EntradaK);
  if (gmo->SoundSelect)
    EntradaK->value (gmo->ss);
  if (gmo->PatternSelect)
    EntradaK->value (gmo->sp);
  if (gmo->StyleSelect)
    EntradaK->value (gmo->st);
  if (gmo->AccordionSelect)
    EntradaK->value (0);

  KBEntrywin->position (1, 1);
  KBEntrywin->show ();
}

void
GMORGAN::cb_MenuUtilssub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuUtilssub2_i (o, v);
}

void
GMORGAN::cb_MenuUtilssub3_i (Fl_Menu_ *, void *)
{
  MVolMaster->value (gmo->MasterON);
  MVolSlider->value (gmo->MasterVolume);
  MTMSB->value (gmo->MTmsb);
  MTCounter->value (gmo->MTmsb - 64);
  MVolwin->hide ();
  MVolwin->position (1, 1);
  MVolwin->show ();
}

void
GMORGAN::cb_MenuUtilssub3 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuUtilssub3_i (o, v);
}

void
GMORGAN::cb_MenuUtilssub4_i (Fl_Menu_ *, void *)
{
  if (strlen (gmo->LibStylesFilename) < 5)
    {

      fl_message (gettext ("Please, configure your settings"));
      return;
    }


  if (gmo->genwindow == 1)
    return;
  gmo->genwindow = 1;
  preparagen ();
}

void
GMORGAN::cb_MenuUtilssub4 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuUtilssub4_i (o, v);
}

void
GMORGAN::cb_MenuUtilssub5_i (Fl_Menu_ *, void *)
{
  preparaGUIPlay ();
}

void
GMORGAN::cb_MenuUtilssub5 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuUtilssub5_i (o, v);
}

void
GMORGAN::cb_MSettingssub1_i (Fl_Menu_ *, void *)
{
  if (strlen (gmo->PresetFilename) < 2)
    {
      fl_alert (gettext ("Configure your Settings"));
      return;
    }
  PreparaPre (1);
}

void
GMORGAN::cb_MSettingssub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MSettingssub1_i (o, v);
}

void
GMORGAN::cb_MSettingssub2_i (Fl_Menu_ *, void *)
{
  if (strlen (gmo->DrumNoteFilename) < 2)
    {
      fl_alert (gettext ("Configure your Settings"));
      return;
    }

  PreparaDru (1);
}

void
GMORGAN::cb_MSettingssub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MSettingssub2_i (o, v);
}

void
GMORGAN::cb_MSettingssub3_i (Fl_Menu_ *, void *)
{
  MiraClientes ();
  MiraConfig ();
  Settingswindow->hide ();
  Settingswindow->position (1, 1);
  Settingswindow->show ();
  Fl::focus (SClose);
}

void
GMORGAN::cb_MSettingssub3 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MSettingssub3_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_Menu[] = {
  {gettext ("&File"), 0, (Fl_Callback *) GMORGAN::cb_MFile, 0, 64,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("&Load Sounds..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub1, 0,
   0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("&Save Sounds..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub2, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Load one Sound ..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub3,
   0, 0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Save one Sound..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub4, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Load Patterns..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub5, 0,
   0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Save Patterns..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub6, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Load one Pattern..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub7,
   0, 0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Save one Pattern"), 0, (Fl_Callback *) GMORGAN::cb_MFilesub8, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Load Styles..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub9, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Save Styles..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub10, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Load one Style..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub11,
   0, 0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Save one Style..."), 0, (Fl_Callback *) GMORGAN::cb_MFilesub12,
   0, 128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Load Song"), 0, (Fl_Callback *) GMORGAN::cb_MFilesub13, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Save Song"), 0, (Fl_Callback *) GMORGAN::cb_MFilesub14, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Export Midifile"), 0, (Fl_Callback *) GMORGAN::cb_MFilesub15, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("E&xit"), 0, (Fl_Callback *) GMORGAN::cb_MFilesub16, 0, 128,
   FL_NORMAL_LABEL, 0, 10, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {gettext ("&Edit"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Pattern"), 0, (Fl_Callback *) GMORGAN::cb_EditWinssub1, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Pattern Global Drum"), 0,
   (Fl_Callback *) GMORGAN::cb_EditWinssub2, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Pattern Control"), 0, (Fl_Callback *) GMORGAN::cb_EditWinssub3,
   0, 0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Style"), 0, (Fl_Callback *) GMORGAN::cb_EditWinssub4, 0, 128,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Import Midifile"), 0, (Fl_Callback *) GMORGAN::cb_EditWinssub5,
   0, 128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Velocity"), 0, (Fl_Callback *) GMORGAN::cb_EditWinssub6, 0, 128,
   FL_NORMAL_LABEL, 0, 10, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {gettext ("&Sounds"), 0x80062, (Fl_Callback *) GMORGAN::cb_MBank, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Se&quencer"), 0, (Fl_Callback *) GMORGAN::cb_BPlay, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("&Utils"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("&Keyb"), 0x6b, (Fl_Callback *) GMORGAN::cb_MenuUtilssub1, 0, 128,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Se&lector"), 0x6c, (Fl_Callback *) GMORGAN::cb_MenuUtilssub2, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Master"), 0x6d, (Fl_Callback *) GMORGAN::cb_MenuUtilssub3, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Generator"), 0x67, (Fl_Callback *) GMORGAN::cb_MenuUtilssub4, 0,
   128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Guided Play"), 0x75, (Fl_Callback *) GMORGAN::cb_MenuUtilssub5,
   0, 128, FL_NORMAL_LABEL, 0, 10, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {gettext ("&Settings"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Preset File"), 0, (Fl_Callback *) GMORGAN::cb_MSettingssub1, 0,
   0, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("Drum Note File"), 0, (Fl_Callback *) GMORGAN::cb_MSettingssub2,
   0, 128, FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("&Global"), 0, (Fl_Callback *) GMORGAN::cb_MSettingssub3, 0, 128,
   FL_NORMAL_LABEL, 0, 10, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Menu_Item *
  GMORGAN::MFile = GMORGAN::menu_Menu + 0;
Fl_Menu_Item *
  GMORGAN::MFilesub1 = GMORGAN::menu_Menu + 1;
Fl_Menu_Item *
  GMORGAN::MFilesub2 = GMORGAN::menu_Menu + 2;
Fl_Menu_Item *
  GMORGAN::MFilesub3 = GMORGAN::menu_Menu + 3;
Fl_Menu_Item *
  GMORGAN::MFilesub4 = GMORGAN::menu_Menu + 4;
Fl_Menu_Item *
  GMORGAN::MFilesub5 = GMORGAN::menu_Menu + 5;
Fl_Menu_Item *
  GMORGAN::MFilesub6 = GMORGAN::menu_Menu + 6;
Fl_Menu_Item *
  GMORGAN::MFilesub7 = GMORGAN::menu_Menu + 7;
Fl_Menu_Item *
  GMORGAN::MFilesub8 = GMORGAN::menu_Menu + 8;
Fl_Menu_Item *
  GMORGAN::MFilesub9 = GMORGAN::menu_Menu + 9;
Fl_Menu_Item *
  GMORGAN::MFilesub10 = GMORGAN::menu_Menu + 10;
Fl_Menu_Item *
  GMORGAN::MFilesub11 = GMORGAN::menu_Menu + 11;
Fl_Menu_Item *
  GMORGAN::MFilesub12 = GMORGAN::menu_Menu + 12;
Fl_Menu_Item *
  GMORGAN::MFilesub13 = GMORGAN::menu_Menu + 13;
Fl_Menu_Item *
  GMORGAN::MFilesub14 = GMORGAN::menu_Menu + 14;
Fl_Menu_Item *
  GMORGAN::MFilesub15 = GMORGAN::menu_Menu + 15;
Fl_Menu_Item *
  GMORGAN::MFilesub16 = GMORGAN::menu_Menu + 16;
Fl_Menu_Item *
  GMORGAN::EditWins = GMORGAN::menu_Menu + 18;
Fl_Menu_Item *
  GMORGAN::EditWinssub1 = GMORGAN::menu_Menu + 19;
Fl_Menu_Item *
  GMORGAN::EditWinssub2 = GMORGAN::menu_Menu + 20;
Fl_Menu_Item *
  GMORGAN::EditWinssub3 = GMORGAN::menu_Menu + 21;
Fl_Menu_Item *
  GMORGAN::EditWinssub4 = GMORGAN::menu_Menu + 22;
Fl_Menu_Item *
  GMORGAN::EditWinssub5 = GMORGAN::menu_Menu + 23;
Fl_Menu_Item *
  GMORGAN::EditWinssub6 = GMORGAN::menu_Menu + 24;
Fl_Menu_Item *
  GMORGAN::MBank = GMORGAN::menu_Menu + 26;
Fl_Menu_Item *
  GMORGAN::BPlay = GMORGAN::menu_Menu + 27;
Fl_Menu_Item *
  GMORGAN::MenuUtils = GMORGAN::menu_Menu + 28;
Fl_Menu_Item *
  GMORGAN::MenuUtilssub1 = GMORGAN::menu_Menu + 29;
Fl_Menu_Item *
  GMORGAN::MenuUtilssub2 = GMORGAN::menu_Menu + 30;
Fl_Menu_Item *
  GMORGAN::MenuUtilssub3 = GMORGAN::menu_Menu + 31;
Fl_Menu_Item *
  GMORGAN::MenuUtilssub4 = GMORGAN::menu_Menu + 32;
Fl_Menu_Item *
  GMORGAN::MenuUtilssub5 = GMORGAN::menu_Menu + 33;
Fl_Menu_Item *
  GMORGAN::MSettings = GMORGAN::menu_Menu + 35;
Fl_Menu_Item *
  GMORGAN::MSettingssub1 = GMORGAN::menu_Menu + 36;
Fl_Menu_Item *
  GMORGAN::MSettingssub2 = GMORGAN::menu_Menu + 37;
Fl_Menu_Item *
  GMORGAN::MSettingssub3 = GMORGAN::menu_Menu + 38;

void
GMORGAN::cb_MenuHelpsub1_i (Fl_Menu_ *, void *)
{
  gmo->make_GHelp ();
}

void
GMORGAN::cb_MenuHelpsub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuHelpsub1_i (o, v);
}

void
GMORGAN::cb_MenuHelpsub2_i (Fl_Menu_ *, void *)
{
  prepara_about ();
}

void
GMORGAN::cb_MenuHelpsub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MenuHelpsub2_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_MenuAyuda[] = {
  {gettext ("&Help"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 10, 32},
  {gettext ("Help"), 0xffbe, (Fl_Callback *) GMORGAN::cb_MenuHelpsub1, 0, 128,
   FL_NORMAL_LABEL, 0, 10, 0},
  {gettext ("&About"), 0, (Fl_Callback *) GMORGAN::cb_MenuHelpsub2, 0, 0,
   FL_NORMAL_LABEL, 0, 10, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Menu_Item *
  GMORGAN::MenuHelp = GMORGAN::menu_MenuAyuda + 0;
Fl_Menu_Item *
  GMORGAN::MenuHelpsub1 = GMORGAN::menu_MenuAyuda + 1;
Fl_Menu_Item *
  GMORGAN::MenuHelpsub2 = GMORGAN::menu_MenuAyuda + 2;

void
GMORGAN::cb_Nombre_i (Fl_Input * o, void *)
{
  int i,k;
  strcpy (gmo->Name, (char *) o->value ());
  i = gmo->ss;
  for (k = 0; k <= (int) strlen (gmo->Name); k++)
    gmo->Prog[i].Nom[k] = gmo->Name[k];
//  cout << " i = " << i;
//  cout << "cb_Nombre_i: ss= " << gmo->ss << "Name: "  << gmo->Name << " value: " << o->value() << endl;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Nombre (Fl_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Nombre_i (o, v);
}

void
GMORGAN::cb_DMIN1_i (Fl_Box * o, void *)
{
  o->label (gmo->MidiInPuerto[1].pMIDIIN);
}

void
GMORGAN::cb_DMIN1 (Fl_Box * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DMIN1_i (o, v);
}

void
GMORGAN::cb_VUI1_i (Fl_Slider * o, void *)
{
  o->value (vum);
}

void
GMORGAN::cb_VUI1 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_VUI1_i (o, v);
}

void
GMORGAN::cb_DMO1_i (Fl_Box * o, void *)
{
  o->label (gmo->MidiOutPuerto[1].pMIDIOUT);
}

void
GMORGAN::cb_DMO1 (Fl_Box * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DMO1_i (o, v);
}

void
GMORGAN::cb_FPan1_i (Fl_Dial * o, void *)
{
  gmo->pan[1] = (int) o->value ();
  gmo->enviocontrol (1, 10, 0);
}

void
GMORGAN::cb_FPan1 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan1_i (o, v);
}

void
GMORGAN::cb_FPan2_i (Fl_Dial * o, void *)
{
  gmo->pan[2] = (int) o->value ();
  gmo->enviocontrol (2, 10, 1);
}

void
GMORGAN::cb_FPan2 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan2_i (o, v);
}

void
GMORGAN::cb_FPan3_i (Fl_Dial * o, void *)
{
  gmo->pan[3] = (int) o->value ();
  gmo->enviocontrol (3, 10, 2);
}

void
GMORGAN::cb_FPan3 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan3_i (o, v);
}

void
GMORGAN::cb_FPan4_i (Fl_Dial * o, void *)
{
  gmo->pan[4] = (int) o->value ();
  gmo->enviocontrol (4, 10, 3);
}

void
GMORGAN::cb_FPan4 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan4_i (o, v);
}

void
GMORGAN::cb_FRev1_i (Fl_Dial * o, void *)
{
  gmo->reverb[1] = (int) o->value ();
  gmo->enviocontrol (1, 91, 0);
}

void
GMORGAN::cb_FRev1 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev1_i (o, v);
}

void
GMORGAN::cb_FCho1_i (Fl_Dial * o, void *)
{
  gmo->chorus[1] = (int) o->value ();
  gmo->enviocontrol (1, 93, 0);
}

void
GMORGAN::cb_FCho1 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho1_i (o, v);
}

void
GMORGAN::cb_FRev2_i (Fl_Dial * o, void *)
{
  gmo->reverb[2] = (int) o->value ();
  gmo->enviocontrol (2, 91, 1);
}

void
GMORGAN::cb_FRev2 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev2_i (o, v);
}

void
GMORGAN::cb_FRev3_i (Fl_Dial * o, void *)
{
  gmo->reverb[3] = (int) o->value ();
  gmo->enviocontrol (3, 91, 2);
}

void
GMORGAN::cb_FRev3 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev3_i (o, v);
}

void
GMORGAN::cb_FRev4_i (Fl_Dial * o, void *)
{
  gmo->reverb[4] = (int) o->value ();
  gmo->enviocontrol (4, 91, 3);
}

void
GMORGAN::cb_FRev4 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev4_i (o, v);
}

void
GMORGAN::cb_FCho2_i (Fl_Dial * o, void *)
{
  gmo->chorus[2] = (int) o->value ();
  gmo->enviocontrol (2, 93, 1);
}

void
GMORGAN::cb_FCho2 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho2_i (o, v);
}

void
GMORGAN::cb_FCho3_i (Fl_Dial * o, void *)
{
  gmo->chorus[3] = (int) o->value ();
  gmo->enviocontrol (3, 93, 2);
}

void
GMORGAN::cb_FCho3 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho3_i (o, v);
}

void
GMORGAN::cb_FCho4_i (Fl_Dial * o, void *)
{
  gmo->chorus[4] = (int) o->value ();
  gmo->enviocontrol (4, 93, 3);
}

void
GMORGAN::cb_FCho4 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho4_i (o, v);
}

void
GMORGAN::cb_PANICO_i (Fl_Button *, void *)
{
  gmo->panico (0, 15);
  Fl::focus (StartStop);
}

void
GMORGAN::cb_PANICO (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_PANICO_i (o, v);
}

void
GMORGAN::cb_FVol1_i (Fl_Slider * o, void *)
{
  gmo->volume[1] = (int) o->value ();
  gmo->enviocontrol (1, 7, 0);
}

void
GMORGAN::cb_FVol1 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol1_i (o, v);
}

void
GMORGAN::cb_FVol2_i (Fl_Slider * o, void *)
{
  gmo->volume[2] = (int) o->value ();
  gmo->enviocontrol (2, 7, 1);
  ;
}

void
GMORGAN::cb_FVol2 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol2_i (o, v);
}

void
GMORGAN::cb_FVol3_i (Fl_Slider * o, void *)
{
  gmo->volume[3] = (int) o->value ();
  gmo->enviocontrol (3, 7, 2);
  ;
}

void
GMORGAN::cb_FVol3 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol3_i (o, v);
}

void
GMORGAN::cb_FVol4_i (Fl_Slider * o, void *)
{
  gmo->volume[4] = (int) o->value ();
  gmo->enviocontrol (4, 7, 3);
  ;
}

void
GMORGAN::cb_FVol4 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol4_i (o, v);
}

void
GMORGAN::cb_FProg1_i (Fl_Counter * o, void *)
{
  gmo->progch[1] = (int) o->value ();

  gmo->enviomidi (1, 0);
  P1->label (gmo->PresetList[gmo->CalculaBanco (1)].PBanco[gmo->progch[1]].
	     ProgName);
}

void
GMORGAN::cb_FProg1 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg1_i (o, v);
}

void
GMORGAN::cb_FProg2_i (Fl_Counter * o, void *)
{
  gmo->progch[2] = (int) o->value ();

  gmo->enviomidi (2, 1);
  P2->label (gmo->PresetList[gmo->CalculaBanco (2)].PBanco[gmo->progch[2]].
	     ProgName);
}

void
GMORGAN::cb_FProg2 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg2_i (o, v);
}

void
GMORGAN::cb_FProg3_i (Fl_Counter * o, void *)
{
  gmo->progch[3] = (int) o->value ();

  gmo->enviomidi (3, 2);
  P3->label (gmo->PresetList[gmo->CalculaBanco (3)].PBanco[gmo->progch[3]].
	     ProgName);
}

void
GMORGAN::cb_FProg3 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg3_i (o, v);
}

void
GMORGAN::cb_FProg4_i (Fl_Counter * o, void *)
{
  gmo->progch[4] = (int) o->value ();

  gmo->enviomidi (4, 3);
  P4->label (gmo->PresetList[gmo->CalculaBanco (4)].PBanco[gmo->progch[4]].
	     ProgName);
}

void
GMORGAN::cb_FProg4 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg4_i (o, v);
}

void
GMORGAN::cb_FPan5_i (Fl_Dial * o, void *)
{
  gmo->pan[5] = (int) o->value ();
  gmo->enviocontrol (5, 10, 4);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc1pan = (int) o->value ();
}

void
GMORGAN::cb_FPan5 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan5_i (o, v);
}

void
GMORGAN::cb_FPan6_i (Fl_Dial * o, void *)
{
  gmo->pan[6] = (int) o->value ();
  gmo->enviocontrol (6, 10, 5);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc2pan = (int) o->value ();
}

void
GMORGAN::cb_FPan6 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan6_i (o, v);
}

void
GMORGAN::cb_FRev5_i (Fl_Dial * o, void *)
{
  gmo->reverb[5] = (int) o->value ();
  gmo->enviocontrol (5, 91, 4);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc1rev = (int) o->value ();
}

void
GMORGAN::cb_FRev5 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev5_i (o, v);
}

void
GMORGAN::cb_FRev6_i (Fl_Dial * o, void *)
{
  gmo->reverb[6] = (int) o->value ();
  gmo->enviocontrol (6, 91, 5);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc2rev = (int) o->value ();
}

void
GMORGAN::cb_FRev6 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev6_i (o, v);
}

void
GMORGAN::cb_FCho5_i (Fl_Dial * o, void *)
{
  gmo->chorus[5] = (int) o->value ();
  gmo->enviocontrol (5, 93, 4);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc1cho = (int) o->value ();
}

void
GMORGAN::cb_FCho5 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho5_i (o, v);
}

void
GMORGAN::cb_FCho6_i (Fl_Dial * o, void *)
{
  gmo->chorus[6] = (int) o->value ();
  gmo->enviocontrol (6, 93, 5);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc2cho = (int) o->value ();
}

void
GMORGAN::cb_FCho6 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho6_i (o, v);
}

void
GMORGAN::cb_FVol5_i (Fl_Slider * o, void *)
{
  gmo->volume[5] = (int) o->value ();
  gmo->enviocontrol (5, 7, 4);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc1vol = (int) o->value ();
}

void
GMORGAN::cb_FVol5 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol5_i (o, v);
}

void
GMORGAN::cb_FVol6_i (Fl_Slider * o, void *)
{
  gmo->volume[6] = (int) o->value ();
  gmo->enviocontrol (6, 7, 5);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc2vol = (int) o->value ();
}

void
GMORGAN::cb_FVol6 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol6_i (o, v);
}

void
GMORGAN::cb_FProg5_i (Fl_Counter * o, void *)
{
  gmo->progch[5] = (int) o->value ();

  gmo->enviomidi (5, 4);
  P5->label (gmo->PresetList[gmo->CalculaBanco (5)].PBanco[gmo->progch[5]].
	     ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc1pc = (int) o->value ();
}

void
GMORGAN::cb_FProg5 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg5_i (o, v);
}

void
GMORGAN::cb_FProg6_i (Fl_Counter * o, void *)
{
  gmo->progch[6] = (int) o->value ();

  gmo->enviomidi (6, 5);
  P6->label (gmo->PresetList[gmo->CalculaBanco (6)].PBanco[gmo->progch[6]].
	     ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc2pc = (int) o->value ();
}

void
GMORGAN::cb_FProg6 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg6_i (o, v);
}

void
GMORGAN::cb_FPan7_i (Fl_Dial * o, void *)
{
  gmo->pan[7] = (int) o->value ();
  gmo->enviocontrol (7, 10, 6);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].basspan = (int) o->value ();
}

void
GMORGAN::cb_FPan7 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan7_i (o, v);
}

void
GMORGAN::cb_FRev7_i (Fl_Dial * o, void *)
{
  gmo->reverb[7] = (int) o->value ();
  gmo->enviocontrol (7, 91, 6);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].bassrev = (int) o->value ();
}

void
GMORGAN::cb_FRev7 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev7_i (o, v);
}

void
GMORGAN::cb_FCho7_i (Fl_Dial * o, void *)
{
  gmo->chorus[7] = (int) o->value ();
  gmo->enviocontrol (7, 93, 6);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].basscho = (int) o->value ();
}

void
GMORGAN::cb_FCho7 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho7_i (o, v);
}

void
GMORGAN::cb_FVol7_i (Fl_Slider * o, void *)
{
  gmo->volume[7] = (int) o->value ();
  gmo->enviocontrol (7, 7, 6);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].bassvol = (int) o->value ();
}

void
GMORGAN::cb_FVol7 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol7_i (o, v);
}

void
GMORGAN::cb_FProg7_i (Fl_Counter * o, void *)
{
  gmo->progch[7] = (int) o->value ();

  gmo->enviomidi (7, 6);
  P7->label (gmo->PresetList[gmo->CalculaBanco (7)].PBanco[gmo->progch[7]].
	     ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].basspc = (int) o->value ();
}

void
GMORGAN::cb_FProg7 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg7_i (o, v);
}

void
GMORGAN::cb_FPan8_i (Fl_Dial * o, void *)
{
  gmo->pan[8] = (int) o->value ();
  gmo->enviocontrol (8, 10, 9);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].drpan = (int) o->value ();
}

void
GMORGAN::cb_FPan8 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan8_i (o, v);
}

void
GMORGAN::cb_FRev8_i (Fl_Dial * o, void *)
{
  gmo->reverb[8] = (int) o->value ();
  gmo->enviocontrol (8, 91, 9);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].drrev = (int) o->value ();
}

void
GMORGAN::cb_FRev8 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev8_i (o, v);
}

void
GMORGAN::cb_FCho8_i (Fl_Dial * o, void *)
{
  gmo->chorus[8] = (int) o->value ();
  gmo->enviocontrol (8, 93, 9);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].drcho = (int) o->value ();
}

void
GMORGAN::cb_FCho8 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho8_i (o, v);
}

void
GMORGAN::cb_FVol8_i (Fl_Slider * o, void *)
{
  gmo->volume[8] = (int) o->value ();
  gmo->enviocontrol (8, 7, 9);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].drvol = (int) o->value ();
}

void
GMORGAN::cb_FVol8 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol8_i (o, v);
}

void
GMORGAN::cb_FProg8_i (Fl_Counter * o, void *)
{
  gmo->progch[8] = (int) o->value ();

  gmo->enviomidi (8, 9);
  P8->label (gmo->PresetList[gmo->CalculaBanco (8)].PBanco[gmo->progch[8]].
	     ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].drpc = (int) o->value ();
}

void
GMORGAN::cb_FProg8 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg8_i (o, v);
}

void
GMORGAN::cb_Pof1_i (Fl_Button * o, void *)
{
  gmo->OnOff[1] = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof1_i (o, v);
}

void
GMORGAN::cb_Pof2_i (Fl_Button * o, void *)
{
  gmo->OnOff[2] = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof2_i (o, v);
}

void
GMORGAN::cb_Pof3_i (Fl_Button * o, void *)
{
  gmo->OnOff[3] = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof3_i (o, v);
}

void
GMORGAN::cb_Pof4_i (Fl_Button * o, void *)
{
  gmo->OnOff[4] = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof4_i (o, v);
}

void
GMORGAN::cb_Pof5_i (Fl_Button * o, void *)
{
  gmo->OnOff[5] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc1on = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof5_i (o, v);
}

void
GMORGAN::cb_Pof6_i (Fl_Button * o, void *)
{
  gmo->OnOff[6] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc2on = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof6_i (o, v);
}

void
GMORGAN::cb_Pof7_i (Fl_Button * o, void *)
{
  gmo->OnOff[7] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].basson = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof7_i (o, v);
}

void
GMORGAN::cb_Pof8_i (Fl_Button * o, void *)
{
  gmo->OnOff[8] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].dron = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof8 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof8_i (o, v);
}

void
GMORGAN::cb_StartStop_i (Fl_Button * o, void *)
{
  gmo->stst = (int) o->value ();
  preparast ();

  if (o->value () == 1)
    {

      MRecord->deactivate ();
      MPlay->deactivate ();
      gmo->init_queue ();
      snd_seq_start_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			   NULL);
      gmo->set_tempo ();
      snd_seq_drain_output (gmo->MidiOutPuerto[1].midi_out);
      gmo->accompaniment ();

    }
  else
    {

      MRecord->activate ();
      MPlay->activate ();
      if (gmo->grabacion)
	{
	  gmo->grabacion = 0;
	  MRecord->value (0);
	}
      gmo->clear_queue ();
      snd_seq_stop_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			  NULL);
      snd_seq_free_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id);
      gmo->panico (0, 15);
      gmo->newp = 1;
      ApagaNex ();
      gmo->sp = gmo->Var1;
      PtBro->select (gmo->Var1);
    };
}

void
GMORGAN::cb_StartStop (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_StartStop_i (o, v);
}

void
GMORGAN::cb_TempoBPM_i (Fl_Dial * o, void *)
{
  gmo->bpm = (int) o->value ();
  gmo->set_tempo ();
  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
  DispTempo->label (gmo->tempoch);
  CTEMPO->value (gmo->bpm / 2);
}

void
GMORGAN::cb_TempoBPM (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_TempoBPM_i (o, v);
}

void
GMORGAN::cb_PtBro_i (Fl_Browser *, void *)
{
  int lastblackn;
  int maxposi;

  lastblackn = gmo->Rt[gmo->sp].blackn;

  if (Fl::event_button () == 3)
    {
      gmo->sp = (int) PtBro->value ();
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
      EditPattern (PtBro->value ());
      gmo->Ending = gmo->Var1 = gmo->Var2 = gmo->Fill1 = gmo->Fill2 =
	gmo->Intro = gmo->sp;

    }
  if (Fl::event_button () == 1)
    {
      gmo->sp = (int) PtBro->value ();
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
      maxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;

      if (lastblackn == gmo->Rt[gmo->sp].blackn)
	{
	  if (gmo->sposi > maxposi)
	    gmo->sposi = gmo->sposi % maxposi;
	}
      else
	{
	  gmo->sposi = 0;
	  count = 1;
	  gmo->negra = 0;
	  gmo->semi = 0;
	  gmo->ncompas = 0;
	}
      gmo->nextp = gmo->sp;
      gmo->Ending = gmo->Var1 = gmo->Var2 = gmo->Fill1 = gmo->Fill2 =
	gmo->Intro = gmo->sp;

    };
}

void
GMORGAN::cb_PtBro (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_PtBro_i (o, v);
}

void
GMORGAN::cb_Mas1_i (Fl_Button *, void *)
{
  MoreParms (1);
}

void
GMORGAN::cb_Mas1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas1_i (o, v);
}

void
GMORGAN::cb_Mas2_i (Fl_Button *, void *)
{
  MoreParms (2);
}

void
GMORGAN::cb_Mas2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas2_i (o, v);
}

void
GMORGAN::cb_Mas3_i (Fl_Button *, void *)
{
  MoreParms (3);
}

void
GMORGAN::cb_Mas3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas3_i (o, v);
}

void
GMORGAN::cb_Mas4_i (Fl_Button *, void *)
{
  MoreParms (4);
}

void
GMORGAN::cb_Mas4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas4_i (o, v);
}

void
GMORGAN::cb_Mas5_i (Fl_Button *, void *)
{
  MoreParms (5);
}

void
GMORGAN::cb_Mas5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas5_i (o, v);
}

void
GMORGAN::cb_Mas6_i (Fl_Button *, void *)
{
  MoreParms (6);
}

void
GMORGAN::cb_Mas6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas6_i (o, v);
}

void
GMORGAN::cb_Mas8_i (Fl_Button *, void *)
{
  MoreParms (7);
}

void
GMORGAN::cb_Mas8 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas8_i (o, v);
}

void
GMORGAN::cb_Mas9_i (Fl_Button *, void *)
{
  MoreParms (8);
}

void
GMORGAN::cb_Mas9 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas9_i (o, v);
}

void
GMORGAN::cb_StBro_i (Fl_Browser *, void *)
{
  if (Fl::event_button () == 3)
    {
      gmo->st = (int) StBro->value ();
      PutStyle (gmo->st);
      EditStyle (StBro->value ());
    }

  if (Fl::event_button () == 1)
    {
      gmo->st = (int) StBro->value ();
      PutStyle (gmo->st);
	cout << "style change to " << gmo->st << endl;
    };
  CTEMPO->value (gmo->bpm / 2);
  TempoBPM->value (gmo->bpm);
}

void
GMORGAN::cb_StBro (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_StBro_i (o, v);
}

void
GMORGAN::cb_PIntro_i (Fl_Button *, void *)
{
  PtBro->select (gmo->Intro);
  if (gmo->stst)
    {
      int acmaxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;
      int prmaxposi =
	gmo->Rt[gmo->Intro].bars * gmo->Rt[gmo->Intro].blackn * 4;
      if (acmaxposi != prmaxposi)
	{
	  if (gmo->sposi > prmaxposi)
	    gmo->sposi = gmo->sposi % (gmo->Rt[gmo->Intro].blackn * 4);
	  if (gmo->sposi == prmaxposi)
	    gmo->sposi = 0;
	}
    }
  gmo->sp = gmo->Intro;
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_PIntro (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_PIntro_i (o, v);
}

void
GMORGAN::cb_PVar1_i (Fl_Button *, void *)
{
  PtBro->select (gmo->Var1);
  if (gmo->stst)
    {
      int acmaxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;
      int prmaxposi = gmo->Rt[gmo->Var1].bars * gmo->Rt[gmo->Var1].blackn * 4;
      if (acmaxposi != prmaxposi)
	{
	  if (gmo->sposi > prmaxposi)
	    gmo->sposi = gmo->sposi % (gmo->Rt[gmo->Var1].blackn * 4);
	  if (gmo->sposi == prmaxposi)
	    gmo->sposi = 0;
	}

    }
  gmo->sp = gmo->Var1;
  gmo->MeteMixerMidi (gmo->sp);
  gmo->ChangePattern (gmo->sp);
  metemixerpat ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_PVar1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_PVar1_i (o, v);
}

void
GMORGAN::cb_PVar2_i (Fl_Button *, void *)
{
  PtBro->select (gmo->Var2);
  if (gmo->stst)
    {
      int acmaxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;
      int prmaxposi = gmo->Rt[gmo->Var2].bars * gmo->Rt[gmo->Var2].blackn * 4;
      if (acmaxposi != prmaxposi)
	{
	  if (gmo->sposi > prmaxposi)
	    gmo->sposi = gmo->sposi % (gmo->Rt[gmo->Var2].blackn * 4);
	  if (gmo->sposi == prmaxposi)
	    gmo->sposi = 0;
	}
    }
  gmo->sp = gmo->Var2;
  gmo->MeteMixerMidi (gmo->sp);
  gmo->ChangePattern (gmo->sp);
  metemixerpat ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_PVar2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_PVar2_i (o, v);
}

void
GMORGAN::cb_PEnding_i (Fl_Button *, void *)
{
  PtBro->select (gmo->Ending);
  if (gmo->stst)
    {
      int acmaxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;
      int prmaxposi =
	gmo->Rt[gmo->Ending].bars * gmo->Rt[gmo->Ending].blackn * 4;
      if (acmaxposi != prmaxposi)
	{
	  if (gmo->sposi > prmaxposi)
	    gmo->sposi = gmo->sposi % (gmo->Rt[gmo->Ending].blackn * 4);
	  if (gmo->sposi == prmaxposi)
	    gmo->sposi = 0;
	}

    }
  gmo->sp = gmo->Ending;
  gmo->MeteMixerMidi (gmo->sp);
  gmo->ChangePattern (gmo->sp);
  metemixerpat ();
  gmo->finito = 1;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_PEnding (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_PEnding_i (o, v);
}

void
GMORGAN::cb_CTRANSPOSE_i (Fl_Counter * o, void *)
{
  gmo->transpose = (int) o->value ();
  gmo->panico (0, 15);
}

void
GMORGAN::cb_CTRANSPOSE (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CTRANSPOSE_i (o, v);
}

void
GMORGAN::cb_NEnding_i (Fl_Button *, void *)
{
  gmo->nextp = gmo->Ending;
  gmo->mezcla = 0;
  gmo->newp = 3;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_NEnding (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_NEnding_i (o, v);
}

void
GMORGAN::cb_NVar1_i (Fl_Button *, void *)
{
  gmo->nextp = gmo->Var1;
  gmo->mezcla = 0;
  gmo->newp = 1;
  ttnp = 1;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_NVar1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_NVar1_i (o, v);
}

void
GMORGAN::cb_NVar2_i (Fl_Button *, void *)
{
  gmo->nextp = gmo->Var2;
  gmo->mezcla = 0;
  gmo->newp = 2;
  ttnp = 3;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_NVar2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_NVar2_i (o, v);
}

void
GMORGAN::cb_NFill1_i (Fl_Button *, void *)
{
  gmo->nextp = gmo->Var1;
  gmo->mezcla = gmo->Fill1;
  gmo->newp = 4;
  ttnp =2;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_NFill1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_NFill1_i (o, v);
}

void
GMORGAN::cb_NFill2_i (Fl_Button *, void *)
{
  gmo->nextp = gmo->Var2;
  gmo->mezcla = gmo->Fill2;
  gmo->newp = 5;
  ttnp = 4;
  Fl::focus (StartStop);
}

void
GMORGAN::cb_NFill2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_NFill2_i (o, v);
}

void
GMORGAN::cb_FPan9_i (Fl_Dial * o, void *)
{
  gmo->pan[9] = (int) o->value ();
  gmo->enviocontrol (9, 10, 7);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc3pan = (int) o->value ();
}

void
GMORGAN::cb_FPan9 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan9_i (o, v);
}

void
GMORGAN::cb_FRev9_i (Fl_Dial * o, void *)
{
  gmo->reverb[9] = (int) o->value ();
  gmo->enviocontrol (9, 91, 7);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc3rev = (int) o->value ();
}

void
GMORGAN::cb_FRev9 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev9_i (o, v);
}

void
GMORGAN::cb_FCho9_i (Fl_Dial * o, void *)
{
  gmo->chorus[9] = (int) o->value ();
  gmo->enviocontrol (9, 93, 7);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc3cho = (int) o->value ();
}

void
GMORGAN::cb_FCho9 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho9_i (o, v);
}

void
GMORGAN::cb_FVol9_i (Fl_Slider * o, void *)
{
  gmo->volume[9] = (int) o->value ();
  gmo->enviocontrol (9, 7, 7);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc3vol = (int) o->value ();
}

void
GMORGAN::cb_FVol9 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol9_i (o, v);
}

void
GMORGAN::cb_FProg9_i (Fl_Counter * o, void *)
{
  gmo->progch[9] = (int) o->value ();

  gmo->enviomidi (9, 7);
  P9->label (gmo->PresetList[gmo->CalculaBanco (9)].PBanco[gmo->progch[9]].
	     ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc3pc = (int) o->value ();
}

void
GMORGAN::cb_FProg9 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg9_i (o, v);
}

void
GMORGAN::cb_Pof9_i (Fl_Button * o, void *)
{
  gmo->OnOff[9] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc3on = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof9 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof9_i (o, v);
}

void
GMORGAN::cb_Mas7_i (Fl_Button *, void *)
{
  MoreParms (9);
}

void
GMORGAN::cb_Mas7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas7_i (o, v);
}

void
GMORGAN::cb_ProSlider_i (Fl_Counter * o, void *)
{
  gmo->ss = (int) o->value ();
  PutCombi (gmo->ss);
}

void
GMORGAN::cb_ProSlider (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_ProSlider_i (o, v);
}

void
GMORGAN::cb_HarSlider_i (Fl_Counter * o, void *)
{
  gmo->HMode = (int) o->value ();
  HZ1->value (gmo->HM[gmo->HMode].Name);
  gmo->panico (0, 3);
}

void
GMORGAN::cb_HarSlider (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_HarSlider_i (o, v);
}

void
GMORGAN::cb_CTEMPO_i (Fl_Counter * o, void *)
{
  gmo->bpm = (int) o->value () * 2;
  gmo->set_tempo ();
  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
  DispTempo->label (gmo->tempoch);
  TempoBPM->value (o->value () * 2);
}

void
GMORGAN::cb_CTEMPO (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CTEMPO_i (o, v);
}

void
GMORGAN::cb_Pof10_i (Fl_Button * o, void *)
{
  gmo->OnOff[10] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc4on = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof10 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof10_i (o, v);
}

void
GMORGAN::cb_Mas10_i (Fl_Button *, void *)
{
  MoreParms (10);
}

void
GMORGAN::cb_Mas10 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas10_i (o, v);
}

void
GMORGAN::cb_FVol10_i (Fl_Slider * o, void *)
{
  gmo->volume[10] = (int) o->value ();
  gmo->enviocontrol (10, 7, 8);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc4vol = (int) o->value ();
}

void
GMORGAN::cb_FVol10 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol10_i (o, v);
}

void
GMORGAN::cb_FPan10_i (Fl_Dial * o, void *)
{
  gmo->pan[10] = (int) o->value ();
  gmo->enviocontrol (10, 10, 8);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc4pan = (int) o->value ();
}

void
GMORGAN::cb_FPan10 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan10_i (o, v);
}

void
GMORGAN::cb_FRev10_i (Fl_Dial * o, void *)
{
  gmo->reverb[10] = (int) o->value ();
  gmo->enviocontrol (10, 91, 8);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc4rev = (int) o->value ();
}

void
GMORGAN::cb_FRev10 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev10_i (o, v);
}

void
GMORGAN::cb_FCho10_i (Fl_Dial * o, void *)
{
  gmo->chorus[10] = (int) o->value ();
  gmo->enviocontrol (10, 93, 8);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc4cho = (int) o->value ();
}

void
GMORGAN::cb_FCho10 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho10_i (o, v);
}

void
GMORGAN::cb_FProg10_i (Fl_Counter * o, void *)
{
  gmo->progch[10] = (int) o->value ();

  gmo->enviomidi (10, 8);
  P10->label (gmo->PresetList[gmo->CalculaBanco (10)].PBanco[gmo->progch[10]].
	      ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc4pc = (int) o->value ();
}

void
GMORGAN::cb_FProg10 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg10_i (o, v);
}

void
GMORGAN::cb_Pof11_i (Fl_Button * o, void *)
{
  gmo->OnOff[11] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc5on = (int) o->value ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Pof11 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Pof11_i (o, v);
}

void
GMORGAN::cb_Mas11_i (Fl_Button *, void *)
{
  MoreParms (11);
}

void
GMORGAN::cb_Mas11 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Mas11_i (o, v);
}

void
GMORGAN::cb_FVol11_i (Fl_Slider * o, void *)
{
  gmo->volume[11] = (int) o->value ();
  gmo->enviocontrol (11, 7, 10);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc5vol = (int) o->value ();
}

void
GMORGAN::cb_FVol11 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FVol11_i (o, v);
}

void
GMORGAN::cb_FPan11_i (Fl_Dial * o, void *)
{
  gmo->pan[11] = (int) o->value ();
  gmo->enviocontrol (11, 10, 10);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc5pan = (int) o->value ();
}

void
GMORGAN::cb_FPan11 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FPan11_i (o, v);
}

void
GMORGAN::cb_FRev11_i (Fl_Dial * o, void *)
{
  gmo->reverb[11] = (int) o->value ();
  gmo->enviocontrol (11, 91, 10);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc5rev = (int) o->value ();
}

void
GMORGAN::cb_FRev11 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FRev11_i (o, v);
}

void
GMORGAN::cb_FCho11_i (Fl_Dial * o, void *)
{
  gmo->chorus[11] = (int) o->value ();
  gmo->enviocontrol (11, 93, 10);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc5cho = (int) o->value ();
}

void
GMORGAN::cb_FCho11 (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FCho11_i (o, v);
}

void
GMORGAN::cb_FProg11_i (Fl_Counter * o, void *)
{
  gmo->progch[11] = (int) o->value ();

  gmo->enviomidi (11, 10);
  P11->label (gmo->PresetList[gmo->CalculaBanco (11)].PBanco[gmo->progch[11]].
	      ProgName);
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    gmo->Rt[gmo->sp].acc5pc = (int) o->value ();
}

void
GMORGAN::cb_FProg11 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_FProg11_i (o, v);
}

void
GMORGAN::cb_MRecord_i (Fl_Button * o, void *)
{
  gmo->grabacion = (int) o->value ();
  preparast ();

  if (o->value () == 1)
    {
      gmo->grabaconta = 0;
      memset (gmo->EG, 0, sizeof gmo->EG);
      MPlay->deactivate ();
      StartStop->value (1);
      gmo->grabacion = 1;
      gmo->stst = 1;
      gmo->init_queue ();
      snd_seq_start_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			   NULL);
      gmo->set_tempo ();
      snd_seq_drain_output (gmo->MidiOutPuerto[1].midi_out);
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
      PutCombi (gmo->ss);
      gmo->accompaniment ();

    }
  else
    {
      MPlay->activate ();
      StartStop->value (0);
      gmo->grabacion = 0;
      gmo->stst = 0;
      gmo->clear_queue ();
      snd_seq_stop_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			  NULL);
      snd_seq_free_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id);
      gmo->panico (0, 15);
      gmo->newp = 1;
      ApagaNex ();
      gmo->sp = gmo->Var1;
      PtBro->select (gmo->Var1);
    };
}

void
GMORGAN::cb_MRecord (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MRecord_i (o, v);
}

void
GMORGAN::cb_MPlay_i (Fl_Button * o, void *)
{
  if (o->value () == 1)
    {
      gmo->reproduccion = 1;
      gmo->cs = 1;
      gmo->ultimotick = 0;
      StartStop->deactivate ();
      MRecord->deactivate ();
      if (gmo->BPW)
	StartStopB->deactivate ();
      gmo->init_queue ();
      snd_seq_start_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			   NULL);
      gmo->set_tempo ();
      sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
      DispTempo->label (gmo->tempoch);
      CTEMPO->value (gmo->bpm / 2);
      snd_seq_drain_output (gmo->MidiOutPuerto[1].midi_out);
      gmo->EPlay ();

    }
  else
    {
      StopPlay ();
    };
}

void
GMORGAN::cb_MPlay (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MPlay_i (o, v);
}

void
GMORGAN::cb_l1mch_i (Fl_Counter * o, void *)
{
  gmo->TMch[1] = (int) o->value ();
}

void
GMORGAN::cb_l1mch (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_l1mch_i (o, v);
}

void
GMORGAN::cb_MchL2_i (Fl_Counter * o, void *)
{
  gmo->TMch[2] = (int) o->value ();
}

void
GMORGAN::cb_MchL2 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MchL2_i (o, v);
}

void
GMORGAN::cb_BassChl_i (Fl_Counter * o, void *)
{
  gmo->TMch[7] = (int) o->value ();
}

void
GMORGAN::cb_BassChl (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BassChl_i (o, v);
}

void
GMORGAN::cb_DrumChnl_i (Fl_Counter * o, void *)
{
  gmo->TMch[8] = (int) o->value ();
}

void
GMORGAN::cb_DrumChnl (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DrumChnl_i (o, v);
}

void
GMORGAN::cb_MAcc1_i (Fl_Counter * o, void *)
{
  gmo->TMch[5] = (int) o->value ();
}

void
GMORGAN::cb_MAcc1 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MAcc1_i (o, v);
}

void
GMORGAN::cb_MAcc2_i (Fl_Counter * o, void *)
{
  gmo->TMch[6] = (int) o->value ();
}

void
GMORGAN::cb_MAcc2 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MAcc2_i (o, v);
}

void
GMORGAN::cb_MAcc3_i (Fl_Counter * o, void *)
{
  gmo->TMch[8] = (int) o->value ();
}

void
GMORGAN::cb_MAcc3 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MAcc3_i (o, v);
}

void
GMORGAN::cb_MAcc4_i (Fl_Counter * o, void *)
{
  gmo->TMch[9] = (int) o->value ();
}

void
GMORGAN::cb_MAcc4 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MAcc4_i (o, v);
}

void
GMORGAN::cb_MAcc5_i (Fl_Counter * o, void *)
{
  gmo->TMch[11] = (int) o->value ();
}

void
GMORGAN::cb_MAcc5 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MAcc5_i (o, v);
}

void
GMORGAN::cb_MchRKB_i (Fl_Counter * o, void *)
{
  gmo->TMch[3] = (int) o->value ();
}

void
GMORGAN::cb_MchRKB (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MchRKB_i (o, v);
}

void
GMORGAN::cb_MchRKB2_i (Fl_Counter * o, void *)
{
  gmo->TMch[4] = (int) o->value ();
}

void
GMORGAN::cb_MchRKB2 (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MchRKB2_i (o, v);
}

void
GMORGAN::cb_v1HighMidi_i (Fl_Counter * o, void *)
{
  gmo->hinote[1] = (int) o->value ();
}

void
GMORGAN::cb_v1HighMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v1HighMidi_i (o, v);
}

void
GMORGAN::cb_v1LowMidi_i (Fl_Counter * o, void *)
{
  gmo->lonote[1] = (int) o->value ();
}

void
GMORGAN::cb_v1LowMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v1LowMidi_i (o, v);
}

void
GMORGAN::cb_v1LowVelocity_i (Fl_Counter * o, void *)
{
  gmo->lowvel[1] = (int) o->value ();
}

void
GMORGAN::cb_v1LowVelocity (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v1LowVelocity_i (o, v);
}

void
GMORGAN::cb_v1HighVel_i (Fl_Counter * o, void *)
{
  gmo->hivel[1] = (int) o->value ();
}

void
GMORGAN::cb_v1HighVel (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v1HighVel_i (o, v);
}

void
GMORGAN::cb_v2LowMidi_i (Fl_Counter * o, void *)
{
  gmo->lonote[2] = (int) o->value ();
}

void
GMORGAN::cb_v2LowMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v2LowMidi_i (o, v);
}

void
GMORGAN::cb_v2HighMidi_i (Fl_Counter * o, void *)
{
  gmo->hinote[2] = (int) o->value ();
}

void
GMORGAN::cb_v2HighMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v2HighMidi_i (o, v);
}

void
GMORGAN::cb_v2LowVelocity_i (Fl_Counter * o, void *)
{
  gmo->lowvel[2] = (int) o->value ();
}

void
GMORGAN::cb_v2LowVelocity (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v2LowVelocity_i (o, v);
}

void
GMORGAN::cb_v2HighVel_i (Fl_Counter * o, void *)
{
  gmo->hivel[2] = (int) o->value ();
}

void
GMORGAN::cb_v2HighVel (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v2HighVel_i (o, v);
}

void
GMORGAN::cb_v3LowVelocity_i (Fl_Counter * o, void *)
{
  gmo->lowvel[3] = (int) o->value ();
}

void
GMORGAN::cb_v3LowVelocity (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v3LowVelocity_i (o, v);
}

void
GMORGAN::cb_v4LowVelocity_i (Fl_Counter * o, void *)
{
  gmo->lowvel[4] = (int) o->value ();
}

void
GMORGAN::cb_v4LowVelocity (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v4LowVelocity_i (o, v);
}

void
GMORGAN::cb_v3HighVel_i (Fl_Counter * o, void *)
{
  gmo->hivel[3] = (int) o->value ();
}

void
GMORGAN::cb_v3HighVel (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v3HighVel_i (o, v);
}

void
GMORGAN::cb_v4HighVel_i (Fl_Counter * o, void *)
{
  gmo->hivel[4] = (int) o->value ();
}

void
GMORGAN::cb_v4HighVel (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v4HighVel_i (o, v);
}

void
GMORGAN::cb_v3LowMidi_i (Fl_Counter * o, void *)
{
  gmo->lonote[3] = (int) o->value ();
}

void
GMORGAN::cb_v3LowMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v3LowMidi_i (o, v);
}

void
GMORGAN::cb_v4LowMidi_i (Fl_Counter * o, void *)
{
  gmo->lonote[4] = (int) o->value ();
}

void
GMORGAN::cb_v4LowMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v4LowMidi_i (o, v);
}

void
GMORGAN::cb_v3HighMidi_i (Fl_Counter * o, void *)
{
  gmo->hinote[3] = (int) o->value ();
}

void
GMORGAN::cb_v3HighMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v3HighMidi_i (o, v);
}

void
GMORGAN::cb_v4HighMidi_i (Fl_Counter * o, void *)
{
  gmo->hinote[4] = (int) o->value ();
}

void
GMORGAN::cb_v4HighMidi (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_v4HighMidi_i (o, v);
}

void GMORGAN::cb_mdimode_i(Fl_Counter* o, void*) {
  gmo->MidiMode = (int) o->value();
}
void GMORGAN::cb_mdimode(Fl_Counter* o, void* v) {
  ((GMORGAN*)(o->parent()->user_data()))->cb_mdimode_i(o,v);
}
void
GMORGAN::cb_Settingswindow_i (Fl_Double_Window *, void *)
{
  Settingswindow->hide ();
}

void
GMORGAN::cb_Settingswindow (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_Settingswindow_i (o, v);
}

void
GMORGAN::cb_SClose_i (Fl_Button *, void *)
{
  Settingswindow->hide ();
}

void
GMORGAN::cb_SClose (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_SClose_i (o, v);
}

void
GMORGAN::cb_Save_i (Fl_Button *, void *)
{
  gmo->GrabaSettings ();
  fl_message (gettext
	      ("Changes will take effect the next time you restart the program"));
  Settingswindow->hide ();
}

void
GMORGAN::cb_Save (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Save_i (o, v);
}

void
GMORGAN::cb_BMidiIn_i (Fl_Browser * o, void *)
{
  int valor;
  valor = (int) o->value ();
  gmo->MidiInPuerto[1].SMidiIn = (char *) o->text (valor);
  o->select (valor, 1);
}

void
GMORGAN::cb_BMidiIn (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BMidiIn_i (o, v);
}

void
GMORGAN::cb_BMidiOut_i (Fl_Browser * o, void *)
{
  int valor;
  valor = (int) o->value ();
  gmo->MidiOutPuerto[1].SMidiOut = (char *) o->text (valor);
  o->select (valor, 1);
}

void
GMORGAN::cb_BMidiOut (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BMidiOut_i (o, v);
}

void
GMORGAN::cb_Browse_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.gmox)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmox");
  SoFiname->value (filename);
  strcpy (gmo->SoundsFilename, filename);
}

void
GMORGAN::cb_Browse (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse_i (o, v);
}

void
GMORGAN::cb_Browse1_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.gmp)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmp");
  PaFiname->value (filename);
  strcpy (gmo->PatternsFilename, filename);
}

void
GMORGAN::cb_Browse1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse1_i (o, v);
}

void
GMORGAN::cb_Browse2_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.gms)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gms");
  StFiname->value (filename);
  strcpy (gmo->StylesFilename, filename);
}

void
GMORGAN::cb_Browse2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse2_i (o, v);
}

void
GMORGAN::cb_Browse3_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.txt)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".txt");
  DrFiname->value (filename);
  strcpy (gmo->DrumNoteFilename, filename);
}

void
GMORGAN::cb_Browse3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse3_i (o, v);
}

void
GMORGAN::cb_Browse4_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.txt)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".txt");
  PrFiname->value (filename);
  strcpy (gmo->PresetFilename, filename);
}

void
GMORGAN::cb_Browse4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse4_i (o, v);
}

void
GMORGAN::cb_Browse5_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.txt)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".txt");
  SkFiname->value (filename);
  strcpy (gmo->SkinFilename, filename);
  gmo->BuscaSkindir ();
  SkinReadNames (gmo->SkinFilename);
}

void
GMORGAN::cb_Browse5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse5_i (o, v);
}

void
GMORGAN::cb_SkinBrowser_i (Fl_Browser * o, void *)
{
  int i = (int) o->value ();
  strcpy (gmo->SkinNombre, o->text (i));
}

void
GMORGAN::cb_SkinBrowser (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_SkinBrowser_i (o, v);
}

void
GMORGAN::cb_Muoff_i (Fl_Check_Button * o, void *)
{
  gmo->MutesOnOff = (int) o->value ();
}

void
GMORGAN::cb_Muoff (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Muoff_i (o, v);
}

void
GMORGAN::cb_Browse6_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.html)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".html");
  HpFiname->value (filename);
  strcpy (gmo->HelpFilename, filename);
}

void
GMORGAN::cb_Browse6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse6_i (o, v);
}

void
GMORGAN::cb_Browse7_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.lib)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".lib");
  LStyFiname->value (filename);
  strcpy (gmo->LibStylesFilename, filename);
}

void
GMORGAN::cb_Browse7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse7_i (o, v);
}

void
GMORGAN::cb_PatternEditWin_i (Fl_Double_Window *, void *)
{
  PatternEditWin->hide ();
}

void
GMORGAN::cb_PatternEditWin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_PatternEditWin_i (o, v);
}

void
GMORGAN::cb_RtName_i (Fl_Input * o, void *)
{
  strcpy (gmo->Rt[gmo->sp].Nom, o->value ());
  char temp[512];
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s - Pattern Editor", gmo->sp, gmo->Rt[gmo->sp].Nom);
  PatternEditWin->label (temp);
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s", gmo->sp, gmo->Rt[gmo->sp].Nom);
  PtBro->text (gmo->sp, temp);
}

void
GMORGAN::cb_RtName (Fl_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_RtName_i (o, v);
}

void
GMORGAN::cb_RtBars_i (Fl_Value_Input * o, void *)
{
  gmo->Rt[gmo->sp].bars = (int) o->value ();
}

void
GMORGAN::cb_RtBars (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_RtBars_i (o, v);
}

void
GMORGAN::cb_SBar_i (Fl_Counter * o, void *)
{
  if (o->value () > gmo->Rt[gmo->sp].bars)
    o->value (gmo->Rt[gmo->sp].bars);
  gmo->sbar = (int) o->value ();
  metepattern ();
}

void
GMORGAN::cb_SBar (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_SBar_i (o, v);
}

void
GMORGAN::cb_RtNom_i (Fl_Value_Input * o, void *)
{
  gmo->Rt[gmo->sp].blackn = (int) o->value ();
  QuitaPon ();
}

void
GMORGAN::cb_RtNom (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_RtNom_i (o, v);
}

void
GMORGAN::cb_bn1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn1_i (o, v);
}

void
GMORGAN::cb_bn2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn2_i (o, v);
}

void
GMORGAN::cb_bn3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn3_i (o, v);
}

void
GMORGAN::cb_bn4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn4_i (o, v);
}

void
GMORGAN::cb_bn5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn5_i (o, v);
}

void
GMORGAN::cb_bn6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn6_i (o, v);
}

void
GMORGAN::cb_bn7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn7_i (o, v);
}

void
GMORGAN::cb_bn8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn8_i (o, v);
}

void
GMORGAN::cb_bn9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn9_i (o, v);
}

void
GMORGAN::cb_bn10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn10_i (o, v);
}

void
GMORGAN::cb_bn11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn11_i (o, v);
}

void
GMORGAN::cb_bn12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn12_i (o, v);
}

void
GMORGAN::cb_bn13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn13_i (o, v);
}

void
GMORGAN::cb_bn14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn14_i (o, v);
}

void
GMORGAN::cb_bn15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn15_i (o, v);
}

void
GMORGAN::cb_bn16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  gmo->Rt[gmo->sp].basn[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_bn16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bn16_i (o, v);
}

void
GMORGAN::cb_bl1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl1_i (o, v);
}

void
GMORGAN::cb_bl2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl2_i (o, v);
}

void
GMORGAN::cb_bl3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl3_i (o, v);
}

void
GMORGAN::cb_bl4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl4_i (o, v);
}

void
GMORGAN::cb_bl5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl5_i (o, v);
}

void
GMORGAN::cb_bl6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl6_i (o, v);
}

void
GMORGAN::cb_bl7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl7_i (o, v);
}

void
GMORGAN::cb_bl8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl8_i (o, v);
}

void
GMORGAN::cb_bl9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl9_i (o, v);
}

void
GMORGAN::cb_bl10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl10_i (o, v);
}

void
GMORGAN::cb_bl11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl11_i (o, v);
}

void
GMORGAN::cb_bl12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl12_i (o, v);
}

void
GMORGAN::cb_bl13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl13_i (o, v);
}

void
GMORGAN::cb_bl14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl14_i (o, v);
}

void
GMORGAN::cb_bl15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl15_i (o, v);
}

void
GMORGAN::cb_bl16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  gmo->Rt[gmo->sp].basn[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_bl16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bl16_i (o, v);
}

void
GMORGAN::cb_bv1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv1_i (o, v);
}

void
GMORGAN::cb_bv2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv2_i (o, v);
}

void
GMORGAN::cb_bv3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv3_i (o, v);
}

void
GMORGAN::cb_bv4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv4_i (o, v);
}

void
GMORGAN::cb_bv5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv5_i (o, v);
}

void
GMORGAN::cb_bv6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv6_i (o, v);
}

void
GMORGAN::cb_bv7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv7_i (o, v);
}

void
GMORGAN::cb_bv8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv8_i (o, v);
}

void
GMORGAN::cb_bv9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv9_i (o, v);
}

void
GMORGAN::cb_bv10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv10_i (o, v);
}

void
GMORGAN::cb_bv11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv11_i (o, v);
}

void
GMORGAN::cb_bv12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv12_i (o, v);
}

void
GMORGAN::cb_bv13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv13_i (o, v);
}

void
GMORGAN::cb_bv14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv14_i (o, v);
}

void
GMORGAN::cb_bv15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv15_i (o, v);
}

void
GMORGAN::cb_bv16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  gmo->Rt[gmo->sp].basn[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_bv16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_bv16_i (o, v);
}

void
GMORGAN::cb_CloRit_i (Fl_Button *, void *)
{
  PatternEditWin->hide ();
}

void
GMORGAN::cb_CloRit (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CloRit_i (o, v);
}

void
GMORGAN::cb_ac1l1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l1_i (o, v);
}

void
GMORGAN::cb_ac1l2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l2_i (o, v);
}

void
GMORGAN::cb_ac1l3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l3_i (o, v);
}

void
GMORGAN::cb_ac1l4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l4_i (o, v);
}

void
GMORGAN::cb_ac1l5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l5_i (o, v);
}

void
GMORGAN::cb_ac1l6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l6_i (o, v);
}

void
GMORGAN::cb_ac1l7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l7_i (o, v);
}

void
GMORGAN::cb_ac1l8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l8_i (o, v);
}

void
GMORGAN::cb_ac1l9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l9_i (o, v);
}

void
GMORGAN::cb_ac1l10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l10_i (o, v);
}

void
GMORGAN::cb_ac1l11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l11_i (o, v);
}

void
GMORGAN::cb_ac1l12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l12_i (o, v);
}

void
GMORGAN::cb_ac1l13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l13_i (o, v);
}

void
GMORGAN::cb_ac1l14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l14_i (o, v);
}

void
GMORGAN::cb_ac1l15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l15_i (o, v);
}

void
GMORGAN::cb_ac1l16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  gmo->Rt[gmo->sp].acc1n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1l16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1l16_i (o, v);
}

void
GMORGAN::cb_ac1v1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v1_i (o, v);
}

void
GMORGAN::cb_ac1v2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v2_i (o, v);
}

void
GMORGAN::cb_ac1v3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v3_i (o, v);
}

void
GMORGAN::cb_ac1v4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v4_i (o, v);
}

void
GMORGAN::cb_ac1v5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v5_i (o, v);
}

void
GMORGAN::cb_ac1v6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v6_i (o, v);
}

void
GMORGAN::cb_ac1v7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v7_i (o, v);
}

void
GMORGAN::cb_ac1v8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v8_i (o, v);
}

void
GMORGAN::cb_ac1v9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v9_i (o, v);
}

void
GMORGAN::cb_ac1v10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v10_i (o, v);
}

void
GMORGAN::cb_ac1v11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v11_i (o, v);
}

void
GMORGAN::cb_ac1v12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v12_i (o, v);
}

void
GMORGAN::cb_ac1v13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v13_i (o, v);
}

void
GMORGAN::cb_ac1v14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v14_i (o, v);
}

void
GMORGAN::cb_ac1v15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v15_i (o, v);
}

void
GMORGAN::cb_ac1v16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  gmo->Rt[gmo->sp].acc1n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac1v16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac1v16_i (o, v);
}

void
GMORGAN::cb_ac2n1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;

  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n1_i (o, v);
}

void
GMORGAN::cb_ac2n2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n2_i (o, v);
}

void
GMORGAN::cb_ac2n3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n3_i (o, v);
}

void
GMORGAN::cb_ac2n4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n4_i (o, v);
}

void
GMORGAN::cb_ac2n5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n5_i (o, v);
}

void
GMORGAN::cb_ac2n6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n6_i (o, v);
}

void
GMORGAN::cb_ac2n7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n7_i (o, v);
}

void
GMORGAN::cb_ac2n8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n8_i (o, v);
}

void
GMORGAN::cb_ac2n9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();

  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n9_i (o, v);
}

void
GMORGAN::cb_ac2n10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n10_i (o, v);
}

void
GMORGAN::cb_ac2n11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n11_i (o, v);
}

void
GMORGAN::cb_ac2n12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n12_i (o, v);
}

void
GMORGAN::cb_ac2n13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n13_i (o, v);
}

void
GMORGAN::cb_ac2n14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n14_i (o, v);
}

void
GMORGAN::cb_ac2n15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n15_i (o, v);
}

void
GMORGAN::cb_ac2n16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[0][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2n16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2n16_i (o, v);
}

void
GMORGAN::cb_ac2l1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l1_i (o, v);
}

void
GMORGAN::cb_ac2l2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l2_i (o, v);
}

void
GMORGAN::cb_ac2l3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l3_i (o, v);
}

void
GMORGAN::cb_ac2l4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l4_i (o, v);
}

void
GMORGAN::cb_ac2l5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l5_i (o, v);
}

void
GMORGAN::cb_ac2l6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l6_i (o, v);
}

void
GMORGAN::cb_ac2l7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l7_i (o, v);
}

void
GMORGAN::cb_ac2l8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l8_i (o, v);
}

void
GMORGAN::cb_ac2l9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l9_i (o, v);
}

void
GMORGAN::cb_ac2l10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l10_i (o, v);
}

void
GMORGAN::cb_ac2l11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l11_i (o, v);
}

void
GMORGAN::cb_ac2l12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l12_i (o, v);
}

void
GMORGAN::cb_ac2l13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l13_i (o, v);
}

void
GMORGAN::cb_ac2l14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l14_i (o, v);
}

void
GMORGAN::cb_ac2l15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l15_i (o, v);
}

void
GMORGAN::cb_ac2l16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[2][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2l16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2l16_i (o, v);
}

void
GMORGAN::cb_ac2v1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v1_i (o, v);
}

void
GMORGAN::cb_ac2v2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v2_i (o, v);
}

void
GMORGAN::cb_ac2v3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v3_i (o, v);
}

void
GMORGAN::cb_ac2v4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v4_i (o, v);
}

void
GMORGAN::cb_ac2v5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v5_i (o, v);
}

void
GMORGAN::cb_ac2v6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v6_i (o, v);
}

void
GMORGAN::cb_ac2v7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v7_i (o, v);
}

void
GMORGAN::cb_ac2v8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v8_i (o, v);
}

void
GMORGAN::cb_ac2v9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v9_i (o, v);
}

void
GMORGAN::cb_ac2v10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v10_i (o, v);
}

void
GMORGAN::cb_ac2v11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v11_i (o, v);
}

void
GMORGAN::cb_ac2v12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v12_i (o, v);
}

void
GMORGAN::cb_ac2v13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v13_i (o, v);
}

void
GMORGAN::cb_ac2v14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v14_i (o, v);
}

void
GMORGAN::cb_ac2v15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v15_i (o, v);
}

void
GMORGAN::cb_ac2v16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2n[1][pos] = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac2v16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac2v16_i (o, v);
}

void
GMORGAN::cb_Copy_i (Fl_Button *, void *)
{
  prepcopy ();
  CopyWin->position (1, 1);
  CopyWin->show ();
}

void
GMORGAN::cb_Copy (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy_i (o, v);
}

void
GMORGAN::cb_Copy1_i (Fl_Button *, void *)
{
  gmo->selcopy = 0;
  CopyBWin->position (1, 1);
  CopyBWin->show ();
}

void
GMORGAN::cb_Copy1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy1_i (o, v);
}

void
GMORGAN::cb_Copy2_i (Fl_Button *, void *)
{
  gmo->selcopy = 3;
  CopyBWin->position (1, 1);
  CopyBWin->show ();
}

void
GMORGAN::cb_Copy2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy2_i (o, v);
}

void
GMORGAN::cb_Copy3_i (Fl_Button *, void *)
{
  gmo->selcopy = 1;
  CopyBWin->position (1, 1);
  CopyBWin->show ();
}

void
GMORGAN::cb_Copy3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy3_i (o, v);
}

void
GMORGAN::cb_Copy4_i (Fl_Button *, void *)
{
  if (gmo->DosCuatro == 2)
    gmo->selcopy = 2;
  if (gmo->DosCuatro == 4)
    gmo->selcopy = 8;
  CopyBWin->position (1, 1);
  CopyBWin->show ();
}

void
GMORGAN::cb_Copy4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy4_i (o, v);
}

void
GMORGAN::cb_RtSwing_i (Fl_Value_Input * o, void *)
{
  gmo->Rt[gmo->sp].swing = (int) o->value ();
}

void
GMORGAN::cb_RtSwing (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_RtSwing_i (o, v);
}

void
GMORGAN::cb_RtAcc2Mode_i (Fl_Value_Input * o, void *)
{
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2mode = (int) o->value ();

  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4mode = (int) o->value ();
}

void
GMORGAN::cb_RtAcc2Mode (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_RtAcc2Mode_i (o, v);
}

void
GMORGAN::cb_RtAcc3Mode_i (Fl_Value_Input * o, void *)
{
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3mode = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5mode = (int) o->value ();
}

void
GMORGAN::cb_RtAcc3Mode (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_RtAcc3Mode_i (o, v);
}

void
GMORGAN::cb_Copy5_i (Fl_Button *, void *)
{
  if (gmo->TresCinco == 3)
    gmo->selcopy = 6;
  if (gmo->TresCinco == 5)
    gmo->selcopy = 9;
  CopyBWin->position (1, 1);
  CopyBWin->show ();
}

void
GMORGAN::cb_Copy5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy5_i (o, v);
}

void
GMORGAN::cb_ac3n1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n1_i (o, v);
}

void
GMORGAN::cb_ac3n2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n2_i (o, v);
}

void
GMORGAN::cb_ac3n3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n3_i (o, v);
}

void
GMORGAN::cb_ac3n4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n4_i (o, v);
}

void
GMORGAN::cb_ac3n5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n5_i (o, v);
}

void
GMORGAN::cb_ac3n6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n6_i (o, v);
}

void
GMORGAN::cb_ac3n7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n7_i (o, v);
}

void
GMORGAN::cb_ac3n8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n8_i (o, v);
}

void
GMORGAN::cb_ac3n9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n9_i (o, v);
}

void
GMORGAN::cb_ac3n10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n10_i (o, v);
}

void
GMORGAN::cb_ac3n11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n11_i (o, v);
}

void
GMORGAN::cb_ac3n12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n12_i (o, v);
}

void
GMORGAN::cb_ac3n13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n13_i (o, v);
}

void
GMORGAN::cb_ac3n14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n14_i (o, v);
}

void
GMORGAN::cb_ac3n15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n15_i (o, v);
}

void
GMORGAN::cb_ac3n16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[0][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[0][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3n16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3n16_i (o, v);
}

void
GMORGAN::cb_ac3l1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l1_i (o, v);
}

void
GMORGAN::cb_ac3l2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l2_i (o, v);
}

void
GMORGAN::cb_ac3l3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l3_i (o, v);
}

void
GMORGAN::cb_ac3l4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l4_i (o, v);
}

void
GMORGAN::cb_ac3l5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l5_i (o, v);
}

void
GMORGAN::cb_ac3l6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l6_i (o, v);
}

void
GMORGAN::cb_ac3l7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l7_i (o, v);
}

void
GMORGAN::cb_ac3l8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l8_i (o, v);
}

void
GMORGAN::cb_ac3l9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l9_i (o, v);
}

void
GMORGAN::cb_ac3l10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l10_i (o, v);
}

void
GMORGAN::cb_ac3l11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l11_i (o, v);
}

void
GMORGAN::cb_ac3l12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l12_i (o, v);
}

void
GMORGAN::cb_ac3l13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l13_i (o, v);
}

void
GMORGAN::cb_ac3l14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l14_i (o, v);
}

void
GMORGAN::cb_ac3l15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l15_i (o, v);
}

void
GMORGAN::cb_ac3l16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[2][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[2][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3l16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3l16_i (o, v);
}

void
GMORGAN::cb_ac3v1_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 1;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v1_i (o, v);
}

void
GMORGAN::cb_ac3v2_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 2;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v2 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v2_i (o, v);
}

void
GMORGAN::cb_ac3v3_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 3;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v3 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v3_i (o, v);
}

void
GMORGAN::cb_ac3v4_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 4;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v4 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v4_i (o, v);
}

void
GMORGAN::cb_ac3v5_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 5;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v5 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v5_i (o, v);
}

void
GMORGAN::cb_ac3v6_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 6;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v6 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v6_i (o, v);
}

void
GMORGAN::cb_ac3v7_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 7;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v7 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v7_i (o, v);
}

void
GMORGAN::cb_ac3v8_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 8;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v8 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v8_i (o, v);
}

void
GMORGAN::cb_ac3v9_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 9;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v9 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v9_i (o, v);
}

void
GMORGAN::cb_ac3v10_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 10;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v10 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v10_i (o, v);
}

void
GMORGAN::cb_ac3v11_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 11;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v11 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v11_i (o, v);
}

void
GMORGAN::cb_ac3v12_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 12;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v12 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v12_i (o, v);
}

void
GMORGAN::cb_ac3v13_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 13;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v13 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v13_i (o, v);
}

void
GMORGAN::cb_ac3v14_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 14;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v14 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v14_i (o, v);
}

void
GMORGAN::cb_ac3v15_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 15;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v15 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v15_i (o, v);
}

void
GMORGAN::cb_ac3v16_i (Fl_Value_Input * o, void *)
{
  int pos;
  pos = ((gmo->sbar - 1) * (4 * gmo->Rt[gmo->sp].blackn)) + 16;
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3n[1][pos] = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5n[1][pos] = (int) o->value ();
}

void
GMORGAN::cb_ac3v16 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ac3v16_i (o, v);
}

void
GMORGAN::cb_Global_i (Fl_Button *, void *)
{
  if (gmo->dredit)
    return;
  gmo->PonDrumTemp (gmo->sp);
  gmo->dredit = 1;
  make_window_drum ();
  make_drum_edit ();
}

void
GMORGAN::cb_Global (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Global_i (o, v);
}

void
GMORGAN::cb_Poc_i (Fl_Button * o, void *)
{
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].octavate = (int) o->value ();

  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].octavate4 = (int) o->value ();
}

void
GMORGAN::cb_Poc (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Poc_i (o, v);
}

void
GMORGAN::cb_Pterc_i (Fl_Button * o, void *)
{
  if (gmo->DosCuatro == 2)
    {
      gmo->Rt[gmo->sp].terceras = (int) o->value ();
      gmo->Rt[gmo->sp].sextas = 0;
    }

  if (gmo->DosCuatro == 4)
    {
      gmo->Rt[gmo->sp].terceras4 = (int) o->value ();
      gmo->Rt[gmo->sp].sextas4 = 0;
    };
}

void
GMORGAN::cb_Pterc (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Pterc_i (o, v);
}

void
GMORGAN::cb_Psext_i (Fl_Button * o, void *)
{
  if (gmo->DosCuatro == 2)
    {
      gmo->Rt[gmo->sp].sextas = (int) o->value ();
      gmo->Rt[gmo->sp].terceras = 0;
    }

  if (gmo->DosCuatro == 4)
    {
      gmo->Rt[gmo->sp].sextas4 = (int) o->value ();
      gmo->Rt[gmo->sp].terceras4 = 0;
    };
}

void
GMORGAN::cb_Psext (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Psext_i (o, v);
}

void
GMORGAN::cb_Punison_i (Fl_Button * o, void *)
{
  int i = (int) o->value ();


  if (i)
    {

      if (gmo->DosCuatro == 2)
	{
	  gmo->Rt[gmo->sp].terceras = 0;
	  gmo->Rt[gmo->sp].sextas = 0;
	}

      if (gmo->DosCuatro == 4)
	{
	  gmo->Rt[gmo->sp].terceras4 = 0;
	  gmo->Rt[gmo->sp].sextas4 = 0;
	}

    };
}

void
GMORGAN::cb_Punison (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Punison_i (o, v);
}

void
GMORGAN::cb_Clear_i (Fl_Button *, void *)
{
  char temp[512];
  gmo->patternclear (gmo->sp);
  PatternEditWin->hide ();
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  EditPattern (gmo->sp);
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s", gmo->sp, gmo->Rt[gmo->sp].Nom);
  PtBro->text (gmo->sp, temp);
}

void
GMORGAN::cb_Clear (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear_i (o, v);
}

void
GMORGAN::cb_Clear1_i (Fl_Button *, void *)
{
  int j;
  int i = ((gmo->sbar - 1) * (gmo->Rt[gmo->sp].blackn * 4)) + 1;
  for (j = 0; j <= gmo->Rt[gmo->sp].blackn * 4; j++)

    {
      gmo->Rt[gmo->sp].basn[0][i + j] = 0;
      gmo->Rt[gmo->sp].basn[2][i + j] = 0;
      gmo->Rt[gmo->sp].basn[1][i + j] = 0;
    }

  metepattern ();
}

void
GMORGAN::cb_Clear1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear1_i (o, v);
}

void
GMORGAN::cb_Clear2_i (Fl_Button *, void *)
{
  int j;
  int i = ((gmo->sbar - 1) * (gmo->Rt[gmo->sp].blackn * 4)) + 1;
  for (j = 0; j <= gmo->Rt[gmo->sp].blackn * 4; j++)

    {
      if (gmo->DosCuatro == 2)
	{
	  gmo->Rt[gmo->sp].acc2n[0][i + j] = 0;
	  gmo->Rt[gmo->sp].acc2n[2][i + j] = 0;
	  gmo->Rt[gmo->sp].acc2n[1][i + j] = 0;
	}
      if (gmo->DosCuatro == 4)
	{
	  gmo->Rt[gmo->sp].acc4n[0][i + j] = 0;
	  gmo->Rt[gmo->sp].acc4n[2][i + j] = 0;
	  gmo->Rt[gmo->sp].acc4n[1][i + j] = 0;
	}
    }

  metepattern ();
}

void
GMORGAN::cb_Clear2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear2_i (o, v);
}

void
GMORGAN::cb_Clear3_i (Fl_Button *, void *)
{
  int j;
  int i = ((gmo->sbar - 1) * (gmo->Rt[gmo->sp].blackn * 4)) + 1;
  for (j = 0; j <= gmo->Rt[gmo->sp].blackn * 4; j++)

    {
      if (gmo->TresCinco == 3)
	{
	  gmo->Rt[gmo->sp].acc3n[0][i + j] = 0;
	  gmo->Rt[gmo->sp].acc3n[2][i + j] = 0;
	  gmo->Rt[gmo->sp].acc3n[1][i + j] = 0;
	}
      if (gmo->TresCinco == 5)
	{
	  gmo->Rt[gmo->sp].acc5n[0][i + j] = 0;
	  gmo->Rt[gmo->sp].acc5n[2][i + j] = 0;
	  gmo->Rt[gmo->sp].acc5n[1][i + j] = 0;
	}
    }

  metepattern ();
}

void
GMORGAN::cb_Clear3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear3_i (o, v);
}

void
GMORGAN::cb_Clear4_i (Fl_Button *, void *)
{
  int j;
  int i = ((gmo->sbar - 1) * (gmo->Rt[gmo->sp].blackn * 4)) + 1;
  for (j = 0; j <= gmo->Rt[gmo->sp].blackn * 4; j++)

    {
      gmo->Rt[gmo->sp].acc1n[0][i + j] = 0;
      gmo->Rt[gmo->sp].acc1n[1][i + j] = 0;
    }

  metepattern ();
}

void
GMORGAN::cb_Clear4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear4_i (o, v);
}

void
GMORGAN::cb_HelpRit_i (Fl_Button *, void *)
{
  makehelp ();
  HelpEdit->show ();
}

void
GMORGAN::cb_HelpRit (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_HelpRit_i (o, v);
}

void
GMORGAN::cb_Sacc2_i (Fl_Button *, void *)
{
  gmo->DosCuatro = 2;
  metepattern ();
}

void
GMORGAN::cb_Sacc2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Sacc2_i (o, v);
}

void
GMORGAN::cb_Sacc4_i (Fl_Button *, void *)
{
  gmo->DosCuatro = 4;
  metepattern ();
}

void
GMORGAN::cb_Sacc4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Sacc4_i (o, v);
}

void
GMORGAN::cb_Sacc3_i (Fl_Button *, void *)
{
  gmo->TresCinco = 3;
  metepattern ();
}

void
GMORGAN::cb_Sacc3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Sacc3_i (o, v);
}

void
GMORGAN::cb_Sacc5_i (Fl_Button *, void *)
{
  gmo->TresCinco = 5;
  metepattern ();
}

void
GMORGAN::cb_Sacc5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Sacc5_i (o, v);
}

void
GMORGAN::cb_STLTAcc24_i (Fl_Slider * o, void *)
{
  if (gmo->DosCuatro == 2)
    gmo->Rt[gmo->sp].acc2stlt = (int) o->value ();
  if (gmo->DosCuatro == 4)
    gmo->Rt[gmo->sp].acc4stlt = (int) o->value ();
}

void
GMORGAN::cb_STLTAcc24 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_STLTAcc24_i (o, v);
}

void
GMORGAN::cb_STLTAcc35_i (Fl_Slider * o, void *)
{
  if (gmo->TresCinco == 3)
    gmo->Rt[gmo->sp].acc3stlt = (int) o->value ();
  if (gmo->TresCinco == 5)
    gmo->Rt[gmo->sp].acc5stlt = (int) o->value ();
}

void
GMORGAN::cb_STLTAcc35 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_STLTAcc35_i (o, v);
}

void
GMORGAN::cb_STLTAcc1_i (Fl_Slider * o, void *)
{
  gmo->Rt[gmo->sp].acc1stlt = (int) o->value ();
}

void
GMORGAN::cb_STLTAcc1 (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_STLTAcc1_i (o, v);
}

void
GMORGAN::cb_STLTBass_i (Fl_Slider * o, void *)
{
  gmo->Rt[gmo->sp].bassstlt = (int) o->value ();
}

void
GMORGAN::cb_STLTBass (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_STLTBass_i (o, v);
}

void
GMORGAN::cb_Control_i (Fl_Button *, void *)
{
  if (gmo->ctrledit)
    return;
  gmo->ctrledit = 1;
  make_ctrl_window ();
  make_ctrl_edit ();
}

void
GMORGAN::cb_Control (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Control_i (o, v);
}

void
GMORGAN::cb_EO_i (Fl_Counter * o, void *)
{
  gmo->octa[gmo->selmix] = (int) o->value ();
  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    {
      switch (gmo->selmix)
	{
	case 5:
	  gmo->Rt[gmo->sp].acc1octa = (int) o->value ();
	  break;
	case 6:
	  gmo->Rt[gmo->sp].acc2octa = (int) o->value ();
	  break;
	case 7:
	  gmo->Rt[gmo->sp].bassocta = (int) o->value ();
	  break;
	case 8:
	  gmo->Rt[gmo->sp].drocta = (int) o->value ();
	  break;
	case 9:
	  gmo->Rt[gmo->sp].acc3octa = (int) o->value ();
	  break;
	case 10:
	  gmo->Rt[gmo->sp].acc4octa = (int) o->value ();
	  break;
	case 11:
	  gmo->Rt[gmo->sp].acc5octa = (int) o->value ();
	  break;
	}
    };
}

void
GMORGAN::cb_EO (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EO_i (o, v);
}

void
GMORGAN::cb_EBM_i (Fl_Counter * o, void *)
{
  gmo->BankMSB[gmo->selmix] = (int) o->value ();
  gmo->enviocontrol (gmo->selmix, 0, gmo->TMch[gmo->selmix]);

  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    {
      switch (gmo->selmix)
	{
	case 1:
	  P1->label (gmo->PresetList[gmo->CalculaBanco (1)].
		     PBanco[gmo->progch[1]].ProgName);
	  break;
	case 2:
	  P2->label (gmo->PresetList[gmo->CalculaBanco (2)].
		     PBanco[gmo->progch[2]].ProgName);
	  break;
	case 3:
	  P3->label (gmo->PresetList[gmo->CalculaBanco (3)].
		     PBanco[gmo->progch[3]].ProgName);
	  break;
	case 4:
	  P4->label (gmo->PresetList[gmo->CalculaBanco (4)].
		     PBanco[gmo->progch[4]].ProgName);
	  break;
	case 5:
	  P5->label (gmo->PresetList[gmo->CalculaBanco (5)].
		     PBanco[gmo->progch[5]].ProgName);
	  gmo->Rt[gmo->sp].acc1BankM = (int) o->value ();
	  break;
	case 6:
	  P6->label (gmo->PresetList[gmo->CalculaBanco (6)].
		     PBanco[gmo->progch[6]].ProgName);
	  gmo->Rt[gmo->sp].acc2BankM = (int) o->value ();
	  break;
	case 7:
	  P7->label (gmo->PresetList[gmo->CalculaBanco (7)].
		     PBanco[gmo->progch[7]].ProgName);
	  gmo->Rt[gmo->sp].bassBankM = (int) o->value ();
	  break;
	case 8:
	  P8->label (gmo->PresetList[gmo->CalculaBanco (8)].
		     PBanco[gmo->progch[8]].ProgName);
	  gmo->Rt[gmo->sp].drBankM = (int) o->value ();
	  break;
	case 9:
	  P9->label (gmo->PresetList[gmo->CalculaBanco (9)].
		     PBanco[gmo->progch[9]].ProgName);
	  gmo->Rt[gmo->sp].acc3BankM = (int) o->value ();
	  break;
	case 10:
	  P10->label (gmo->PresetList[gmo->CalculaBanco (10)].
		      PBanco[gmo->progch[10]].ProgName);
	  gmo->Rt[gmo->sp].acc4BankM = (int) o->value ();
	  break;
	case 11:
	  P11->label (gmo->PresetList[gmo->CalculaBanco (11)].
		      PBanco[gmo->progch[11]].ProgName);
	  gmo->Rt[gmo->sp].acc5BankM = (int) o->value ();
	  break;
	}
    };
}

void
GMORGAN::cb_EBM (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EBM_i (o, v);
}

void
GMORGAN::cb_EPtime_i (Fl_Counter * o, void *)
{
  gmo->Ptime[gmo->selmix] = (int) o->value ();
  gmo->enviocontrol (gmo->selmix, 5, gmo->TMch[gmo->selmix]);
  gmo->enviocontrol (gmo->selmix, 37, gmo->TMch[gmo->selmix]);
}

void
GMORGAN::cb_EPtime (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EPtime_i (o, v);
}

void
GMORGAN::cb_EPon_i (Fl_Button * o, void *)
{
  gmo->Pon[gmo->selmix] = (int) o->value ();
  if (o->value () == 0)
    gmo->Pon[gmo->selmix] = (int) o->value ();
  else
    gmo->Pon[gmo->selmix] = 64;
  gmo->enviocontrol (gmo->selmix, 65, gmo->TMch[gmo->selmix]);
}

void
GMORGAN::cb_EPon (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EPon_i (o, v);
}

void
GMORGAN::cb_Close_i (Fl_Button *, void *)
{
  ExtraPWin->hide ();
  Fl::focus (StartStop);
}

void
GMORGAN::cb_Close (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Close_i (o, v);
}

void
GMORGAN::cb_EBL_i (Fl_Counter * o, void *)
{
  gmo->BankLSB[gmo->selmix] = (int) o->value ();
  gmo->enviocontrol (gmo->selmix, 32, gmo->TMch[gmo->selmix]);

  if ((gmo->reproduccion == 0) && (gmo->grabacion == 0))
    {
      switch (gmo->selmix)
	{
	case 1:
	  P1->label (gmo->PresetList[gmo->CalculaBanco (1)].
		     PBanco[gmo->progch[1]].ProgName);
	  break;
	case 2:
	  P2->label (gmo->PresetList[gmo->CalculaBanco (2)].
		     PBanco[gmo->progch[2]].ProgName);
	  break;
	case 3:
	  P3->label (gmo->PresetList[gmo->CalculaBanco (3)].
		     PBanco[gmo->progch[3]].ProgName);
	  break;
	case 4:
	  P4->label (gmo->PresetList[gmo->CalculaBanco (4)].
		     PBanco[gmo->progch[4]].ProgName);
	  break;
	case 5:
	  P5->label (gmo->PresetList[gmo->CalculaBanco (5)].
		     PBanco[gmo->progch[5]].ProgName);
	  break;
	case 6:
	  P6->label (gmo->PresetList[gmo->CalculaBanco (6)].
		     PBanco[gmo->progch[6]].ProgName);
	  break;
	case 7:
	  P7->label (gmo->PresetList[gmo->CalculaBanco (7)].
		     PBanco[gmo->progch[7]].ProgName);
	  break;
	case 8:
	  P8->label (gmo->PresetList[gmo->CalculaBanco (8)].
		     PBanco[gmo->progch[8]].ProgName);
	  break;
	case 9:
	  P9->label (gmo->PresetList[gmo->CalculaBanco (9)].
		     PBanco[gmo->progch[9]].ProgName);
	  break;
	case 10:
	  P10->label (gmo->PresetList[gmo->CalculaBanco (10)].
		      PBanco[gmo->progch[10]].ProgName);
	  break;
	case 11:
	  P11->label (gmo->PresetList[gmo->CalculaBanco (11)].
		      PBanco[gmo->progch[11]].ProgName);
	  break;

	}
    };
}

void
GMORGAN::cb_EBL (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EBL_i (o, v);
}

void
GMORGAN::cb_Copy6_i (Fl_Button *, void *)
{
  int patron;
  patron = (int) CPtBro->value ();
  gmo->Rt[gmo->sp] = gmo->Rt[patron];
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  char temp[512];
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s", gmo->sp, gmo->Rt[gmo->sp].Nom);
  PtBro->text (gmo->sp, temp);
  PatternEditWin->hide ();
  EditPattern (gmo->sp);
  CopyWin->hide ();
}

void
GMORGAN::cb_Copy6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy6_i (o, v);
}

void
GMORGAN::cb_Cancel_i (Fl_Button *, void *)
{
  CopyWin->hide ();
}

void
GMORGAN::cb_Cancel (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel_i (o, v);
}

void
GMORGAN::cb_Copy7_i (Fl_Button *, void *)
{
  int cc = (int) SBCopy->value ();
  if (cc < 1)
    {
      fl_alert (gettext ("Bar not exist"));
      return;
    }
  if (cc > gmo->Rt[gmo->sp].bars)
    {
      fl_alert (gettext ("Bar not exist"));
      return;
    }
  gmo->copy1 (cc);

  metepattern ();
  CopyBWin->hide ();
}

void
GMORGAN::cb_Copy7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy7_i (o, v);
}

void
GMORGAN::cb_Cancel1_i (Fl_Button *, void *)
{
  CopyBWin->hide ();
}

void
GMORGAN::cb_Cancel1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel1_i (o, v);
}

void
GMORGAN::cb_BankBro_i (Fl_Browser *, void *)
{
  if (Fl::event_button () == 3)
    {
      gmo->ss = (int) BankBro->value ();
      GetCombi (gmo->ss);
    }

  if (Fl::event_button () == 1)
    {
      gmo->ss = (int) BankBro->value ();
      ProSlider->value (gmo->ss);
      PutCombi (gmo->ss);
    };
}

void
GMORGAN::cb_BankBro (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BankBro_i (o, v);
}

void
GMORGAN::cb_CloBank_i (Fl_Button *, void *)
{
  BankWin->hide ();
}

void
GMORGAN::cb_CloBank (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CloBank_i (o, v);
}

void
GMORGAN::cb_StyleWin_i (Fl_Double_Window *, void *)
{
  gmo->Styl[gmo->st].bpm = gmo->bpm;
}

void
GMORGAN::cb_StyleWin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_StyleWin_i (o, v);
}

void
GMORGAN::cb_Intro_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].Intro = EPtBro->value ();
  STI->label (gmo->Rt[EPtBro->value ()].Nom);
  gmo->Intro = EPtBro->value ();
}

void
GMORGAN::cb_Intro (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Intro_i (o, v);
}

void
GMORGAN::cb_Var1_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].Var1 = EPtBro->value ();
  gmo->Styl[gmo->st].startP = gmo->Styl[gmo->st].Var1;
  STV1->label (gmo->Rt[EPtBro->value ()].Nom);
  gmo->sp = (int) EPtBro->value ();
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  PVar1->setonly ();
  gmo->Var1 = EPtBro->value ();
}

void
GMORGAN::cb_Var1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Var1_i (o, v);
}

void
GMORGAN::cb_Var2_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].Var2 = EPtBro->value ();
  STV2->label (gmo->Rt[EPtBro->value ()].Nom);
  gmo->Var2 = EPtBro->value ();
}

void
GMORGAN::cb_Var2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Var2_i (o, v);
}

void
GMORGAN::cb_Fill1_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].Fill1 = EPtBro->value ();
  STF1->label (gmo->Rt[EPtBro->value ()].Nom);
  gmo->Fill1 = EPtBro->value ();
}

void
GMORGAN::cb_Fill1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Fill1_i (o, v);
}

void
GMORGAN::cb_Fill2_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].Fill2 = EPtBro->value ();
  STF2->label (gmo->Rt[EPtBro->value ()].Nom);
  gmo->Fill2 = EPtBro->value ();
}

void
GMORGAN::cb_Fill2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Fill2_i (o, v);
}

void
GMORGAN::cb_Ending_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].Ending = EPtBro->value ();
  STE->label (gmo->Rt[EPtBro->value ()].Nom);
  gmo->Ending = EPtBro->value ();
}

void
GMORGAN::cb_Ending (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Ending_i (o, v);
}

void
GMORGAN::cb_CloSty_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].bpm = gmo->bpm;
  StyleWin->hide ();
}

void
GMORGAN::cb_CloSty (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CloSty_i (o, v);
}

void
GMORGAN::cb_NombreSt_i (Fl_Input * o, void *)
{
  strcpy (gmo->Styl[gmo->st].Nom, o->value ());
  char temp[512];
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s - Style Editor", gmo->st, gmo->Styl[gmo->st].Nom);
  StyleWin->label (temp);
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s", gmo->st, gmo->Styl[gmo->st].Nom);
  StBro->text (gmo->st, temp);
  STY1->label ("");
  STY1->label (gmo->Styl[gmo->st].Nom);
}

void
GMORGAN::cb_NombreSt (Fl_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_NombreSt_i (o, v);
}

void
GMORGAN::cb_SPrograma_i (Fl_Button *, void *)
{
  gmo->Styl[gmo->st].programa = EPrBro->value ();
  SPr->label (gmo->Prog[EPrBro->value ()].Nom);
  gmo->ss = EPrBro->value ();
  PutCombi (gmo->ss);
}

void
GMORGAN::cb_SPrograma (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_SPrograma_i (o, v);
}

void
GMORGAN::cb_Copy8_i (Fl_Button *, void *)
{
  int cc = (int) SB2Copy->value ();
  int gg = (int) SB2TCopy->value ();
  if ((cc < 1) || (gg < 1))
    {
      fl_alert (gettext ("Bar does not exist"));
      return;
    }
  if ((cc > gmo->Rt[gmo->sp].bars) || (gg > gmo->Rt[gmo->sp].bars))
    {
      fl_alert (gettext ("Bar does not exist"));
      return;
    }
  gmo->copy2 (cc, gg);
// restore table. rlv
//    cout << "restore table cb_Copy8_i " << endl;
    for (int c = 1; c < MAX_COLS; c++)
      for (int r = 1; r < MAX_ROWS; r++)
	{
	values[r-1][c-1] = (Edr[r][c]);		// initialize cells
	}
// rlv
      DrumEditBox->hide ();
      make_drum_edit ();

  if ((gmo->selcopy == 4) || (gmo->selcopy == 5))
    {
      DrumEditBox->hide ();
      make_drum_edit ();
//      CopyB2Win->hide ();
    }

  if ((gmo->selcopy == 14) || (gmo->selcopy == 15))
    {
      CtrlEditBox->hide ();
      make_ctrl_edit ();
//      CopyB2Win->hide ();
    };
}

void
GMORGAN::cb_Copy8 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy8_i (o, v);
}

void
GMORGAN::cb_Cancel2_i (Fl_Button *, void *)
{
  CopyB2Win->hide ();
}

void
GMORGAN::cb_Cancel2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel2_i (o, v);
}

void
GMORGAN::cb_HelpEdit_i (Fl_Double_Window *, void *)
{
  HelpEdit->hide ();
}

void
GMORGAN::cb_HelpEdit (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_HelpEdit_i (o, v);
}

void
GMORGAN::cb_Value_i (Fl_Box *, void *)
{
  ;
}

void
GMORGAN::cb_Value (Fl_Box * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Value_i (o, v);
}

void
GMORGAN::cb_Close1_i (Fl_Button *, void *)
{
  HelpEdit->hide ();
}

void
GMORGAN::cb_Close1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Close1_i (o, v);
}

void
GMORGAN::cb_SongCopyWin_i (Fl_Double_Window *, void *)
{
  SongCopyWin->hide ();
}

void
GMORGAN::cb_SongCopyWin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_SongCopyWin_i (o, v);
}

void
GMORGAN::cb_Ok_i (Fl_Button *, void *)
{
  int i, j, k;
  k = (int) CopySPut->value ();
  j = 0;
  for (i = (int) CopySFrom->value (); i <= (int) CopySTo->value (); i++)
    {

      if ((k + j) <= 128)
	{
	  strcpy (S[k + j].ch1, S[i].ch1);
	  strcpy (S[k + j].ch2, S[i].ch2);
	  strcpy (S[k + j].ch3, S[i].ch3);
	  strcpy (S[k + j].ch4, S[i].ch4);
	  S[k + j].pattern = S[i].pattern;
	  j++;
	}
    }

  SongCopyWin->hide ();
  BPEWin->hide ();
  make_bp ();
}

void
GMORGAN::cb_Ok (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Ok_i (o, v);
}

void
GMORGAN::cb_Cancel3_i (Fl_Button *, void *)
{
  SongCopyWin->hide ();
}

void
GMORGAN::cb_Cancel3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel3_i (o, v);
}

void
GMORGAN::cb_SongClearWin_i (Fl_Double_Window *, void *)
{
  SongClearWin->hide ();
}

void
GMORGAN::cb_SongClearWin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_SongClearWin_i (o, v);
}

void
GMORGAN::cb_Ok1_i (Fl_Button *, void *)
{
  int i;

  for (i = (int) ClearSFrom->value (); i <= (int) ClearSTo->value (); i++)
    {


      bzero (S[i].ch1, sizeof (S[i].ch1));
      bzero (S[i].ch2, sizeof (S[i].ch2));
      bzero (S[i].ch3, sizeof (S[i].ch3));
      bzero (S[i].ch4, sizeof (S[i].ch4));
      S[i].pattern = 0;
      S[i].a = 0;
      S[i].b = 0;
      S[i].c = 0;
      S[i].d = 0;
      S[i].e = 0;
      S[i].f = 0;
      S[i].g = 0;
      S[i].h = 0;
      S[i].times = 0;
      S[i].atimes = 0;
      S[i].fin = 0;
      bzero (S[i].go_to, sizeof (S[i].go_to));
      bzero (S[i].go_af, sizeof (S[i].go_af));



    }

  SongClearWin->hide ();
  BPEWin->hide ();
  make_bp ();
}

void
GMORGAN::cb_Ok1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Ok1_i (o, v);
}

void
GMORGAN::cb_Cancel4_i (Fl_Button *, void *)
{
  SongClearWin->hide ();
}

void
GMORGAN::cb_Cancel4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel4_i (o, v);
}
/*
void
GMORGAN::cb_EntradaK_i (MiValueInput * o, void *)
*/
void
GMORGAN::cb_FunnyWin_i (Fl_Double_Window *, void *)
{
  int i;
//  i = Fl::event ();
  i = Fl::event_key ();
  gmo->panico (0, 15);
  gmo->KeybON = 0;
  FunnyWin->hide ();
}

void
GMORGAN::cb_FunnyWin (Fl_Double_Window * o, void *v)
{
  int i;
  i = Fl::event ();
  ((GMORGAN *) (o->user_data ()))->cb_FunnyWin_i (o, v);
}
/*
int
MiFunnyWin::handle (int event)
{
  int i;
  switch (event)
    {
    case FL_SHORTCUT:
      {
	return 0;
	break;
      }
    case FL_KEYDOWN:
      {
 	i = Fl::event_key ();
	cout << "Funnywin keydown " << i << endl;
	do_callback ();
	return 1;
	break;
      }

    default:
      return 1;
    }
}
*/
void
GMORGAN::cb_DoC_i (Fl_Button *, void *)
{
  int i;
//  i = Fl::event ();
  i = Fl::event_key ();
  char enote[4];
  strcpy (enote, "C");
  EventProcessor (enote);
}

void
GMORGAN::cb_DoC (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DoC_i (o, v);
}

void
GMORGAN::cb_D_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "D");
  EventProcessor (enote);
}

void
GMORGAN::cb_D (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_D_i (o, v);
}

void
GMORGAN::cb_E_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "E");
  EventProcessor (enote);
}

void
GMORGAN::cb_E (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_E_i (o, v);
}

void
GMORGAN::cb_F_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "F");
  EventProcessor (enote);
}

void
GMORGAN::cb_F (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_F_i (o, v);
}

void
GMORGAN::cb_G_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "G");
  EventProcessor (enote);
}

void
GMORGAN::cb_G (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_G_i (o, v);
}

void
GMORGAN::cb_A_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "A");
  EventProcessor (enote);
}

void
GMORGAN::cb_A (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_A_i (o, v);
}

void
GMORGAN::cb_B_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "B");
  EventProcessor (enote);
}

void
GMORGAN::cb_B (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_B_i (o, v);
}

// mouse settings.
void
GMORGAN::EventProcessor (char fundamental[4])
{
  int i;

  strcpy (KbChordSymbol, fundamental);
  if (Fl::event_button () == 1)
    {
      strcat (KbChordSymbol, "Maj7");
    }
  if (Fl::event_button () == 3)
    {
      strcat (KbChordSymbol, "m7");
    }

  if (Fl::event_state (FL_SHIFT) != 0)
    {
      if (Fl::event_button () == 1)
	{
	  strcpy (KbChordSymbol, fundamental);
	  strcat (KbChordSymbol, "7");
	}
      if (Fl::event_button () == 3)
	{
	  strcpy (KbChordSymbol, fundamental);
	  strcat (KbChordSymbol, "6");
	}
    }
  if (Fl::event_state (FL_CTRL) != 0)
    {
      if (Fl::event_button () == 1)
	{
	  strcpy (KbChordSymbol, fundamental);
	  strcat (KbChordSymbol, "m7(b5)");
	}
      if (Fl::event_button () == 3)
	{
	  strcpy (KbChordSymbol, fundamental);
	  strcat (KbChordSymbol, "sus4");
	}
    }
  if (Fl::event_state (FL_ALT) != 0)
    {
      if (Fl::event_button () == 1)
	{
	  strcpy (KbChordSymbol, fundamental);
	  strcat (KbChordSymbol, "+7");
	}
      if (Fl::event_button () == 3)
	{
	  strcpy (KbChordSymbol, fundamental);
	  {
	    strcat (KbChordSymbol, "dim7");
	  }
	}
    }
//bookmark
  strcpy (AName, KbChordSymbol);
  strcpy (NombreAcorde, AName);
  cambialo = 1;
  FunnyWin->redraw ();
  Fl::focus (DoC);
}

void
GMORGAN::cb_Do_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "C");
  EventProcessor (enote);
}

void
GMORGAN::cb_Do (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Do_i (o, v);
}

void
GMORGAN::cb_1_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "D");
  EventProcessor (enote);
}

void
GMORGAN::cb_1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_1_i (o, v);
}

void
GMORGAN::cb_2_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "E");
  EventProcessor (enote);
}

void
GMORGAN::cb_2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_2_i (o, v);
}

void
GMORGAN::cb_3_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "F");
  EventProcessor (enote);
}

void
GMORGAN::cb_3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_3_i (o, v);
}

void
GMORGAN::cb_4_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "G");
  EventProcessor (enote);
}

void
GMORGAN::cb_4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_4_i (o, v);
}

void
GMORGAN::cb_5_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "A");
  EventProcessor (enote);
}

void
GMORGAN::cb_5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_5_i (o, v);
}

void
GMORGAN::cb_6_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "B");
  EventProcessor (enote);
}

void
GMORGAN::cb_6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_6_i (o, v);
}

void
GMORGAN::cb_7_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "C#");
  EventProcessor (enote);
}

void
GMORGAN::cb_7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_7_i (o, v);
}

void
GMORGAN::cb_8_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "D#");
  EventProcessor (enote);
}

void
GMORGAN::cb_8 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_8_i (o, v);
}

void
GMORGAN::cb_9_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "F#");
  EventProcessor (enote);
}

void
GMORGAN::cb_9 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_9_i (o, v);
}

void
GMORGAN::cb_a_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "G#");
  EventProcessor (enote);
}

void
GMORGAN::cb_a (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_a_i (o, v);
}

void
GMORGAN::cb_b_i (Fl_Button *, void *)
{
  char enote[4];
  strcpy (enote, "A#");
  EventProcessor (enote);
}

void
GMORGAN::cb_b (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_b_i (o, v);
}

void
GMORGAN::cb_KBEntrywin_i (Fl_Double_Window *, void *)
{
  Fl::focus (EntradaK);
  KBEntrywin->hide ();
}

void
GMORGAN::cb_KBEntrywin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_KBEntrywin_i (o, v);
}

void
GMORGAN::cb_EntradaK_i (MiValueInput * o, void *)
{
  int i, valor, maxvalor;
  valor = (int) o->value ();
  if (gmo->PatternSelect)
    maxvalor = 499;
  else
    maxvalor = 100;
  i = Fl::event_key ();
  switch (i)
    {
    case 65361:
      if (valor > 1)
	{
	  valor--;
	  EntradaK->value (valor);
	  ActualizaEntrada ();
	}
      break;
    case 65363:
      if (valor < maxvalor)
	{
	  valor++;
	  EntradaK->value (valor);
	  ActualizaEntrada ();
	}
      break;
    case 65362:
      if (gmo->bpm < 520)
	{
	  gmo->bpm += 2;
	  gmo->set_tempo ();
	  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
	  DispTempo->label (gmo->tempoch);
	  CTEMPO->value (gmo->bpm / 2);
	}
      break;
    case 65364:
      if (gmo->bpm > 82)
	{
	  gmo->bpm -= 2;
	  gmo->set_tempo ();
	  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
	  DispTempo->label (gmo->tempoch);
	  CTEMPO->value (gmo->bpm / 2);
	}
      break;
    case 48:
      Calcula (0);
      break;
    case 49:
      Calcula (1);
      break;
    case 50:
      Calcula (2);
      break;
    case 51:
      Calcula (3);
      break;
    case 52:
      Calcula (4);
      break;
    case 53:
      Calcula (5);
      break;
    case 54:
      Calcula (6);
      break;
    case 55:
      Calcula (7);
      break;
    case 56:
      Calcula (8);
      break;
    case 57:
      Calcula (9);
      break;
    case 65293:
      EntradaK->value (valor);
      ActualizaEntrada ();
      gmo->Hay = 0;
      break;
    case 65421:
      EntradaK->value (valor);
      ActualizaEntrada ();
      gmo->Hay = 0;
      break;
    case 65288:
      gmo->Hay = 0;
      EntradaK->clear_changed ();
      break;
    case 65535:
      gmo->Hay = 0;
      EntradaK->clear_changed ();
      break;
    case 65454:
      gmo->Hay = 0;
      EntradaK->clear_changed ();
      break;
    case 65456:
      Calcula (0);
      break;
    case 65457:
      Calcula (1);
      break;
    case 65458:
      Calcula (2);
      break;
    case 65459:
      Calcula (3);
      break;
    case 65460:
      Calcula (4);
      break;
    case 65461:
      Calcula (5);
      break;
    case 65462:
      Calcula (6);
      break;
    case 65463:
      Calcula (7);
      break;
    case 65464:
      Calcula (8);
      break;
    case 65465:
      Calcula (9);
      break;
    case 97:
      Calcula (1);
      break;
    case 122:
      Calcula (2);
      break;
    case 101:
      Calcula (3);
      break;
    case 114:
      Calcula (4);
      break;
    case 116:
      Calcula (5);
      break;
    case 121:
      Calcula (6);
      break;
    case 117:
      Calcula (7);
      break;
    case 105:
      Calcula (8);
      break;
    case 111:
      Calcula (9);
      break;
    case 112:
      Calcula (0);
      break;
    case 106:
      if (valor > 1)
	{
	  valor--;
	  EntradaK->value (valor);
	  ActualizaEntrada ();
	}
      break;
    case 108:
      if (valor < maxvalor)
	{
	  valor++;
	  EntradaK->value (valor);
	  ActualizaEntrada ();
	}
      break;
    case 107:
      if (gmo->bpm < 520)
	{
	  gmo->bpm += 2;
	  gmo->set_tempo ();
	  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
	  DispTempo->label (gmo->tempoch);
	  CTEMPO->value (gmo->bpm / 2);
	}
      break;
    case 109:
      if (gmo->bpm > 82)
	{
	  gmo->bpm -= 2;
	  gmo->set_tempo ();
	  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
	  DispTempo->label (gmo->tempoch);
	  CTEMPO->value (gmo->bpm / 2);
	}
      break;
    };
}

void
GMORGAN::cb_EntradaK (MiValueInput * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_EntradaK_i (o, v);
}

void
GMORGAN::cb_SSSelector_i (Fl_Button *, void *)
{
  EntradaK->maximum (100);
  gmo->PatternSelect = 0;
  gmo->SoundSelect = 1;
  gmo->StyleSelect = 0;
  gmo->AccordionSelect = 0;
  EntradaK->value (gmo->ss);
  Fl::focus (EntradaK);
}

void
GMORGAN::cb_SSSelector (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_SSSelector_i (o,
									  v);
}

void
GMORGAN::cb_PSSelector_i (Fl_Button *, void *)
{
  EntradaK->maximum (499);
  gmo->PatternSelect = 1;
  gmo->SoundSelect = 0;
  gmo->StyleSelect = 0;
  gmo->AccordionSelect = 0;
  EntradaK->value (gmo->sp);
  Fl::focus (EntradaK);
}

void
GMORGAN::cb_PSSelector (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_PSSelector_i (o,
									  v);
}

void
GMORGAN::cb_YSSelector_i (Fl_Button *, void *)
{
  EntradaK->maximum (100);
  gmo->PatternSelect = 0;
  gmo->SoundSelect = 0;
  gmo->StyleSelect = 1;
  gmo->AccordionSelect = 0;
  EntradaK->value (gmo->st);
  Fl::focus (EntradaK);
}

void
GMORGAN::cb_YSSelector (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_YSSelector_i (o,
									  v);
}

void
GMORGAN::cb_ASSelector_i (Fl_Button *, void *)
{
  EntradaK->maximum (999999);
  gmo->PatternSelect = 0;
  gmo->SoundSelect = 0;
  gmo->StyleSelect = 0;
  gmo->AccordionSelect = 1;
  EntradaK->value (kn);
  Fl::focus (EntradaK);
}


void
GMORGAN::cb_ASSelector (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_ASSelector_i (o,v);
}

void
GMORGAN::cb_Close2_i (Fl_Button *, void *)
{
  gmo->KeybON =0;
  KBEntrywin->hide ();
}

void
GMORGAN::cb_Close2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Close2_i (o, v);
}

void
GMORGAN::cb_MVolSlider_i (Fl_Slider * o, void *)
{
  gmo->MasterVolume = o->value ();
  ActualizaVolumen ();
}

void
GMORGAN::cb_MVolSlider (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MVolSlider_i (o, v);
}

void
GMORGAN::cb_MVolMaster_i (Fl_Button * o, void *)
{
  gmo->MasterON = (int) o->value ();
}

void
GMORGAN::cb_MVolMaster (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MVolMaster_i (o, v);
}

void
GMORGAN::cb_Close3_i (Fl_Button *, void *)
{
  MVolwin->hide ();
}

void
GMORGAN::cb_Close3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Close3_i (o, v);
}

void
GMORGAN::cb_MTMSB_i (Fl_Dial * o, void *)
{
  int i;
  gmo->MTmsb = (int) o->value ();
  MTCounter->value (gmo->MTmsb - 64);
  gmo->DataMSB = gmo->MTmsb;
  gmo->DataLSB = gmo->MTlsb;
  for (i = 0; i <= 15; i++)
    {
      gmo->enviocontrol (1, 101, i);
      gmo->enviocontrol (1, 100, i);
      gmo->enviocontrol (1, 6, i);
      gmo->enviocontrol (1, 38, i);
    };
}

void
GMORGAN::cb_MTMSB (Fl_Dial * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MTMSB_i (o, v);
}

void
GMORGAN::cb_MTCounter_i (Fl_Counter * o, void *)
{
  int i;
  gmo->MTmsb = (int) o->value () + 64;
  MTMSB->value (gmo->MTmsb);
  gmo->DataMSB = gmo->MTmsb;
  gmo->DataLSB = gmo->MTlsb;
  for (i = 0; i <= 15; i++)
    {
      gmo->enviocontrol (1, 101, i);
      gmo->enviocontrol (1, 100, i);
      gmo->enviocontrol (1, 6, i);
      gmo->enviocontrol (1, 38, i);
    };
}

void
GMORGAN::cb_MTCounter (Fl_Counter * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MTCounter_i (o, v);
}

void
GMORGAN::cb_c_i (Fl_Button *, void *)
{
  gmo->make_GHelp ();
}

void
GMORGAN::cb_c (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_c_i (o, v);
}

void
GMORGAN::cb_WinMidiImport_i (Fl_Double_Window *, void *)
{
  WinMidiImport->hide ();
}

void
GMORGAN::cb_WinMidiImport (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_WinMidiImport_i (o, v);
}

void
GMORGAN::cb_Browse8_i (Fl_Button *, void *)
{
  char *filename;
  filename = fl_file_chooser ("Browse:", "(*.{mid,MID})", NULL, 0);
  if (filename == NULL)
    return;
  MiFiname->value (filename);
  strcpy (gmo->MidiImportFilename, filename);
}

void
GMORGAN::cb_Browse8 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Browse8_i (o, v);
}

void
GMORGAN::cb_WMiNominator_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 3) || ((int) o->value () > 4))
    {
      fl_message (gettext ("Nominator only can be 3 or 4"));
      return;
    }

  gmo->MiNominator = (int) o->value ();
}

void
GMORGAN::cb_WMiNominator (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiNominator_i (o, v);
}

void
GMORGAN::cb_WMiBars_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 1) || ((int) o->value () > 8))
    {
      fl_message (gettext ("Number of Bars (1-8)"));
      return;
    }

  gmo->MiBars = (int) o->value ();
}

void
GMORGAN::cb_WMiBars (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiBars_i (o, v);
}

void
GMORGAN::cb_WMiDrumsMCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiDrumsMCh = (int) o->value ();
}

void
GMORGAN::cb_WMiDrumsMCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiDrumsMCh_i (o, v);
}

void
GMORGAN::cb_WMiBassMCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiBassMCh = (int) o->value ();
}

void
GMORGAN::cb_WMiBassMCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiBassMCh_i (o, v);
}

void
GMORGAN::cb_Ok2_i (Fl_Button *, void *)
{
  if ((gmo->MiDrumsMCh == 0) && (gmo->MiBassMCh == 0))
    {
      fl_message (gettext
		  ("Import Midifile needs almost one channel to be specified"));
      return;
    }


  int ResultadoImport;
  WinMidiImport->hide ();

  ResultadoImport = gmo->ImportaMidi ();


  if (ResultadoImport == 0)
    {
      fl_message (gettext ("Import Midi File succesfully"));
      int lastblackn;
      lastblackn = gmo->Rt[gmo->sp].blackn;
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
      EditPattern (gmo->sp);
      gmo->Ending = gmo->Var1 = gmo->Var2 = gmo->Fill1 = gmo->Fill2 =
	gmo->Intro = gmo->sp;


    }

  else
    {
      switch (ResultadoImport)
	{

	case 1:
	  fl_message (gettext ("Error - This file doesn't seem to be a Midi File"));
	  break;

	case 2:
	  fl_message (gettext ("Error - Import needs Midi File type 1"));
	  break;

	case 99:
	  fl_message (gettext ("Error -  Importing data Midi File "));
	  break;
	}
    };
}

void
GMORGAN::cb_Ok2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Ok2_i (o, v);
}

void
GMORGAN::cb_Cancel5_i (Fl_Button *, void *)
{
  WinMidiImport->hide ();
}

void
GMORGAN::cb_Cancel5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel5_i (o, v);
}

void
GMORGAN::cb_WMiBaseKey_i (Fl_Choice * o, void *)
{
  gmo->MiBaseKey = o->value ();
}

void
GMORGAN::cb_WMiBaseKey (Fl_Choice * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiBaseKey_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_WMiBaseKey[] = {
  {gettext ("C"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("Db"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("D"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("Eb"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("E"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("F"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("Gb"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("G"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("Ab"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("A"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("Bb"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {gettext ("B"), 0, 0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

void
GMORGAN::cb_WMiAcc3MCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiAcc3MCh = (int) o->value ();
}

void
GMORGAN::cb_WMiAcc3MCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiAcc3MCh_i (o, v);
}

void
GMORGAN::cb_WMiStart_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 100))
    {
      fl_message (gettext ("Import starts at bar(1-100)"));
      return;
    }

  gmo->MiStart = (int) o->value ();
}

void
GMORGAN::cb_WMiStart (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiStart_i (o, v);
}

void
GMORGAN::cb_WMiAcc1MCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiAcc1MCh = (int) o->value ();
}

void
GMORGAN::cb_WMiAcc1MCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiAcc1MCh_i (o, v);
}

void
GMORGAN::cb_WMiAcc2MCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiAcc2MCh = (int) o->value ();
}

void
GMORGAN::cb_WMiAcc2MCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiAcc2MCh_i (o, v);
}

void
GMORGAN::cb_WMiAcc4MCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiAcc4MCh = (int) o->value ();
}

void
GMORGAN::cb_WMiAcc4MCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiAcc4MCh_i (o, v);
}

void
GMORGAN::cb_WMiAcc5MCh_i (Fl_Value_Input * o, void *)
{
  if (((int) o->value () < 0) || ((int) o->value () > 16))
    {
      fl_message (gettext ("Midi Channel (1-16)"));
      return;
    }

  gmo->MiAcc5MCh = (int) o->value ();
}

void
GMORGAN::cb_WMiAcc5MCh (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_WMiAcc5MCh_i (o, v);
}

void
GMORGAN::cb_WMimodeB1_i (Fl_Check_Button * o, void *)
{
  if ((int) o->value () == 1)
    gmo->Mmodebass = 1;
  else
    gmo->Mmodebass = 2;
}

void
GMORGAN::cb_WMimodeB1 (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_WMimodeB1_i (o,
									 v);
}

void
GMORGAN::cb_WMimodeB2_i (Fl_Check_Button * o, void *)
{
  if ((int) o->value () == 1)
    gmo->Mmodebass = 2;
  else
    gmo->Mmodebass = 1;
}

void
GMORGAN::cb_WMimodeB2 (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_WMimodeB2_i (o,
									 v);
}

void
GMORGAN::cb_WMimodeA21_i (Fl_Check_Button * o, void *)
{
  if ((int) o->value () == 1)
    gmo->Mmodeacc2 = 1;
  else
    gmo->Mmodeacc2 = 2;
}

void
GMORGAN::cb_WMimodeA21 (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_WMimodeA21_i (o,
									  v);
}

void
GMORGAN::cb_WMimodeA22_i (Fl_Check_Button * o, void *)
{
  if ((int) o->value () == 1)
    gmo->Mmodeacc2 = 2;
  else
    gmo->Mmodeacc2 = 1;
}

void
GMORGAN::cb_WMimodeA22 (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_WMimodeA22_i (o,
									  v);
}

void
GMORGAN::cb_WMimodeA41_i (Fl_Check_Button * o, void *)
{
  if ((int) o->value () == 1)
    gmo->Mmodeacc4 = 1;
  else
    gmo->Mmodeacc4 = 2;
}

void
GMORGAN::cb_WMimodeA41 (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_WMimodeA41_i (o,
									  v);
}

void
GMORGAN::cb_WMimodeA42_i (Fl_Check_Button * o, void *)
{
  if ((int) o->value () == 1)
    gmo->Mmodeacc4 = 2;
  else
    gmo->Mmodeacc4 = 1;
}

void
GMORGAN::cb_WMimodeA42 (Fl_Check_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_WMimodeA42_i (o,
									  v);
}

void
GMORGAN::cb_TempoTrackBrowser_i (Fl_Browser * o, void *)
{
  int i = (int) o->value ();
  WTTBar->value (gmo->TemT[i].bar);
  WTTBlack->value (gmo->TemT[i].black);
  WTTTempo->value (gmo->TemT[i].tempo);
}

void
GMORGAN::cb_TempoTrackBrowser (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_TempoTrackBrowser_i (o, v);
}

void
GMORGAN::cb_MTempoTrack_i (Fl_Button * o, void *)
{
  gmo->MTempo = (int) o->value ();
}

void
GMORGAN::cb_MTempoTrack (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MTempoTrack_i (o, v);
}

void
GMORGAN::cb_Modify_i (Fl_Button *, void *)
{
  if (((int) WTTBlack->value () > 4) || ((int) WTTBlack->value () < 1))
    {
      fl_message (gettext ("Sorry Black (1-4) only"));
      return;
    }
  if (((int) WTTTempo->value () > 260) || ((int) WTTTempo->value () < 40))
    {
      fl_message (gettext ("Sorry Tempo (40-260) only"));
      return;
    }
  char temp[64];
  int i = (int) TempoTrackBrowser->value ();
  gmo->TemT[i].bar = (int) WTTBar->value ();
  gmo->TemT[i].black = (int) WTTBlack->value ();
  gmo->TemT[i].tempo = (int) WTTTempo->value ();
  bzero (temp, sizeof (temp));
  sprintf (temp, "B-%03d-%d T-%03d", gmo->TemT[i].bar, gmo->TemT[i].black,
	   gmo->TemT[i].tempo);
  TempoTrackBrowser->text (i, temp);
}

void
GMORGAN::cb_Modify (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Modify_i (o, v);
}

void
GMORGAN::cb_Add_i (Fl_Button *, void *)
{
  if (((int) WTTBlack->value () > 4) || ((int) WTTBlack->value () < 1))
    {
      fl_message (gettext ("Sorry Black (1-4) only"));
      return;
    }
  if (((int) WTTTempo->value () > 260) || ((int) WTTTempo->value () < 40))
    {
      fl_message (gettext ("Sorry Tempo (40-260) only"));
      return;
    }

  int i;
  char temp[64];
  i = (int) TempoTrackBrowser->size () + 1;
  if (i < 200)
    {
      gmo->TemT[i].bar = (int) WTTBar->value ();
      gmo->TemT[i].black = (int) WTTBlack->value ();
      gmo->TemT[i].tempo = (int) WTTTempo->value ();
      bzero (temp, sizeof (temp));
      sprintf (temp, "B-%03d-%d T-%03d", gmo->TemT[i].bar, gmo->TemT[i].black,
	       gmo->TemT[i].tempo);
      TempoTrackBrowser->add (temp);
      TempoTrackBrowser->select (i);
    }
  else
    fl_message (gettext ("Sorry Track Full"));
}

void
GMORGAN::cb_Add (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Add_i (o, v);
}

void
GMORGAN::cb_Delete_i (Fl_Button *, void *)
{
  int i = (int) TempoTrackBrowser->value ();
  if (i != 1)
    {
      TempoTrackBrowser->remove (i);
      gmo->BorraTiempo (i);
    };
}

void
GMORGAN::cb_Delete (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Delete_i (o, v);
}

void
GMORGAN::cb_Insert_i (Fl_Button *, void *)
{
  if (((int) WTTBlack->value () > 4) || ((int) WTTBlack->value () < 1))
    {
      fl_message (gettext ("Sorry Black (1-4) only"));
      return;
    }
  if (((int) WTTTempo->value () > 260) || ((int) WTTTempo->value () < 40))
    {
      fl_message (gettext ("Sorry Tempo (40-260) only"));
      return;
    }

  char temp[64];
  int i = (int) TempoTrackBrowser->value ();
  gmo->InsertaTiempo (i);
  gmo->TemT[i].bar = (int) WTTBar->value ();
  gmo->TemT[i].black = (int) WTTBlack->value ();
  gmo->TemT[i].tempo = (int) WTTTempo->value ();
  bzero (temp, sizeof (temp));
  sprintf (temp, "B-%03d-%d T-%03d", gmo->TemT[i].bar, gmo->TemT[i].black,
	   gmo->TemT[i].tempo);
  TempoTrackBrowser->insert (i, temp);
  TempoTrackBrowser->select (i);
}

void
GMORGAN::cb_Insert (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Insert_i (o, v);
}

void
GMORGAN::cb_Clear5_i (Fl_Button *, void *)
{
  char temp[64];
  TempoTrackBrowser->clear ();
  memset (gmo->TemT, 0, sizeof gmo->TemT);

  gmo->TemT[1].bar = 1;
  gmo->TemT[1].black = 1;
  gmo->TemT[1].tempo = TempoSong;

  bzero (temp, sizeof (temp));
  sprintf (temp, "B-%03d-%d T-%03d", gmo->TemT[1].bar, gmo->TemT[1].black,
	   gmo->TemT[1].tempo);
  TempoTrackBrowser->add (temp);
  TempoTrackBrowser->select (1);
}

void
GMORGAN::cb_Clear5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear5_i (o, v);
}

void
GMORGAN::cb_Close4_i (Fl_Button *, void *)
{
  WTT->hide ();
}

void
GMORGAN::cb_Close4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Close4_i (o, v);
}

void
GMORGAN::cb_VeloBox_i (Fl_Double_Window *, void *)
{
  gmo->veloW = 0;
  gmo->VeloMixer = 0;
  VeloBox->hide ();
}

void
GMORGAN::cb_VeloBox (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_VeloBox_i (o, v);
}

void
GMORGAN::cb_d_i (Fl_Menu_ *, void *)
{
  gmo->make_GHelp ();
}

void
GMORGAN::cb_d (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_d_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_[] = {
  {"", 0xffbe, (Fl_Callback *) GMORGAN::cb_d, 0, 0, FL_NORMAL_LABEL, 0, 12,
   0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

void
GMORGAN::cb_MVLoad_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename = fl_file_chooser (gettext ("Load Velocity:"), "(*.gmv)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmv");
  gmo->loadvelo (filename);
  VeloBox->hide ();
  make_velo ();
}

void
GMORGAN::cb_MVLoad (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MVLoad_i (o, v);
}

void
GMORGAN::cb_MVSave_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmv"
  filename =
    fl_file_chooser (gettext ("Save Velocity:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->savevelo (filename);
}

void
GMORGAN::cb_MVSave (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MVSave_i (o, v);
}

void
GMORGAN::cb_MVClose_i (Fl_Menu_ *, void *)
{
  gmo->veloW = 0;
  gmo->VeloMixer = 0;
  VeloBox->hide ();
}

void
GMORGAN::cb_MVClose (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MVClose_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_1[] = {
  {gettext ("&File"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Load"), 0, (Fl_Callback *) GMORGAN::cb_MVLoad, 0, 0,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Save"), 0, (Fl_Callback *) GMORGAN::cb_MVSave, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Close"), 0, (Fl_Callback *) GMORGAN::cb_MVClose, 0, 0,
   FL_NORMAL_LABEL, 0, 12, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Menu_Item *
  GMORGAN::MVFile = GMORGAN::menu_1 + 0;
Fl_Menu_Item *
  GMORGAN::MVLoad = GMORGAN::menu_1 + 1;
Fl_Menu_Item *
  GMORGAN::MVSave = GMORGAN::menu_1 + 2;
Fl_Menu_Item *
  GMORGAN::MVClose = GMORGAN::menu_1 + 3;

void
GMORGAN::cb_CloVelo_i (Fl_Button *, void *)
{
  gmo->veloW = 0;
  gmo->VeloMixer = 0;
  VeloBox->hide ();
}

void
GMORGAN::cb_CloVelo (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CloVelo_i (o, v);
}

void
GMORGAN::cb_Aplica_i (Fl_Button *, void *)
{
  int i, k;
  k = 1;
// just want to get rid of the compiler warning here. 
  fl_message
    ("This applies mixer contents in the pattern and resets the mixer to zero state");
  if (k)
    {
      gmo->ActualizaPattern ();
      gmo->veloW = 0;
      gmo->VeloMixer = 0;
      VeloBox->hide ();
      for (i = 1; i <= 61; i++)
	veloplus[i] = 0;
      cierraDrEdit ();
      make_window_drum ();
      make_drum_edit ();
    };
}

void
GMORGAN::cb_Aplica (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Aplica_i (o, v);
}

void
GMORGAN::cb_ResetV_i (Fl_Button *, void *)
{
  int i;
  VeloBox->hide ();
  for (i = 1; i <= 61; i++)
    veloplus[i] = 0;
  make_velo ();
}

void
GMORGAN::cb_ResetV (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_ResetV_i (o, v);
}

void
GMORGAN::cb_BPEWin_i (Fl_Double_Window *, void *)
{
  Close_BP ();
}

void
GMORGAN::cb_BPEWin (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_BPEWin_i (o, v);
}

void
GMORGAN::cb_e_i (Fl_Menu_ *, void *)
{
  gmo->make_GHelp ();
}

void
GMORGAN::cb_e (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_e_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_2[] = {
  {"", 0xffbe, (Fl_Callback *) GMORGAN::cb_e, 0, 0, FL_NORMAL_LABEL, 0, 12,
   0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

void
GMORGAN::cb_BPMFile_i (Fl_Menu_ *, void *)
{
  Fl::focus (StartStopB);
}

void
GMORGAN::cb_BPMFile (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPMFile_i (o, v);
}

void
GMORGAN::cb_BPNew_i (Fl_Menu_ *, void *)
{
  gmo->newsong ();
  BPEWin->hide ();
  make_bp ();
}

void
GMORGAN::cb_BPNew (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPNew_i (o, v);
}

void
GMORGAN::cb_BPMLoad_i (Fl_Menu_ *, void *)
{
  char *filename;
  Fl::focus (PANICO);
  filename = fl_file_chooser (gettext ("Load Song:"), "(*.gmsong)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmsong");
  cout << " current song loaded is " << filename << endl;
  strcpy (SongFileName,filename); 
  gmo->newsong ();
  gmo->loadsong (filename);
  gmo-> MutesOnOff = 0;
  BPEWin->hide ();
  make_bp ();
}

void
GMORGAN::cb_BPMLoad (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPMLoad_i (o, v);
}

void
GMORGAN::cb_BPSave_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmsong"
//  filename = fl_file_chooser (gettext ("Save Song:"), "(*" EXT ")", NULL, 0);
  filename = fl_file_chooser (gettext ("Save Song:"), "(*" EXT ")", SongFileName, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->savesong (filename);
}

void
GMORGAN::cb_BPSave (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPSave_i (o, v);
}

void GMORGAN::cb_BPPrint_i(Fl_Menu_*, void*) {
  char *filename;
#define EXT ".ly"
filename=fl_file_chooser(gettext("Print Song:"),"(*"EXT")",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT
gmo->printsong(filename);
}
void GMORGAN::cb_BPPrint(Fl_Menu_* o, void* v) {
  ((GMORGAN*)(o->parent()->user_data()))->cb_BPPrint_i(o,v);
}

void
GMORGAN::cb_BPExport_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".mid"
  filename =
    fl_file_chooser (gettext ("Save MIDI file:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->saveMidiFile (filename);
}

void
GMORGAN::cb_BPExport (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPExport_i (o, v);
}

void
GMORGAN::cb_BPClose_i (Fl_Menu_ *, void *)
{
  Close_BP ();
}

void
GMORGAN::cb_BPClose (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPClose_i (o, v);
}

void
GMORGAN::cb_BPMTempo_i (Fl_Menu_ *, void *)
{
  WTT->hide ();
  WTT->position (30, 30);
  prepara_WTT ();
  WTT->show ();
}

void
GMORGAN::cb_BPMTempo (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_BPMTempo_i (o, v);
}
void GMORGAN::cb_BPMTool_i(Fl_Menu_*, void*) {
  Fl::focus(StartStopB);
}
void GMORGAN::cb_BPMTool(Fl_Menu_* o, void* v) {
  ((GMORGAN*)(o->parent()->user_data()))->cb_BPMTool_i(o,v);
}
/*
void GMORGAN::cb_BPMTranspose_i(Fl_Menu_*, void*) {
 Translation TransposeChord;
 cout << " Transpose " << endl; 
 Translation *TransChord = new Translation();
 TransChord->make_window()->show();
// destroy it. 
}
void GMORGAN::cb_BPMTranspose(Fl_Menu_* o, void* v) {
  ((GMORGAN*)(o->parent()->user_data()))->cb_BPMTranspose_i(o,v);
}
*/
//unsigned char GMORGAN::menu_3_i18n_done = 0;
Fl_Menu_Item GMORGAN::menu_3[] = {
 {gettext ("&File"), 0,  (Fl_Callback*)GMORGAN::cb_BPMFile, 0, 64, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("&New"), 0,  (Fl_Callback*)GMORGAN::cb_BPNew, 0, 128, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("&Load"), 0,  (Fl_Callback*)GMORGAN::cb_BPMLoad, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("&Save"), 0,  (Fl_Callback*)GMORGAN::cb_BPSave, 0, 128, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("&Print"), 0,  (Fl_Callback*)GMORGAN::cb_BPPrint, 0, 128, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("Export MidiFile"), 0,  (Fl_Callback*)GMORGAN::cb_BPExport, 0, 128, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("&Close"), 0,  (Fl_Callback*)GMORGAN::cb_BPClose, 0, 128, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0},
 {gettext ("&Tempo Track"), 0x74,  (Fl_Callback*)GMORGAN::cb_BPMTempo, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {gettext ("Tools"), 0,  (Fl_Callback*)GMORGAN::cb_BPMTool, 0, 64, FL_NORMAL_LABEL, 0, 12, 0},
// {gettext ("&Transpose"), 0, (Fl_Callback*)GMORGAN::cb_BPMTranspose, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item* GMORGAN::BPMFile = GMORGAN::menu_3 + 0;
Fl_Menu_Item* GMORGAN::BPNew = GMORGAN::menu_3 + 1;
Fl_Menu_Item* GMORGAN::BPMLoad = GMORGAN::menu_3 + 2;
Fl_Menu_Item* GMORGAN::BPSave = GMORGAN::menu_3 + 3;
Fl_Menu_Item* GMORGAN::BPPrint = GMORGAN::menu_3 + 4;
Fl_Menu_Item* GMORGAN::BPExport = GMORGAN::menu_3 + 5;
Fl_Menu_Item* GMORGAN::BPClose = GMORGAN::menu_3 + 6;
Fl_Menu_Item* GMORGAN::BPMTempo = GMORGAN::menu_3 + 8;
Fl_Menu_Item* GMORGAN::BPMTool = GMORGAN::menu_3 + 9;
//Fl_Menu_Item* GMORGAN::BPMTranspose = GMORGAN::menu_3 + 10;

void
GMORGAN::cb_NSong_i (Fl_Input * o, void *)
{
  strcpy (NombreSong, (char *) o->value ());
}

void
GMORGAN::cb_NSong (Fl_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_NSong_i (o, v);
}

void
GMORGAN::cb_STempo_i (Fl_Value_Input * o, void *)
{
  TempoSong = (int) o->value ();
  gmo->bpm = TempoSong * 2;
  gmo->set_tempo ();

  if (gmo->MTempo)
    {
      gmo->TemT[1].bar = 1;
      gmo->TemT[1].black = 1;
      gmo->TemT[1].tempo = TempoSong;
    };
}

void
GMORGAN::cb_STempo (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_STempo_i (o, v);
}

void
GMORGAN::cb_Nomi_i (Fl_Value_Input * o, void *)
{
  SNomi = (int) o->value ();
  BPEWin->hide ();
  make_bp ();
}

void
GMORGAN::cb_Nomi (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Nomi_i (o, v);
}

void
GMORGAN::cb_StartStopB_i (Fl_Button * o, void *)
{
  int i;
  gmo->stst = (int) o->value ();
  gmo->bplay = (int) o->value ();
  preparast ();
  cout << "Batch Start Button Pressed " << o->value() << endl;
  if (o->value () == 1)
    {
      LaBarra->deactivate ();
      PonACero->deactivate ();
      StartStop->deactivate ();
      MRecord->deactivate ();
      MPlay->deactivate ();
      gmo->init_queue ();
      snd_seq_start_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			   NULL);
      if (gmo->MTempo == 0)
	gmo->bpm = TempoSong * 2;
      else
	gmo->BuscaTempo ();
      gmo->set_tempo ();
      sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
      DispTempo->label (gmo->tempoch);
      snd_seq_drain_output (gmo->MidiOutPuerto[1].midi_out);
      if (S[gmo->nb].pattern == 0)
	BuscaLastPattern ();
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
      gmo->accompaniment ();
    }
  else
    {
      gmo->clear_queue ();
      snd_seq_stop_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			  NULL);
      snd_seq_free_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id);
      gmo->panico (0, 15);
      for (i = 0; i < POLY; i++)
	gmo->note_active[i] = 0;
      StartStop->activate ();
      LaBarra->activate ();
      MRecord->activate ();
      MPlay->activate ();
      PonACero->activate ();
    };
}

void
GMORGAN::cb_StartStopB (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_StartStopB_i (o, v);
}

void
GMORGAN::cb_Inv1_i (Fl_Button * o, void *)
{
  if (o->value () == 1)
    InvMode = 1;
}

void
GMORGAN::cb_Inv1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Inv1_i (o, v);
}

void
GMORGAN::cb_Inv2_i (Fl_Button * o, void *)
{
  if (o->value () == 1)
    InvMode = 2;
}

void
GMORGAN::cb_Inv2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_Inv2_i (o, v);
}

void
GMORGAN::cb_LaBarra_i (Fl_Slider * o, void *)
{
  gmo->nb = (int) o->value ();
  sprintf (gmo->elnb, "%d", gmo->nb);
  Dispnb->label (gmo->elnb);
  BDispBlack->label (gmo->elnb);
}

void
GMORGAN::cb_LaBarra (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_LaBarra_i (o, v);
}

void
GMORGAN::cb_Copy9_i (Fl_Button *, void *)
{
  SongCopyWin->position (50, 50);

  SongCopyWin->show ();
}

void
GMORGAN::cb_Copy9 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copy9_i (o, v);
}

void
GMORGAN::cb_Clear6_i (Fl_Button *, void *)
{
  SongClearWin->position (50, 50);

  SongClearWin->show ();
}

void
GMORGAN::cb_Clear6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear6_i (o, v);
}

void
GMORGAN::cb_PonACero_i (Fl_Button *, void *)
{
  gmo->nb = 1;
  sprintf (gmo->elnb, "%d", gmo->nb);
  Dispnb->label (gmo->elnb);
  BDispBlack->label (gmo->elnb);
  LaBarra->value (1);
}

void
GMORGAN::cb_PonACero (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_PonACero_i (o, v);
}

void
GMORGAN::cb_DrumEditBox_i (Fl_Double_Window *, void *)
{
//  cout << "cb_DrumEditBox_i " << endl;
  cierraDrEdit ();
}

void
GMORGAN::cb_DrumEditBox (Fl_Double_Window * o, void *v)
{
//  cout << "cb_DrumEditBox " << endl;
  ((GMORGAN *) (o->user_data ()))->cb_DrumEditBox_i (o, v);
}
/* rlvseg
void
GMORGAN::cb_VerBar_i (Fl_Scrollbar * o, void *)
{
  Scroll1->position (Scroll1->xposition (), o->value ());
  Scroll2->position (Scroll2->xposition (), o->value ());
}

void
GMORGAN::cb_VerBar (Fl_Scrollbar * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_VerBar_i (o, v);
}

void
GMORGAN::cb_HorBar_i (Fl_Scrollbar * o, void *)
{
  Scroll3->position (o->value (), Scroll3->yposition ());
  Scroll2->position (o->value (), Scroll2->yposition ());
}

void
GMORGAN::cb_HorBar (Fl_Scrollbar * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_HorBar_i (o, v);
}
*/
void
GMORGAN::cb_Ok3_i (Fl_Button *, void *)
{
  gmo->PonTempDrum (gmo->sp);
  cierraDrEdit ();
}

void
GMORGAN::cb_Ok3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Ok3_i (o, v);
}

void
GMORGAN::cb_Cancel6_i (Fl_Button *, void *)
{
  cierraDrEdit ();
}

void
GMORGAN::cb_Cancel6 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel6_i (o, v);
}

void
GMORGAN::cb_Copya_i (Fl_Button *, void *)
{
  gmo->selcopy = 5;
  CopyB2Win->position (1, 1);
  CopyB2Win->show ();
}

void
GMORGAN::cb_Copya (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copya_i (o, v);
}

void
GMORGAN::cb_Copyb_i (Fl_Button *, void *)
{
  gmo->selcopy = 4;
  CopyB2Win->position (1, 1);
  CopyB2Win->show ();
}

void
GMORGAN::cb_Copyb (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copyb_i (o, v);
}

void
GMORGAN::cb_Velocity_i (Fl_Button *, void *)
{
  if (gmo->veloW == 0)
    {
      gmo->VeloMixer = 1;
      gmo->veloW = 1;
      make_velo ();
    };
}

void
GMORGAN::cb_Velocity (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Velocity_i (o, v);
}

void
GMORGAN::cb_Clear7_i (Fl_Button *, void *)
{
  int j;
  for (j = 0; j <= 108; j++)

    {
      Edr[sde][j] = 0;
    }
//  Spreadsheet::table.cleartable();
  DrumEditBox->hide ();
  make_drum_edit ();
}

void
GMORGAN::cb_Clear7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear7_i (o, v);
}

void
GMORGAN::cb_PFileEdit_i (Fl_Double_Window *, void *)
{
  PFileEdit->hide ();
  PFileEdit->clear ();
  gmo->PFEW = 0;
}

void
GMORGAN::cb_PFileEdit (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_PFileEdit_i (o, v);
}

void
GMORGAN::cb_f_i (Fl_Menu_ *, void *)
{
  gmo->make_GHelp ();
}

void
GMORGAN::cb_f (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_f_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_4[] = {
  {"", 0xffbe, (Fl_Callback *) GMORGAN::cb_f, 0, 0, FL_NORMAL_LABEL, 0, 12,
   0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

void
GMORGAN::cb_PreBro_i (Fl_Browser * o, void *)
{
  PreparaPre ((int) o->value ());
}

void
GMORGAN::cb_PreBro (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_PreBro_i (o, v);
}

void
GMORGAN::cb_PFileFilesub1_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".txt"
  filename =
    fl_file_chooser (gettext ("Save Preset file:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  save_preset (filename);
}

void
GMORGAN::cb_PFileFilesub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_PFileFilesub1_i (o, v);
}

void
GMORGAN::cb_PFileFilesub2_i (Fl_Menu_ *, void *)
{
  PFileEdit->hide ();
  PFileEdit->clear ();
  gmo->PFEW = 0;
}

void
GMORGAN::cb_PFileFilesub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_PFileFilesub2_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_5[] = {
  {gettext ("&File"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Save"), 0, (Fl_Callback *) GMORGAN::cb_PFileFilesub1, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Close"), 0, (Fl_Callback *) GMORGAN::cb_PFileFilesub2, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Menu_Item *
  GMORGAN::PFileFile = GMORGAN::menu_5 + 0;
Fl_Menu_Item *
  GMORGAN::PFileFilesub1 = GMORGAN::menu_5 + 1;
Fl_Menu_Item *
  GMORGAN::PFileFilesub2 = GMORGAN::menu_5 + 2;

void
GMORGAN::cb_Modify1_i (Fl_Button *, void *)
{
  int i, j, k;
  char temp[128];

  i = (int) PEBank->value ();

  if (i > 128)
    {
      fl_alert (gettext ("Sorry, only Bank 0-128"));
      return;
    }
  j = (int) PEPreset->value ();

  if (j > 128)
    {
      fl_alert (gettext ("Sorry, only Preset 0-128"));
      return;
    }

  bzero (temp, sizeof (temp));
  strcpy (temp, PEPreName->value ());


  for (k = 0; k <= (int) strlen (PEPreName->value ()); k++)
    gmo->PresetList[i].PBanco[j].ProgName[k] = temp[k];
  MetePresets ();
  Sel_Last_Pre (i, j);
}

void
GMORGAN::cb_Modify1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Modify1_i (o, v);
}

void
GMORGAN::cb_DFileEdit_i (Fl_Double_Window *, void *)
{
  DFileEdit->hide ();
  DFileEdit->clear ();
  gmo->DNNWE = 0;
}

void
GMORGAN::cb_DFileEdit (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_DFileEdit_i (o, v);
}

void
GMORGAN::cb_10_i (Fl_Menu_ *, void *)
{
  gmo->make_GHelp ();
}

void
GMORGAN::cb_10 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_10_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_6[] = {
  {"", 0xffbe, (Fl_Callback *) GMORGAN::cb_10, 0, 0, FL_NORMAL_LABEL, 0, 12,
   0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

void
GMORGAN::cb_DruBro_i (Fl_Browser * o, void *)
{
  PreparaDru ((int) o->value ());
}

void
GMORGAN::cb_DruBro (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DruBro_i (o, v);
}

void
GMORGAN::cb_DFileFilesub1_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".txt"
  filename =
    fl_file_chooser (gettext ("Save Drum Note file:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  save_drumn (filename);
}

void
GMORGAN::cb_DFileFilesub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DFileFilesub1_i (o, v);
}

void
GMORGAN::cb_DFileFilesub2_i (Fl_Menu_ *, void *)
{
  DFileEdit->hide ();
  DFileEdit->clear ();
  gmo->DNNWE = 0;
}

void
GMORGAN::cb_DFileFilesub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_DFileFilesub2_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_7[] = {
  {gettext ("&File"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Save"), 0, (Fl_Callback *) GMORGAN::cb_DFileFilesub1, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Close"), 0, (Fl_Callback *) GMORGAN::cb_DFileFilesub2, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Menu_Item *
  GMORGAN::DFileFile = GMORGAN::menu_7 + 0;
Fl_Menu_Item *
  GMORGAN::DFileFilesub1 = GMORGAN::menu_7 + 1;
Fl_Menu_Item *
  GMORGAN::DFileFilesub2 = GMORGAN::menu_7 + 2;

void
GMORGAN::cb_Modify2_i (Fl_Button *, void *)
{
  int i, j, k;
  char temp[128];

  i = (int) DEProgram->value ();

  if (i > 60)
    {
      fl_alert (gettext ("Sorry, only Program 0-60"));
      return;
    }
  j = (int) DENote->value ();

  if ((j < 27) || (j > 88))
    {
      fl_alert (gettext ("Sorry, only Note 27-88"));
      return;
    }

  bzero (temp, sizeof (temp));
  strcpy (temp, DEInstName->value ());


  for (k = 0; k <= (int) strlen (DEInstName->value ()); k++)
    gmo->PD[i].DNN[j].Nom[k] = temp[k];
  MeteDrumn ();
  Sel_Last_Dru (i, j);
}

void
GMORGAN::cb_Modify2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Modify2_i (o, v);
}

void
GMORGAN::cb_CtrlEditBox_i (Fl_Double_Window *, void *)
{
  cierraCtrlEdit ();
}

void
GMORGAN::cb_CtrlEditBox (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_CtrlEditBox_i (o, v);
}

void
GMORGAN::cb_CVerBar_i (Fl_Scrollbar * o, void *)
{
  CScroll1->position (CScroll1->xposition (), o->value ());
  CScroll2->position (CScroll2->xposition (), o->value ());
}

void
GMORGAN::cb_CVerBar (Fl_Scrollbar * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CVerBar_i (o, v);
}

void
GMORGAN::cb_CHorBar_i (Fl_Scrollbar * o, void *)
{
  CScroll3->position (o->value (), CScroll3->yposition ());
  CScroll2->position (o->value (), CScroll2->yposition ());
}

void
GMORGAN::cb_CHorBar (Fl_Scrollbar * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_CHorBar_i (o, v);
}

void
GMORGAN::cb_Ok4_i (Fl_Button *, void *)
{
  gmo->ControlesPon (gmo->sp);
  cierraCtrlEdit ();
}

void
GMORGAN::cb_Ok4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Ok4_i (o, v);
}

void
GMORGAN::cb_Cancel7_i (Fl_Button *, void *)
{
  cierraCtrlEdit ();
}

void
GMORGAN::cb_Cancel7 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Cancel7_i (o, v);
}

void
GMORGAN::cb_Copyc_i (Fl_Button *, void *)
{
  gmo->selcopy = 15;
  CopyB2Win->position (1, 1);
  CopyB2Win->show ();
}

void
GMORGAN::cb_Copyc (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copyc_i (o, v);
}

void
GMORGAN::cb_Copyd_i (Fl_Button *, void *)
{
  gmo->selcopy = 14;
  CopyB2Win->position (1, 1);
  CopyB2Win->show ();
}

void
GMORGAN::cb_Copyd (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Copyd_i (o, v);
}

void
GMORGAN::cb_CtrlAcc1_i (Fl_Button *, void *)
{
  repinta (1);
}

void
GMORGAN::cb_CtrlAcc1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlAcc1_i (o, v);
}

void
GMORGAN::cb_CtrlAcc2_i (Fl_Button *, void *)
{
  repinta (2);
}

void
GMORGAN::cb_CtrlAcc2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlAcc2_i (o, v);
}

void
GMORGAN::cb_CtrlAcc3_i (Fl_Button *, void *)
{
  repinta (3);
}

void
GMORGAN::cb_CtrlAcc3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlAcc3_i (o, v);
}

void
GMORGAN::cb_CtrlAcc4_i (Fl_Button *, void *)
{
  repinta (4);
}

void
GMORGAN::cb_CtrlAcc4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlAcc4_i (o, v);
}

void
GMORGAN::cb_CtrlAcc5_i (Fl_Button *, void *)
{
  repinta (5);
}

void
GMORGAN::cb_CtrlAcc5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlAcc5_i (o, v);
}

void
GMORGAN::cb_CtrlBass_i (Fl_Button *, void *)
{
  repinta (6);
}

void
GMORGAN::cb_CtrlBass (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlBass_i (o, v);
}

void
GMORGAN::cb_CtrlDrums_i (Fl_Button *, void *)
{
  repinta (7);
}

void
GMORGAN::cb_CtrlDrums (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_CtrlDrums_i (o,
									 v);
}

void
GMORGAN::cb_Clear8_i (Fl_Button *, void *)
{
  int j;
  for (j = 0; j <= 108; j++)

    {
      Ectrl[canaledit][sdec][j] = 0;
    }

  CtrlEditBox->hide ();
  make_ctrl_edit ();
}

void
GMORGAN::cb_Clear8 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Clear8_i (o, v);
}

void
GMORGAN::cb_gtwindow_i (Fl_Double_Window *, void *)
{
  gmo->genwindow = 0;
  gtwindow->hide ();
}

void
GMORGAN::cb_gtwindow (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_gtwindow_i (o, v);
}

void
GMORGAN::cb_gstybrowser_i (Fl_Browser * o, void *)
{
  int i = o->value ();
  if (i < 1)
    return;
  bzero (gmo->ElEstilo, sizeof (gmo->ElEstilo));
  strcpy (gmo->ElEstilo, o->text (i));
  leelib ();
  gvarbrowser->clear ();
  PonVariation ();
  gvarbrowser->select (1);
  o->select (i);
}

void
GMORGAN::cb_gstybrowser (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_gstybrowser_i (o, v);
}

void
GMORGAN::cb_ginstbrowser_i (Fl_Browser *, void *)
{
  miraselboton (0);
  gvarbrowser->clear ();
  PonVariation ();
  gvarbrowser->select (1);
}

void
GMORGAN::cb_ginstbrowser (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_ginstbrowser_i (o, v);
}

void
GMORGAN::cb_GAddSty_i (Fl_Button *, void *)
{
  const char *NombreEstilo;


  NombreEstilo = fl_input (gettext ("Name of the new style"), "");

  if (NombreEstilo == NULL)
    return;
  if (strlen (NombreEstilo) > 0)
    {
      gstybrowser->add (NombreEstilo);
      bzero (gmo->ElEstilo, sizeof (gmo->ElEstilo));
      strcpy (gmo->ElEstilo, NombreEstilo);
      bzero (gmo->Register.style, sizeof (gmo->Register.style));
      strcpy (gmo->Register.style, NombreEstilo);
      gmo->Register.type = 1;
      gmo->Register.stat = 1;
      bzero (gmo->Register.datavar, sizeof (gmo->Register.datavar));
      gmo->grabalib ();
    }
  gstybrowser->select ((int) gstybrowser->size ());
  int i = gstybrowser->value ();
  leelib ();
  gvarbrowser->clear ();
  PonVariation ();
  gvarbrowser->select (1);
  gstybrowser->select (i);
}

void
GMORGAN::cb_GAddSty (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GAddSty_i (o, v);
}

void
GMORGAN::cb_GAddVar_i (Fl_Button *, void *)
{
  if (gmo->Rt[gmo->sp].bars < 8)
    {
      fl_message (gettext
		  ("Sorry, only patterns with 8 bars length can be added to Style Library"));
      return;
    }

  if (strcmp (gmo->ElEstilo, "Empty") == 0)
    {
      fl_message (gettext ("Sorry, Add First a Style definition"));
      return;
    }


  AddVariation ();
  gmo->NumVari[(int) (gmo->Register.type) - 1]++;
  gvarbrowser->clear ();
  PonVariation ();
  gvarbrowser->select (1);
}

void
GMORGAN::cb_GAddVar (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GAddVar_i (o, v);
}

void
GMORGAN::cb_Close5_i (Fl_Button *, void *)
{
  gmo->genwindow = 0;
  gtwindow->hide ();
}

void
GMORGAN::cb_Close5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Close5_i (o, v);
}

void
GMORGAN::cb_GenAcc1_i (Fl_Button *, void *)
{
  miraselboton (0);
}

void
GMORGAN::cb_GenAcc1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenAcc1_i (o, v);
}

void
GMORGAN::cb_GenAcc2_i (Fl_Button *, void *)
{
  miraselboton (2);
}

void
GMORGAN::cb_GenAcc2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenAcc2_i (o, v);
}

void
GMORGAN::cb_GenAcc3_i (Fl_Button *, void *)
{
  miraselboton (3);
}

void
GMORGAN::cb_GenAcc3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenAcc3_i (o, v);
}

void
GMORGAN::cb_GenAcc4_i (Fl_Button *, void *)
{
  miraselboton (4);
}

void
GMORGAN::cb_GenAcc4 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenAcc4_i (o, v);
}

void
GMORGAN::cb_GenAcc5_i (Fl_Button *, void *)
{
  miraselboton (5);
}

void
GMORGAN::cb_GenAcc5 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenAcc5_i (o, v);
}

void
GMORGAN::cb_GenBass_i (Fl_Button *, void *)
{
  miraselboton (0);
}

void
GMORGAN::cb_GenBass (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenBass_i (o, v);
}

void
GMORGAN::cb_GenDrums_i (Fl_Button *, void *)
{
  miraselboton (0);
}

void
GMORGAN::cb_GenDrums (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->cb_GenDrums_i (o, v);
}

void
GMORGAN::cb_GPutVar_i (Fl_Button *, void *)
{
  Put_Variation ();
  gmo->PonTempDrum (gmo->sp);
}

void
GMORGAN::cb_GPutVar (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GPutVar_i (o, v);
}

void
GMORGAN::cb_WGuiPattern_i (Fl_Double_Window *, void *)
{
  WGuiPattern->hide ();
  gmo->WGUIP = 0;
  WGuiPattern->clear ();
}

void
GMORGAN::cb_WGuiPattern (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_WGuiPattern_i (o, v);
}

void
GMORGAN::cb_GPWEFileFilesub1_i (Fl_Menu_ *, void *)
{
  int i;
  char temp[32];
  char *filename;
  filename = fl_file_chooser (gettext ("Load Song:"), "(*.gmpl)", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, ".gmpl");
  GPBrowser->clear ();
  memset (gmo->GP, 0, sizeof gmo->GP);

  gmo->loadgmpl (filename);

  for (i = 1; i < 200; i++)
    {
      if (gmo->GP[i].bar != 0)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "B-%03d P-%03d", gmo->GP[i].bar, gmo->GP[i].pattern);
	  GPBrowser->add (temp);
	}
    }
  GPBrowser->select (1);
  WGPBar->value (gmo->GP[1].bar);
  WGPPattern->value (gmo->GP[1].pattern);
}

void
GMORGAN::cb_GPWEFileFilesub1 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GPWEFileFilesub1_i (o, v);
}

void
GMORGAN::cb_GPWEFileFilesub2_i (Fl_Menu_ *, void *)
{
  char *filename;
#define EXT ".gmpl"
  filename = fl_file_chooser (gettext ("Save Song:"), "(*" EXT ")", NULL, 0);
  if (filename == NULL)
    return;
  filename = fl_filename_setext (filename, EXT);
#undef EXT
  gmo->savegmpl (filename);
}

void
GMORGAN::cb_GPWEFileFilesub2 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GPWEFileFilesub2_i (o, v);
}

void
GMORGAN::cb_GPWEFileFilesub3_i (Fl_Menu_ *, void *)
{
  GPBrowser->clear ();
  memset (gmo->GP, 0, sizeof gmo->GP);
  GPBrowser->select (1);
  WGPBar->value (gmo->GP[1].bar);
  WGPPattern->value (gmo->GP[1].pattern);
}

void
GMORGAN::cb_GPWEFileFilesub3 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GPWEFileFilesub3_i (o, v);
}

void
GMORGAN::cb_GPWEFileFilesub4_i (Fl_Menu_ *, void *)
{
  WGuiPattern->hide ();
  gmo->WGUIP = 0;
  WGuiPattern->clear ();
}

void
GMORGAN::cb_GPWEFileFilesub4 (Fl_Menu_ * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GPWEFileFilesub4_i (o, v);
}

Fl_Menu_Item
  GMORGAN::menu_8[] = {
  {gettext ("&File"), 0, 0, 0, 64, FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Load"), 0, (Fl_Callback *) GMORGAN::cb_GPWEFileFilesub1, 0, 0,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Save"), 0, (Fl_Callback *) GMORGAN::cb_GPWEFileFilesub2, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&New"), 0, (Fl_Callback *) GMORGAN::cb_GPWEFileFilesub3, 0, 128,
   FL_NORMAL_LABEL, 0, 12, 0},
  {gettext ("&Close"), 0, (Fl_Callback *) GMORGAN::cb_GPWEFileFilesub4, 0,
   128, FL_NORMAL_LABEL, 0, 12, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0},
  {0, 0, 0, 0, 0, 0, 0, 0, 0}
};

Fl_Menu_Item *
  GMORGAN::GPWEFileFile = GMORGAN::menu_8 + 0;
Fl_Menu_Item *
  GMORGAN::GPWEFileFilesub1 = GMORGAN::menu_8 + 1;
Fl_Menu_Item *
  GMORGAN::GPWEFileFilesub2 = GMORGAN::menu_8 + 2;
Fl_Menu_Item *
  GMORGAN::GPWEFileFilesub3 = GMORGAN::menu_8 + 3;
Fl_Menu_Item *
  GMORGAN::GPWEFileFilesub4 = GMORGAN::menu_8 + 4;

void
GMORGAN::cb_GPBrowser_i (Fl_Browser * o, void *)
{
  int i = (int) o->value ();
  WGPBar->value (gmo->GP[i].bar);
  WGPPattern->value (gmo->GP[i].pattern);
}

void
GMORGAN::cb_GPBrowser (Fl_Browser * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_GPBrowser_i (o, v);
}

void
GMORGAN::cb_MGUIPlay_i (Fl_Button * o, void *)
{
  gmo->GUIPlay = (int) o->value ();
  gmo->ncompas = 0;
  notplaying = 0;
  if ((gmo->GUIPlay == 0) && (gmo->bplay == 0))
    {
	notplaying = 1;
      gmo->sp = gmo->Var1;
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
    };
}

void
GMORGAN::cb_MGUIPlay (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_MGUIPlay_i (o, v);
}

void
GMORGAN::cb_Modify3_i (Fl_Button *, void *)
{
  char temp[64];
  int i = (int) GPBrowser->value ();
  gmo->GP[i].bar = (int) WGPBar->value ();
  gmo->GP[i].pattern = (int) WGPPattern->value ();
  bzero (temp, sizeof (temp));
  sprintf (temp, "B-%03d P-%03d", gmo->GP[i].bar, gmo->GP[i].pattern);
  GPBrowser->text (i, temp);
}

void
GMORGAN::cb_Modify3 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Modify3_i (o, v);
}

void
GMORGAN::cb_Add1_i (Fl_Button *, void *)
{
  if (((int) WGPPattern->value () < 1) || ((int) WGPPattern->value () > 499))
    {
      fl_message (gettext ("Sorry pattern (1-499) only"));
      return;
    }

  int i;
  char temp[64];
  i = (int) GPBrowser->size () + 1;
  if (i < 200)
    {
      gmo->GP[i].bar = (int) WGPBar->value ();
      gmo->GP[i].pattern = (int) WGPPattern->value ();
      bzero (temp, sizeof (temp));
      sprintf (temp, "B-%03d P-%03d", gmo->GP[i].bar, gmo->GP[i].pattern);
      GPBrowser->add (temp);
      GPBrowser->select (i);
    }
  else
    fl_message (gettext ("Sorry Track Full"));
}

void
GMORGAN::cb_Add1 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_Add1_i (o, v);
}

void
GMORGAN::cb_aboutwindow_i (Fl_Double_Window *, void *)
{
  gmo->ABOW = 0;
  aboutwindow->hide ();
  aboutwindow->clear ();
}

void
GMORGAN::cb_aboutwindow (Fl_Double_Window * o, void *v)
{
  ((GMORGAN *) (o->user_data ()))->cb_aboutwindow_i (o, v);
}

void
GMORGAN::cb_OK_i (Fl_Button *, void *)
{
  gmo->ABOW = 0;
  aboutwindow->hide ();
  aboutwindow->clear ();
}

void
GMORGAN::cb_OK (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->user_data ()))->cb_OK_i (o, v);
}

Fl_Double_Window *
GMORGAN::make_window ()
{
  MFile->label (gettext ("&File"));
  MFilesub1->label (gettext ("&Load Sounds..."));
  MFilesub2->label (gettext ("&Save Sounds..."));
  MFilesub3->label (gettext ("Load one Sound ..."));
  MFilesub4->label (gettext ("Save one Sound..."));
  MFilesub5->label (gettext ("Load Patterns..."));
  MFilesub6->label (gettext ("Save Patterns..."));
  MFilesub7->label (gettext ("Load one Pattern..."));
  MFilesub8->label (gettext ("Save one Pattern"));
  MFilesub9->label (gettext ("Load Styles..."));
  MFilesub10->label (gettext ("Save Styles..."));
  MFilesub11->label (gettext ("Load one Style..."));
  MFilesub12->label (gettext ("Save one Style..."));
  MFilesub13->label (gettext ("Load Song"));
  MFilesub14->label (gettext ("Save Song"));
  MFilesub15->label (gettext ("Export Midifile"));
  MFilesub16->label (gettext ("E&xit"));
  EditWins->label (gettext ("&Edit"));
  EditWinssub1->label (gettext ("Pattern"));
  EditWinssub2->label (gettext ("Pattern Global Drum"));
  EditWinssub3->label (gettext ("Pattern Control"));
  EditWinssub4->label (gettext ("Style"));
  EditWinssub5->label (gettext ("Import Midifile"));
  EditWinssub6->label (gettext ("Velocity"));
  MBank->label (gettext ("&Sounds"));
  BPlay->label (gettext ("Se&quencer"));
  MenuUtils->label (gettext ("&Utils"));
  MenuUtilssub1->label (gettext ("&Keyb"));
  MenuUtilssub2->label (gettext ("Se&lector"));
  MenuUtilssub3->label (gettext ("Master"));
  MenuUtilssub4->label (gettext ("Generator"));
  MenuUtilssub5->label (gettext ("Guided Play"));
  MSettings->label (gettext ("&Settings"));
  MSettingssub1->label (gettext ("Preset File"));
  MSettingssub2->label (gettext ("Drum Note File"));
  MSettingssub3->label (gettext ("&Global"));
  MenuHelp->label (gettext ("&Help"));
  MenuHelpsub1->label (gettext ("Help"));
  MenuHelpsub2->label (gettext ("&About"));

  Fl::redraw ();
  {
    gmorganwin = new Fl_Double_Window (815, 715, gettext ("gmorgan v0.79"));
    gmorganwin->tooltip (gettext ("Set first Midi Voices - mode must be on "));
    gmorganwin->color (FL_LIGHT2);
    gmorganwin->callback ((Fl_Callback *) cb_gmorganwin, (void *) (this));
    gmorganwin->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    {
      MenuPrincipal = new Fl_Box (0, 0, 800, 25);
      MenuPrincipal->box (FL_THIN_UP_BOX);
      MenuPrincipal->color (FL_LIGHT2);
      MenuPrincipal->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* MenuPrincipal
    {
      Menu = new Fl_Menu_Bar (0, 0, 395, 25);
      Menu->box (FL_NO_BOX);
      Menu->color (FL_LIGHT2);
      Menu->selection_color ((Fl_Color) 138);
      Menu->labelsize (10);
      Menu->textsize (12);
      Menu->align (FL_ALIGN_BOTTOM_LEFT);
      Menu->menu (menu_Menu);
    }				// Fl_Menu_Bar* Menu
    {
      MenuAyuda = new Fl_Menu_Bar (745, 0, 55, 25);
      MenuAyuda->box (FL_NO_BOX);
      MenuAyuda->color (FL_LIGHT2);
      MenuAyuda->menu (menu_MenuAyuda);
    }				// Fl_Menu_Bar* MenuAyuda
    {
      CAJASALIDAS2 = new Fl_Box (510, 25, 290, 70);
      CAJASALIDAS2->box (FL_THIN_UP_FRAME);
      CAJASALIDAS2->color (FL_FOREGROUND_COLOR);
      CAJASALIDAS2->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJASALIDAS2
    {
      CAJABROWSERS2 = new Fl_Box (510, 95, 290, 130);
      CAJABROWSERS2->box (FL_THIN_UP_FRAME);
      CAJABROWSERS2->color (FL_FOREGROUND_COLOR);
      CAJABROWSERS2->labelsize (10);
      CAJABROWSERS2->labelcolor ((Fl_Color) 1);
      CAJABROWSERS2->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJABROWSERS2
    {
      CAJASALIDAS = new Fl_Box (0, 25, 510, 70);
      CAJASALIDAS->box (FL_THIN_UP_FRAME);
      CAJASALIDAS->color (FL_FOREGROUND_COLOR);
      CAJASALIDAS->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJASALIDAS
    {
      CAJAPANICO = new Fl_Box (0, 95, 90, 130, gettext ("panico"));
      CAJAPANICO->box (FL_THIN_UP_FRAME);
      CAJAPANICO->labeltype (FL_NO_LABEL);
    }				// Fl_Box* CAJAPANICO
    {
      CAJABROWSERS = new Fl_Box (90, 95, 420, 130);
      CAJABROWSERS->box (FL_THIN_UP_FRAME);
      CAJABROWSERS->color (FL_FOREGROUND_COLOR);
      CAJABROWSERS->labelsize (10);
      CAJABROWSERS->labelcolor ((Fl_Color) 1);
      CAJABROWSERS->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJABROWSERS
    {
      CAJAACC1 = new Fl_Box (270, 230, 75, 375);
      CAJAACC1->box (FL_THIN_UP_FRAME);
      CAJAACC1->color (FL_FOREGROUND_COLOR);
      CAJAACC1->labelsize (20);
      CAJAACC1->labelcolor ((Fl_Color) 1);
      CAJAACC1->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJAACC1
    {
      CAJAACC2 = new Fl_Box (345, 230, 75, 375);
      CAJAACC2->box (FL_THIN_UP_FRAME);
      CAJAACC2->color (FL_FOREGROUND_COLOR);
      CAJAACC2->labelsize (20);
      CAJAACC2->labelcolor ((Fl_Color) 1);
      CAJAACC2->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJAACC2
    {
      CAJAACC3 = new Fl_Box (420, 230, 75, 375);
      CAJAACC3->box (FL_THIN_UP_FRAME);
      CAJAACC3->color (FL_FOREGROUND_COLOR);
      CAJAACC3->labelsize (20);
      CAJAACC3->labelcolor ((Fl_Color) 1);
      CAJAACC3->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJAACC3
    {
      CAJABASS = new Fl_Box (645, 280, 80, 320);
      CAJABASS->box (FL_THIN_UP_FRAME);
      CAJABASS->color (FL_FOREGROUND_COLOR);
      CAJABASS->labelsize (20);
      CAJABASS->labelcolor ((Fl_Color) 1);
      CAJABASS->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJABASS
    {
      CAJADRUMS = new Fl_Box (725, 280, 75, 320);
      CAJADRUMS->box (FL_THIN_UP_FRAME);
      CAJADRUMS->color (FL_FOREGROUND_COLOR);
      CAJADRUMS->labelsize (20);
      CAJADRUMS->labelcolor ((Fl_Color) 1);
      CAJADRUMS->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJADRUMS
    {
      CAJANOMSTYL = new Fl_Box (570, 225, 230, 55);
      CAJANOMSTYL->box (FL_THIN_UP_FRAME);
      CAJANOMSTYL->color (FL_FOREGROUND_COLOR);
      CAJANOMSTYL->labelsize (20);
      CAJANOMSTYL->labelcolor ((Fl_Color) 1);
      CAJANOMSTYL->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJANOMSTYL
    {
      CAJAHARMONIZER = new Fl_Box (280, 625, 120, 65);
      CAJAHARMONIZER->box (FL_THIN_UP_FRAME);
      CAJAHARMONIZER->color (FL_FOREGROUND_COLOR);
      CAJAHARMONIZER->labelsize (20);
      CAJAHARMONIZER->labelcolor ((Fl_Color) 1);
      CAJAHARMONIZER->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJAHARMONIZER
    {
      Nombre = new Fl_Input (10, 35, 280, 50, gettext (" "));
      Nombre->tooltip (gettext ("Sound"));
      Nombre->box (FL_PLASTIC_DOWN_BOX);
      Nombre->color (FL_CYAN);
      Nombre->labeltype (FL_ENGRAVED_LABEL);
      Nombre->labelsize (21);
      Nombre->labelcolor ((Fl_Color) 208);
      Nombre->textsize (29);
      Nombre->callback ((Fl_Callback *) cb_Nombre);
      Nombre->align (68);
    }				// Fl_Input* Nombre
    {
      Fl_Box *o = DMIN1 = new Fl_Box (520, 35, 190, 25);
      DMIN1->tooltip (gettext ("Input Midi Port"));
      DMIN1->box (FL_PLASTIC_DOWN_BOX);
      DMIN1->color (FL_WHITE);
      DMIN1->labelsize (12);
      DMIN1->callback ((Fl_Callback *) cb_DMIN1);
      DMIN1->align (68 | FL_ALIGN_INSIDE);
      o->label (gmo->MidiInPuerto[1].pMIDIIN);
    }				// Fl_Box* DMIN1
    {
      Fl_Slider *o = VUI1 =
	new Fl_Slider (720, 35, 65, 35, gettext ("MIDI IN"));
      VUI1->type (2);
      VUI1->color ((Fl_Color) 30);
      VUI1->selection_color ((Fl_Color) 158);
      VUI1->labelsize (10);
      VUI1->minimum (127);
      VUI1->maximum (0);
      VUI1->step (1);
      VUI1->callback ((Fl_Callback *) cb_VUI1);
      o->value (vum);
    }				// Fl_Slider* VUI1
    {
      Fl_Box *o = DMO1 = new Fl_Box (520, 60, 190, 25);
      DMO1->tooltip (gettext ("Midi Output Port"));
      DMO1->box (FL_PLASTIC_DOWN_BOX);
      DMO1->color (FL_WHITE);
      DMO1->labelsize (12);
      DMO1->callback ((Fl_Callback *) cb_DMO1);
      DMO1->align (68 | FL_ALIGN_INSIDE);
      o->label (gmo->MidiOutPuerto[1].pMIDIOUT);
    }				// Fl_Box* DMO1
    {
      P1 = new Fl_Box (0, 610, 60, 25);
      P1->tooltip (gettext ("Voice 1 Name"));
      P1->box (FL_PLASTIC_DOWN_BOX);
      P1->color ((Fl_Color) 55);
      P1->selection_color ((Fl_Color) 238);
      P1->labelsize (8);
      P1->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P1
    {
      P2 = new Fl_Box (70, 610, 60, 25);
      P2->tooltip (gettext ("Voice 2 Name"));
      P2->box (FL_PLASTIC_DOWN_BOX);
      P2->color ((Fl_Color) 55);
      P2->selection_color ((Fl_Color) 238);
      P2->labelsize (8);
      P2->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P2
    {
      ACI = new Fl_Box (585, 230, 200, 45);
      ACI->tooltip (gettext ("Chord Display"));
      ACI->box (FL_PLASTIC_DOWN_BOX);
      ACI->color ((Fl_Color) 215);
      ACI->labeltype (FL_ENGRAVED_LABEL);
      ACI->labelfont (1);
      ACI->labelsize (22);
      ACI->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* ACI
    {
      FPan1 = new Fl_Dial (35, 360, 30, 30, gettext ("Pan"));
      FPan1->tooltip (gettext ("Pan"));
      FPan1->box (FL_ROUND_UP_BOX);
      FPan1->color (FL_DARK1);
      FPan1->selection_color ((Fl_Color) 127);
      FPan1->labelsize (8);
      FPan1->labelcolor ((Fl_Color) 43);
      FPan1->maximum (127);
      FPan1->step (1);
      FPan1->value (64);
      FPan1->callback ((Fl_Callback *) cb_FPan1);
      FPan1->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan1
    {
      FPan2 = new Fl_Dial (100, 360, 30, 30, gettext ("Pan"));
      FPan2->tooltip (gettext ("Pan"));
      FPan2->box (FL_ROUND_UP_BOX);
      FPan2->color (FL_DARK1);
      FPan2->selection_color ((Fl_Color) 127);
      FPan2->labelsize (8);
      FPan2->labelcolor ((Fl_Color) 43);
      FPan2->maximum (127);
      FPan2->step (1);
      FPan2->value (64);
      FPan2->callback ((Fl_Callback *) cb_FPan2);
      FPan2->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan2
    {
      FPan3 = new Fl_Dial (170, 360, 30, 30, gettext ("Pan"));
      FPan3->box (FL_ROUND_UP_BOX);
      FPan3->color (FL_DARK1);
      FPan3->selection_color ((Fl_Color) 127);
      FPan3->labelsize (8);
      FPan3->labelcolor ((Fl_Color) 43);
      FPan3->maximum (127);
      FPan3->step (1);
      FPan3->value (64);
      FPan3->callback ((Fl_Callback *) cb_FPan3);
      FPan3->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan3
    {
      FPan4 = new Fl_Dial (235, 360, 30, 30, gettext ("Pan"));
      FPan4->box (FL_ROUND_UP_BOX);
      FPan4->color (FL_DARK1);
      FPan4->selection_color ((Fl_Color) 127);
      FPan4->labelsize (8);
      FPan4->labelcolor ((Fl_Color) 43);
      FPan4->maximum (127);
      FPan4->step (1);
      FPan4->value (64);
      FPan4->callback ((Fl_Callback *) cb_FPan4);
      FPan4->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan4
    {
      FRev1 = new Fl_Dial (35, 405, 30, 30, gettext ("Reverb"));
      FRev1->tooltip (gettext ("Reverb Left Keyboard 1"));
      FRev1->type (1);
      FRev1->box (FL_ROUND_UP_BOX);
      FRev1->color (FL_DARK1);
      FRev1->selection_color ((Fl_Color) 82);
      FRev1->labelsize (8);
      FRev1->labelcolor ((Fl_Color) 43);
      FRev1->maximum (127);
      FRev1->step (1);
      FRev1->callback ((Fl_Callback *) cb_FRev1);
      FRev1->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev1
    {
      FCho1 = new Fl_Dial (35, 455, 30, 30, gettext ("Chorus"));
      FCho1->tooltip (gettext ("Chorus"));
      FCho1->type (1);
      FCho1->box (FL_ROUND_UP_BOX);
      FCho1->color (FL_DARK1);
      FCho1->selection_color ((Fl_Color) 82);
      FCho1->labelsize (8);
      FCho1->labelcolor ((Fl_Color) 43);
      FCho1->maximum (127);
      FCho1->step (1);
      FCho1->callback ((Fl_Callback *) cb_FCho1);
      FCho1->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho1
    {
      FRev2 = new Fl_Dial (100, 405, 30, 30, gettext ("Reverb"));
      FRev2->tooltip (gettext ("Reverb Left Keyboard #2"));
      FRev2->type (1);
      FRev2->box (FL_ROUND_UP_BOX);
      FRev2->color (FL_DARK1);
      FRev2->selection_color ((Fl_Color) 82);
      FRev2->labelsize (8);
      FRev2->labelcolor ((Fl_Color) 43);
      FRev2->maximum (127);
      FRev2->step (1);
      FRev2->callback ((Fl_Callback *) cb_FRev2);
      FRev2->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev2
    {
      FRev3 = new Fl_Dial (170, 405, 30, 30, gettext ("Reverb"));
      FRev3->type (1);
      FRev3->box (FL_ROUND_UP_BOX);
      FRev3->color (FL_DARK1);
      FRev3->selection_color ((Fl_Color) 82);
      FRev3->labelsize (8);
      FRev3->labelcolor ((Fl_Color) 43);
      FRev3->maximum (127);
      FRev3->step (1);
      FRev3->callback ((Fl_Callback *) cb_FRev3);
      FRev3->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev3
    {
      FRev4 = new Fl_Dial (235, 405, 30, 30, gettext ("Reverb"));
      FRev4->type (1);
      FRev4->box (FL_ROUND_UP_BOX);
      FRev4->color (FL_DARK1);
      FRev4->selection_color ((Fl_Color) 82);
      FRev4->labelsize (8);
      FRev4->labelcolor ((Fl_Color) 43);
      FRev4->maximum (127);
      FRev4->step (1);
      FRev4->callback ((Fl_Callback *) cb_FRev4);
      FRev4->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev4
    {
      FCho2 = new Fl_Dial (100, 455, 30, 30, gettext ("Chorus"));
      FCho2->tooltip (gettext ("Chorus"));
      FCho2->type (1);
      FCho2->box (FL_ROUND_UP_BOX);
      FCho2->color (FL_DARK1);
      FCho2->selection_color ((Fl_Color) 82);
      FCho2->labelsize (8);
      FCho2->labelcolor ((Fl_Color) 43);
      FCho2->maximum (127);
      FCho2->step (1);
      FCho2->callback ((Fl_Callback *) cb_FCho2);
      FCho2->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho2
    {
      FCho3 = new Fl_Dial (170, 455, 30, 30, gettext ("Chorus"));
      FCho3->type (1);
      FCho3->box (FL_ROUND_UP_BOX);
      FCho3->color (FL_DARK1);
      FCho3->selection_color ((Fl_Color) 82);
      FCho3->labelsize (8);
      FCho3->labelcolor ((Fl_Color) 43);
      FCho3->maximum (127);
      FCho3->step (1);
      FCho3->callback ((Fl_Callback *) cb_FCho3);
      FCho3->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho3
    {
      FCho4 = new Fl_Dial (235, 455, 30, 30, gettext ("Chorus"));
      FCho4->type (1);
      FCho4->box (FL_ROUND_UP_BOX);
      FCho4->color (FL_DARK1);
      FCho4->selection_color ((Fl_Color) 82);
      FCho4->labelsize (8);
      FCho4->labelcolor ((Fl_Color) 43);
      FCho4->maximum (127);
      FCho4->step (1);
      FCho4->callback ((Fl_Callback *) cb_FCho4);
      FCho4->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho4
    {
      P3 = new Fl_Box (140, 610, 60, 25);
      P3->box (FL_PLASTIC_DOWN_BOX);
      P3->color ((Fl_Color) 55);
      P3->selection_color ((Fl_Color) 238);
      P3->labelsize (8);
      P3->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P3
    {
      P4 = new Fl_Box (205, 610, 60, 25);
      P4->box (FL_PLASTIC_DOWN_BOX);
      P4->color ((Fl_Color) 55);
      P4->selection_color ((Fl_Color) 238);
      P4->labelsize (8);
      P4->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P4
    {
      DispNumber = new Fl_Box (10, 105, 70, 65, gettext ("---"));
      DispNumber->box (FL_DOWN_BOX);
      DispNumber->color (FL_FOREGROUND_COLOR);
      DispNumber->selection_color (FL_BACKGROUND2_COLOR);
      DispNumber->labeltype (FL_ENGRAVED_LABEL);
      DispNumber->labelfont (14);
      DispNumber->labelsize (28);
      DispNumber->labelcolor ((Fl_Color) 128);
      DispNumber->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* DispNumber
    {
      PANICO = new Fl_Button (0, 670, 70, 45, gettext ("Panic"));
      PANICO->tooltip (gettext ("Stop everything."));
      PANICO->box (FL_PLASTIC_UP_BOX);
      PANICO->shortcut (0x70);
      PANICO->color ((Fl_Color) 1);
      PANICO->selection_color (FL_RED);
      PANICO->labeltype (FL_ENGRAVED_LABEL);
      PANICO->callback ((Fl_Callback *) cb_PANICO);
      PANICO->align (FL_ALIGN_CLIP);
    }				// Fl_Button* PANICO
    {
      FVol1 = new Fl_Slider (5, 330, 25, 160);
      FVol1->tooltip (gettext ("Volume Voice 1"));
      FVol1->type (4);
      FVol1->box (FL_PLASTIC_DOWN_BOX);
      FVol1->color ((Fl_Color) 33);
      FVol1->selection_color ((Fl_Color) 82);
      FVol1->minimum (127);
      FVol1->maximum (0);
      FVol1->step (1);
      FVol1->value (100);
      FVol1->callback ((Fl_Callback *) cb_FVol1);
    }				// Fl_Slider* FVol1
    {
      FVol2 = new Fl_Slider (70, 330, 25, 160);
      FVol2->tooltip (gettext ("Volume Voice 2"));
      FVol2->type (4);
      FVol2->box (FL_PLASTIC_DOWN_BOX);
      FVol2->color ((Fl_Color) 33);
      FVol2->selection_color ((Fl_Color) 82);
      FVol2->minimum (127);
      FVol2->maximum (0);
      FVol2->step (1);
      FVol2->value (100);
      FVol2->callback ((Fl_Callback *) cb_FVol2);
    }				// Fl_Slider* FVol2
    {
      FVol3 = new Fl_Slider (140, 330, 25, 160);
      FVol3->tooltip (gettext ("Volume Voice 3"));
      FVol3->type (4);
      FVol3->box (FL_PLASTIC_DOWN_BOX);
      FVol3->color ((Fl_Color) 33);
      FVol3->selection_color ((Fl_Color) 82);
      FVol3->minimum (127);
      FVol3->maximum (0);
      FVol3->step (1);
      FVol3->value (100);
      FVol3->callback ((Fl_Callback *) cb_FVol3);
    }				// Fl_Slider* FVol3
    {
      FVol4 = new Fl_Slider (205, 330, 25, 160);
      FVol4->tooltip (gettext ("Volume Voice 4"));
      FVol4->type (4);
      FVol4->box (FL_PLASTIC_DOWN_BOX);
      FVol4->color ((Fl_Color) 33);
      FVol4->selection_color ((Fl_Color) 82);
      FVol4->minimum (127);
      FVol4->maximum (0);
      FVol4->step (1);
      FVol4->value (100);
      FVol4->callback ((Fl_Callback *) cb_FVol4);
    }				// Fl_Slider* FVol4
    {
      FProg1 = new Fl_Counter (0, 648, 60, 18, gettext ("Program"));
      FProg1->tooltip (gettext ("Set voice 1"));
      FProg1->type (1);
      FProg1->labelsize (10);
      FProg1->labelcolor ((Fl_Color) 43);
      FProg1->minimum (0);
      FProg1->maximum (127);
      FProg1->step (1);
      FProg1->callback ((Fl_Callback *) cb_FProg1);
      FProg1->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg1
    {
      FProg2 = new Fl_Counter (70, 648, 60, 20, gettext ("Program"));
      FProg2->tooltip (gettext ("Set voice 2"));
      FProg2->type (1);
      FProg2->labelsize (10);
      FProg2->labelcolor ((Fl_Color) 43);
      FProg2->minimum (0);
      FProg2->maximum (127);
      FProg2->step (1);
      FProg2->callback ((Fl_Callback *) cb_FProg2);
      FProg2->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg2
    {
      FProg3 = new Fl_Counter (140, 648, 60, 20, gettext ("Program"));
      FProg3->tooltip (gettext ("Set Voice 3"));
      FProg3->type (1);
      FProg3->labelsize (10);
      FProg3->labelcolor ((Fl_Color) 43);
      FProg3->minimum (0);
      FProg3->maximum (127);
      FProg3->step (1);
      FProg3->callback ((Fl_Callback *) cb_FProg3);
      FProg3->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg3
    {
      FProg4 = new Fl_Counter (205, 648, 60, 20, gettext ("Program"));
      FProg4->tooltip (gettext ("Set voice 4"));
      FProg4->type (1);
      FProg4->labelsize (10);
      FProg4->labelcolor ((Fl_Color) 43);
      FProg4->minimum (0);
      FProg4->maximum (127);
      FProg4->step (1);
      FProg4->callback ((Fl_Callback *) cb_FProg4);
      FProg4->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg4
    {
      FPan5 = new Fl_Dial (305, 360, 30, 30, gettext ("Pan"));
      FPan5->box (FL_ROUND_UP_BOX);
      FPan5->color (FL_DARK1);
      FPan5->selection_color ((Fl_Color) 127);
      FPan5->labelsize (8);
      FPan5->labelcolor ((Fl_Color) 43);
      FPan5->maximum (127);
      FPan5->step (1);
      FPan5->value (64);
      FPan5->callback ((Fl_Callback *) cb_FPan5);
      FPan5->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan5
    {
      FPan6 = new Fl_Dial (380, 360, 30, 30, gettext ("Pan"));
      FPan6->box (FL_ROUND_UP_BOX);
      FPan6->color (FL_DARK1);
      FPan6->selection_color ((Fl_Color) 127);
      FPan6->labelsize (8);
      FPan6->labelcolor ((Fl_Color) 43);
      FPan6->maximum (127);
      FPan6->step (1);
      FPan6->value (64);
      FPan6->callback ((Fl_Callback *) cb_FPan6);
      FPan6->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan6
    {
      FRev5 = new Fl_Dial (305, 405, 30, 30, gettext ("Reverb"));
      FRev5->type (1);
      FRev5->box (FL_ROUND_UP_BOX);
      FRev5->color (FL_DARK1);
      FRev5->selection_color ((Fl_Color) 82);
      FRev5->labelsize (8);
      FRev5->labelcolor ((Fl_Color) 43);
      FRev5->maximum (127);
      FRev5->step (1);
      FRev5->callback ((Fl_Callback *) cb_FRev5);
      FRev5->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev5
    {
      FRev6 = new Fl_Dial (380, 405, 30, 30, gettext ("Reverb"));
      FRev6->type (1);
      FRev6->box (FL_ROUND_UP_BOX);
      FRev6->color (FL_DARK1);
      FRev6->selection_color ((Fl_Color) 82);
      FRev6->labelsize (8);
      FRev6->labelcolor ((Fl_Color) 43);
      FRev6->maximum (127);
      FRev6->step (1);
      FRev6->callback ((Fl_Callback *) cb_FRev6);
      FRev6->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev6
    {
      FCho5 = new Fl_Dial (305, 455, 30, 30, gettext ("Chorus"));
      FCho5->type (1);
      FCho5->box (FL_ROUND_UP_BOX);
      FCho5->color (FL_DARK1);
      FCho5->selection_color ((Fl_Color) 82);
      FCho5->labelsize (8);
      FCho5->labelcolor ((Fl_Color) 43);
      FCho5->maximum (127);
      FCho5->step (1);
      FCho5->callback ((Fl_Callback *) cb_FCho5);
      FCho5->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho5
    {
      FCho6 = new Fl_Dial (380, 455, 30, 30, gettext ("Chorus"));
      FCho6->type (1);
      FCho6->box (FL_ROUND_UP_BOX);
      FCho6->color (FL_DARK1);
      FCho6->selection_color ((Fl_Color) 82);
      FCho6->labelsize (8);
      FCho6->labelcolor ((Fl_Color) 43);
      FCho6->maximum (127);
      FCho6->step (1);
      FCho6->callback ((Fl_Callback *) cb_FCho6);
      FCho6->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho6
    {
      P5 = new Fl_Box (275, 535, 65, 25);
      P5->box (FL_PLASTIC_DOWN_BOX);
      P5->color ((Fl_Color) 55);
      P5->selection_color ((Fl_Color) 238);
      P5->labelsize (8);
      P5->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P5
    {
      P6 = new Fl_Box (350, 535, 65, 25);
      P6->box (FL_PLASTIC_DOWN_BOX);
      P6->color ((Fl_Color) 55);
      P6->selection_color ((Fl_Color) 238);
      P6->labelsize (8);
      P6->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P6
    {
      FVol5 = new Fl_Slider (275, 330, 25, 160);
      FVol5->type (4);
      FVol5->box (FL_PLASTIC_DOWN_BOX);
      FVol5->color ((Fl_Color) 33);
      FVol5->selection_color ((Fl_Color) 82);
      FVol5->minimum (127);
      FVol5->maximum (0);
      FVol5->step (1);
      FVol5->value (100);
      FVol5->callback ((Fl_Callback *) cb_FVol5);
    }				// Fl_Slider* FVol5
    {
      FVol6 = new Fl_Slider (350, 330, 25, 160);
      FVol6->type (4);
      FVol6->box (FL_PLASTIC_DOWN_BOX);
      FVol6->color ((Fl_Color) 33);
      FVol6->selection_color ((Fl_Color) 82);
      FVol6->minimum (127);
      FVol6->maximum (0);
      FVol6->step (1);
      FVol6->value (100);
      FVol6->callback ((Fl_Callback *) cb_FVol6);
    }				// Fl_Slider* FVol6
    {
      FProg5 = new Fl_Counter (275, 575, 65, 20, gettext ("Program"));
      FProg5->type (1);
      FProg5->labelsize (10);
      FProg5->labelcolor ((Fl_Color) 43);
      FProg5->minimum (0);
      FProg5->maximum (127);
      FProg5->step (1);
      FProg5->callback ((Fl_Callback *) cb_FProg5);
      FProg5->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg5
    {
      FProg6 = new Fl_Counter (350, 575, 65, 20, gettext ("Program"));
      FProg6->type (1);
      FProg6->labelsize (10);
      FProg6->labelcolor ((Fl_Color) 43);
      FProg6->minimum (0);
      FProg6->maximum (127);
      FProg6->step (1);
      FProg6->callback ((Fl_Callback *) cb_FProg6);
      FProg6->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg6
    {
      FPan7 = new Fl_Dial (690, 360, 30, 30, gettext ("Pan"));
      FPan7->box (FL_ROUND_UP_BOX);
      FPan7->color (FL_DARK1);
      FPan7->selection_color ((Fl_Color) 127);
      FPan7->labelsize (8);
      FPan7->labelcolor ((Fl_Color) 43);
      FPan7->maximum (127);
      FPan7->step (1);
      FPan7->value (64);
      FPan7->callback ((Fl_Callback *) cb_FPan7);
      FPan7->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan7
    {
      FRev7 = new Fl_Dial (690, 405, 30, 30, gettext ("Reverb"));
      FRev7->type (1);
      FRev7->box (FL_ROUND_UP_BOX);
      FRev7->color (FL_DARK1);
      FRev7->selection_color ((Fl_Color) 82);
      FRev7->labelsize (8);
      FRev7->labelcolor ((Fl_Color) 43);
      FRev7->maximum (127);
      FRev7->step (1);
      FRev7->callback ((Fl_Callback *) cb_FRev7);
      FRev7->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev7
    {
      FCho7 = new Fl_Dial (690, 455, 30, 30, gettext ("Chorus"));
      FCho7->type (1);
      FCho7->box (FL_ROUND_UP_BOX);
      FCho7->color (FL_DARK1);
      FCho7->selection_color ((Fl_Color) 82);
      FCho7->labelsize (8);
      FCho7->labelcolor ((Fl_Color) 43);
      FCho7->maximum (127);
      FCho7->step (1);
      FCho7->callback ((Fl_Callback *) cb_FCho7);
      FCho7->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho7
    {
      P7 = new Fl_Box (650, 535, 70, 25);
      P7->box (FL_PLASTIC_DOWN_BOX);
      P7->color ((Fl_Color) 55);
      P7->selection_color ((Fl_Color) 238);
      P7->labelsize (8);
      P7->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P7
    {
      FVol7 = new Fl_Slider (660, 330, 25, 160);
      FVol7->type (4);
      FVol7->box (FL_PLASTIC_DOWN_BOX);
      FVol7->color ((Fl_Color) 33);
      FVol7->selection_color ((Fl_Color) 82);
      FVol7->minimum (127);
      FVol7->maximum (0);
      FVol7->step (1);
      FVol7->value (100);
      FVol7->callback ((Fl_Callback *) cb_FVol7);
    }				// Fl_Slider* FVol7
    {
      FProg7 = new Fl_Counter (655, 575, 65, 20, gettext ("Program"));
      FProg7->type (1);
      FProg7->labelsize (10);
      FProg7->labelcolor ((Fl_Color) 43);
      FProg7->minimum (0);
      FProg7->maximum (127);
      FProg7->step (1);
      FProg7->callback ((Fl_Callback *) cb_FProg7);
      FProg7->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg7
    {
      FPan8 = new Fl_Dial (765, 360, 30, 30, gettext ("Pan"));
      FPan8->box (FL_ROUND_UP_BOX);
      FPan8->color (FL_DARK1);
      FPan8->selection_color ((Fl_Color) 127);
      FPan8->labelsize (8);
      FPan8->labelcolor ((Fl_Color) 43);
      FPan8->maximum (127);
      FPan8->step (1);
      FPan8->value (64);
      FPan8->callback ((Fl_Callback *) cb_FPan8);
      FPan8->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan8
    {
      FRev8 = new Fl_Dial (765, 405, 30, 30, gettext ("Reverb"));
      FRev8->type (1);
      FRev8->box (FL_ROUND_UP_BOX);
      FRev8->color (FL_DARK1);
      FRev8->selection_color ((Fl_Color) 82);
      FRev8->labelsize (8);
      FRev8->labelcolor ((Fl_Color) 43);
      FRev8->maximum (127);
      FRev8->step (1);
      FRev8->callback ((Fl_Callback *) cb_FRev8);
      FRev8->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev8
    {
      FCho8 = new Fl_Dial (765, 455, 30, 30, gettext ("Chorus"));
      FCho8->type (1);
      FCho8->box (FL_ROUND_UP_BOX);
      FCho8->color (FL_DARK1);
      FCho8->selection_color ((Fl_Color) 82);
      FCho8->labelsize (8);
      FCho8->labelcolor ((Fl_Color) 43);
      FCho8->maximum (127);
      FCho8->step (1);
      FCho8->callback ((Fl_Callback *) cb_FCho8);
      FCho8->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho8
    {
      P8 = new Fl_Box (730, 535, 65, 25);
      P8->box (FL_PLASTIC_DOWN_BOX);
      P8->color ((Fl_Color) 55);
      P8->selection_color ((Fl_Color) 238);
      P8->labelsize (8);
      P8->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P8
    {
      FVol8 = new Fl_Slider (735, 330, 25, 160);
      FVol8->type (4);
      FVol8->box (FL_PLASTIC_DOWN_BOX);
      FVol8->color ((Fl_Color) 33);
      FVol8->selection_color ((Fl_Color) 82);
      FVol8->minimum (127);
      FVol8->maximum (0);
      FVol8->step (1);
      FVol8->value (100);
      FVol8->callback ((Fl_Callback *) cb_FVol8);
    }				// Fl_Slider* FVol8
    {
      FProg8 = new Fl_Counter (730, 575, 65, 20, gettext ("Program"));
      FProg8->type (1);
      FProg8->labelsize (10);
      FProg8->labelcolor ((Fl_Color) 43);
      FProg8->minimum (0);
      FProg8->maximum (127);
      FProg8->step (1);
      FProg8->callback ((Fl_Callback *) cb_FProg8);
      FProg8->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg8
    {
      Pof1 = new Fl_Button (0, 231, 30, 25, gettext ("On"));
      Pof1->tooltip (gettext ("Mute Voice 1"));
      Pof1->type (1);
      Pof1->box (FL_PLASTIC_UP_BOX);
      Pof1->color ((Fl_Color) 55);
      Pof1->selection_color ((Fl_Color) 3);
      Pof1->labeltype (FL_ENGRAVED_LABEL);
      Pof1->labelsize (12);
      Pof1->labelcolor ((Fl_Color) 4);
      Pof1->callback ((Fl_Callback *) cb_Pof1);
      Pof1->align (65 | FL_ALIGN_INSIDE);
    }				// Fl_Button* Pof1
    {
      Pof2 = new Fl_Button (70, 231, 30, 25, gettext ("On"));
      Pof2->tooltip (gettext ("Mute Voice 2"));
      Pof2->type (1);
      Pof2->box (FL_PLASTIC_UP_BOX);
      Pof2->color ((Fl_Color) 55);
      Pof2->selection_color ((Fl_Color) 3);
      Pof2->labeltype (FL_ENGRAVED_LABEL);
      Pof2->labelsize (12);
      Pof2->labelcolor ((Fl_Color) 4);
      Pof2->callback ((Fl_Callback *) cb_Pof2);
      Pof2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Pof2
    {
      Pof3 = new Fl_Button (140, 231, 30, 25, gettext ("On"));
      Pof3->tooltip (gettext ("Mute Voice 3"));
      Pof3->type (1);
      Pof3->box (FL_PLASTIC_UP_BOX);
      Pof3->color ((Fl_Color) 55);
      Pof3->selection_color ((Fl_Color) 3);
      Pof3->labeltype (FL_ENGRAVED_LABEL);
      Pof3->labelsize (12);
      Pof3->labelcolor ((Fl_Color) 4);
      Pof3->callback ((Fl_Callback *) cb_Pof3);
      Pof3->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof3
    {
      Pof4 = new Fl_Button (205, 231, 30, 25, gettext ("On"));
      Pof4->tooltip (gettext ("Mute Voice 4"));
      Pof4->type (1);
      Pof4->box (FL_PLASTIC_UP_BOX);
      Pof4->color ((Fl_Color) 55);
      Pof4->selection_color ((Fl_Color) 3);
      Pof4->labeltype (FL_ENGRAVED_LABEL);
      Pof4->labelsize (12);
      Pof4->labelcolor ((Fl_Color) 4);
      Pof4->callback ((Fl_Callback *) cb_Pof4);
      Pof4->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof4
    {
      Pof5 = new Fl_Button (275, 300, 30, 25, gettext ("On"));
      Pof5->tooltip (gettext ("Turn On Acc 1"));
      Pof5->type (1);
      Pof5->box (FL_PLASTIC_UP_BOX);
      Pof5->color ((Fl_Color) 55);
      Pof5->selection_color ((Fl_Color) 3);
      Pof5->labeltype (FL_ENGRAVED_LABEL);
      Pof5->labelsize (12);
      Pof5->labelcolor ((Fl_Color) 4);
      Pof5->callback ((Fl_Callback *) cb_Pof5);
      Pof5->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof5
    {
      Pof6 = new Fl_Button (350, 300, 30, 25, gettext ("On"));
      Pof6->tooltip (gettext ("Turn On Acc 2"));
      Pof6->type (1);
      Pof6->box (FL_PLASTIC_UP_BOX);
      Pof6->color ((Fl_Color) 55);
      Pof6->selection_color ((Fl_Color) 3);
      Pof6->labeltype (FL_ENGRAVED_LABEL);
      Pof6->labelsize (12);
      Pof6->labelcolor ((Fl_Color) 4);
      Pof6->callback ((Fl_Callback *) cb_Pof6);
      Pof6->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof6
    {
      Pof7 = new Fl_Button (655, 300, 30, 25, gettext ("On"));
      Pof7->tooltip (gettext ("Turn On Bass"));
      Pof7->type (1);
      Pof7->box (FL_PLASTIC_UP_BOX);
      Pof7->color ((Fl_Color) 55);
      Pof7->selection_color ((Fl_Color) 3);
      Pof7->labeltype (FL_ENGRAVED_LABEL);
      Pof7->labelsize (12);
      Pof7->labelcolor ((Fl_Color) 4);
      Pof7->callback ((Fl_Callback *) cb_Pof7);
      Pof7->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof7
    {
      Pof8 = new Fl_Button (730, 300, 30, 25, gettext ("On"));
      Pof8->tooltip (gettext ("Turn On Drums"));
      Pof8->type (1);
      Pof8->box (FL_PLASTIC_UP_BOX);
      Pof8->color ((Fl_Color) 55);
      Pof8->selection_color ((Fl_Color) 3);
      Pof8->labeltype (FL_ENGRAVED_LABEL);
      Pof8->labelsize (12);
      Pof8->labelcolor ((Fl_Color) 4);
      Pof8->callback ((Fl_Callback *) cb_Pof8);
      Pof8->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof8
    {
      StartStop = new Fl_Button (700, 175, 86, 45, gettext ("Start/Stop"));
      StartStop->tooltip (gettext ("Start or Stop Input"));
      StartStop->type (1);
      StartStop->box (FL_PLASTIC_UP_BOX);
      StartStop->shortcut (0x20);
      StartStop->color ((Fl_Color) 55);
      StartStop->selection_color ((Fl_Color) 3);
      StartStop->labeltype (FL_ENGRAVED_LABEL);
      StartStop->labelsize (11);
      StartStop->labelcolor ((Fl_Color) 4);
      StartStop->callback ((Fl_Callback *) cb_StartStop);
      StartStop->align (FL_ALIGN_CLIP);
    }				// Fl_Button* StartStop
    {
      TempoBPM = new Fl_Dial (525, 105, 85, 80);
      TempoBPM->tooltip (gettext ("Tempo in Beats Per Minute"));
      TempoBPM->box (FL_ROUND_UP_BOX);
      TempoBPM->labeltype (FL_ENGRAVED_LABEL);
      TempoBPM->labelcolor ((Fl_Color) 4);
      TempoBPM->minimum (80);
      TempoBPM->maximum (520);
      TempoBPM->step (1);
      TempoBPM->value (200);
      TempoBPM->callback ((Fl_Callback *) cb_TempoBPM);
      TempoBPM->align (FL_ALIGN_LEFT);
    }				// Fl_Dial* TempoBPM
    {
      PtBro = new Fl_Browser (100, 115, 190, 95, gettext ("Patterns"));
      PtBro->tooltip (gettext ("Left Click Select - Right Click Edit"));
      PtBro->type (2);
      PtBro->box (FL_PLASTIC_DOWN_BOX);
      PtBro->color (FL_LIGHT2);
      PtBro->selection_color ((Fl_Color) 138);
      PtBro->labelsize (10);
      PtBro->labelcolor ((Fl_Color) 43);
      PtBro->textfont (1);
      PtBro->textsize (10);
      PtBro->callback ((Fl_Callback *) cb_PtBro);
      PtBro->align (FL_ALIGN_TOP);
    }				// Fl_Browser* PtBro
    {
      Grupito = new Fl_Group (615, 135, 175, 40);
      {
	Fl_Box *o = new Fl_Box (695, 145, 85, 15);
	o->box (FL_THIN_DOWN_FRAME);
	o->color (FL_FOREGROUND_COLOR);
      }				// Fl_Box* o
      {
	N1 = new Fl_Button (700, 148, 19, 12);
	N1->type (102);
	N1->box (FL_THIN_DOWN_BOX);
	N1->down_box (FL_THIN_DOWN_BOX);
	N1->color (FL_DARK_RED);
	N1->selection_color ((Fl_Color) 1);
	N1->when (FL_WHEN_NEVER);
	N1->deactivate ();
      }				// Fl_Button* N1
      {
	N2 = new Fl_Button (719, 148, 19, 12);
	N2->type (102);
	N2->box (FL_THIN_DOWN_BOX);
	N2->down_box (FL_THIN_DOWN_BOX);
	N2->color ((Fl_Color) 59);
	N2->selection_color (FL_GREEN);
	N2->when (FL_WHEN_NEVER);
	N2->deactivate ();
      }				// Fl_Button* N2
      {
	N3 = new Fl_Button (738, 148, 19, 12);
	N3->type (102);
	N3->box (FL_THIN_DOWN_BOX);
	N3->down_box (FL_THIN_DOWN_BOX);
	N3->color ((Fl_Color) 59);
	N3->selection_color (FL_GREEN);
	N3->when (FL_WHEN_NEVER);
	N3->deactivate ();
      }				// Fl_Button* N3
      {
	N4 = new Fl_Button (757, 148, 19, 12);
	N4->type (102);
	N4->box (FL_THIN_DOWN_BOX);
	N4->down_box (FL_THIN_DOWN_BOX);
	N4->color ((Fl_Color) 59);
	N4->selection_color (FL_GREEN);
	N4->when (FL_WHEN_NEVER);
	N4->deactivate ();
      }				// Fl_Button* N4
      Grupito->end ();
    }				// Fl_Group* Grupito
    {
      Mas1 = new Fl_Button (40, 330, 20, 20, gettext ("+"));
      Mas1->box (FL_PLASTIC_UP_BOX);
      Mas1->color ((Fl_Color) 55);
      Mas1->labeltype (FL_ENGRAVED_LABEL);
      Mas1->labelcolor ((Fl_Color) 4);
      Mas1->callback ((Fl_Callback *) cb_Mas1);
      Mas1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas1
    {
      Mas2 = new Fl_Button (105, 330, 20, 20, gettext ("+"));
      Mas2->box (FL_PLASTIC_UP_BOX);
      Mas2->color ((Fl_Color) 55);
      Mas2->labeltype (FL_ENGRAVED_LABEL);
      Mas2->labelcolor ((Fl_Color) 4);
      Mas2->callback ((Fl_Callback *) cb_Mas2);
      Mas2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas2
    {
      Mas3 = new Fl_Button (175, 330, 20, 20, gettext ("+"));
      Mas3->box (FL_PLASTIC_UP_BOX);
      Mas3->color ((Fl_Color) 55);
      Mas3->labeltype (FL_ENGRAVED_LABEL);
      Mas3->labelcolor ((Fl_Color) 4);
      Mas3->callback ((Fl_Callback *) cb_Mas3);
      Mas3->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas3
    {
      Mas4 = new Fl_Button (240, 330, 20, 20, gettext ("+"));
      Mas4->box (FL_PLASTIC_UP_BOX);
      Mas4->color ((Fl_Color) 55);
      Mas4->labeltype (FL_ENGRAVED_LABEL);
      Mas4->labelcolor ((Fl_Color) 4);
      Mas4->callback ((Fl_Callback *) cb_Mas4);
      Mas4->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas4
    {
      Mas5 = new Fl_Button (310, 330, 20, 20, gettext ("+"));
      Mas5->box (FL_PLASTIC_UP_BOX);
      Mas5->color ((Fl_Color) 55);
      Mas5->labeltype (FL_ENGRAVED_LABEL);
      Mas5->labelcolor ((Fl_Color) 4);
      Mas5->callback ((Fl_Callback *) cb_Mas5);
      Mas5->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas5
    {
      Mas6 = new Fl_Button (385, 330, 20, 20, gettext ("+"));
      Mas6->box (FL_PLASTIC_UP_BOX);
      Mas6->color ((Fl_Color) 55);
      Mas6->labeltype (FL_ENGRAVED_LABEL);
      Mas6->labelcolor ((Fl_Color) 4);
      Mas6->callback ((Fl_Callback *) cb_Mas6);
      Mas6->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas6
    {
      Mas8 = new Fl_Button (695, 330, 20, 20, gettext ("+"));
      Mas8->box (FL_PLASTIC_UP_BOX);
      Mas8->color ((Fl_Color) 55);
      Mas8->labeltype (FL_ENGRAVED_LABEL);
      Mas8->labelcolor ((Fl_Color) 4);
      Mas8->callback ((Fl_Callback *) cb_Mas8);
      Mas8->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas8
    {
      Mas9 = new Fl_Button (770, 330, 20, 20, gettext ("+"));
      Mas9->box (FL_PLASTIC_UP_BOX);
      Mas9->color ((Fl_Color) 55);
      Mas9->labeltype (FL_ENGRAVED_LABEL);
      Mas9->labelcolor ((Fl_Color) 4);
      Mas9->callback ((Fl_Callback *) cb_Mas9);
      Mas9->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas9
    {
      StBro = new Fl_Browser (305, 115, 190, 95, gettext ("Styles"));
      StBro->tooltip (gettext ("Left Click Select - Right Click Edit"));
      StBro->type (2);
      StBro->box (FL_PLASTIC_DOWN_BOX);
      StBro->color ((Fl_Color) 51);
      StBro->selection_color ((Fl_Color) 138);
      StBro->labelsize (10);
      StBro->labelcolor ((Fl_Color) 43);
      StBro->textfont (1);
      StBro->textsize (10);
      StBro->callback ((Fl_Callback *) cb_StBro);
      StBro->align (FL_ALIGN_TOP);
    }				// Fl_Browser* StBro
    {
      Fl_Group *o = new Fl_Group (355, 600, 525, 50);
      {
	PIntro = new Fl_Button (425, 610, 70, 25, gettext ("Intro"));
	PIntro->tooltip (gettext ("Intro"));
	PIntro->type (102);
	PIntro->box (FL_PLASTIC_UP_BOX);
	PIntro->shortcut (0x69);
	PIntro->color ((Fl_Color) 127);
	PIntro->selection_color ((Fl_Color) 3);
	PIntro->labelsize (10);
	PIntro->labelcolor ((Fl_Color) 160);
	PIntro->callback ((Fl_Callback *) cb_PIntro);
	PIntro->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* PIntro
      {
	PVar1 = new Fl_Button (505, 610, 100, 25, gettext ("Var1"));
	PVar1->type (102);
	PVar1->box (FL_PLASTIC_UP_BOX);
	PVar1->shortcut (0x31);
	PVar1->color ((Fl_Color) 55);
	PVar1->selection_color ((Fl_Color) 3);
	PVar1->labelsize (10);
	PVar1->labelcolor ((Fl_Color) 160);
	PVar1->callback ((Fl_Callback *) cb_PVar1);
	PVar1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* PVar1
      {
	PVar2 = new Fl_Button (620, 610, 100, 25, gettext ("Var2"));
	PVar2->type (102);
	PVar2->box (FL_PLASTIC_UP_BOX);
	PVar2->shortcut (0x32);
	PVar2->color ((Fl_Color) 55);
	PVar2->selection_color ((Fl_Color) 3);
	PVar2->labelsize (10);
	PVar2->labelcolor ((Fl_Color) 160);
	PVar2->callback ((Fl_Callback *) cb_PVar2);
	PVar2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* PVar2
      {
	PEnding = new Fl_Button (725, 605, 70, 40, gettext ("Ending"));
	PEnding->type (102);
	PEnding->box (FL_PLASTIC_UP_BOX);
	PEnding->shortcut (0x65);
	PEnding->color ((Fl_Color) 127);
	PEnding->selection_color ((Fl_Color) 3);
	PEnding->labelsize (10);
	PEnding->labelcolor ((Fl_Color) 160);
	PEnding->callback ((Fl_Callback *) cb_PEnding);
	PEnding->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* PEnding
      o->end ();
    }				// Fl_Group* o
    {
      CTRANSPOSE = new Fl_Counter (700, 110, 85, 20, gettext ("Transpose"));
      CTRANSPOSE->tooltip (gettext ("Transpose"));
      CTRANSPOSE->type (1);
      CTRANSPOSE->color (FL_LIGHT2);
      CTRANSPOSE->labelsize (10);
      CTRANSPOSE->labelcolor ((Fl_Color) 43);
      CTRANSPOSE->minimum (-7);
      CTRANSPOSE->maximum (7);
      CTRANSPOSE->step (1);
      CTRANSPOSE->textsize (10);
      CTRANSPOSE->callback ((Fl_Callback *) cb_CTRANSPOSE);
      CTRANSPOSE->align (FL_ALIGN_TOP);
    }				// Fl_Counter* CTRANSPOSE
    {
      Fl_Group *o = new Fl_Group (355, 644, 455, 51);
      {
	NEnding = new Fl_Button (730, 650, 70, 45, gettext ("Ending"));
	NEnding->type (102);
	NEnding->box (FL_PLASTIC_UP_BOX);
	NEnding->shortcut (0x62);
	NEnding->color ((Fl_Color) 55);
	NEnding->selection_color ((Fl_Color) 3);
	NEnding->labelsize (10);
	NEnding->labelcolor ((Fl_Color) 160);
	NEnding->callback ((Fl_Callback *) cb_NEnding);
	NEnding->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* NEnding
      {
	NVar1 = new Fl_Button (485, 655, 70, 35, gettext ("Var1"));
	NVar1->type (102);
	NVar1->box (FL_PLASTIC_UP_BOX);
	NVar1->shortcut (0x7a);
	NVar1->color ((Fl_Color) 55);
	NVar1->selection_color ((Fl_Color) 3);
	NVar1->labelsize (10);
	NVar1->labelcolor ((Fl_Color) 160);
	NVar1->callback ((Fl_Callback *) cb_NVar1);
	NVar1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* NVar1
      {
	NVar2 = new Fl_Button (610, 655, 50, 35, gettext ("Var2"));
	NVar2->type (102);
	NVar2->box (FL_PLASTIC_UP_BOX);
	NVar2->value (1);
	NVar2->shortcut (0x63);
	NVar2->color ((Fl_Color) 55);
	NVar2->selection_color ((Fl_Color) 3);
	NVar2->labelsize (10);
	NVar2->labelcolor ((Fl_Color) 160);
	NVar2->callback ((Fl_Callback *) cb_NVar2);
	NVar2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* NVar2
      {
	NFill1 = new Fl_Button (560, 655, 50, 35, gettext ("Fill1"));
	NFill1->type (102);
	NFill1->box (FL_PLASTIC_UP_BOX);
	NFill1->shortcut (0x78);
	NFill1->color ((Fl_Color) 55);
	NFill1->selection_color ((Fl_Color) 3);
	NFill1->labelsize (10);
	NFill1->labelcolor ((Fl_Color) 160);
	NFill1->callback ((Fl_Callback *) cb_NFill1);
	NFill1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* NFill1
      {
	NFill2 = new Fl_Button (665, 655, 50, 35, gettext ("Fill2"));
	NFill2->type (102);
	NFill2->box (FL_PLASTIC_UP_BOX);
	NFill2->shortcut (0x76);
	NFill2->color ((Fl_Color) 55);
	NFill2->selection_color ((Fl_Color) 3);
	NFill2->labelsize (10);
	NFill2->labelcolor ((Fl_Color) 160);
	NFill2->callback ((Fl_Callback *) cb_NFill2);
	NFill2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* NFill2
      o->end ();
    }				// Fl_Group* o
    {
      STY1 = new Fl_Box (305, 35, 190, 50);
      STY1->box (FL_PLASTIC_DOWN_BOX);
      STY1->color (FL_CYAN);
      STY1->selection_color (FL_CYAN);
      STY1->labeltype (FL_ENGRAVED_LABEL);
      STY1->labelsize (29);
      STY1->labelcolor (FL_RED);
      STY1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STY1
    {
      DispTempo = new Fl_Box (620, 135, 70, 40, gettext ("---"));
      DispTempo->tooltip (gettext ("Tempo Display"));
      DispTempo->box (FL_DOWN_BOX);
      DispTempo->color (FL_FOREGROUND_COLOR);
      DispTempo->selection_color (FL_BACKGROUND2_COLOR);
      DispTempo->labeltype (FL_ENGRAVED_LABEL);
      DispTempo->labelfont (14);
      DispTempo->labelsize (26);
      DispTempo->labelcolor ((Fl_Color) 128);
      DispTempo->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* DispTempo
    {
      DispBlack = new Fl_Box (640, 185, 50, 35, gettext ("-"));
      DispBlack->tooltip (gettext ("Display Current Bar Number"));
      DispBlack->box (FL_DOWN_BOX);
      DispBlack->color (FL_FOREGROUND_COLOR);
      DispBlack->selection_color (FL_BACKGROUND2_COLOR);
      DispBlack->labelfont (14);
      DispBlack->labelsize (20);
      DispBlack->labelcolor ((Fl_Color) 128);
      DispBlack->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* DispBlack
    {
      FPan9 = new Fl_Dial (455, 360, 30, 30, gettext ("Pan"));
      FPan9->box (FL_ROUND_UP_BOX);
      FPan9->color (FL_DARK1);
      FPan9->selection_color ((Fl_Color) 127);
      FPan9->labelsize (8);
      FPan9->labelcolor ((Fl_Color) 43);
      FPan9->maximum (127);
      FPan9->step (1);
      FPan9->value (64);
      FPan9->callback ((Fl_Callback *) cb_FPan9);
      FPan9->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan9
    {
      FRev9 = new Fl_Dial (455, 405, 30, 30, gettext ("Reverb"));
      FRev9->type (1);
      FRev9->box (FL_ROUND_UP_BOX);
      FRev9->color (FL_DARK1);
      FRev9->selection_color ((Fl_Color) 82);
      FRev9->labelsize (8);
      FRev9->labelcolor ((Fl_Color) 43);
      FRev9->maximum (127);
      FRev9->step (1);
      FRev9->callback ((Fl_Callback *) cb_FRev9);
      FRev9->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev9
    {
      FCho9 = new Fl_Dial (455, 455, 30, 30, gettext ("Chorus"));
      FCho9->type (1);
      FCho9->box (FL_ROUND_UP_BOX);
      FCho9->color (FL_DARK1);
      FCho9->selection_color ((Fl_Color) 82);
      FCho9->labelsize (8);
      FCho9->labelcolor ((Fl_Color) 43);
      FCho9->maximum (127);
      FCho9->step (1);
      FCho9->callback ((Fl_Callback *) cb_FCho9);
      FCho9->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho9
    {
      P9 = new Fl_Box (425, 535, 65, 25);
      P9->box (FL_PLASTIC_DOWN_BOX);
      P9->color ((Fl_Color) 55);
      P9->selection_color ((Fl_Color) 238);
      P9->labelsize (8);
      P9->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P9
    {
      FVol9 = new Fl_Slider (425, 330, 25, 160);
      FVol9->type (4);
      FVol9->box (FL_PLASTIC_DOWN_BOX);
      FVol9->color ((Fl_Color) 33);
      FVol9->selection_color ((Fl_Color) 82);
      FVol9->minimum (127);
      FVol9->maximum (0);
      FVol9->step (1);
      FVol9->value (100);
      FVol9->callback ((Fl_Callback *) cb_FVol9);
    }				// Fl_Slider* FVol9
    {
      FProg9 = new Fl_Counter (425, 575, 65, 20, gettext ("Program"));
      FProg9->type (1);
      FProg9->labelsize (10);
      FProg9->labelcolor ((Fl_Color) 43);
      FProg9->minimum (0);
      FProg9->maximum (127);
      FProg9->step (1);
      FProg9->callback ((Fl_Callback *) cb_FProg9);
      FProg9->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg9
    {
      Pof9 = new Fl_Button (425, 300, 30, 25, gettext ("On"));
      Pof9->tooltip (gettext ("Turn On Acc 3"));
      Pof9->type (1);
      Pof9->box (FL_PLASTIC_UP_BOX);
      Pof9->color ((Fl_Color) 55);
      Pof9->selection_color ((Fl_Color) 3);
      Pof9->labeltype (FL_ENGRAVED_LABEL);
      Pof9->labelsize (12);
      Pof9->labelcolor ((Fl_Color) 4);
      Pof9->callback ((Fl_Callback *) cb_Pof9);
      Pof9->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof9
    {
      Mas7 = new Fl_Button (460, 330, 20, 20, gettext ("+"));
      Mas7->box (FL_PLASTIC_UP_BOX);
      Mas7->color ((Fl_Color) 55);
      Mas7->labeltype (FL_ENGRAVED_LABEL);
      Mas7->labelcolor ((Fl_Color) 4);
      Mas7->callback ((Fl_Callback *) cb_Mas7);
      Mas7->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas7
    {
      ProSlider = new Fl_Counter (10, 185, 70, 25, gettext ("Program"));
      ProSlider->type (1);
      ProSlider->color (FL_LIGHT2);
      ProSlider->selection_color ((Fl_Color) 4);
      ProSlider->labelsize (10);
      ProSlider->labelcolor ((Fl_Color) 43);
      ProSlider->minimum (1);
      ProSlider->maximum (100);
      ProSlider->step (1);
      ProSlider->value (1);
      ProSlider->textsize (10);
      ProSlider->callback ((Fl_Callback *) cb_ProSlider);
      ProSlider->align (65);
    }				// Fl_Counter* ProSlider
    {
      HarSlider = new Fl_Counter (320, 635, 50, 20, gettext ("Har."));
      HarSlider->
	tooltip (gettext ("Harmonization options."));
      HarSlider->type (1);
      HarSlider->color (FL_LIGHT2);
      HarSlider->selection_color ((Fl_Color) 3);
      HarSlider->labelsize (10);
      HarSlider->labelcolor ((Fl_Color) 43);
      HarSlider->minimum (0);
      HarSlider->maximum (7);
      HarSlider->step (1);
      HarSlider->textsize (10);
      HarSlider->callback ((Fl_Callback *) cb_HarSlider);
      HarSlider->align (68);
    }				// Fl_Counter* HarSlider
    {
      HZ1 = new Fl_Output (290, 660, 95, 20);
      HZ1->box (FL_PLASTIC_DOWN_BOX);
      HZ1->color ((Fl_Color) 79);
      HZ1->labelsize (12);
      HZ1->labelcolor ((Fl_Color) 1);
      HZ1->textfont (1);
      HZ1->textsize (12);
      HZ1->textcolor (66);
      HZ1->align (FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Output* HZ1
    {
      ACC1LABEL = new Fl_Box (275, 280, 65, 25, gettext ("Acc.1"));
      ACC1LABEL->labeltype (FL_ENGRAVED_LABEL);
      ACC1LABEL->labelsize (18);
      ACC1LABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* ACC1LABEL
    {
      ACC2LABEL = new Fl_Box (350, 280, 65, 25, gettext ("Acc.2"));
      ACC2LABEL->labeltype (FL_ENGRAVED_LABEL);
      ACC2LABEL->labelsize (18);
      ACC2LABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* ACC2LABEL
    {
      ACC3LABEL = new Fl_Box (425, 280, 65, 25, gettext ("Acc.3"));
      ACC3LABEL->labeltype (FL_ENGRAVED_LABEL);
      ACC3LABEL->labelsize (18);
      ACC3LABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* ACC3LABEL
    {
      BASSLABEL = new Fl_Box (650, 280, 70, 25, gettext ("Bass"));
      BASSLABEL->labeltype (FL_ENGRAVED_LABEL);
      BASSLABEL->labelsize (18);
      BASSLABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* BASSLABEL
    {
      DRUMSLABEL = new Fl_Box (730, 280, 65, 25, gettext ("Drums"));
      DRUMSLABEL->labeltype (FL_ENGRAVED_LABEL);
      DRUMSLABEL->labelsize (18);
      DRUMSLABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* DRUMSLABEL
    {
      CTEMPO = new Fl_Counter (620, 110, 70, 20, gettext ("Tempo"));
      CTEMPO->tooltip (gettext ("Set Tempo"));
      CTEMPO->type (1);
      CTEMPO->color (FL_LIGHT2);
      CTEMPO->labelsize (10);
      CTEMPO->labelcolor ((Fl_Color) 43);
      CTEMPO->minimum (40);
      CTEMPO->maximum (260);
      CTEMPO->step (1);
      CTEMPO->value (100);
      CTEMPO->textsize (10);
      CTEMPO->callback ((Fl_Callback *) cb_CTEMPO);
      CTEMPO->align (FL_ALIGN_TOP);
    }				// Fl_Counter* CTEMPO
    {
      CAJANEXT = new Fl_Box (425, 655, 60, 25, gettext ("Next"));
      CAJANEXT->labelsize (10);
      CAJANEXT->labelcolor ((Fl_Color) 43);
    }				// Fl_Box* CAJANEXT
    {
      CAJAACC4 = new Fl_Box (495, 280, 75, 325);
      CAJAACC4->box (FL_THIN_UP_FRAME);
      CAJAACC4->color (FL_FOREGROUND_COLOR);
      CAJAACC4->labelsize (20);
      CAJAACC4->labelcolor ((Fl_Color) 1);
      CAJAACC4->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJAACC4
    {
      ACC4LABEL = new Fl_Box (500, 280, 65, 25, gettext ("Acc.4"));
      ACC4LABEL->labeltype (FL_ENGRAVED_LABEL);
      ACC4LABEL->labelsize (18);
      ACC4LABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* ACC4LABEL
    {
      Pof10 = new Fl_Button (500, 300, 30, 25, gettext ("On"));
      Pof10->tooltip (gettext ("Turn On Acc 4"));
      Pof10->type (1);
      Pof10->box (FL_PLASTIC_UP_BOX);
      Pof10->color ((Fl_Color) 55);
      Pof10->selection_color ((Fl_Color) 3);
      Pof10->labeltype (FL_ENGRAVED_LABEL);
      Pof10->labelsize (12);
      Pof10->labelcolor ((Fl_Color) 4);
      Pof10->callback ((Fl_Callback *) cb_Pof10);
      Pof10->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof10
    {
      Mas10 = new Fl_Button (535, 330, 20, 20, gettext ("+"));
      Mas10->box (FL_PLASTIC_UP_BOX);
      Mas10->color ((Fl_Color) 55);
      Mas10->labeltype (FL_ENGRAVED_LABEL);
      Mas10->labelcolor ((Fl_Color) 4);
      Mas10->callback ((Fl_Callback *) cb_Mas10);
      Mas10->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas10
    {
      CAJAACC5 = new Fl_Box (570, 280, 75, 320);
      CAJAACC5->box (FL_THIN_UP_FRAME);
      CAJAACC5->color (FL_FOREGROUND_COLOR);
      CAJAACC5->labelsize (20);
      CAJAACC5->labelcolor ((Fl_Color) 1);
      CAJAACC5->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* CAJAACC5
    {
      FVol10 = new Fl_Slider (500, 330, 25, 160);
      FVol10->type (4);
      FVol10->box (FL_PLASTIC_DOWN_BOX);
      FVol10->color ((Fl_Color) 33);
      FVol10->selection_color ((Fl_Color) 82);
      FVol10->minimum (127);
      FVol10->maximum (0);
      FVol10->step (1);
      FVol10->value (100);
      FVol10->callback ((Fl_Callback *) cb_FVol10);
    }				// Fl_Slider* FVol10
    {
      FPan10 = new Fl_Dial (530, 360, 30, 30, gettext ("Pan"));
      FPan10->box (FL_ROUND_UP_BOX);
      FPan10->color (FL_DARK1);
      FPan10->selection_color ((Fl_Color) 127);
      FPan10->labelsize (8);
      FPan10->labelcolor ((Fl_Color) 43);
      FPan10->maximum (127);
      FPan10->step (1);
      FPan10->value (64);
      FPan10->callback ((Fl_Callback *) cb_FPan10);
      FPan10->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan10
    {
      FRev10 = new Fl_Dial (530, 405, 30, 30, gettext ("Reverb"));
      FRev10->type (1);
      FRev10->box (FL_ROUND_UP_BOX);
      FRev10->color (FL_DARK1);
      FRev10->selection_color ((Fl_Color) 82);
      FRev10->labelsize (8);
      FRev10->labelcolor ((Fl_Color) 43);
      FRev10->maximum (127);
      FRev10->step (1);
      FRev10->callback ((Fl_Callback *) cb_FRev10);
      FRev10->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev10
    {
      FCho10 = new Fl_Dial (530, 455, 30, 30, gettext ("Chorus"));
      FCho10->type (1);
      FCho10->box (FL_ROUND_UP_BOX);
      FCho10->color (FL_DARK1);
      FCho10->selection_color ((Fl_Color) 82);
      FCho10->labelsize (8);
      FCho10->labelcolor ((Fl_Color) 43);
      FCho10->maximum (127);
      FCho10->step (1);
      FCho10->callback ((Fl_Callback *) cb_FCho10);
      FCho10->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho10
    {
      P10 = new Fl_Box (500, 535, 65, 25);
      P10->box (FL_PLASTIC_DOWN_BOX);
      P10->color ((Fl_Color) 55);
      P10->selection_color ((Fl_Color) 238);
      P10->labelsize (8);
      P10->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P10
    {
      FProg10 = new Fl_Counter (500, 575, 65, 20, gettext ("Program"));
      FProg10->type (1);
      FProg10->labelsize (10);
      FProg10->labelcolor ((Fl_Color) 43);
      FProg10->minimum (0);
      FProg10->maximum (127);
      FProg10->step (1);
      FProg10->callback ((Fl_Callback *) cb_FProg10);
      FProg10->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg10
    {
      ACC5LABEL = new Fl_Box (575, 280, 65, 25, gettext ("Acc.5"));
      ACC5LABEL->labeltype (FL_ENGRAVED_LABEL);
      ACC5LABEL->labelsize (18);
      ACC5LABEL->labelcolor ((Fl_Color) 1);
    }				// Fl_Box* ACC5LABEL
    {
      Pof11 = new Fl_Button (575, 300, 30, 25, gettext ("On"));
      Pof11->tooltip (gettext ("Turn On Acc 5"));
      Pof11->type (1);
      Pof11->box (FL_PLASTIC_UP_BOX);
      Pof11->color ((Fl_Color) 55);
      Pof11->selection_color ((Fl_Color) 3);
      Pof11->labeltype (FL_ENGRAVED_LABEL);
      Pof11->labelsize (12);
      Pof11->labelcolor ((Fl_Color) 4);
      Pof11->callback ((Fl_Callback *) cb_Pof11);
      Pof11->align (FL_ALIGN_CLIP);
    }				// Fl_Button* Pof11
    {
      Mas11 = new Fl_Button (610, 330, 20, 20, gettext ("+"));
      Mas11->box (FL_PLASTIC_UP_BOX);
      Mas11->color ((Fl_Color) 55);
      Mas11->labeltype (FL_ENGRAVED_LABEL);
      Mas11->labelcolor ((Fl_Color) 4);
      Mas11->callback ((Fl_Callback *) cb_Mas11);
      Mas11->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* Mas11
    {
      FVol11 = new Fl_Slider (575, 330, 25, 160);
      FVol11->type (4);
      FVol11->box (FL_PLASTIC_DOWN_BOX);
      FVol11->color ((Fl_Color) 33);
      FVol11->selection_color ((Fl_Color) 82);
      FVol11->minimum (127);
      FVol11->maximum (0);
      FVol11->step (1);
      FVol11->value (100);
      FVol11->callback ((Fl_Callback *) cb_FVol11);
    }				// Fl_Slider* FVol11
    {
      FPan11 = new Fl_Dial (605, 360, 30, 30, gettext ("Pan"));
      FPan11->box (FL_ROUND_UP_BOX);
      FPan11->color (FL_DARK1);
      FPan11->selection_color ((Fl_Color) 127);
      FPan11->labelsize (8);
      FPan11->labelcolor ((Fl_Color) 43);
      FPan11->maximum (127);
      FPan11->step (1);
      FPan11->value (64);
      FPan11->callback ((Fl_Callback *) cb_FPan11);
      FPan11->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FPan11
    {
      FRev11 = new Fl_Dial (605, 405, 30, 30, gettext ("Reverb"));
      FRev11->type (1);
      FRev11->box (FL_ROUND_UP_BOX);
      FRev11->color (FL_DARK1);
      FRev11->selection_color ((Fl_Color) 82);
      FRev11->labelsize (8);
      FRev11->labelcolor ((Fl_Color) 43);
      FRev11->maximum (127);
      FRev11->step (1);
      FRev11->callback ((Fl_Callback *) cb_FRev11);
      FRev11->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FRev11
    {
      FCho11 = new Fl_Dial (605, 455, 30, 30, gettext ("Chorus"));
      FCho11->type (1);
      FCho11->box (FL_ROUND_UP_BOX);
      FCho11->color (FL_DARK1);
      FCho11->selection_color ((Fl_Color) 82);
      FCho11->labelsize (8);
      FCho11->labelcolor ((Fl_Color) 43);
      FCho11->maximum (127);
      FCho11->step (1);
      FCho11->callback ((Fl_Callback *) cb_FCho11);
      FCho11->align (FL_ALIGN_TOP);
    }				// Fl_Dial* FCho11
    {
      P11 = new Fl_Box (575, 535, 65, 25);
      P11->box (FL_PLASTIC_DOWN_BOX);
      P11->color ((Fl_Color) 55);
      P11->selection_color ((Fl_Color) 238);
      P11->labelsize (8);
      P11->align (68 | FL_ALIGN_INSIDE);
    }				// Fl_Box* P11
    {
      FProg11 = new Fl_Counter (575, 575, 65, 20, gettext ("Program"));
      FProg11->type (1);
      FProg11->labelsize (10);
      FProg11->labelcolor ((Fl_Color) 43);
      FProg11->minimum (0);
      FProg11->maximum (127);
      FProg11->step (1);
      FProg11->callback ((Fl_Callback *) cb_FProg11);
      FProg11->align (FL_ALIGN_TOP);
    }				// Fl_Counter* FProg11
    {
      MRecord = new Fl_Button (580, 195, 55, 25, gettext ("Record"));
      MRecord->tooltip (gettext ("Record Midi"));
      MRecord->type (1);
      MRecord->box (FL_PLASTIC_UP_BOX);
      MRecord->shortcut (0x20);
      MRecord->color ((Fl_Color) 212);
      MRecord->selection_color ((Fl_Color) 1);
      MRecord->labeltype (FL_ENGRAVED_LABEL);
      MRecord->labelsize (10);
      MRecord->labelcolor ((Fl_Color) 1);
      MRecord->callback ((Fl_Callback *) cb_MRecord);
      MRecord->align (FL_ALIGN_CLIP);
    }				// Fl_Button* MRecord
    {
      MPlay = new Fl_Button (515, 195, 55, 25, gettext ("Play"));
      MPlay->tooltip (gettext ("Play Midi"));
      MPlay->type (1);
      MPlay->box (FL_PLASTIC_UP_BOX);
      MPlay->shortcut (0x20);
      MPlay->color ((Fl_Color) 51);
      MPlay->selection_color ((Fl_Color) 3);
      MPlay->labeltype (FL_ENGRAVED_LABEL);
      MPlay->labelsize (10);
      MPlay->labelcolor ((Fl_Color) 4);
      MPlay->callback ((Fl_Callback *) cb_MPlay);
      MPlay->align (FL_ALIGN_CLIP);
    }				// Fl_Button* MPlay
    {
      l1mch = new Fl_Counter (0, 509, 60, 20, gettext ("MchV1"));
      l1mch->tooltip (gettext ("Output Midi Channel for v1"));
      l1mch->type (1);
      l1mch->color (FL_BLUE);
      l1mch->minimum (0);
      l1mch->maximum (16);
      l1mch->step (1);
      l1mch->callback ((Fl_Callback *) cb_l1mch);
      l1mch->align (FL_ALIGN_TOP);
    }				// Fl_Counter* l1mch
    {
      MchL2 = new Fl_Counter (70, 509, 60, 20, gettext ("MchL2"));
      MchL2->tooltip (gettext ("Output Midi Channel for V2"));
      MchL2->type (1);
      MchL2->color ((Fl_Color) 176);
      MchL2->minimum (0);
      MchL2->maximum (16);
      MchL2->step (1);
      MchL2->value (1);
      MchL2->callback ((Fl_Callback *) cb_MchL2);
      MchL2->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MchL2
    {
      BassChl = new Fl_Counter (650, 509, 64, 21, gettext ("Bass Chl"));
      BassChl->tooltip (gettext ("Output Midi Channel For Bass"));
      BassChl->type (1);
      BassChl->minimum (0);
      BassChl->maximum (16);
      BassChl->step (1);
      BassChl->value (6);
      BassChl->callback ((Fl_Callback *) cb_BassChl);
      BassChl->align (FL_ALIGN_TOP);
    }				// Fl_Counter* BassChl
    {
      DrumChnl = new Fl_Counter (732, 509, 64, 21, gettext ("Drum Chl"));
      DrumChnl->tooltip (gettext ("Output Midi Channel For Drums"));
      DrumChnl->type (1);
      DrumChnl->minimum (0);
      DrumChnl->maximum (16);
      DrumChnl->step (1);
      DrumChnl->value (9);
      DrumChnl->callback ((Fl_Callback *) cb_DrumChnl);
      DrumChnl->align (FL_ALIGN_TOP);
    }				// Fl_Counter* DrumChnl
    {
      MAcc1 = new Fl_Counter (275, 509, 60, 20, gettext ("MAcc1"));
      MAcc1->tooltip (gettext ("Output Midi Channel For Acc1"));
      MAcc1->type (1);
      MAcc1->minimum (0);
      MAcc1->maximum (16);
      MAcc1->step (1);
      MAcc1->value (4);
      MAcc1->callback ((Fl_Callback *) cb_MAcc1);
      MAcc1->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MAcc1
    {
      MAcc2 = new Fl_Counter (355, 509, 60, 20, gettext ("MAcc2"));
      MAcc2->tooltip (gettext ("Output Midi Channel For Acc2"));
      MAcc2->type (1);
      MAcc2->minimum (0);
      MAcc2->maximum (16);
      MAcc2->step (1);
      MAcc2->value (5);
      MAcc2->callback ((Fl_Callback *) cb_MAcc2);
      MAcc2->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MAcc2
    {
      MAcc3 = new Fl_Counter (425, 509, 60, 20, gettext ("MAcc3"));
      MAcc3->tooltip (gettext ("Output Midi Channel For Accompaniment 3"));
      MAcc3->type (1);
      MAcc3->minimum (0);
      MAcc3->maximum (16);
      MAcc3->step (1);
      MAcc3->value (7);
      MAcc3->callback ((Fl_Callback *) cb_MAcc3);
      MAcc3->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MAcc3
    {
      MAcc4 = new Fl_Counter (500, 509, 64, 21, gettext ("MAcc4"));
      MAcc4->tooltip (gettext ("Output Midi Channel Acc 4"));
      MAcc4->type (1);
      MAcc4->minimum (0);
      MAcc4->maximum (16);
      MAcc4->step (1);
      MAcc4->value (8);
      MAcc4->callback ((Fl_Callback *) cb_MAcc4);
      MAcc4->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MAcc4
    {
      MAcc5 = new Fl_Counter (575, 509, 64, 21, gettext ("MAcc5"));
      MAcc5->tooltip (gettext ("Output Midi Channel Acc 5"));
      MAcc5->type (1);
      MAcc5->minimum (0);
      MAcc5->maximum (1);
      MAcc5->step (16);
      MAcc5->value (10);
      MAcc5->callback ((Fl_Callback *) cb_MAcc5);
      MAcc5->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MAcc5
    {
      MchRKB = new Fl_Counter (138, 509, 60, 20, gettext ("MchV3"));
      MchRKB->tooltip (gettext ("Output Midi Channel V3"));
      MchRKB->type (1);
      MchRKB->color ((Fl_Color) 176);
      MchRKB->minimum (0);
      MchRKB->maximum (16);
      MchRKB->step (1);
      MchRKB->value (2);
      MchRKB->callback ((Fl_Callback *) cb_MchRKB);
      MchRKB->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MchRKB
    {
      MchRKB2 = new Fl_Counter (204, 509, 60, 20, gettext ("MchV4"));
      MchRKB2->tooltip (gettext ("Output Midi Channel V4"));
      MchRKB2->type (1);
      MchRKB2->color (FL_BLUE);
      MchRKB2->minimum (0);
      MchRKB2->maximum (16);
      MchRKB2->step (1);
      MchRKB2->value (3);
      MchRKB2->callback ((Fl_Callback *) cb_MchRKB2);
      MchRKB2->align (FL_ALIGN_TOP);
    }				// Fl_Counter* MchRKB2
    {
      v1HighMidi = new Fl_Counter (0, 584, 60, 16, gettext ("v1 High"));
      v1HighMidi->tooltip (gettext ("V1 Highest Midi Note"));
      v1HighMidi->type (1);
      v1HighMidi->color ((Fl_Color) 208);
      v1HighMidi->selection_color ((Fl_Color) 208);
      v1HighMidi->minimum (0);
      v1HighMidi->maximum (128);
      v1HighMidi->step (1);
      v1HighMidi->value (60);
      v1HighMidi->textcolor (176);
      v1HighMidi->callback ((Fl_Callback *) cb_v1HighMidi);
      v1HighMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v1HighMidi
    {
      v1LowMidi = new Fl_Counter (0, 544, 60, 16, gettext ("v1 Low"));
      v1LowMidi->tooltip (gettext ("V1 Lowest Midi Note"));
      v1LowMidi->type (1);
      v1LowMidi->color ((Fl_Color) 168);
      v1LowMidi->minimum (0);
      v1LowMidi->maximum (120);
      v1LowMidi->step (1);
      v1LowMidi->callback ((Fl_Callback *) cb_v1LowMidi);
      v1LowMidi->align (33);
    }				// Fl_Counter* v1LowMidi
    {
      v1LowVelocity = new Fl_Counter (0, 275, 60, 16, gettext ("LowVel"));
      v1LowVelocity->tooltip (gettext ("v1 Lowest Velocity"));
      v1LowVelocity->type (1);
      v1LowVelocity->color (FL_GREEN);
      v1LowVelocity->minimum (0);
      v1LowVelocity->maximum (100);
      v1LowVelocity->step (1);
      v1LowVelocity->callback ((Fl_Callback *) cb_v1LowVelocity);
      v1LowVelocity->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v1LowVelocity
    {
      v1HighVel = new Fl_Counter (0, 309, 60, 16, gettext ("HiVel"));
      v1HighVel->tooltip (gettext ("V1 Upper Velocity"));
      v1HighVel->type (1);
      v1HighVel->color (FL_GREEN);
      v1HighVel->minimum (0);
      v1HighVel->maximum (199);
      v1HighVel->step (1);
      v1HighVel->value (199);
      v1HighVel->callback ((Fl_Callback *) cb_v1HighVel);
      v1HighVel->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v1HighVel
    {
      v2LowMidi = new Fl_Counter (70, 544, 60, 16, gettext ("v2 Low"));
      v2LowMidi->tooltip (gettext ("Lowest Note Midi Voice 2"));
      v2LowMidi->type (1);
      v2LowMidi->color ((Fl_Color) 208);
      v2LowMidi->minimum (0);
      v2LowMidi->maximum (120);
      v2LowMidi->step (1);
      v2LowMidi->callback ((Fl_Callback *) cb_v2LowMidi);
      v2LowMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v2LowMidi
    {
      v2HighMidi = new Fl_Counter (70, 584, 60, 16, gettext ("v2 High"));
      v2HighMidi->tooltip (gettext ("Voice 2 Highest Note"));
      v2HighMidi->type (1);
      v2HighMidi->color ((Fl_Color) 208);
      v2HighMidi->minimum (0);
      v2HighMidi->maximum (128);
      v2HighMidi->step (1);
      v2HighMidi->value (60);
      v2HighMidi->callback ((Fl_Callback *) cb_v2HighMidi);
      v2HighMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v2HighMidi
    {
      v2LowVelocity = new Fl_Counter (70, 275, 60, 16);
      v2LowVelocity->tooltip (gettext ("v2 lowest velocity"));
      v2LowVelocity->type (1);
      v2LowVelocity->color (FL_GREEN);
      v2LowVelocity->minimum (0);
      v2LowVelocity->maximum (99);
      v2LowVelocity->step (1);
      v2LowVelocity->callback ((Fl_Callback *) cb_v2LowVelocity);
      v2LowVelocity->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v2LowVelocity
    {
      v2HighVel = new Fl_Counter (70, 309, 60, 16);
      v2HighVel->tooltip (gettext ("voice 2 max velocity"));
      v2HighVel->type (1);
      v2HighVel->color (FL_GREEN);
      v2HighVel->minimum (0);
      v2HighVel->maximum (199);
      v2HighVel->step (1);
      v2HighVel->value (199);
      v2HighVel->callback ((Fl_Callback *) cb_v2HighVel);
      v2HighVel->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v2HighVel
    {
      v3LowVelocity = new Fl_Counter (140, 275, 60, 15);
      v3LowVelocity->tooltip (gettext ("v3 lowest velocity"));
      v3LowVelocity->type (1);
      v3LowVelocity->color (FL_GREEN);
      v3LowVelocity->minimum (0);
      v3LowVelocity->maximum (199);
      v3LowVelocity->step (1);
      v3LowVelocity->callback ((Fl_Callback *) cb_v3LowVelocity);
    }				// Fl_Counter* v3LowVelocity
    {
      v4LowVelocity = new Fl_Counter (205, 275, 60, 16);
      v4LowVelocity->tooltip (gettext ("v4 lowest velocity"));
      v4LowVelocity->type (1);
      v4LowVelocity->color (FL_GREEN);
      v4LowVelocity->minimum (0);
      v4LowVelocity->maximum (199);
      v4LowVelocity->step (1);
      v4LowVelocity->callback ((Fl_Callback *) cb_v4LowVelocity);
      v4LowVelocity->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v4LowVelocity
    {
      v3HighVel = new Fl_Counter (140, 309, 60, 16);
      v3HighVel->tooltip (gettext ("v3 max velocity"));
      v3HighVel->type (1);
      v3HighVel->color (FL_GREEN);
      v3HighVel->minimum (0);
      v3HighVel->maximum (199);
      v3HighVel->step (1);
      v3HighVel->value (199);
      v3HighVel->callback ((Fl_Callback *) cb_v3HighVel);
      v3HighVel->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v3HighVel
    {
      v4HighVel = new Fl_Counter (205, 309, 60, 16);
      v4HighVel->tooltip (gettext ("v4 Max Velocity"));
      v4HighVel->type (1);
      v4HighVel->color (FL_GREEN);
      v4HighVel->minimum (0);
      v4HighVel->maximum (199);
      v4HighVel->step (1);
      v4HighVel->value (199);
      v4HighVel->callback ((Fl_Callback *) cb_v4HighVel);
      v4HighVel->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v4HighVel
    {
      v3LowMidi = new Fl_Counter (140, 544, 60, 16, gettext ("v3 Low"));
      v3LowMidi->tooltip (gettext ("voice 3 lowest note"));
      v3LowMidi->type (1);
      v3LowMidi->color ((Fl_Color) 208);
      v3LowMidi->minimum (0);
      v3LowMidi->maximum (128);
      v3LowMidi->step (1);
      v3LowMidi->value (60);
      v3LowMidi->callback ((Fl_Callback *) cb_v3LowMidi);
      v3LowMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v3LowMidi
    {
      v4LowMidi = new Fl_Counter (205, 544, 60, 16, gettext ("v4 Low"));
      v4LowMidi->tooltip (gettext ("Voice 4 Lowest Note"));
      v4LowMidi->type (1);
      v4LowMidi->color ((Fl_Color) 208);
      v4LowMidi->minimum (0);
      v4LowMidi->maximum (128);
      v4LowMidi->step (1);
      v4LowMidi->value (60);
      v4LowMidi->callback ((Fl_Callback *) cb_v4LowMidi);
      v4LowMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v4LowMidi
    {
      v3HighMidi = new Fl_Counter (140, 584, 60, 16, gettext ("v3 High"));
      v3HighMidi->tooltip (gettext ("Voice 3 Highest Note"));
      v3HighMidi->type (1);
      v3HighMidi->color ((Fl_Color) 208);
      v3HighMidi->minimum (0);
      v3HighMidi->maximum (128);
      v3HighMidi->step (1);
      v3HighMidi->value (128);
      v3HighMidi->callback ((Fl_Callback *) cb_v3HighMidi);
      v3HighMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v3HighMidi
    {
      v4HighMidi = new Fl_Counter (205, 584, 60, 16, gettext ("v4 High"));
      v4HighMidi->tooltip (gettext ("Voice 4 Highest Note"));
      v4HighMidi->type (1);
      v4HighMidi->color ((Fl_Color) 208);
      v4HighMidi->minimum (0);
      v4HighMidi->maximum (128);
      v4HighMidi->step (1);
      v4HighMidi->value (128);
      v4HighMidi->callback ((Fl_Callback *) cb_v4HighMidi);
      v4HighMidi->align (FL_ALIGN_TOP);
    }				// Fl_Counter* v4HighMidi
    {
      Fl_Value_Input *o =
	new Fl_Value_Input (520, 245, 50, 35, gettext ("Bar"));
      o->tooltip (gettext ("Input Starting Bar Number"));
      o->color (FL_GRAY0);
      o->labelcolor ((Fl_Color) 1);
      o->value (1);
      o->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Value_Input* o
    { mdimode = new Fl_Counter(720, 74, 64, 21, gettext("Midi Mode"));
      mdimode->type(1);
      mdimode->tooltip(gettext("midi mode"));
      mdimode->color(FL_RED);
      mdimode->minimum(0);
      mdimode->maximum(3);
      mdimode->step(1);
      mdimode->callback((Fl_Callback*)cb_mdimode);
      mdimode->align(Fl_Align(FL_ALIGN_TOP));
    } // Fl_Counter* mdimode

    gmorganwin->end ();
    gmorganwin->resizable (gmorganwin);
  }				// Fl_Double_Window* gmorganwin
  {
    Settingswindow = new Fl_Double_Window (585, 550, gettext ("Settings"));
    Settingswindow->color (FL_LIGHT2);
    Settingswindow->callback ((Fl_Callback *) cb_Settingswindow,
			      (void *) (this));
    {
      SClose = new Fl_Button (485, 515, 85, 30, gettext ("Close"));
      SClose->box (FL_UP_FRAME);
      SClose->shortcut (0xff0d);
      SClose->labelsize (12);
      SClose->callback ((Fl_Callback *) cb_SClose);
    }				// Fl_Button* SClose
    {
      Fl_Button *o = new Fl_Button (390, 515, 85, 30, gettext ("Save"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Save);
    }				// Fl_Button* o
    {
      BMidiIn = new Fl_Browser (25, 30, 180, 100, gettext ("Midi Input to:"));
      BMidiIn->type (2);
      BMidiIn->selection_color (FL_FOREGROUND_COLOR);
      BMidiIn->labelsize (12);
      BMidiIn->textsize (12);
      BMidiIn->callback ((Fl_Callback *) cb_BMidiIn);
      BMidiIn->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Browser* BMidiIn
    {
      BMidiOut =
	new Fl_Browser (225, 30, 180, 100, gettext ("Midi Output to:"));
      BMidiOut->type (2);
      BMidiOut->box (FL_DOWN_BOX);
      BMidiOut->selection_color (FL_FOREGROUND_COLOR);
      BMidiOut->labelsize (12);
      BMidiOut->textsize (12);
      BMidiOut->callback ((Fl_Callback *) cb_BMidiOut);
      BMidiOut->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Browser* BMidiOut
    {
      PaFiname =
	new Fl_File_Input (25, 205, 400, 30, gettext ("Patterns Filename:"));
      PaFiname->labelsize (12);
      PaFiname->textsize (12);
      PaFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* PaFiname
    {
      StFiname =
	new Fl_File_Input (25, 250, 400, 30, gettext ("Styles Filename:"));
      StFiname->labelsize (12);
      StFiname->textsize (12);
      StFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* StFiname
    {
      SoFiname =
	new Fl_File_Input (25, 160, 400, 30, gettext ("Sounds Filename:"));
      SoFiname->labelsize (12);
      SoFiname->textsize (12);
      SoFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* SoFiname
    {
      Fl_Button *o = new Fl_Button (440, 160, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (440, 205, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (440, 250, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse2);
    }				// Fl_Button* o
    {
      PrFiname =
	new Fl_File_Input (25, 295, 400, 30,
			   gettext ("Preset List Filename:"));
      PrFiname->labelsize (12);
      PrFiname->textsize (12);
      PrFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* PrFiname
    {
      DrFiname =
	new Fl_File_Input (25, 340, 400, 30,
			   gettext ("Drum Note Name Filename"));
      DrFiname->labelsize (12);
      DrFiname->textsize (12);
      DrFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* DrFiname
    {
      Fl_Button *o = new Fl_Button (440, 340, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse3);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (440, 295, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse4);
    }				// Fl_Button* o
    {
      SkFiname =
	new Fl_File_Input (25, 430, 400, 30, gettext ("Skin Filename"));
      SkFiname->labelsize (12);
      SkFiname->textsize (12);
      SkFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* SkFiname
    {
      Fl_Button *o = new Fl_Button (440, 430, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse5);
    }				// Fl_Button* o
    {
      SkinBrowser = new Fl_Browser (425, 30, 150, 100, gettext ("Skin:"));
      SkinBrowser->type (2);
      SkinBrowser->selection_color (FL_FOREGROUND_COLOR);
      SkinBrowser->labelsize (12);
      SkinBrowser->textsize (12);
      SkinBrowser->callback ((Fl_Callback *) cb_SkinBrowser);
      SkinBrowser->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Browser* SkinBrowser
    {
      Muoff =
	new Fl_Check_Button (205, 510, 30, 25,
			     gettext ("Mutes depends on patterns"));
      Muoff->down_box (FL_DOWN_BOX);
      Muoff->labelsize (12);
      Muoff->callback ((Fl_Callback *) cb_Muoff);
      Muoff->align (FL_ALIGN_LEFT);
    }				// Fl_Check_Button* Muoff
    {
      HpFiname =
	new Fl_File_Input (25, 385, 400, 30, gettext ("Help Filename"));
      HpFiname->labelsize (12);
      HpFiname->textsize (12);
      HpFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* HpFiname
    {
      Fl_Button *o = new Fl_Button (440, 385, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse6);
    }				// Fl_Button* o
    {
      LStyFiname =
	new Fl_File_Input (25, 475, 400, 30, gettext ("LibStyles Filename"));
      LStyFiname->labelsize (12);
      LStyFiname->textsize (12);
      LStyFiname->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_File_Input* LStyFiname
    {
      Fl_Button *o = new Fl_Button (440, 475, 130, 30, gettext ("Browse"));
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse7);
    }				// Fl_Button* o
    Settingswindow->end ();
  }				// Fl_Double_Window* Settingswindow
  {
    PatternEditWin =
      new Fl_Double_Window (780, 560, gettext ("Pattern Editor"));
    PatternEditWin->box (FL_THIN_UP_BOX);
    PatternEditWin->color (FL_LIGHT2);
    PatternEditWin->callback ((Fl_Callback *) cb_PatternEditWin,
			      (void *) (this));
    {
      Fl_Box *o = new Fl_Box (0, 0, 410, 70, gettext ("Pattern"));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      RtName = new Fl_Input (95, 35, 170, 25, gettext ("Name"));
      RtName->labelsize (12);
      RtName->textsize (12);
      RtName->callback ((Fl_Callback *) cb_RtName);
    }				// Fl_Input* RtName
    {
      RtBars = new Fl_Value_Input (330, 35, 20, 25, gettext ("Bars"));
      RtBars->labelsize (12);
      RtBars->minimum (1);
      RtBars->maximum (8);
      RtBars->step (1);
      RtBars->value (1);
      RtBars->callback ((Fl_Callback *) cb_RtBars);
    }				// Fl_Value_Input* RtBars
    {
      Fl_Box *o = new Fl_Box (0, 70, 780, 30, gettext ("Drums"));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 100, 780, 120, gettext ("Bass"));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 220, 780, 100, gettext ("Acc.1"));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 320, 780, 120, gettext ("Acc."));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (590, 0, 190, 70, gettext ("Bars"));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      SBar = new Fl_Counter (680, 35, 90, 30, gettext ("Bar "));
      SBar->type (1);
      SBar->color (FL_LIGHT2);
      SBar->labelsize (12);
      SBar->minimum (1);
      SBar->maximum (8);
      SBar->step (1);
      SBar->value (1);
      SBar->callback ((Fl_Callback *) cb_SBar);
      SBar->align (FL_ALIGN_LEFT);
    }				// Fl_Counter* SBar
    {
      RtNom = new Fl_Value_Input (385, 35, 20, 25, gettext ("Nom."));
      RtNom->labelsize (12);
      RtNom->minimum (2);
      RtNom->maximum (4);
      RtNom->step (1);
      RtNom->value (4);
      RtNom->callback ((Fl_Callback *) cb_RtNom);
    }				// Fl_Value_Input* RtNom
    {
      Fl_Box *o = new Fl_Box (410, 0, 180, 70);
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 135, 770, 80);
      o->box (FL_PLASTIC_DOWN_BOX);
      o->color (FL_GRAY0);
    }				// Fl_Box* o
    {
      B1G1 = new Fl_Group (85, 135, 180, 35);
      {
	bn1 = new Fl_Value_Input (95, 140, 35, 20);
	bn1->minimum (-12);
	bn1->maximum (128);
	bn1->step (1);
	bn1->callback ((Fl_Callback *) cb_bn1);
      }				// Fl_Value_Input* bn1
      {
	bn2 = new Fl_Value_Input (135, 140, 35, 20);
	bn2->minimum (-12);
	bn2->maximum (128);
	bn2->step (1);
	bn2->callback ((Fl_Callback *) cb_bn2);
      }				// Fl_Value_Input* bn2
      {
	bn3 = new Fl_Value_Input (175, 140, 35, 20);
	bn3->minimum (-12);
	bn3->maximum (128);
	bn3->step (1);
	bn3->callback ((Fl_Callback *) cb_bn3);
      }				// Fl_Value_Input* bn3
      {
	bn4 = new Fl_Value_Input (215, 140, 35, 20);
	bn4->minimum (-12);
	bn4->maximum (129);
	bn4->step (1);
	bn4->callback ((Fl_Callback *) cb_bn4);
      }				// Fl_Value_Input* bn4
      B1G1->end ();
    }				// Fl_Group* B1G1
    {
      B1G2 = new Fl_Group (255, 135, 180, 35);
      {
	bn5 = new Fl_Value_Input (265, 140, 35, 20);
	bn5->minimum (-12);
	bn5->maximum (128);
	bn5->step (1);
	bn5->callback ((Fl_Callback *) cb_bn5);
      }				// Fl_Value_Input* bn5
      {
	bn6 = new Fl_Value_Input (305, 140, 35, 20);
	bn6->minimum (-12);
	bn6->maximum (128);
	bn6->step (1);
	bn6->callback ((Fl_Callback *) cb_bn6);
      }				// Fl_Value_Input* bn6
      {
	bn7 = new Fl_Value_Input (345, 140, 35, 20);
	bn7->minimum (-12);
	bn7->maximum (128);
	bn7->step (1);
	bn7->callback ((Fl_Callback *) cb_bn7);
      }				// Fl_Value_Input* bn7
      {
	bn8 = new Fl_Value_Input (385, 140, 35, 20);
	bn8->minimum (-12);
	bn8->maximum (128);
	bn8->step (1);
	bn8->callback ((Fl_Callback *) cb_bn8);
      }				// Fl_Value_Input* bn8
      B1G2->end ();
    }				// Fl_Group* B1G2
    {
      B1G3 = new Fl_Group (425, 135, 180, 35);
      {
	bn9 = new Fl_Value_Input (435, 140, 35, 20);
	bn9->minimum (-12);
	bn9->maximum (128);
	bn9->step (1);
	bn9->callback ((Fl_Callback *) cb_bn9);
      }				// Fl_Value_Input* bn9
      {
	bn10 = new Fl_Value_Input (475, 140, 35, 20);
	bn10->minimum (-12);
	bn10->maximum (128);
	bn10->step (1);
	bn10->callback ((Fl_Callback *) cb_bn10);
      }				// Fl_Value_Input* bn10
      {
	bn11 = new Fl_Value_Input (515, 140, 35, 20);
	bn11->minimum (-12);
	bn11->maximum (128);
	bn11->step (1);
	bn11->callback ((Fl_Callback *) cb_bn11);
      }				// Fl_Value_Input* bn11
      {
	bn12 = new Fl_Value_Input (555, 140, 35, 20);
	bn12->minimum (-12);
	bn12->maximum (128);
	bn12->step (1);
	bn12->callback ((Fl_Callback *) cb_bn12);
      }				// Fl_Value_Input* bn12
      B1G3->end ();
    }				// Fl_Group* B1G3
    {
      B1G4 = new Fl_Group (595, 135, 180, 30);
      {
	bn13 = new Fl_Value_Input (605, 140, 35, 20);
	bn13->minimum (-12);
	bn13->maximum (128);
	bn13->step (1);
	bn13->callback ((Fl_Callback *) cb_bn13);
      }				// Fl_Value_Input* bn13
      {
	bn14 = new Fl_Value_Input (645, 140, 35, 20);
	bn14->minimum (-12);
	bn14->maximum (128);
	bn14->step (1);
	bn14->callback ((Fl_Callback *) cb_bn14);
      }				// Fl_Value_Input* bn14
      {
	bn15 = new Fl_Value_Input (685, 140, 35, 20);
	bn15->minimum (-12);
	bn15->maximum (128);
	bn15->step (1);
	bn15->callback ((Fl_Callback *) cb_bn15);
      }				// Fl_Value_Input* bn15
      {
	bn16 = new Fl_Value_Input (725, 140, 35, 20);
	bn16->minimum (-12);
	bn16->maximum (128);
	bn16->step (1);
	bn16->callback ((Fl_Callback *) cb_bn16);
      }				// Fl_Value_Input* bn16
      B1G4->end ();
    }				// Fl_Group* B1G4
    {
      BL1G1 = new Fl_Group (85, 160, 180, 35);
      {
	bl1 = new Fl_Value_Input (95, 165, 35, 20);
	bl1->maximum (64);
	bl1->step (1);
	bl1->callback ((Fl_Callback *) cb_bl1);
      }				// Fl_Value_Input* bl1
      {
	bl2 = new Fl_Value_Input (135, 165, 35, 20);
	bl2->maximum (64);
	bl2->step (1);
	bl2->callback ((Fl_Callback *) cb_bl2);
      }				// Fl_Value_Input* bl2
      {
	bl3 = new Fl_Value_Input (175, 165, 35, 20);
	bl3->maximum (64);
	bl3->step (1);
	bl3->callback ((Fl_Callback *) cb_bl3);
      }				// Fl_Value_Input* bl3
      {
	bl4 = new Fl_Value_Input (215, 165, 35, 20);
	bl4->maximum (64);
	bl4->step (1);
	bl4->callback ((Fl_Callback *) cb_bl4);
      }				// Fl_Value_Input* bl4
      BL1G1->end ();
    }				// Fl_Group* BL1G1
    {
      BL1G2 = new Fl_Group (255, 160, 180, 35);
      {
	bl5 = new Fl_Value_Input (265, 165, 35, 20);
	bl5->maximum (64);
	bl5->step (1);
	bl5->callback ((Fl_Callback *) cb_bl5);
      }				// Fl_Value_Input* bl5
      {
	bl6 = new Fl_Value_Input (305, 165, 35, 20);
	bl6->maximum (64);
	bl6->step (1);
	bl6->callback ((Fl_Callback *) cb_bl6);
      }				// Fl_Value_Input* bl6
      {
	bl7 = new Fl_Value_Input (345, 165, 35, 20);
	bl7->maximum (64);
	bl7->step (1);
	bl7->callback ((Fl_Callback *) cb_bl7);
      }				// Fl_Value_Input* bl7
      {
	bl8 = new Fl_Value_Input (385, 165, 35, 20);
	bl8->maximum (64);
	bl8->step (1);
	bl8->callback ((Fl_Callback *) cb_bl8);
      }				// Fl_Value_Input* bl8
      BL1G2->end ();
    }				// Fl_Group* BL1G2
    {
      BL1G3 = new Fl_Group (425, 160, 180, 35);
      {
	bl9 = new Fl_Value_Input (435, 165, 35, 20);
	bl9->maximum (64);
	bl9->step (1);
	bl9->callback ((Fl_Callback *) cb_bl9);
      }				// Fl_Value_Input* bl9
      {
	bl10 = new Fl_Value_Input (475, 165, 35, 20);
	bl10->maximum (64);
	bl10->step (1);
	bl10->callback ((Fl_Callback *) cb_bl10);
      }				// Fl_Value_Input* bl10
      {
	bl11 = new Fl_Value_Input (515, 165, 35, 20);
	bl11->maximum (64);
	bl11->step (1);
	bl11->callback ((Fl_Callback *) cb_bl11);
      }				// Fl_Value_Input* bl11
      {
	bl12 = new Fl_Value_Input (555, 165, 35, 20);
	bl12->maximum (64);
	bl12->step (1);
	bl12->callback ((Fl_Callback *) cb_bl12);
      }				// Fl_Value_Input* bl12
      BL1G3->end ();
    }				// Fl_Group* BL1G3
    {
      BL1G4 = new Fl_Group (600, 160, 175, 30);
      {
	bl13 = new Fl_Value_Input (605, 165, 35, 20);
	bl13->maximum (64);
	bl13->step (1);
	bl13->callback ((Fl_Callback *) cb_bl13);
      }				// Fl_Value_Input* bl13
      {
	bl14 = new Fl_Value_Input (645, 165, 35, 20);
	bl14->maximum (64);
	bl14->step (1);
	bl14->callback ((Fl_Callback *) cb_bl14);
      }				// Fl_Value_Input* bl14
      {
	bl15 = new Fl_Value_Input (685, 165, 35, 20);
	bl15->maximum (64);
	bl15->step (1);
	bl15->callback ((Fl_Callback *) cb_bl15);
      }				// Fl_Value_Input* bl15
      {
	bl16 = new Fl_Value_Input (725, 165, 35, 20);
	bl16->maximum (64);
	bl16->step (1);
	bl16->callback ((Fl_Callback *) cb_bl16);
      }				// Fl_Value_Input* bl16
      BL1G4->end ();
    }				// Fl_Group* BL1G4
    {
      BV1G1 = new Fl_Group (85, 185, 180, 35);
      {
	bv1 = new Fl_Value_Input (95, 190, 35, 20);
	bv1->maximum (127);
	bv1->step (1);
	bv1->callback ((Fl_Callback *) cb_bv1);
      }				// Fl_Value_Input* bv1
      {
	bv2 = new Fl_Value_Input (135, 190, 35, 20);
	bv2->maximum (127);
	bv2->step (1);
	bv2->callback ((Fl_Callback *) cb_bv2);
      }				// Fl_Value_Input* bv2
      {
	bv3 = new Fl_Value_Input (175, 190, 35, 20);
	bv3->maximum (127);
	bv3->step (1);
	bv3->callback ((Fl_Callback *) cb_bv3);
      }				// Fl_Value_Input* bv3
      {
	bv4 = new Fl_Value_Input (215, 190, 35, 20);
	bv4->maximum (127);
	bv4->step (1);
	bv4->callback ((Fl_Callback *) cb_bv4);
      }				// Fl_Value_Input* bv4
      BV1G1->end ();
    }				// Fl_Group* BV1G1
    {
      BV1G2 = new Fl_Group (255, 185, 180, 35);
      {
	bv5 = new Fl_Value_Input (265, 190, 35, 20);
	bv5->maximum (127);
	bv5->step (1);
	bv5->callback ((Fl_Callback *) cb_bv5);
      }				// Fl_Value_Input* bv5
      {
	bv6 = new Fl_Value_Input (305, 190, 35, 20);
	bv6->maximum (127);
	bv6->step (1);
	bv6->callback ((Fl_Callback *) cb_bv6);
      }				// Fl_Value_Input* bv6
      {
	bv7 = new Fl_Value_Input (345, 190, 35, 20);
	bv7->maximum (127);
	bv7->step (1);
	bv7->callback ((Fl_Callback *) cb_bv7);
      }				// Fl_Value_Input* bv7
      {
	bv8 = new Fl_Value_Input (385, 190, 35, 20);
	bv8->maximum (127);
	bv8->step (1);
	bv8->callback ((Fl_Callback *) cb_bv8);
      }				// Fl_Value_Input* bv8
      BV1G2->end ();
    }				// Fl_Group* BV1G2
    {
      BV1G3 = new Fl_Group (425, 185, 180, 35);
      {
	bv9 = new Fl_Value_Input (435, 190, 35, 20);
	bv9->maximum (127);
	bv9->step (1);
	bv9->callback ((Fl_Callback *) cb_bv9);
      }				// Fl_Value_Input* bv9
      {
	bv10 = new Fl_Value_Input (475, 190, 35, 20);
	bv10->maximum (127);
	bv10->step (1);
	bv10->callback ((Fl_Callback *) cb_bv10);
      }				// Fl_Value_Input* bv10
      {
	bv11 = new Fl_Value_Input (515, 190, 35, 20);
	bv11->maximum (127);
	bv11->step (1);
	bv11->callback ((Fl_Callback *) cb_bv11);
      }				// Fl_Value_Input* bv11
      {
	bv12 = new Fl_Value_Input (555, 190, 35, 20);
	bv12->maximum (127);
	bv12->step (1);
	bv12->callback ((Fl_Callback *) cb_bv12);
      }				// Fl_Value_Input* bv12
      BV1G3->end ();
    }				// Fl_Group* BV1G3
    {
      BV1G4 = new Fl_Group (595, 185, 180, 30);
      {
	bv13 = new Fl_Value_Input (605, 190, 35, 20);
	bv13->maximum (127);
	bv13->step (1);
	bv13->callback ((Fl_Callback *) cb_bv13);
      }				// Fl_Value_Input* bv13
      {
	bv14 = new Fl_Value_Input (645, 190, 35, 20);
	bv14->maximum (127);
	bv14->step (1);
	bv14->callback ((Fl_Callback *) cb_bv14);
      }				// Fl_Value_Input* bv14
      {
	bv15 = new Fl_Value_Input (685, 190, 35, 20);
	bv15->maximum (127);
	bv15->step (1);
	bv15->callback ((Fl_Callback *) cb_bv15);
      }				// Fl_Value_Input* bv15
      {
	bv16 = new Fl_Value_Input (725, 190, 35, 20);
	bv16->maximum (127);
	bv16->step (1);
	bv16->callback ((Fl_Callback *) cb_bv16);
      }				// Fl_Value_Input* bv16
      BV1G4->end ();
    }				// Fl_Group* BV1G4
    {
      Fl_Box *o = new Fl_Box (0, 190, 95, 20, gettext ("Velocity"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 140, 95, 20, gettext ("Note"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      CloRit = new Fl_Button (425, 5, 70, 35, gettext ("Close"));
      CloRit->box (FL_UP_FRAME);
      CloRit->shortcut (0xff0d);
      CloRit->color ((Fl_Color) 44);
      CloRit->labelsize (12);
      CloRit->callback ((Fl_Callback *) cb_CloRit);
    }				// Fl_Button* CloRit
    {
      Fl_Box *o = new Fl_Box (0, 165, 95, 20, gettext ("Length"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 255, 770, 60);
      o->box (FL_PLASTIC_DOWN_BOX);
      o->color (FL_GRAY0);
    }				// Fl_Box* o
    {
      AC1LG1 = new Fl_Group (85, 255, 180, 35);
      {
	ac1l1 = new Fl_Value_Input (95, 260, 35, 20);
	ac1l1->maximum (64);
	ac1l1->step (1);
	ac1l1->callback ((Fl_Callback *) cb_ac1l1);
      }				// Fl_Value_Input* ac1l1
      {
	ac1l2 = new Fl_Value_Input (135, 260, 35, 20);
	ac1l2->maximum (64);
	ac1l2->step (1);
	ac1l2->callback ((Fl_Callback *) cb_ac1l2);
      }				// Fl_Value_Input* ac1l2
      {
	ac1l3 = new Fl_Value_Input (175, 260, 35, 20);
	ac1l3->maximum (64);
	ac1l3->step (1);
	ac1l3->callback ((Fl_Callback *) cb_ac1l3);
      }				// Fl_Value_Input* ac1l3
      {
	ac1l4 = new Fl_Value_Input (215, 260, 35, 20);
	ac1l4->maximum (64);
	ac1l4->step (1);
	ac1l4->callback ((Fl_Callback *) cb_ac1l4);
      }				// Fl_Value_Input* ac1l4
      AC1LG1->end ();
    }				// Fl_Group* AC1LG1
    {
      AC1LG2 = new Fl_Group (255, 255, 180, 35);
      {
	ac1l5 = new Fl_Value_Input (265, 260, 35, 20);
	ac1l5->maximum (64);
	ac1l5->step (1);
	ac1l5->callback ((Fl_Callback *) cb_ac1l5);
      }				// Fl_Value_Input* ac1l5
      {
	ac1l6 = new Fl_Value_Input (305, 260, 35, 20);
	ac1l6->maximum (64);
	ac1l6->step (1);
	ac1l6->callback ((Fl_Callback *) cb_ac1l6);
      }				// Fl_Value_Input* ac1l6
      {
	ac1l7 = new Fl_Value_Input (345, 260, 35, 20);
	ac1l7->maximum (64);
	ac1l7->step (1);
	ac1l7->callback ((Fl_Callback *) cb_ac1l7);
      }				// Fl_Value_Input* ac1l7
      {
	ac1l8 = new Fl_Value_Input (385, 260, 35, 20);
	ac1l8->maximum (64);
	ac1l8->step (1);
	ac1l8->callback ((Fl_Callback *) cb_ac1l8);
      }				// Fl_Value_Input* ac1l8
      AC1LG2->end ();
    }				// Fl_Group* AC1LG2
    {
      AC1LG3 = new Fl_Group (425, 255, 180, 35);
      {
	ac1l9 = new Fl_Value_Input (435, 260, 35, 20);
	ac1l9->maximum (64);
	ac1l9->step (1);
	ac1l9->callback ((Fl_Callback *) cb_ac1l9);
      }				// Fl_Value_Input* ac1l9
      {
	ac1l10 = new Fl_Value_Input (475, 260, 35, 20);
	ac1l10->maximum (64);
	ac1l10->step (1);
	ac1l10->callback ((Fl_Callback *) cb_ac1l10);
      }				// Fl_Value_Input* ac1l10
      {
	ac1l11 = new Fl_Value_Input (515, 260, 35, 20);
	ac1l11->maximum (64);
	ac1l11->step (1);
	ac1l11->callback ((Fl_Callback *) cb_ac1l11);
      }				// Fl_Value_Input* ac1l11
      {
	ac1l12 = new Fl_Value_Input (555, 260, 35, 20);
	ac1l12->maximum (64);
	ac1l12->step (1);
	ac1l12->callback ((Fl_Callback *) cb_ac1l12);
      }				// Fl_Value_Input* ac1l12
      AC1LG3->end ();
    }				// Fl_Group* AC1LG3
    {
      AC1LG4 = new Fl_Group (595, 255, 180, 30);
      {
	ac1l13 = new Fl_Value_Input (605, 260, 35, 20);
	ac1l13->maximum (64);
	ac1l13->step (1);
	ac1l13->callback ((Fl_Callback *) cb_ac1l13);
      }				// Fl_Value_Input* ac1l13
      {
	ac1l14 = new Fl_Value_Input (645, 260, 35, 20);
	ac1l14->maximum (64);
	ac1l14->step (1);
	ac1l14->callback ((Fl_Callback *) cb_ac1l14);
      }				// Fl_Value_Input* ac1l14
      {
	ac1l15 = new Fl_Value_Input (685, 260, 35, 20);
	ac1l15->maximum (64);
	ac1l15->step (1);
	ac1l15->callback ((Fl_Callback *) cb_ac1l15);
      }				// Fl_Value_Input* ac1l15
      {
	ac1l16 = new Fl_Value_Input (725, 260, 35, 20);
	ac1l16->maximum (64);
	ac1l16->step (1);
	ac1l16->callback ((Fl_Callback *) cb_ac1l16);
      }				// Fl_Value_Input* ac1l16
      AC1LG4->end ();
    }				// Fl_Group* AC1LG4
    {
      AC1VG1 = new Fl_Group (85, 285, 180, 35);
      {
	ac1v1 = new Fl_Value_Input (95, 290, 35, 20);
	ac1v1->maximum (127);
	ac1v1->step (1);
	ac1v1->callback ((Fl_Callback *) cb_ac1v1);
      }				// Fl_Value_Input* ac1v1
      {
	ac1v2 = new Fl_Value_Input (135, 290, 35, 20);
	ac1v2->maximum (127);
	ac1v2->step (1);
	ac1v2->callback ((Fl_Callback *) cb_ac1v2);
      }				// Fl_Value_Input* ac1v2
      {
	ac1v3 = new Fl_Value_Input (175, 290, 35, 20);
	ac1v3->maximum (127);
	ac1v3->step (1);
	ac1v3->callback ((Fl_Callback *) cb_ac1v3);
      }				// Fl_Value_Input* ac1v3
      {
	ac1v4 = new Fl_Value_Input (215, 290, 35, 20);
	ac1v4->maximum (127);
	ac1v4->step (1);
	ac1v4->callback ((Fl_Callback *) cb_ac1v4);
      }				// Fl_Value_Input* ac1v4
      AC1VG1->end ();
    }				// Fl_Group* AC1VG1
    {
      AC1VG2 = new Fl_Group (255, 285, 180, 35);
      {
	ac1v5 = new Fl_Value_Input (265, 290, 35, 20);
	ac1v5->maximum (127);
	ac1v5->step (1);
	ac1v5->callback ((Fl_Callback *) cb_ac1v5);
      }				// Fl_Value_Input* ac1v5
      {
	ac1v6 = new Fl_Value_Input (305, 290, 35, 20);
	ac1v6->maximum (127);
	ac1v6->step (1);
	ac1v6->callback ((Fl_Callback *) cb_ac1v6);
      }				// Fl_Value_Input* ac1v6
      {
	ac1v7 = new Fl_Value_Input (345, 290, 35, 20);
	ac1v7->maximum (127);
	ac1v7->step (1);
	ac1v7->callback ((Fl_Callback *) cb_ac1v7);
      }				// Fl_Value_Input* ac1v7
      {
	ac1v8 = new Fl_Value_Input (385, 290, 35, 20);
	ac1v8->maximum (127);
	ac1v8->step (1);
	ac1v8->callback ((Fl_Callback *) cb_ac1v8);
      }				// Fl_Value_Input* ac1v8
      AC1VG2->end ();
    }				// Fl_Group* AC1VG2
    {
      AC1VG3 = new Fl_Group (425, 285, 180, 35);
      {
	ac1v9 = new Fl_Value_Input (435, 290, 35, 20);
	ac1v9->maximum (127);
	ac1v9->step (1);
	ac1v9->callback ((Fl_Callback *) cb_ac1v9);
      }				// Fl_Value_Input* ac1v9
      {
	ac1v10 = new Fl_Value_Input (475, 290, 35, 20);
	ac1v10->maximum (127);
	ac1v10->step (1);
	ac1v10->callback ((Fl_Callback *) cb_ac1v10);
      }				// Fl_Value_Input* ac1v10
      {
	ac1v11 = new Fl_Value_Input (515, 290, 35, 20);
	ac1v11->maximum (127);
	ac1v11->step (1);
	ac1v11->callback ((Fl_Callback *) cb_ac1v11);
      }				// Fl_Value_Input* ac1v11
      {
	ac1v12 = new Fl_Value_Input (555, 290, 35, 20);
	ac1v12->maximum (127);
	ac1v12->step (1);
	ac1v12->callback ((Fl_Callback *) cb_ac1v12);
      }				// Fl_Value_Input* ac1v12
      AC1VG3->end ();
    }				// Fl_Group* AC1VG3
    {
      AC1VG4 = new Fl_Group (595, 285, 180, 30);
      {
	ac1v13 = new Fl_Value_Input (605, 290, 35, 20);
	ac1v13->maximum (127);
	ac1v13->step (1);
	ac1v13->callback ((Fl_Callback *) cb_ac1v13);
      }				// Fl_Value_Input* ac1v13
      {
	ac1v14 = new Fl_Value_Input (645, 290, 35, 20);
	ac1v14->maximum (127);
	ac1v14->step (1);
	ac1v14->callback ((Fl_Callback *) cb_ac1v14);
      }				// Fl_Value_Input* ac1v14
      {
	ac1v15 = new Fl_Value_Input (685, 290, 35, 20);
	ac1v15->maximum (127);
	ac1v15->step (1);
	ac1v15->callback ((Fl_Callback *) cb_ac1v15);
      }				// Fl_Value_Input* ac1v15
      {
	ac1v16 = new Fl_Value_Input (725, 290, 35, 20);
	ac1v16->maximum (127);
	ac1v16->step (1);
	ac1v16->callback ((Fl_Callback *) cb_ac1v16);
      }				// Fl_Value_Input* ac1v16
      AC1VG4->end ();
    }				// Fl_Group* AC1VG4
    {
      Fl_Box *o = new Fl_Box (0, 290, 95, 20, gettext ("Velocity"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 260, 95, 20, gettext ("Length"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 355, 770, 80);
      o->box (FL_PLASTIC_DOWN_BOX);
      o->color (FL_GRAY0);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 360, 95, 20, gettext ("Note"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 385, 95, 20, gettext ("Length"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 410, 95, 20, gettext ("Velocity"));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      AC2G1 = new Fl_Group (85, 355, 180, 35);
      {
	ac2n1 = new Fl_Value_Input (95, 360, 35, 20);
	ac2n1->minimum (-12);
	ac2n1->maximum (12);
	ac2n1->step (1);
	ac2n1->callback ((Fl_Callback *) cb_ac2n1);
      }				// Fl_Value_Input* ac2n1
      {
	ac2n2 = new Fl_Value_Input (135, 360, 35, 20);
	ac2n2->minimum (-12);
	ac2n2->maximum (12);
	ac2n2->step (1);
	ac2n2->callback ((Fl_Callback *) cb_ac2n2);
      }				// Fl_Value_Input* ac2n2
      {
	ac2n3 = new Fl_Value_Input (175, 360, 35, 20);
	ac2n3->minimum (-12);
	ac2n3->maximum (12);
	ac2n3->step (1);
	ac2n3->callback ((Fl_Callback *) cb_ac2n3);
      }				// Fl_Value_Input* ac2n3
      {
	ac2n4 = new Fl_Value_Input (215, 360, 35, 20);
	ac2n4->minimum (-12);
	ac2n4->maximum (12);
	ac2n4->step (1);
	ac2n4->callback ((Fl_Callback *) cb_ac2n4);
      }				// Fl_Value_Input* ac2n4
      AC2G1->end ();
    }				// Fl_Group* AC2G1
    {
      AC2G2 = new Fl_Group (255, 355, 180, 35);
      {
	ac2n5 = new Fl_Value_Input (265, 360, 35, 20);
	ac2n5->minimum (-12);
	ac2n5->maximum (12);
	ac2n5->step (1);
	ac2n5->callback ((Fl_Callback *) cb_ac2n5);
      }				// Fl_Value_Input* ac2n5
      {
	ac2n6 = new Fl_Value_Input (305, 360, 35, 20);
	ac2n6->minimum (-12);
	ac2n6->maximum (12);
	ac2n6->step (1);
	ac2n6->callback ((Fl_Callback *) cb_ac2n6);
      }				// Fl_Value_Input* ac2n6
      {
	ac2n7 = new Fl_Value_Input (345, 360, 35, 20);
	ac2n7->minimum (-12);
	ac2n7->maximum (12);
	ac2n7->step (1);
	ac2n7->callback ((Fl_Callback *) cb_ac2n7);
      }				// Fl_Value_Input* ac2n7
      {
	ac2n8 = new Fl_Value_Input (385, 360, 35, 20);
	ac2n8->minimum (-12);
	ac2n8->maximum (12);
	ac2n8->step (1);
	ac2n8->callback ((Fl_Callback *) cb_ac2n8);
      }				// Fl_Value_Input* ac2n8
      AC2G2->end ();
    }				// Fl_Group* AC2G2
    {
      AC2G3 = new Fl_Group (425, 355, 180, 35);
      {
	ac2n9 = new Fl_Value_Input (435, 360, 35, 20);
	ac2n9->minimum (-12);
	ac2n9->maximum (12);
	ac2n9->step (1);
	ac2n9->callback ((Fl_Callback *) cb_ac2n9);
      }				// Fl_Value_Input* ac2n9
      {
	ac2n10 = new Fl_Value_Input (475, 360, 35, 20);
	ac2n10->minimum (-12);
	ac2n10->maximum (12);
	ac2n10->step (1);
	ac2n10->callback ((Fl_Callback *) cb_ac2n10);
      }				// Fl_Value_Input* ac2n10
      {
	ac2n11 = new Fl_Value_Input (515, 360, 35, 20);
	ac2n11->minimum (-12);
	ac2n11->maximum (12);
	ac2n11->step (1);
	ac2n11->callback ((Fl_Callback *) cb_ac2n11);
      }				// Fl_Value_Input* ac2n11
      {
	ac2n12 = new Fl_Value_Input (555, 360, 35, 20);
	ac2n12->minimum (-12);
	ac2n12->maximum (12);
	ac2n12->step (1);
	ac2n12->callback ((Fl_Callback *) cb_ac2n12);
      }				// Fl_Value_Input* ac2n12
      AC2G3->end ();
    }				// Fl_Group* AC2G3
    {
      AC2G4 = new Fl_Group (595, 355, 180, 30);
      {
	ac2n13 = new Fl_Value_Input (605, 360, 35, 20);
	ac2n13->minimum (-12);
	ac2n13->maximum (12);
	ac2n13->step (1);
	ac2n13->callback ((Fl_Callback *) cb_ac2n13);
      }				// Fl_Value_Input* ac2n13
      {
	ac2n14 = new Fl_Value_Input (645, 360, 35, 20);
	ac2n14->minimum (-12);
	ac2n14->maximum (12);
	ac2n14->step (1);
	ac2n14->callback ((Fl_Callback *) cb_ac2n14);
      }				// Fl_Value_Input* ac2n14
      {
	ac2n15 = new Fl_Value_Input (685, 360, 35, 20);
	ac2n15->minimum (-12);
	ac2n15->maximum (12);
	ac2n15->step (1);
	ac2n15->callback ((Fl_Callback *) cb_ac2n15);
      }				// Fl_Value_Input* ac2n15
      {
	ac2n16 = new Fl_Value_Input (725, 360, 35, 20);
	ac2n16->minimum (-12);
	ac2n16->maximum (12);
	ac2n16->step (1);
	ac2n16->callback ((Fl_Callback *) cb_ac2n16);
      }				// Fl_Value_Input* ac2n16
      AC2G4->end ();
    }				// Fl_Group* AC2G4
    {
      AC2LG1 = new Fl_Group (85, 380, 180, 35);
      {
	ac2l1 = new Fl_Value_Input (95, 385, 35, 20);
	ac2l1->maximum (64);
	ac2l1->step (1);
	ac2l1->callback ((Fl_Callback *) cb_ac2l1);
      }				// Fl_Value_Input* ac2l1
      {
	ac2l2 = new Fl_Value_Input (135, 385, 35, 20);
	ac2l2->maximum (64);
	ac2l2->step (1);
	ac2l2->callback ((Fl_Callback *) cb_ac2l2);
      }				// Fl_Value_Input* ac2l2
      {
	ac2l3 = new Fl_Value_Input (175, 385, 35, 20);
	ac2l3->maximum (64);
	ac2l3->step (1);
	ac2l3->callback ((Fl_Callback *) cb_ac2l3);
      }				// Fl_Value_Input* ac2l3
      {
	ac2l4 = new Fl_Value_Input (215, 385, 35, 20);
	ac2l4->maximum (64);
	ac2l4->step (1);
	ac2l4->callback ((Fl_Callback *) cb_ac2l4);
      }				// Fl_Value_Input* ac2l4
      AC2LG1->end ();
    }				// Fl_Group* AC2LG1
    {
      AC2LG2 = new Fl_Group (255, 380, 180, 35);
      {
	ac2l5 = new Fl_Value_Input (265, 385, 35, 20);
	ac2l5->maximum (64);
	ac2l5->step (1);
	ac2l5->callback ((Fl_Callback *) cb_ac2l5);
      }				// Fl_Value_Input* ac2l5
      {
	ac2l6 = new Fl_Value_Input (305, 385, 35, 20);
	ac2l6->maximum (64);
	ac2l6->step (1);
	ac2l6->callback ((Fl_Callback *) cb_ac2l6);
      }				// Fl_Value_Input* ac2l6
      {
	ac2l7 = new Fl_Value_Input (345, 385, 35, 20);
	ac2l7->maximum (64);
	ac2l7->step (1);
	ac2l7->callback ((Fl_Callback *) cb_ac2l7);
      }				// Fl_Value_Input* ac2l7
      {
	ac2l8 = new Fl_Value_Input (385, 385, 35, 20);
	ac2l8->maximum (64);
	ac2l8->step (1);
	ac2l8->callback ((Fl_Callback *) cb_ac2l8);
      }				// Fl_Value_Input* ac2l8
      AC2LG2->end ();
    }				// Fl_Group* AC2LG2
    {
      AC2LG3 = new Fl_Group (425, 380, 180, 35);
      {
	ac2l9 = new Fl_Value_Input (435, 385, 35, 20);
	ac2l9->maximum (64);
	ac2l9->step (1);
	ac2l9->callback ((Fl_Callback *) cb_ac2l9);
      }				// Fl_Value_Input* ac2l9
      {
	ac2l10 = new Fl_Value_Input (475, 385, 35, 20);
	ac2l10->maximum (64);
	ac2l10->step (1);
	ac2l10->callback ((Fl_Callback *) cb_ac2l10);
      }				// Fl_Value_Input* ac2l10
      {
	ac2l11 = new Fl_Value_Input (515, 385, 35, 20);
	ac2l11->maximum (64);
	ac2l11->step (1);
	ac2l11->callback ((Fl_Callback *) cb_ac2l11);
      }				// Fl_Value_Input* ac2l11
      {
	ac2l12 = new Fl_Value_Input (555, 385, 35, 20);
	ac2l12->maximum (64);
	ac2l12->step (1);
	ac2l12->callback ((Fl_Callback *) cb_ac2l12);
      }				// Fl_Value_Input* ac2l12
      AC2LG3->end ();
    }				// Fl_Group* AC2LG3
    {
      AC2LG4 = new Fl_Group (600, 380, 175, 30);
      {
	ac2l13 = new Fl_Value_Input (605, 385, 35, 20);
	ac2l13->maximum (64);
	ac2l13->step (1);
	ac2l13->callback ((Fl_Callback *) cb_ac2l13);
      }				// Fl_Value_Input* ac2l13
      {
	ac2l14 = new Fl_Value_Input (645, 385, 35, 20);
	ac2l14->maximum (64);
	ac2l14->step (1);
	ac2l14->callback ((Fl_Callback *) cb_ac2l14);
      }				// Fl_Value_Input* ac2l14
      {
	ac2l15 = new Fl_Value_Input (685, 385, 35, 20);
	ac2l15->maximum (64);
	ac2l15->step (1);
	ac2l15->callback ((Fl_Callback *) cb_ac2l15);
      }				// Fl_Value_Input* ac2l15
      {
	ac2l16 = new Fl_Value_Input (725, 385, 35, 20);
	ac2l16->maximum (64);
	ac2l16->step (1);
	ac2l16->callback ((Fl_Callback *) cb_ac2l16);
      }				// Fl_Value_Input* ac2l16
      AC2LG4->end ();
    }				// Fl_Group* AC2LG4
    {
      AC2VG1 = new Fl_Group (85, 405, 180, 35);
      {
	ac2v1 = new Fl_Value_Input (95, 410, 35, 20);
	ac2v1->maximum (127);
	ac2v1->step (1);
	ac2v1->callback ((Fl_Callback *) cb_ac2v1);
      }				// Fl_Value_Input* ac2v1
      {
	ac2v2 = new Fl_Value_Input (135, 410, 35, 20);
	ac2v2->maximum (127);
	ac2v2->step (1);
	ac2v2->callback ((Fl_Callback *) cb_ac2v2);
      }				// Fl_Value_Input* ac2v2
      {
	ac2v3 = new Fl_Value_Input (175, 410, 35, 20);
	ac2v3->maximum (127);
	ac2v3->step (1);
	ac2v3->callback ((Fl_Callback *) cb_ac2v3);
      }				// Fl_Value_Input* ac2v3
      {
	ac2v4 = new Fl_Value_Input (215, 410, 35, 20);
	ac2v4->maximum (127);
	ac2v4->step (1);
	ac2v4->callback ((Fl_Callback *) cb_ac2v4);
      }				// Fl_Value_Input* ac2v4
      AC2VG1->end ();
    }				// Fl_Group* AC2VG1
    {
      AC2VG2 = new Fl_Group (255, 405, 180, 35);
      {
	ac2v5 = new Fl_Value_Input (265, 410, 35, 20);
	ac2v5->maximum (127);
	ac2v5->step (1);
	ac2v5->callback ((Fl_Callback *) cb_ac2v5);
      }				// Fl_Value_Input* ac2v5
      {
	ac2v6 = new Fl_Value_Input (305, 410, 35, 20);
	ac2v6->maximum (127);
	ac2v6->step (1);
	ac2v6->callback ((Fl_Callback *) cb_ac2v6);
      }				// Fl_Value_Input* ac2v6
      {
	ac2v7 = new Fl_Value_Input (345, 410, 35, 20);
	ac2v7->maximum (127);
	ac2v7->step (1);
	ac2v7->callback ((Fl_Callback *) cb_ac2v7);
      }				// Fl_Value_Input* ac2v7
      {
	ac2v8 = new Fl_Value_Input (385, 410, 35, 20);
	ac2v8->maximum (127);
	ac2v8->step (1);
	ac2v8->callback ((Fl_Callback *) cb_ac2v8);
      }				// Fl_Value_Input* ac2v8
      AC2VG2->end ();
    }				// Fl_Group* AC2VG2
    {
      AC2VG3 = new Fl_Group (425, 405, 180, 35);
      {
	ac2v9 = new Fl_Value_Input (435, 410, 35, 20);
	ac2v9->maximum (127);
	ac2v9->step (1);
	ac2v9->callback ((Fl_Callback *) cb_ac2v9);
      }				// Fl_Value_Input* ac2v9
      {
	ac2v10 = new Fl_Value_Input (475, 410, 35, 20);
	ac2v10->maximum (127);
	ac2v10->step (1);
	ac2v10->callback ((Fl_Callback *) cb_ac2v10);
      }				// Fl_Value_Input* ac2v10
      {
	ac2v11 = new Fl_Value_Input (515, 410, 35, 20);
	ac2v11->maximum (127);
	ac2v11->step (1);
	ac2v11->callback ((Fl_Callback *) cb_ac2v11);
      }				// Fl_Value_Input* ac2v11
      {
	ac2v12 = new Fl_Value_Input (555, 410, 35, 20);
	ac2v12->maximum (127);
	ac2v12->step (1);
	ac2v12->callback ((Fl_Callback *) cb_ac2v12);
      }				// Fl_Value_Input* ac2v12
      AC2VG3->end ();
    }				// Fl_Group* AC2VG3
    {
      AC2VG4 = new Fl_Group (595, 405, 180, 30);
      {
	ac2v13 = new Fl_Value_Input (605, 409, 35, 20);
	ac2v13->maximum (127);
	ac2v13->step (1);
	ac2v13->callback ((Fl_Callback *) cb_ac2v13);
      }				// Fl_Value_Input* ac2v13
      {
	ac2v14 = new Fl_Value_Input (645, 410, 35, 20);
	ac2v14->maximum (127);
	ac2v14->step (1);
	ac2v14->callback ((Fl_Callback *) cb_ac2v14);
      }				// Fl_Value_Input* ac2v14
      {
	ac2v15 = new Fl_Value_Input (685, 410, 35, 20);
	ac2v15->maximum (127);
	ac2v15->step (1);
	ac2v15->callback ((Fl_Callback *) cb_ac2v15);
      }				// Fl_Value_Input* ac2v15
      {
	ac2v16 = new Fl_Value_Input (725, 410, 35, 20);
	ac2v16->maximum (127);
	ac2v16->step (1);
	ac2v16->callback ((Fl_Callback *) cb_ac2v16);
      }				// Fl_Value_Input* ac2v16
      AC2VG4->end ();
    }				// Fl_Group* AC2VG4
    {
      Fl_Button *o = new Fl_Button (300, 10, 105, 20, gettext ("Copy From"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (680, 10, 90, 20, gettext ("Copy From"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (675, 110, 85, 20, gettext ("Copy From"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy2);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (680, 230, 85, 20, gettext ("Copy From"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy3);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (680, 330, 85, 20, gettext ("Copy From"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy4);
    }				// Fl_Button* o
    {
      RtSwing = new Fl_Value_Input (235, 10, 30, 20, gettext ("Swing"));
      RtSwing->labelsize (12);
      RtSwing->maximum (63);
      RtSwing->step (1);
      RtSwing->callback ((Fl_Callback *) cb_RtSwing);
    }				// Fl_Value_Input* RtSwing
    {
      Fl_Value_Input *o = RtAcc2Mode =
	new Fl_Value_Input (130, 330, 20, 20, gettext ("Mode"));
      RtAcc2Mode->labelsize (10);
      RtAcc2Mode->maximum (2);
      RtAcc2Mode->step (1);
      RtAcc2Mode->callback ((Fl_Callback *) cb_RtAcc2Mode);
      o->value (gmo->Rt[gmo->sp].acc2mode);
    }				// Fl_Value_Input* RtAcc2Mode
    {
      Fl_Box *o = new Fl_Box (0, 440, 780, 120, gettext ("Acc."));
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Value_Input *o = RtAcc3Mode =
	new Fl_Value_Input (130, 450, 20, 20, gettext ("Mode"));
      RtAcc3Mode->labelsize (10);
      RtAcc3Mode->maximum (2);
      RtAcc3Mode->step (1);
      RtAcc3Mode->callback ((Fl_Callback *) cb_RtAcc3Mode);
      o->value (gmo->Rt[gmo->sp].acc3mode);
    }				// Fl_Value_Input* RtAcc3Mode
    {
      Fl_Button *o = new Fl_Button (680, 450, 85, 20, gettext ("Copy From"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy5);
    }				// Fl_Button* o
    {
      Fl_Box *o = new Fl_Box (0, 475, 770, 80);
      o->box (FL_PLASTIC_DOWN_BOX);
      o->color (FL_GRAY0);
    }				// Fl_Box* o
    {
      new Fl_Box (0, 480, 80, 20, gettext ("Note"));
    }				// Fl_Box* o
    {
      new Fl_Box (0, 505, 80, 20, gettext ("Length"));
    }				// Fl_Box* o
    {
      new Fl_Box (0, 530, 80, 20, gettext ("Velocity"));
    }				// Fl_Box* o
    {
      AC3G1 = new Fl_Group (85, 475, 180, 35);
      {
	ac3n1 = new Fl_Value_Input (95, 480, 35, 20);
	ac3n1->minimum (-12);
	ac3n1->maximum (12);
	ac3n1->step (1);
	ac3n1->callback ((Fl_Callback *) cb_ac3n1);
      }				// Fl_Value_Input* ac3n1
      {
	ac3n2 = new Fl_Value_Input (135, 480, 35, 20);
	ac3n2->minimum (-12);
	ac3n2->maximum (12);
	ac3n2->step (1);
	ac3n2->callback ((Fl_Callback *) cb_ac3n2);
      }				// Fl_Value_Input* ac3n2
      {
	ac3n3 = new Fl_Value_Input (175, 480, 35, 20);
	ac3n3->minimum (-12);
	ac3n3->maximum (12);
	ac3n3->step (1);
	ac3n3->callback ((Fl_Callback *) cb_ac3n3);
      }				// Fl_Value_Input* ac3n3
      {
	ac3n4 = new Fl_Value_Input (215, 480, 35, 20);
	ac3n4->minimum (-12);
	ac3n4->maximum (12);
	ac3n4->step (1);
	ac3n4->callback ((Fl_Callback *) cb_ac3n4);
      }				// Fl_Value_Input* ac3n4
      AC3G1->end ();
    }				// Fl_Group* AC3G1
    {
      AC3G2 = new Fl_Group (255, 475, 180, 35);
      {
	ac3n5 = new Fl_Value_Input (265, 480, 35, 20);
	ac3n5->minimum (-12);
	ac3n5->maximum (12);
	ac3n5->step (1);
	ac3n5->callback ((Fl_Callback *) cb_ac3n5);
      }				// Fl_Value_Input* ac3n5
      {
	ac3n6 = new Fl_Value_Input (305, 480, 35, 20);
	ac3n6->minimum (-12);
	ac3n6->maximum (12);
	ac3n6->step (1);
	ac3n6->callback ((Fl_Callback *) cb_ac3n6);
      }				// Fl_Value_Input* ac3n6
      {
	ac3n7 = new Fl_Value_Input (345, 480, 35, 20);
	ac3n7->minimum (-12);
	ac3n7->maximum (12);
	ac3n7->step (1);
	ac3n7->callback ((Fl_Callback *) cb_ac3n7);
      }				// Fl_Value_Input* ac3n7
      {
	ac3n8 = new Fl_Value_Input (385, 480, 35, 20);
	ac3n8->minimum (-12);
	ac3n8->maximum (12);
	ac3n8->step (1);
	ac3n8->callback ((Fl_Callback *) cb_ac3n8);
      }				// Fl_Value_Input* ac3n8
      AC3G2->end ();
    }				// Fl_Group* AC3G2
    {
      AC3G3 = new Fl_Group (425, 475, 180, 35);
      {
	ac3n9 = new Fl_Value_Input (435, 480, 35, 20);
	ac3n9->minimum (-12);
	ac3n9->maximum (12);
	ac3n9->step (1);
	ac3n9->callback ((Fl_Callback *) cb_ac3n9);
      }				// Fl_Value_Input* ac3n9
      {
	ac3n10 = new Fl_Value_Input (475, 480, 35, 20);
	ac3n10->minimum (-12);
	ac3n10->maximum (12);
	ac3n10->step (1);
	ac3n10->callback ((Fl_Callback *) cb_ac3n10);
      }				// Fl_Value_Input* ac3n10
      {
	ac3n11 = new Fl_Value_Input (515, 480, 35, 20);
	ac3n11->minimum (-12);
	ac3n11->maximum (12);
	ac3n11->step (1);
	ac3n11->callback ((Fl_Callback *) cb_ac3n11);
      }				// Fl_Value_Input* ac3n11
      {
	ac3n12 = new Fl_Value_Input (555, 480, 35, 20);
	ac3n12->minimum (-12);
	ac3n12->maximum (12);
	ac3n12->step (1);
	ac3n12->callback ((Fl_Callback *) cb_ac3n12);
      }				// Fl_Value_Input* ac3n12
      AC3G3->end ();
    }				// Fl_Group* AC3G3
    {
      AC3G4 = new Fl_Group (595, 475, 180, 30);
      {
	ac3n13 = new Fl_Value_Input (605, 480, 35, 20);
	ac3n13->minimum (-12);
	ac3n13->maximum (12);
	ac3n13->step (1);
	ac3n13->callback ((Fl_Callback *) cb_ac3n13);
      }				// Fl_Value_Input* ac3n13
      {
	ac3n14 = new Fl_Value_Input (645, 480, 35, 20);
	ac3n14->minimum (-12);
	ac3n14->maximum (12);
	ac3n14->step (1);
	ac3n14->callback ((Fl_Callback *) cb_ac3n14);
      }				// Fl_Value_Input* ac3n14
      {
	ac3n15 = new Fl_Value_Input (685, 480, 35, 20);
	ac3n15->minimum (-12);
	ac3n15->maximum (12);
	ac3n15->step (1);
	ac3n15->callback ((Fl_Callback *) cb_ac3n15);
      }				// Fl_Value_Input* ac3n15
      {
	ac3n16 = new Fl_Value_Input (725, 480, 35, 20);
	ac3n16->minimum (-12);
	ac3n16->maximum (12);
	ac3n16->step (1);
	ac3n16->callback ((Fl_Callback *) cb_ac3n16);
      }				// Fl_Value_Input* ac3n16
      AC3G4->end ();
    }				// Fl_Group* AC3G4
    {
      AC3LG1 = new Fl_Group (85, 500, 180, 35);
      {
	ac3l1 = new Fl_Value_Input (95, 505, 35, 20);
	ac3l1->maximum (64);
	ac3l1->step (1);
	ac3l1->callback ((Fl_Callback *) cb_ac3l1);
      }				// Fl_Value_Input* ac3l1
      {
	ac3l2 = new Fl_Value_Input (135, 505, 35, 20);
	ac3l2->maximum (64);
	ac3l2->step (1);
	ac3l2->callback ((Fl_Callback *) cb_ac3l2);
      }				// Fl_Value_Input* ac3l2
      {
	ac3l3 = new Fl_Value_Input (175, 505, 35, 20);
	ac3l3->maximum (64);
	ac3l3->step (1);
	ac3l3->callback ((Fl_Callback *) cb_ac3l3);
      }				// Fl_Value_Input* ac3l3
      {
	ac3l4 = new Fl_Value_Input (215, 505, 35, 20);
	ac3l4->maximum (64);
	ac3l4->step (1);
	ac3l4->callback ((Fl_Callback *) cb_ac3l4);
      }				// Fl_Value_Input* ac3l4
      AC3LG1->end ();
    }				// Fl_Group* AC3LG1
    {
      AC3LG2 = new Fl_Group (255, 500, 180, 35);
      {
	ac3l5 = new Fl_Value_Input (265, 505, 35, 20);
	ac3l5->maximum (64);
	ac3l5->step (1);
	ac3l5->callback ((Fl_Callback *) cb_ac3l5);
      }				// Fl_Value_Input* ac3l5
      {
	ac3l6 = new Fl_Value_Input (305, 505, 35, 20);
	ac3l6->maximum (64);
	ac3l6->step (1);
	ac3l6->callback ((Fl_Callback *) cb_ac3l6);
      }				// Fl_Value_Input* ac3l6
      {
	ac3l7 = new Fl_Value_Input (345, 505, 35, 20);
	ac3l7->maximum (64);
	ac3l7->step (1);
	ac3l7->callback ((Fl_Callback *) cb_ac3l7);
      }				// Fl_Value_Input* ac3l7
      {
	ac3l8 = new Fl_Value_Input (385, 505, 35, 20);
	ac3l8->maximum (64);
	ac3l8->step (1);
	ac3l8->callback ((Fl_Callback *) cb_ac3l8);
      }				// Fl_Value_Input* ac3l8
      AC3LG2->end ();
    }				// Fl_Group* AC3LG2
    {
      AC3LG3 = new Fl_Group (425, 500, 180, 35);
      {
	ac3l9 = new Fl_Value_Input (435, 505, 35, 20);
	ac3l9->maximum (64);
	ac3l9->step (1);
	ac3l9->callback ((Fl_Callback *) cb_ac3l9);
      }				// Fl_Value_Input* ac3l9
      {
	ac3l10 = new Fl_Value_Input (475, 505, 35, 20);
	ac3l10->maximum (64);
	ac3l10->step (1);
	ac3l10->callback ((Fl_Callback *) cb_ac3l10);
      }				// Fl_Value_Input* ac3l10
      {
	ac3l11 = new Fl_Value_Input (515, 505, 35, 20);
	ac3l11->maximum (64);
	ac3l11->step (1);
	ac3l11->callback ((Fl_Callback *) cb_ac3l11);
      }				// Fl_Value_Input* ac3l11
      {
	ac3l12 = new Fl_Value_Input (555, 505, 35, 20);
	ac3l12->maximum (64);
	ac3l12->step (1);
	ac3l12->callback ((Fl_Callback *) cb_ac3l12);
      }				// Fl_Value_Input* ac3l12
      AC3LG3->end ();
    }				// Fl_Group* AC3LG3
    {
      AC3LG4 = new Fl_Group (600, 500, 175, 30);
      {
	ac3l13 = new Fl_Value_Input (605, 505, 35, 20);
	ac3l13->maximum (64);
	ac3l13->step (1);
	ac3l13->callback ((Fl_Callback *) cb_ac3l13);
      }				// Fl_Value_Input* ac3l13
      {
	ac3l14 = new Fl_Value_Input (645, 505, 35, 20);
	ac3l14->maximum (64);
	ac3l14->step (1);
	ac3l14->callback ((Fl_Callback *) cb_ac3l14);
      }				// Fl_Value_Input* ac3l14
      {
	ac3l15 = new Fl_Value_Input (685, 505, 35, 20);
	ac3l15->maximum (64);
	ac3l15->step (1);
	ac3l15->callback ((Fl_Callback *) cb_ac3l15);
      }				// Fl_Value_Input* ac3l15
      {
	ac3l16 = new Fl_Value_Input (725, 505, 35, 20);
	ac3l16->maximum (64);
	ac3l16->step (1);
	ac3l16->callback ((Fl_Callback *) cb_ac3l16);
      }				// Fl_Value_Input* ac3l16
      AC3LG4->end ();
    }				// Fl_Group* AC3LG4
    {
      AC3VG1 = new Fl_Group (85, 525, 180, 35);
      {
	ac3v1 = new Fl_Value_Input (95, 530, 35, 20);
	ac3v1->maximum (127);
	ac3v1->step (1);
	ac3v1->callback ((Fl_Callback *) cb_ac3v1);
      }				// Fl_Value_Input* ac3v1
      {
	ac3v2 = new Fl_Value_Input (135, 530, 35, 20);
	ac3v2->maximum (127);
	ac3v2->step (1);
	ac3v2->callback ((Fl_Callback *) cb_ac3v2);
      }				// Fl_Value_Input* ac3v2
      {
	ac3v3 = new Fl_Value_Input (175, 530, 35, 20);
	ac3v3->maximum (127);
	ac3v3->step (1);
	ac3v3->callback ((Fl_Callback *) cb_ac3v3);
      }				// Fl_Value_Input* ac3v3
      {
	ac3v4 = new Fl_Value_Input (215, 530, 35, 20);
	ac3v4->maximum (127);
	ac3v4->step (1);
	ac3v4->callback ((Fl_Callback *) cb_ac3v4);
      }				// Fl_Value_Input* ac3v4
      AC3VG1->end ();
    }				// Fl_Group* AC3VG1
    {
      AC3VG2 = new Fl_Group (255, 525, 180, 35);
      {
	ac3v5 = new Fl_Value_Input (265, 530, 35, 20);
	ac3v5->maximum (127);
	ac3v5->step (1);
	ac3v5->callback ((Fl_Callback *) cb_ac3v5);
      }				// Fl_Value_Input* ac3v5
      {
	ac3v6 = new Fl_Value_Input (305, 530, 35, 20);
	ac3v6->maximum (127);
	ac3v6->step (1);
	ac3v6->callback ((Fl_Callback *) cb_ac3v6);
      }				// Fl_Value_Input* ac3v6
      {
	ac3v7 = new Fl_Value_Input (345, 530, 35, 20);
	ac3v7->maximum (127);
	ac3v7->step (1);
	ac3v7->callback ((Fl_Callback *) cb_ac3v7);
      }				// Fl_Value_Input* ac3v7
      {
	ac3v8 = new Fl_Value_Input (385, 530, 35, 20);
	ac3v8->maximum (127);
	ac3v8->step (1);
	ac3v8->callback ((Fl_Callback *) cb_ac3v8);
      }				// Fl_Value_Input* ac3v8
      AC3VG2->end ();
    }				// Fl_Group* AC3VG2
    {
      AC3VG3 = new Fl_Group (425, 525, 180, 35);
      {
	ac3v9 = new Fl_Value_Input (435, 530, 35, 20);
	ac3v9->maximum (127);
	ac3v9->step (1);
	ac3v9->callback ((Fl_Callback *) cb_ac3v9);
      }				// Fl_Value_Input* ac3v9
      {
	ac3v10 = new Fl_Value_Input (475, 530, 35, 20);
	ac3v10->maximum (127);
	ac3v10->step (1);
	ac3v10->callback ((Fl_Callback *) cb_ac3v10);
      }				// Fl_Value_Input* ac3v10
      {
	ac3v11 = new Fl_Value_Input (515, 530, 35, 20);
	ac3v11->maximum (127);
	ac3v11->step (1);
	ac3v11->callback ((Fl_Callback *) cb_ac3v11);
      }				// Fl_Value_Input* ac3v11
      {
	ac3v12 = new Fl_Value_Input (555, 530, 35, 20);
	ac3v12->maximum (127);
	ac3v12->step (1);
	ac3v12->callback ((Fl_Callback *) cb_ac3v12);
      }				// Fl_Value_Input* ac3v12
      AC3VG3->end ();
    }				// Fl_Group* AC3VG3
    {
      AC3VG4 = new Fl_Group (595, 525, 180, 30);
      {
	ac3v13 = new Fl_Value_Input (605, 530, 35, 20);
	ac3v13->maximum (127);
	ac3v13->step (1);
	ac3v13->callback ((Fl_Callback *) cb_ac3v13);
      }				// Fl_Value_Input* ac3v13
      {
	ac3v14 = new Fl_Value_Input (645, 530, 35, 20);
	ac3v14->maximum (127);
	ac3v14->step (1);
	ac3v14->callback ((Fl_Callback *) cb_ac3v14);
      }				// Fl_Value_Input* ac3v14
      {
	ac3v15 = new Fl_Value_Input (685, 530, 35, 20);
	ac3v15->maximum (127);
	ac3v15->step (1);
	ac3v15->callback ((Fl_Callback *) cb_ac3v15);
      }				// Fl_Value_Input* ac3v15
      {
	ac3v16 = new Fl_Value_Input (725, 530, 35, 20);
	ac3v16->maximum (127);
	ac3v16->step (1);
	ac3v16->callback ((Fl_Callback *) cb_ac3v16);
      }				// Fl_Value_Input* ac3v16
      AC3VG4->end ();
    }				// Fl_Group* AC3VG4
    {
      Fl_Button *o =
	new Fl_Button (100, 75, 160, 20, gettext ("Global Drum Editor"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Global);
    }				// Fl_Button* o
    {
      Poc = new Fl_Button (480, 330, 70, 20, gettext ("Play Octave"));
      Poc->type (1);
      Poc->box (FL_PLASTIC_UP_BOX);
      Poc->color ((Fl_Color) 55);
      Poc->selection_color ((Fl_Color) 3);
      Poc->labelsize (10);
      Poc->callback ((Fl_Callback *) cb_Poc);
    }				// Fl_Button* Poc
    {
      Fl_Group *o = new Fl_Group (255, 330, 220, 25);
      {
	Pterc = new Fl_Button (330, 330, 70, 20, gettext ("Play Thirds"));
	Pterc->type (102);
	Pterc->box (FL_PLASTIC_UP_BOX);
	Pterc->color ((Fl_Color) 55);
	Pterc->selection_color ((Fl_Color) 3);
	Pterc->labelsize (10);
	Pterc->callback ((Fl_Callback *) cb_Pterc);
      }				// Fl_Button* Pterc
      {
	Psext = new Fl_Button (405, 330, 70, 20, gettext ("Play Sixths"));
	Psext->type (102);
	Psext->box (FL_PLASTIC_UP_BOX);
	Psext->color ((Fl_Color) 55);
	Psext->selection_color ((Fl_Color) 3);
	Psext->labelsize (10);
	Psext->callback ((Fl_Callback *) cb_Psext);
      }				// Fl_Button* Psext
      {
	Punison = new Fl_Button (260, 330, 65, 20, gettext ("Unison"));
	Punison->type (102);
	Punison->box (FL_PLASTIC_UP_BOX);
	Punison->color ((Fl_Color) 55);
	Punison->selection_color ((Fl_Color) 3);
	Punison->labelsize (10);
	Punison->callback ((Fl_Callback *) cb_Punison);
      }				// Fl_Button* Punison
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Button *o = new Fl_Button (95, 10, 90, 20, gettext ("Clear"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Clear);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (575, 110, 85, 20, gettext ("Clear Bar"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Clear1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (575, 330, 85, 20, gettext ("Clear Bar"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Clear2);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (575, 450, 85, 20, gettext ("Clear Bar"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Clear3);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (575, 230, 85, 20, gettext ("Clear Bar"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Clear4);
    }				// Fl_Button* o
    {
      HelpRit = new Fl_Button (505, 5, 70, 35, gettext ("Help"));
      HelpRit->box (FL_UP_FRAME);
      HelpRit->shortcut (0xffbe);
      HelpRit->color ((Fl_Color) 44);
      HelpRit->labelsize (12);
      HelpRit->callback ((Fl_Callback *) cb_HelpRit);
    }				// Fl_Button* HelpRit
    {
      Fl_Group *o = new Fl_Group (40, 330, 45, 20);
      {
	Sacc2 = new Fl_Button (40, 330, 20, 20, gettext ("2"));
	Sacc2->type (102);
	Sacc2->box (FL_THIN_UP_BOX);
	Sacc2->color (FL_LIGHT2);
	Sacc2->selection_color ((Fl_Color) 3);
	Sacc2->labeltype (FL_ENGRAVED_LABEL);
	Sacc2->labelsize (20);
	Sacc2->labelcolor ((Fl_Color) 4);
	Sacc2->callback ((Fl_Callback *) cb_Sacc2);
      }				// Fl_Button* Sacc2
      {
	Sacc4 = new Fl_Button (65, 330, 20, 20, gettext ("4"));
	Sacc4->type (102);
	Sacc4->box (FL_THIN_UP_BOX);
	Sacc4->color (FL_LIGHT2);
	Sacc4->selection_color ((Fl_Color) 3);
	Sacc4->labeltype (FL_ENGRAVED_LABEL);
	Sacc4->labelsize (20);
	Sacc4->labelcolor ((Fl_Color) 4);
	Sacc4->callback ((Fl_Callback *) cb_Sacc4);
      }				// Fl_Button* Sacc4
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Group *o = new Fl_Group (40, 450, 45, 20);
      {
	Sacc3 = new Fl_Button (40, 450, 20, 20, gettext ("3"));
	Sacc3->type (102);
	Sacc3->box (FL_THIN_UP_BOX);
	Sacc3->color (FL_LIGHT2);
	Sacc3->selection_color ((Fl_Color) 3);
	Sacc3->labeltype (FL_ENGRAVED_LABEL);
	Sacc3->labelsize (20);
	Sacc3->labelcolor ((Fl_Color) 4);
	Sacc3->callback ((Fl_Callback *) cb_Sacc3);
      }				// Fl_Button* Sacc3
      {
	Sacc5 = new Fl_Button (65, 450, 20, 20, gettext ("5"));
	Sacc5->type (102);
	Sacc5->box (FL_THIN_UP_BOX);
	Sacc5->color (FL_LIGHT2);
	Sacc5->selection_color ((Fl_Color) 3);
	Sacc5->labeltype (FL_ENGRAVED_LABEL);
	Sacc5->labelsize (20);
	Sacc5->labelcolor ((Fl_Color) 4);
	Sacc5->callback ((Fl_Callback *) cb_Sacc5);
      }				// Fl_Button* Sacc5
      o->end ();
    }				// Fl_Group* o
    {
      STLTAcc24 = new Fl_Slider (185, 330, 70, 20, gettext ("St-Lt"));
      STLTAcc24->type (1);
      STLTAcc24->color (FL_LIGHT2);
      STLTAcc24->labelsize (10);
      STLTAcc24->minimum (-128);
      STLTAcc24->maximum (128);
      STLTAcc24->step (1);
      STLTAcc24->callback ((Fl_Callback *) cb_STLTAcc24);
      STLTAcc24->align (FL_ALIGN_LEFT);
    }				// Fl_Slider* STLTAcc24
    {
      STLTAcc35 = new Fl_Slider (185, 450, 70, 20, gettext ("St-Lt"));
      STLTAcc35->type (1);
      STLTAcc35->color (FL_LIGHT2);
      STLTAcc35->labelsize (10);
      STLTAcc35->minimum (-128);
      STLTAcc35->maximum (128);
      STLTAcc35->step (1);
      STLTAcc35->callback ((Fl_Callback *) cb_STLTAcc35);
      STLTAcc35->align (FL_ALIGN_LEFT);
    }				// Fl_Slider* STLTAcc35
    {
      STLTAcc1 = new Fl_Slider (185, 230, 70, 20, gettext ("St-Lt"));
      STLTAcc1->type (1);
      STLTAcc1->color (FL_LIGHT2);
      STLTAcc1->labelsize (10);
      STLTAcc1->minimum (-128);
      STLTAcc1->maximum (128);
      STLTAcc1->step (1);
      STLTAcc1->callback ((Fl_Callback *) cb_STLTAcc1);
      STLTAcc1->align (FL_ALIGN_LEFT);
    }				// Fl_Slider* STLTAcc1
    {
      STLTBass = new Fl_Slider (185, 110, 70, 20, gettext ("St-Lt"));
      STLTBass->type (1);
      STLTBass->color (FL_LIGHT2);
      STLTBass->labelsize (10);
      STLTBass->minimum (-128);
      STLTBass->maximum (128);
      STLTBass->step (1);
      STLTBass->callback ((Fl_Callback *) cb_STLTBass);
      STLTBass->align (FL_ALIGN_LEFT);
    }				// Fl_Slider* STLTBass
    {
      Fl_Button *o =
	new Fl_Button (420, 45, 160, 20, gettext ("Control Editor"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Control);
    }				// Fl_Button* o
    PatternEditWin->end ();
    PatternEditWin->resizable (PatternEditWin);
  }				// Fl_Double_Window* PatternEditWin
  {
    ExtraPWin = new Fl_Double_Window (115, 275, gettext ("+ Parm."));
    ExtraPWin->color (FL_LIGHT2);
    ExtraPWin->user_data ((void *) (this));
    {
      Cajita = new Fl_Box (0, 0, 115, 275);
      Cajita->box (FL_THIN_UP_FRAME);
      Cajita->color (FL_LIGHT2);
      Cajita->labeltype (FL_ENGRAVED_LABEL);
      Cajita->labelsize (20);
      Cajita->labelcolor ((Fl_Color) 1);
      Cajita->align (FL_ALIGN_TOP | FL_ALIGN_INSIDE);
    }				// Fl_Box* Cajita
    {
      EO = new Fl_Counter (25, 50, 65, 25, gettext ("Octave"));
      EO->type (1);
      EO->color (FL_LIGHT2);
      EO->labelsize (10);
      EO->minimum (-1);
      EO->maximum (3);
      EO->step (1);
      EO->callback ((Fl_Callback *) cb_EO);
      EO->align (FL_ALIGN_TOP);
    }				// Fl_Counter* EO
    {
      EBM = new Fl_Counter (25, 90, 65, 25, gettext ("Bank MSB"));
      EBM->type (1);
      EBM->color (FL_LIGHT2);
      EBM->labelsize (10);
      EBM->minimum (0);
      EBM->maximum (128);
      EBM->step (1);
      EBM->callback ((Fl_Callback *) cb_EBM);
      EBM->align (FL_ALIGN_TOP);
    }				// Fl_Counter* EBM
    {
      EPtime = new Fl_Counter (25, 200, 65, 25, gettext ("Port. Time"));
      EPtime->type (1);
      EPtime->color (FL_LIGHT2);
      EPtime->labelsize (10);
      EPtime->minimum (0);
      EPtime->maximum (127);
      EPtime->step (1);
      EPtime->callback ((Fl_Callback *) cb_EPtime);
      EPtime->align (FL_ALIGN_TOP);
    }				// Fl_Counter* EPtime
    {
      EPon = new Fl_Button (30, 160, 55, 25, gettext ("Port."));
      EPon->type (1);
      EPon->box (FL_PLASTIC_UP_BOX);
      EPon->color ((Fl_Color) 55);
      EPon->selection_color ((Fl_Color) 3);
      EPon->labelfont (1);
      EPon->labelsize (10);
      EPon->labelcolor ((Fl_Color) 43);
      EPon->callback ((Fl_Callback *) cb_EPon);
    }				// Fl_Button* EPon
    {
      Fl_Button *o = new Fl_Button (25, 235, 65, 30, gettext ("Close"));
      o->box (FL_UP_FRAME);
      o->color ((Fl_Color) 55);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Close);
    }				// Fl_Button* o
    {
      EBL = new Fl_Counter (25, 130, 65, 25, gettext ("Bank LSB"));
      EBL->type (1);
      EBL->color (FL_LIGHT2);
      EBL->labelsize (10);
      EBL->minimum (0);
      EBL->maximum (128);
      EBL->step (1);
      EBL->callback ((Fl_Callback *) cb_EBL);
      EBL->align (FL_ALIGN_TOP);
    }				// Fl_Counter* EBL
    ExtraPWin->end ();
  }				// Fl_Double_Window* ExtraPWin
  {
    CopyWin = new Fl_Double_Window (285, 205, gettext ("Copy Patterns"));
    CopyWin->box (FL_THIN_UP_BOX);
    CopyWin->color (FL_LIGHT2);
    CopyWin->user_data ((void *) (this));
    {
      CPtBro = new Fl_Browser (10, 5, 265, 145);
      CPtBro->tooltip (gettext ("Left Click Select - Right Click Edit"));
      CPtBro->type (2);
      CPtBro->box (FL_PLASTIC_DOWN_BOX);
      CPtBro->color (FL_FOREGROUND_COLOR);
      CPtBro->textfont (1);
      CPtBro->textsize (12);
    }				// Fl_Browser* CPtBro
    {
      Fl_Button *o = new Fl_Button (135, 165, 65, 30, gettext ("Copy"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Copy6);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (205, 165, 65, 30, gettext ("Cancel"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel);
    }				// Fl_Button* o
    CopyWin->end ();
  }				// Fl_Double_Window* CopyWin
  {
    CopyBWin = new Fl_Double_Window (170, 130, gettext ("Copy Bars"));
    CopyBWin->color (FL_LIGHT2);
    CopyBWin->user_data ((void *) (this));
    {
      Fl_Box *o = new Fl_Box (0, 0, 170, 130, gettext ("Bars"));
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      SBCopy =
	new Fl_Value_Input (130, 35, 25, 30, gettext ("Copy from bar :"));
      SBCopy->labelsize (12);
      SBCopy->minimum (1);
      SBCopy->maximum (8);
      SBCopy->step (1);
      SBCopy->value (1);
    }				// Fl_Value_Input* SBCopy
    {
      Fl_Button *o = new Fl_Button (15, 85, 65, 30, gettext ("Copy"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Copy7);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (90, 85, 65, 30, gettext ("Cancel"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel1);
    }				// Fl_Button* o
    CopyBWin->end ();
  }				// Fl_Double_Window* CopyBWin
  {
    BankWin = new Fl_Double_Window (375, 400, gettext ("Sound"));
    BankWin->box (FL_THIN_UP_BOX);
    BankWin->color (FL_LIGHT2);
    BankWin->user_data ((void *) (this));
    {
      BankBro = new Fl_Browser (10, 15, 260, 375);
      BankBro->tooltip (gettext ("Left Click Select - Right Click Store"));
      BankBro->type (2);
      BankBro->box (FL_THIN_DOWN_BOX);
      BankBro->labelsize (12);
      BankBro->textsize (12);
      BankBro->callback ((Fl_Callback *) cb_BankBro);
    }				// Fl_Browser* BankBro
    {
      CloBank = new Fl_Button (280, 355, 85, 35, gettext ("Close"));
      CloBank->box (FL_UP_FRAME);
      CloBank->shortcut (0xff0d);
      CloBank->color (FL_DARK1);
      CloBank->labelsize (12);
      CloBank->callback ((Fl_Callback *) cb_CloBank);
    }				// Fl_Button* CloBank
    BankWin->end ();
  }				// Fl_Double_Window* BankWin
  {
    StyleWin = new Fl_Double_Window (595, 415, gettext ("Style Editor"));
    StyleWin->box (FL_THIN_UP_BOX);
    StyleWin->color (FL_LIGHT2);
    StyleWin->callback ((Fl_Callback *) cb_StyleWin, (void *) (this));
    {
      EPtBro = new Fl_Browser (350, 80, 230, 175, gettext ("Styles"));
      EPtBro->type (2);
      EPtBro->color ((Fl_Color) 55);
      EPtBro->labelsize (10);
      EPtBro->textsize (12);
      EPtBro->align (FL_ALIGN_TOP);
    }				// Fl_Browser* EPtBro
    {
      EPrBro = new Fl_Browser (350, 275, 230, 70, gettext ("Programmes"));
      EPrBro->type (2);
      EPrBro->color ((Fl_Color) 55);
      EPrBro->labelsize (10);
      EPrBro->textsize (12);
      EPrBro->align (FL_ALIGN_TOP);
    }				// Fl_Browser* EPrBro
    {
      Fl_Button *o = new Fl_Button (15, 80, 65, 25, gettext ("Intro"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 87);
      o->selection_color ((Fl_Color) 3);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->callback ((Fl_Callback *) cb_Intro);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (15, 110, 65, 25, gettext ("Var1"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 55);
      o->selection_color ((Fl_Color) 3);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->callback ((Fl_Callback *) cb_Var1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (15, 140, 65, 25, gettext ("Var2"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 55);
      o->selection_color ((Fl_Color) 3);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->callback ((Fl_Callback *) cb_Var2);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (15, 170, 65, 25, gettext ("Fill1"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 55);
      o->selection_color ((Fl_Color) 3);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->callback ((Fl_Callback *) cb_Fill1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (15, 200, 65, 25, gettext ("Fill2"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 55);
      o->selection_color ((Fl_Color) 3);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->callback ((Fl_Callback *) cb_Fill2);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (15, 230, 65, 25, gettext ("Ending"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 87);
      o->selection_color ((Fl_Color) 3);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->callback ((Fl_Callback *) cb_Ending);
    }				// Fl_Button* o
    {
      STI = new Fl_Box (85, 80, 250, 25);
      STI->box (FL_PLASTIC_DOWN_BOX);
      STI->color ((Fl_Color) 55);
      STI->labeltype (FL_ENGRAVED_LABEL);
      STI->labelfont (1);
      STI->labelsize (16);
      STI->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STI
    {
      STV1 = new Fl_Box (85, 110, 250, 25);
      STV1->box (FL_PLASTIC_DOWN_BOX);
      STV1->color ((Fl_Color) 55);
      STV1->labeltype (FL_ENGRAVED_LABEL);
      STV1->labelfont (1);
      STV1->labelsize (16);
      STV1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STV1
    {
      STV2 = new Fl_Box (85, 140, 250, 25);
      STV2->box (FL_PLASTIC_DOWN_BOX);
      STV2->color ((Fl_Color) 55);
      STV2->labeltype (FL_ENGRAVED_LABEL);
      STV2->labelfont (1);
      STV2->labelsize (16);
      STV2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STV2
    {
      STF1 = new Fl_Box (85, 170, 250, 25);
      STF1->box (FL_PLASTIC_DOWN_BOX);
      STF1->color ((Fl_Color) 55);
      STF1->labeltype (FL_ENGRAVED_LABEL);
      STF1->labelfont (1);
      STF1->labelsize (16);
      STF1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STF1
    {
      STF2 = new Fl_Box (85, 200, 250, 25);
      STF2->box (FL_PLASTIC_DOWN_BOX);
      STF2->color ((Fl_Color) 55);
      STF2->labeltype (FL_ENGRAVED_LABEL);
      STF2->labelfont (1);
      STF2->labelsize (16);
      STF2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STF2
    {
      STE = new Fl_Box (85, 230, 250, 25);
      STE->box (FL_PLASTIC_DOWN_BOX);
      STE->color ((Fl_Color) 55);
      STE->labeltype (FL_ENGRAVED_LABEL);
      STE->labelfont (1);
      STE->labelsize (16);
      STE->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* STE
    {
      CloSty = new Fl_Button (485, 365, 95, 35, gettext ("Close"));
      CloSty->box (FL_UP_FRAME);
      CloSty->shortcut (0xff0d);
      CloSty->color (FL_FOREGROUND_COLOR);
      CloSty->labelsize (12);
      CloSty->callback ((Fl_Callback *) cb_CloSty);
    }				// Fl_Button* CloSty
    {
      NombreSt = new Fl_Input (15, 15, 565, 50, gettext ("  "));
      NombreSt->box (FL_PLASTIC_DOWN_BOX);
      NombreSt->color (FL_DARK_GREEN);
      NombreSt->labeltype (FL_ENGRAVED_LABEL);
      NombreSt->labelsize (20);
      NombreSt->labelcolor ((Fl_Color) 208);
      NombreSt->textfont (1);
      NombreSt->textsize (24);
      NombreSt->textcolor (82);
      NombreSt->callback ((Fl_Callback *) cb_NombreSt);
      NombreSt->align (68);
    }				// Fl_Input* NombreSt
    {
      SPrograma = new Fl_Button (15, 275, 65, 25, gettext ("Program"));
      SPrograma->box (FL_PLASTIC_UP_BOX);
      SPrograma->color ((Fl_Color) 55);
      SPrograma->selection_color ((Fl_Color) 3);
      SPrograma->labeltype (FL_ENGRAVED_LABEL);
      SPrograma->callback ((Fl_Callback *) cb_SPrograma);
    }				// Fl_Button* SPrograma
    {
      SPr = new Fl_Box (85, 275, 250, 25);
      SPr->box (FL_PLASTIC_DOWN_BOX);
      SPr->color ((Fl_Color) 219);
      SPr->labeltype (FL_ENGRAVED_LABEL);
      SPr->labelfont (1);
      SPr->labelsize (16);
      SPr->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* SPr
    StyleWin->end ();
  }				// Fl_Double_Window* StyleWin
  {
    CopyB2Win = new Fl_Double_Window (230, 155, gettext ("Copy Bars"));
    CopyB2Win->box (FL_THIN_UP_BOX);
    CopyB2Win->color ((Fl_Color) 51);
    CopyB2Win->user_data ((void *) (this));
    {
      Fl_Box *o = new Fl_Box (0, 0, 230, 160, gettext ("Bars"));
      o->color (FL_LIGHT2);
      o->labeltype (FL_ENGRAVED_LABEL);
      o->labelsize (20);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_TOP_LEFT | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      SB2Copy =
	new Fl_Value_Input (125, 35, 25, 30, gettext ("Copy from bar :"));
      SB2Copy->labelsize (12);
      SB2Copy->minimum (1);
      SB2Copy->maximum (8);
      SB2Copy->step (1);
      SB2Copy->value (1);
      SB2Copy->textsize (12);
    }				// Fl_Value_Input* SB2Copy
    {
      Fl_Button *o = new Fl_Button (75, 115, 65, 30, gettext ("Copy"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Copy8);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (150, 115, 65, 30, gettext ("Cancel"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel2);
    }				// Fl_Button* o
    {
      SB2TCopy =
	new Fl_Value_Input (125, 70, 25, 30, gettext ("Copy to bar :"));
      SB2TCopy->labelsize (12);
      SB2TCopy->minimum (1);
      SB2TCopy->maximum (8);
      SB2TCopy->step (1);
      SB2TCopy->value (1);
      SB2TCopy->textsize (12);
    }				// Fl_Value_Input* SB2TCopy
    CopyB2Win->end ();
  }				// Fl_Double_Window* CopyB2Win
  {
    HelpEdit = new Fl_Double_Window (450, 455, gettext ("Help"));
    HelpEdit->callback ((Fl_Callback *) cb_HelpEdit, (void *) (this));
    {
      Fl_Box *o = new Fl_Box (0, -5, 450, 520);
      o->box (FL_FLAT_BOX);
      o->color (FL_LIGHT2);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (0, 0, 450, 35, gettext ("Note Edit Help"));
      o->box (FL_BORDER_FRAME);
      o->color (FL_LIGHT2);
      o->labelsize (21);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (40, 35, 65, 25, gettext ("Value"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Value);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (105, 35, 70, 25, gettext ("Interval"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (175, 35, 80, 25, gettext ("Example C"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (255, 35, 65, 25, gettext ("Length"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (320, 35, 115, 25, gettext ("Note"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (12);
    }				// Fl_Box* o
    {
      Fl_Button *o = new Fl_Button (350, 415, 85, 30, gettext ("Close"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Close1);
    }				// Fl_Button* o
    {
      HelpBrowser = new Fl_Browser (40, 60, 395, 340);
      HelpBrowser->labelsize (12);
      HelpBrowser->textsize (12);
      HelpBrowser->when (FL_WHEN_NEVER);
    }				// Fl_Browser* HelpBrowser
    HelpEdit->end ();
  }				// Fl_Double_Window* HelpEdit
  {
    SongCopyWin = new Fl_Double_Window (220, 170, gettext ("Song Copy Bars"));
    SongCopyWin->box (FL_THIN_UP_BOX);
    SongCopyWin->color (FL_LIGHT2);
    SongCopyWin->callback ((Fl_Callback *) cb_SongCopyWin, (void *) (this));
    {
      CopySFrom = new Fl_Value_Input (115, 20, 35, 25, gettext ("From:"));
      CopySFrom->labelsize (12);
      CopySFrom->minimum (1);
      CopySFrom->maximum (128);
      CopySFrom->step (1);
      CopySFrom->value (1);
    }				// Fl_Value_Input* CopySFrom
    {
      CopySTo = new Fl_Value_Input (115, 55, 35, 25, gettext ("To:"));
      CopySTo->labelsize (12);
      CopySTo->minimum (1);
      CopySTo->maximum (128);
      CopySTo->step (1);
      CopySTo->value (1);
    }				// Fl_Value_Input* CopySTo
    {
      CopySPut = new Fl_Value_Input (115, 90, 35, 25, gettext ("Put In:"));
      CopySPut->labelsize (12);
      CopySPut->minimum (1);
      CopySPut->maximum (128);
      CopySPut->step (1);
      CopySPut->value (1);
    }				// Fl_Value_Input* CopySPut
    {
      Fl_Button *o = new Fl_Button (40, 120, 65, 35, gettext ("Ok"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Ok);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (115, 120, 65, 35, gettext ("Cancel"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel3);
    }				// Fl_Button* o
    SongCopyWin->end ();
  }				// Fl_Double_Window* SongCopyWin
  {
    SongClearWin =
      new Fl_Double_Window (220, 140, gettext ("Song Clear Bars"));
    SongClearWin->box (FL_THIN_UP_BOX);
    SongClearWin->color (FL_LIGHT2);
    SongClearWin->callback ((Fl_Callback *) cb_SongClearWin, (void *) (this));
    {
      ClearSFrom = new Fl_Value_Input (115, 10, 35, 25, gettext ("From:"));
      ClearSFrom->labelsize (12);
      ClearSFrom->minimum (1);
      ClearSFrom->maximum (128);
      ClearSFrom->step (1);
      ClearSFrom->value (1);
    }				// Fl_Value_Input* ClearSFrom
    {
      ClearSTo = new Fl_Value_Input (115, 50, 35, 25, gettext ("To:"));
      ClearSTo->labelsize (12);
      ClearSTo->minimum (1);
      ClearSTo->maximum (128);
      ClearSTo->step (1);
      ClearSTo->value (1);
    }				// Fl_Value_Input* ClearSTo
    {
      Fl_Button *o = new Fl_Button (20, 90, 65, 35, gettext ("Ok"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Ok1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (130, 90, 65, 35, gettext ("Cancel"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel4);
    }				// Fl_Button* o
    SongClearWin->end ();
  }				// Fl_Double_Window* SongClearWin
  {
    FunnyWin = new Fl_Double_Window (245, 245, gettext ("Funny Play"));
    FunnyWin->callback ((Fl_Callback *) cb_FunnyWin, (void *) (this));
    {
      DoC = new Fl_Button (0, 190, 35, 55, gettext ("C"));
      DoC->shortcut (0x63);
      DoC->color (FL_FOREGROUND_COLOR);
      DoC->labeltype (FL_EMBOSSED_LABEL);
      DoC->labelsize (25);
      DoC->labelcolor (FL_BACKGROUND2_COLOR);
      DoC->callback ((Fl_Callback *) cb_DoC);
    }				// Fl_Button* DoC
    {
      Fl_Button *o = new Fl_Button (35, 190, 35, 55, gettext ("D"));
      o->shortcut (0x64);
      o->color ((Fl_Color) 1);
      o->labeltype (FL_EMBOSSED_LABEL);
      o->labelsize (25);
      o->labelcolor (FL_BACKGROUND2_COLOR);
      o->callback ((Fl_Callback *) cb_D);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (70, 190, 35, 55, gettext ("E"));
      o->shortcut (0x65);
      o->color ((Fl_Color) 2);
      o->labeltype (FL_EMBOSSED_LABEL);
      o->labelsize (25);
      o->labelcolor (FL_BACKGROUND2_COLOR);
      o->callback ((Fl_Callback *) cb_E);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (105, 190, 35, 55, gettext ("F"));
      o->shortcut (0x66);
      o->color ((Fl_Color) 132);
      o->labeltype (FL_EMBOSSED_LABEL);
      o->labelsize (25);
      o->labelcolor (FL_BACKGROUND2_COLOR);
      o->callback ((Fl_Callback *) cb_F);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (140, 190, 35, 55, gettext ("G"));
      o->shortcut (0x67);
      o->color ((Fl_Color) 4);
      o->labeltype (FL_EMBOSSED_LABEL);
      o->labelsize (25);
      o->labelcolor (FL_BACKGROUND2_COLOR);
      o->callback ((Fl_Callback *) cb_G);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (175, 190, 35, 55, gettext ("A"));
      o->shortcut (0x61);
      o->color ((Fl_Color) 5);
      o->labeltype (FL_EMBOSSED_LABEL);
      o->labelsize (25);
      o->labelcolor (FL_BACKGROUND2_COLOR);
      o->callback ((Fl_Callback *) cb_A);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (210, 190, 35, 55, gettext ("B"));
      o->shortcut (0x62);
      o->color ((Fl_Color) 6);
      o->labeltype (FL_EMBOSSED_LABEL);
      o->labelsize (25);
      o->labelcolor (FL_BACKGROUND2_COLOR);
      o->callback ((Fl_Callback *) cb_B);
    }				// Fl_Button* o
    {
      Do = new Fl_Button (0, 0, 35, 185);
      Do->color ((Fl_Color) 53);
      Do->callback ((Fl_Callback *) cb_Do);
    }				// Fl_Button* Do
    {
      Fl_Button *o = new Fl_Button (35, 0, 35, 185);
      o->color ((Fl_Color) 53);
      o->callback ((Fl_Callback *) cb_1);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (70, 0, 35, 185);
      o->color ((Fl_Color) 53);
      o->callback ((Fl_Callback *) cb_2);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (105, 0, 35, 185);
      o->color ((Fl_Color) 53);
      o->callback ((Fl_Callback *) cb_3);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (140, 0, 35, 185);
      o->color ((Fl_Color) 53);
      o->callback ((Fl_Callback *) cb_4);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (175, 0, 35, 185);
      o->color ((Fl_Color) 53);
      o->callback ((Fl_Callback *) cb_5);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (210, 0, 35, 185);
      o->color ((Fl_Color) 53);
      o->callback ((Fl_Callback *) cb_6);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (18, 0, 23, 120);
      o->box (FL_ENGRAVED_BOX);
      o->color (FL_FOREGROUND_COLOR);
      o->callback ((Fl_Callback *) cb_7);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (62, 0, 23, 120);
      o->box (FL_ENGRAVED_BOX);
      o->color (FL_FOREGROUND_COLOR);
      o->callback ((Fl_Callback *) cb_8);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (121, 0, 23, 120);
      o->box (FL_ENGRAVED_BOX);
      o->color (FL_FOREGROUND_COLOR);
      o->callback ((Fl_Callback *) cb_9);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (162, 0, 23, 120);
      o->box (FL_ENGRAVED_BOX);
      o->color (FL_FOREGROUND_COLOR);
      o->callback ((Fl_Callback *) cb_a);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (202, 0, 23, 120);
      o->box (FL_ENGRAVED_BOX);
      o->color (FL_FOREGROUND_COLOR);
      o->callback ((Fl_Callback *) cb_b);
    }				// Fl_Button* o
    FunnyWin->end ();
  }				// Fl_Double_Window* FunnyWin
  {
    KBEntrywin = new Fl_Double_Window (250, 250, gettext ("Keyboard Entry"));
    KBEntrywin->color ((Fl_Color) 51);
    KBEntrywin->callback ((Fl_Callback *) cb_KBEntrywin, (void *) (this));
    {
      EntradaK = new MiValueInput (135, 5, 100, 60);
      EntradaK->box (FL_DOWN_BOX);
      EntradaK->color (FL_FOREGROUND_COLOR);
      EntradaK->selection_color (FL_SELECTION_COLOR);
      EntradaK->labeltype (FL_NORMAL_LABEL);
      EntradaK->labelfont (0);
      EntradaK->labelsize (14);
      EntradaK->labelcolor (FL_FOREGROUND_COLOR);
      EntradaK->minimum (1);
      EntradaK->maximum (100);
      EntradaK->step (1);
      EntradaK->value (1);
      EntradaK->textsize (41);
      EntradaK->textcolor (1);
      EntradaK->callback ((Fl_Callback *) cb_EntradaK);
      EntradaK->align (FL_ALIGN_LEFT);
      EntradaK->when (FL_WHEN_ENTER_KEY);
    }				// MiValueInput* EntradaK
    {
      Fl_Group *o = new Fl_Group (5, 10, 115, 155);
      {
	SSSelector = new Fl_Button (5, 10, 105, 25, gettext ("Sounds"));
	SSSelector->type (102);
	SSSelector->box (FL_PLASTIC_UP_BOX);
	SSSelector->selection_color ((Fl_Color) 3);
	SSSelector->labelsize (12);
	SSSelector->callback ((Fl_Callback *) cb_SSSelector);
      }				// Fl_Button* SSSelector
      {
	PSSelector = new Fl_Button (5, 40, 105, 25, gettext ("Patterns"));
	PSSelector->type (102);
	PSSelector->box (FL_PLASTIC_UP_BOX);
	PSSelector->selection_color ((Fl_Color) 3);
	PSSelector->labelsize (12);
	PSSelector->callback ((Fl_Callback *) cb_PSSelector);
      }				// Fl_Button* PSSelector
      {
	YSSelector = new Fl_Button (5, 70, 105, 25, gettext ("Styles"));
	YSSelector->type (102);
	YSSelector->box (FL_PLASTIC_UP_BOX);
	YSSelector->selection_color ((Fl_Color) 3);
	YSSelector->labelsize (12);
	YSSelector->callback ((Fl_Callback *) cb_YSSelector);
      }				// Fl_Button* YSSelector
      {
	ASSelector = new Fl_Button (5,110, 105, 25, gettext ("Accordion"));
	ASSelector->type (102);
	ASSelector->box (FL_PLASTIC_UP_BOX);
	ASSelector->selection_color ((Fl_Color) 3);
	ASSelector->labelsize (12);
	ASSelector->callback ((Fl_Callback *) cb_ASSelector);
      }				// Fl_Button* Accordion 
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Button *o = new Fl_Button (170, 70, 65, 25, gettext ("Close"));
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Close2);
    }				// Fl_Button* o
    KBEntrywin->end ();
  }				// Fl_Double_Window* KBEntrywin
  {
    MVolwin = new Fl_Double_Window (185, 270, gettext ("Master"));
    MVolwin->color ((Fl_Color) 51);
    MVolwin->user_data ((void *) (this));
    {
      MVolSlider = new Fl_Slider (10, 50, 55, 215);
      MVolSlider->type (4);
      MVolSlider->box (FL_PLASTIC_DOWN_BOX);
      MVolSlider->selection_color ((Fl_Color) 1);
      MVolSlider->minimum (1.25);
      MVolSlider->maximum (0);
      MVolSlider->step (0.01);
      MVolSlider->value (1);
      MVolSlider->callback ((Fl_Callback *) cb_MVolSlider);
    }				// Fl_Slider* MVolSlider
    {
      MVolMaster = new Fl_Button (10, 15, 55, 30, gettext ("On"));
      MVolMaster->type (1);
      MVolMaster->box (FL_PLASTIC_UP_BOX);
      MVolMaster->selection_color ((Fl_Color) 3);
      MVolMaster->labeltype (FL_ENGRAVED_LABEL);
      MVolMaster->labelsize (12);
      MVolMaster->callback ((Fl_Callback *) cb_MVolMaster);
      MVolMaster->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Button* MVolMaster
    {
      Fl_Button *o = new Fl_Button (105, 235, 65, 25, gettext ("Close"));
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Close3);
    }				// Fl_Button* o
    {
      MTMSB = new Fl_Dial (95, 24, 65, 61, gettext ("Master Tune"));
      MTMSB->box (FL_ROUND_UP_BOX);
      MTMSB->labelsize (10);
      MTMSB->maximum (127);
      MTMSB->step (1);
      MTMSB->value (64);
      MTMSB->callback ((Fl_Callback *) cb_MTMSB);
      MTMSB->align (FL_ALIGN_TOP);
    }				// Fl_Dial* MTMSB
    {
      MTCounter = new Fl_Counter (75, 90, 100, 25);
      MTCounter->type (1);
      MTCounter->labelsize (12);
      MTCounter->minimum (-64);
      MTCounter->maximum (64);
      MTCounter->step (1);
      MTCounter->textsize (12);
      MTCounter->callback ((Fl_Callback *) cb_MTCounter);
    }				// Fl_Counter* MTCounter
    {
      Fl_Button *o = new Fl_Button (555, 630, 25, 25);
      o->shortcut (0xffbe);
      o->callback ((Fl_Callback *) cb_c);
      o->hide ();
    }				// Fl_Button* o
    MVolwin->end ();
  }				// Fl_Double_Window* MVolwin
  {
    WinMidiImport =
      new Fl_Double_Window (545, 265, gettext ("Import Midi File"));
    WinMidiImport->box (FL_THIN_UP_BOX);
    WinMidiImport->color (FL_LIGHT2);
    WinMidiImport->labelsize (12);
    WinMidiImport->callback ((Fl_Callback *) cb_WinMidiImport,
			     (void *) (this));
    {
      MiFiname = new Fl_File_Input (5, 5, 430, 30);
      MiFiname->labelsize (12);
    }				// Fl_File_Input* MiFiname
    {
      Fl_Button *o = new Fl_Button (445, 10, 90, 25, gettext ("Browse"));
      o->box (FL_UP_FRAME);
      o->color ((Fl_Color) 44);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Browse8);
    }				// Fl_Button* o
    {
      WMiNominator =
	new Fl_Value_Input (195, 55, 35, 25, gettext ("Nominator"));
      WMiNominator->labelsize (12);
      WMiNominator->minimum (3);
      WMiNominator->maximum (4);
      WMiNominator->step (1);
      WMiNominator->value (4);
      WMiNominator->callback ((Fl_Callback *) cb_WMiNominator);
    }				// Fl_Value_Input* WMiNominator
    {
      WMiBars =
	new Fl_Value_Input (195, 85, 35, 25,
			    gettext ("Number of Bars to import"));
      WMiBars->labelsize (12);
      WMiBars->minimum (1);
      WMiBars->maximum (8);
      WMiBars->step (1);
      WMiBars->value (1);
      WMiBars->callback ((Fl_Callback *) cb_WMiBars);
    }				// Fl_Value_Input* WMiBars
    {
      WMiDrumsMCh =
	new Fl_Value_Input (195, 115, 35, 25, gettext ("Drums Midi Channel"));
      WMiDrumsMCh->labelsize (12);
      WMiDrumsMCh->maximum (16);
      WMiDrumsMCh->step (1);
      WMiDrumsMCh->value (10);
      WMiDrumsMCh->callback ((Fl_Callback *) cb_WMiDrumsMCh);
    }				// Fl_Value_Input* WMiDrumsMCh
    {
      WMiBassMCh =
	new Fl_Value_Input (195, 145, 35, 25, gettext ("Bass Midi Channel"));
      WMiBassMCh->labelsize (12);
      WMiBassMCh->maximum (16);
      WMiBassMCh->step (1);
      WMiBassMCh->callback ((Fl_Callback *) cb_WMiBassMCh);
    }				// Fl_Value_Input* WMiBassMCh
    {
      Fl_Button *o = new Fl_Button (440, 185, 95, 35, gettext ("Ok"));
      o->box (FL_UP_FRAME);
      o->color ((Fl_Color) 44);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Ok2);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (440, 225, 95, 35, gettext ("Cancel"));
      o->box (FL_UP_FRAME);
      o->color ((Fl_Color) 44);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel5);
    }				// Fl_Button* o
    {
      WMiBaseKey = new Fl_Choice (480, 115, 50, 25, gettext ("Base Key"));
      WMiBaseKey->down_box (FL_BORDER_BOX);
      WMiBaseKey->labelsize (12);
      WMiBaseKey->callback ((Fl_Callback *) cb_WMiBaseKey);
      WMiBaseKey->menu (menu_WMiBaseKey);
    }				// Fl_Choice* WMiBaseKey
    {
      WMiAcc3MCh =
	new Fl_Value_Input (195, 235, 35, 25, gettext ("Acc3 Midi Channel"));
      WMiAcc3MCh->labelsize (12);
      WMiAcc3MCh->maximum (16);
      WMiAcc3MCh->step (1);
      WMiAcc3MCh->callback ((Fl_Callback *) cb_WMiAcc3MCh);
    }				// Fl_Value_Input* WMiAcc3MCh
    {
      WMiStart =
	new Fl_Value_Input (495, 150, 35, 25,
			    gettext ("Import starts at bar"));
      WMiStart->labelsize (12);
      WMiStart->minimum (1);
      WMiStart->maximum (100);
      WMiStart->step (1);
      WMiStart->value (1);
      WMiStart->callback ((Fl_Callback *) cb_WMiStart);
    }				// Fl_Value_Input* WMiStart
    {
      WMiAcc1MCh =
	new Fl_Value_Input (195, 175, 35, 25, gettext ("Acc1 Midi Channel"));
      WMiAcc1MCh->labelsize (12);
      WMiAcc1MCh->maximum (16);
      WMiAcc1MCh->step (1);
      WMiAcc1MCh->callback ((Fl_Callback *) cb_WMiAcc1MCh);
    }				// Fl_Value_Input* WMiAcc1MCh
    {
      WMiAcc2MCh =
	new Fl_Value_Input (195, 205, 35, 25, gettext ("Acc2 Midi Channel"));
      WMiAcc2MCh->labelsize (12);
      WMiAcc2MCh->maximum (16);
      WMiAcc2MCh->step (1);
      WMiAcc2MCh->callback ((Fl_Callback *) cb_WMiAcc2MCh);
    }				// Fl_Value_Input* WMiAcc2MCh
    {
      WMiAcc4MCh =
	new Fl_Value_Input (440, 50, 35, 25, gettext ("Acc4 Midi Channel"));
      WMiAcc4MCh->labelsize (12);
      WMiAcc4MCh->maximum (16);
      WMiAcc4MCh->step (1);
      WMiAcc4MCh->callback ((Fl_Callback *) cb_WMiAcc4MCh);
    }				// Fl_Value_Input* WMiAcc4MCh
    {
      WMiAcc5MCh =
	new Fl_Value_Input (440, 80, 35, 25, gettext ("Acc5 Midi Channel"));
      WMiAcc5MCh->labelsize (12);
      WMiAcc5MCh->maximum (16);
      WMiAcc5MCh->step (1);
      WMiAcc5MCh->callback ((Fl_Callback *) cb_WMiAcc5MCh);
    }				// Fl_Value_Input* WMiAcc5MCh
    {
      Fl_Group *o = new Fl_Group (235, 150, 45, 25);
      {
	WMimodeB1 = new Fl_Check_Button (235, 150, 25, 25, gettext ("Mode"));
	WMimodeB1->type (102);
	WMimodeB1->down_box (FL_DOWN_BOX);
	WMimodeB1->labelsize (12);
	WMimodeB1->callback ((Fl_Callback *) cb_WMimodeB1);
	WMimodeB1->align (FL_ALIGN_TOP_LEFT);
      }				// Fl_Check_Button* WMimodeB1
      {
	WMimodeB2 = new Fl_Check_Button (255, 150, 25, 25);
	WMimodeB2->type (102);
	WMimodeB2->down_box (FL_DOWN_BOX);
	WMimodeB2->value (1);
	WMimodeB2->labelsize (12);
	WMimodeB2->callback ((Fl_Callback *) cb_WMimodeB2);
      }				// Fl_Check_Button* WMimodeB2
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Group *o = new Fl_Group (235, 210, 45, 25);
      {
	WMimodeA21 = new Fl_Check_Button (235, 210, 25, 25, gettext ("Mode"));
	WMimodeA21->type (102);
	WMimodeA21->down_box (FL_DOWN_BOX);
	WMimodeA21->labelsize (12);
	WMimodeA21->callback ((Fl_Callback *) cb_WMimodeA21);
	WMimodeA21->align (FL_ALIGN_TOP_LEFT);
      }				// Fl_Check_Button* WMimodeA21
      {
	WMimodeA22 = new Fl_Check_Button (255, 210, 25, 25);
	WMimodeA22->type (102);
	WMimodeA22->down_box (FL_DOWN_BOX);
	WMimodeA22->value (1);
	WMimodeA22->labelsize (12);
	WMimodeA22->callback ((Fl_Callback *) cb_WMimodeA22);
      }				// Fl_Check_Button* WMimodeA22
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Group *o = new Fl_Group (480, 55, 45, 25);
      {
	WMimodeA41 = new Fl_Check_Button (480, 55, 25, 25, gettext ("Mode"));
	WMimodeA41->type (102);
	WMimodeA41->down_box (FL_DOWN_BOX);
	WMimodeA41->labelsize (12);
	WMimodeA41->callback ((Fl_Callback *) cb_WMimodeA41);
	WMimodeA41->align (FL_ALIGN_TOP_LEFT);
      }				// Fl_Check_Button* WMimodeA41
      {
	WMimodeA42 = new Fl_Check_Button (500, 55, 25, 25);
	WMimodeA42->type (102);
	WMimodeA42->down_box (FL_DOWN_BOX);
	WMimodeA42->value (1);
	WMimodeA42->labelsize (12);
	WMimodeA42->callback ((Fl_Callback *) cb_WMimodeA42);
      }				// Fl_Check_Button* WMimodeA42
      o->end ();
    }				// Fl_Group* o
    WinMidiImport->end ();
  }				// Fl_Double_Window* WinMidiImport
  {
    WTT = new Fl_Double_Window (300, 320, gettext ("Tempo Track"));
    WTT->color (FL_LIGHT2);
    WTT->user_data ((void *) (this));
    {
      TempoTrackBrowser = new Fl_Browser (5, 40, 150, 275);
      TempoTrackBrowser->type (2);
      TempoTrackBrowser->textsize (12);
      TempoTrackBrowser->callback ((Fl_Callback *) cb_TempoTrackBrowser);
    }				// Fl_Browser* TempoTrackBrowser
    {
      WTTBar = new Fl_Value_Input (240, 45, 40, 25, gettext ("Bar"));
      WTTBar->labelsize (12);
      WTTBar->minimum (1);
      WTTBar->maximum (4000);
      WTTBar->step (1);
      WTTBar->value (1);
      WTTBar->textsize (12);
    }				// Fl_Value_Input* WTTBar
    {
      WTTTempo = new Fl_Value_Input (240, 95, 40, 25, gettext ("Tempo"));
      WTTTempo->labelsize (12);
      WTTTempo->minimum (40);
      WTTTempo->maximum (260);
      WTTTempo->step (1);
      WTTTempo->value (120);
      WTTTempo->textsize (12);
    }				// Fl_Value_Input* WTTTempo
    {
      MTempoTrack = new Fl_Button (5, 5, 55, 30, gettext ("On"));
      MTempoTrack->type (1);
      MTempoTrack->box (FL_PLASTIC_UP_BOX);
      MTempoTrack->selection_color ((Fl_Color) 3);
      MTempoTrack->labeltype (FL_ENGRAVED_LABEL);
      MTempoTrack->labelsize (12);
      MTempoTrack->callback ((Fl_Callback *) cb_MTempoTrack);
      MTempoTrack->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Button* MTempoTrack
    {
      Fl_Button *o = new Fl_Button (170, 160, 110, 30, gettext ("Modify"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Modify);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (170, 125, 110, 30, gettext ("Add"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Add);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      WTTBlack = new Fl_Value_Input (240, 70, 40, 25, gettext ("Black Note"));
      WTTBlack->labelsize (12);
      WTTBlack->minimum (1);
      WTTBlack->maximum (4);
      WTTBlack->step (1);
      WTTBlack->value (1);
      WTTBlack->textsize (12);
    }				// Fl_Value_Input* WTTBlack
    {
      Fl_Button *o = new Fl_Button (170, 195, 110, 30, gettext ("Delete"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Delete);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (170, 230, 110, 30, gettext ("Insert"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Insert);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (170, 265, 110, 30, gettext ("Clear All"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Clear5);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (70, 5, 85, 30, gettext ("Close"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Close4);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    WTT->end ();
  }				// Fl_Double_Window* WTT
  return WTT;
}

void
GMORGAN::MiraConfig ()
{
  int i = 1;

  while (BMidiIn->text (i) != NULL)
    {
      if (strcmp (BMidiIn->text (i), gmo->MidiInPuerto[1].SetMidiIn) == 0)
	BMidiIn->select (i, 1);
      i++;
    }

  i = 1;

  while (BMidiOut->text (i) != NULL)
    {
      if (strcmp (BMidiOut->text (i), gmo->MidiOutPuerto[1].SetMidiOut) == 0)
	BMidiOut->select (i, 1);
      i++;
    }

  if (strcmp (gmo->SoundsFilename, "0") != 0)
    SoFiname->value (gmo->SoundsFilename);
  if (strcmp (gmo->PatternsFilename, "0") != 0)
    PaFiname->value (gmo->PatternsFilename);
  if (strcmp (gmo->StylesFilename, "0") != 0)
    StFiname->value (gmo->StylesFilename);
  if (strcmp (gmo->PresetFilename, "0") != 0)
    PrFiname->value (gmo->PresetFilename);
  if (strcmp (gmo->DrumNoteFilename, "0") != 0)
    DrFiname->value (gmo->DrumNoteFilename);
  if (strcmp (gmo->SkinFilename, "0") != 0)
    SkFiname->value (gmo->SkinFilename);
  SkinReadNames (gmo->SkinFilename);
  Muoff->value (gmo->MutesOnOff);
  if (strcmp (gmo->HelpFilename, "0") != 0)
    HpFiname->value (gmo->HelpFilename);
  if (strcmp (gmo->LibStylesFilename, "0") != 0)
    LStyFiname->value (gmo->LibStylesFilename);
}

void
GMORGAN::MiraClientes ()
{
  snd_seq_client_info_t *cinfo;
  snd_seq_port_info_t *pinfo;
  int client;
  int err;
  int i;
  snd_seq_t *handle;
  int count = 1;
  int count1 = 1;
  char temp[80];
  char linea[256];
  char *nctemp = strdup (gettext ("Not Connected"));
//  if (nctemp == 0) …process out of memory error; do not continue…
  if (nctemp == 0) cout << " Out of Memory- do not continue " << endl; 
  BMidiOut->clear ();
  BMidiIn->clear ();
  BMidiOut->add (nctemp);
  BMidiIn->add (nctemp);
  free(nctemp);

  err = snd_seq_open (&handle, "hw", SND_SEQ_OPEN_DUPLEX, 0);
  snd_config_update_free_global ();
  if (err < 0)
    printf (gettext ("Could not open sequencer\n"));

  snd_seq_client_info_alloca (&cinfo);
  snd_seq_client_info_set_client (cinfo, -1);

  while (snd_seq_query_next_client (handle, cinfo) >= 0)
    {
      client = snd_seq_client_info_get_client (cinfo);
      snd_seq_port_info_alloca (&pinfo);
      snd_seq_port_info_set_client (pinfo, client);

      snd_seq_port_info_set_port (pinfo, -1);
      while (snd_seq_query_next_port (handle, pinfo) >= 0)
	{
	  unsigned int cap;

	  cap = (SND_SEQ_PORT_CAP_SUBS_WRITE | SND_SEQ_PORT_CAP_WRITE);
	  if ((snd_seq_port_info_get_capability (pinfo) & cap) == cap)
	    {

	      gmo->CPOMidiS[count].Client =
		snd_seq_port_info_get_client (pinfo);
	      gmo->CPOMidiS[count].Port = snd_seq_port_info_get_port (pinfo);
	      gmo->CPOMidiS[count].CName =
		snd_seq_client_info_get_name (cinfo);
	      for (i = 0; i <= (int) (strlen (gmo->CPOMidiS[count].CName));
		   i++)
		gmo->CPOMidiS[count].Nombre[i] =
		  gmo->CPOMidiS[count].CName[i];
	      gmo->CPOMidiS[count].CInfo = snd_seq_port_info_get_name (pinfo);
	      for (i = 0; i <= (int) (strlen (gmo->CPOMidiS[count].CInfo));
		   i++)
		gmo->CPOMidiS[count].Info[i] = gmo->CPOMidiS[count].CInfo[i];
	      bzero (linea, sizeof (linea));
	      sprintf (linea, "%s", gmo->CPOMidiS[count].CInfo);
	      bzero (temp, sizeof (temp));
	      sscanf (linea, "%s", temp);
	      if (strcmp (temp, "gmorgan") != 0)

		BMidiOut->add (linea);

	      count++;
	    }

	  cap = (SND_SEQ_PORT_CAP_SUBS_READ | SND_SEQ_PORT_CAP_READ);
	  if ((snd_seq_port_info_get_capability (pinfo) & cap) == cap)
	    {

	      gmo->CPIMidiS[count1].Client =
		snd_seq_port_info_get_client (pinfo);
	      gmo->CPIMidiS[count1].Port = snd_seq_port_info_get_port (pinfo);
	      gmo->CPIMidiS[count1].CName =
		snd_seq_client_info_get_name (cinfo);
	      for (i = 0; i <= (int) (strlen (gmo->CPIMidiS[count1].CName));
		   i++)
		gmo->CPIMidiS[count1].Nombre[i] =
		  gmo->CPIMidiS[count1].CName[i];
	      gmo->CPIMidiS[count1].CInfo =
		snd_seq_port_info_get_name (pinfo);
	      for (i = 0; i <= (int) (strlen (gmo->CPIMidiS[count1].CInfo));
		   i++)
		gmo->CPIMidiS[count1].Info[i] =
		  gmo->CPIMidiS[count1].CInfo[i];
	      bzero (linea, sizeof (linea));
	      sprintf (linea, "%s", gmo->CPIMidiS[count1].CInfo);
	      bzero (temp, sizeof (temp));
	      sscanf (linea, "%s", temp);

	      if (strcmp (temp, "gmorgan") != 0)


		BMidiIn->add (linea);


	      count1++;

	    }

	}
    }
}

void
GMORGAN::Conecta ()
{
  char t1[40], t2[40];
  const char *tt1, *tt2;
  int client = 0;
  char linea[256];


  int queue = 0, convert_time = 0, convert_real = 0, exclusive = 0;
  snd_seq_port_subscribe_t *subs, *subs1;
  snd_seq_addr_t sender, dest;
//  cout << "********** Conecta **************" << endl;
  while (espera == 0)
    usleep (1);

  int k = 0, i = 0;

  for (k = 1; k <= 46; k++)
    {

      bzero (linea, sizeof (linea));
      sprintf (linea, "gmorgan IN");

      if (!strcmp (gmo->CPOMidiS[k].Info, linea))
	gmo->MidiInPuerto[1].YOIN = gmo->CPOMidiS[k].Client;
      if (!strcmp (gmo->CPIMidiS[k].Info, gmo->MidiInPuerto[1].SetMidiIn))
	{
	  gmo->MidiInPuerto[1].SettingsIN = gmo->CPIMidiS[k].Client;
	  gmo->MidiInPuerto[1].Ports = gmo->CPIMidiS[k].Port;
	}
    }
// cout << "SettingsIn =" << gmo->MidiInPuerto[1].SettingsIN << endl;
// cout << "Port IN = " <<  gmo->MidiInPuerto[1].Ports << endl;
  for (k = 1; k <= 46; k++)
    {
      bzero (linea, sizeof (linea));
      sprintf (linea, "gmorgan OUT");

      if (!strcmp (gmo->CPIMidiS[k].Info, linea))
	gmo->MidiOutPuerto[1].YOOUT = gmo->CPIMidiS[k].Client;
      if (!strcmp (gmo->CPOMidiS[k].Info, gmo->MidiOutPuerto[1].SetMidiOut))
	{
	  gmo->MidiOutPuerto[1].SettingsOUT = gmo->CPOMidiS[k].Client;
	  gmo->MidiOutPuerto[1].Ports = gmo->CPOMidiS[k].Port;
	}
    }
//  cout << " MidiOutPuerto[1].SettingsOUT " << gmo->MidiOutPuerto[1].SettingsOUT << endl;
//  cout << " MidiOutPuerto[1].Ports = " << gmo->MidiOutPuerto[1].Ports << endl;

  if (strcmp (gmo->MidiInPuerto[1].SetMidiIn, gettext ("Not Connected")) != 0)
    {
      bzero (t1, sizeof (t1));
      sprintf (t1, "%d", gmo->MidiInPuerto[1].YOIN);
      tt1 = t1;
      bzero (t2, sizeof (t2));
      sprintf (t2, "%d", gmo->MidiInPuerto[1].SettingsIN);
      tt2 = t2;


      if ((client = snd_seq_client_id (gmo->MidiInPuerto[1].midi_in)) < 0)
	printf (gettext ("can't get client id\n"));

      if (snd_seq_parse_address (gmo->MidiInPuerto[1].midi_in, &sender, tt2) <
	  0)
	printf (gettext ("invalid sender address %s\n"),
		(char *) gmo->MidiInPuerto[1].SettingsIN);
      if (snd_seq_parse_address (gmo->MidiInPuerto[1].midi_in, &dest, tt1) <
	  0)
	printf (gettext ("invalid destination address %s\n"),
		(char *) gmo->MidiInPuerto[1].YOIN);
      dest.port = gmo->MidiInPuerto[1].Ports;
      snd_seq_port_subscribe_alloca (&subs);
      snd_seq_port_subscribe_set_sender (subs, &sender);
      snd_seq_port_subscribe_set_dest (subs, &dest);
      snd_seq_port_subscribe_set_queue (subs, queue);
      snd_seq_port_subscribe_set_exclusive (subs, exclusive);
      snd_seq_port_subscribe_set_time_update (subs, convert_time);
      snd_seq_port_subscribe_set_time_real (subs, convert_real);

      if (snd_seq_get_port_subscription (gmo->MidiInPuerto[1].midi_in, subs)
	  == 0)
	printf (gettext ("Connection is already subscribed\n"));
      if (snd_seq_subscribe_port (gmo->MidiInPuerto[1].midi_in, subs) < 0)
	{
	  printf ("Connection failed (%s)\n", snd_strerror (errno));
	  DMIN1->label (gettext ("Connection failed"));
	}
      else
	{
	  bzero (linea, sizeof (linea));
	  sprintf (linea, "%d %s", gmo->MidiInPuerto[1].SettingsIN,
		   gmo->MidiInPuerto[1].SetMidiIn);
	  for (i = 0; i <= (int) strlen (linea); i++)
	    gmo->MidiInPuerto[1].pMIDIIN[i] = linea[i];
	}
    }
  else
    sprintf (gmo->MidiInPuerto[1].pMIDIIN, gettext ("Not Connected"));

  if (strcmp (gmo->MidiOutPuerto[1].SetMidiOut, gettext ("Not Connected")) !=
      0)
    {
      bzero (t1, sizeof (t1));
      sprintf (t1, "%d", gmo->MidiOutPuerto[1].YOOUT);
      tt1 = t1;
      bzero (t2, sizeof (t2));
      sprintf (t2, "%d", gmo->MidiOutPuerto[1].SettingsOUT);
      tt2 = t2;
      if ((client = snd_seq_client_id (gmo->MidiOutPuerto[1].midi_out)) < 0)
	printf (gettext ("can't get client id\n"));
      if (snd_seq_parse_address (gmo->MidiOutPuerto[1].midi_out, &sender, tt1)
	  < 0)
	printf (gettext ("invalid sender address %s\n"),
		(char *) gmo->MidiOutPuerto[1].YOOUT);
      if (snd_seq_parse_address (gmo->MidiOutPuerto[1].midi_out, &dest, tt2) <
	  0)
	printf (gettext ("invalid destination address %s\n"),
		(char *) gmo->MidiOutPuerto[1].SettingsOUT);
      dest.port = gmo->MidiOutPuerto[1].Ports;
      snd_seq_port_subscribe_alloca (&subs1);
      snd_seq_port_subscribe_set_sender (subs1, &sender);
      snd_seq_port_subscribe_set_dest (subs1, &dest);
      snd_seq_port_subscribe_set_queue (subs1, queue);
      snd_seq_port_subscribe_set_exclusive (subs1, exclusive);
      snd_seq_port_subscribe_set_time_update (subs1, convert_time);
      snd_seq_port_subscribe_set_time_real (subs1, convert_real);

      if (snd_seq_get_port_subscription
	  (gmo->MidiOutPuerto[1].midi_out, subs1) == 0)
	printf (gettext ("Connection is already subscribed\n"));
      if (snd_seq_subscribe_port (gmo->MidiOutPuerto[1].midi_out, subs1) < 0)
	{
	  printf ("Connection failed (%s)\n", snd_strerror (errno));
	  DMO1->label (gettext ("Connection failed"));
	}
      else
	{
	  bzero (linea, sizeof (linea));
	  sprintf (linea, "%d %s", gmo->MidiOutPuerto[1].SettingsOUT,
		   gmo->MidiOutPuerto[1].SetMidiOut);
	  for (i = 0; i <= (int) strlen (linea); i++)
	    gmo->MidiOutPuerto[1].pMIDIOUT[i] = linea[i];
	}
    }
  else
    sprintf (gmo->MidiOutPuerto[1].pMIDIOUT, gettext ("Not Connected"));
}

GMORGAN::GMORGAN (GMO * gmo_)
{
  Fl::visual (FL_DOUBLE | FL_INDEX);
  Fl::visual (FL_RGB);
  gmo = gmo_;
  make_window ();
  make_skin_changes (gmo->SkinFilename);
  gmorganwin->position (600, 1);
  MiraClientes ();
  Conecta ();
  LeePatterns ();
  LeeStyles ();
  metebank ();
  HZ1->value (gmo->HM[gmo->HMode].Name);
  PutCombi (gmo->ss);
  PutStyle (gmo->st);
  Fl::focus (StartStop);
  Fl::add_timeout (1.0 / 500.0, tick);
}

void
GMORGAN::tick (void *v)
{
  Fl::repeat_timeout (1.0 / 500.0, tick);
}

void
GMORGAN::metepattern ()
{
  int i = (gmo->sbar - 1) * (gmo->Rt[gmo->sp].blackn * 4);


  bn1->value (gmo->Rt[gmo->sp].basn[0][i + 1]);
  bn2->value (gmo->Rt[gmo->sp].basn[0][i + 2]);
  bn3->value (gmo->Rt[gmo->sp].basn[0][i + 3]);
  bn4->value (gmo->Rt[gmo->sp].basn[0][i + 4]);
  bn5->value (gmo->Rt[gmo->sp].basn[0][i + 5]);
  bn6->value (gmo->Rt[gmo->sp].basn[0][i + 6]);
  bn7->value (gmo->Rt[gmo->sp].basn[0][i + 7]);
  bn8->value (gmo->Rt[gmo->sp].basn[0][i + 8]);

  bv1->value (gmo->Rt[gmo->sp].basn[1][i + 1]);
  bv2->value (gmo->Rt[gmo->sp].basn[1][i + 2]);
  bv3->value (gmo->Rt[gmo->sp].basn[1][i + 3]);
  bv4->value (gmo->Rt[gmo->sp].basn[1][i + 4]);
  bv5->value (gmo->Rt[gmo->sp].basn[1][i + 5]);
  bv6->value (gmo->Rt[gmo->sp].basn[1][i + 6]);
  bv7->value (gmo->Rt[gmo->sp].basn[1][i + 7]);
  bv8->value (gmo->Rt[gmo->sp].basn[1][i + 8]);

  bl1->value (gmo->Rt[gmo->sp].basn[2][i + 1]);
  bl2->value (gmo->Rt[gmo->sp].basn[2][i + 2]);
  bl3->value (gmo->Rt[gmo->sp].basn[2][i + 3]);
  bl4->value (gmo->Rt[gmo->sp].basn[2][i + 4]);
  bl5->value (gmo->Rt[gmo->sp].basn[2][i + 5]);
  bl6->value (gmo->Rt[gmo->sp].basn[2][i + 6]);
  bl7->value (gmo->Rt[gmo->sp].basn[2][i + 7]);
  bl8->value (gmo->Rt[gmo->sp].basn[2][i + 8]);


  ac1l1->value (gmo->Rt[gmo->sp].acc1n[0][i + 1]);
  ac1l2->value (gmo->Rt[gmo->sp].acc1n[0][i + 2]);
  ac1l3->value (gmo->Rt[gmo->sp].acc1n[0][i + 3]);
  ac1l4->value (gmo->Rt[gmo->sp].acc1n[0][i + 4]);
  ac1l5->value (gmo->Rt[gmo->sp].acc1n[0][i + 5]);
  ac1l6->value (gmo->Rt[gmo->sp].acc1n[0][i + 6]);
  ac1l7->value (gmo->Rt[gmo->sp].acc1n[0][i + 7]);
  ac1l8->value (gmo->Rt[gmo->sp].acc1n[0][i + 8]);

  ac1v1->value (gmo->Rt[gmo->sp].acc1n[1][i + 1]);
  ac1v2->value (gmo->Rt[gmo->sp].acc1n[1][i + 2]);
  ac1v3->value (gmo->Rt[gmo->sp].acc1n[1][i + 3]);
  ac1v4->value (gmo->Rt[gmo->sp].acc1n[1][i + 4]);
  ac1v5->value (gmo->Rt[gmo->sp].acc1n[1][i + 5]);
  ac1v6->value (gmo->Rt[gmo->sp].acc1n[1][i + 6]);
  ac1v7->value (gmo->Rt[gmo->sp].acc1n[1][i + 7]);
  ac1v8->value (gmo->Rt[gmo->sp].acc1n[1][i + 8]);
  if (gmo->DosCuatro == 2)
    {
      ac2n1->value (gmo->Rt[gmo->sp].acc2n[0][i + 1]);
      ac2n2->value (gmo->Rt[gmo->sp].acc2n[0][i + 2]);
      ac2n3->value (gmo->Rt[gmo->sp].acc2n[0][i + 3]);
      ac2n4->value (gmo->Rt[gmo->sp].acc2n[0][i + 4]);
      ac2n5->value (gmo->Rt[gmo->sp].acc2n[0][i + 5]);
      ac2n6->value (gmo->Rt[gmo->sp].acc2n[0][i + 6]);
      ac2n7->value (gmo->Rt[gmo->sp].acc2n[0][i + 7]);
      ac2n8->value (gmo->Rt[gmo->sp].acc2n[0][i + 8]);

      ac2v1->value (gmo->Rt[gmo->sp].acc2n[1][i + 1]);
      ac2v2->value (gmo->Rt[gmo->sp].acc2n[1][i + 2]);
      ac2v3->value (gmo->Rt[gmo->sp].acc2n[1][i + 3]);
      ac2v4->value (gmo->Rt[gmo->sp].acc2n[1][i + 4]);
      ac2v5->value (gmo->Rt[gmo->sp].acc2n[1][i + 5]);
      ac2v6->value (gmo->Rt[gmo->sp].acc2n[1][i + 6]);
      ac2v7->value (gmo->Rt[gmo->sp].acc2n[1][i + 7]);
      ac2v8->value (gmo->Rt[gmo->sp].acc2n[1][i + 8]);

      ac2l1->value (gmo->Rt[gmo->sp].acc2n[2][i + 1]);
      ac2l2->value (gmo->Rt[gmo->sp].acc2n[2][i + 2]);
      ac2l3->value (gmo->Rt[gmo->sp].acc2n[2][i + 3]);
      ac2l4->value (gmo->Rt[gmo->sp].acc2n[2][i + 4]);
      ac2l5->value (gmo->Rt[gmo->sp].acc2n[2][i + 5]);
      ac2l6->value (gmo->Rt[gmo->sp].acc2n[2][i + 6]);
      ac2l7->value (gmo->Rt[gmo->sp].acc2n[2][i + 7]);
      ac2l8->value (gmo->Rt[gmo->sp].acc2n[2][i + 8]);
    }

  if (gmo->DosCuatro == 4)
    {
      ac2n1->value (gmo->Rt[gmo->sp].acc4n[0][i + 1]);
      ac2n2->value (gmo->Rt[gmo->sp].acc4n[0][i + 2]);
      ac2n3->value (gmo->Rt[gmo->sp].acc4n[0][i + 3]);
      ac2n4->value (gmo->Rt[gmo->sp].acc4n[0][i + 4]);
      ac2n5->value (gmo->Rt[gmo->sp].acc4n[0][i + 5]);
      ac2n6->value (gmo->Rt[gmo->sp].acc4n[0][i + 6]);
      ac2n7->value (gmo->Rt[gmo->sp].acc4n[0][i + 7]);
      ac2n8->value (gmo->Rt[gmo->sp].acc4n[0][i + 8]);

      ac2v1->value (gmo->Rt[gmo->sp].acc4n[1][i + 1]);
      ac2v2->value (gmo->Rt[gmo->sp].acc4n[1][i + 2]);
      ac2v3->value (gmo->Rt[gmo->sp].acc4n[1][i + 3]);
      ac2v4->value (gmo->Rt[gmo->sp].acc4n[1][i + 4]);
      ac2v5->value (gmo->Rt[gmo->sp].acc4n[1][i + 5]);
      ac2v6->value (gmo->Rt[gmo->sp].acc4n[1][i + 6]);
      ac2v7->value (gmo->Rt[gmo->sp].acc4n[1][i + 7]);
      ac2v8->value (gmo->Rt[gmo->sp].acc4n[1][i + 8]);

      ac2l1->value (gmo->Rt[gmo->sp].acc4n[2][i + 1]);
      ac2l2->value (gmo->Rt[gmo->sp].acc4n[2][i + 2]);
      ac2l3->value (gmo->Rt[gmo->sp].acc4n[2][i + 3]);
      ac2l4->value (gmo->Rt[gmo->sp].acc4n[2][i + 4]);
      ac2l5->value (gmo->Rt[gmo->sp].acc4n[2][i + 5]);
      ac2l6->value (gmo->Rt[gmo->sp].acc4n[2][i + 6]);
      ac2l7->value (gmo->Rt[gmo->sp].acc4n[2][i + 7]);
      ac2l8->value (gmo->Rt[gmo->sp].acc4n[2][i + 8]);
    }

  if (gmo->TresCinco == 3)
    {
      ac3n1->value (gmo->Rt[gmo->sp].acc3n[0][i + 1]);
      ac3n2->value (gmo->Rt[gmo->sp].acc3n[0][i + 2]);
      ac3n3->value (gmo->Rt[gmo->sp].acc3n[0][i + 3]);
      ac3n4->value (gmo->Rt[gmo->sp].acc3n[0][i + 4]);
      ac3n5->value (gmo->Rt[gmo->sp].acc3n[0][i + 5]);
      ac3n6->value (gmo->Rt[gmo->sp].acc3n[0][i + 6]);
      ac3n7->value (gmo->Rt[gmo->sp].acc3n[0][i + 7]);
      ac3n8->value (gmo->Rt[gmo->sp].acc3n[0][i + 8]);

      ac3v1->value (gmo->Rt[gmo->sp].acc3n[1][i + 1]);
      ac3v2->value (gmo->Rt[gmo->sp].acc3n[1][i + 2]);
      ac3v3->value (gmo->Rt[gmo->sp].acc3n[1][i + 3]);
      ac3v4->value (gmo->Rt[gmo->sp].acc3n[1][i + 4]);
      ac3v5->value (gmo->Rt[gmo->sp].acc3n[1][i + 5]);
      ac3v6->value (gmo->Rt[gmo->sp].acc3n[1][i + 6]);
      ac3v7->value (gmo->Rt[gmo->sp].acc3n[1][i + 7]);
      ac3v8->value (gmo->Rt[gmo->sp].acc3n[1][i + 8]);

      ac3l1->value (gmo->Rt[gmo->sp].acc3n[2][i + 1]);
      ac3l2->value (gmo->Rt[gmo->sp].acc3n[2][i + 2]);
      ac3l3->value (gmo->Rt[gmo->sp].acc3n[2][i + 3]);
      ac3l4->value (gmo->Rt[gmo->sp].acc3n[2][i + 4]);
      ac3l5->value (gmo->Rt[gmo->sp].acc3n[2][i + 5]);
      ac3l6->value (gmo->Rt[gmo->sp].acc3n[2][i + 6]);
      ac3l7->value (gmo->Rt[gmo->sp].acc3n[2][i + 7]);
      ac3l8->value (gmo->Rt[gmo->sp].acc3n[2][i + 8]);
    }

  if (gmo->TresCinco == 5)
    {
      ac3n1->value (gmo->Rt[gmo->sp].acc5n[0][i + 1]);
      ac3n2->value (gmo->Rt[gmo->sp].acc5n[0][i + 2]);
      ac3n3->value (gmo->Rt[gmo->sp].acc5n[0][i + 3]);
      ac3n4->value (gmo->Rt[gmo->sp].acc5n[0][i + 4]);
      ac3n5->value (gmo->Rt[gmo->sp].acc5n[0][i + 5]);
      ac3n6->value (gmo->Rt[gmo->sp].acc5n[0][i + 6]);
      ac3n7->value (gmo->Rt[gmo->sp].acc5n[0][i + 7]);
      ac3n8->value (gmo->Rt[gmo->sp].acc5n[0][i + 8]);

      ac3v1->value (gmo->Rt[gmo->sp].acc5n[1][i + 1]);
      ac3v2->value (gmo->Rt[gmo->sp].acc5n[1][i + 2]);
      ac3v3->value (gmo->Rt[gmo->sp].acc5n[1][i + 3]);
      ac3v4->value (gmo->Rt[gmo->sp].acc5n[1][i + 4]);
      ac3v5->value (gmo->Rt[gmo->sp].acc5n[1][i + 5]);
      ac3v6->value (gmo->Rt[gmo->sp].acc5n[1][i + 6]);
      ac3v7->value (gmo->Rt[gmo->sp].acc5n[1][i + 7]);
      ac3v8->value (gmo->Rt[gmo->sp].acc5n[1][i + 8]);

      ac3l1->value (gmo->Rt[gmo->sp].acc5n[2][i + 1]);
      ac3l2->value (gmo->Rt[gmo->sp].acc5n[2][i + 2]);
      ac3l3->value (gmo->Rt[gmo->sp].acc5n[2][i + 3]);
      ac3l4->value (gmo->Rt[gmo->sp].acc5n[2][i + 4]);
      ac3l5->value (gmo->Rt[gmo->sp].acc5n[2][i + 5]);
      ac3l6->value (gmo->Rt[gmo->sp].acc5n[2][i + 6]);
      ac3l7->value (gmo->Rt[gmo->sp].acc5n[2][i + 7]);
      ac3l8->value (gmo->Rt[gmo->sp].acc5n[2][i + 8]);
    }

  if (gmo->Rt[gmo->sp].blackn > 2)
    {

      bn9->value (gmo->Rt[gmo->sp].basn[0][i + 9]);
      bn10->value (gmo->Rt[gmo->sp].basn[0][i + 10]);
      bn11->value (gmo->Rt[gmo->sp].basn[0][i + 11]);
      bn12->value (gmo->Rt[gmo->sp].basn[0][i + 12]);

      bv9->value (gmo->Rt[gmo->sp].basn[1][i + 9]);
      bv10->value (gmo->Rt[gmo->sp].basn[1][i + 10]);
      bv11->value (gmo->Rt[gmo->sp].basn[1][i + 11]);
      bv12->value (gmo->Rt[gmo->sp].basn[1][i + 12]);

      bl9->value (gmo->Rt[gmo->sp].basn[2][i + 9]);
      bl10->value (gmo->Rt[gmo->sp].basn[2][i + 10]);
      bl11->value (gmo->Rt[gmo->sp].basn[2][i + 11]);
      bl12->value (gmo->Rt[gmo->sp].basn[2][i + 12]);

      ac1l9->value (gmo->Rt[gmo->sp].acc1n[0][i + 9]);
      ac1l10->value (gmo->Rt[gmo->sp].acc1n[0][i + 10]);
      ac1l11->value (gmo->Rt[gmo->sp].acc1n[0][i + 11]);
      ac1l12->value (gmo->Rt[gmo->sp].acc1n[0][i + 12]);

      ac1v9->value (gmo->Rt[gmo->sp].acc1n[1][i + 9]);
      ac1v10->value (gmo->Rt[gmo->sp].acc1n[1][i + 10]);
      ac1v11->value (gmo->Rt[gmo->sp].acc1n[1][i + 11]);
      ac1v12->value (gmo->Rt[gmo->sp].acc1n[1][i + 12]);

      if (gmo->DosCuatro == 2)
	{
	  ac2n9->value (gmo->Rt[gmo->sp].acc2n[0][i + 9]);
	  ac2n10->value (gmo->Rt[gmo->sp].acc2n[0][i + 10]);
	  ac2n11->value (gmo->Rt[gmo->sp].acc2n[0][i + 11]);
	  ac2n12->value (gmo->Rt[gmo->sp].acc2n[0][i + 12]);

	  ac2v9->value (gmo->Rt[gmo->sp].acc2n[1][i + 9]);
	  ac2v10->value (gmo->Rt[gmo->sp].acc2n[1][i + 10]);
	  ac2v11->value (gmo->Rt[gmo->sp].acc2n[1][i + 11]);
	  ac2v12->value (gmo->Rt[gmo->sp].acc2n[1][i + 12]);

	  ac2l9->value (gmo->Rt[gmo->sp].acc2n[2][i + 9]);
	  ac2l10->value (gmo->Rt[gmo->sp].acc2n[2][i + 10]);
	  ac2l11->value (gmo->Rt[gmo->sp].acc2n[2][i + 11]);
	  ac2l12->value (gmo->Rt[gmo->sp].acc2n[2][i + 12]);
	}
      if (gmo->DosCuatro == 4)
	{
	  ac2n9->value (gmo->Rt[gmo->sp].acc4n[0][i + 9]);
	  ac2n10->value (gmo->Rt[gmo->sp].acc4n[0][i + 10]);
	  ac2n11->value (gmo->Rt[gmo->sp].acc4n[0][i + 11]);
	  ac2n12->value (gmo->Rt[gmo->sp].acc4n[0][i + 12]);

	  ac2v9->value (gmo->Rt[gmo->sp].acc4n[1][i + 9]);
	  ac2v10->value (gmo->Rt[gmo->sp].acc4n[1][i + 10]);
	  ac2v11->value (gmo->Rt[gmo->sp].acc4n[1][i + 11]);
	  ac2v12->value (gmo->Rt[gmo->sp].acc4n[1][i + 12]);

	  ac2l9->value (gmo->Rt[gmo->sp].acc4n[2][i + 9]);
	  ac2l10->value (gmo->Rt[gmo->sp].acc4n[2][i + 10]);
	  ac2l11->value (gmo->Rt[gmo->sp].acc4n[2][i + 11]);
	  ac2l12->value (gmo->Rt[gmo->sp].acc4n[2][i + 12]);
	}

      if (gmo->TresCinco == 3)
	{
	  ac3n9->value (gmo->Rt[gmo->sp].acc3n[0][i + 9]);
	  ac3n10->value (gmo->Rt[gmo->sp].acc3n[0][i + 10]);
	  ac3n11->value (gmo->Rt[gmo->sp].acc3n[0][i + 11]);
	  ac3n12->value (gmo->Rt[gmo->sp].acc3n[0][i + 12]);

	  ac3v9->value (gmo->Rt[gmo->sp].acc3n[1][i + 9]);
	  ac3v10->value (gmo->Rt[gmo->sp].acc3n[1][i + 10]);
	  ac3v11->value (gmo->Rt[gmo->sp].acc3n[1][i + 11]);
	  ac3v12->value (gmo->Rt[gmo->sp].acc3n[1][i + 12]);

	  ac3l9->value (gmo->Rt[gmo->sp].acc3n[2][i + 9]);
	  ac3l10->value (gmo->Rt[gmo->sp].acc3n[2][i + 10]);
	  ac3l11->value (gmo->Rt[gmo->sp].acc3n[2][i + 11]);
	  ac3l12->value (gmo->Rt[gmo->sp].acc3n[2][i + 12]);
	}
      if (gmo->TresCinco == 5)
	{
	  ac3n9->value (gmo->Rt[gmo->sp].acc5n[0][i + 9]);
	  ac3n10->value (gmo->Rt[gmo->sp].acc5n[0][i + 10]);
	  ac3n11->value (gmo->Rt[gmo->sp].acc5n[0][i + 11]);
	  ac3n12->value (gmo->Rt[gmo->sp].acc5n[0][i + 12]);

	  ac3v9->value (gmo->Rt[gmo->sp].acc5n[1][i + 9]);
	  ac3v10->value (gmo->Rt[gmo->sp].acc5n[1][i + 10]);
	  ac3v11->value (gmo->Rt[gmo->sp].acc5n[1][i + 11]);
	  ac3v12->value (gmo->Rt[gmo->sp].acc5n[1][i + 12]);

	  ac3l9->value (gmo->Rt[gmo->sp].acc5n[2][i + 9]);
	  ac3l10->value (gmo->Rt[gmo->sp].acc5n[2][i + 10]);
	  ac3l11->value (gmo->Rt[gmo->sp].acc5n[2][i + 11]);
	  ac3l12->value (gmo->Rt[gmo->sp].acc5n[2][i + 12]);
	}

    }

  if (gmo->Rt[gmo->sp].blackn > 3)

    {



      bn13->value (gmo->Rt[gmo->sp].basn[0][i + 13]);
      bn14->value (gmo->Rt[gmo->sp].basn[0][i + 14]);
      bn15->value (gmo->Rt[gmo->sp].basn[0][i + 15]);
      bn16->value (gmo->Rt[gmo->sp].basn[0][i + 16]);

      bv13->value (gmo->Rt[gmo->sp].basn[1][i + 13]);
      bv14->value (gmo->Rt[gmo->sp].basn[1][i + 14]);
      bv15->value (gmo->Rt[gmo->sp].basn[1][i + 15]);
      bv16->value (gmo->Rt[gmo->sp].basn[1][i + 16]);

      bl13->value (gmo->Rt[gmo->sp].basn[2][i + 13]);
      bl14->value (gmo->Rt[gmo->sp].basn[2][i + 14]);
      bl15->value (gmo->Rt[gmo->sp].basn[2][i + 15]);
      bl16->value (gmo->Rt[gmo->sp].basn[2][i + 16]);

      ac1l13->value (gmo->Rt[gmo->sp].acc1n[0][i + 13]);
      ac1l14->value (gmo->Rt[gmo->sp].acc1n[0][i + 14]);
      ac1l15->value (gmo->Rt[gmo->sp].acc1n[0][i + 15]);
      ac1l16->value (gmo->Rt[gmo->sp].acc1n[0][i + 16]);

      ac1v13->value (gmo->Rt[gmo->sp].acc1n[1][i + 13]);
      ac1v14->value (gmo->Rt[gmo->sp].acc1n[1][i + 14]);
      ac1v15->value (gmo->Rt[gmo->sp].acc1n[1][i + 15]);
      ac1v16->value (gmo->Rt[gmo->sp].acc1n[1][i + 16]);
      if (gmo->DosCuatro == 2)
	{
	  ac2n13->value (gmo->Rt[gmo->sp].acc2n[0][i + 13]);
	  ac2n14->value (gmo->Rt[gmo->sp].acc2n[0][i + 14]);
	  ac2n15->value (gmo->Rt[gmo->sp].acc2n[0][i + 15]);
	  ac2n16->value (gmo->Rt[gmo->sp].acc2n[0][i + 16]);

	  ac2v13->value (gmo->Rt[gmo->sp].acc2n[1][i + 13]);
	  ac2v14->value (gmo->Rt[gmo->sp].acc2n[1][i + 14]);
	  ac2v15->value (gmo->Rt[gmo->sp].acc2n[1][i + 15]);
	  ac2v16->value (gmo->Rt[gmo->sp].acc2n[1][i + 16]);

	  ac2l13->value (gmo->Rt[gmo->sp].acc2n[2][i + 13]);
	  ac2l14->value (gmo->Rt[gmo->sp].acc2n[2][i + 14]);
	  ac2l15->value (gmo->Rt[gmo->sp].acc2n[2][i + 15]);
	  ac2l16->value (gmo->Rt[gmo->sp].acc2n[2][i + 16]);
	}
      if (gmo->DosCuatro == 4)
	{
	  ac2n13->value (gmo->Rt[gmo->sp].acc4n[0][i + 13]);
	  ac2n14->value (gmo->Rt[gmo->sp].acc4n[0][i + 14]);
	  ac2n15->value (gmo->Rt[gmo->sp].acc4n[0][i + 15]);
	  ac2n16->value (gmo->Rt[gmo->sp].acc4n[0][i + 16]);

	  ac2v13->value (gmo->Rt[gmo->sp].acc4n[1][i + 13]);
	  ac2v14->value (gmo->Rt[gmo->sp].acc4n[1][i + 14]);
	  ac2v15->value (gmo->Rt[gmo->sp].acc4n[1][i + 15]);
	  ac2v16->value (gmo->Rt[gmo->sp].acc4n[1][i + 16]);

	  ac2l13->value (gmo->Rt[gmo->sp].acc4n[2][i + 13]);
	  ac2l14->value (gmo->Rt[gmo->sp].acc4n[2][i + 14]);
	  ac2l15->value (gmo->Rt[gmo->sp].acc4n[2][i + 15]);
	  ac2l16->value (gmo->Rt[gmo->sp].acc4n[2][i + 16]);
	}
      if (gmo->TresCinco == 3)
	{
	  ac3n13->value (gmo->Rt[gmo->sp].acc3n[0][i + 13]);
	  ac3n14->value (gmo->Rt[gmo->sp].acc3n[0][i + 14]);
	  ac3n15->value (gmo->Rt[gmo->sp].acc3n[0][i + 15]);
	  ac3n16->value (gmo->Rt[gmo->sp].acc3n[0][i + 16]);

	  ac3v13->value (gmo->Rt[gmo->sp].acc3n[1][i + 13]);
	  ac3v14->value (gmo->Rt[gmo->sp].acc3n[1][i + 14]);
	  ac3v15->value (gmo->Rt[gmo->sp].acc3n[1][i + 15]);
	  ac3v16->value (gmo->Rt[gmo->sp].acc3n[1][i + 16]);

	  ac3l13->value (gmo->Rt[gmo->sp].acc3n[2][i + 13]);
	  ac3l14->value (gmo->Rt[gmo->sp].acc3n[2][i + 14]);
	  ac3l15->value (gmo->Rt[gmo->sp].acc3n[2][i + 15]);
	  ac3l16->value (gmo->Rt[gmo->sp].acc3n[2][i + 16]);
	}
      if (gmo->TresCinco == 5)
	{
	  ac3n13->value (gmo->Rt[gmo->sp].acc5n[0][i + 13]);
	  ac3n14->value (gmo->Rt[gmo->sp].acc5n[0][i + 14]);
	  ac3n15->value (gmo->Rt[gmo->sp].acc5n[0][i + 15]);
	  ac3n16->value (gmo->Rt[gmo->sp].acc5n[0][i + 16]);

	  ac3v13->value (gmo->Rt[gmo->sp].acc5n[1][i + 13]);
	  ac3v14->value (gmo->Rt[gmo->sp].acc5n[1][i + 14]);
	  ac3v15->value (gmo->Rt[gmo->sp].acc5n[1][i + 15]);
	  ac3v16->value (gmo->Rt[gmo->sp].acc5n[1][i + 16]);

	  ac3l13->value (gmo->Rt[gmo->sp].acc5n[2][i + 13]);
	  ac3l14->value (gmo->Rt[gmo->sp].acc5n[2][i + 14]);
	  ac3l15->value (gmo->Rt[gmo->sp].acc5n[2][i + 15]);
	  ac3l16->value (gmo->Rt[gmo->sp].acc5n[2][i + 16]);
	}
    }

  SBar->value (gmo->sbar);

  if (gmo->TresCinco == 3)
    RtAcc3Mode->value (gmo->Rt[gmo->sp].acc3mode);
  if (gmo->TresCinco == 5)
    RtAcc3Mode->value (gmo->Rt[gmo->sp].acc5mode);

  if (gmo->DosCuatro == 2)
    {
      RtAcc2Mode->value (gmo->Rt[gmo->sp].acc2mode);
      Poc->value (gmo->Rt[gmo->sp].octavate);
      if (gmo->Rt[gmo->sp].terceras)
	Pterc->setonly ();
      if (gmo->Rt[gmo->sp].sextas)
	Psext->setonly ();
      if ((gmo->Rt[gmo->sp].terceras == 0) && (gmo->Rt[gmo->sp].sextas == 0))
	Punison->setonly ();
    }

  if (gmo->DosCuatro == 4)
    {
      RtAcc2Mode->value (gmo->Rt[gmo->sp].acc4mode);
      Poc->value (gmo->Rt[gmo->sp].octavate4);
      if (gmo->Rt[gmo->sp].terceras4)
	Pterc->setonly ();
      if (gmo->Rt[gmo->sp].sextas4)
	Psext->setonly ();
      if ((gmo->Rt[gmo->sp].terceras4 == 0)
	  && (gmo->Rt[gmo->sp].sextas4 == 0))
	Punison->setonly ();
    }

  if (gmo->TresCinco == 3)
    STLTAcc35->value (gmo->Rt[gmo->sp].acc3stlt);
  if (gmo->TresCinco == 5)
    STLTAcc35->value (gmo->Rt[gmo->sp].acc5stlt);
  if (gmo->DosCuatro == 2)
    STLTAcc24->value (gmo->Rt[gmo->sp].acc2stlt);
  if (gmo->DosCuatro == 4)
    STLTAcc24->value (gmo->Rt[gmo->sp].acc4stlt);
  STLTAcc1->value (gmo->Rt[gmo->sp].acc1stlt);
  STLTBass->value (gmo->Rt[gmo->sp].bassstlt);
}

void
GMORGAN::procesaskin (char *temp)
{
  char WName[64], val1[128], val2[128], val11[128];
  int Funcion, valor1, valor2;
  Fl_Double_Window *Ventana = gmorganwin;
  Fl_Widget *Pepe = PtBro;
  Fl_Browser *Juan = PtBro;
  Fl_Menu_Item *Pedro = MFile;
  Fl_Counter *Ana = HarSlider;
  bzero (WName, sizeof (WName));
  Funcion = 1000;
  valor1 = 0;
  valor2 = 0;


  sscanf (temp, "%s %d %s %s", (char *) WName, &Funcion, (char *) val1,
	  (char *) val2);

  if (strcmp (WName, "Resize") == 0)
    {
      sscanf (val1, "%d", &valor1);
      gmorganwin->resize (1, 1, Funcion, valor1);
      return;
    }
  if (strcmp (WName, "NoResizable") == 0)
    {
      gmorganwin->resizable (NULL);
    }

  if (strcmp (WName, "MenuPrincipal") == 0)
    {
      Pepe = MenuPrincipal;
      goto sigue;
    }

  if (strcmp (WName, "CAJASALIDAS") == 0)
    {
      Pepe = CAJASALIDAS;
      goto sigue;
    }
  if (strcmp (WName, "CAJAACC1") == 0)
    {
      Pepe = CAJAACC1;
      goto sigue;
    }
  if (strcmp (WName, "CAJAACC2") == 0)
    {
      Pepe = CAJAACC2;
      goto sigue;
    }

  if (strcmp (WName, "CAJAACC4") == 0)
    {
      Pepe = CAJAACC4;
      goto sigue;
    }
  if (strcmp (WName, "CAJAACC5") == 0)
    {
      Pepe = CAJAACC5;
      goto sigue;
    }

  if (strcmp (WName, "CAJAHARMONIZER") == 0)
    {
      Pepe = CAJAHARMONIZER;
      goto sigue;
    }

  if (strcmp (WName, "CAJAACC3") == 0)
    {
      Pepe = CAJAACC3;
      goto sigue;
    }

  if (strcmp (WName, "CAJAPANICO") == 0)
    {
      Pepe = CAJAPANICO;
      goto sigue;
    }
  if (strcmp (WName, "ACC1LABEL") == 0)
    {
      Pepe = ACC1LABEL;
      goto sigue;
    }
  if (strcmp (WName, "ACC2LABEL") == 0)
    {
      Pepe = ACC2LABEL;
      goto sigue;
    }
  if (strcmp (WName, "ACC3LABEL") == 0)
    {
      Pepe = ACC3LABEL;
      goto sigue;
    }

  if (strcmp (WName, "ACC4LABEL") == 0)
    {
      Pepe = ACC4LABEL;
      goto sigue;
    }
  if (strcmp (WName, "ACC5LABEL") == 0)
    {
      Pepe = ACC5LABEL;
      goto sigue;
    }


  if (strcmp (WName, "BASSLABEL") == 0)
    {
      Pepe = BASSLABEL;
      goto sigue;
    }

  if (strcmp (WName, "DRUMSLABEL") == 0)
    {
      Pepe = DRUMSLABEL;
      goto sigue;
    }
  if (strcmp (WName, "CAJABASS") == 0)
    {
      Pepe = CAJABASS;
      goto sigue;
    }
  if (strcmp (WName, "CAJADRUMS") == 0)
    {
      Pepe = CAJADRUMS;
      goto sigue;
    }
  if (strcmp (WName, "CAJANOMSTYL") == 0)
    {
      Pepe = CAJANOMSTYL;
      goto sigue;
    }

  if (strcmp (WName, "CAJABROWSERS") == 0)
    {
      Pepe = CAJABROWSERS;
      goto sigue;
    }
  if (strcmp (WName, "CAJABROWSERS2") == 0)
    {
      Pepe = CAJABROWSERS2;
      goto sigue;
    }
  if (strcmp (WName, "CAJASALIDAS2") == 0)
    {
      Pepe = CAJASALIDAS2;
      goto sigue;
    }
  if (strcmp (WName, "CAJANEXT") == 0)
    {
      Pepe = CAJANEXT;
      goto sigue;
    }

  if (strcmp (WName, "StartStop") == 0)
    {
      Pepe = StartStop;
      goto sigue;
    }
  if (strcmp (WName, "TempoBPM") == 0)
    {
      Pepe = TempoBPM;
      goto sigue;
    }

  if (strcmp (WName, "PtBro") == 0)
    {
      Pepe = Juan = PtBro;
      goto sigue;
    }
  if (strcmp (WName, "StBro") == 0)
    {
      Pepe = Juan = StBro;
      goto sigue;
    }
  if (strcmp (WName, "N1") == 0)
    {
      Pepe = N1;
      goto sigue;
    }
  if (strcmp (WName, "Menu") == 0)
    Pepe = Menu;
  if (strcmp (WName, "MenuAyuda") == 0)
    Pepe = MenuAyuda;
  if (strcmp (WName, "MPlay") == 0)
    Pepe = MPlay;
  if (strcmp (WName, "MRecord") == 0)
    Pepe = MRecord;
  if (strcmp (WName, "CTEMPO") == 0)
    Pepe = Ana = CTEMPO;
  if (strcmp (WName, "N2") == 0)
    Pepe = N2;
  if (strcmp (WName, "N3") == 0)
    Pepe = N3;
  if (strcmp (WName, "N4") == 0)
    Pepe = N4;
  if (strcmp (WName, "PIntro") == 0)
    Pepe = PIntro;
  if (strcmp (WName, "PVar1") == 0)
    Pepe = PVar1;
  if (strcmp (WName, "PVar2") == 0)
    Pepe = PVar2;
  if (strcmp (WName, "PEnding") == 0)
    Pepe = PEnding;
  if (strcmp (WName, "CTRANSPOSE") == 0)
    Pepe = Ana = CTRANSPOSE;
  if (strcmp (WName, "NVar1") == 0)
    Pepe = NVar1;
  if (strcmp (WName, "NVar2") == 0)
    Pepe = NVar2;
  if (strcmp (WName, "NEnding") == 0)
    Pepe = NEnding;
  if (strcmp (WName, "NFill1") == 0)
    Pepe = NFill1;
  if (strcmp (WName, "NFill2") == 0)
    Pepe = NFill2;
  if (strcmp (WName, "DispTempo") == 0)
    Pepe = DispTempo;
  if (strcmp (WName, "DispBlack") == 0)
    Pepe = DispBlack;
  if (strcmp (WName, "ProSlider") == 0)
    Pepe = ProSlider;
  if (strcmp (WName, "HarSlider") == 0)
    Pepe = Ana = HarSlider;
  if (strcmp (WName, "DispNumber") == 0)
    Pepe = DispNumber;
  if (strcmp (WName, "PANICO") == 0)
    Pepe = PANICO;
  if (strcmp (WName, "P5") == 0)
    Pepe = P5;
  if (strcmp (WName, "P6") == 0)
    Pepe = P6;
  if (strcmp (WName, "P7") == 0)
    Pepe = P7;
  if (strcmp (WName, "P8") == 0)
    Pepe = P8;
  if (strcmp (WName, "P9") == 0)
    Pepe = P9;
  if (strcmp (WName, "P10") == 0)
    Pepe = P10;
  if (strcmp (WName, "P11") == 0)
    Pepe = P11;
  if (strcmp (WName, "VUI1") == 0)
    Pepe = VUI1;
  if (strcmp (WName, "P1") == 0)
    Pepe = P1;
  if (strcmp (WName, "P2") == 0)
    Pepe = P2;
  if (strcmp (WName, "P3") == 0)
    Pepe = P3;
  if (strcmp (WName, "P4") == 0)
    Pepe = P4;
  if (strcmp (WName, "Nombre") == 0)
    Pepe = Nombre;
  if (strcmp (WName, "ACI") == 0)
    Pepe = ACI;
  if (strcmp (WName, "STY1") == 0)
    Pepe = STY1;
  if (strcmp (WName, "DMO1") == 0)
    Pepe = DMO1;
  if (strcmp (WName, "DMIN1") == 0)
    Pepe = DMIN1;
  if (strcmp (WName, "HZ1") == 0)
    Pepe = HZ1;
  if (strcmp (WName, "FPan1") == 0)
    Pepe = FPan1;
  if (strcmp (WName, "FPan2") == 0)
    Pepe = FPan2;
  if (strcmp (WName, "FPan3") == 0)
    Pepe = FPan3;
  if (strcmp (WName, "FPan4") == 0)
    Pepe = FPan4;
  if (strcmp (WName, "FPan5") == 0)
    Pepe = FPan5;
  if (strcmp (WName, "FPan6") == 0)
    Pepe = FPan6;
  if (strcmp (WName, "FPan7") == 0)
    Pepe = FPan7;
  if (strcmp (WName, "FPan8") == 0)
    Pepe = FPan8;
  if (strcmp (WName, "FPan9") == 0)
    Pepe = FPan9;
  if (strcmp (WName, "FPan10") == 0)
    Pepe = FPan10;
  if (strcmp (WName, "FPan11") == 0)
    Pepe = FPan11;
  if (strcmp (WName, "FCho1") == 0)
    Pepe = FCho1;
  if (strcmp (WName, "FCho2") == 0)
    Pepe = FCho2;
  if (strcmp (WName, "FCho3") == 0)
    Pepe = FCho3;
  if (strcmp (WName, "FCho4") == 0)
    Pepe = FCho4;
  if (strcmp (WName, "FCho5") == 0)
    Pepe = FCho5;
  if (strcmp (WName, "FCho6") == 0)
    Pepe = FCho6;
  if (strcmp (WName, "FCho7") == 0)
    Pepe = FCho7;
  if (strcmp (WName, "FCho8") == 0)
    Pepe = FCho8;
  if (strcmp (WName, "FCho9") == 0)
    Pepe = FCho9;
  if (strcmp (WName, "FCho10") == 0)
    Pepe = FCho10;
  if (strcmp (WName, "FCho11") == 0)
    Pepe = FCho11;
  if (strcmp (WName, "FRev1") == 0)
    Pepe = FRev1;
  if (strcmp (WName, "FRev2") == 0)
    Pepe = FRev2;
  if (strcmp (WName, "FRev3") == 0)
    Pepe = FRev3;
  if (strcmp (WName, "FRev4") == 0)
    Pepe = FRev4;
  if (strcmp (WName, "FRev5") == 0)
    Pepe = FRev5;
  if (strcmp (WName, "FRev6") == 0)
    Pepe = FRev6;
  if (strcmp (WName, "FRev7") == 0)
    Pepe = FRev7;
  if (strcmp (WName, "FRev8") == 0)
    Pepe = FRev8;
  if (strcmp (WName, "FRev9") == 0)
    Pepe = FRev9;
  if (strcmp (WName, "FRev10") == 0)
    Pepe = FRev10;
  if (strcmp (WName, "FRev11") == 0)
    Pepe = FRev11;
  if (strcmp (WName, "FVol1") == 0)
    Pepe = FVol1;
  if (strcmp (WName, "FVol2") == 0)
    Pepe = FVol2;
  if (strcmp (WName, "FVol3") == 0)
    Pepe = FVol3;
  if (strcmp (WName, "FVol4") == 0)
    Pepe = FVol4;
  if (strcmp (WName, "FVol5") == 0)
    Pepe = FVol5;
  if (strcmp (WName, "FVol6") == 0)
    Pepe = FVol6;
  if (strcmp (WName, "FVol7") == 0)
    Pepe = FVol7;
  if (strcmp (WName, "FVol8") == 0)
    Pepe = FVol8;
  if (strcmp (WName, "FVol9") == 0)
    Pepe = FVol9;
  if (strcmp (WName, "FVol10") == 0)
    Pepe = FVol10;
  if (strcmp (WName, "FVol11") == 0)
    Pepe = FVol11;
  if (strcmp (WName, "FProg1") == 0)
    Pepe = Ana = FProg1;
  if (strcmp (WName, "FProg2") == 0)
    Pepe = Ana = FProg2;
  if (strcmp (WName, "FProg3") == 0)
    Pepe = Ana = FProg3;
  if (strcmp (WName, "FProg4") == 0)
    Pepe = Ana = FProg4;
  if (strcmp (WName, "FProg5") == 0)
    Pepe = Ana = FProg5;
  if (strcmp (WName, "FProg6") == 0)
    Pepe = Ana = FProg6;
  if (strcmp (WName, "FProg7") == 0)
    Pepe = Ana = FProg7;
  if (strcmp (WName, "FProg8") == 0)
    Pepe = Ana = FProg8;
  if (strcmp (WName, "FProg9") == 0)
    Pepe = Ana = FProg9;
  if (strcmp (WName, "FProg10") == 0)
    Pepe = Ana = FProg10;
  if (strcmp (WName, "FProg11") == 0)
    Pepe = Ana = FProg11;
  if (strcmp (WName, "Pof1") == 0)
    Pepe = Pof1;
  if (strcmp (WName, "Pof2") == 0)
    Pepe = Pof2;
  if (strcmp (WName, "Pof3") == 0)
    Pepe = Pof3;
  if (strcmp (WName, "Pof4") == 0)
    Pepe = Pof4;
  if (strcmp (WName, "Pof5") == 0)
    Pepe = Pof5;
  if (strcmp (WName, "Pof6") == 0)
    Pepe = Pof6;
  if (strcmp (WName, "Pof7") == 0)
    Pepe = Pof7;
  if (strcmp (WName, "Pof8") == 0)
    Pepe = Pof8;
  if (strcmp (WName, "Pof9") == 0)
    Pepe = Pof9;
  if (strcmp (WName, "Pof10") == 0)
    Pepe = Pof10;
  if (strcmp (WName, "Pof11") == 0)
    Pepe = Pof11;
  if (strcmp (WName, "Mas1") == 0)
    Pepe = Mas1;
  if (strcmp (WName, "Mas2") == 0)
    Pepe = Mas2;
  if (strcmp (WName, "Mas3") == 0)
    Pepe = Mas3;
  if (strcmp (WName, "Mas4") == 0)
    Pepe = Mas4;
  if (strcmp (WName, "Mas5") == 0)
    Pepe = Mas5;
  if (strcmp (WName, "Mas6") == 0)
    Pepe = Mas6;
  if (strcmp (WName, "Mas7") == 0)
    Pepe = Mas7;
  if (strcmp (WName, "Mas8") == 0)
    Pepe = Mas8;
  if (strcmp (WName, "Mas9") == 0)
    Pepe = Mas9;
  if (strcmp (WName, "Mas10") == 0)
    Pepe = Mas10;
  if (strcmp (WName, "Mas11") == 0)
    Pepe = Mas11;
  if (strcmp (WName, "Grupito") == 0)
    Pepe = Grupito;
  if (strcmp (WName, "MFile") == 0)
    Pedro = MFile;
  if (strcmp (WName, "MFilesub1") == 0)
    Pedro = MFilesub1;
  if (strcmp (WName, "MFilesub2") == 0)
    Pedro = MFilesub2;
  if (strcmp (WName, "MFilesub3") == 0)
    Pedro = MFilesub3;
  if (strcmp (WName, "MFilesub4") == 0)
    Pedro = MFilesub4;
  if (strcmp (WName, "MFilesub5") == 0)
    Pedro = MFilesub5;
  if (strcmp (WName, "MFilesub6") == 0)
    Pedro = MFilesub6;
  if (strcmp (WName, "MFilesub7") == 0)
    Pedro = MFilesub7;
  if (strcmp (WName, "MFilesub8") == 0)
    Pedro = MFilesub8;
  if (strcmp (WName, "MFilesub9") == 0)
    Pedro = MFilesub9;
  if (strcmp (WName, "MFilesub10") == 0)
    Pedro = MFilesub10;
  if (strcmp (WName, "MFilesub11") == 0)
    Pedro = MFilesub11;
  if (strcmp (WName, "MFilesub12") == 0)
    Pedro = MFilesub12;
  if (strcmp (WName, "MFilesub13") == 0)
    Pedro = MFilesub13;
  if (strcmp (WName, "MFilesub14") == 0)
    Pedro = MFilesub14;
  if (strcmp (WName, "MFilesub15") == 0)
    Pedro = MFilesub15;
  if (strcmp (WName, "MFilesub16") == 0)
    Pedro = MFilesub16;
  if (strcmp (WName, "EditWins") == 0)
    Pedro = EditWins;
  if (strcmp (WName, "EditWinssub1") == 0)
    Pedro = EditWinssub1;
  if (strcmp (WName, "EditWinssub2") == 0)
    Pedro = EditWinssub2;
  if (strcmp (WName, "EditWinssub3") == 0)
    Pedro = EditWinssub3;
  if (strcmp (WName, "EditWinssub4") == 0)
    Pedro = EditWinssub4;
  if (strcmp (WName, "EditWinssub5") == 0)
    Pedro = EditWinssub5;
  if (strcmp (WName, "EditWinssub6") == 0)
    Pedro = EditWinssub6;
  if (strcmp (WName, "MBank") == 0)
    Pedro = MBank;
  if (strcmp (WName, "BPlay") == 0)
    Pedro = BPlay;
  if (strcmp (WName, "MenuUtils") == 0)
    Pedro = MenuUtils;
  if (strcmp (WName, "MenuUtilssub1") == 0)
    Pedro = MenuUtilssub1;
  if (strcmp (WName, "MenuUtilssub2") == 0)
    Pedro = MenuUtilssub2;
  if (strcmp (WName, "MenuUtilssub3") == 0)
    Pedro = MenuUtilssub3;
  if (strcmp (WName, "MenuUtilssub4") == 0)
    Pedro = MenuUtilssub4;
  if (strcmp (WName, "MenuUtilssub5") == 0)
    Pedro = MenuUtilssub5;
  if (strcmp (WName, "MSettings") == 0)
    Pedro = MSettings;
  if (strcmp (WName, "MSettingssub1") == 0)
    Pedro = MSettingssub1;
  if (strcmp (WName, "MSettingssub2") == 0)
    Pedro = MSettingssub2;
  if (strcmp (WName, "MSettingssub3") == 0)
    Pedro = MSettingssub3;
  if (strcmp (WName, "MenuHelp") == 0)
    Pedro = MenuHelp;
  if (strcmp (WName, "MenuHelpsub1") == 0)
    Pedro = MenuHelpsub1;
  if (strcmp (WName, "MenuHelpsub2") == 0)
    Pedro = MenuHelpsub2;




sigue:

  if (Funcion == 10)
    {
      sprintf (val11, "%s%s/%s", gmo->Skindir, gmo->SkinNombre, val1);

      if (strcmp (fl_filename_ext (val11), ".jpg") == 0)
	{
	  Fl_JPEG_Image *Imagen = new Fl_JPEG_Image (val11);
	  Pepe->image (Imagen);
	}

      if (strcmp (fl_filename_ext (val11), ".jpeg") == 0)
	{
	  Fl_JPEG_Image *Imagen = new Fl_JPEG_Image (val11);
	  Pepe->image (Imagen);
	}

      if (strcmp (fl_filename_ext (val11), ".JPG") == 0)
	{
	  Fl_JPEG_Image *Imagen = new Fl_JPEG_Image (val11);
	  Pepe->image (Imagen);
	}

      if (strcmp (fl_filename_ext (val11), ".JPEG") == 0)
	{
	  Fl_JPEG_Image *Imagen = new Fl_JPEG_Image (val11);
	  Pepe->image (Imagen);
	}


      if (strcmp (fl_filename_ext (val11), ".png") == 0)
	{
	  Fl_PNG_Image *Imagen = new Fl_PNG_Image (val11);
	  Pepe->image (Imagen);
	}

      if (strcmp (fl_filename_ext (val11), ".PNG") == 0)
	{
	  Fl_PNG_Image *Imagen = new Fl_PNG_Image (val11);
	  Pepe->image (Imagen);
	}


      return;
    }



  switch (Funcion)
    {
    case 0:
      Pepe->hide ();
      break;

    case 1:
      sscanf (val1, "%d", &valor1);
      Pepe->color (valor1);
      break;

    case 2:
      if (strcmp (val1, "FL_NO_BOX") == 0)
	Pepe->box (FL_NO_BOX);
      if (strcmp (val1, "FL_FLAT_BOX") == 0)
	Pepe->box (FL_FLAT_BOX);
      if (strcmp (val1, "FL_UP_BOX") == 0)
	Pepe->box (FL_UP_BOX);
      if (strcmp (val1, "FL_DOWN_BOX") == 0)
	Pepe->box (FL_DOWN_BOX);
      if (strcmp (val1, "FL_UP_FRAME") == 0)
	Pepe->box (FL_UP_FRAME);
      if (strcmp (val1, "FL_DOWN_FRAME") == 0)
	Pepe->box (FL_DOWN_FRAME);
      if (strcmp (val1, "FL_THIN_UP_BOX") == 0)
	Pepe->box (FL_THIN_UP_BOX);
      if (strcmp (val1, "FL_THIN_DOWN_BOX") == 0)
	Pepe->box (FL_THIN_DOWN_BOX);
      if (strcmp (val1, "FL_THIN_UP_FRAME") == 0)
	Pepe->box (FL_THIN_UP_FRAME);
      if (strcmp (val1, "FL_THIN_DOWN_FRAME") == 0)
	Pepe->box (FL_THIN_DOWN_FRAME);
      if (strcmp (val1, "FL_ENGRAVED_BOX") == 0)
	Pepe->box (FL_ENGRAVED_BOX);
      if (strcmp (val1, "FL_ENGRAVED_FRAME") == 0)
	Pepe->box (FL_ENGRAVED_FRAME);
      if (strcmp (val1, "FL_EMBOSSED_BOX") == 0)
	Pepe->box (FL_EMBOSSED_BOX);
      if (strcmp (val1, "FL_EMBOSSED_FRAME") == 0)
	Pepe->box (FL_EMBOSSED_FRAME);
      if (strcmp (val1, "FL_BORDER_BOX") == 0)
	Pepe->box (FL_BORDER_BOX);
      if (strcmp (val1, "FL_BORDER_FRAME") == 0)
	Pepe->box (FL_BORDER_FRAME);
      if (strcmp (val1, "FL_SHADOW_BOX") == 0)
	Pepe->box (FL_SHADOW_BOX);
      if (strcmp (val1, "FL_SHADOW_FRAME") == 0)
	Pepe->box (FL_SHADOW_FRAME);
      if (strcmp (val1, "_FL_ROUNDED_BOX") == 0)
	Pepe->box (_FL_ROUNDED_BOX);
      if (strcmp (val1, "_FL_RSHADOW_BOX") == 0)
	Pepe->box (_FL_RSHADOW_BOX);
      if (strcmp (val1, "_FL_ROUNDED_FRAME") == 0)
	Pepe->box (_FL_ROUNDED_FRAME);
      if (strcmp (val1, "_FL_RFLAT_BOX") == 0)
	Pepe->box (_FL_RFLAT_BOX);
      if (strcmp (val1, "_FL_ROUND_UP_BOX") == 0)
	Pepe->box (_FL_ROUND_UP_BOX);
      if (strcmp (val1, "_FL_ROUND_DOWN_BOX") == 0)
	Pepe->box (_FL_ROUND_DOWN_BOX);
      if (strcmp (val1, "_FL_DIAMOND_UP_BOX") == 0)
	Pepe->box (_FL_DIAMOND_UP_BOX);
      if (strcmp (val1, "_FL_DIAMOND_DOWN_BOX") == 0)
	Pepe->box (_FL_DIAMOND_DOWN_BOX);
      if (strcmp (val1, "_FL_OVAL_BOX") == 0)
	Pepe->box (_FL_OVAL_BOX);
      if (strcmp (val1, "_FL_OSHADOW_BOX") == 0)
	Pepe->box (_FL_OSHADOW_BOX);
      if (strcmp (val1, "_FL_OVAL_FRAME") == 0)
	Pepe->box (_FL_OVAL_FRAME);
      if (strcmp (val1, "_FL_OFLAT_BOX") == 0)
	Pepe->box (_FL_OFLAT_BOX);
      if (strcmp (val1, "_FL_PLASTIC_UP_BOX") == 0)
	Pepe->box (_FL_PLASTIC_UP_BOX);
      if (strcmp (val1, "_FL_PLASTIC_DOWN_BOX") == 0)
	Pepe->box (_FL_PLASTIC_DOWN_BOX);
      if (strcmp (val1, "_FL_PLASTIC_UP_FRAME") == 0)
	Pepe->box (_FL_PLASTIC_UP_FRAME);
      if (strcmp (val1, "_FL_PLASTIC_DOWN_FRAME") == 0)
	Pepe->box (_FL_PLASTIC_DOWN_FRAME);
      if (strcmp (val1, "FL_FREE_BOXTYPE") == 0)
	Pepe->box (FL_FREE_BOXTYPE);
      break;

    case 3:
      sscanf (val1, "%d", &valor1);
      Pepe->labelcolor (valor1);
      break;

    case 4:
      sscanf (val1, "%d", &valor1);
      Pepe->labelfont (valor1);
      break;

    case 5:
      sscanf (val1, "%d", &valor1);
      Pepe->labelsize (valor1);
      break;

    case 6:
      if (strcmp (val1, "FL_NORMAL_LABEL") == 0)
	Pepe->labeltype (FL_NORMAL_LABEL);
      if (strcmp (val1, "FL_NO_LABEL") == 0)
	Pepe->labeltype (FL_NO_LABEL);
      if (strcmp (val1, "_FL_SHADOW_LABEL") == 0)
	Pepe->labeltype (_FL_SHADOW_LABEL);
      if (strcmp (val1, "_FL_ENGRAVED_LABEL") == 0)
	Pepe->labeltype (_FL_ENGRAVED_LABEL);
      if (strcmp (val1, "_FL_EMBOSSED_LABEL") == 0)
	Pepe->labeltype (_FL_EMBOSSED_LABEL);
      if (strcmp (val1, "_FL_MULTI_LABEL") == 0)
	Pepe->labeltype (_FL_MULTI_LABEL);
      if (strcmp (val1, "_FL_ICON_LABEL") == 0)
	Pepe->labeltype (_FL_ICON_LABEL);
      if (strcmp (val1, "_FL_IMAGE_LABEL") == 0)
	Pepe->labeltype (_FL_IMAGE_LABEL);
      if (strcmp (val1, "FL_FREE_LABELTYPE") == 0)
	Pepe->labeltype (FL_FREE_LABELTYPE);
      break;

    case 7:
      sscanf (val1, "%d", &valor1);
      sscanf (val2, "%d", &valor2);
      Pepe->position (valor1, valor2);
      break;

    case 8:
      sscanf (val1, "%d", &valor1);
      sscanf (val2, "%d", &valor2);
      Pepe->size (valor1, valor2);
      break;

    case 9:
      sscanf (val1, "%d", &valor1);
      Pepe->selection_color (valor1);
      break;

    case 11:
      if (strcmp (val1, "FL_ALIGN_CENTER") == 0)
	Pepe->align (FL_ALIGN_CENTER);
      if (strcmp (val1, "FL_ALIGN_TOP") == 0)
	Pepe->align (FL_ALIGN_TOP);
      if (strcmp (val1, "FL_ALIGN_BOTTOM") == 0)
	Pepe->align (FL_ALIGN_BOTTOM);
      if (strcmp (val1, "FL_ALIGN_LEFT") == 0)
	Pepe->align (FL_ALIGN_LEFT);
      if (strcmp (val1, "FL_ALIGN_RIGHT") == 0)
	Pepe->align (FL_ALIGN_RIGHT);
      if (strcmp (val1, "FL_ALIGN_INSIDE") == 0)
	Pepe->align (FL_ALIGN_INSIDE);
      if (strcmp (val1, "FL_ALIGN_TEXT_OVER_IMAGE") == 0)
	Pepe->align (FL_ALIGN_TEXT_OVER_IMAGE);
      if (strcmp (val1, "FL_ALIGN_IMAGE_OVER_TEXT") == 0)
	Pepe->align (FL_ALIGN_IMAGE_OVER_TEXT);
      if (strcmp (val1, "FL_ALIGN_CLIP") == 0)
	Pepe->align (FL_ALIGN_CLIP);
      if (strcmp (val1, "FL_ALIGN_WRAP") == 0)
	Pepe->align (FL_ALIGN_WRAP);
      if (strcmp (val1, "FL_ALIGN_TOP_LEFT") == 0)
	Pepe->align (FL_ALIGN_TOP_LEFT);
      if (strcmp (val1, "FL_ALIGN_TOP_RIGHT") == 0)
	Pepe->align (FL_ALIGN_TOP_RIGHT);
      if (strcmp (val1, "FL_ALIGN_BOTTOM_LEFT") == 0)
	Pepe->align (FL_ALIGN_BOTTOM_LEFT);
      if (strcmp (val1, "FL_ALIGN_BOTTOM_RIGHT") == 0)
	Pepe->align (FL_ALIGN_BOTTOM_RIGHT);
      if (strcmp (val1, "FL_ALIGN_LEFT_TOP") == 0)
	Pepe->align (FL_ALIGN_LEFT_TOP);
      if (strcmp (val1, "FL_ALIGN_RIGHT_TOP") == 0)
	Pepe->align (FL_ALIGN_RIGHT_TOP);
      if (strcmp (val1, "FL_ALIGN_LEFT_BOTTOM") == 0)
	Pepe->align (FL_ALIGN_LEFT_BOTTOM);
      if (strcmp (val1, "FL_ALIGN_RIGHT_BOTTOM") == 0)
	Pepe->align (FL_ALIGN_RIGHT_BOTTOM);
      if (strcmp (val1, "FL_ALIGN_NOWRAP") == 0)
	Pepe->align (FL_ALIGN_NOWRAP);
      break;

    case 12:
      sscanf (val1, "%d", &valor1);
      Juan->textsize (valor1);
      break;

    case 13:
      sscanf (val1, "%d", &valor1);
      Pedro->labelsize (valor1);
      break;

    case 14:
      sscanf (val1, "%d", &valor1);
      Ana->textsize (valor1);
      break;

    case 15:
      sscanf (val1, "%d", &valor1);
      sscanf (val2, "%d", &valor2);
      Ventana->size (valor1, valor2);
      break;

    case 16:
      sscanf (val1, "%d", &valor1);
      sscanf (val2, "%d", &valor2);
      Pepe->color (valor1, valor2);
      break;

    }
}

void
GMORGAN::QuitaPon ()
{
  switch (gmo->Rt[gmo->sp].blackn)
    {
    case 2:

      B1G3->hide ();
      B1G4->hide ();
      bn9->hide ();
      bn10->hide ();
      bn11->hide ();
      bn12->hide ();
      bn13->hide ();
      bn14->hide ();
      bn15->hide ();
      bn16->hide ();
      BV1G3->hide ();
      BV1G4->hide ();
      bv9->hide ();
      bv10->hide ();
      bv11->hide ();
      bv12->hide ();
      bv13->hide ();
      bv14->hide ();
      bv15->hide ();
      bv16->hide ();
      BL1G3->hide ();
      BL1G4->hide ();
      bl9->hide ();
      bl10->hide ();
      bl11->hide ();
      bl12->hide ();
      bl13->hide ();
      bl14->hide ();
      bl15->hide ();
      bl16->hide ();
      AC1VG3->hide ();
      AC1VG4->hide ();
      ac1v9->hide ();
      ac1v10->hide ();
      ac1v11->hide ();
      ac1v12->hide ();
      ac1v13->hide ();
      ac1v14->hide ();
      ac1v15->hide ();
      ac1v16->hide ();
      AC1LG3->hide ();
      AC1LG4->hide ();
      ac1l9->hide ();
      ac1l10->hide ();
      ac1l11->hide ();
      ac1l12->hide ();
      ac1l13->hide ();
      ac1l14->hide ();
      ac1l15->hide ();
      ac1l16->hide ();
      AC2G3->hide ();
      AC2G4->hide ();
      ac2n9->hide ();
      ac2n10->hide ();
      ac2n11->hide ();
      ac2n12->hide ();
      ac2n13->hide ();
      ac2n14->hide ();
      ac2n15->hide ();
      ac2n16->hide ();
      AC2VG3->hide ();
      AC2VG4->hide ();
      ac2v9->hide ();
      ac2v10->hide ();
      ac2v11->hide ();
      ac2v12->hide ();
      ac2v13->hide ();
      ac2v14->hide ();
      ac2v15->hide ();
      ac2v16->hide ();
      AC2LG3->hide ();
      AC2LG4->hide ();
      ac2l9->hide ();
      ac2l10->hide ();
      ac2l11->hide ();
      ac2l12->hide ();
      ac2l13->hide ();
      ac2l14->hide ();
      ac2l15->hide ();
      ac2l16->hide ();
      AC3G3->hide ();
      AC3G4->hide ();
      ac3n9->hide ();
      ac3n10->hide ();
      ac3n11->hide ();
      ac3n12->hide ();
      ac3n13->hide ();
      ac3n14->hide ();
      ac3n15->hide ();
      ac3n16->hide ();
      AC3VG3->hide ();
      AC3VG4->hide ();
      ac3v9->hide ();
      ac3v10->hide ();
      ac3v11->hide ();
      ac3v12->hide ();
      ac3v13->hide ();
      ac3v14->hide ();
      ac3v15->hide ();
      ac3v16->hide ();
      AC3LG3->hide ();
      AC3LG4->hide ();
      ac3l9->hide ();
      ac3l10->hide ();
      ac3l11->hide ();
      ac3l12->hide ();
      ac3l13->hide ();
      ac3l14->hide ();
      ac3l15->hide ();
      ac3l16->hide ();
      break;

    case 3:

      B1G3->show ();
      B1G4->hide ();
      bn9->show ();
      bn10->show ();
      bn11->show ();
      bn12->show ();
      bn13->hide ();
      bn14->hide ();
      bn15->hide ();
      bn16->hide ();
      BV1G3->show ();
      BV1G4->hide ();
      bv9->show ();
      bv10->show ();
      bv11->show ();
      bv12->show ();
      bv13->hide ();
      bv14->hide ();
      bv15->hide ();
      bv16->hide ();
      BL1G3->show ();
      BL1G4->hide ();
      bl9->show ();
      bl10->show ();
      bl11->show ();
      bl12->show ();
      bl13->hide ();
      bl14->hide ();
      bl15->hide ();
      bl16->hide ();
      AC1VG3->show ();
      AC1VG4->hide ();
      ac1v9->show ();
      ac1v10->show ();
      ac1v11->show ();
      ac1v12->show ();
      ac1v13->hide ();
      ac1v14->hide ();
      ac1v15->hide ();
      ac1v16->hide ();
      AC1LG3->show ();
      AC1LG4->hide ();
      ac1l9->show ();
      ac1l10->show ();
      ac1l11->show ();
      ac1l12->show ();
      ac1l13->hide ();
      ac1l14->hide ();
      ac1l15->hide ();
      ac1l16->hide ();
      AC2G3->show ();
      AC2G4->hide ();
      ac2n9->show ();
      ac2n10->show ();
      ac2n11->show ();
      ac2n12->show ();
      ac2n13->hide ();
      ac2n14->hide ();
      ac2n15->hide ();
      ac2n16->hide ();
      AC2VG3->show ();
      AC2VG4->hide ();
      ac2v9->show ();
      ac2v10->show ();
      ac2v11->show ();
      ac2v12->show ();
      ac2v13->hide ();
      ac2v14->hide ();
      ac2v15->hide ();
      ac2v16->hide ();
      AC2LG3->show ();
      AC2LG4->hide ();
      ac2l9->show ();
      ac2l10->show ();
      ac2l11->show ();
      ac2l12->show ();
      ac2l13->hide ();
      ac2l14->hide ();
      ac2l15->hide ();
      ac2l16->hide ();
      AC3G3->show ();
      AC3G4->hide ();
      ac3n9->show ();
      ac3n10->show ();
      ac3n11->show ();
      ac3n12->show ();
      ac3n13->hide ();
      ac3n14->hide ();
      ac3n15->hide ();
      ac3n16->hide ();
      AC3VG3->show ();
      AC3VG4->hide ();
      ac3v9->show ();
      ac3v10->show ();
      ac3v11->show ();
      ac3v12->show ();
      ac3v13->hide ();
      ac3v14->hide ();
      ac3v15->hide ();
      ac3v16->hide ();
      AC3LG3->show ();
      AC3LG4->hide ();
      ac3l9->show ();
      ac3l10->show ();
      ac3l11->show ();
      ac3l12->show ();
      ac3l13->hide ();
      ac3l14->hide ();
      ac3l15->hide ();
      ac3l16->hide ();
      break;
    case 4:

      B1G3->show ();
      B1G4->show ();
      bn9->show ();
      bn10->show ();
      bn11->show ();
      bn12->show ();
      bn13->show ();
      bn14->show ();
      bn15->show ();
      bn16->show ();
      BV1G3->show ();
      BV1G4->show ();
      bv9->show ();
      bv10->show ();
      bv11->show ();
      bv12->show ();
      bv13->show ();
      bv14->show ();
      bv15->show ();
      bv16->show ();
      BL1G3->show ();
      BL1G4->show ();
      bl9->show ();
      bl10->show ();
      bl11->show ();
      bl12->show ();
      bl13->show ();
      bl14->show ();
      bl15->show ();
      bl16->show ();
      AC1VG3->show ();
      AC1VG4->show ();
      ac1v9->show ();
      ac1v10->show ();
      ac1v11->show ();
      ac1v12->show ();
      ac1v13->show ();
      ac1v14->show ();
      ac1v15->show ();
      ac1v16->show ();
      AC1LG3->show ();
      AC1LG4->show ();
      ac1l9->show ();
      ac1l10->show ();
      ac1l11->show ();
      ac1l12->show ();
      ac1l13->show ();
      ac1l14->show ();
      ac1l15->show ();
      ac1l16->show ();
      AC2G3->show ();
      AC2G4->show ();
      ac2n9->show ();
      ac2n10->show ();
      ac2n11->show ();
      ac2n12->show ();
      ac2n13->show ();
      ac2n14->show ();
      ac2n15->show ();
      ac2n16->show ();
      AC2VG3->show ();
      AC2VG4->show ();
      ac2v9->show ();
      ac2v10->show ();
      ac2v11->show ();
      ac2v12->show ();
      ac2v13->show ();
      ac2v14->show ();
      ac2v15->show ();
      ac2v16->show ();
      AC2LG3->show ();
      AC2LG4->show ();
      ac2l9->show ();
      ac2l10->show ();
      ac2l11->show ();
      ac2l12->show ();
      ac2l13->show ();
      ac2l14->show ();
      ac2l15->show ();
      ac2l16->show ();
      AC3G3->show ();
      AC3G4->show ();
      ac3n9->show ();
      ac3n10->show ();
      ac3n11->show ();
      ac3n12->show ();
      ac3n13->show ();
      ac3n14->show ();
      ac3n15->show ();
      ac3n16->show ();
      AC3VG3->show ();
      AC3VG4->show ();
      ac3v9->show ();
      ac3v10->show ();
      ac3v11->show ();
      ac3v12->show ();
      ac3v13->show ();
      ac3v14->show ();
      ac3v15->show ();
      ac3v16->show ();
      AC3LG3->show ();
      AC3LG4->show ();
      ac3l9->show ();
      ac3l10->show ();
      ac3l11->show ();
      ac3l12->show ();
      ac3l13->show ();
      ac3l14->show ();
      ac3l15->show ();
      ac3l16->show ();
      break;
    }
}

void
GMORGAN::EditPattern (int i)
{
//  int hay = 0;
  gmo->sp = i;
  RtName->value (gmo->Rt[i].Nom);
  RtBars->value (gmo->Rt[i].bars);
  RtNom->value (gmo->Rt[i].blackn);
  RtSwing->value (gmo->Rt[i].swing);



  if (gmo->DosCuatro == 2)
    Sacc2->setonly ();
  if (gmo->DosCuatro == 4)
    Sacc4->setonly ();
  if (gmo->TresCinco == 3)
    Sacc3->setonly ();
  if (gmo->TresCinco == 5)
    Sacc5->setonly ();


  int k;
  char temp[512];
  bzero (temp, sizeof (temp));
//rlv.........out of range. Does what ?
//  for (k = 27; k < 85; k++)
//    if (strcmp (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[k].Nom, "") != 0)
//      hay = 1;
  gmo->cdn = gmo->sd + 26;
  QuitaPon ();
  gmo->sbar = 1;
  metepattern ();
//  cout << "opening pattern edit: i = " << i << endl;
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s - Pattern Editor", gmo->sp, gmo->Rt[i].Nom);
  PatternEditWin->label (temp);
  PatternEditWin->resize (1, 1, 900, 900);
  PatternEditWin->show ();
  Fl::focus (CloRit);
}

void
GMORGAN::LeePatterns ()
{
  int i;
  char temp[512];
  PtBro->clear ();
  for (i = 1; i < 500; i++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", i, gmo->Rt[i].Nom);
      PtBro->add (temp);
    }
  PtBro->select (gmo->sp);
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
}

void
GMORGAN::metemixerpat ()
{
  gmo->PonDrumTemp (gmo->sp);

  Pof5->value (gmo->OnOff[5]);
  Pof6->value (gmo->OnOff[6]);
  Pof7->value (gmo->OnOff[7]);
  Pof8->value (gmo->OnOff[8]);
  Pof9->value (gmo->OnOff[9]);
  Pof10->value (gmo->OnOff[10]);
  Pof11->value (gmo->OnOff[11]);

  FVol5->value (gmo->volume[5]);
  FVol6->value (gmo->volume[6]);
  FVol7->value (gmo->volume[7]);
  FVol8->value (gmo->volume[8]);
  FVol9->value (gmo->volume[9]);
  FVol10->value (gmo->volume[10]);
  FVol11->value (gmo->volume[11]);

  FProg5->value (gmo->progch[5]);
  FProg6->value (gmo->progch[6]);
  FProg7->value (gmo->progch[7]);
  FProg8->value (gmo->progch[8]);
  FProg9->value (gmo->progch[9]);
  FProg10->value (gmo->progch[10]);
  FProg11->value (gmo->progch[11]);

  FPan5->value (gmo->pan[5]);
  FPan6->value (gmo->pan[6]);
  FPan7->value (gmo->pan[7]);
  FPan8->value (gmo->pan[8]);
  FPan9->value (gmo->pan[9]);
  FPan10->value (gmo->pan[10]);
  FPan11->value (gmo->pan[11]);

  FRev5->value (gmo->reverb[5]);
  FRev6->value (gmo->reverb[6]);
  FRev7->value (gmo->reverb[7]);
  FRev8->value (gmo->reverb[8]);
  FRev9->value (gmo->reverb[9]);
  FRev10->value (gmo->reverb[10]);
  FRev11->value (gmo->reverb[11]);

  FCho5->value (gmo->chorus[5]);
  FCho6->value (gmo->chorus[6]);
  FCho7->value (gmo->chorus[7]);
  FCho8->value (gmo->chorus[8]);
  FCho9->value (gmo->chorus[9]);
  FCho10->value (gmo->chorus[10]);
  FCho11->value (gmo->chorus[11]);

  P5->label (gmo->PresetList[gmo->CalculaBanco (5)].PBanco[gmo->progch[5]].
	     ProgName);
  P6->label (gmo->PresetList[gmo->CalculaBanco (6)].PBanco[gmo->progch[6]].
	     ProgName);
  P7->label (gmo->PresetList[gmo->CalculaBanco (7)].PBanco[gmo->progch[7]].
	     ProgName);
  P8->label (gmo->PresetList[gmo->CalculaBanco (8)].PBanco[gmo->progch[8]].
	     ProgName);
  P9->label (gmo->PresetList[gmo->CalculaBanco (9)].PBanco[gmo->progch[9]].
	     ProgName);
  P10->label (gmo->PresetList[gmo->CalculaBanco (10)].PBanco[gmo->progch[10]].
	      ProgName);
  P11->label (gmo->PresetList[gmo->CalculaBanco (11)].PBanco[gmo->progch[11]].
	      ProgName);

  gmo->PonControles (gmo->sp);
  PtBro->select (gmo->sp);
}

void
GMORGAN::preparast ()
{
  int i;
  vumvum = 0;
  gmo->mezcla = 0;
  gmo->sposi = 0;
  gmo->semi = 1;
  gmo->elbar = 1;
  if (gmo->bplay == 0)
    {
      gmo->ncompas = 0;
      sprintf (gmo->elbart, "%d", gmo->ncompas + 1);
    }
  gmo->tick = 0;
  gmo->atick = 0;
  gmo->nfundi = 0;
  gmo->ya = 0;
  gmo->anticipa = 0;
  count = 1;
  gmo->negra = 0;
  ulcount = 0;
  N1->value (0);
  N2->value (0);
  N3->value (0);
  N4->value (0);
  if (gmo->BPW)
    {
      BPN1->value (0);
      BPN2->value (0);
      BPN3->value (0);
      BPN4->value (0);
    }
  DispBlack->label (gmo->elbart);
  if (gmo->stst == 0)
    {
      N1->deactivate ();
      N2->deactivate ();
      N3->deactivate ();
      N4->deactivate ();
      if (gmo->BPW)
	{
	  BPN1->deactivate ();
	  BPN2->deactivate ();
	  BPN3->deactivate ();
	  BPN4->deactivate ();
	}
    }
  else
    {
      N1->activate ();
      N2->activate ();
      N3->activate ();
      N4->activate ();
      if (gmo->BPW)
	{
	  BPN1->activate ();
	  BPN2->activate ();
	  BPN3->activate ();
	  BPN4->activate ();
	}
    }
  if ((gmo->bplay == 0) && (gmo->GUIPlay == 1))
    {
      gmo->sp = (int) PtBro->value ();
      for (i = 1; i < 200; i++)
	{
	  if (gmo->GP[i].bar == 1)
	    {
	      gmo->sp = (int) gmo->GP[1].pattern;
	      break;
	    }
	}
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
    }

  if (gmo->bplay)
    {
      if (LaBarra->value () != 1)
	gmo->nb = (int) LaBarra->value ();
      else
	gmo->nb = 1;
      gmo->ncompas = gmo->nb - 1;
      gmo->sp = S[gmo->nb].pattern;
      gmo->MeteMixerMidi (gmo->sp);
      metemixerpat ();
      gmo->lfundi = 0;
      gmo->fundi = 0;
      if (InvMode == 1)
	gmo->inversion = 1;
      else
	gmo->inversion = 3;
      sprintf (gmo->elnb, "%d", gmo->nb);
      sprintf (gmo->elbart, "%d", gmo->nb);
      Dispnb->label (gmo->elnb);
      gmo->GeneraChord ();
      gmo->BuscaRepes ();
    }
}

void
GMORGAN::MoreParms (int i)
{
  ExtraPWin->hide ();
  gmo->selmix = i;

  EO->value (gmo->octa[gmo->selmix]);
  EBM->value (gmo->BankMSB[gmo->selmix]);
  EBL->value (gmo->BankLSB[gmo->selmix]);
  EPtime->value (gmo->Ptime[gmo->selmix]);
  EPon->value (gmo->Pon[gmo->selmix]);


  switch (gmo->selmix)
    {
    case 1:
      Cajita->label ("LK 1");
      break;
    case 2:
      Cajita->label ("LK 2");
      break;
    case 3:
      Cajita->label ("RK 1");
      break;
    case 4:
      Cajita->label ("RK 2");
      break;
    case 5:
      Cajita->label ("Acc1");
      break;
    case 6:
      Cajita->label ("Acc2");
      break;
    case 7:
      Cajita->label ("Bass");
      break;
    case 8:
      Cajita->label ("Drums");
      break;
    case 9:
      Cajita->label ("Acc3");
      break;
    case 10:
      Cajita->label ("Acc4");
      break;
    case 11:
      Cajita->label ("Acc5");
      break;

    }
  int x, y;
  Fl::get_mouse (x, y);
  ExtraPWin->position (x, y);

  ExtraPWin->show ();
}

void
GMORGAN::prepcopy ()
{
  int i;
  char temp[512];
  CPtBro->clear ();
  for (i = 1; i < 500; i++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", i, gmo->Rt[i].Nom);
      CPtBro->add (temp);
    }
  CPtBro->select (1);
}

void
GMORGAN::PutCombi (int i)
{
  int k;
  gmo->ss = i;
  ProSlider->value (gmo->ss);
  bzero (gmo->Name, sizeof (gmo->Name));
  for (k = 0; k <= (int) strlen (gmo->Prog[i].Nom); k++)
    gmo->Name[k] = gmo->Prog[i].Nom[k];
// rlv
//  Nombre->value (gmo->Name);
    Nombre->value (strdup (gmo->Name));
  cout << " Changing Program to: " << i << " " << gmo->Name << endl;
//  cout << " PutCombi 2 i=" << i << " name " << gmo->Name << " Nombre: " << Nombre << endl;
  if (gmo->grabacion == 0)
    gmo->panico (0, 3);

  sprintf (gmo->temporal, "%03d", i);
  DispNumber->label (gmo->temporal);
// rlv relocated from below.
  gmo->MeteMixerMidiProg (gmo->ss);

  Pof1->value (gmo->OnOff[1]);
  Pof2->value (gmo->OnOff[2]);
  Pof3->value (gmo->OnOff[3]);
  Pof4->value (gmo->OnOff[4]);

  v1LowMidi->value (gmo->lonote[1]);
  v2LowMidi->value (gmo->lonote[2]);
  v3LowMidi->value (gmo->lonote[3]);
  v4LowMidi->value (gmo->lonote[4]);

  v1HighMidi->value (gmo->hinote[1]);
  v2HighMidi->value (gmo->hinote[2]);
  v3HighMidi->value (gmo->hinote[3]);
  v4HighMidi->value (gmo->hinote[4]);

  v1LowVelocity->value (gmo->lowvel[1]); 
  v2LowVelocity->value (gmo->lowvel[2]); 
  v3LowVelocity->value (gmo->lowvel[3]); 
  v4LowVelocity->value (gmo->lowvel[4]); 

  v1HighVel->value (gmo->hivel[1]); 
  v2HighVel->value (gmo->hivel[2]); 
  v3HighVel->value (gmo->hivel[3]); 
  v4HighVel->value (gmo->hivel[4]); 

  FVol1->value (gmo->volume[1]);
  FVol2->value (gmo->volume[2]);
  FVol3->value (gmo->volume[3]);
  FVol4->value (gmo->volume[4]);
  FProg1->value (gmo->progch[1]);
  FProg2->value (gmo->progch[2]);
  FProg3->value (gmo->progch[3]);
  FProg4->value (gmo->progch[4]);
  FPan1->value (gmo->pan[1]);
  FPan2->value (gmo->pan[2]);
  FPan3->value (gmo->pan[3]);
  FPan4->value (gmo->pan[4]);
  FRev1->value (gmo->reverb[1]);
  FRev2->value (gmo->reverb[2]);
  FRev3->value (gmo->reverb[3]);
  FRev4->value (gmo->reverb[4]);
  FCho1->value (gmo->chorus[1]);
  FCho2->value (gmo->chorus[2]);
  FCho3->value (gmo->chorus[3]);
  FCho4->value (gmo->chorus[4]);
  P1->label (gmo->PresetList[gmo->CalculaBanco (1)].PBanco[gmo->progch[1]].
	     ProgName);
  P2->label (gmo->PresetList[gmo->CalculaBanco (2)].PBanco[gmo->progch[2]].
	     ProgName);
  P3->label (gmo->PresetList[gmo->CalculaBanco (3)].PBanco[gmo->progch[3]].
	     ProgName);
  P4->label (gmo->PresetList[gmo->CalculaBanco (4)].PBanco[gmo->progch[4]].
	     ProgName);
// rlv moved up.
//  gmo->MeteMixerMidiProg (gmo->ss);
}

void
GMORGAN::metebank ()
{
  int i;
  char temp[512];
  BankBro->clear ();
  for (i = 1; i <= 100; i++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", i, gmo->Prog[i].Nom);
      BankBro->add (temp);
    }
  BankBro->select (gmo->ss);
}

void
GMORGAN::GetCombi (int i)
{
  gmo->GetCombiM (i);
  char temp[512];
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s", gmo->ss, gmo->Prog[i].Nom);
  BankBro->text (gmo->ss, temp);
}

void
GMORGAN::EditStyle (int i)
{
  int j;
  char temp[512];

  gmo->st = i;

  EPtBro->clear ();

  for (j = 1; j < 500; j++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", j, gmo->Rt[j].Nom);
      EPtBro->add (temp);
    }
  EPrBro->clear ();

  for (j = 1; j <= 100; j++)
    {

      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", j, gmo->Prog[j].Nom);
      EPrBro->add (temp);
    }

  EPtBro->select (gmo->Styl[gmo->st].Var1);
  EPrBro->select (gmo->Styl[gmo->st].programa);


  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s - Style Editor", gmo->st, gmo->Styl[gmo->st].Nom);
  StyleWin->label (temp);

  NombreSt->value (strdup (gmo->Styl[gmo->st].Nom));

  STI->label (gmo->Rt[gmo->Styl[gmo->st].Intro].Nom);
  STV1->label (gmo->Rt[gmo->Styl[gmo->st].Var1].Nom);
  STV2->label (gmo->Rt[gmo->Styl[gmo->st].Var2].Nom);
  STF1->label (gmo->Rt[gmo->Styl[gmo->st].Fill1].Nom);
  STF2->label (gmo->Rt[gmo->Styl[gmo->st].Fill2].Nom);
  STE->label (gmo->Rt[gmo->Styl[gmo->st].Ending].Nom);
  SPr->label (gmo->Prog[gmo->Styl[gmo->st].programa].Nom);
  gmo->Styl[gmo->st].bpm = gmo->bpm;

  StyleWin->position (1, 1);
  StyleWin->show ();
  Fl::focus (CloSty);
}

void
GMORGAN::LeeStyles ()
{
  int i;
  char temp[512];
  StBro->clear ();
  for (i = 1; i <= 100; i++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", i, gmo->Styl[i].Nom);
      StBro->add (temp);
    }
  StBro->select (gmo->st);
  STY1->label (gmo->Styl[gmo->st].Nom);
}

void
GMORGAN::PutStyle (int i)
{
  int lastblackn;
  int maxposi;
  lastblackn = gmo->Rt[gmo->sp].blackn;
  gmo->st = i;
  STY1->label ("");
  STY1->label (gmo->Styl[gmo->st].Nom);
  gmo->Intro = gmo->Styl[gmo->st].Intro;
  gmo->Var1 = gmo->Styl[gmo->st].Var1;
  gmo->Var2 = gmo->Styl[gmo->st].Var2;
  gmo->Fill1 = gmo->Styl[gmo->st].Fill1;
  gmo->Fill2 = gmo->Styl[gmo->st].Fill2;
  gmo->Ending = gmo->Styl[gmo->st].Ending;
  PutCombi (gmo->Styl[gmo->st].programa);
  PVar1->setonly ();
//  gmo->bpm = gmo->Styl[gmo->st].bpm;
//  gmo->set_tempo ();
  gmo->sp = gmo->Var1;
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
  PtBro->select (gmo->Var1);
  sprintf (gmo->tempoch, "%03d", gmo->bpm / 2);
  DispTempo->label (gmo->tempoch);
  CTEMPO->value (gmo->bpm / 2);
  TempoBPM->value (gmo->bpm);
  maxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;
  if (lastblackn == gmo->Rt[gmo->sp].blackn)
    {
      if (gmo->sposi > maxposi)
	gmo->sposi = gmo->sposi % maxposi;
    }
  else
    {
      gmo->sposi = 0;
      count = 1;
      gmo->negra = 0;
      gmo->semi = 1;
      gmo->ncompas = 0;
    }
}

void
GMORGAN::ApagaNex ()
{
  metemixerpat ();
  NVar1->value (0);
  NVar2->value (0);
  NFill1->value (0);
  NFill2->value (0);
  NEnding->value (0);

  switch (gmo->newp)
    {

    case 1:
      PVar1->setonly ();
      PtBro->select (gmo->Var1);
      break;
    case 2:
      PVar2->setonly ();
      PtBro->select (gmo->Var2);
      break;

    case 3:
      PEnding->setonly ();
      PtBro->select (gmo->Ending);
      gmo->finito = 1;
      break;
    case 4:
      PEnding->setonly ();
      PtBro->select (gmo->Fill1);
      break;
    case 5:
      PEnding->setonly ();
      PtBro->select (gmo->Fill2);
      break;
    }
}

void
GMORGAN::ApagaSt ()
{
  int i;

  StartStop->value (0);
  gmo->clear_queue ();
  snd_seq_stop_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id, NULL);
  snd_seq_free_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id);
  gmo->panico (0, 15);
  gmo->newp = 1;
  ApagaNex ();
  gmo->sp = gmo->Var1;
  PtBro->select (gmo->Var1);
  N1->value (0);
  N2->value (0);
  N3->value (0);
  N4->value (0);
  N1->deactivate ();
  N2->deactivate ();
  N3->deactivate ();
  N4->deactivate ();

  if (gmo->bplay == 1)

    {

      StartStopB->value (0);
      gmo->clear_queue ();
      snd_seq_stop_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id,
			  NULL);
      snd_seq_free_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id);
      gmo->panico (0, 15);
      N1->value (0);
      N2->value (0);
      N3->value (0);
      N4->value (0);
      N1->deactivate ();
      N2->deactivate ();
      N3->deactivate ();
      N4->deactivate ();
      BPN1->value (0);
      BPN2->value (0);
      BPN3->value (0);
      BPN4->value (0);
      BPN1->deactivate ();
      BPN2->deactivate ();
      BPN3->deactivate ();
      BPN4->deactivate ();
      for (i = 0; i < POLY; i++)
	gmo->note_active[i] = 0;
      StartStop->activate ();
      LaBarra->activate ();
      PonACero->activate ();
    }
}

void
GMORGAN::prepsig ()
{
  switch (ttnp)
    {
    case 1:
	cout << " Var1 " << endl;
      NVar1->setonly ();
      gmo->nextp = gmo->Var1;
      gmo->mezcla = 0;
      gmo->newp = 1;
      break;
    case 2:
	cout << " Var1 - Fill1 " << endl;
      NFill1->setonly ();
      gmo->nextp = gmo->Var1;
      gmo->mezcla = gmo->Fill1;
      gmo->newp = 4;
      break;
    case 3:
	cout << " Var2 " << endl;
      NVar2->setonly ();
      gmo->nextp = gmo->Var2;
      gmo->mezcla = 0;
      gmo->newp = 2;
      break;
    case 4:
	cout << " Var2 - Fill2" << endl;
      NFill2->setonly ();
      gmo->nextp = gmo->Var2;
      gmo->mezcla = gmo->Fill2;
      gmo->newp = 5;
      break;
    case 5:
	cout << " Ending " << endl;
      NEnding->setonly ();
      gmo->nextp = gmo->Ending;
      gmo->mezcla = 0;
      gmo->newp = 3;
      break;
    }

  ttnp = 0;
}

// Drum Velocity Mixer.
// rlv
Fl_Double_Window *
GMORGAN::make_velo ()
{
  {
    VeloBox = new Fl_Double_Window (815, 935);
    VeloBox->color (FL_LIGHT2);
    VeloBox->callback ((Fl_Callback *) cb_VeloBox, (void *) (this));
//rlv: Looks like these menubars are not used now.
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (670, 0, 45, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_);
    }				// Fl_Menu_Bar* o
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (0, 0, 515, 25);
      o->color (FL_LIGHT2);
      o->menu (menu_1);
    }				// Fl_Menu_Bar* o
//
    {
      CloVelo = new Fl_Button (615, 290, 90, 40, gettext ("Close"));
      CloVelo->color (FL_LIGHT2);
      CloVelo->labelsize (12);
      CloVelo->callback ((Fl_Callback *) cb_CloVelo);
    }				// Fl_Button* CloVelo
    {
      Aplica = new Fl_Button (615, 200, 90, 40, gettext ("Apply Changes"));
      Aplica->color (FL_LIGHT2);
      Aplica->labelsize (12);
      Aplica->callback ((Fl_Callback *) cb_Aplica);
      Aplica->align (192);
    }				// Fl_Button* Aplica
    {
      ResetV = new Fl_Button (615, 245, 90, 40, gettext ("Reset"));
      ResetV->color (FL_LIGHT2);
      ResetV->labelsize (12);
      ResetV->callback ((Fl_Callback *) cb_ResetV);
    }				// Fl_Button* ResetV
    VeloBox->end ();
  }				// Fl_Double_Window* VeloBox
  int i;
  long j;
  char temp[128];

  Fl_Group *group = new Fl_Group (1, 25, 500, 850);

  Fl_Scroll *scroll = new Fl_Scroll (1, 25, 480, 840);
  scroll->type (6);

  for (j = 1; j < 61; j++)
    {

      Fl_Output *obox = new Fl_Output (25, 30 * j, 185, 36, "");

      obox->box (FL_PLASTIC_DOWN_BOX);
      obox->color (59);

      bzero (temp, sizeof (temp));
// rlv this is out of range.
//      if (strcmp (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[j+26].Nom, "") != 0)
//	{
	  for (i = 0;
	       i <=
	       (int) strlen (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[j+26].Nom) -
	       2; i++)
	    temp[i] = gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[j+26].Nom[i];
//	}
      obox->value (temp);
    }

  for (j = 1; j < 61; j++)
    {
      Fl_Slider *slider = new Fl_Slider (210, 30 * j, 260, 30, "");
      slider->box (FL_PLASTIC_UP_BOX);
      slider->type (5);
      slider->color (0);
      slider->minimum (-50);
      slider->maximum (50);
      slider->step (1);
      slider->user_data ((void *) j);
      slider->value (veloplus[j]);
      slider->callback ((Fl_Callback *) a_ver);
    }

  scroll->end ();
  group->end ();
  scroll->position (0, 0);
  VeloBox->add (group);
  VeloBox->add (scroll);
  VeloBox->end ();
  VeloBox->position (1, 1);
  VeloBox->label ("Drum Velocity Mixer");
  if (gmo->VeloMixer == 0)
    Aplica->hide ();
  else
    Aplica->show ();
  VeloBox->show ();
  MVFile->label (gettext ("&File"));
  MVLoad->label (gettext ("&Load"));
  MVSave->label (gettext ("&Save"));
  MVClose->label (gettext ("&Close"));
  Fl::redraw ();
  return VeloBox;
}

inline void
GMORGAN::a_ver_i (Fl_Slider * o, void *)
{
  int kd = (long) (o->user_data ());
  int kv = (int) o->value ();
  if (kv > 61)
	{
	 cout << " ************* kv > 61 ********** " << endl;
	}
	else
	{
	  veloplus[kd] = kv;
	}
}

void
GMORGAN::a_ver (Fl_Slider * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->a_ver_i (o, v);
}
// *******************************************************
// Batch Play Window ... static part.
// *******************************************************
Fl_Double_Window *
GMORGAN::make_bp ()
{
  BPMFile->label (gettext ("&File"));
  BPNew->label (gettext ("&New"));
  BPMLoad->label (gettext ("&Load"));
  BPSave->label (gettext ("&Save"));
  BPPrint->label (gettext ("&Export to Lillypond"));
  BPExport->label (gettext ("Export MidiFile"));
  BPClose->label (gettext ("&Close"));
  BPMTempo->label (gettext ("&Tempo Track"));
  Fl::redraw ();
  {
    BPEWin =
      new Fl_Double_Window (1200, 1250, gettext ("Batch Play Song Editor"));
    BPEWin->box (FL_THIN_UP_BOX);
    BPEWin->color (FL_LIGHT2);
    BPEWin->callback ((Fl_Callback *) cb_BPEWin, (void *) (this));
    {
      Fl_Box *o = new Fl_Box (0, 25, 1490, 25);
      o->box (FL_THIN_UP_FRAME);
      o->color ((Fl_Color) 41);
    }				// Fl_Box* o
/*
    {
      Fl_Box *o = new Fl_Box (0, 835, 1180, 140);
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
    }				// Fl_Box* o
*/
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (780, 0, 45, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_2);
    }				// Fl_Menu_Bar* o
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (0, 0, 700, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_3);
    }				// Fl_Menu_Bar* o
/*
    {
      BPPtBro = new Fl_Browser (5, 850, 190, 115);
      BPPtBro->labelsize (12);
      BPPtBro->textsize (12);
    }				// Fl_Browser* BPPtBro
*/
    {
      NSong = new Fl_Input (5, 30, 475, 30, gettext ("  "));
      NSong->box (FL_THIN_DOWN_BOX);
      NSong->color (FL_LIGHT1);
      NSong->labeltype (FL_ENGRAVED_LABEL);
      NSong->labelcolor ((Fl_Color) 208);
      NSong->textfont (1);
      NSong->textcolor (83);
      NSong->callback ((Fl_Callback *) cb_NSong);
      NSong->align (68);
    }				// Fl_Input* NSong
/*
    {
      Fl_Box *o = new Fl_Box (5, 30, 45, 20, gettext ("Name: "));
      o->labelsize (12);
    }				// Fl_Box* o
*/
    {
      Fl_Box *o = new Fl_Box (530, 30, 60, 20, gettext ("Tempo: "));
      o->labelsize (12);
    }				// Fl_Box* o
    {
      STempo = new Fl_Value_Input (590, 25, 45, 30);
      STempo->color (FL_FOREGROUND_COLOR);
      STempo->minimum (40);
      STempo->maximum (260);
      STempo->step (1);
      STempo->value (100);
      STempo->textfont (1);
      STempo->textsize (12);
      STempo->textcolor (1);
      STempo->callback ((Fl_Callback *) cb_STempo);
      STempo->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Value_Input* STempo
    {
      Nomi = new Fl_Value_Input (715, 30, 20, 20, gettext ("Nominator:"));
      Nomi->box (FL_THIN_DOWN_BOX);
      Nomi->color (FL_LIGHT1);
      Nomi->labelsize (12);
      Nomi->minimum (2);
      Nomi->maximum (4);
      Nomi->step (1);
      Nomi->value (4);
      Nomi->textsize (12);
      Nomi->callback ((Fl_Callback *) cb_Nomi);
    }				// Fl_Value_Input* Nomi
    {
      StartStopB =
	new Fl_Button (0, 60, 145, 55, gettext ("Start / Stop"));
      StartStopB->type (1);
      StartStopB->box (FL_PLASTIC_UP_BOX);
      StartStopB->shortcut (0x20);
      StartStopB->color ((Fl_Color) 55);
      StartStopB->selection_color ((Fl_Color) 3);
      StartStopB->labeltype (FL_ENGRAVED_LABEL);
      StartStopB->labelcolor ((Fl_Color) 4);
      StartStopB->callback ((Fl_Callback *) cb_StartStopB);
      StartStopB->align (FL_ALIGN_CLIP);
    }				// Fl_Button* StartStopB
    {
      BDispBlack = new Fl_Box (900, 70, 75, 40, gettext ("-"));
      BDispBlack->box (FL_THIN_DOWN_BOX);
      BDispBlack->color (FL_FOREGROUND_COLOR);
      BDispBlack->selection_color (FL_BACKGROUND2_COLOR);
      BDispBlack->labelfont (14);
      BDispBlack->labelsize (20);
      BDispBlack->labelcolor ((Fl_Color) 128);
      BDispBlack->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* BDispBlack
    {
      Fl_Box *o = new Fl_Box (200, 60, 75, 20, gettext ("Sequence Bar"));
      o->labelsize (10);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (750, 70, 60, 20, gettext ("Bar"));
      o->labelsize (10);
    }				// Fl_Box* o
    {
      Dispnb = new Fl_Box (800,70, 75, 40, gettext ("---"));
      Dispnb->box (FL_THIN_DOWN_BOX);
      Dispnb->color (FL_FOREGROUND_COLOR);
      Dispnb->selection_color (FL_BACKGROUND2_COLOR);
      Dispnb->labelfont (14);
      Dispnb->labelsize (27);
      Dispnb->labelcolor ((Fl_Color) 128);
      Dispnb->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* Dispnb
    {
      Fl_Group *o = new Fl_Group (770, 30, 55, 20);
      {
	Inv1 = new Fl_Button (770, 30, 20, 20, gettext ("1"));
	Inv1->type (102);
	Inv1->box (FL_PLASTIC_UP_BOX);
	Inv1->color ((Fl_Color) 55);
	Inv1->selection_color ((Fl_Color) 3);
	Inv1->labeltype (FL_ENGRAVED_LABEL);
	Inv1->callback ((Fl_Callback *) cb_Inv1);
	Inv1->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* Inv1
      {
	Inv2 = new Fl_Button (795, 30, 20, 20, gettext ("2"));
	Inv2->type (102);
	Inv2->box (FL_PLASTIC_UP_BOX);
	Inv2->color ((Fl_Color) 55);
	Inv2->selection_color ((Fl_Color) 3);
	Inv2->labeltype (FL_ENGRAVED_LABEL);
	Inv2->callback ((Fl_Callback *) cb_Inv2);
	Inv2->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
      }				// Fl_Button* Inv2
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Box *o = new Fl_Box (740, 30, 30, 20, gettext ("Inv. "));
      o->labelsize (12);
    }				// Fl_Box* o
/*
    {
      Fl_Box *o = new Fl_Box (205, 850, 290, 90);
      o->box (FL_THIN_DOWN_FRAME);
      o->color ((Fl_Color) 41);
    }				// Fl_Box* o
*/
/*
    {
      Fl_Box *o = new Fl_Box (210, 790, 280, 20, gettext ("C  Cm C\260 C2"));
      o->box (FL_FLAT_BOX);
      o->color ((Fl_Color) 171);
      o->labelsize (12);
    }				// Fl_Box* o
*/
    {
      LaBarra = new Fl_Slider (200, 80, 250, 25);
      LaBarra->type (5);
      LaBarra->color (FL_LIGHT1);
      LaBarra->selection_color (FL_BACKGROUND2_COLOR);
      LaBarra->minimum (1);
      LaBarra->maximum (128);
      LaBarra->step (1);
      LaBarra->value (1);
      LaBarra->slider_size (0.02);
      LaBarra->callback ((Fl_Callback *) cb_LaBarra);
    }				// Fl_Slider* LaBarra
    {
      Fl_Button *o = new Fl_Button (515, 70, 90, 20, gettext ("Copy"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Copy9);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (610, 70, 90, 20, gettext ("Clear"));
      o->box (FL_THIN_UP_FRAME);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Clear6);
    }				// Fl_Button* o
/*
    {
      Fl_Box *o = new Fl_Box (595, 1090, 85, 20);
      o->box (FL_THIN_DOWN_FRAME);
      o->color (FL_FOREGROUND_COLOR);
    }				// Fl_Box* o
*/
    {
      BPN1 = new Fl_Button (800, 30, 19, 16);
      BPN1->type (102);
      BPN1->box (FL_THIN_DOWN_BOX);
      BPN1->down_box (FL_THIN_DOWN_BOX);
      BPN1->color (FL_DARK_RED);
      BPN1->selection_color ((Fl_Color) 1);
      BPN1->when (FL_WHEN_NEVER);
      BPN1->deactivate ();
    }				// Fl_Button* BPN1
    {
      BPN2 = new Fl_Button (820, 30, 19, 14);
      BPN2->type (102);
      BPN2->box (FL_THIN_DOWN_BOX);
      BPN2->down_box (FL_THIN_DOWN_BOX);
      BPN2->color ((Fl_Color) 59);
      BPN2->selection_color (FL_GREEN);
      BPN2->when (FL_WHEN_NEVER);
      BPN2->deactivate ();
    }				// Fl_Button* BPN2
    {
      BPN3 = new Fl_Button (840, 30, 19, 14);
      BPN3->type (102);
      BPN3->box (FL_THIN_DOWN_BOX);
      BPN3->down_box (FL_THIN_DOWN_BOX);
      BPN3->color ((Fl_Color) 59);
      BPN3->selection_color (FL_GREEN);
      BPN3->when (FL_WHEN_NEVER);
      BPN3->deactivate ();
    }				// Fl_Button* BPN3
    {
      BPN4 = new Fl_Button (860, 30, 19, 14);
      BPN4->type (102);
      BPN4->box (FL_THIN_DOWN_BOX);
      BPN4->down_box (FL_THIN_DOWN_BOX);
      BPN4->color ((Fl_Color) 59);
      BPN4->selection_color (FL_GREEN);
      BPN4->when (FL_WHEN_NEVER);
      BPN4->deactivate ();
    }				// Fl_Button* BPN4
    {
      NomElacorde = new Fl_Output (1000, 70, 170, 40);
      NomElacorde->color (FL_FOREGROUND_COLOR);
      NomElacorde->textfont (1);
      NomElacorde->textsize (24);
      NomElacorde->textcolor (222);
      NomElacorde->align (FL_ALIGN_CLIP);
    }				// Fl_Output* NomElacorde
    {
      PonACero = new Fl_Button (150, 80, 35, 25, gettext ("@<|"));
      PonACero->callback ((Fl_Callback *) cb_PonACero);
    }				// Fl_Button* PonACero
    BPEWin->end ();
    BPEWin->resizable (BPEWin);
  }				// Fl_Double_Window* BPEWin
  int i, j, k, n;
  long num = 0;
  char temp[512];

  Fl_Group *group = new Fl_Group (1, 50, 1200, 1200);

  Fl_Scroll *bpscroll = new Fl_Scroll (1, 12, 1200, 1200);
  bpscroll->type (6);

  for (j = 1; j <= 32; j++)
    {
      n = (j - 1) * 95;

      for (i = 1; i <= 4; i++)
	{
	  k = (i - 1) * 305;
	  num++;
	  bzero (gmo->llg[num].lbE, sizeof (gmo->llg[num].lbE));
	  sprintf (gmo->llg[num].lbE, "%d", num);

	  {
	    Fl_Box *o = new Fl_Box (10 + k, n, 300, 95);
	    o->box (FL_THIN_UP_BOX);
//	    o->color (52);
	    o->color (FL_BLACK);
	    o->labelsize (16);
	    o->labelfont (FL_BOLD);
	    o->labelcolor (1);
	    o->selection_color (1);
	    o->align (FL_ALIGN_TOP_RIGHT | FL_ALIGN_INSIDE);
	    o->label (gmo->llg[num].lbE);
	    BarBox[num] = o;
	  }

	  {
	    Fl_Input *o = new Fl_Input (15 + k, 50 + n, 70, 30);
	    o->box (FL_PLASTIC_DOWN_BOX);
	    o->color (215);
	    o->selection_color (2);
	    o->textsize (14);
	    o->textfont (FL_BOLD);
	    o->user_data ((void *) num);
	    o->value (S[num].ch1);
	    o->callback ((Fl_Callback *) song_call);
	  }


	  {
	    Fl_Input *o = new Fl_Input (87 + k, 50 + n, 70, 30);
	    o->box (FL_PLASTIC_DOWN_BOX);
	    o->color (215);
	    o->selection_color (2);
	    o->textsize (14);
	    o->textfont (FL_BOLD);
	    o->user_data ((void *) (128 + num));
	    o->value (S[num].ch2);
	    o->callback ((Fl_Callback *) song_call);
	  }
	  if (SNomi > 2)
	    {
	      {
		Fl_Input *o = new Fl_Input (160 + k, 50 + n, 70, 30);
		o->box (FL_PLASTIC_DOWN_BOX);
		o->color (215);
		o->selection_color (2);
		o->textsize (14);
	        o->textfont (FL_BOLD);
		o->user_data ((void *) (1152 + num));
		o->value (S[num].ch3);
		o->callback ((Fl_Callback *) song_call);
	      }
	    }
	  if (SNomi > 3)

	    {
	      Fl_Input *o = new Fl_Input (231 + k, 50 + n, 70, 30);
	      o->box (FL_PLASTIC_DOWN_BOX);
	      o->color (215);
	      o->selection_color (2);
	      o->textsize (14);
	      o->textfont (FL_BOLD);
	      o->user_data ((void *) (1280 + num));
	      o->value (S[num].ch4);
	      o->callback ((Fl_Callback *) song_call);
	    }
	  {
	    Fl_Button *o = new Fl_Button (15 + k, 5 + n, 15, 20, "A");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (3);
	    o->labelsize (11);
	    o->user_data ((void *) (256 + num));
	    o->value (S[num].a);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (30 + k, 5 + n, 15, 20, "B");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (2);
	    o->labelsize (11);
	    o->user_data ((void *) (384 + num));
	    o->value (S[num].b);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (45 + k, 5 + n, 15, 20, "C");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (1);
	    o->labelsize (11);
	    o->user_data ((void *) (512 + num));
	    o->value (S[num].c);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (60 + k, 5 + n, 15, 20, "D");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (4);
	    o->labelsize (11);
	    o->user_data ((void *) (640 + num));
	    o->value (S[num].d);
	    o->callback ((Fl_Callback *) song_call2);
	  }


	  {
	    Fl_Button *o = new Fl_Button (75 + k, 5 + n, 15, 20, "E");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (3);
	    o->labelsize (11);
	    o->user_data ((void *) (1152 + num));
	    o->value (S[num].e);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (90 + k, 5 + n, 15, 20, "F");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (2);
	    o->labelsize (11);
	    o->user_data ((void *) (1280 + num));
	    o->value (S[num].f);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (105 + k, 5 + n, 15, 20, "G");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (1);
	    o->labelsize (11);
	    o->user_data ((void *) (1408 + num));
	    o->value (S[num].g);
	    o->callback ((Fl_Callback *) song_call2);
	  }
	  {
	    Fl_Button *o = new Fl_Button (120 + k, 5 + n, 15, 20, "H");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (1);
	    o->labelsize (11);
	    o->user_data ((void *) (1536 + num));
	    o->value (S[num].h);
	    o->callback ((Fl_Callback *) song_call2);
	  }
	    Fl_Toggle_Button *o = new Fl_Toggle_Button (10 + k, 80+ n, 290, 10);
	      o->box (FL_THIN_DOWN_BOX);
	      o->down_box (FL_THIN_DOWN_BOX);
	      o->color (FL_BLACK);
	      o->selection_color ((Fl_Color) 1);
	    o->labelsize (14);
	    Hbutton[num]=o;	
	   {
	    Fl_Input *o = new Fl_Input (31 + k, 31 + n, 20, 20, "To");
	    o->labelsize (10);
	    o->align (FL_ALIGN_LEFT);
	    o->color (222);
	    o->user_data ((void *) (768 + num));
	    o->value (S[num].go_to);
	    o->callback ((Fl_Callback *) song_call);
	  }

	  {
	    Fl_Value_Input *o = new Fl_Value_Input (53 + k, 31 + n, 20, 20);
	    o->color (222);
	    o->maximum (8);
	    o->step (1);
	    o->user_data ((void *) (896 + num));
	    o->value (S[num].times);
	    o->callback ((Fl_Callback *) song_call1);
	  }

	  {
	    Fl_Input *o = new Fl_Input (96 + k, 31 + n, 20, 20, "To");
	    o->labelsize (10);
	    o->align (FL_ALIGN_LEFT);
	    o->color (222);
	    o->user_data ((void *) (1664 + num));
	    o->value (S[num].go_af);
	    o->callback ((Fl_Callback *) song_call);
	  }

	  {
	    Fl_Value_Input *o = new Fl_Value_Input (118 + k, 31 + n, 20, 20);
	    o->color (222);
	    o->maximum (8);
	    o->step (1);
	    o->user_data ((void *) (1792 + num));
	    o->value (S[num].atimes);
	    o->callback ((Fl_Callback *) song_call1);
	  }

	  {
	    Fl_Button *o = new Fl_Button (148 + k, 31 + n, 20, 20, "X");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (3);
	    o->labelsize (11);
	    o->user_data ((void *) (1920 + num));
	    o->value (S[num].fin);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (170 + k, 31 + n, 15, 20, "8");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (3);
	    o->labelsize (9);
	    o->user_data ((void *) (2048 + num));
	    o->value (S[num].ar8);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Button *o = new Fl_Button (185 + k, 31 + n, 15, 20, "16");
	    o->type (1);
	    o->box (FL_PLASTIC_UP_BOX);
	    o->selection_color (3);
	    o->labelsize (9);
	    o->user_data ((void *) (2176 + num));
	    o->value (S[num].ar16);
	    o->callback ((Fl_Callback *) song_call2);
	  }

	  {
	    Fl_Value_Input *o =
	      new Fl_Value_Input (167 + k, 5 + n, 35, 20, " Patt.");
	    o->labelsize (10);
	    o->align (FL_ALIGN_LEFT);
	    o->color (222);
	    o->maximum (499);
	    o->step (1);
	    o->user_data ((void *) (1024 + num));
	    o->value (S[num].pattern);
	    o->callback ((Fl_Callback *) song_call1);
	  }

	}
    }

  bpscroll->end ();
  group->end ();
  bpscroll->position (0,120);
  thescroll = bpscroll;
  BPEWin->add (group);
  BPEWin->add (bpscroll);
  BPEWin->end ();
/*
  for (i = 1; i < 500; i++)
    {

      bzero (temp, sizeof (temp));
      sprintf (temp, "%03d - %s", i, gmo->Rt[i].Nom);
      BPPtBro->add (temp);
    }
*/
  NSong->value (strdup (NombreSong));
  STempo->value (TempoSong);
  Nomi->value (SNomi);
  if (InvMode == 1)
    {
      Inv1->setonly ();
      gmo->inversion = 1; }
  else
    {
      Inv2->setonly ();
      gmo->inversion = 3;
    }
  WTT->hide ();
  thescroll->scroll_to(0,0);
  BPEWin->resize (1, 1, 1200, 1200);
  BPEWin->show ();
  return BPEWin;
}

// rlv: if graphics are slow, this might disturb timing.
// Try installing the proprietary graphics drivers first.
// If that does not solve the problem you can
// comment this next routine out, but in that case the cursor
// will not work.
// 
void
GMORGAN::LightIt (int barno)
{
//  BarBox[barno]->labelcolor (barno);
//  Hbutton[barno]->color (FL_BLACK,FL_RED);
//  Hbutton[barno]->selection_color (103);
//  Hbutton[barno]->selection_color (FL_RED);
//  Hbutton[barno]->color (FL_DARK_RED);
//  Hbutton[barno]->selection_color ((Fl_Color) 1);
//  Hbutton[barno]->selection_color (FL_DARK_RED);
//  Hbutton[barno]->when (0);
  Hbutton[barno]->value (1);
  Hbutton[barno]->active ();
  Hbutton[barno]->activate ();
//  Hbutton[barno]->when (FL_WHEN_NEVER);
  if (barno != LastBar)
    {
//  	BarBox[LastBar]->labelcolor (LastBar);
        Hbutton[LastBar]->color (FL_BLACK);
  	Hbutton[LastBar]->value (0);
        Hbutton[LastBar]->when (FL_WHEN_NEVER);
    }
//  Hbutton[barno]->labelcolor (5);
//  if ((barno-1)%4 == 0) ScrollIt(barno*21);  
  LastBar = barno;
}

void
GMORGAN::ScrollIt (int ypos)
{
//	cout << "ScrollIt: " << ypos << " -- " << thescroll->scrollbar.value() << endl;
thescroll->scroll_to(0,ypos);
  thescroll->redraw();
}

void
GMORGAN::Close_BP ()
{
  if (gmo->bplay)
    return;
  gmo->BPW = 0;
  BPEWin->hide ();
  BPEWin->clear ();
  WTT->hide ();
  StartStop->activate ();
  gmo->sp = gmo->Var1;
  PtBro->select (gmo->Var1);
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
}

void
GMORGAN::song_call (Fl_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->song_call_i (o, v);
}

inline void
GMORGAN::song_call_i (Fl_Input * o, void *)
{
  int kd = (long) o->user_data ();

  if (kd <= 128)
	{
	strcpy (S[kd].ch1, (char *) o->value ());
	 std::string checkchord = "";
         checkchord.assign (S[kd].ch1);
         vector < int >midinotes = zing.Chordsym2Midi (checkchord, 4);
         if (midinotes.at (0) == 12)
		fl_message(gettext("Chord on first beat is not in the table, but you could add it. "));
	}
  if ((kd > 128) && (kd <= 256))
	{
        strcpy (S[kd - 128].ch2, (char *) o->value ());
	 std::string checkchord = "";
         checkchord.assign (S[kd - 128].ch2);
         vector < int >midinotes = zing.Chordsym2Midi (checkchord, 4);
         if (midinotes.at (0) == 12)
		fl_message(gettext("Chord on second beat is not in the table, but you could add it. "));
	}
  if ((kd > 768) && (kd <= 896))
    strcpy (S[kd - 768].go_to, (char *) o->value ());
  if ((kd > 1152) && (kd <= 1280))
	{
        strcpy (S[kd - 1152].ch3, (char *) o->value ());
	 std::string checkchord = "";
         checkchord.assign (S[kd - 1152].ch3);
         vector < int >midinotes = zing.Chordsym2Midi (checkchord, 4);
         if (midinotes.at (0) == 12)
		fl_message(gettext("Chord on third beat is not in the table, but you could add it. "));
	}
  if ((kd > 1280) && (kd <= 1408))
	{
        strcpy (S[kd - 1280].ch4, (char *) o->value ());
	 std::string checkchord = "";
         checkchord.assign (S[kd - 1280].ch4);
         vector < int >midinotes = zing.Chordsym2Midi (checkchord, 4);
         if (midinotes.at (0) == 12)
		fl_message(gettext("Chord on fourth beat is not in the table, but you could add it. "));
	}
  if ((kd > 1664) && (kd <= 1792))
    strcpy (S[kd - 1664].go_af, (char *) o->value ());

}

void
GMORGAN::song_call1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->song_call1_i (o, v);
}

inline void
GMORGAN::song_call1_i (Fl_Value_Input * o, void *)
{
  int kd = (long) o->user_data ();
  if ((kd > 896) && (kd <= 1024))
	{
    S[kd - 896].times = (int) o->value ();
	}
  if ((kd > 1024) && (kd <= 1152))
    S[kd - 1024].pattern = (int) o->value ();
  if ((kd > 1792) && (kd <= 1920))
    S[kd - 1792].atimes = (int) o->value ();
}

void
GMORGAN::song_call2 (Fl_Button * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->song_call2_i (o, v);
}

inline void
GMORGAN::song_call2_i (Fl_Button * o, void *)
{
  int i;
  int kd = (long) o->user_data ();
  if ((kd > 256) && (kd <= 384))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].a != 0) && (i != (kd - 256)))
	    {
	      fl_alert (gettext
			("Another 'A' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}

      S[kd - 256].a = (int) o->value ();
    }

  if ((kd > 384) && (kd <= 512))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].b != 0) && (i != (kd - 384)))
	    {
	      fl_alert (gettext
			("Another 'B' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}

      S[kd - 384].b = (int) o->value ();
    }




  if ((kd > 512) && (kd <= 640))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].c != 0) && (i != (kd - 512)))
	    {
	      fl_alert (gettext
			("Another 'C' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}

      S[kd - 512].c = (int) o->value ();
    }


  if ((kd > 640) && (kd <= 768))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].d != 0) && (i != (kd - 640)))
	    {
	      fl_alert (gettext
			("Another 'D' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}
      S[kd - 640].d = (int) o->value ();
    }



  if ((kd > 1152) && (kd <= 1280))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].e != 0) && (i != (kd - 1152)))
	    {
	      fl_alert (gettext
			("Another 'E' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}
      S[kd - 1152].e = (int) o->value ();
    }


  if ((kd > 1280) && (kd <= 1408))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].f != 0) && (i != (kd - 1280)))
	    {
	      fl_alert (gettext
			("Another 'F' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}
      S[kd - 1280].f = (int) o->value ();
    }


  if ((kd > 1408) && (kd <= 1536))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].g != 0) && (i != (kd - 1408)))
	    {
	      fl_alert (gettext
			("Another 'G' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}
      S[kd - 1408].g = (int) o->value ();
    }


  if ((kd > 1536) && (kd <= 1664))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].h != 0) && (i != (kd - 1536)))
	    {
	      fl_alert (gettext
			("Another 'H' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}
      S[kd - 1536].h = (int) o->value ();
    }


  if ((kd > 1920) && (kd <= 2048))
    {
      for (i = 1; i <= 128; i++)
	{
	  if ((S[i].fin != 0) && (i != (kd - 1920)))
	    {
	      fl_alert (gettext
			("Another 'X' point is selected. Please Correct."));
	      o->value (0);
	      return;
	    }
	}
      S[kd - 1920].fin = (int) o->value ();
    }


  if ((kd > 2048) && (kd <= 2176))
    {


      if (S[kd - 2048].ar16)
	{
	  o->value (0);
	  return;
	}
      else
	S[kd - 2048].ar8 = (int) o->value ();
    }


  if ((kd > 2176) && (kd <= 2304))
    {

      if (S[kd - 2176].ar8)
	{
	  o->value (0);
	  return;
	}
      else
	S[kd - 2176].ar16 = (int) o->value ();

    }
}

void
GMORGAN::make_drum_edit ()
{
  int i, j, l, num, totalcasillas, lasuma;
  long ud;
  char temp[512];
  lasuma = 0;
  totalcasillas = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;

  Fl_Group *op = new Fl_Group (20, 25, 800, 790);
    {
      Fl_Group *ot = new Fl_Group (50, 25, 800, 790);
      {
	Scroll2 = new Fl_Scroll (50, 25, 800, 790);
	Scroll2->type (3);
	Scroll2->when (FL_WHEN_CHANGED);
	Scroll2->end ();
//        Fl_Group::add(*ot);
      }				// Fl_Scroll* Scroll2
// rlv: drum labels. 
  for (j = 1; j <= 61; j++)
    {
      ud = 10000 + j;
      Fl_Output *obox = new Fl_Output (10, 25 *(j+1), 194, 25, "");

      obox->box (FL_PLASTIC_DOWN_BOX);
      obox->color (59);

      bzero (temp, sizeof (temp));
// rlv out of range.
      if (strcmp (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[j + 26].Nom, "") != 0)
	{
	  for (i = 0;
	       i <=
	       (int) strlen (gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[j + 26].Nom) -
	       2; i++)
	    temp[i] = gmo->PD[gmo->Rt[gmo->sp].drpc].DNN[j + 26].Nom[i];
	}
//	cout << "obox: " << j << "  temp is " << temp << endl;
      obox->value (temp);
      obox->user_data ((void *) ud);
      obox->callback ((Fl_Callback *) dr_call2);
      Scroll2->add (obox);
	obox->redraw ();
	obox->show ();
    }

  for (i = 0; i < totalcasillas; i++)
    {

      if (i % 4 == 0)
	l = 8;
      else
	l = 0;
      lasuma += l;
    }
// rlv load drum grid.
  for (j = 1; j <= 61; j++)
    {
      lasuma = 0;
      ud = j * 130;
      for (i = 0; i < totalcasillas; i++)
	{
	  ud++;

	  if (i % 4 == 0)
	    l = 8;
	  else
	    l = 0;
	  lasuma += l;

	  {
	    Fl_Value_Input *o =
	      new Fl_Value_Input (205 + (i * 32) + 13 + lasuma, 25*(j+1), 32,
				  25);
	    o->box (FL_PLASTIC_DOWN_BOX);
	    o->maximum (127);
	    o->minimum (0);
	    o->textcolor((Fl_Color) 4); 
	    if (l == 8)
		{o->textcolor((Fl_Color) FL_RED);}	
	    o->step (1);
	    o->user_data ((void *) ud);
// j = row, i = column
//	    cout << "(" << j << "," << i+1 << ")" << (Edr[j][i + 1]) << ":";	
	    o->value (Edr[j][i + 1]);
//       	    Spreadsheet::draw_cell(3, i,j, int X,int Y,int W,int H) {
	    o->callback ((Fl_Callback *) dr_call1);
	    Scroll2->add (o);
		o->redraw ();
		o->show ();
	  }
//	cout << endl;
	}
    }
    ot->end ();
    op->end ();
     }	
//  Scroll3->position (Scroll3->xposition (), Scroll3->yposition());
  Scroll2->position (Scroll2->xposition (), Scroll2->yposition ());
//  DrumEditBox->redraw ();
  DrumEditBox->redraw();
  DrumEditBox->end ();
/*
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s - Pattern Editor", gmo->sp, gmo->Rt[gmo->sp].Nom);
  DrumEditBox->label (temp);
  DrumEditBox->position (1, 1);
  HorBar->value (1, 0, 0, (gmo->Rt[gmo->sp].bars - 1) * 546);
  Scroll3->position (HorBar->value (), Scroll3->yposition ());
  Scroll2->position (HorBar->value (), Scroll2->yposition ());
  Scroll1->position (Scroll1->xposition (), VerBar->value ());
  Scroll2->position (Scroll2->xposition (), VerBar->value ());
//  DrumEditBox->redraw ();
*/
  DrumEditBox->show ();
}

void
GMORGAN::cierraDrEdit ()
{
//  cout << " cierraDrEdit " << endl;
  gmo->dredit = 0;
/*
  HorBar->value (1, 0, 0, (gmo->Rt[gmo->sp].bars - 1) * 546);
  Scroll3->position (HorBar->value (), Scroll3->yposition ());
  Scroll2->position (HorBar->value (), Scroll2->yposition ());
  VerBar->value (1, 0, 0, 1024);
  Scroll1->position (Scroll1->xposition (), VerBar->value ());
*/
  Scroll2->position (Scroll2->xposition (), Scroll2->yposition ());
  DrumEditBox->hide ();
//  DrumEditBox->clear ();
}

void
GMORGAN::dr_call1 (Fl_Value_Input * o, void *v)
{
//  cout << " dr_call1 " << endl;
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->dr_call1_i (o, v);
}

inline void
GMORGAN::dr_call1_i (Fl_Value_Input * o, void *)
{
  int i, j;
//  cout << " dr_call1_i begin " << endl;
  int kd = (long) o->user_data ();
  int kv = (int) o->value ();
  i = kd / 130;
  j = kd % 130;
//  cout << "dr_call1_i kd= " << kd << " kv = " << kv << " i = " << i << " j = " << j << endl; 
  Edr[i][j] = kv;
}

void
GMORGAN::dr_call2 (Fl_Output * o, void *v)
{
//  cout << "rlv dr_call2 " << endl;
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->dr_call2_i (o, v);
}

inline void
GMORGAN::dr_call2_i (Fl_Output * o, void *)
{
//  cout << "rlv dr_call2_i " << endl;
  lastcasdr = sde + 10000;
  int kd = (long) o->user_data ();
  if (kd != lastcasdr)
    cambiacasdr = 1;
  o->cursor_color (FL_WHITE);
  o->color (FL_WHITE);
  o->redraw ();
  tocadrum = 26 + kd - 10000;
  sde = kd - 10000;
}
// rlv 
Fl_Double_Window *
GMORGAN::make_window_drum ()
{
  {
    DrumEditBox = new Fl_Double_Window (900, 950, "Drum Edit Window");
    DrumEditBox->color (FL_LIGHT2);
    DrumEditBox->callback ((Fl_Callback *) cb_DrumEditBox, (void *) (this));
    {
      Fl_Button *o = new Fl_Button (605, 910, 75, 35, gettext ("Ok"));
      o->color (FL_LIGHT2);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Ok3);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (700, 910, 75, 35, gettext ("Cancel"));
      o->color (FL_LIGHT2);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel6);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (155, 910, 90, 35, gettext ("Copy From"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Copya);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (20, 910, 100, 35, gettext ("Copy From"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Copyb);
    }				// Fl_Button* o
    {
      Fl_Button *o =
	new Fl_Button (450, 910, 100, 25, gettext ("Velocity Mixer"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Velocity);
    }				// Fl_Button* o
    {
      Fl_Button *o =
	new Fl_Button (305, 910, 110, 30, gettext ("Clear Instrument"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Clear7);
    }				// Fl_Button* o
    Spreadsheet* table = new Spreadsheet(10, 10, DrumEditBox->w()-80, DrumEditBox->h()-80);
  // Table rows
  table->row_header(1);
  table->row_header_width(120);
  table->row_resize(1);
  table->rows(MAX_ROWS);
  table->row_height_all(25);
  // Table cols
  table->col_header(1);
  table->col_header_height(25);
  table->col_resize(1);
  table->cols(MAX_COLS);

  table->col_width_all(30);
  table->set_selection(0,0,0,0);	// select top/left cell
  DrumEditBox->begin();

  // Add children to window

  // Row slider
  Fl_Value_Slider setrows(DrumEditBox->w()-40,10,10,DrumEditBox->h()-50, 0);
  setrows.type(FL_VERT_NICE_SLIDER);
  setrows.bounds(2,MAX_ROWS);
  setrows.step(1);
  setrows.value(table->rows()-1);
  setrows.callback(setrows_cb, (void*)table);
  setrows.when(FL_WHEN_CHANGED);
  setrows.clear_visible_focus();

  // Column slider
  Fl_Value_Slider setcols(10,DrumEditBox->h()-40,DrumEditBox->w()-80,20, 0);
  setcols.type(FL_HOR_NICE_SLIDER);
  setcols.bounds(2,MAX_COLS);
  setcols.step(1);
  setcols.value(table->cols()-1);
  setcols.callback(setcols_cb, (void*)table);
  setcols.when(FL_WHEN_CHANGED);
  setcols.clear_visible_focus();

  DrumEditBox->end();
  DrumEditBox->resizable(table);
  DrumEditBox->show();

//  return Fl::run();
// olds stuff.
/*
    {
      Fl_Box *o = new Fl_Box (20, 25, 810, 855);
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Group *o = new Fl_Group (20, 30, 800, 790);
*/
// rlv
/*
    {
      Fl_Box *o = new Fl_Box (0, 800, 195, 25, gettext ("Instruments/ Bars"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 4);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (25, 830, 100, 25, gettext ("Instruments"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 5);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (155, 830, 90, 25, gettext ("Bars"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 4);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
*/
/*
    DrumEditBox->redraw();
    DrumEditBox->end ();
*/
  }				// Fl_Double_Window* DrumEditBox
  return DrumEditBox;
}

void
GMORGAN::MetePresets ()
{
  int i, j;
  char temp[512];

  PreBro->clear ();

  for (i = 0; i <= 128; i++)
    {
      for (j = 0; j <= 128; j++)
	{

	  if (strlen (gmo->PresetList[i].PBanco[j].ProgName) >= 2)

	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%03d %03d %s", i, j,
		       gmo->PresetList[i].PBanco[j].ProgName);

	      PreBro->add (temp);
	    }
	}
    }
}

void
GMORGAN::PreparaPre (int PEN)
{
  if (gmo->PFEW == 1)
    return;
  gmo->PFEW = 1;
  make_PFEditwindow ();
  MetePresets ();
  PreBro->select (1);
  PFileEdit->position (1, 1);
  PFileEdit->show ();

  char temp[512];
  int i;
  int Banco, Preset;
  char Nombre[50];
  char RNombre[50];

  bzero (temp, sizeof (temp));
  strcpy (temp, PreBro->text (PEN));

  sscanf (temp, "%d %d %[^]]c", &Banco, &Preset, (char *) Nombre);
  bzero (RNombre, sizeof (RNombre));
  for (i = 0; i <= (int) strlen (Nombre) - 2; i++)
    RNombre[i] = Nombre[i];
//  cout << "PreparaPre " << Nombre << endl;
  PEBank->value (Banco);
  PEPreset->value (Preset);
  PEPreName->value (strdup (RNombre));
}

Fl_Double_Window *
GMORGAN::make_PFEditwindow ()
{
  {
    PFileEdit =
      new Fl_Double_Window (380, 390, gettext ("Preset File Editor"));
    PFileEdit->box (FL_THIN_UP_BOX);
    PFileEdit->color (FL_LIGHT2);
    PFileEdit->callback ((Fl_Callback *) cb_PFileEdit, (void *) (this));
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (335, 0, 45, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_4);
    }				// Fl_Menu_Bar* o
    {
      PreBro = new Fl_Browser (15, 40, 350, 260);
      PreBro->type (2);
      PreBro->labelsize (12);
      PreBro->textsize (12);
      PreBro->callback ((Fl_Callback *) cb_PreBro);
    }				// Fl_Browser* PreBro
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (0, 0, 380, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_5);
    }				// Fl_Menu_Bar* o
    {
      PEBank = new Fl_Value_Input (15, 320, 40, 25, gettext ("Bank"));
      PEBank->labelsize (10);
      PEBank->textsize (12);
      PEBank->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Value_Input* PEBank
    {
      PEPreset = new Fl_Value_Input (60, 320, 40, 25, gettext ("Preset"));
      PEPreset->labelsize (10);
      PEPreset->textsize (12);
      PEPreset->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Value_Input* PEPreset
    {
      PEPreName = new Fl_Input (115, 320, 250, 25, gettext ("Preset Name"));
      PEPreName->labelsize (10);
      PEPreName->textsize (12);
      PEPreName->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Input* PEPreName
    {
      Fl_Button *o =
	new Fl_Button (255, 350, 110, 30, gettext ("Modify/Add"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Modify1);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    PFileEdit->end ();
  }				// Fl_Double_Window* PFileEdit
  PFileFile->label (gettext ("&File"));
  PFileFilesub1->label (gettext ("&Save"));
  PFileFilesub2->label (gettext ("&Close"));
  return PFileEdit;
}

void
GMORGAN::Sel_Last_Pre (int Bank, int Preset)
{
  char temp[512];
  int i;
  int PBanco, PPreset;
  char Nombre[50];

  for (i = 1; i <= (int) PreBro->size (); i++)
    {

      bzero (temp, sizeof (temp));
      strcpy (temp, PreBro->text (i));
      sscanf (temp, "%d %d %[^]]c", &PBanco, &PPreset, (char *) Nombre);

      if ((PBanco == Bank) && (PPreset == Preset))
	{
	  PreBro->select (i);
	  break;
	}
    }
}

void
GMORGAN::save_preset (char *filename)
{
  FILE *fs;
  int i;

  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (i = 1; i <= (int) PreBro->size (); i++)
	{
	  fputs (PreBro->text (i), fs);
	}

      fclose (fs);

    }
}

void
GMORGAN::MeteDrumn ()
{
  int i, j;
  char temp[512];

  DruBro->clear ();

  for (i = 0; i <= 59; i++)
    {
      for (j = 27; j < 88; j++)
	{
// rlv out of range.
	  if (strlen (gmo->PD[i].DNN[j].Nom) >= 2)
	    {
	      bzero (temp, sizeof (temp));
	      sprintf (temp, "%03d %03d %s", i, j, gmo->PD[i].DNN[j].Nom);
	      DruBro->add (temp);
	    }
	}
    }
}

Fl_Double_Window *
GMORGAN::make_windowDNN ()
{
  {
    DFileEdit =
      new Fl_Double_Window (680, 695, gettext ("Drum Note File Editor"));
    DFileEdit->box (FL_THIN_UP_BOX);
    DFileEdit->color (FL_LIGHT2);
    DFileEdit->callback ((Fl_Callback *) cb_DFileEdit, (void *) (this));
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (335, 0, 45, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_6);
    }				// Fl_Menu_Bar* o
    {
      DruBro = new Fl_Browser (15, 40, 645, 575);
      DruBro->type (2);
      DruBro->labelsize (12);
      DruBro->textsize (12);
      DruBro->callback ((Fl_Callback *) cb_DruBro);
    }				// Fl_Browser* DruBro
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (0, 0, 380, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->menu (menu_7);
    }				// Fl_Menu_Bar* o
    {
      DEProgram = new Fl_Value_Input (45, 640, 40, 25, gettext ("Prog."));
      DEProgram->labelsize (10);
      DEProgram->textsize (12);
      DEProgram->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Value_Input* DEProgram
    {
      DENote = new Fl_Value_Input (145, 640, 40, 25, gettext ("Note"));
      DENote->labelsize (10);
      DENote->textsize (12);
      DENote->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Value_Input* DENote
    {
      DEInstName =
	new Fl_Input (230, 640, 250, 25, gettext ("Instrument Name"));
      DEInstName->labelsize (10);
      DEInstName->textsize (12);
      DEInstName->align (FL_ALIGN_TOP_LEFT);
    }				// Fl_Input* DEInstName
    {
      Fl_Button *o =
	new Fl_Button (520, 635, 110, 30, gettext ("Modify/Add"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Modify2);
    }				// Fl_Button* o
    DFileEdit->end ();
  }				// Fl_Double_Window* DFileEdit
  DFileFile->label (gettext ("&File"));
  DFileFilesub1->label (gettext ("&Save"));
  DFileFilesub2->label (gettext ("&Close"));
  Fl::redraw ();
  return DFileEdit;
}

void
GMORGAN::PreparaDru (int PEN)
{
  if (gmo->DNNWE == 1)
    return;
  gmo->DNNWE = 1;
  make_windowDNN ();
  MeteDrumn ();
  DruBro->select (1);
  DFileEdit->position (1, 1);
  DFileEdit->show ();


  char temp[512];
  int i;
  int Programa, Nota;
  char Nombre[50];
  char RNombre[50];

  bzero (temp, sizeof (temp));
  strcpy (temp, DruBro->text (PEN));

  sscanf (temp, "%d %d %[^]]c", &Programa, &Nota, (char *) Nombre);
  bzero (RNombre, sizeof (RNombre));
  for (i = 0; i <= (int) strlen (Nombre) - 2; i++)
    RNombre[i] = Nombre[i];
//  cout << "PreparaDru " << Nombre << endl;

  DEProgram->value (Programa);
  DENote->value (Nota);
  DEInstName->value (strdup (RNombre));
}

void
GMORGAN::Sel_Last_Dru (int Programa, int Nota)
{
  char temp[512];
  int i;
  int DPrograma, DNota;
  char Nombre[50];

  for (i = 1; i <= (int) DruBro->size (); i++)
    {

      bzero (temp, sizeof (temp));
      strcpy (temp, DruBro->text (i));
      sscanf (temp, "%d %d %[^]]c", &DPrograma, &DNota, (char *) Nombre);

      if ((DPrograma == Programa) && (DNota == Nota))
	{
	  DruBro->select (i);
	  break;
	}
    }
}

void
GMORGAN::save_drumn (char *filename)
{
  FILE *fs;
  int i;

  if ((fs = fopen (filename, "w")) != NULL)
    {
      for (i = 1; i <= (int) DruBro->size (); i++)
	{
	  fputs (DruBro->text (i), fs);
	}

      fclose (fs);

    }
}

void
GMORGAN::SkinReadNames (char *filename)
{
  FILE *fs;
  char temp[256];
  char skinname[64];
  int i, k;
  SkinBrowser->clear ();
  if ((fs = fopen (filename, "r")) != NULL)
    {
      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fs) != NULL)
	{
	  if (temp[0] == '{')
	    {

	      bzero (skinname, sizeof (skinname));
	      for (i = 1; i <= (int) strlen (temp) - 3; i++)
		skinname[i - 1] = temp[i];
	      SkinBrowser->add (skinname);
	    }

	}
    fclose (fs);
    }
  k = 1;
  while (SkinBrowser->text (k) != NULL)
    {
      if (strcmp (gmo->SkinNombre, SkinBrowser->text (k)) == 0)
	{
	  SkinBrowser->select (k, 1);
	  break;
	}
      k++;
    }
}

void
GMORGAN::make_skin_changes (char *filename)
{
  FILE *fs;
  char temp[256];
  char skinname[64];
  int i;



  if ((fs = fopen (filename, "r")) != NULL)
    {
      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fs) != NULL)
	{
	  if (temp[0] == '{')
	    {
	      bzero (skinname, sizeof (skinname));
	      for (i = 1; i <= (int) strlen (temp) - 3; i++)
		skinname[i - 1] = temp[i];
	      if (strcmp (skinname, gmo->SkinNombre) == 0)
		{
		  break;
		}
	    }
	  bzero (temp, sizeof (temp));
	}

      bzero (temp, sizeof (temp));
      while (fgets (temp, sizeof temp, fs) != NULL)
	{
	  if (temp[0] == '{')
	    break;
	  procesaskin (temp);
	  bzero (temp, sizeof (temp));
	}
    fclose (fs);
    }
}

void
GMORGAN::makehelp ()
{
  static const int tapsg[] = { 65, 70, 80, 65, 90, 0 };

  HelpBrowser->clear ();
  HelpBrowser->column_widths (tapsg);
  HelpBrowser->
    add ("@b@C7@B4@_-12\t@B3@_2m\t@B2@_Db\t@b@C7@B4@_0\t@B3@_W NoteOff");
  HelpBrowser->
    add ("@b@C7@B4@_-11\t@B3@_2M\t@B2@_D\t@b@C7@B4@_1\t@B3@_Whole");
  HelpBrowser->
    add ("@b@C7@B4@_-10\t@B3@_3m\t@B2@_Eb\t@b@C7@B4@_2\t@B3@_Half");
  HelpBrowser->
    add ("@b@C7@B4@_-9\t@B3@_3M\t@B2@_E\t@b@C7@B4@_3\t@B3@_Dot Quarter");
  HelpBrowser->
    add ("@b@C7@B4@_-8\t@B3@_4J\t@B2@_F\t@b@C7@B4@_4\t@B3@_Quarter");
  HelpBrowser->
    add ("@b@C7@B4@_-7\t@B3@_5dis\t@B2@_Gb\t@b@C7@B4@_6\t@B3@_Dot Eighth");
  HelpBrowser->
    add ("@b@C7@B4@_-6\t@B3@_5J\t@B2@_G\t@b@C7@B4@_8\t@B3@_Eighth");
  HelpBrowser->
    add ("@b@C7@B4@_-5\t@B3@_6m\t@B2@_Ab\t@b@C7@B4@_12\t@B3@_Dot Sixteenth");
  HelpBrowser->
    add ("@b@C7@B4@_-4\t@B3@_6M\t@B2@_A\t@b@C7@B4@_16\t@B3@_Sixteenth");
  HelpBrowser->
    add
    ("@b@C7@B4@_-3\t@B3@_7m\t@B2@_Bb\t@b@C7@B4@_24\t@B3@_Dot Thirty-second");
  HelpBrowser->
    add ("@b@C7@B4@_-2\t@B3@_7M\t@B2@_B\t@b@C7@B4@_32\t@B3@_thirty-second");
  HelpBrowser->add ("@b@C7@B4@_0\t@B3@_No\t@B2@_-\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_1\t@B3@_1M\t@B2@_C\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_2\t@B3@_2m\t@B2@_Db\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_3\t@B3@_2M\t@B2@_D\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_4\t@B3@_3m\t@B2@_Eb\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_5\t@B3@_3M\t@B2@_E\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_6\t@B3@_4J\t@B2@_F\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_7\t@B3@_5dis\t@B2@_Gb\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_8\t@B3@_5J\t@B2@_G\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_9\t@B3@_6m\t@B2@_Ab\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_10\t@B3@_6M\t@B2@_A\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_11\t@B3@_7m\t@B2@_Bb\t@B4@_\t@B3@_");
  HelpBrowser->add ("@b@C7@B4@_12\t@B3@_7M\t@B2@_B\t@B4@_\t@B3@_");
}

void
GMORGAN::BuscaLastPattern ()
{
  int i;

  for (i = gmo->nb; i >= 1; i--)
    {
      if (S[i].pattern != 0)
	{
	  gmo->sp = S[i].pattern;
	  gmo->MeteMixerMidi (gmo->sp);
	  metemixerpat ();
	  break;
	}
    }
}

void
GMORGAN::StopPlay ()
{
  paraplay = 0;
  gmo->reproduccion = 0;
  gmo->cs = 1;
  MPlay->value (0);
  StartStop->activate ();
  MRecord->activate ();
  if (gmo->BPW)
    StartStopB->deactivate ();
  gmo->clear_queue ();
  snd_seq_stop_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id, NULL);
  snd_seq_free_queue (gmo->MidiOutPuerto[1].midi_out, gmo->queue_id);
  gmo->panico (0, 15);
  PutCombi (gmo->ss);
  gmo->MeteMixerMidi (gmo->sp);
  metemixerpat ();
}

void
GMORGAN::ActualizaEntrada ()
{
  int lastblackn;
  int maxposi;
  lastblackn = gmo->Rt[gmo->sp].blackn;
  if (gmo->SoundSelect)
    {
      if (((int) EntradaK->value () > 0) && ((int) EntradaK->value () < 101))
	{
	  PutCombi ((int) EntradaK->value ());
	}
    }
  if (gmo->PatternSelect)
    {
      if (((int) EntradaK->value () > 0) && ((int) EntradaK->value () < 500))
	{
	  gmo->sp = (int) EntradaK->value ();
	  PtBro->select (gmo->sp);
	  gmo->MeteMixerMidi (gmo->sp);
	  metemixerpat ();
	  maxposi = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;
	  if (lastblackn == gmo->Rt[gmo->sp].blackn)
	    {
	      if (gmo->sposi > maxposi)
		gmo->sposi = gmo->sposi % maxposi;
	    }
	  else
	    {
	      gmo->sposi = 0;
	      count = 1;
	      gmo->negra = 0;
	      gmo->semi = 1;
	      gmo->ncompas = 0;
	    }
	  gmo->nextp = gmo->sp;
	  gmo->Ending = gmo->Var1 = gmo->Var2 = gmo->Fill1 = gmo->Fill2 =
	    gmo->Intro = gmo->sp;
	}
    }
  if (gmo->StyleSelect)
    {
      if (((int) EntradaK->value () > 0) && ((int) EntradaK->value () < 101))
	{
	  gmo->st = (int) EntradaK->value ();
	  PutStyle (gmo->st);
	  StBro->select (gmo->st);
	}
    }
}

void
GMORGAN::ActualizaVolumen ()
{
  int i;

  if (gmo->MasterON)
    {
      for (i = 1; i <= 11; i++)
	{

	  gmo->enviocontrol (i, 7, gmo->TMch[i]);

	}
    }
}

void
GMORGAN::Calcula (int i)
{
  int valor;
  valor = (int) EntradaK->value ();


  if (gmo->Hay)
    {
      EntradaK->value ((valor * 10) + i);
    }

  else
    {
      gmo->Hay = 1;
      EntradaK->value (i);
    }
}

void
GMORGAN::make_ctrl_edit ()
{
  int i, j, l, num, totalcasillas, lasuma;
  long ud;
  char temp[128];

  lasuma = 0;
  totalcasillas = gmo->Rt[gmo->sp].bars * gmo->Rt[gmo->sp].blackn * 4;


  CScroll2->type (0);
  CScroll3->type (0);

  CHorBar->maximum ((gmo->Rt[gmo->sp].bars - 1) * 137 *
		    gmo->Rt[gmo->sp].blackn);

  for (i = 0; i <= gmo->Rt[gmo->sp].bars - 1; i++)
    {

      num = i + 1;
      bzero (gmo->llg[num].lbE, sizeof (gmo->llg[num].lbE));
      sprintf (gmo->llg[num].lbE, "%d", num);


      {
	Fl_Box *obox =
	  new Fl_Box (196 + (i * 136 * gmo->Rt[gmo->sp].blackn), 0,
		      136 * gmo->Rt[gmo->sp].blackn, 25, "");

	obox->box (FL_PLASTIC_DOWN_BOX);
	obox->color (119);
	obox->labelsize (18);
	obox->labeltype (FL_ENGRAVED_LABEL);
	obox->labelcolor (128);
	obox->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
	obox->label (gmo->llg[num].lbE);
	CScroll3->add (obox);
      }
    }




  for (j = 1; j <= 31; j++)
    {
      ud = 10000 + j;
      Fl_Output *obox = new Fl_Output (1, 25 * j, 194, 25, "");
      obox->box (FL_PLASTIC_DOWN_BOX);
      obox->color (59);

      bzero (temp, sizeof (temp));
      switch (j)
	{
	case 1:
	  sprintf (temp, "Pan");
	  break;
	case 2:
	  sprintf (temp, "Volume");
	  break;
	case 3:
	  sprintf (temp, "Reverb");
	  break;
	case 4:
	  sprintf (temp, "Chorus");
	  break;
	case 5:
	  sprintf (temp, "Detune");
	  break;
	case 6:
	  sprintf (temp, "Portamento");
	  break;
	case 7:
	  sprintf (temp, "Resonance");
	  break;
	case 8:
	  sprintf (temp, "LFO1 Delay");
	  break;
	case 9:
	  sprintf (temp, "LFO1 Frequency");
	  break;
	case 10:
	  sprintf (temp, "LFO2 Delay");
	  break;
	case 11:
	  sprintf (temp, "LFO2 Frequency");
	  break;
	case 12:
	  sprintf (temp, "ENV1 Delay Time");
	  break;
	case 13:
	  sprintf (temp, "ENV1 Attack Time");
	  break;
	case 14:
	  sprintf (temp, "ENV1 Hold Time");
	  break;
	case 15:
	  sprintf (temp, "ENV1 Decay Time");
	  break;
	case 16:
	  sprintf (temp, "ENV1 Sustain Level");
	  break;
	case 17:
	  sprintf (temp, "ENV1 Release Time");
	  break;
	case 18:
	  sprintf (temp, "ENV2 Delay Time");
	  break;
	case 19:
	  sprintf (temp, "ENV2 Attack Time");
	  break;
	case 20:
	  sprintf (temp, "ENV2 Hold Time");
	  break;
	case 21:
	  sprintf (temp, "ENV2 Decay Time");
	  break;
	case 22:
	  sprintf (temp, "ENV2 Sustain Level");
	  break;
	case 23:
	  sprintf (temp, "ENV2 Release Time");
	  break;
	case 24:
	  sprintf (temp, "LFO1 to Pitch");
	  break;
	case 25:
	  sprintf (temp, "LFO2 to Pitch");
	  break;
	case 26:
	  sprintf (temp, "ENV1 to Pitch");
	  break;
	case 27:
	  sprintf (temp, "LFO1 to Volume");
	  break;
	case 28:
	  sprintf (temp, "Filter Cutoff");
	  break;
	case 29:
	  sprintf (temp, "LFO1 to Filter Cutoff");
	  break;
	case 30:
	  sprintf (temp, "ENV1 to Filter Cutoff");
	  break;
	case 31:
	  sprintf (temp, "Modulation");
	  break;

	}
      obox->user_data ((void *) ud);
      obox->callback ((Fl_Callback *) ctrl_call2);
      obox->value (temp);
      CScroll1->add (obox);
    }


  for (i = 0; i < totalcasillas; i++)
    {

      if (i % 4 == 0)
	l = 8;
      else
	l = 0;
      lasuma += l;
    }


  {
    Fl_Output *obox =
      new Fl_Output (195, 25, (32 * totalcasillas) + lasuma + 4, 61 * 25, "");
    obox->box (FL_PLASTIC_DOWN_BOX);
    obox->color (24);
    CScroll2->add (obox);
  }


  for (j = 1; j <= 31; j++)
    {
      lasuma = 0;
      ud = j * 130;
      for (i = 0; i < totalcasillas; i++)
	{
	  ud++;

	  if (i % 4 == 0)
	    l = 8;
	  else
	    l = 0;
	  lasuma += l;

	  {
	    Fl_Value_Input *o =
	      new Fl_Value_Input (195 + (i * 32) + 4 + lasuma, 25 * j, 32,
				  25);
	    o->box (FL_PLASTIC_DOWN_BOX);
	    o->maximum (999);
	    o->minimum (0);
	    o->step (1);
	    o->user_data ((void *) ud);
	    o->value (Ectrl[canaledit][j][i + 1]);
	    o->callback ((Fl_Callback *) ctrl_call1);
	    CScroll2->add (o);
	  }

	}

    }


  CtrlEditBox->end ();
  bzero (temp, sizeof (temp));
  sprintf (temp, "%03d - %s - Controller Editor", gmo->sp,
	   gmo->Rt[gmo->sp].Nom);
  CtrlEditBox->label (temp);
  CtrlEditBox->position (1, 1);
  CHorBar->value (1, 0, 0, (gmo->Rt[gmo->sp].bars - 1) * 546);
  CScroll3->position (CHorBar->value (), CScroll3->yposition ());
  CScroll2->position (CHorBar->value (), CScroll2->yposition ());
  CVerBar->value (1, 0, 0, 1024);
  CScroll1->position (CScroll1->xposition (), CVerBar->value ());
  CScroll2->position (CScroll2->xposition (), CVerBar->value ());
  switch (canaledit)
    {
    case 1:
      CtrlAcc1->setonly ();
      break;
    case 2:
      CtrlAcc2->setonly ();
      break;
    case 3:
      CtrlAcc3->setonly ();
      break;
    case 4:
      CtrlAcc4->setonly ();
      break;
    case 5:
      CtrlAcc4->setonly ();
      break;
    case 6:
      CtrlBass->setonly ();
      break;
    case 7:
      CtrlDrums->setonly ();
      break;
    }

  CtrlEditBox->show ();
}

Fl_Double_Window *
GMORGAN::make_ctrl_window ()
{
  {
    CtrlEditBox = new Fl_Double_Window (765, 600);
    CtrlEditBox->color (FL_LIGHT2);
    CtrlEditBox->callback ((Fl_Callback *) cb_CtrlEditBox, (void *) (this));
    {
      Fl_Box *o = new Fl_Box (-5, 545, 770, 55);
      o->box (FL_THIN_UP_FRAME);
      o->color (FL_FOREGROUND_COLOR);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Group *o = new Fl_Group (0, 0, 750, 550);
      {
	CScroll1 = new Fl_Scroll (0, 24, 195, 521);
	CScroll1->type (5);
	CScroll1->end ();
      }				// Fl_Scroll* CScroll1
      {
	CScroll2 = new Fl_Scroll (195, 24, 555, 506);
	CScroll2->type (1);
	CScroll2->when (FL_WHEN_CHANGED);
	CScroll2->end ();
      }				// Fl_Scroll* CScroll2
      {
	CScroll3 = new Fl_Scroll (195, 0, 555, 25);
	CScroll3->type (1);
	CScroll3->when (FL_WHEN_CHANGED);
	CScroll3->end ();
      }				// Fl_Scroll* CScroll3
      o->end ();
    }				// Fl_Group* o
    {
      CVerBar = new Fl_Scrollbar (750, 24, 16, 521);
      CVerBar->maximum (1024);
      CVerBar->callback ((Fl_Callback *) cb_CVerBar);
    }				// Fl_Scrollbar* CVerBar
    {
      CHorBar = new Fl_Scrollbar (195, 529, 555, 16);
      CHorBar->type (1);
      CHorBar->maximum (0);
      CHorBar->callback ((Fl_Callback *) cb_CHorBar);
    }				// Fl_Scrollbar* CHorBar
    {
      Fl_Button *o = new Fl_Button (600, 555, 75, 35, gettext ("Ok"));
      o->color (FL_LIGHT2);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Ok4);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (680, 555, 75, 35, gettext ("Cancel"));
      o->color (FL_LIGHT2);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Cancel7);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (105, 575, 90, 20, gettext ("Copy From"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Copyc);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (5, 575, 90, 20, gettext ("Copy From"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Copyd);
    }				// Fl_Button* o
    {
      Fl_Box *o = new Fl_Box (0, 0, 195, 25, gettext ("Controllers/ Bars"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 4);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (5, 550, 90, 25, gettext ("Controllers"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 4);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Box *o = new Fl_Box (105, 550, 90, 25, gettext ("Bars"));
      o->box (FL_PLASTIC_UP_BOX);
      o->color ((Fl_Color) 4);
      o->labeltype (FL_ENGRAVED_LABEL);
    }				// Fl_Box* o
    {
      Fl_Group *o = new Fl_Group (205, 575, 380, 20);
      {
	CtrlAcc1 = new Fl_Button (205, 575, 50, 20, gettext ("Acc1"));
	CtrlAcc1->type (102);
	CtrlAcc1->box (FL_PLASTIC_UP_BOX);
	CtrlAcc1->color (FL_LIGHT2);
	CtrlAcc1->selection_color ((Fl_Color) 3);
	CtrlAcc1->labelsize (12);
	CtrlAcc1->callback ((Fl_Callback *) cb_CtrlAcc1);
      }				// Fl_Button* CtrlAcc1
      {
	CtrlAcc2 = new Fl_Button (260, 575, 50, 20, gettext ("Acc2"));
	CtrlAcc2->type (102);
	CtrlAcc2->box (FL_PLASTIC_UP_BOX);
	CtrlAcc2->color (FL_LIGHT2);
	CtrlAcc2->selection_color ((Fl_Color) 3);
	CtrlAcc2->labelsize (12);
	CtrlAcc2->callback ((Fl_Callback *) cb_CtrlAcc2);
      }				// Fl_Button* CtrlAcc2
      {
	CtrlAcc3 = new Fl_Button (315, 575, 50, 20, gettext ("Acc3"));
	CtrlAcc3->type (102);
	CtrlAcc3->box (FL_PLASTIC_UP_BOX);
	CtrlAcc3->color (FL_LIGHT2);
	CtrlAcc3->selection_color ((Fl_Color) 3);
	CtrlAcc3->labelsize (12);
	CtrlAcc3->callback ((Fl_Callback *) cb_CtrlAcc3);
      }				// Fl_Button* CtrlAcc3
      {
	CtrlAcc4 = new Fl_Button (370, 575, 50, 20, gettext ("Acc4"));
	CtrlAcc4->type (102);
	CtrlAcc4->box (FL_PLASTIC_UP_BOX);
	CtrlAcc4->color (FL_LIGHT2);
	CtrlAcc4->selection_color ((Fl_Color) 3);
	CtrlAcc4->labelsize (12);
	CtrlAcc4->callback ((Fl_Callback *) cb_CtrlAcc4);
      }				// Fl_Button* CtrlAcc4
      {
	CtrlAcc5 = new Fl_Button (425, 575, 50, 20, gettext ("Acc5"));
	CtrlAcc5->type (102);
	CtrlAcc5->box (FL_PLASTIC_UP_BOX);
	CtrlAcc5->color (FL_LIGHT2);
	CtrlAcc5->selection_color ((Fl_Color) 3);
	CtrlAcc5->labelsize (12);
	CtrlAcc5->callback ((Fl_Callback *) cb_CtrlAcc5);
      }				// Fl_Button* CtrlAcc5
      {
	CtrlBass = new Fl_Button (480, 575, 50, 20, gettext ("Bass"));
	CtrlBass->type (102);
	CtrlBass->box (FL_PLASTIC_UP_BOX);
	CtrlBass->color (FL_LIGHT2);
	CtrlBass->selection_color ((Fl_Color) 3);
	CtrlBass->labelsize (12);
	CtrlBass->callback ((Fl_Callback *) cb_CtrlBass);
      }				// Fl_Button* CtrlBass
      {
	CtrlDrums = new Fl_Button (535, 575, 50, 20, gettext ("Drums"));
	CtrlDrums->type (102);
	CtrlDrums->box (FL_PLASTIC_UP_BOX);
	CtrlDrums->color (FL_LIGHT2);
	CtrlDrums->selection_color ((Fl_Color) 3);
	CtrlDrums->labelsize (12);
	CtrlDrums->callback ((Fl_Callback *) cb_CtrlDrums);
      }				// Fl_Button* CtrlDrums
      o->end ();
    }				// Fl_Group* o
    {
      Fl_Button *o =
	new Fl_Button (205, 550, 110, 20, gettext ("Clear Control"));
      o->color (FL_LIGHT2);
      o->labelsize (11);
      o->callback ((Fl_Callback *) cb_Clear8);
    }				// Fl_Button* o
    CtrlEditBox->end ();
  }				// Fl_Double_Window* CtrlEditBox
  return CtrlEditBox;
}

void
GMORGAN::cierraCtrlEdit ()
{
  gmo->ctrledit = 0;
  CHorBar->value (1, 0, 0, (gmo->Rt[gmo->sp].bars - 1) * 546);
  CScroll3->position (CHorBar->value (), CScroll3->yposition ());
  CScroll2->position (CHorBar->value (), CScroll2->yposition ());
  CVerBar->value (1, 0, 0, 1024);
  CScroll1->position (CScroll1->xposition (), CVerBar->value ());
  CScroll2->position (CScroll2->xposition (), CVerBar->value ());

  CtrlEditBox->hide ();
  CtrlEditBox->clear ();
}

void
GMORGAN::ctrl_call1 (Fl_Value_Input * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->ctrl_call1_i (o, v);
}

inline void
GMORGAN::ctrl_call1_i (Fl_Value_Input * o, void *)
{
  int i, j;

  int kd = (long) o->user_data ();
  int kv = (int) o->value ();
  i = kd / 130;
  j = kd % 130;
  Ectrl[canaledit][i][j] = kv;
}

void
GMORGAN::ctrl_call2 (Fl_Output * o, void *v)
{
  ((GMORGAN *) (o->parent ()->parent ()->user_data ()))->ctrl_call2_i (o, v);
}

inline void
GMORGAN::ctrl_call2_i (Fl_Output * o, void *)
{
  lastcascr = sdec + 10000;
  int kd = (long) o->user_data ();
  if (kd != lastcascr)
    cambiacascr = 1;
  sdec = kd - 10000;
  o->color (FL_WHITE);
  o->cursor_color (FL_WHITE);
  o->redraw ();
}

void
GMORGAN::repinta (int ccanal)
{
  gmo->BorraControles (gmo->sp);

  gmo->ControlesPon (gmo->sp);

  cierraCtrlEdit ();

  canaledit = ccanal;

  gmo->PonControles (gmo->sp);

  gmo->ctrledit = 1;
  make_ctrl_window ();
  make_ctrl_edit ();
}

void
GMORGAN::PreparaMidiImport ()
{
  MiFiname->value (gmo->MidiImportFilename);
  WMiNominator->value (gmo->MiNominator);
  WMiBars->value (gmo->MiBars);
  WMiDrumsMCh->value (gmo->MiDrumsMCh);
  WMiBassMCh->value (gmo->MiBassMCh);
  WMiBaseKey->value (gmo->MiBaseKey);
  WMiStart->value (gmo->MiStart);
  WMiAcc1MCh->value (gmo->MiAcc1MCh);
  WMiAcc2MCh->value (gmo->MiAcc2MCh);
  WMiAcc3MCh->value (gmo->MiAcc3MCh);
  WMiAcc4MCh->value (gmo->MiAcc4MCh);
  WMiAcc5MCh->value (gmo->MiAcc5MCh);

  if (gmo->Mmodebass == 1)
    WMimodeB1->value (1);
  else
    WMimodeB2->value (1);
  if (gmo->Mmodeacc2 == 1)
    WMimodeA21->value (1);
  else
    WMimodeA22->value (1);
  if (gmo->Mmodeacc4 == 1)
    WMimodeA41->value (1);
  else
    WMimodeA42->value (1);
}

void
GMORGAN::miraselboton (int k)
{
  int i;
  i = (int) ginstbrowser->value ();

  switch (i)
    {
    case 1:

      GenDrums->setonly ();
      break;

    case 2:

      GenDrums->setonly ();
      break;

    case 3:

      GenDrums->setonly ();
      break;

    case 4:

      GenDrums->setonly ();
      break;

    case 5:

      GenDrums->setonly ();
      break;

    case 6:

      GenBass->setonly ();
      break;

    case 7:

      GenAcc1->setonly ();
      break;

    case 8:

      GenAcc1->setonly ();
      break;

    case 9:

      GenAcc1->setonly ();
      break;

    case 10:

      GenAcc1->setonly ();
      break;

    case 11:

      GenAcc2->setonly ();
      if (k == 4)
	GenAcc4->setonly ();
      break;

    case 12:

      GenAcc2->setonly ();
      if (k == 4)
	GenAcc4->setonly ();
      break;

    case 13:

      GenAcc2->setonly ();
      if (k == 4)
	GenAcc4->setonly ();
      break;

    case 14:

      GenAcc2->setonly ();
      if (k == 4)
	GenAcc4->setonly ();
      break;

    case 15:

      GenAcc3->setonly ();
      if (k == 5)
	GenAcc5->setonly ();
      break;

    case 16:

      GenAcc3->setonly ();
      if (k == 5)
	GenAcc5->setonly ();
      break;

    case 17:

      GenAcc3->setonly ();
      if (k == 5)
	GenAcc5->setonly ();
      break;

    case 18:

      GenAcc3->setonly ();
      if (k == 5)
	GenAcc5->setonly ();
      break;
    }
}

Fl_Double_Window *
GMORGAN::make_generator ()
{
  {
    gtwindow = new Fl_Double_Window (635, 325, gettext ("Pattern Generator"));
    gtwindow->box (FL_THIN_UP_BOX);
    gtwindow->color (FL_LIGHT2);
    gtwindow->callback ((Fl_Callback *) cb_gtwindow, (void *) (this));
    {
      gstybrowser = new Fl_Browser (5, 20, 145, 250, gettext ("Styles"));
      gstybrowser->type (2);
      gstybrowser->labelsize (12);
      gstybrowser->textsize (12);
      gstybrowser->callback ((Fl_Callback *) cb_gstybrowser);
      gstybrowser->align (FL_ALIGN_TOP);
    }				// Fl_Browser* gstybrowser
    {
      ginstbrowser =
	new Fl_Browser (220, 20, 215, 250, gettext ("Instrument"));
      ginstbrowser->type (2);
      ginstbrowser->labelsize (12);
      ginstbrowser->textsize (12);
      ginstbrowser->callback ((Fl_Callback *) cb_ginstbrowser);
      ginstbrowser->align (FL_ALIGN_TOP);
    }				// Fl_Browser* ginstbrowser
    {
      gvarbrowser = new Fl_Browser (445, 20, 120, 250, gettext ("Variation"));
      gvarbrowser->type (2);
      gvarbrowser->labelsize (12);
      gvarbrowser->textsize (12);
      gvarbrowser->align (FL_ALIGN_TOP);
    }				// Fl_Browser* gvarbrowser
    {
      GAddSty = new Fl_Button (155, 60, 60, 35, gettext ("Add"));
      GAddSty->box (FL_UP_FRAME);
      GAddSty->color ((Fl_Color) 44);
      GAddSty->labelsize (10);
      GAddSty->callback ((Fl_Callback *) cb_GAddSty);
    }				// Fl_Button* GAddSty
    {
      GAddVar = new Fl_Button (570, 60, 60, 35, gettext ("Add"));
      GAddVar->box (FL_UP_FRAME);
      GAddVar->color ((Fl_Color) 44);
      GAddVar->labelsize (10);
      GAddVar->callback ((Fl_Callback *) cb_GAddVar);
    }				// Fl_Button* GAddVar
    {
      Fl_Button *o = new Fl_Button (570, 285, 60, 35, gettext ("Close"));
      o->box (FL_UP_FRAME);
      o->color ((Fl_Color) 44);
      o->labelsize (10);
      o->callback ((Fl_Callback *) cb_Close5);
    }				// Fl_Button* o
    {
      Fl_Group *o = new Fl_Group (125, 285, 385, 25);
      {
	GenAcc1 = new Fl_Button (130, 290, 50, 20, gettext ("Acc1"));
	GenAcc1->type (102);
	GenAcc1->box (FL_PLASTIC_UP_BOX);
	GenAcc1->color (FL_LIGHT2);
	GenAcc1->selection_color ((Fl_Color) 3);
	GenAcc1->labelsize (12);
	GenAcc1->callback ((Fl_Callback *) cb_GenAcc1);
      }				// Fl_Button* GenAcc1
      {
	GenAcc2 = new Fl_Button (185, 290, 50, 20, gettext ("Acc2"));
	GenAcc2->type (102);
	GenAcc2->box (FL_PLASTIC_UP_BOX);
	GenAcc2->color (FL_LIGHT2);
	GenAcc2->selection_color ((Fl_Color) 3);
	GenAcc2->labelsize (12);
	GenAcc2->callback ((Fl_Callback *) cb_GenAcc2);
      }				// Fl_Button* GenAcc2
      {
	GenAcc3 = new Fl_Button (240, 290, 50, 20, gettext ("Acc3"));
	GenAcc3->type (102);
	GenAcc3->box (FL_PLASTIC_UP_BOX);
	GenAcc3->color (FL_LIGHT2);
	GenAcc3->selection_color ((Fl_Color) 3);
	GenAcc3->labelsize (12);
	GenAcc3->callback ((Fl_Callback *) cb_GenAcc3);
      }				// Fl_Button* GenAcc3
      {
	GenAcc4 = new Fl_Button (295, 290, 50, 20, gettext ("Acc4"));
	GenAcc4->type (102);
	GenAcc4->box (FL_PLASTIC_UP_BOX);
	GenAcc4->color (FL_LIGHT2);
	GenAcc4->selection_color ((Fl_Color) 3);
	GenAcc4->labelsize (12);
	GenAcc4->callback ((Fl_Callback *) cb_GenAcc4);
      }				// Fl_Button* GenAcc4
      {
	GenAcc5 = new Fl_Button (350, 290, 50, 20, gettext ("Acc5"));
	GenAcc5->type (102);
	GenAcc5->box (FL_PLASTIC_UP_BOX);
	GenAcc5->color (FL_LIGHT2);
	GenAcc5->selection_color ((Fl_Color) 3);
	GenAcc5->labelsize (12);
	GenAcc5->callback ((Fl_Callback *) cb_GenAcc5);
      }				// Fl_Button* GenAcc5
      {
	GenBass = new Fl_Button (405, 290, 50, 20, gettext ("Bass"));
	GenBass->type (102);
	GenBass->box (FL_PLASTIC_UP_BOX);
	GenBass->color (FL_LIGHT2);
	GenBass->selection_color ((Fl_Color) 3);
	GenBass->labelsize (12);
	GenBass->callback ((Fl_Callback *) cb_GenBass);
      }				// Fl_Button* GenBass
      {
	GenDrums = new Fl_Button (460, 290, 50, 20, gettext ("Drums"));
	GenDrums->type (102);
	GenDrums->box (FL_PLASTIC_UP_BOX);
	GenDrums->color (FL_LIGHT2);
	GenDrums->selection_color ((Fl_Color) 3);
	GenDrums->labelsize (12);
	GenDrums->callback ((Fl_Callback *) cb_GenDrums);
      }				// Fl_Button* GenDrums
      o->end ();
    }				// Fl_Group* o
    {
      GPutVar = new Fl_Button (570, 100, 60, 35, gettext ("Put"));
      GPutVar->box (FL_UP_FRAME);
      GPutVar->color ((Fl_Color) 44);
      GPutVar->labelsize (10);
      GPutVar->callback ((Fl_Callback *) cb_GPutVar);
    }				// Fl_Button* GPutVar
    gtwindow->end ();
  }				// Fl_Double_Window* gtwindow
  return gtwindow;
}

void
GMORGAN::preparagen ()
{
  int i;
  make_generator ();
  ginstbrowser->clear ();
  gstybrowser->clear ();
  gvarbrowser->clear ();
  for (i = 1; i < 19; i++)
    ginstbrowser->add (gmo->INames[i].Name);
  leelib ();
  ginstbrowser->select (1);
  gstybrowser->select (1);
  PonVariation ();
  gvarbrowser->select (1);
  miraselboton (0);


  gtwindow->position (1, 1);
  gtwindow->show ();
}

void
GMORGAN::leelib ()
{
  FILE *fs;
  int i;
  char *filename;

  gstybrowser->clear ();
  gvarbrowser->clear ();

  for (i = 1; i < 19; i++)
    gmo->NumVari[i] = 0;

  filename = strdup (gmo->LibStylesFilename);
  if ((fs = fopen (filename, "rb")) != NULL)
    {
      while (!feof (fs))
	{
	  i = fread (&gmo->Register, sizeof (gmo->Register), 1, fs);
	  if (feof (fs) == 0)
	    procesaleido ();
	}
      fclose (fs);
    }
}

void
GMORGAN::procesaleido ()
{
  if (gmo->Register.stat == 0)
    return;

  int i = (int) gmo->Register.type;


  if (i == 1)
    {
      gstybrowser->add (gmo->Register.style);
      if (strcmp (gmo->ElEstilo, "Empty") == 0)
	{
	  bzero (gmo->ElEstilo, sizeof (gmo->ElEstilo));
	  strcpy (gmo->ElEstilo, gmo->Register.style);
	}
      return;
    }


  if (strcmp (gmo->Register.style, gmo->ElEstilo) == 0)

    gmo->NumVari[i - 1]++;
}

void
GMORGAN::AddVariation ()
{
  int i, j;
  strcpy (gmo->Register.style, gstybrowser->text (gstybrowser->value ()));
  gmo->Register.stat = 1;
  gmo->Register.type = ginstbrowser->value () + 1;
  bzero (gmo->Register.datavar, sizeof (gmo->Register.datavar));

  int Tipode = (int) gmo->Register.type;

  if ((Tipode < 2) || (Tipode > 19))
    return;

  switch (Tipode)
    {

    case 2:
      for (i = 1; i < 129; i++)
	{
	  for (j = 9; j < 11; j++)
	    {

	      gmo->Register.datavar[j - 9][i] = Edr[j][i];

	    }
	}

      break;

    case 3:
      for (i = 1; i < 129; i++)
	{
	  gmo->Register.datavar[0][i] = Edr[5][i];
	  gmo->Register.datavar[1][i] = Edr[11][i];
	  gmo->Register.datavar[2][i] = Edr[12][i];
	  gmo->Register.datavar[3][i] = Edr[13][i];
	  gmo->Register.datavar[4][i] = Edr[14][i];
	}
      break;

    case 4:
      for (i = 1; i < 129; i++)
	{
	  gmo->Register.datavar[0][i] = Edr[16][i];
	  gmo->Register.datavar[1][i] = Edr[18][i];
	  gmo->Register.datavar[2][i] = Edr[20][i];
	  gmo->Register.datavar[3][i] = Edr[23][i];
	  gmo->Register.datavar[4][i] = Edr[25][i];
	  gmo->Register.datavar[5][i] = Edr[26][i];
	  gmo->Register.datavar[6][i] = Edr[27][i];
	  gmo->Register.datavar[7][i] = Edr[29][i];
	  gmo->Register.datavar[8][i] = Edr[31][i];
	  gmo->Register.datavar[9][i] = Edr[33][i];
	}
      break;

    case 5:
      for (i = 1; i < 129; i++)
	{
	  gmo->Register.datavar[0][i] = Edr[15][i];
	  gmo->Register.datavar[1][i] = Edr[17][i];
	  gmo->Register.datavar[2][i] = Edr[19][i];
	  gmo->Register.datavar[3][i] = Edr[21][i];
	  gmo->Register.datavar[4][i] = Edr[22][i];
	  gmo->Register.datavar[5][i] = Edr[24][i];
	  gmo->Register.datavar[6][i] = Edr[39][i];
	  gmo->Register.datavar[7][i] = Edr[40][i];
	  gmo->Register.datavar[8][i] = Edr[60][i];
	  gmo->Register.datavar[9][i] = Edr[61][i];
	}
      break;

    case 6:
      for (i = 1; i < 129; i++)
	{
	  gmo->Register.datavar[0][i] = Edr[28][i];
	  gmo->Register.datavar[1][i] = Edr[30][i];
	  gmo->Register.datavar[2][i] = Edr[34][i];
	  gmo->Register.datavar[3][i] = Edr[35][i];
	  gmo->Register.datavar[4][i] = Edr[36][i];
	  gmo->Register.datavar[5][i] = Edr[37][i];
	  gmo->Register.datavar[6][i] = Edr[38][i];
	  gmo->Register.datavar[7][i] = Edr[43][i];
	  gmo->Register.datavar[8][i] = Edr[49][i];
	  gmo->Register.datavar[9][i] = Edr[55][i];
	}
      break;

    case 7:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].basn[j][i];
	    }
	}

      break;

    case 8:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc1n[j][i];
	    }
	}
      break;

    case 9:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc1n[j][i];
	    }
	}
      break;

    case 10:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc1n[j][i];
	    }
	}
      break;

    case 11:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc1n[j][i];
	    }
	}
      break;

    case 12:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc2n[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc4n[j][i];
	    }
	}
      break;

    case 13:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc2n[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc4n[j][i];
	    }
	}
      break;


    case 14:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc2n[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc4n[j][i];
	    }
	}
      break;


    case 15:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc2n[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc4n[j][i];
	    }
	}
      break;


    case 16:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc3n[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc5n[j][i];
	    }
	}
      break;

    case 17:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc3n[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc5n[j][i];
	    }
	}
      break;

    case 18:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc3n[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc5n[j][i];
	    }
	}
      break;


    case 19:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc3n[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Register.datavar[j][i] = gmo->Rt[gmo->sp].acc5n[j][i];
	    }
	}
      break;



    }


  gmo->grabalib ();
}

void
GMORGAN::PonVariation ()
{
  int i;
  char temp[32];

  for (i = 1; i <= (int) gmo->NumVari[(int) ginstbrowser->value ()]; i++)
    {
      bzero (temp, sizeof (temp));
      sprintf (temp, gettext ("Variation %d"), i);
      gvarbrowser->add (temp);

    }
}

void
GMORGAN::Put_Variation ()
{
  if (gmo->NumVari[(int) ginstbrowser->value ()] < 1)
    return;

  FILE *fs;
  int i;
  char *filename;
  int contador = 0;

  filename = strdup (gmo->LibStylesFilename);

  if ((fs = fopen (filename, "rb")) != NULL)
    {
      while (!feof (fs))
	{
	  i = fread (&gmo->Register, sizeof (gmo->Register), 1, fs);
	  if (feof (fs) == 0)
	    {

	      if (gmo->Register.type == (ginstbrowser->value () + 1))
		{
		  if (strcmp (gmo->Register.style, gmo->ElEstilo) == 0)
		    {
		      contador++;

		      if (contador == (int) gvarbrowser->value ())
			{
			  PutInPattern ();
			  break;
			}
		    }
		}
	    }
	}
      fclose (fs);
    }
}

void
GMORGAN::PutInPattern ()
{
  int i, j;

  int Tipode = (int) gmo->Register.type;
  if ((Tipode < 2) || (Tipode > 19))
    return;
  switch (Tipode)
    {

    case 2:
      for (i = 1; i < 129; i++)
	{
	  for (j = 9; j < 11; j++)
	    {
	      Edr[j][i] = gmo->Register.datavar[j - 9][i];
	    }
	}
      break;
    case 3:
      for (i = 1; i < 129; i++)
	{
	  Edr[5][i] = gmo->Register.datavar[0][i];
	  Edr[11][i] = gmo->Register.datavar[1][i];
	  Edr[12][i] = gmo->Register.datavar[2][i];
	  Edr[13][i] = gmo->Register.datavar[3][i];
	  Edr[14][i] = gmo->Register.datavar[4][i];
	}
      break;

    case 4:
      for (i = 1; i < 129; i++)
	{
	  Edr[16][i] = gmo->Register.datavar[0][i];
	  Edr[18][i] = gmo->Register.datavar[1][i];
	  Edr[20][i] = gmo->Register.datavar[2][i];
	  Edr[23][i] = gmo->Register.datavar[3][i];
	  Edr[25][i] = gmo->Register.datavar[4][i];
	  Edr[26][i] = gmo->Register.datavar[5][i];
	  Edr[27][i] = gmo->Register.datavar[6][i];
	  Edr[29][i] = gmo->Register.datavar[7][i];
	  Edr[31][i] = gmo->Register.datavar[8][i];
	  Edr[33][i] = gmo->Register.datavar[9][i];
	}
      break;

    case 5:
      for (i = 1; i < 129; i++)
	{
	  Edr[15][i] = gmo->Register.datavar[0][i];
	  Edr[17][i] = gmo->Register.datavar[1][i];
	  Edr[19][i] = gmo->Register.datavar[2][i];
	  Edr[21][i] = gmo->Register.datavar[3][i];
	  Edr[22][i] = gmo->Register.datavar[4][i];
	  Edr[24][i] = gmo->Register.datavar[5][i];
	  Edr[39][i] = gmo->Register.datavar[6][i];
	  Edr[40][i] = gmo->Register.datavar[7][i];
	  Edr[60][i] = gmo->Register.datavar[8][i];
	  Edr[61][i] = gmo->Register.datavar[9][i];
	}
      break;

    case 6:
      for (i = 1; i < 129; i++)
	{
	  Edr[28][i] = gmo->Register.datavar[0][i];
	  Edr[30][i] = gmo->Register.datavar[1][i];
	  Edr[34][i] = gmo->Register.datavar[2][i];
	  Edr[35][i] = gmo->Register.datavar[3][i];
	  Edr[36][i] = gmo->Register.datavar[4][i];
	  Edr[37][i] = gmo->Register.datavar[5][i];
	  Edr[38][i] = gmo->Register.datavar[6][i];
	  Edr[43][i] = gmo->Register.datavar[7][i];
	  Edr[49][i] = gmo->Register.datavar[8][i];
	  Edr[55][i] = gmo->Register.datavar[9][i];
	}
      break;

    case 7:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      gmo->Rt[gmo->sp].basn[j][i] = gmo->Register.datavar[j][i];
	    }
	}

      break;

    case 8:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Rt[gmo->sp].acc1n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 9:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Rt[gmo->sp].acc1n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 10:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Rt[gmo->sp].acc1n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 11:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 2; j++)
	    {
	      gmo->Rt[gmo->sp].acc1n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 12:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc2->value () == 1)
		gmo->Rt[gmo->sp].acc2n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Rt[gmo->sp].acc4n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 13:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc2->value () == 1)
		gmo->Rt[gmo->sp].acc2n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Rt[gmo->sp].acc4n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;


    case 14:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc2->value () == 1)
		gmo->Rt[gmo->sp].acc2n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Rt[gmo->sp].acc4n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;


    case 15:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc2->value () == 1)
		gmo->Rt[gmo->sp].acc2n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc4->value () == 1)
		gmo->Rt[gmo->sp].acc4n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;


    case 16:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc3->value () == 1)
		gmo->Rt[gmo->sp].acc3n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Rt[gmo->sp].acc5n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 17:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc3->value () == 1)
		gmo->Rt[gmo->sp].acc3n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Rt[gmo->sp].acc5n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;

    case 18:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc3->value () == 1)
		gmo->Rt[gmo->sp].acc3n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Rt[gmo->sp].acc5n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;


    case 19:
      for (i = 1; i < 129; i++)
	{
	  for (j = 0; j < 3; j++)
	    {
	      if ((int) GenAcc3->value () == 1)
		gmo->Rt[gmo->sp].acc3n[j][i] = gmo->Register.datavar[j][i];
	      if ((int) GenAcc5->value () == 1)
		gmo->Rt[gmo->sp].acc5n[j][i] = gmo->Register.datavar[j][i];
	    }
	}
      break;
    }

  if ((gmo->dredit == 1) && (Tipode < 7))
    {
      DrumEditBox->hide ();
      gmo->dredit = 0;
    }

  if (Tipode > 6)
    {
      PatternEditWin->hide ();
    }
}

void
GMORGAN::preparaGUIPlay ()
{
  if (gmo->WGUIP == 1)
    return;

  make_WPGP ();
  gmo->WGUIP = 1;
  int i;
  char temp[64];
  GPBrowser->clear ();
  MGUIPlay->value (gmo->GUIPlay);

  for (i = 1; i < 200; i++)
    {
      if (gmo->GP[i].bar != 0)
	{
	  bzero (temp, sizeof (temp));
	  sprintf (temp, "B-%03d P-%03d", gmo->GP[i].bar, gmo->GP[i].pattern);
	  GPBrowser->add (temp);
	}
    }

  GPBrowser->select (1);
  WGPBar->value (gmo->GP[1].bar);
  WGPPattern->value (gmo->GP[1].pattern);
  WGuiPattern->position (30, 30);
  WGuiPattern->show ();
}

Fl_Double_Window *
GMORGAN::make_WPGP ()
{
  {
    WGuiPattern =
      new Fl_Double_Window (290, 330, gettext ("Pattern Guided Play"));
    WGuiPattern->color (FL_LIGHT2);
    WGuiPattern->callback ((Fl_Callback *) cb_WGuiPattern, (void *) (this));
    {
      Fl_Menu_Bar *o = new Fl_Menu_Bar (0, 0, 435, 25);
      o->box (FL_THIN_UP_BOX);
      o->color (FL_LIGHT2);
      o->labelsize (12);
      o->menu (menu_8);
    }				// Fl_Menu_Bar* o
    {
      GPBrowser = new Fl_Browser (5, 75, 150, 245);
      GPBrowser->type (2);
      GPBrowser->textsize (12);
      GPBrowser->callback ((Fl_Callback *) cb_GPBrowser);
    }				// Fl_Browser* GPBrowser
    {
      WGPBar = new Fl_Value_Input (240, 80, 40, 25, gettext ("Bar"));
      WGPBar->labelsize (12);
      WGPBar->minimum (1);
      WGPBar->maximum (4000);
      WGPBar->step (1);
      WGPBar->value (1);
      WGPBar->textsize (12);
    }				// Fl_Value_Input* WGPBar
    {
      WGPPattern = new Fl_Value_Input (240, 105, 40, 25, gettext ("Pattern"));
      WGPPattern->labelsize (12);
      WGPPattern->minimum (1);
      WGPPattern->maximum (99);
      WGPPattern->step (1);
      WGPPattern->value (1);
      WGPPattern->textsize (12);
    }				// Fl_Value_Input* WGPPattern
    {
      MGUIPlay = new Fl_Button (5, 40, 55, 30, gettext ("On"));
      MGUIPlay->type (1);
      MGUIPlay->box (FL_PLASTIC_UP_BOX);
      MGUIPlay->selection_color ((Fl_Color) 3);
      MGUIPlay->labeltype (FL_ENGRAVED_LABEL);
      MGUIPlay->labelsize (12);
      MGUIPlay->callback ((Fl_Callback *) cb_MGUIPlay);
      MGUIPlay->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Button* MGUIPlay
    {
      Fl_Button *o = new Fl_Button (165, 180, 115, 30, gettext ("Modify"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Modify3);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    {
      Fl_Button *o = new Fl_Button (165, 145, 115, 30, gettext ("Add"));
      o->box (FL_UP_FRAME);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_Add1);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Button* o
    WGuiPattern->end ();
  }				// Fl_Double_Window* WGuiPattern
  GPWEFileFile->label (gettext ("&File"));
  GPWEFileFilesub1->label (gettext ("&Load"));
  GPWEFileFilesub2->label (gettext ("&Save"));
  GPWEFileFilesub3->label (gettext ("&New"));
  GPWEFileFilesub4->label (gettext ("&Close"));
  Fl::redraw ();
  return WGuiPattern;
}

Fl_Double_Window *
GMORGAN::make_abowindow ()
{
  {
    aboutwindow = new Fl_Double_Window (270, 465, gettext ("About..."));
    aboutwindow->color (FL_LIGHT2);
    aboutwindow->selection_color ((Fl_Color) 51);
    aboutwindow->callback ((Fl_Callback *) cb_aboutwindow, (void *) (this));
    aboutwindow->align (33);
    {
      Fl_Box *o = new Fl_Box (0, -10, 270, 415);
      o->image (image_gmorgan_logo);
      o->align (FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (0, 0, 270, 45,
		    gettext
		    (" Copyright (C) 2003-2004 by Josep Andreu\n     (Holborn) \n      vogelrl\
@@atlanticbb.net "));
      o->labelfont (1);
      o->labelsize (10);
      o->labelcolor ((Fl_Color) 4);
      o->align (FL_ALIGN_CLIP | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (0, 350, 270, 115,
		    gettext
		    ("This is free software. you may redistribute and/or modify it under the terms \
of the latest version of the GNU General Public License as published by the Free So\
ftware Fundation.\n This program comes with \n ABSOLUTE NO WARRANTY. \n See th\
e \n GNU General Public License for details."));
      o->box (FL_FLAT_BOX);
      o->color (FL_LIGHT1);
      o->labelfont (1);
      o->labelsize (10);
      o->labelcolor ((Fl_Color) 4);
      o->align (194 | FL_ALIGN_INSIDE);
    }				// Fl_Box* o
    {
      Fl_Button *o = new Fl_Button (100, 305, 70, 40, gettext ("OK"));
      o->box (FL_UP_FRAME);
      o->shortcut (0xff0d);
      o->color (FL_LIGHT2);
      o->labelfont (1);
      o->labelsize (12);
      o->callback ((Fl_Callback *) cb_OK);
    }				// Fl_Button* o
    {
      Fl_Box *o =
	new Fl_Box (0, 45, 270, 10,
		    gettext ("Graphic Designer : Guy Daniel CLOTILDE"));
      o->color ((Fl_Color) 48);
      o->labelfont (1);
      o->labelsize (10);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    {
      Fl_Box *o =
	new Fl_Box (5, 55, 265, 10, gettext ("Documentation: Gilles Maire"));
      o->color ((Fl_Color) 48);
      o->labelfont (1);
      o->labelsize (10);
      o->labelcolor ((Fl_Color) 4);
    }				// Fl_Box* o
    aboutwindow->end ();
  }				// Fl_Double_Window* aboutwindow
  return aboutwindow;
}

void
GMORGAN::prepara_about ()
{
  if (gmo->ABOW == 1)
    return;
  gmo->ABOW = 1;
  make_abowindow ();
  aboutwindow->position (100, 100);
  aboutwindow->show ();
}

void
GMORGAN::prepara_WTT ()
{
  int i;
  char temp[128];
  MTempoTrack->value (gmo->MTempo);
  WTTBar->value (gmo->TemT[1].bar);
  WTTBlack->value (gmo->TemT[1].black);
  WTTTempo->value (gmo->TemT[1].tempo);
  TempoTrackBrowser->clear ();

  for (i = 1; i < 200; i++)
    {
      if ((int) gmo->TemT[i].bar == 0)
	break;
      bzero (temp, sizeof (temp));
      sprintf (temp, "B-%03d-%d T-%03d", gmo->TemT[i].bar, gmo->TemT[i].black,
	       gmo->TemT[i].tempo);
      TempoTrackBrowser->add (temp);

    }

  TempoTrackBrowser->select (1);
}

void
GMORGAN::PonColores (int usdata)
{
  int i;
  int ladata;
  for (i = 0; i < 61; i++)

    {
      ladata = (long) Scroll2->child (i)->user_data ();
      if (ladata == usdata)
	{
	  Scroll2->child (i)->color (59);
	  Scroll2->child (i)->redraw ();
	  break;
	}
    }
}

void
GMORGAN::PonColores2 (int usdata)
{
  int i;
  int ladata;
  for (i = 0; i < 32; i++)

    {
      ladata = (long) CScroll1->child (i)->user_data ();
      if (ladata == usdata)
	{
	  CScroll1->child (i)->color (59);
	  CScroll1->child (i)->redraw ();
	  break;
	}
    }
}
