#########################################################################
# (C) ZE CMS, Humboldt-Universitaet zu Berlin
# Written 2014 by Daniel Rohde <d.rohde@cms.hu-berlin.de>
#########################################################################
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#########################################################################

package WebInterface::Extension::SendByMail::Addressbook;
use strict;
use warnings;
our $VERSION = '2.0';

sub get_mail_addresses {
    my ( $self, $extension, $pattern ) = @_;
    my @result = grep { /\Q$pattern\E/xms }
      @{
        $extension->config( 'mailaddresses',
            [ 'Test User1 <a@example.org>', 'Test User2 <b@example.org>' ] )
      };
    return \@result;
}

1;
