// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/common.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Update type of the requests.
type UpdateType int32

const (
	// Defaults to full replace behavior, ie. FULL_REPLACE.
	UpdateType_UPDATE_TYPE_UNSPECIFIED UpdateType = 0
	// Fully replace all the fields. Any field masks will be ignored.
	UpdateType_UPDATE_TYPE_REPLACE UpdateType = 1
	// Merge the fields into the existing entities.
	UpdateType_UPDATE_TYPE_MERGE UpdateType = 2
	// Inserts the properties by names.
	UpdateType_UPDATE_TYPE_INSERT_PROPERTIES_BY_NAMES UpdateType = 3
	// Replace the properties by names.
	UpdateType_UPDATE_TYPE_REPLACE_PROPERTIES_BY_NAMES UpdateType = 4
	// Delete the properties by names.
	UpdateType_UPDATE_TYPE_DELETE_PROPERTIES_BY_NAMES UpdateType = 5
)

// Enum value maps for UpdateType.
var (
	UpdateType_name = map[int32]string{
		0: "UPDATE_TYPE_UNSPECIFIED",
		1: "UPDATE_TYPE_REPLACE",
		2: "UPDATE_TYPE_MERGE",
		3: "UPDATE_TYPE_INSERT_PROPERTIES_BY_NAMES",
		4: "UPDATE_TYPE_REPLACE_PROPERTIES_BY_NAMES",
		5: "UPDATE_TYPE_DELETE_PROPERTIES_BY_NAMES",
	}
	UpdateType_value = map[string]int32{
		"UPDATE_TYPE_UNSPECIFIED":                 0,
		"UPDATE_TYPE_REPLACE":                     1,
		"UPDATE_TYPE_MERGE":                       2,
		"UPDATE_TYPE_INSERT_PROPERTIES_BY_NAMES":  3,
		"UPDATE_TYPE_REPLACE_PROPERTIES_BY_NAMES": 4,
		"UPDATE_TYPE_DELETE_PROPERTIES_BY_NAMES":  5,
	}
)

func (x UpdateType) Enum() *UpdateType {
	p := new(UpdateType)
	*p = x
	return p
}

func (x UpdateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_common_proto_enumTypes[0].Descriptor()
}

func (UpdateType) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_common_proto_enumTypes[0]
}

func (x UpdateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateType.Descriptor instead.
func (UpdateType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{0}
}

// Type of database used by the customer
type DatabaseType int32

const (
	// This value is required by protobuf best practices
	DatabaseType_DB_UNKNOWN DatabaseType = 0
	// Internal Spanner
	DatabaseType_DB_INFRA_SPANNER DatabaseType = 1
	// Cloud Sql with a Postgres Sql instance
	DatabaseType_DB_CLOUD_SQL_POSTGRES DatabaseType = 2
)

// Enum value maps for DatabaseType.
var (
	DatabaseType_name = map[int32]string{
		0: "DB_UNKNOWN",
		1: "DB_INFRA_SPANNER",
		2: "DB_CLOUD_SQL_POSTGRES",
	}
	DatabaseType_value = map[string]int32{
		"DB_UNKNOWN":            0,
		"DB_INFRA_SPANNER":      1,
		"DB_CLOUD_SQL_POSTGRES": 2,
	}
)

func (x DatabaseType) Enum() *DatabaseType {
	p := new(DatabaseType)
	*p = x
	return p
}

func (x DatabaseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_common_proto_enumTypes[1].Descriptor()
}

func (DatabaseType) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_common_proto_enumTypes[1]
}

func (x DatabaseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseType.Descriptor instead.
func (DatabaseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{1}
}

// Access Control Mode.
type AccessControlMode int32

const (
	// This value is required by protobuf best practices
	AccessControlMode_ACL_MODE_UNKNOWN AccessControlMode = 0
	// Universal Access: No document level access control.
	AccessControlMode_ACL_MODE_UNIVERSAL_ACCESS AccessControlMode = 1
	// Document level access control with customer own Identity Service.
	AccessControlMode_ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID AccessControlMode = 2
	// Document level access control using Google Cloud Identity.
	AccessControlMode_ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI AccessControlMode = 3
)

// Enum value maps for AccessControlMode.
var (
	AccessControlMode_name = map[int32]string{
		0: "ACL_MODE_UNKNOWN",
		1: "ACL_MODE_UNIVERSAL_ACCESS",
		2: "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID",
		3: "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI",
	}
	AccessControlMode_value = map[string]int32{
		"ACL_MODE_UNKNOWN":                             0,
		"ACL_MODE_UNIVERSAL_ACCESS":                    1,
		"ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID": 2,
		"ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI":   3,
	}
)

func (x AccessControlMode) Enum() *AccessControlMode {
	p := new(AccessControlMode)
	*p = x
	return p
}

func (x AccessControlMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessControlMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_common_proto_enumTypes[2].Descriptor()
}

func (AccessControlMode) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_common_proto_enumTypes[2]
}

func (x AccessControlMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessControlMode.Descriptor instead.
func (AccessControlMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{2}
}

// Meta information is used to improve the performance of the service.
type RequestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Provides user unique identification and groups information.
	UserInfo *UserInfo `protobuf:"bytes,1,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
}

func (x *RequestMetadata) Reset() {
	*x = RequestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestMetadata) ProtoMessage() {}

func (x *RequestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestMetadata.ProtoReflect.Descriptor instead.
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *RequestMetadata) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

// Additional information returned to client, such as debugging information.
type ResponseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique id associated with this call. This id is logged for tracking
	// purpose.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResponseMetadata) Reset() {
	*x = ResponseMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMetadata) ProtoMessage() {}

func (x *ResponseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMetadata.ProtoReflect.Descriptor instead.
func (*ResponseMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *ResponseMetadata) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type UserInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique user identification string, as determined by the client.
	// The maximum number of allowed characters is 255.
	// Allowed characters include numbers 0 to 9, uppercase and lowercase letters,
	// and restricted special symbols (:, @, +, -, _, ~)
	// The format is "user:xxxx@example.com";
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The unique group identifications which the user is belong to.
	// The format is "group:yyyy@example.com";
	GroupIds []string `protobuf:"bytes,2,rep,name=group_ids,json=groupIds,proto3" json:"group_ids,omitempty"`
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *UserInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *UserInfo) GetGroupIds() []string {
	if x != nil {
		return x.GroupIds
	}
	return nil
}

// Options for Update operations.
type UpdateOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type for update.
	UpdateType UpdateType `protobuf:"varint,1,opt,name=update_type,json=updateType,proto3,enum=google.cloud.contentwarehouse.v1.UpdateType" json:"update_type,omitempty"`
	// Field mask for merging Document fields.
	// For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Options for merging.
	MergeFieldsOptions *MergeFieldsOptions `protobuf:"bytes,3,opt,name=merge_fields_options,json=mergeFieldsOptions,proto3" json:"merge_fields_options,omitempty"`
}

func (x *UpdateOptions) Reset() {
	*x = UpdateOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOptions) ProtoMessage() {}

func (x *UpdateOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOptions.ProtoReflect.Descriptor instead.
func (*UpdateOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateOptions) GetUpdateType() UpdateType {
	if x != nil {
		return x.UpdateType
	}
	return UpdateType_UPDATE_TYPE_UNSPECIFIED
}

func (x *UpdateOptions) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateOptions) GetMergeFieldsOptions() *MergeFieldsOptions {
	if x != nil {
		return x.MergeFieldsOptions
	}
	return nil
}

// Options for merging updated fields.
type MergeFieldsOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When merging message fields, the default behavior is to merge
	// the content of two message fields together. If you instead want to use
	// the field from the source message to replace the corresponding field in
	// the destination message, set this flag to true. When this flag is set,
	// specified submessage fields that are missing in source will be cleared in
	// destination.
	ReplaceMessageFields *bool `protobuf:"varint,1,opt,name=replace_message_fields,json=replaceMessageFields,proto3,oneof" json:"replace_message_fields,omitempty"`
	// When merging repeated fields, the default behavior is to append
	// entries from the source repeated field to the destination repeated field.
	// If you instead want to keep only the entries from the source repeated
	// field, set this flag to true.
	//
	// If you want to replace a repeated field within a message field on the
	// destination message, you must set both replace_repeated_fields and
	// replace_message_fields to true, otherwise the repeated fields will be
	// appended.
	ReplaceRepeatedFields *bool `protobuf:"varint,2,opt,name=replace_repeated_fields,json=replaceRepeatedFields,proto3,oneof" json:"replace_repeated_fields,omitempty"`
}

func (x *MergeFieldsOptions) Reset() {
	*x = MergeFieldsOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeFieldsOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeFieldsOptions) ProtoMessage() {}

func (x *MergeFieldsOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeFieldsOptions.ProtoReflect.Descriptor instead.
func (*MergeFieldsOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP(), []int{4}
}

func (x *MergeFieldsOptions) GetReplaceMessageFields() bool {
	if x != nil && x.ReplaceMessageFields != nil {
		return *x.ReplaceMessageFields
	}
	return false
}

func (x *MergeFieldsOptions) GetReplaceRepeatedFields() bool {
	if x != nil && x.ReplaceRepeatedFields != nil {
		return *x.ReplaceRepeatedFields
	}
	return false
}

var File_google_cloud_contentwarehouse_v1_common_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_common_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5a,
	0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x47, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x31, 0x0a, 0x10, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x37, 0x0a,
	0x08, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x22, 0x83, 0x02, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x66, 0x0a, 0x14, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xc3, 0x01, 0x0a,
	0x12, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x16, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3b,
	0x0a, 0x17, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x01, 0x52, 0x15, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x65, 0x70, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x88, 0x01, 0x01, 0x42, 0x19, 0x0a, 0x17, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x2a, 0xde, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1b, 0x0a, 0x17, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17,
	0x0a, 0x13, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45,
	0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x02, 0x12, 0x2a,
	0x0a, 0x26, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e,
	0x53, 0x45, 0x52, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x49, 0x45, 0x53, 0x5f,
	0x42, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x03, 0x12, 0x2b, 0x0a, 0x27, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x49, 0x45, 0x53, 0x5f, 0x42, 0x59, 0x5f,
	0x4e, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x04, 0x12, 0x2a, 0x0a, 0x26, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x50, 0x52,
	0x4f, 0x50, 0x45, 0x52, 0x54, 0x49, 0x45, 0x53, 0x5f, 0x42, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45,
	0x53, 0x10, 0x05, 0x2a, 0x4f, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x42, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x42, 0x5f, 0x49, 0x4e, 0x46, 0x52, 0x41, 0x5f,
	0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x42, 0x5f,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52,
	0x45, 0x53, 0x10, 0x02, 0x2a, 0xaa, 0x01, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x43,
	0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x1d, 0x0a, 0x19, 0x41, 0x43, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x49,
	0x56, 0x45, 0x52, 0x53, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12,
	0x30, 0x0a, 0x2c, 0x41, 0x43, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x4f, 0x43, 0x55,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x42, 0x59, 0x4f, 0x49, 0x44, 0x10,
	0x02, 0x12, 0x2e, 0x0a, 0x2a, 0x41, 0x43, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x4f,
	0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x47, 0x43, 0x49, 0x10,
	0x03, 0x42, 0xdd, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0xea, 0x41, 0x53, 0x0a, 0x28,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_common_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_common_proto_rawDescData = file_google_cloud_contentwarehouse_v1_common_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_common_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_common_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_common_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_contentwarehouse_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_contentwarehouse_v1_common_proto_goTypes = []interface{}{
	(UpdateType)(0),               // 0: google.cloud.contentwarehouse.v1.UpdateType
	(DatabaseType)(0),             // 1: google.cloud.contentwarehouse.v1.DatabaseType
	(AccessControlMode)(0),        // 2: google.cloud.contentwarehouse.v1.AccessControlMode
	(*RequestMetadata)(nil),       // 3: google.cloud.contentwarehouse.v1.RequestMetadata
	(*ResponseMetadata)(nil),      // 4: google.cloud.contentwarehouse.v1.ResponseMetadata
	(*UserInfo)(nil),              // 5: google.cloud.contentwarehouse.v1.UserInfo
	(*UpdateOptions)(nil),         // 6: google.cloud.contentwarehouse.v1.UpdateOptions
	(*MergeFieldsOptions)(nil),    // 7: google.cloud.contentwarehouse.v1.MergeFieldsOptions
	(*fieldmaskpb.FieldMask)(nil), // 8: google.protobuf.FieldMask
}
var file_google_cloud_contentwarehouse_v1_common_proto_depIdxs = []int32{
	5, // 0: google.cloud.contentwarehouse.v1.RequestMetadata.user_info:type_name -> google.cloud.contentwarehouse.v1.UserInfo
	0, // 1: google.cloud.contentwarehouse.v1.UpdateOptions.update_type:type_name -> google.cloud.contentwarehouse.v1.UpdateType
	8, // 2: google.cloud.contentwarehouse.v1.UpdateOptions.update_mask:type_name -> google.protobuf.FieldMask
	7, // 3: google.cloud.contentwarehouse.v1.UpdateOptions.merge_fields_options:type_name -> google.cloud.contentwarehouse.v1.MergeFieldsOptions
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_common_proto_init() }
func file_google_cloud_contentwarehouse_v1_common_proto_init() {
	if File_google_cloud_contentwarehouse_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeFieldsOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contentwarehouse_v1_common_proto_msgTypes[4].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_common_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_contentwarehouse_v1_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_common_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_common_proto = out.File
	file_google_cloud_contentwarehouse_v1_common_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_common_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_common_proto_depIdxs = nil
}
