/***************************************************************************
                      cob.hxx  -  Include file for COB
                             -------------------
    begin                : Tue Oct 14 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sdw.hxx"

using namespace SDLWrapper;

#define SPRITESIZE  (1024/32)                   // Size of sprites (square) in pixels
#define MAXCHASERS  (6)                         // Max # of chasers

#define M_UP        (0x01)                      // Bit values for map squares
#define M_DOWN      (0x02)
#define M_LEFT      (0x04)
#define M_RIGHT     (0x08)
#define M_COLOUR    (0x10)
#define M_HIDDEN    (0x20)
#define M_UNKNOWN   (0xFF)

class Graphics : public TransparentSurface
{
    public:
        Graphics(void) : TransparentSurface(SPRITESIZE*16,SPRITESIZE*3) { Repaint(); }
    protected:
        void Repaint(void);
        void PaintSquare(int Bits);
};

class Map
{
    public:
        Map(Surface &s,Graphics &g) : surface(s),graphics(g) { ResetMap(32,24); }
        void ResetMap(int xs,int ys);
        void Write(int x,int y,int n);
        int  Read(int x,int y) { return map[x][y]; }
        void VLine(int x,int y1,int y2);
        void HLine(int x1,int x2,int y);
        void Box(int x1,int y1,int x2,int y2);
        void Hide(int x,int y);
        void CheckHide(void);
        int  XSize(void) { return xsize; }
        int  YSize(void) { return ysize; }
        int  IsComplete(void) { return(mapremaining == 0); }
        int  Load(int Level);
        int  ToColour(void) { return mapremaining; }
    private:
        Surface &surface;                       // Surface used for drawing
        Graphics &graphics;                     // Sprite graphics
        int xsize,ysize;                        // Size of map
        int map[64][48];                        // Map entries (combination of M_UP etc)
        int mapremaining;                       // Number of cells not coloured in yet.
        int hiddenflag;                         // Non zero if something hidden
        int xhidden,yhidden;                    // x and y hidden cell
        Timer restore;                          // Restore timer.
};

class Sprite
{
    public:
        Sprite(Map &m,Graphics &g) : map(m),graphics(g) { x = y = 256;Direction = 0; }
        void Paint(void);
        int Move(void);
        int Collide(Sprite &s) { return (abs(x-s.x) < 128 && abs(y-s.y) < 128); }
    protected:
        int CheckValidMove(int Dir,int &dx,int &dy);
        virtual int GetGraphic(void) { return 2; }
        virtual void Junction(int x,int y) {}
        virtual void FailValidityCheck(void) {}
        Map &map;                               // Map on
        Graphics &graphics;                     // Graphics to be used
        int x,y;                                // Current position
        int Direction;                          // Current Direction
};

class Player : public Sprite
{
    public:
        Player(Map &m,Graphics &g) : Sprite(m,g) { StartPos(); }
        int Move(void);
    protected:
        virtual void Junction(int x,int y);
        void StartPos(void) { x = y = 1;while (map.Read(x,y) == 0) x++; x = x << 8;y = y << 8; }
};

class Chaser : public Sprite
{
    public:
        Chaser(Map &m,Graphics &g) : Sprite(m,g) { FindStart();FailValidityCheck(); }
    protected:
        void FindStart(void);
        virtual void Junction(int x,int y);
        virtual int GetGraphic(void);
        virtual void FailValidityCheck(void);
};

class Game
{
    public:
        Game(Map &m,Graphics &g,Surface &s) : map(m), graphics(g),surface(s) { }
        int Run(int Speed,int Level,int Chasers);
        void ResetScore(void) { Score = 0; }
        void GameOver(void);
        void LevelOver(int Time,int Colour);
        int  GetScore(void) { return Score; }
    protected:
        void DrawScore(int yc,char *Text,int Num);
    private:
        Map &map;
        Graphics &graphics;
        Surface &surface;
        int Score;
};

class MenuObject
{
    public:
        MenuObject(int y,char *opts);
        void Paint(void);
        int Click(int x,int y);
        int Get(void) { return selected; }
    protected:
        void GetItem(char *buffer,int selected);
    private:
        Rect rc;
        char *Options;
        int selected;
        int selcount;
};
