// Code generated by pigeon; DO NOT EDIT.

// Package json parses JSON as defined by [1].
//
// BUGS: the escaped forward solidus (`\/`) is not currently handled.
//
// [1]: http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-404.pdf
package json

import (
	"bytes"
	"errors"
	"fmt"
	"io"
	"io/ioutil"
	"math"
	"os"
	"sort"
	"strconv"
	"strings"
	"unicode"
	"unicode/utf8"
)

func toIfaceSlice(v interface{}) []interface{} {
	if v == nil {
		return nil
	}
	return v.([]interface{})
}

var g = &grammar{
	rules: []*rule{
		{
			name: "JSON",
			pos:  position{line: 17, col: 1, offset: 347},
			expr: &actionExpr{
				pos: position{line: 17, col: 8, offset: 356},
				run: (*parser).callonJSON1,
				expr: &seqExpr{
					pos: position{line: 17, col: 8, offset: 356},
					exprs: []interface{}{
						&ruleRefExpr{
							pos:  position{line: 17, col: 8, offset: 356},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 17, col: 10, offset: 358},
							label: "val",
							expr: &ruleRefExpr{
								pos:  position{line: 17, col: 14, offset: 362},
								name: "Value",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 17, col: 20, offset: 368},
							name: "EOF",
						},
					},
				},
			},
		},
		{
			name: "Value",
			pos:  position{line: 21, col: 1, offset: 397},
			expr: &actionExpr{
				pos: position{line: 21, col: 9, offset: 407},
				run: (*parser).callonValue1,
				expr: &seqExpr{
					pos: position{line: 21, col: 9, offset: 407},
					exprs: []interface{}{
						&labeledExpr{
							pos:   position{line: 21, col: 9, offset: 407},
							label: "val",
							expr: &choiceExpr{
								pos: position{line: 21, col: 15, offset: 413},
								alternatives: []interface{}{
									&ruleRefExpr{
										pos:  position{line: 21, col: 15, offset: 413},
										name: "Object",
									},
									&ruleRefExpr{
										pos:  position{line: 21, col: 24, offset: 422},
										name: "Array",
									},
									&ruleRefExpr{
										pos:  position{line: 21, col: 32, offset: 430},
										name: "Number",
									},
									&ruleRefExpr{
										pos:  position{line: 21, col: 41, offset: 439},
										name: "String",
									},
									&ruleRefExpr{
										pos:  position{line: 21, col: 50, offset: 448},
										name: "Bool",
									},
									&ruleRefExpr{
										pos:  position{line: 21, col: 57, offset: 455},
										name: "Null",
									},
								},
							},
						},
						&ruleRefExpr{
							pos:  position{line: 21, col: 64, offset: 462},
							name: "_",
						},
					},
				},
			},
		},
		{
			name: "Object",
			pos:  position{line: 25, col: 1, offset: 489},
			expr: &actionExpr{
				pos: position{line: 25, col: 10, offset: 500},
				run: (*parser).callonObject1,
				expr: &seqExpr{
					pos: position{line: 25, col: 10, offset: 500},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 25, col: 10, offset: 500},
							val:        "{",
							ignoreCase: false,
							want:       "\"{\"",
						},
						&ruleRefExpr{
							pos:  position{line: 25, col: 14, offset: 504},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 25, col: 16, offset: 506},
							label: "vals",
							expr: &zeroOrOneExpr{
								pos: position{line: 25, col: 21, offset: 511},
								expr: &seqExpr{
									pos: position{line: 25, col: 23, offset: 513},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 25, col: 23, offset: 513},
											name: "String",
										},
										&ruleRefExpr{
											pos:  position{line: 25, col: 30, offset: 520},
											name: "_",
										},
										&litMatcher{
											pos:        position{line: 25, col: 32, offset: 522},
											val:        ":",
											ignoreCase: false,
											want:       "\":\"",
										},
										&ruleRefExpr{
											pos:  position{line: 25, col: 36, offset: 526},
											name: "_",
										},
										&ruleRefExpr{
											pos:  position{line: 25, col: 38, offset: 528},
											name: "Value",
										},
										&zeroOrMoreExpr{
											pos: position{line: 25, col: 44, offset: 534},
											expr: &seqExpr{
												pos: position{line: 25, col: 46, offset: 536},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 25, col: 46, offset: 536},
														val:        ",",
														ignoreCase: false,
														want:       "\",\"",
													},
													&ruleRefExpr{
														pos:  position{line: 25, col: 50, offset: 540},
														name: "_",
													},
													&ruleRefExpr{
														pos:  position{line: 25, col: 52, offset: 542},
														name: "String",
													},
													&ruleRefExpr{
														pos:  position{line: 25, col: 59, offset: 549},
														name: "_",
													},
													&litMatcher{
														pos:        position{line: 25, col: 61, offset: 551},
														val:        ":",
														ignoreCase: false,
														want:       "\":\"",
													},
													&ruleRefExpr{
														pos:  position{line: 25, col: 65, offset: 555},
														name: "_",
													},
													&ruleRefExpr{
														pos:  position{line: 25, col: 67, offset: 557},
														name: "Value",
													},
												},
											},
										},
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 25, col: 79, offset: 569},
							val:        "}",
							ignoreCase: false,
							want:       "\"}\"",
						},
					},
				},
			},
		},
		{
			name: "Array",
			pos:  position{line: 40, col: 1, offset: 911},
			expr: &actionExpr{
				pos: position{line: 40, col: 9, offset: 921},
				run: (*parser).callonArray1,
				expr: &seqExpr{
					pos: position{line: 40, col: 9, offset: 921},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 40, col: 9, offset: 921},
							val:        "[",
							ignoreCase: false,
							want:       "\"[\"",
						},
						&ruleRefExpr{
							pos:  position{line: 40, col: 13, offset: 925},
							name: "_",
						},
						&labeledExpr{
							pos:   position{line: 40, col: 15, offset: 927},
							label: "vals",
							expr: &zeroOrOneExpr{
								pos: position{line: 40, col: 20, offset: 932},
								expr: &seqExpr{
									pos: position{line: 40, col: 22, offset: 934},
									exprs: []interface{}{
										&ruleRefExpr{
											pos:  position{line: 40, col: 22, offset: 934},
											name: "Value",
										},
										&zeroOrMoreExpr{
											pos: position{line: 40, col: 28, offset: 940},
											expr: &seqExpr{
												pos: position{line: 40, col: 30, offset: 942},
												exprs: []interface{}{
													&litMatcher{
														pos:        position{line: 40, col: 30, offset: 942},
														val:        ",",
														ignoreCase: false,
														want:       "\",\"",
													},
													&ruleRefExpr{
														pos:  position{line: 40, col: 34, offset: 946},
														name: "_",
													},
													&ruleRefExpr{
														pos:  position{line: 40, col: 36, offset: 948},
														name: "Value",
													},
												},
											},
										},
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 40, col: 48, offset: 960},
							val:        "]",
							ignoreCase: false,
							want:       "\"]\"",
						},
					},
				},
			},
		},
		{
			name: "Number",
			pos:  position{line: 54, col: 1, offset: 1266},
			expr: &actionExpr{
				pos: position{line: 54, col: 10, offset: 1277},
				run: (*parser).callonNumber1,
				expr: &seqExpr{
					pos: position{line: 54, col: 10, offset: 1277},
					exprs: []interface{}{
						&zeroOrOneExpr{
							pos: position{line: 54, col: 10, offset: 1277},
							expr: &litMatcher{
								pos:        position{line: 54, col: 10, offset: 1277},
								val:        "-",
								ignoreCase: false,
								want:       "\"-\"",
							},
						},
						&ruleRefExpr{
							pos:  position{line: 54, col: 15, offset: 1282},
							name: "Integer",
						},
						&zeroOrOneExpr{
							pos: position{line: 54, col: 23, offset: 1290},
							expr: &seqExpr{
								pos: position{line: 54, col: 25, offset: 1292},
								exprs: []interface{}{
									&litMatcher{
										pos:        position{line: 54, col: 25, offset: 1292},
										val:        ".",
										ignoreCase: false,
										want:       "\".\"",
									},
									&oneOrMoreExpr{
										pos: position{line: 54, col: 29, offset: 1296},
										expr: &ruleRefExpr{
											pos:  position{line: 54, col: 29, offset: 1296},
											name: "DecimalDigit",
										},
									},
								},
							},
						},
						&zeroOrOneExpr{
							pos: position{line: 54, col: 46, offset: 1313},
							expr: &ruleRefExpr{
								pos:  position{line: 54, col: 46, offset: 1313},
								name: "Exponent",
							},
						},
					},
				},
			},
		},
		{
			name: "Integer",
			pos:  position{line: 60, col: 1, offset: 1468},
			expr: &choiceExpr{
				pos: position{line: 60, col: 11, offset: 1480},
				alternatives: []interface{}{
					&litMatcher{
						pos:        position{line: 60, col: 11, offset: 1480},
						val:        "0",
						ignoreCase: false,
						want:       "\"0\"",
					},
					&seqExpr{
						pos: position{line: 60, col: 17, offset: 1486},
						exprs: []interface{}{
							&ruleRefExpr{
								pos:  position{line: 60, col: 17, offset: 1486},
								name: "NonZeroDecimalDigit",
							},
							&zeroOrMoreExpr{
								pos: position{line: 60, col: 37, offset: 1506},
								expr: &ruleRefExpr{
									pos:  position{line: 60, col: 37, offset: 1506},
									name: "DecimalDigit",
								},
							},
						},
					},
				},
			},
		},
		{
			name: "Exponent",
			pos:  position{line: 62, col: 1, offset: 1521},
			expr: &seqExpr{
				pos: position{line: 62, col: 12, offset: 1534},
				exprs: []interface{}{
					&litMatcher{
						pos:        position{line: 62, col: 12, offset: 1534},
						val:        "e",
						ignoreCase: true,
						want:       "\"e\"i",
					},
					&zeroOrOneExpr{
						pos: position{line: 62, col: 17, offset: 1539},
						expr: &charClassMatcher{
							pos:             position{line: 62, col: 17, offset: 1539},
							val:             "[+-]",
							chars:           []rune{'+', '-'},
							basicLatinChars: [128]bool{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false},
							ignoreCase:      false,
							inverted:        false,
						},
					},
					&oneOrMoreExpr{
						pos: position{line: 62, col: 23, offset: 1545},
						expr: &ruleRefExpr{
							pos:  position{line: 62, col: 23, offset: 1545},
							name: "DecimalDigit",
						},
					},
				},
			},
		},
		{
			name: "String",
			pos:  position{line: 64, col: 1, offset: 1560},
			expr: &actionExpr{
				pos: position{line: 64, col: 10, offset: 1571},
				run: (*parser).callonString1,
				expr: &seqExpr{
					pos: position{line: 64, col: 10, offset: 1571},
					exprs: []interface{}{
						&litMatcher{
							pos:        position{line: 64, col: 10, offset: 1571},
							val:        "\"",
							ignoreCase: false,
							want:       "\"\\\"\"",
						},
						&zeroOrMoreExpr{
							pos: position{line: 64, col: 14, offset: 1575},
							expr: &choiceExpr{
								pos: position{line: 64, col: 16, offset: 1577},
								alternatives: []interface{}{
									&seqExpr{
										pos: position{line: 64, col: 16, offset: 1577},
										exprs: []interface{}{
											&notExpr{
												pos: position{line: 64, col: 16, offset: 1577},
												expr: &ruleRefExpr{
													pos:  position{line: 64, col: 17, offset: 1578},
													name: "EscapedChar",
												},
											},
											&anyMatcher{
												line: 64, col: 29, offset: 1590,
											},
										},
									},
									&seqExpr{
										pos: position{line: 64, col: 33, offset: 1594},
										exprs: []interface{}{
											&litMatcher{
												pos:        position{line: 64, col: 33, offset: 1594},
												val:        "\\",
												ignoreCase: false,
												want:       "\"\\\\\"",
											},
											&ruleRefExpr{
												pos:  position{line: 64, col: 38, offset: 1599},
												name: "EscapeSequence",
											},
										},
									},
								},
							},
						},
						&litMatcher{
							pos:        position{line: 64, col: 56, offset: 1617},
							val:        "\"",
							ignoreCase: false,
							want:       "\"\\\"\"",
						},
					},
				},
			},
		},
		{
			name: "EscapedChar",
			pos:  position{line: 69, col: 1, offset: 1735},
			expr: &charClassMatcher{
				pos:             position{line: 69, col: 15, offset: 1751},
				val:             "[\\x00-\\x1f\"\\\\]",
				chars:           []rune{'"', '\\'},
				ranges:          []rune{'\x00', '\x1f'},
				basicLatinChars: [128]bool{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false},
				ignoreCase:      false,
				inverted:        false,
			},
		},
		{
			name: "EscapeSequence",
			pos:  position{line: 71, col: 1, offset: 1767},
			expr: &choiceExpr{
				pos: position{line: 71, col: 18, offset: 1786},
				alternatives: []interface{}{
					&ruleRefExpr{
						pos:  position{line: 71, col: 18, offset: 1786},
						name: "SingleCharEscape",
					},
					&ruleRefExpr{
						pos:  position{line: 71, col: 37, offset: 1805},
						name: "UnicodeEscape",
					},
				},
			},
		},
		{
			name: "SingleCharEscape",
			pos:  position{line: 73, col: 1, offset: 1820},
			expr: &charClassMatcher{
				pos:             position{line: 73, col: 20, offset: 1841},
				val:             "[\"\\\\/bfnrt]",
				chars:           []rune{'"', '\\', '/', 'b', 'f', 'n', 'r', 't'},
				basicLatinChars: [128]bool{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false},
				ignoreCase:      false,
				inverted:        false,
			},
		},
		{
			name: "UnicodeEscape",
			pos:  position{line: 75, col: 1, offset: 1854},
			expr: &seqExpr{
				pos: position{line: 75, col: 17, offset: 1872},
				exprs: []interface{}{
					&litMatcher{
						pos:        position{line: 75, col: 17, offset: 1872},
						val:        "u",
						ignoreCase: false,
						want:       "\"u\"",
					},
					&ruleRefExpr{
						pos:  position{line: 75, col: 21, offset: 1876},
						name: "HexDigit",
					},
					&ruleRefExpr{
						pos:  position{line: 75, col: 30, offset: 1885},
						name: "HexDigit",
					},
					&ruleRefExpr{
						pos:  position{line: 75, col: 39, offset: 1894},
						name: "HexDigit",
					},
					&ruleRefExpr{
						pos:  position{line: 75, col: 48, offset: 1903},
						name: "HexDigit",
					},
				},
			},
		},
		{
			name: "DecimalDigit",
			pos:  position{line: 77, col: 1, offset: 1913},
			expr: &charClassMatcher{
				pos:             position{line: 77, col: 16, offset: 1930},
				val:             "[0-9]",
				ranges:          []rune{'0', '9'},
				basicLatinChars: [128]bool{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false},
				ignoreCase:      false,
				inverted:        false,
			},
		},
		{
			name: "NonZeroDecimalDigit",
			pos:  position{line: 79, col: 1, offset: 1937},
			expr: &charClassMatcher{
				pos:             position{line: 79, col: 23, offset: 1961},
				val:             "[1-9]",
				ranges:          []rune{'1', '9'},
				basicLatinChars: [128]bool{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false},
				ignoreCase:      false,
				inverted:        false,
			},
		},
		{
			name: "HexDigit",
			pos:  position{line: 81, col: 1, offset: 1968},
			expr: &charClassMatcher{
				pos:             position{line: 81, col: 12, offset: 1981},
				val:             "[0-9a-f]i",
				ranges:          []rune{'0', '9', 'a', 'f'},
				basicLatinChars: [128]bool{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false},
				ignoreCase:      true,
				inverted:        false,
			},
		},
		{
			name: "Bool",
			pos:  position{line: 83, col: 1, offset: 1992},
			expr: &choiceExpr{
				pos: position{line: 83, col: 8, offset: 2001},
				alternatives: []interface{}{
					&actionExpr{
						pos: position{line: 83, col: 8, offset: 2001},
						run: (*parser).callonBool2,
						expr: &litMatcher{
							pos:        position{line: 83, col: 8, offset: 2001},
							val:        "true",
							ignoreCase: false,
							want:       "\"true\"",
						},
					},
					&actionExpr{
						pos: position{line: 83, col: 38, offset: 2031},
						run: (*parser).callonBool4,
						expr: &litMatcher{
							pos:        position{line: 83, col: 38, offset: 2031},
							val:        "false",
							ignoreCase: false,
							want:       "\"false\"",
						},
					},
				},
			},
		},
		{
			name: "Null",
			pos:  position{line: 85, col: 1, offset: 2062},
			expr: &actionExpr{
				pos: position{line: 85, col: 8, offset: 2071},
				run: (*parser).callonNull1,
				expr: &litMatcher{
					pos:        position{line: 85, col: 8, offset: 2071},
					val:        "null",
					ignoreCase: false,
					want:       "\"null\"",
				},
			},
		},
		{
			name:        "_",
			displayName: "\"whitespace\"",
			pos:         position{line: 87, col: 1, offset: 2099},
			expr: &zeroOrMoreExpr{
				pos: position{line: 87, col: 18, offset: 2118},
				expr: &charClassMatcher{
					pos:             position{line: 87, col: 18, offset: 2118},
					val:             "[ \\t\\r\\n]",
					chars:           []rune{' ', '\t', '\r', '\n'},
					basicLatinChars: [128]bool{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false},
					ignoreCase:      false,
					inverted:        false,
				},
			},
		},
		{
			name: "EOF",
			pos:  position{line: 89, col: 1, offset: 2130},
			expr: &notExpr{
				pos: position{line: 89, col: 7, offset: 2138},
				expr: &anyMatcher{
					line: 89, col: 8, offset: 2139,
				},
			},
		},
	},
}

func (c *current) onJSON1(val interface{}) (interface{}, error) {
	return val, nil
}

func (p *parser) callonJSON1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onJSON1(stack["val"])
}

func (c *current) onValue1(val interface{}) (interface{}, error) {
	return val, nil
}

func (p *parser) callonValue1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onValue1(stack["val"])
}

func (c *current) onObject1(vals interface{}) (interface{}, error) {
	res := make(map[string]interface{})
	valsSl := toIfaceSlice(vals)
	if len(valsSl) == 0 {
		return res, nil
	}
	res[valsSl[0].(string)] = valsSl[4]
	restSl := toIfaceSlice(valsSl[5])
	for _, v := range restSl {
		vSl := toIfaceSlice(v)
		res[vSl[2].(string)] = vSl[6]
	}
	return res, nil
}

func (p *parser) callonObject1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onObject1(stack["vals"])
}

func (c *current) onArray1(vals interface{}) (interface{}, error) {
	valsSl := toIfaceSlice(vals)
	if len(valsSl) == 0 {
		return []interface{}{}, nil
	}
	res := []interface{}{valsSl[0]}
	restSl := toIfaceSlice(valsSl[1])
	for _, v := range restSl {
		vSl := toIfaceSlice(v)
		res = append(res, vSl[2])
	}
	return res, nil
}

func (p *parser) callonArray1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onArray1(stack["vals"])
}

func (c *current) onNumber1() (interface{}, error) {
	// JSON numbers have the same syntax as Go's, and are parseable using
	// strconv.
	return strconv.ParseFloat(string(c.text), 64)
}

func (p *parser) callonNumber1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNumber1()
}

func (c *current) onString1() (interface{}, error) {
	c.text = bytes.Replace(c.text, []byte(`\/`), []byte(`/`), -1)
	return strconv.Unquote(string(c.text))
}

func (p *parser) callonString1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onString1()
}

func (c *current) onBool2() (interface{}, error) {
	return true, nil
}

func (p *parser) callonBool2() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onBool2()
}

func (c *current) onBool4() (interface{}, error) {
	return false, nil
}

func (p *parser) callonBool4() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onBool4()
}

func (c *current) onNull1() (interface{}, error) {
	return nil, nil
}

func (p *parser) callonNull1() (interface{}, error) {
	stack := p.vstack[len(p.vstack)-1]
	_ = stack
	return p.cur.onNull1()
}

var (
	// errNoRule is returned when the grammar to parse has no rule.
	errNoRule = errors.New("grammar has no rule")

	// errInvalidEntrypoint is returned when the specified entrypoint rule
	// does not exit.
	errInvalidEntrypoint = errors.New("invalid entrypoint")

	// errInvalidEncoding is returned when the source is not properly
	// utf8-encoded.
	errInvalidEncoding = errors.New("invalid encoding")

	// errMaxExprCnt is used to signal that the maximum number of
	// expressions have been parsed.
	errMaxExprCnt = errors.New("max number of expresssions parsed")
)

// Option is a function that can set an option on the parser. It returns
// the previous setting as an Option.
type Option func(*parser) Option

// MaxExpressions creates an Option to stop parsing after the provided
// number of expressions have been parsed, if the value is 0 then the parser will
// parse for as many steps as needed (possibly an infinite number).
//
// The default for maxExprCnt is 0.
func MaxExpressions(maxExprCnt uint64) Option {
	return func(p *parser) Option {
		oldMaxExprCnt := p.maxExprCnt
		p.maxExprCnt = maxExprCnt
		return MaxExpressions(oldMaxExprCnt)
	}
}

// Entrypoint creates an Option to set the rule name to use as entrypoint.
// The rule name must have been specified in the -alternate-entrypoints
// if generating the parser with the -optimize-grammar flag, otherwise
// it may have been optimized out. Passing an empty string sets the
// entrypoint to the first rule in the grammar.
//
// The default is to start parsing at the first rule in the grammar.
func Entrypoint(ruleName string) Option {
	return func(p *parser) Option {
		oldEntrypoint := p.entrypoint
		p.entrypoint = ruleName
		if ruleName == "" {
			p.entrypoint = g.rules[0].name
		}
		return Entrypoint(oldEntrypoint)
	}
}

// AllowInvalidUTF8 creates an Option to allow invalid UTF-8 bytes.
// Every invalid UTF-8 byte is treated as a utf8.RuneError (U+FFFD)
// by character class matchers and is matched by the any matcher.
// The returned matched value, c.text and c.offset are NOT affected.
//
// The default is false.
func AllowInvalidUTF8(b bool) Option {
	return func(p *parser) Option {
		old := p.allowInvalidUTF8
		p.allowInvalidUTF8 = b
		return AllowInvalidUTF8(old)
	}
}

// Recover creates an Option to set the recover flag to b. When set to
// true, this causes the parser to recover from panics and convert it
// to an error. Setting it to false can be useful while debugging to
// access the full stack trace.
//
// The default is true.
func Recover(b bool) Option {
	return func(p *parser) Option {
		old := p.recover
		p.recover = b
		return Recover(old)
	}
}

// GlobalStore creates an Option to set a key to a certain value in
// the globalStore.
func GlobalStore(key string, value interface{}) Option {
	return func(p *parser) Option {
		old := p.cur.globalStore[key]
		p.cur.globalStore[key] = value
		return GlobalStore(key, old)
	}
}

// ParseFile parses the file identified by filename.
func ParseFile(filename string, opts ...Option) (i interface{}, err error) { // nolint: deadcode
	f, err := os.Open(filename)
	if err != nil {
		return nil, err
	}
	defer func() {
		if closeErr := f.Close(); closeErr != nil {
			err = closeErr
		}
	}()
	return ParseReader(filename, f, opts...)
}

// ParseReader parses the data from r using filename as information in the
// error messages.
func ParseReader(filename string, r io.Reader, opts ...Option) (interface{}, error) { // nolint: deadcode
	b, err := ioutil.ReadAll(r)
	if err != nil {
		return nil, err
	}

	return Parse(filename, b, opts...)
}

// Parse parses the data from b using filename as information in the
// error messages.
func Parse(filename string, b []byte, opts ...Option) (interface{}, error) {
	return newParser(filename, b, opts...).parse(g)
}

// position records a position in the text.
type position struct {
	line, col, offset int
}

func (p position) String() string {
	return strconv.Itoa(p.line) + ":" + strconv.Itoa(p.col) + " [" + strconv.Itoa(p.offset) + "]"
}

// savepoint stores all state required to go back to this point in the
// parser.
type savepoint struct {
	position
	rn rune
	w  int
}

type current struct {
	pos  position // start position of the match
	text []byte   // raw text of the match

	// globalStore is a general store for the user to store arbitrary key-value
	// pairs that they need to manage and that they do not want tied to the
	// backtracking of the parser. This is only modified by the user and never
	// rolled back by the parser. It is always up to the user to keep this in a
	// consistent state.
	globalStore storeDict
}

type storeDict map[string]interface{}

// the AST types...

// nolint: structcheck
type grammar struct {
	pos   position
	rules []*rule
}

// nolint: structcheck
type rule struct {
	pos         position
	name        string
	displayName string
	expr        interface{}
}

// nolint: structcheck
type choiceExpr struct {
	pos          position
	alternatives []interface{}
}

// nolint: structcheck
type actionExpr struct {
	pos  position
	expr interface{}
	run  func(*parser) (interface{}, error)
}

// nolint: structcheck
type recoveryExpr struct {
	pos          position
	expr         interface{}
	recoverExpr  interface{}
	failureLabel []string
}

// nolint: structcheck
type seqExpr struct {
	pos   position
	exprs []interface{}
}

// nolint: structcheck
type throwExpr struct {
	pos   position
	label string
}

// nolint: structcheck
type labeledExpr struct {
	pos   position
	label string
	expr  interface{}
}

// nolint: structcheck
type expr struct {
	pos  position
	expr interface{}
}

type andExpr expr        // nolint: structcheck
type notExpr expr        // nolint: structcheck
type zeroOrOneExpr expr  // nolint: structcheck
type zeroOrMoreExpr expr // nolint: structcheck
type oneOrMoreExpr expr  // nolint: structcheck

// nolint: structcheck
type ruleRefExpr struct {
	pos  position
	name string
}

// nolint: structcheck
type andCodeExpr struct {
	pos position
	run func(*parser) (bool, error)
}

// nolint: structcheck
type notCodeExpr struct {
	pos position
	run func(*parser) (bool, error)
}

// nolint: structcheck
type litMatcher struct {
	pos        position
	val        string
	ignoreCase bool
	want       string
}

// nolint: structcheck
type charClassMatcher struct {
	pos             position
	val             string
	basicLatinChars [128]bool
	chars           []rune
	ranges          []rune
	classes         []*unicode.RangeTable
	ignoreCase      bool
	inverted        bool
}

type anyMatcher position // nolint: structcheck

// errList cumulates the errors found by the parser.
type errList []error

func (e *errList) add(err error) {
	*e = append(*e, err)
}

func (e errList) err() error {
	if len(e) == 0 {
		return nil
	}
	e.dedupe()
	return e
}

func (e *errList) dedupe() {
	var cleaned []error
	set := make(map[string]bool)
	for _, err := range *e {
		if msg := err.Error(); !set[msg] {
			set[msg] = true
			cleaned = append(cleaned, err)
		}
	}
	*e = cleaned
}

func (e errList) Error() string {
	switch len(e) {
	case 0:
		return ""
	case 1:
		return e[0].Error()
	default:
		var buf bytes.Buffer

		for i, err := range e {
			if i > 0 {
				buf.WriteRune('\n')
			}
			buf.WriteString(err.Error())
		}
		return buf.String()
	}
}

// parserError wraps an error with a prefix indicating the rule in which
// the error occurred. The original error is stored in the Inner field.
type parserError struct {
	Inner    error
	pos      position
	prefix   string
	expected []string
}

// Error returns the error message.
func (p *parserError) Error() string {
	return p.prefix + ": " + p.Inner.Error()
}

// newParser creates a parser with the specified input source and options.
func newParser(filename string, b []byte, opts ...Option) *parser {
	stats := Stats{
		ChoiceAltCnt: make(map[string]map[string]int),
	}

	p := &parser{
		filename: filename,
		errs:     new(errList),
		data:     b,
		pt:       savepoint{position: position{line: 1}},
		recover:  true,
		cur: current{
			globalStore: make(storeDict),
		},
		maxFailPos:      position{col: 1, line: 1},
		maxFailExpected: make([]string, 0, 20),
		Stats:           &stats,
		// start rule is rule [0] unless an alternate entrypoint is specified
		entrypoint: g.rules[0].name,
	}
	p.setOptions(opts)

	if p.maxExprCnt == 0 {
		p.maxExprCnt = math.MaxUint64
	}

	return p
}

// setOptions applies the options to the parser.
func (p *parser) setOptions(opts []Option) {
	for _, opt := range opts {
		opt(p)
	}
}

// nolint: structcheck,deadcode
type resultTuple struct {
	v   interface{}
	b   bool
	end savepoint
}

// nolint: varcheck
const choiceNoMatch = -1

// Stats stores some statistics, gathered during parsing
type Stats struct {
	// ExprCnt counts the number of expressions processed during parsing
	// This value is compared to the maximum number of expressions allowed
	// (set by the MaxExpressions option).
	ExprCnt uint64

	// ChoiceAltCnt is used to count for each ordered choice expression,
	// which alternative is used how may times.
	// These numbers allow to optimize the order of the ordered choice expression
	// to increase the performance of the parser
	//
	// The outer key of ChoiceAltCnt is composed of the name of the rule as well
	// as the line and the column of the ordered choice.
	// The inner key of ChoiceAltCnt is the number (one-based) of the matching alternative.
	// For each alternative the number of matches are counted. If an ordered choice does not
	// match, a special counter is incremented. The name of this counter is set with
	// the parser option Statistics.
	// For an alternative to be included in ChoiceAltCnt, it has to match at least once.
	ChoiceAltCnt map[string]map[string]int
}

// nolint: structcheck,maligned
type parser struct {
	filename string
	pt       savepoint
	cur      current

	data []byte
	errs *errList

	depth   int
	recover bool

	// rules table, maps the rule identifier to the rule node
	rules map[string]*rule
	// variables stack, map of label to value
	vstack []map[string]interface{}
	// rule stack, allows identification of the current rule in errors
	rstack []*rule

	// parse fail
	maxFailPos            position
	maxFailExpected       []string
	maxFailInvertExpected bool

	// max number of expressions to be parsed
	maxExprCnt uint64
	// entrypoint for the parser
	entrypoint string

	allowInvalidUTF8 bool

	*Stats

	choiceNoMatch string
	// recovery expression stack, keeps track of the currently available recovery expression, these are traversed in reverse
	recoveryStack []map[string]interface{}
}

// push a variable set on the vstack.
func (p *parser) pushV() {
	if cap(p.vstack) == len(p.vstack) {
		// create new empty slot in the stack
		p.vstack = append(p.vstack, nil)
	} else {
		// slice to 1 more
		p.vstack = p.vstack[:len(p.vstack)+1]
	}

	// get the last args set
	m := p.vstack[len(p.vstack)-1]
	if m != nil && len(m) == 0 {
		// empty map, all good
		return
	}

	m = make(map[string]interface{})
	p.vstack[len(p.vstack)-1] = m
}

// pop a variable set from the vstack.
func (p *parser) popV() {
	// if the map is not empty, clear it
	m := p.vstack[len(p.vstack)-1]
	if len(m) > 0 {
		// GC that map
		p.vstack[len(p.vstack)-1] = nil
	}
	p.vstack = p.vstack[:len(p.vstack)-1]
}

// push a recovery expression with its labels to the recoveryStack
func (p *parser) pushRecovery(labels []string, expr interface{}) {
	if cap(p.recoveryStack) == len(p.recoveryStack) {
		// create new empty slot in the stack
		p.recoveryStack = append(p.recoveryStack, nil)
	} else {
		// slice to 1 more
		p.recoveryStack = p.recoveryStack[:len(p.recoveryStack)+1]
	}

	m := make(map[string]interface{}, len(labels))
	for _, fl := range labels {
		m[fl] = expr
	}
	p.recoveryStack[len(p.recoveryStack)-1] = m
}

// pop a recovery expression from the recoveryStack
func (p *parser) popRecovery() {
	// GC that map
	p.recoveryStack[len(p.recoveryStack)-1] = nil

	p.recoveryStack = p.recoveryStack[:len(p.recoveryStack)-1]
}

func (p *parser) addErr(err error) {
	p.addErrAt(err, p.pt.position, []string{})
}

func (p *parser) addErrAt(err error, pos position, expected []string) {
	var buf bytes.Buffer
	if p.filename != "" {
		buf.WriteString(p.filename)
	}
	if buf.Len() > 0 {
		buf.WriteString(":")
	}
	buf.WriteString(fmt.Sprintf("%d:%d (%d)", pos.line, pos.col, pos.offset))
	if len(p.rstack) > 0 {
		if buf.Len() > 0 {
			buf.WriteString(": ")
		}
		rule := p.rstack[len(p.rstack)-1]
		if rule.displayName != "" {
			buf.WriteString("rule " + rule.displayName)
		} else {
			buf.WriteString("rule " + rule.name)
		}
	}
	pe := &parserError{Inner: err, pos: pos, prefix: buf.String(), expected: expected}
	p.errs.add(pe)
}

func (p *parser) failAt(fail bool, pos position, want string) {
	// process fail if parsing fails and not inverted or parsing succeeds and invert is set
	if fail == p.maxFailInvertExpected {
		if pos.offset < p.maxFailPos.offset {
			return
		}

		if pos.offset > p.maxFailPos.offset {
			p.maxFailPos = pos
			p.maxFailExpected = p.maxFailExpected[:0]
		}

		if p.maxFailInvertExpected {
			want = "!" + want
		}
		p.maxFailExpected = append(p.maxFailExpected, want)
	}
}

// read advances the parser to the next rune.
func (p *parser) read() {
	p.pt.offset += p.pt.w
	rn, n := utf8.DecodeRune(p.data[p.pt.offset:])
	p.pt.rn = rn
	p.pt.w = n
	p.pt.col++
	if rn == '\n' {
		p.pt.line++
		p.pt.col = 0
	}

	if rn == utf8.RuneError && n == 1 { // see utf8.DecodeRune
		if !p.allowInvalidUTF8 {
			p.addErr(errInvalidEncoding)
		}
	}
}

// restore parser position to the savepoint pt.
func (p *parser) restore(pt savepoint) {
	if pt.offset == p.pt.offset {
		return
	}
	p.pt = pt
}

// get the slice of bytes from the savepoint start to the current position.
func (p *parser) sliceFrom(start savepoint) []byte {
	return p.data[start.position.offset:p.pt.position.offset]
}

func (p *parser) buildRulesTable(g *grammar) {
	p.rules = make(map[string]*rule, len(g.rules))
	for _, r := range g.rules {
		p.rules[r.name] = r
	}
}

// nolint: gocyclo
func (p *parser) parse(g *grammar) (val interface{}, err error) {
	if len(g.rules) == 0 {
		p.addErr(errNoRule)
		return nil, p.errs.err()
	}

	// TODO : not super critical but this could be generated
	p.buildRulesTable(g)

	if p.recover {
		// panic can be used in action code to stop parsing immediately
		// and return the panic as an error.
		defer func() {
			if e := recover(); e != nil {
				val = nil
				switch e := e.(type) {
				case error:
					p.addErr(e)
				default:
					p.addErr(fmt.Errorf("%v", e))
				}
				err = p.errs.err()
			}
		}()
	}

	startRule, ok := p.rules[p.entrypoint]
	if !ok {
		p.addErr(errInvalidEntrypoint)
		return nil, p.errs.err()
	}

	p.read() // advance to first rune
	val, ok = p.parseRule(startRule)
	if !ok {
		if len(*p.errs) == 0 {
			// If parsing fails, but no errors have been recorded, the expected values
			// for the farthest parser position are returned as error.
			maxFailExpectedMap := make(map[string]struct{}, len(p.maxFailExpected))
			for _, v := range p.maxFailExpected {
				maxFailExpectedMap[v] = struct{}{}
			}
			expected := make([]string, 0, len(maxFailExpectedMap))
			eof := false
			if _, ok := maxFailExpectedMap["!."]; ok {
				delete(maxFailExpectedMap, "!.")
				eof = true
			}
			for k := range maxFailExpectedMap {
				expected = append(expected, k)
			}
			sort.Strings(expected)
			if eof {
				expected = append(expected, "EOF")
			}
			p.addErrAt(errors.New("no match found, expected: "+listJoin(expected, ", ", "or")), p.maxFailPos, expected)
		}

		return nil, p.errs.err()
	}
	return val, p.errs.err()
}

func listJoin(list []string, sep string, lastSep string) string {
	switch len(list) {
	case 0:
		return ""
	case 1:
		return list[0]
	default:
		return strings.Join(list[:len(list)-1], sep) + " " + lastSep + " " + list[len(list)-1]
	}
}

func (p *parser) parseRule(rule *rule) (interface{}, bool) {
	p.rstack = append(p.rstack, rule)
	p.pushV()
	val, ok := p.parseExpr(rule.expr)
	p.popV()
	p.rstack = p.rstack[:len(p.rstack)-1]
	return val, ok
}

// nolint: gocyclo
func (p *parser) parseExpr(expr interface{}) (interface{}, bool) {

	p.ExprCnt++
	if p.ExprCnt > p.maxExprCnt {
		panic(errMaxExprCnt)
	}

	var val interface{}
	var ok bool
	switch expr := expr.(type) {
	case *actionExpr:
		val, ok = p.parseActionExpr(expr)
	case *andCodeExpr:
		val, ok = p.parseAndCodeExpr(expr)
	case *andExpr:
		val, ok = p.parseAndExpr(expr)
	case *anyMatcher:
		val, ok = p.parseAnyMatcher(expr)
	case *charClassMatcher:
		val, ok = p.parseCharClassMatcher(expr)
	case *choiceExpr:
		val, ok = p.parseChoiceExpr(expr)
	case *labeledExpr:
		val, ok = p.parseLabeledExpr(expr)
	case *litMatcher:
		val, ok = p.parseLitMatcher(expr)
	case *notCodeExpr:
		val, ok = p.parseNotCodeExpr(expr)
	case *notExpr:
		val, ok = p.parseNotExpr(expr)
	case *oneOrMoreExpr:
		val, ok = p.parseOneOrMoreExpr(expr)
	case *recoveryExpr:
		val, ok = p.parseRecoveryExpr(expr)
	case *ruleRefExpr:
		val, ok = p.parseRuleRefExpr(expr)
	case *seqExpr:
		val, ok = p.parseSeqExpr(expr)
	case *throwExpr:
		val, ok = p.parseThrowExpr(expr)
	case *zeroOrMoreExpr:
		val, ok = p.parseZeroOrMoreExpr(expr)
	case *zeroOrOneExpr:
		val, ok = p.parseZeroOrOneExpr(expr)
	default:
		panic(fmt.Sprintf("unknown expression type %T", expr))
	}
	return val, ok
}

func (p *parser) parseActionExpr(act *actionExpr) (interface{}, bool) {
	start := p.pt
	val, ok := p.parseExpr(act.expr)
	if ok {
		p.cur.pos = start.position
		p.cur.text = p.sliceFrom(start)
		actVal, err := act.run(p)
		if err != nil {
			p.addErrAt(err, start.position, []string{})
		}

		val = actVal
	}
	return val, ok
}

func (p *parser) parseAndCodeExpr(and *andCodeExpr) (interface{}, bool) {

	ok, err := and.run(p)
	if err != nil {
		p.addErr(err)
	}

	return nil, ok
}

func (p *parser) parseAndExpr(and *andExpr) (interface{}, bool) {
	pt := p.pt
	p.pushV()
	_, ok := p.parseExpr(and.expr)
	p.popV()
	p.restore(pt)

	return nil, ok
}

func (p *parser) parseAnyMatcher(any *anyMatcher) (interface{}, bool) {
	if p.pt.rn == utf8.RuneError && p.pt.w == 0 {
		// EOF - see utf8.DecodeRune
		p.failAt(false, p.pt.position, ".")
		return nil, false
	}
	start := p.pt
	p.read()
	p.failAt(true, start.position, ".")
	return p.sliceFrom(start), true
}

// nolint: gocyclo
func (p *parser) parseCharClassMatcher(chr *charClassMatcher) (interface{}, bool) {
	cur := p.pt.rn
	start := p.pt

	if cur < 128 {
		if chr.basicLatinChars[cur] != chr.inverted {
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
		p.failAt(false, start.position, chr.val)
		return nil, false
	}

	// can't match EOF
	if cur == utf8.RuneError && p.pt.w == 0 { // see utf8.DecodeRune
		p.failAt(false, start.position, chr.val)
		return nil, false
	}

	if chr.ignoreCase {
		cur = unicode.ToLower(cur)
	}

	// try to match in the list of available chars
	for _, rn := range chr.chars {
		if rn == cur {
			if chr.inverted {
				p.failAt(false, start.position, chr.val)
				return nil, false
			}
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
	}

	// try to match in the list of ranges
	for i := 0; i < len(chr.ranges); i += 2 {
		if cur >= chr.ranges[i] && cur <= chr.ranges[i+1] {
			if chr.inverted {
				p.failAt(false, start.position, chr.val)
				return nil, false
			}
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
	}

	// try to match in the list of Unicode classes
	for _, cl := range chr.classes {
		if unicode.Is(cl, cur) {
			if chr.inverted {
				p.failAt(false, start.position, chr.val)
				return nil, false
			}
			p.read()
			p.failAt(true, start.position, chr.val)
			return p.sliceFrom(start), true
		}
	}

	if chr.inverted {
		p.read()
		p.failAt(true, start.position, chr.val)
		return p.sliceFrom(start), true
	}
	p.failAt(false, start.position, chr.val)
	return nil, false
}

func (p *parser) parseChoiceExpr(ch *choiceExpr) (interface{}, bool) {
	for altI, alt := range ch.alternatives {
		// dummy assignment to prevent compile error if optimized
		_ = altI

		p.pushV()
		val, ok := p.parseExpr(alt)
		p.popV()
		if ok {
			return val, ok
		}
	}
	return nil, false
}

func (p *parser) parseLabeledExpr(lab *labeledExpr) (interface{}, bool) {
	p.pushV()
	val, ok := p.parseExpr(lab.expr)
	p.popV()
	if ok && lab.label != "" {
		m := p.vstack[len(p.vstack)-1]
		m[lab.label] = val
	}
	return val, ok
}

func (p *parser) parseLitMatcher(lit *litMatcher) (interface{}, bool) {
	start := p.pt
	for _, want := range lit.val {
		cur := p.pt.rn
		if lit.ignoreCase {
			cur = unicode.ToLower(cur)
		}
		if cur != want {
			p.failAt(false, start.position, lit.want)
			p.restore(start)
			return nil, false
		}
		p.read()
	}
	p.failAt(true, start.position, lit.want)
	return p.sliceFrom(start), true
}

func (p *parser) parseNotCodeExpr(not *notCodeExpr) (interface{}, bool) {
	ok, err := not.run(p)
	if err != nil {
		p.addErr(err)
	}

	return nil, !ok
}

func (p *parser) parseNotExpr(not *notExpr) (interface{}, bool) {
	pt := p.pt
	p.pushV()
	p.maxFailInvertExpected = !p.maxFailInvertExpected
	_, ok := p.parseExpr(not.expr)
	p.maxFailInvertExpected = !p.maxFailInvertExpected
	p.popV()
	p.restore(pt)

	return nil, !ok
}

func (p *parser) parseOneOrMoreExpr(expr *oneOrMoreExpr) (interface{}, bool) {
	var vals []interface{}

	for {
		p.pushV()
		val, ok := p.parseExpr(expr.expr)
		p.popV()
		if !ok {
			if len(vals) == 0 {
				// did not match once, no match
				return nil, false
			}
			return vals, true
		}
		vals = append(vals, val)
	}
}

func (p *parser) parseRecoveryExpr(recover *recoveryExpr) (interface{}, bool) {

	p.pushRecovery(recover.failureLabel, recover.recoverExpr)
	val, ok := p.parseExpr(recover.expr)
	p.popRecovery()

	return val, ok
}

func (p *parser) parseRuleRefExpr(ref *ruleRefExpr) (interface{}, bool) {
	if ref.name == "" {
		panic(fmt.Sprintf("%s: invalid rule: missing name", ref.pos))
	}

	rule := p.rules[ref.name]
	if rule == nil {
		p.addErr(fmt.Errorf("undefined rule: %s", ref.name))
		return nil, false
	}
	return p.parseRule(rule)
}

func (p *parser) parseSeqExpr(seq *seqExpr) (interface{}, bool) {
	vals := make([]interface{}, 0, len(seq.exprs))

	pt := p.pt
	for _, expr := range seq.exprs {
		val, ok := p.parseExpr(expr)
		if !ok {
			p.restore(pt)
			return nil, false
		}
		vals = append(vals, val)
	}
	return vals, true
}

func (p *parser) parseThrowExpr(expr *throwExpr) (interface{}, bool) {

	for i := len(p.recoveryStack) - 1; i >= 0; i-- {
		if recoverExpr, ok := p.recoveryStack[i][expr.label]; ok {
			if val, ok := p.parseExpr(recoverExpr); ok {
				return val, ok
			}
		}
	}

	return nil, false
}

func (p *parser) parseZeroOrMoreExpr(expr *zeroOrMoreExpr) (interface{}, bool) {
	var vals []interface{}

	for {
		p.pushV()
		val, ok := p.parseExpr(expr.expr)
		p.popV()
		if !ok {
			return vals, true
		}
		vals = append(vals, val)
	}
}

func (p *parser) parseZeroOrOneExpr(expr *zeroOrOneExpr) (interface{}, bool) {
	p.pushV()
	val, _ := p.parseExpr(expr.expr)
	p.popV()
	// whether it matched or not, consider it a match
	return val, true
}
