//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfarray?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct CGPDFArray {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFArray {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("CGPDFArray", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfarrayref?language=objc)
pub type CGPDFArrayRef = *mut CGPDFArray;

impl CGPDFArray {
    /// # Safety
    ///
    /// `array` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetCount")]
    #[inline]
    pub unsafe fn count(array: CGPDFArrayRef) -> usize {
        extern "C-unwind" {
            fn CGPDFArrayGetCount(array: CGPDFArrayRef) -> usize;
        }
        unsafe { CGPDFArrayGetCount(array) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetObject")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn object(array: CGPDFArrayRef, index: usize, value: *mut CGPDFObjectRef) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetObject(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFObjectRef,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetObject(array, index, value) }
    }

    /// # Safety
    ///
    /// `array` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetNull")]
    #[inline]
    pub unsafe fn null(array: CGPDFArrayRef, index: usize) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetNull(array: CGPDFArrayRef, index: usize) -> bool;
        }
        unsafe { CGPDFArrayGetNull(array, index) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetBoolean")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn boolean(array: CGPDFArrayRef, index: usize, value: *mut CGPDFBoolean) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetBoolean(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFBoolean,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetBoolean(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetInteger")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn integer(array: CGPDFArrayRef, index: usize, value: *mut CGPDFInteger) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetInteger(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFInteger,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetInteger(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetNumber")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn number(array: CGPDFArrayRef, index: usize, value: *mut CGPDFReal) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetNumber(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFReal,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetNumber(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetName")]
    #[inline]
    pub unsafe fn name(array: CGPDFArrayRef, index: usize, value: *mut *const c_char) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetName(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut *const c_char,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetName(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetString")]
    #[cfg(feature = "CGPDFString")]
    #[inline]
    pub unsafe fn string(array: CGPDFArrayRef, index: usize, value: *mut CGPDFStringRef) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetString(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFStringRef,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetString(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetArray")]
    #[inline]
    pub unsafe fn array(array: CGPDFArrayRef, index: usize, value: *mut CGPDFArrayRef) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetArray(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFArrayRef,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetArray(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetDictionary")]
    #[cfg(feature = "CGPDFDictionary")]
    #[inline]
    pub unsafe fn dictionary(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFDictionaryRef,
    ) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetDictionary(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFDictionaryRef,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetDictionary(array, index, value) }
    }

    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `value` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayGetStream")]
    #[cfg(feature = "CGPDFStream")]
    #[inline]
    pub unsafe fn stream(array: CGPDFArrayRef, index: usize, value: *mut CGPDFStreamRef) -> bool {
        extern "C-unwind" {
            fn CGPDFArrayGetStream(
                array: CGPDFArrayRef,
                index: usize,
                value: *mut CGPDFStreamRef,
            ) -> bool;
        }
        unsafe { CGPDFArrayGetStream(array, index, value) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfarrayapplierblock?language=objc)
#[cfg(all(feature = "CGPDFObject", feature = "block2"))]
pub type CGPDFArrayApplierBlock =
    *mut block2::DynBlock<dyn Fn(usize, CGPDFObjectRef, *mut c_void) -> bool>;

impl CGPDFArray {
    /// # Safety
    ///
    /// - `array` must be a valid pointer or null.
    /// - `block` must be a valid pointer or null.
    /// - `info` must be a valid pointer or null.
    #[doc(alias = "CGPDFArrayApplyBlock")]
    #[cfg(all(feature = "CGPDFObject", feature = "block2"))]
    #[inline]
    pub unsafe fn apply_block(
        array: CGPDFArrayRef,
        block: CGPDFArrayApplierBlock,
        info: *mut c_void,
    ) {
        extern "C-unwind" {
            fn CGPDFArrayApplyBlock(
                array: CGPDFArrayRef,
                block: CGPDFArrayApplierBlock,
                info: *mut c_void,
            );
        }
        unsafe { CGPDFArrayApplyBlock(array, block, info) }
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFArray::count`"]
    pub fn CGPDFArrayGetCount(array: CGPDFArrayRef) -> usize;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFArray::object`"]
    pub fn CGPDFArrayGetObject(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFObjectRef,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFArray::null`"]
    pub fn CGPDFArrayGetNull(array: CGPDFArrayRef, index: usize) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFArray::boolean`"]
    pub fn CGPDFArrayGetBoolean(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFBoolean,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFArray::integer`"]
    pub fn CGPDFArrayGetInteger(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFInteger,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFArray::number`"]
    pub fn CGPDFArrayGetNumber(array: CGPDFArrayRef, index: usize, value: *mut CGPDFReal) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFArray::name`"]
    pub fn CGPDFArrayGetName(array: CGPDFArrayRef, index: usize, value: *mut *const c_char)
        -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFString")]
    #[deprecated = "renamed to `CGPDFArray::string`"]
    pub fn CGPDFArrayGetString(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFStringRef,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFArray::array`"]
    pub fn CGPDFArrayGetArray(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFArrayRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFDictionary")]
    #[deprecated = "renamed to `CGPDFArray::dictionary`"]
    pub fn CGPDFArrayGetDictionary(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFDictionaryRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFStream")]
    #[deprecated = "renamed to `CGPDFArray::stream`"]
    pub fn CGPDFArrayGetStream(
        array: CGPDFArrayRef,
        index: usize,
        value: *mut CGPDFStreamRef,
    ) -> bool;
}

extern "C-unwind" {
    #[cfg(all(feature = "CGPDFObject", feature = "block2"))]
    #[deprecated = "renamed to `CGPDFArray::apply_block`"]
    pub fn CGPDFArrayApplyBlock(
        array: CGPDFArrayRef,
        block: CGPDFArrayApplierBlock,
        info: *mut c_void,
    );
}
