// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server_template

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"
)

// GetServerTemplatesHandlerFunc turns a function with the right signature into a get server templates handler
type GetServerTemplatesHandlerFunc func(GetServerTemplatesParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn GetServerTemplatesHandlerFunc) Handle(params GetServerTemplatesParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// GetServerTemplatesHandler interface for that can handle valid get server templates params
type GetServerTemplatesHandler interface {
	Handle(GetServerTemplatesParams, interface{}) middleware.Responder
}

// NewGetServerTemplates creates a new http.Handler for the get server templates operation
func NewGetServerTemplates(ctx *middleware.Context, handler GetServerTemplatesHandler) *GetServerTemplates {
	return &GetServerTemplates{Context: ctx, Handler: handler}
}

/*
	GetServerTemplates swagger:route GET /services/haproxy/configuration/backends/{parent_name}/server_templates ServerTemplate getServerTemplates

# Return an array of server templates

Returns an array of all server templates that are configured in specified backend.
*/
type GetServerTemplates struct {
	Context *middleware.Context
	Handler GetServerTemplatesHandler
}

func (o *GetServerTemplates) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetServerTemplatesParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
