// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package ring

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateRingCreatedCode is the HTTP code returned for type CreateRingCreated
const CreateRingCreatedCode int = 201

/*
CreateRingCreated Ring created

swagger:response createRingCreated
*/
type CreateRingCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Ring `json:"body,omitempty"`
}

// NewCreateRingCreated creates CreateRingCreated with default headers values
func NewCreateRingCreated() *CreateRingCreated {

	return &CreateRingCreated{}
}

// WithPayload adds the payload to the create ring created response
func (o *CreateRingCreated) WithPayload(payload *models.Ring) *CreateRingCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create ring created response
func (o *CreateRingCreated) SetPayload(payload *models.Ring) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRingCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRingAcceptedCode is the HTTP code returned for type CreateRingAccepted
const CreateRingAcceptedCode int = 202

/*
CreateRingAccepted Configuration change accepted and reload requested

swagger:response createRingAccepted
*/
type CreateRingAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Ring `json:"body,omitempty"`
}

// NewCreateRingAccepted creates CreateRingAccepted with default headers values
func NewCreateRingAccepted() *CreateRingAccepted {

	return &CreateRingAccepted{}
}

// WithReloadID adds the reloadId to the create ring accepted response
func (o *CreateRingAccepted) WithReloadID(reloadID string) *CreateRingAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create ring accepted response
func (o *CreateRingAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create ring accepted response
func (o *CreateRingAccepted) WithPayload(payload *models.Ring) *CreateRingAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create ring accepted response
func (o *CreateRingAccepted) SetPayload(payload *models.Ring) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRingAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRingBadRequestCode is the HTTP code returned for type CreateRingBadRequest
const CreateRingBadRequestCode int = 400

/*
CreateRingBadRequest Bad request

swagger:response createRingBadRequest
*/
type CreateRingBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateRingBadRequest creates CreateRingBadRequest with default headers values
func NewCreateRingBadRequest() *CreateRingBadRequest {

	return &CreateRingBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create ring bad request response
func (o *CreateRingBadRequest) WithConfigurationVersion(configurationVersion string) *CreateRingBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create ring bad request response
func (o *CreateRingBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create ring bad request response
func (o *CreateRingBadRequest) WithPayload(payload *models.Error) *CreateRingBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create ring bad request response
func (o *CreateRingBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRingBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRingConflictCode is the HTTP code returned for type CreateRingConflict
const CreateRingConflictCode int = 409

/*
CreateRingConflict The specified resource already exists

swagger:response createRingConflict
*/
type CreateRingConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateRingConflict creates CreateRingConflict with default headers values
func NewCreateRingConflict() *CreateRingConflict {

	return &CreateRingConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create ring conflict response
func (o *CreateRingConflict) WithConfigurationVersion(configurationVersion string) *CreateRingConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create ring conflict response
func (o *CreateRingConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create ring conflict response
func (o *CreateRingConflict) WithPayload(payload *models.Error) *CreateRingConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create ring conflict response
func (o *CreateRingConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRingConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateRingDefault General Error

swagger:response createRingDefault
*/
type CreateRingDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateRingDefault creates CreateRingDefault with default headers values
func NewCreateRingDefault(code int) *CreateRingDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateRingDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create ring default response
func (o *CreateRingDefault) WithStatusCode(code int) *CreateRingDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create ring default response
func (o *CreateRingDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create ring default response
func (o *CreateRingDefault) WithConfigurationVersion(configurationVersion string) *CreateRingDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create ring default response
func (o *CreateRingDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create ring default response
func (o *CreateRingDefault) WithPayload(payload *models.Error) *CreateRingDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create ring default response
func (o *CreateRingDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRingDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
