#!/usr/bin/env bats
#
# Copyright 2022 HAProxy Technologies
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http:#www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

load '../../libs/dataplaneapi'
load '../../libs/get_json_path'
load '../../libs/haproxy_config_setup'
load '../../libs/haproxy_version'
load '../../libs/resource_client'
load '../../libs/version'

load 'utils/_helpers'

@test "http_error_rules: Add a new HTTP Error Rule to frontend" {
	haproxy_version_ge $_ERR_SUPPORTED_HAPROXY_VERSION || skip "requires HAProxy $_ERR_SUPPORTED_HAPROXY_VERSION+"

	PARENT_NAME="test_frontend"
	resource_post "$_FRONTEND_BASE_PATH/$PARENT_NAME/http_error_rules/0" "data/post.json" "force_reload=true"
	assert_equal "$SC" 201

	resource_get "$_FRONTEND_BASE_PATH/$PARENT_NAME/http_error_rules/0"
	assert_equal "$SC" 200
	assert_equal "$(get_json_path "$BODY" ".status")" 425
}

@test "http_error_rules: Add a new HTTP Error Rule to backend" {
	haproxy_version_ge $_ERR_SUPPORTED_HAPROXY_VERSION || skip "requires HAProxy $_ERR_SUPPORTED_HAPROXY_VERSION+"

	PARENT_NAME="test_backend"
	resource_post "$_BACKEND_BASE_PATH/$PARENT_NAME/http_error_rules/0" "data/post.json" "force_reload=true"
	assert_equal "$SC" 201

	resource_get "$_BACKEND_BASE_PATH/$PARENT_NAME/http_error_rules/0" "parent_type=backend&parent_name=test_backend"
	assert_equal "$SC" 200
	assert_equal "$(get_json_path "$BODY" ".status")" 425
}

@test "http_error_rules: Add a new HTTP Error Rule to defaults" {
	haproxy_version_ge $_ERR_SUPPORTED_HAPROXY_VERSION || skip "requires HAProxy $_ERR_SUPPORTED_HAPROXY_VERSION+"

	PARENT_NAME="mydefaults"
    resource_post "$_DEFAULTS_BASE_PATH/$PARENT_NAME/http_error_rules/0" "data/post.json" "force_reload=true"
	assert_equal "$SC" 201

	resource_get "$_DEFAULTS_BASE_PATH/$PARENT_NAME/http_error_rules/0"
	assert_equal "$SC" 200
	assert_equal "$(get_json_path "$BODY" ".status")" 425
}

@test "http_error_rules: Fail to add a new HTTP Error Rule without status code to backend" {
	haproxy_version_ge $_ERR_SUPPORTED_HAPROXY_VERSION || skip "requires HAProxy $_ERR_SUPPORTED_HAPROXY_VERSION+"

	PARENT_NAME="test_backend"
    resource_post "$_BACKEND_BASE_PATH/$PARENT_NAME/http_error_rules/0" "data/invalid_no_status_code.json" "force_reload=true"
	assert_equal "$SC" 422
}

@test "http_error_rules: Fail to add a new HTTP Error Rule with unsupported status code to frontend" {
	haproxy_version_ge $_ERR_SUPPORTED_HAPROXY_VERSION || skip "requires HAProxy $_ERR_SUPPORTED_HAPROXY_VERSION+"

	PARENT_NAME="test_frontend"
    resource_post "$_FRONTEND_BASE_PATH/$PARENT_NAME/http_error_rules/0" "data/invalid_bad_status_code.json" "parent_type=frontend&parent_name=test_frontend&force_reload=true"
	assert_equal "$SC" 422
}
