// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#[allow(unused_imports)]
use super::*;

impl std::fmt::Debug for super::ErrorInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ErrorInfo");
        debug_struct.field("reason", &self.reason);
        debug_struct.field("domain", &self.domain);
        debug_struct.field("metadata", &self.metadata);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::RetryInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("RetryInfo");
        debug_struct.field("retry_delay", &self.retry_delay);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::DebugInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("DebugInfo");
        debug_struct.field("stack_entries", &self.stack_entries);
        debug_struct.field("detail", &self.detail);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::QuotaFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("QuotaFailure");
        debug_struct.field("violations", &self.violations);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::quota_failure::Violation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Violation");
        debug_struct.field("subject", &self.subject);
        debug_struct.field("description", &self.description);
        debug_struct.field("api_service", &self.api_service);
        debug_struct.field("quota_metric", &self.quota_metric);
        debug_struct.field("quota_id", &self.quota_id);
        debug_struct.field("quota_dimensions", &self.quota_dimensions);
        debug_struct.field("quota_value", &self.quota_value);
        debug_struct.field("future_quota_value", &self.future_quota_value);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::PreconditionFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("PreconditionFailure");
        debug_struct.field("violations", &self.violations);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::precondition_failure::Violation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Violation");
        debug_struct.field("r#type", &self.r#type);
        debug_struct.field("subject", &self.subject);
        debug_struct.field("description", &self.description);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::BadRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("BadRequest");
        debug_struct.field("field_violations", &self.field_violations);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::bad_request::FieldViolation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("FieldViolation");
        debug_struct.field("field", &self.field);
        debug_struct.field("description", &self.description);
        debug_struct.field("reason", &self.reason);
        debug_struct.field("localized_message", &self.localized_message);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::RequestInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("RequestInfo");
        debug_struct.field("request_id", &self.request_id);
        debug_struct.field("serving_data", &self.serving_data);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::ResourceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("ResourceInfo");
        debug_struct.field("resource_type", &self.resource_type);
        debug_struct.field("resource_name", &self.resource_name);
        debug_struct.field("owner", &self.owner);
        debug_struct.field("description", &self.description);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Help {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Help");
        debug_struct.field("links", &self.links);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::help::Link {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Link");
        debug_struct.field("description", &self.description);
        debug_struct.field("url", &self.url);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::LocalizedMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("LocalizedMessage");
        debug_struct.field("locale", &self.locale);
        debug_struct.field("message", &self.message);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::HttpRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("HttpRequest");
        debug_struct.field("method", &self.method);
        debug_struct.field("uri", &self.uri);
        debug_struct.field("headers", &self.headers);
        debug_struct.field("body", &self.body);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::HttpResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("HttpResponse");
        debug_struct.field("status", &self.status);
        debug_struct.field("reason", &self.reason);
        debug_struct.field("headers", &self.headers);
        debug_struct.field("body", &self.body);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::HttpHeader {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("HttpHeader");
        debug_struct.field("key", &self.key);
        debug_struct.field("value", &self.value);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}

impl std::fmt::Debug for super::Status {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut debug_struct = f.debug_struct("Status");
        debug_struct.field("code", &self.code);
        debug_struct.field("message", &self.message);
        debug_struct.field("details", &self.details);
        if !self._unknown_fields.is_empty() {
            debug_struct.field("_unknown_fields", &self._unknown_fields);
        }
        debug_struct.finish()
    }
}
