/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import org.gradle.fileevents.FileWatchEvent;
import org.gradle.fileevents.FileWatcher;
import org.gradle.fileevents.internal.AbstractNativeFileEventFunctions;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.DefaultFileWatcherProbeRegistry;
import org.gradle.internal.watch.registry.impl.DefaultFileWatcherRegistry;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;

public abstract class AbstractFileWatcherRegistryFactory<T extends AbstractNativeFileEventFunctions<W>, W extends FileWatcher>
implements FileWatcherRegistryFactory {
    private static final int FILE_EVENT_QUEUE_SIZE = 4096;
    protected final T fileEventFunctions;
    private final Predicate<String> immutableLocationsFilter;

    public AbstractFileWatcherRegistryFactory(T fileEventFunctions, Predicate<String> immutableLocationsFilter) {
        this.fileEventFunctions = fileEventFunctions;
        this.immutableLocationsFilter = immutableLocationsFilter;
    }

    @Override
    public FileWatcherRegistry createFileWatcherRegistry(FileWatcherRegistry.ChangeHandler handler) {
        ArrayBlockingQueue<FileWatchEvent> fileEvents = new ArrayBlockingQueue<FileWatchEvent>(4096);
        try {
            DefaultFileWatcherProbeRegistry probeRegistry = new DefaultFileWatcherProbeRegistry(buildDir -> new File(new File((File)buildDir, ".gradle"), "file-system.probe"));
            W watcher = this.createFileWatcher(fileEvents);
            WatchableHierarchies watchableHierarchies = new WatchableHierarchies(probeRegistry, this.immutableLocationsFilter);
            FileWatcherUpdater fileWatcherUpdater = this.createFileWatcherUpdater(watcher, probeRegistry, watchableHierarchies);
            return new DefaultFileWatcherRegistry((FileWatcher)watcher, handler, fileWatcherUpdater, (BlockingQueue<FileWatchEvent>)fileEvents);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected abstract W createFileWatcher(BlockingQueue<FileWatchEvent> var1) throws InterruptedException;

    protected abstract FileWatcherUpdater createFileWatcherUpdater(W var1, FileWatcherProbeRegistry var2, WatchableHierarchies var3);
}

