//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
   This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
   Copyright (C) 2013-2025 Martin Koehler

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef LAPACK_STRUCTURE_H
#define LAPACK_STRUCTURE_H

#include <stdint.h>
#include <complex.h>

#define FLEXIBLAS_LAPACK_MAJOR 3
#define FLEXIBLAS_LAPACK_MINOR 7
#define FLEXIBLAS_LAPACK_PATCH 0
#define FLEXIBLAS_LAPACK_EXTRA without deprecated


#ifdef __cplusplus
extern "C" {
#endif

#include "flexiblas_config.h"
#include "flexiblas_fortran_char_len.h"
#include "flexiblas_fortran_mangle.h"

typedef struct _flexiblas_lapack_backend {
    flexiblas_blasfn cbbcsd;
    flexiblas_blasfn cbdsqr;
    flexiblas_blasfn cgbbrd;
    flexiblas_blasfn cgbcon;
    flexiblas_blasfn cgbequ;
    flexiblas_blasfn cgbequb;
    flexiblas_blasfn cgbrfs;
    flexiblas_blasfn cgbsv;
    flexiblas_blasfn cgbsvx;
    flexiblas_blasfn cgbtf2;
    flexiblas_blasfn cgbtrf;
    flexiblas_blasfn cgbtrs;
    flexiblas_blasfn cgebak;
    flexiblas_blasfn cgebal;
    flexiblas_blasfn cgebd2;
    flexiblas_blasfn cgebrd;
    flexiblas_blasfn cgecon;
    flexiblas_blasfn cgeequ;
    flexiblas_blasfn cgeequb;
    flexiblas_blasfn cgees;
    flexiblas_blasfn cgeesx;
    flexiblas_blasfn cgeev;
    flexiblas_blasfn cgeevx;
    flexiblas_blasfn cgehd2;
    flexiblas_blasfn cgehrd;
    flexiblas_blasfn cgejsv;
    flexiblas_blasfn cgelq;
    flexiblas_blasfn cgelq2;
    flexiblas_blasfn cgelqf;
    flexiblas_blasfn cgelqt;
    flexiblas_blasfn cgelqt3;
    flexiblas_blasfn cgels;
    flexiblas_blasfn cgelsd;
    flexiblas_blasfn cgelss;
    flexiblas_blasfn cgelsy;
    flexiblas_blasfn cgemlq;
    flexiblas_blasfn cgemlqt;
    flexiblas_blasfn cgemqr;
    flexiblas_blasfn cgemqrt;
    flexiblas_blasfn cgeql2;
    flexiblas_blasfn cgeqlf;
    flexiblas_blasfn cgeqp3;
    flexiblas_blasfn cgeqr;
    flexiblas_blasfn cgeqr2;
    flexiblas_blasfn cgeqr2p;
    flexiblas_blasfn cgeqrf;
    flexiblas_blasfn cgeqrfp;
    flexiblas_blasfn cgeqrt;
    flexiblas_blasfn cgeqrt2;
    flexiblas_blasfn cgeqrt3;
    flexiblas_blasfn cgerfs;
    flexiblas_blasfn cgerq2;
    flexiblas_blasfn cgerqf;
    flexiblas_blasfn cgesc2;
    flexiblas_blasfn cgesdd;
    flexiblas_blasfn cgesv;
    flexiblas_blasfn cgesvd;
    flexiblas_blasfn cgesvdx;
    flexiblas_blasfn cgesvj;
    flexiblas_blasfn cgesvx;
    flexiblas_blasfn cgetc2;
    flexiblas_blasfn cgetf2;
    flexiblas_blasfn cgetrf;
    flexiblas_blasfn cgetrf2;
    flexiblas_blasfn cgetri;
    flexiblas_blasfn cgetrs;
    flexiblas_blasfn cgetsls;
    flexiblas_blasfn cggbak;
    flexiblas_blasfn cggbal;
    flexiblas_blasfn cgges;
    flexiblas_blasfn cgges3;
    flexiblas_blasfn cggesx;
    flexiblas_blasfn cggev;
    flexiblas_blasfn cggev3;
    flexiblas_blasfn cggevx;
    flexiblas_blasfn cggglm;
    flexiblas_blasfn cgghd3;
    flexiblas_blasfn cgghrd;
    flexiblas_blasfn cgglse;
    flexiblas_blasfn cggqrf;
    flexiblas_blasfn cggrqf;
    flexiblas_blasfn cggsvd3;
    flexiblas_blasfn cggsvp3;
    flexiblas_blasfn cgsvj0;
    flexiblas_blasfn cgsvj1;
    flexiblas_blasfn cgtcon;
    flexiblas_blasfn cgtrfs;
    flexiblas_blasfn cgtsv;
    flexiblas_blasfn cgtsvx;
    flexiblas_blasfn cgttrf;
    flexiblas_blasfn cgttrs;
    flexiblas_blasfn cgtts2;
    flexiblas_blasfn chb2st_kernels;
    flexiblas_blasfn chbev;
    flexiblas_blasfn chbev_2stage;
    flexiblas_blasfn chbevd;
    flexiblas_blasfn chbevd_2stage;
    flexiblas_blasfn chbevx;
    flexiblas_blasfn chbevx_2stage;
    flexiblas_blasfn chbgst;
    flexiblas_blasfn chbgv;
    flexiblas_blasfn chbgvd;
    flexiblas_blasfn chbgvx;
    flexiblas_blasfn chbtrd;
    flexiblas_blasfn checon;
    flexiblas_blasfn checon_3;
    flexiblas_blasfn checon_rook;
    flexiblas_blasfn cheequb;
    flexiblas_blasfn cheev;
    flexiblas_blasfn cheev_2stage;
    flexiblas_blasfn cheevd;
    flexiblas_blasfn cheevd_2stage;
    flexiblas_blasfn cheevr;
    flexiblas_blasfn cheevr_2stage;
    flexiblas_blasfn cheevx;
    flexiblas_blasfn cheevx_2stage;
    flexiblas_blasfn chegs2;
    flexiblas_blasfn chegst;
    flexiblas_blasfn chegv;
    flexiblas_blasfn chegv_2stage;
    flexiblas_blasfn chegvd;
    flexiblas_blasfn chegvx;
    flexiblas_blasfn cherfs;
    flexiblas_blasfn chesv;
    flexiblas_blasfn chesv_aa;
    flexiblas_blasfn chesv_rk;
    flexiblas_blasfn chesv_rook;
    flexiblas_blasfn chesvx;
    flexiblas_blasfn cheswapr;
    flexiblas_blasfn chetd2;
    flexiblas_blasfn chetf2;
    flexiblas_blasfn chetf2_rk;
    flexiblas_blasfn chetf2_rook;
    flexiblas_blasfn chetrd;
    flexiblas_blasfn chetrd_2stage;
    flexiblas_blasfn chetrd_hb2st;
    flexiblas_blasfn chetrd_he2hb;
    flexiblas_blasfn chetrf;
    flexiblas_blasfn chetrf_aa;
    flexiblas_blasfn chetrf_rk;
    flexiblas_blasfn chetrf_rook;
    flexiblas_blasfn chetri;
    flexiblas_blasfn chetri2;
    flexiblas_blasfn chetri2x;
    flexiblas_blasfn chetri_3;
    flexiblas_blasfn chetri_3x;
    flexiblas_blasfn chetri_rook;
    flexiblas_blasfn chetrs;
    flexiblas_blasfn chetrs2;
    flexiblas_blasfn chetrs_3;
    flexiblas_blasfn chetrs_aa;
    flexiblas_blasfn chetrs_rook;
    flexiblas_blasfn chfrk;
    flexiblas_blasfn chgeqz;
    flexiblas_blasfn chla_transtype;
    flexiblas_blasfn chpcon;
    flexiblas_blasfn chpev;
    flexiblas_blasfn chpevd;
    flexiblas_blasfn chpevx;
    flexiblas_blasfn chpgst;
    flexiblas_blasfn chpgv;
    flexiblas_blasfn chpgvd;
    flexiblas_blasfn chpgvx;
    flexiblas_blasfn chprfs;
    flexiblas_blasfn chpsv;
    flexiblas_blasfn chpsvx;
    flexiblas_blasfn chptrd;
    flexiblas_blasfn chptrf;
    flexiblas_blasfn chptri;
    flexiblas_blasfn chptrs;
    flexiblas_blasfn chsein;
    flexiblas_blasfn chseqr;
    flexiblas_blasfn clabrd;
    flexiblas_blasfn clacgv;
    flexiblas_blasfn clacn2;
    flexiblas_blasfn clacon;
    flexiblas_blasfn clacp2;
    flexiblas_blasfn clacpy;
    flexiblas_blasfn clacrm;
    flexiblas_blasfn clacrt;
    flexiblas_blasfn cladiv;
    flexiblas_blasfn claed0;
    flexiblas_blasfn claed7;
    flexiblas_blasfn claed8;
    flexiblas_blasfn claein;
    flexiblas_blasfn claesy;
    flexiblas_blasfn claev2;
    flexiblas_blasfn clag2z;
    flexiblas_blasfn clags2;
    flexiblas_blasfn clagtm;
    flexiblas_blasfn clahef;
    flexiblas_blasfn clahef_aa;
    flexiblas_blasfn clahef_rk;
    flexiblas_blasfn clahef_rook;
    flexiblas_blasfn clahqr;
    flexiblas_blasfn clahr2;
    flexiblas_blasfn claic1;
    flexiblas_blasfn clals0;
    flexiblas_blasfn clalsa;
    flexiblas_blasfn clalsd;
    flexiblas_blasfn clamswlq;
    flexiblas_blasfn clamtsqr;
    flexiblas_blasfn clangb;
    flexiblas_blasfn clange;
    flexiblas_blasfn clangt;
    flexiblas_blasfn clanhb;
    flexiblas_blasfn clanhe;
    flexiblas_blasfn clanhf;
    flexiblas_blasfn clanhp;
    flexiblas_blasfn clanhs;
    flexiblas_blasfn clanht;
    flexiblas_blasfn clansb;
    flexiblas_blasfn clansp;
    flexiblas_blasfn clansy;
    flexiblas_blasfn clantb;
    flexiblas_blasfn clantp;
    flexiblas_blasfn clantr;
    flexiblas_blasfn clapll;
    flexiblas_blasfn clapmr;
    flexiblas_blasfn clapmt;
    flexiblas_blasfn claqgb;
    flexiblas_blasfn claqge;
    flexiblas_blasfn claqhb;
    flexiblas_blasfn claqhe;
    flexiblas_blasfn claqhp;
    flexiblas_blasfn claqp2;
    flexiblas_blasfn claqps;
    flexiblas_blasfn claqr0;
    flexiblas_blasfn claqr1;
    flexiblas_blasfn claqr2;
    flexiblas_blasfn claqr3;
    flexiblas_blasfn claqr4;
    flexiblas_blasfn claqr5;
    flexiblas_blasfn claqsb;
    flexiblas_blasfn claqsp;
    flexiblas_blasfn claqsy;
    flexiblas_blasfn clar1v;
    flexiblas_blasfn clar2v;
    flexiblas_blasfn clarcm;
    flexiblas_blasfn clarf;
    flexiblas_blasfn clarfb;
    flexiblas_blasfn clarfg;
    flexiblas_blasfn clarfgp;
    flexiblas_blasfn clarft;
    flexiblas_blasfn clarfx;
    flexiblas_blasfn clarfy;
    flexiblas_blasfn clargv;
    flexiblas_blasfn clarnv;
    flexiblas_blasfn clarrv;
    flexiblas_blasfn clartg;
    flexiblas_blasfn clartv;
    flexiblas_blasfn clarz;
    flexiblas_blasfn clarzb;
    flexiblas_blasfn clarzt;
    flexiblas_blasfn clascl;
    flexiblas_blasfn claset;
    flexiblas_blasfn clasr;
    flexiblas_blasfn classq;
    flexiblas_blasfn claswlq;
    flexiblas_blasfn claswp;
    flexiblas_blasfn clasyf;
    flexiblas_blasfn clasyf_aa;
    flexiblas_blasfn clasyf_rk;
    flexiblas_blasfn clasyf_rook;
    flexiblas_blasfn clatbs;
    flexiblas_blasfn clatdf;
    flexiblas_blasfn clatps;
    flexiblas_blasfn clatrd;
    flexiblas_blasfn clatrs;
    flexiblas_blasfn clatrz;
    flexiblas_blasfn clatsqr;
    flexiblas_blasfn clauu2;
    flexiblas_blasfn clauum;
    flexiblas_blasfn cpbcon;
    flexiblas_blasfn cpbequ;
    flexiblas_blasfn cpbrfs;
    flexiblas_blasfn cpbstf;
    flexiblas_blasfn cpbsv;
    flexiblas_blasfn cpbsvx;
    flexiblas_blasfn cpbtf2;
    flexiblas_blasfn cpbtrf;
    flexiblas_blasfn cpbtrs;
    flexiblas_blasfn cpftrf;
    flexiblas_blasfn cpftri;
    flexiblas_blasfn cpftrs;
    flexiblas_blasfn cpocon;
    flexiblas_blasfn cpoequ;
    flexiblas_blasfn cpoequb;
    flexiblas_blasfn cporfs;
    flexiblas_blasfn cposv;
    flexiblas_blasfn cposvx;
    flexiblas_blasfn cpotf2;
    flexiblas_blasfn cpotrf;
    flexiblas_blasfn cpotrf2;
    flexiblas_blasfn cpotri;
    flexiblas_blasfn cpotrs;
    flexiblas_blasfn cppcon;
    flexiblas_blasfn cppequ;
    flexiblas_blasfn cpprfs;
    flexiblas_blasfn cppsv;
    flexiblas_blasfn cppsvx;
    flexiblas_blasfn cpptrf;
    flexiblas_blasfn cpptri;
    flexiblas_blasfn cpptrs;
    flexiblas_blasfn cpstf2;
    flexiblas_blasfn cpstrf;
    flexiblas_blasfn cptcon;
    flexiblas_blasfn cpteqr;
    flexiblas_blasfn cptrfs;
    flexiblas_blasfn cptsv;
    flexiblas_blasfn cptsvx;
    flexiblas_blasfn cpttrf;
    flexiblas_blasfn cpttrs;
    flexiblas_blasfn cptts2;
    flexiblas_blasfn crot;
    flexiblas_blasfn cspcon;
    flexiblas_blasfn cspmv;
    flexiblas_blasfn cspr;
    flexiblas_blasfn csprfs;
    flexiblas_blasfn cspsv;
    flexiblas_blasfn cspsvx;
    flexiblas_blasfn csptrf;
    flexiblas_blasfn csptri;
    flexiblas_blasfn csptrs;
    flexiblas_blasfn csrscl;
    flexiblas_blasfn cstedc;
    flexiblas_blasfn cstegr;
    flexiblas_blasfn cstein;
    flexiblas_blasfn cstemr;
    flexiblas_blasfn csteqr;
    flexiblas_blasfn csycon;
    flexiblas_blasfn csycon_3;
    flexiblas_blasfn csycon_rook;
    flexiblas_blasfn csyconv;
    flexiblas_blasfn csyconvf;
    flexiblas_blasfn csyconvf_rook;
    flexiblas_blasfn csyequb;
    flexiblas_blasfn csymv;
    flexiblas_blasfn csyr;
    flexiblas_blasfn csyrfs;
    flexiblas_blasfn csysv;
    flexiblas_blasfn csysv_aa;
    flexiblas_blasfn csysv_rk;
    flexiblas_blasfn csysv_rook;
    flexiblas_blasfn csysvx;
    flexiblas_blasfn csyswapr;
    flexiblas_blasfn csytf2;
    flexiblas_blasfn csytf2_rk;
    flexiblas_blasfn csytf2_rook;
    flexiblas_blasfn csytrf;
    flexiblas_blasfn csytrf_aa;
    flexiblas_blasfn csytrf_rk;
    flexiblas_blasfn csytrf_rook;
    flexiblas_blasfn csytri;
    flexiblas_blasfn csytri2;
    flexiblas_blasfn csytri2x;
    flexiblas_blasfn csytri_3;
    flexiblas_blasfn csytri_3x;
    flexiblas_blasfn csytri_rook;
    flexiblas_blasfn csytrs;
    flexiblas_blasfn csytrs2;
    flexiblas_blasfn csytrs_3;
    flexiblas_blasfn csytrs_aa;
    flexiblas_blasfn csytrs_rook;
    flexiblas_blasfn ctbcon;
    flexiblas_blasfn ctbrfs;
    flexiblas_blasfn ctbtrs;
    flexiblas_blasfn ctfsm;
    flexiblas_blasfn ctftri;
    flexiblas_blasfn ctfttp;
    flexiblas_blasfn ctfttr;
    flexiblas_blasfn ctgevc;
    flexiblas_blasfn ctgex2;
    flexiblas_blasfn ctgexc;
    flexiblas_blasfn ctgsen;
    flexiblas_blasfn ctgsja;
    flexiblas_blasfn ctgsna;
    flexiblas_blasfn ctgsy2;
    flexiblas_blasfn ctgsyl;
    flexiblas_blasfn ctpcon;
    flexiblas_blasfn ctplqt;
    flexiblas_blasfn ctplqt2;
    flexiblas_blasfn ctpmlqt;
    flexiblas_blasfn ctpmqrt;
    flexiblas_blasfn ctpqrt;
    flexiblas_blasfn ctpqrt2;
    flexiblas_blasfn ctprfb;
    flexiblas_blasfn ctprfs;
    flexiblas_blasfn ctptri;
    flexiblas_blasfn ctptrs;
    flexiblas_blasfn ctpttf;
    flexiblas_blasfn ctpttr;
    flexiblas_blasfn ctrcon;
    flexiblas_blasfn ctrevc;
    flexiblas_blasfn ctrevc3;
    flexiblas_blasfn ctrexc;
    flexiblas_blasfn ctrrfs;
    flexiblas_blasfn ctrsen;
    flexiblas_blasfn ctrsna;
    flexiblas_blasfn ctrsyl;
    flexiblas_blasfn ctrti2;
    flexiblas_blasfn ctrtri;
    flexiblas_blasfn ctrtrs;
    flexiblas_blasfn ctrttf;
    flexiblas_blasfn ctrttp;
    flexiblas_blasfn ctzrzf;
    flexiblas_blasfn cunbdb;
    flexiblas_blasfn cunbdb1;
    flexiblas_blasfn cunbdb2;
    flexiblas_blasfn cunbdb3;
    flexiblas_blasfn cunbdb4;
    flexiblas_blasfn cunbdb5;
    flexiblas_blasfn cunbdb6;
    flexiblas_blasfn cuncsd;
    flexiblas_blasfn cuncsd2by1;
    flexiblas_blasfn cung2l;
    flexiblas_blasfn cung2r;
    flexiblas_blasfn cungbr;
    flexiblas_blasfn cunghr;
    flexiblas_blasfn cungl2;
    flexiblas_blasfn cunglq;
    flexiblas_blasfn cungql;
    flexiblas_blasfn cungqr;
    flexiblas_blasfn cungr2;
    flexiblas_blasfn cungrq;
    flexiblas_blasfn cungtr;
    flexiblas_blasfn cunm22;
    flexiblas_blasfn cunm2l;
    flexiblas_blasfn cunm2r;
    flexiblas_blasfn cunmbr;
    flexiblas_blasfn cunmhr;
    flexiblas_blasfn cunml2;
    flexiblas_blasfn cunmlq;
    flexiblas_blasfn cunmql;
    flexiblas_blasfn cunmqr;
    flexiblas_blasfn cunmr2;
    flexiblas_blasfn cunmr3;
    flexiblas_blasfn cunmrq;
    flexiblas_blasfn cunmrz;
    flexiblas_blasfn cunmtr;
    flexiblas_blasfn cupgtr;
    flexiblas_blasfn cupmtr;
    flexiblas_blasfn dbbcsd;
    flexiblas_blasfn dbdsdc;
    flexiblas_blasfn dbdsqr;
    flexiblas_blasfn dbdsvdx;
    flexiblas_blasfn ddisna;
    flexiblas_blasfn dgbbrd;
    flexiblas_blasfn dgbcon;
    flexiblas_blasfn dgbequ;
    flexiblas_blasfn dgbequb;
    flexiblas_blasfn dgbrfs;
    flexiblas_blasfn dgbsv;
    flexiblas_blasfn dgbsvx;
    flexiblas_blasfn dgbtf2;
    flexiblas_blasfn dgbtrf;
    flexiblas_blasfn dgbtrs;
    flexiblas_blasfn dgebak;
    flexiblas_blasfn dgebal;
    flexiblas_blasfn dgebd2;
    flexiblas_blasfn dgebrd;
    flexiblas_blasfn dgecon;
    flexiblas_blasfn dgeequ;
    flexiblas_blasfn dgeequb;
    flexiblas_blasfn dgees;
    flexiblas_blasfn dgeesx;
    flexiblas_blasfn dgeev;
    flexiblas_blasfn dgeevx;
    flexiblas_blasfn dgehd2;
    flexiblas_blasfn dgehrd;
    flexiblas_blasfn dgejsv;
    flexiblas_blasfn dgelq;
    flexiblas_blasfn dgelq2;
    flexiblas_blasfn dgelqf;
    flexiblas_blasfn dgelqt;
    flexiblas_blasfn dgelqt3;
    flexiblas_blasfn dgels;
    flexiblas_blasfn dgelsd;
    flexiblas_blasfn dgelss;
    flexiblas_blasfn dgelsy;
    flexiblas_blasfn dgemlq;
    flexiblas_blasfn dgemlqt;
    flexiblas_blasfn dgemqr;
    flexiblas_blasfn dgemqrt;
    flexiblas_blasfn dgeql2;
    flexiblas_blasfn dgeqlf;
    flexiblas_blasfn dgeqp3;
    flexiblas_blasfn dgeqr;
    flexiblas_blasfn dgeqr2;
    flexiblas_blasfn dgeqr2p;
    flexiblas_blasfn dgeqrf;
    flexiblas_blasfn dgeqrfp;
    flexiblas_blasfn dgeqrt;
    flexiblas_blasfn dgeqrt2;
    flexiblas_blasfn dgeqrt3;
    flexiblas_blasfn dgerfs;
    flexiblas_blasfn dgerq2;
    flexiblas_blasfn dgerqf;
    flexiblas_blasfn dgesc2;
    flexiblas_blasfn dgesdd;
    flexiblas_blasfn dgesv;
    flexiblas_blasfn dgesvd;
    flexiblas_blasfn dgesvdx;
    flexiblas_blasfn dgesvj;
    flexiblas_blasfn dgesvx;
    flexiblas_blasfn dgetc2;
    flexiblas_blasfn dgetf2;
    flexiblas_blasfn dgetrf;
    flexiblas_blasfn dgetrf2;
    flexiblas_blasfn dgetri;
    flexiblas_blasfn dgetrs;
    flexiblas_blasfn dgetsls;
    flexiblas_blasfn dggbak;
    flexiblas_blasfn dggbal;
    flexiblas_blasfn dgges;
    flexiblas_blasfn dgges3;
    flexiblas_blasfn dggesx;
    flexiblas_blasfn dggev;
    flexiblas_blasfn dggev3;
    flexiblas_blasfn dggevx;
    flexiblas_blasfn dggglm;
    flexiblas_blasfn dgghd3;
    flexiblas_blasfn dgghrd;
    flexiblas_blasfn dgglse;
    flexiblas_blasfn dggqrf;
    flexiblas_blasfn dggrqf;
    flexiblas_blasfn dggsvd3;
    flexiblas_blasfn dggsvp3;
    flexiblas_blasfn dgsvj0;
    flexiblas_blasfn dgsvj1;
    flexiblas_blasfn dgtcon;
    flexiblas_blasfn dgtrfs;
    flexiblas_blasfn dgtsv;
    flexiblas_blasfn dgtsvx;
    flexiblas_blasfn dgttrf;
    flexiblas_blasfn dgttrs;
    flexiblas_blasfn dgtts2;
    flexiblas_blasfn dhgeqz;
    flexiblas_blasfn dhsein;
    flexiblas_blasfn dhseqr;
    flexiblas_blasfn disnan;
    flexiblas_blasfn dlabad;
    flexiblas_blasfn dlabrd;
    flexiblas_blasfn dlacn2;
    flexiblas_blasfn dlacon;
    flexiblas_blasfn dlacpy;
    flexiblas_blasfn dladiv;
    flexiblas_blasfn dladiv1;
    flexiblas_blasfn dladiv2;
    flexiblas_blasfn dlae2;
    flexiblas_blasfn dlaebz;
    flexiblas_blasfn dlaed0;
    flexiblas_blasfn dlaed1;
    flexiblas_blasfn dlaed2;
    flexiblas_blasfn dlaed3;
    flexiblas_blasfn dlaed4;
    flexiblas_blasfn dlaed5;
    flexiblas_blasfn dlaed6;
    flexiblas_blasfn dlaed7;
    flexiblas_blasfn dlaed8;
    flexiblas_blasfn dlaed9;
    flexiblas_blasfn dlaeda;
    flexiblas_blasfn dlaein;
    flexiblas_blasfn dlaev2;
    flexiblas_blasfn dlaexc;
    flexiblas_blasfn dlag2;
    flexiblas_blasfn dlag2s;
    flexiblas_blasfn dlags2;
    flexiblas_blasfn dlagtf;
    flexiblas_blasfn dlagtm;
    flexiblas_blasfn dlagts;
    flexiblas_blasfn dlagv2;
    flexiblas_blasfn dlahqr;
    flexiblas_blasfn dlahr2;
    flexiblas_blasfn dlaic1;
    flexiblas_blasfn dlaisnan;
    flexiblas_blasfn dlaln2;
    flexiblas_blasfn dlals0;
    flexiblas_blasfn dlalsa;
    flexiblas_blasfn dlalsd;
    flexiblas_blasfn dlamc3;
    flexiblas_blasfn dlamch;
    flexiblas_blasfn dlamrg;
    flexiblas_blasfn dlamswlq;
    flexiblas_blasfn dlamtsqr;
    flexiblas_blasfn dlaneg;
    flexiblas_blasfn dlangb;
    flexiblas_blasfn dlange;
    flexiblas_blasfn dlangt;
    flexiblas_blasfn dlanhs;
    flexiblas_blasfn dlansb;
    flexiblas_blasfn dlansf;
    flexiblas_blasfn dlansp;
    flexiblas_blasfn dlanst;
    flexiblas_blasfn dlansy;
    flexiblas_blasfn dlantb;
    flexiblas_blasfn dlantp;
    flexiblas_blasfn dlantr;
    flexiblas_blasfn dlanv2;
    flexiblas_blasfn dlapll;
    flexiblas_blasfn dlapmr;
    flexiblas_blasfn dlapmt;
    flexiblas_blasfn dlapy2;
    flexiblas_blasfn dlapy3;
    flexiblas_blasfn dlaqgb;
    flexiblas_blasfn dlaqge;
    flexiblas_blasfn dlaqp2;
    flexiblas_blasfn dlaqps;
    flexiblas_blasfn dlaqr0;
    flexiblas_blasfn dlaqr1;
    flexiblas_blasfn dlaqr2;
    flexiblas_blasfn dlaqr3;
    flexiblas_blasfn dlaqr4;
    flexiblas_blasfn dlaqr5;
    flexiblas_blasfn dlaqsb;
    flexiblas_blasfn dlaqsp;
    flexiblas_blasfn dlaqsy;
    flexiblas_blasfn dlaqtr;
    flexiblas_blasfn dlar1v;
    flexiblas_blasfn dlar2v;
    flexiblas_blasfn dlarf;
    flexiblas_blasfn dlarfb;
    flexiblas_blasfn dlarfg;
    flexiblas_blasfn dlarfgp;
    flexiblas_blasfn dlarft;
    flexiblas_blasfn dlarfx;
    flexiblas_blasfn dlarfy;
    flexiblas_blasfn dlargv;
    flexiblas_blasfn dlarnv;
    flexiblas_blasfn dlarra;
    flexiblas_blasfn dlarrb;
    flexiblas_blasfn dlarrc;
    flexiblas_blasfn dlarrd;
    flexiblas_blasfn dlarre;
    flexiblas_blasfn dlarrf;
    flexiblas_blasfn dlarrj;
    flexiblas_blasfn dlarrk;
    flexiblas_blasfn dlarrr;
    flexiblas_blasfn dlarrv;
    flexiblas_blasfn dlartg;
    flexiblas_blasfn dlartgp;
    flexiblas_blasfn dlartgs;
    flexiblas_blasfn dlartv;
    flexiblas_blasfn dlaruv;
    flexiblas_blasfn dlarz;
    flexiblas_blasfn dlarzb;
    flexiblas_blasfn dlarzt;
    flexiblas_blasfn dlas2;
    flexiblas_blasfn dlascl;
    flexiblas_blasfn dlasd0;
    flexiblas_blasfn dlasd1;
    flexiblas_blasfn dlasd2;
    flexiblas_blasfn dlasd3;
    flexiblas_blasfn dlasd4;
    flexiblas_blasfn dlasd5;
    flexiblas_blasfn dlasd6;
    flexiblas_blasfn dlasd7;
    flexiblas_blasfn dlasd8;
    flexiblas_blasfn dlasda;
    flexiblas_blasfn dlasdq;
    flexiblas_blasfn dlasdt;
    flexiblas_blasfn dlaset;
    flexiblas_blasfn dlasq1;
    flexiblas_blasfn dlasq2;
    flexiblas_blasfn dlasq3;
    flexiblas_blasfn dlasq4;
    flexiblas_blasfn dlasq5;
    flexiblas_blasfn dlasq6;
    flexiblas_blasfn dlasr;
    flexiblas_blasfn dlasrt;
    flexiblas_blasfn dlassq;
    flexiblas_blasfn dlasv2;
    flexiblas_blasfn dlaswlq;
    flexiblas_blasfn dlaswp;
    flexiblas_blasfn dlasy2;
    flexiblas_blasfn dlasyf;
    flexiblas_blasfn dlasyf_aa;
    flexiblas_blasfn dlasyf_rk;
    flexiblas_blasfn dlasyf_rook;
    flexiblas_blasfn dlat2s;
    flexiblas_blasfn dlatbs;
    flexiblas_blasfn dlatdf;
    flexiblas_blasfn dlatps;
    flexiblas_blasfn dlatrd;
    flexiblas_blasfn dlatrs;
    flexiblas_blasfn dlatrz;
    flexiblas_blasfn dlatsqr;
    flexiblas_blasfn dlauu2;
    flexiblas_blasfn dlauum;
    flexiblas_blasfn dopgtr;
    flexiblas_blasfn dopmtr;
    flexiblas_blasfn dorbdb;
    flexiblas_blasfn dorbdb1;
    flexiblas_blasfn dorbdb2;
    flexiblas_blasfn dorbdb3;
    flexiblas_blasfn dorbdb4;
    flexiblas_blasfn dorbdb5;
    flexiblas_blasfn dorbdb6;
    flexiblas_blasfn dorcsd;
    flexiblas_blasfn dorcsd2by1;
    flexiblas_blasfn dorg2l;
    flexiblas_blasfn dorg2r;
    flexiblas_blasfn dorgbr;
    flexiblas_blasfn dorghr;
    flexiblas_blasfn dorgl2;
    flexiblas_blasfn dorglq;
    flexiblas_blasfn dorgql;
    flexiblas_blasfn dorgqr;
    flexiblas_blasfn dorgr2;
    flexiblas_blasfn dorgrq;
    flexiblas_blasfn dorgtr;
    flexiblas_blasfn dorm22;
    flexiblas_blasfn dorm2l;
    flexiblas_blasfn dorm2r;
    flexiblas_blasfn dormbr;
    flexiblas_blasfn dormhr;
    flexiblas_blasfn dorml2;
    flexiblas_blasfn dormlq;
    flexiblas_blasfn dormql;
    flexiblas_blasfn dormqr;
    flexiblas_blasfn dormr2;
    flexiblas_blasfn dormr3;
    flexiblas_blasfn dormrq;
    flexiblas_blasfn dormrz;
    flexiblas_blasfn dormtr;
    flexiblas_blasfn dpbcon;
    flexiblas_blasfn dpbequ;
    flexiblas_blasfn dpbrfs;
    flexiblas_blasfn dpbstf;
    flexiblas_blasfn dpbsv;
    flexiblas_blasfn dpbsvx;
    flexiblas_blasfn dpbtf2;
    flexiblas_blasfn dpbtrf;
    flexiblas_blasfn dpbtrs;
    flexiblas_blasfn dpftrf;
    flexiblas_blasfn dpftri;
    flexiblas_blasfn dpftrs;
    flexiblas_blasfn dpocon;
    flexiblas_blasfn dpoequ;
    flexiblas_blasfn dpoequb;
    flexiblas_blasfn dporfs;
    flexiblas_blasfn dposv;
    flexiblas_blasfn dposvx;
    flexiblas_blasfn dpotf2;
    flexiblas_blasfn dpotrf;
    flexiblas_blasfn dpotrf2;
    flexiblas_blasfn dpotri;
    flexiblas_blasfn dpotrs;
    flexiblas_blasfn dppcon;
    flexiblas_blasfn dppequ;
    flexiblas_blasfn dpprfs;
    flexiblas_blasfn dppsv;
    flexiblas_blasfn dppsvx;
    flexiblas_blasfn dpptrf;
    flexiblas_blasfn dpptri;
    flexiblas_blasfn dpptrs;
    flexiblas_blasfn dpstf2;
    flexiblas_blasfn dpstrf;
    flexiblas_blasfn dptcon;
    flexiblas_blasfn dpteqr;
    flexiblas_blasfn dptrfs;
    flexiblas_blasfn dptsv;
    flexiblas_blasfn dptsvx;
    flexiblas_blasfn dpttrf;
    flexiblas_blasfn dpttrs;
    flexiblas_blasfn dptts2;
    flexiblas_blasfn drscl;
    flexiblas_blasfn dsb2st_kernels;
    flexiblas_blasfn dsbev;
    flexiblas_blasfn dsbev_2stage;
    flexiblas_blasfn dsbevd;
    flexiblas_blasfn dsbevd_2stage;
    flexiblas_blasfn dsbevx;
    flexiblas_blasfn dsbevx_2stage;
    flexiblas_blasfn dsbgst;
    flexiblas_blasfn dsbgv;
    flexiblas_blasfn dsbgvd;
    flexiblas_blasfn dsbgvx;
    flexiblas_blasfn dsbtrd;
    flexiblas_blasfn dsecnd;
    flexiblas_blasfn dsfrk;
    flexiblas_blasfn dsgesv;
    flexiblas_blasfn dspcon;
    flexiblas_blasfn dspev;
    flexiblas_blasfn dspevd;
    flexiblas_blasfn dspevx;
    flexiblas_blasfn dspgst;
    flexiblas_blasfn dspgv;
    flexiblas_blasfn dspgvd;
    flexiblas_blasfn dspgvx;
    flexiblas_blasfn dsposv;
    flexiblas_blasfn dsprfs;
    flexiblas_blasfn dspsv;
    flexiblas_blasfn dspsvx;
    flexiblas_blasfn dsptrd;
    flexiblas_blasfn dsptrf;
    flexiblas_blasfn dsptri;
    flexiblas_blasfn dsptrs;
    flexiblas_blasfn dstebz;
    flexiblas_blasfn dstedc;
    flexiblas_blasfn dstegr;
    flexiblas_blasfn dstein;
    flexiblas_blasfn dstemr;
    flexiblas_blasfn dsteqr;
    flexiblas_blasfn dsterf;
    flexiblas_blasfn dstev;
    flexiblas_blasfn dstevd;
    flexiblas_blasfn dstevr;
    flexiblas_blasfn dstevx;
    flexiblas_blasfn dsycon;
    flexiblas_blasfn dsycon_3;
    flexiblas_blasfn dsycon_rook;
    flexiblas_blasfn dsyconv;
    flexiblas_blasfn dsyconvf;
    flexiblas_blasfn dsyconvf_rook;
    flexiblas_blasfn dsyequb;
    flexiblas_blasfn dsyev;
    flexiblas_blasfn dsyev_2stage;
    flexiblas_blasfn dsyevd;
    flexiblas_blasfn dsyevd_2stage;
    flexiblas_blasfn dsyevr;
    flexiblas_blasfn dsyevr_2stage;
    flexiblas_blasfn dsyevx;
    flexiblas_blasfn dsyevx_2stage;
    flexiblas_blasfn dsygs2;
    flexiblas_blasfn dsygst;
    flexiblas_blasfn dsygv;
    flexiblas_blasfn dsygv_2stage;
    flexiblas_blasfn dsygvd;
    flexiblas_blasfn dsygvx;
    flexiblas_blasfn dsyrfs;
    flexiblas_blasfn dsysv;
    flexiblas_blasfn dsysv_aa;
    flexiblas_blasfn dsysv_rk;
    flexiblas_blasfn dsysv_rook;
    flexiblas_blasfn dsysvx;
    flexiblas_blasfn dsyswapr;
    flexiblas_blasfn dsytd2;
    flexiblas_blasfn dsytf2;
    flexiblas_blasfn dsytf2_rk;
    flexiblas_blasfn dsytf2_rook;
    flexiblas_blasfn dsytrd;
    flexiblas_blasfn dsytrd_2stage;
    flexiblas_blasfn dsytrd_sb2st;
    flexiblas_blasfn dsytrd_sy2sb;
    flexiblas_blasfn dsytrf;
    flexiblas_blasfn dsytrf_aa;
    flexiblas_blasfn dsytrf_rk;
    flexiblas_blasfn dsytrf_rook;
    flexiblas_blasfn dsytri;
    flexiblas_blasfn dsytri2;
    flexiblas_blasfn dsytri2x;
    flexiblas_blasfn dsytri_3;
    flexiblas_blasfn dsytri_3x;
    flexiblas_blasfn dsytri_rook;
    flexiblas_blasfn dsytrs;
    flexiblas_blasfn dsytrs2;
    flexiblas_blasfn dsytrs_3;
    flexiblas_blasfn dsytrs_aa;
    flexiblas_blasfn dsytrs_rook;
    flexiblas_blasfn dtbcon;
    flexiblas_blasfn dtbrfs;
    flexiblas_blasfn dtbtrs;
    flexiblas_blasfn dtfsm;
    flexiblas_blasfn dtftri;
    flexiblas_blasfn dtfttp;
    flexiblas_blasfn dtfttr;
    flexiblas_blasfn dtgevc;
    flexiblas_blasfn dtgex2;
    flexiblas_blasfn dtgexc;
    flexiblas_blasfn dtgsen;
    flexiblas_blasfn dtgsja;
    flexiblas_blasfn dtgsna;
    flexiblas_blasfn dtgsy2;
    flexiblas_blasfn dtgsyl;
    flexiblas_blasfn dtpcon;
    flexiblas_blasfn dtplqt;
    flexiblas_blasfn dtplqt2;
    flexiblas_blasfn dtpmlqt;
    flexiblas_blasfn dtpmqrt;
    flexiblas_blasfn dtpqrt;
    flexiblas_blasfn dtpqrt2;
    flexiblas_blasfn dtprfb;
    flexiblas_blasfn dtprfs;
    flexiblas_blasfn dtptri;
    flexiblas_blasfn dtptrs;
    flexiblas_blasfn dtpttf;
    flexiblas_blasfn dtpttr;
    flexiblas_blasfn dtrcon;
    flexiblas_blasfn dtrevc;
    flexiblas_blasfn dtrevc3;
    flexiblas_blasfn dtrexc;
    flexiblas_blasfn dtrrfs;
    flexiblas_blasfn dtrsen;
    flexiblas_blasfn dtrsna;
    flexiblas_blasfn dtrsyl;
    flexiblas_blasfn dtrti2;
    flexiblas_blasfn dtrtri;
    flexiblas_blasfn dtrtrs;
    flexiblas_blasfn dtrttf;
    flexiblas_blasfn dtrttp;
    flexiblas_blasfn dtzrzf;
    flexiblas_blasfn dzsum1;
    flexiblas_blasfn icmax1;
    flexiblas_blasfn ieeeck;
    flexiblas_blasfn ilaclc;
    flexiblas_blasfn ilaclr;
    flexiblas_blasfn iladiag;
    flexiblas_blasfn iladlc;
    flexiblas_blasfn iladlr;
    flexiblas_blasfn ilaenv;
    flexiblas_blasfn ilaprec;
    flexiblas_blasfn ilaslc;
    flexiblas_blasfn ilaslr;
    flexiblas_blasfn ilatrans;
    flexiblas_blasfn ilauplo;
    flexiblas_blasfn ilazlc;
    flexiblas_blasfn ilazlr;
    flexiblas_blasfn iparam2stage;
    flexiblas_blasfn iparmq;
    flexiblas_blasfn izmax1;
    flexiblas_blasfn sbbcsd;
    flexiblas_blasfn sbdsdc;
    flexiblas_blasfn sbdsqr;
    flexiblas_blasfn sbdsvdx;
    flexiblas_blasfn scsum1;
    flexiblas_blasfn sdisna;
    flexiblas_blasfn second;
    flexiblas_blasfn sgbbrd;
    flexiblas_blasfn sgbcon;
    flexiblas_blasfn sgbequ;
    flexiblas_blasfn sgbequb;
    flexiblas_blasfn sgbrfs;
    flexiblas_blasfn sgbsv;
    flexiblas_blasfn sgbsvx;
    flexiblas_blasfn sgbtf2;
    flexiblas_blasfn sgbtrf;
    flexiblas_blasfn sgbtrs;
    flexiblas_blasfn sgebak;
    flexiblas_blasfn sgebal;
    flexiblas_blasfn sgebd2;
    flexiblas_blasfn sgebrd;
    flexiblas_blasfn sgecon;
    flexiblas_blasfn sgeequ;
    flexiblas_blasfn sgeequb;
    flexiblas_blasfn sgees;
    flexiblas_blasfn sgeesx;
    flexiblas_blasfn sgeev;
    flexiblas_blasfn sgeevx;
    flexiblas_blasfn sgehd2;
    flexiblas_blasfn sgehrd;
    flexiblas_blasfn sgejsv;
    flexiblas_blasfn sgelq;
    flexiblas_blasfn sgelq2;
    flexiblas_blasfn sgelqf;
    flexiblas_blasfn sgelqt;
    flexiblas_blasfn sgelqt3;
    flexiblas_blasfn sgels;
    flexiblas_blasfn sgelsd;
    flexiblas_blasfn sgelss;
    flexiblas_blasfn sgelsy;
    flexiblas_blasfn sgemlq;
    flexiblas_blasfn sgemlqt;
    flexiblas_blasfn sgemqr;
    flexiblas_blasfn sgemqrt;
    flexiblas_blasfn sgeql2;
    flexiblas_blasfn sgeqlf;
    flexiblas_blasfn sgeqp3;
    flexiblas_blasfn sgeqr;
    flexiblas_blasfn sgeqr2;
    flexiblas_blasfn sgeqr2p;
    flexiblas_blasfn sgeqrf;
    flexiblas_blasfn sgeqrfp;
    flexiblas_blasfn sgeqrt;
    flexiblas_blasfn sgeqrt2;
    flexiblas_blasfn sgeqrt3;
    flexiblas_blasfn sgerfs;
    flexiblas_blasfn sgerq2;
    flexiblas_blasfn sgerqf;
    flexiblas_blasfn sgesc2;
    flexiblas_blasfn sgesdd;
    flexiblas_blasfn sgesv;
    flexiblas_blasfn sgesvd;
    flexiblas_blasfn sgesvdx;
    flexiblas_blasfn sgesvj;
    flexiblas_blasfn sgesvx;
    flexiblas_blasfn sgetc2;
    flexiblas_blasfn sgetf2;
    flexiblas_blasfn sgetrf;
    flexiblas_blasfn sgetrf2;
    flexiblas_blasfn sgetri;
    flexiblas_blasfn sgetrs;
    flexiblas_blasfn sgetsls;
    flexiblas_blasfn sggbak;
    flexiblas_blasfn sggbal;
    flexiblas_blasfn sgges;
    flexiblas_blasfn sgges3;
    flexiblas_blasfn sggesx;
    flexiblas_blasfn sggev;
    flexiblas_blasfn sggev3;
    flexiblas_blasfn sggevx;
    flexiblas_blasfn sggglm;
    flexiblas_blasfn sgghd3;
    flexiblas_blasfn sgghrd;
    flexiblas_blasfn sgglse;
    flexiblas_blasfn sggqrf;
    flexiblas_blasfn sggrqf;
    flexiblas_blasfn sggsvd3;
    flexiblas_blasfn sggsvp3;
    flexiblas_blasfn sgsvj0;
    flexiblas_blasfn sgsvj1;
    flexiblas_blasfn sgtcon;
    flexiblas_blasfn sgtrfs;
    flexiblas_blasfn sgtsv;
    flexiblas_blasfn sgtsvx;
    flexiblas_blasfn sgttrf;
    flexiblas_blasfn sgttrs;
    flexiblas_blasfn sgtts2;
    flexiblas_blasfn shgeqz;
    flexiblas_blasfn shsein;
    flexiblas_blasfn shseqr;
    flexiblas_blasfn sisnan;
    flexiblas_blasfn slabad;
    flexiblas_blasfn slabrd;
    flexiblas_blasfn slacn2;
    flexiblas_blasfn slacon;
    flexiblas_blasfn slacpy;
    flexiblas_blasfn sladiv;
    flexiblas_blasfn sladiv1;
    flexiblas_blasfn sladiv2;
    flexiblas_blasfn slae2;
    flexiblas_blasfn slaebz;
    flexiblas_blasfn slaed0;
    flexiblas_blasfn slaed1;
    flexiblas_blasfn slaed2;
    flexiblas_blasfn slaed3;
    flexiblas_blasfn slaed4;
    flexiblas_blasfn slaed5;
    flexiblas_blasfn slaed6;
    flexiblas_blasfn slaed7;
    flexiblas_blasfn slaed8;
    flexiblas_blasfn slaed9;
    flexiblas_blasfn slaeda;
    flexiblas_blasfn slaein;
    flexiblas_blasfn slaev2;
    flexiblas_blasfn slaexc;
    flexiblas_blasfn slag2;
    flexiblas_blasfn slag2d;
    flexiblas_blasfn slags2;
    flexiblas_blasfn slagtf;
    flexiblas_blasfn slagtm;
    flexiblas_blasfn slagts;
    flexiblas_blasfn slagv2;
    flexiblas_blasfn slahqr;
    flexiblas_blasfn slahr2;
    flexiblas_blasfn slaic1;
    flexiblas_blasfn slaisnan;
    flexiblas_blasfn slaln2;
    flexiblas_blasfn slals0;
    flexiblas_blasfn slalsa;
    flexiblas_blasfn slalsd;
    flexiblas_blasfn slamc3;
    flexiblas_blasfn slamch;
    flexiblas_blasfn slamrg;
    flexiblas_blasfn slamswlq;
    flexiblas_blasfn slamtsqr;
    flexiblas_blasfn slaneg;
    flexiblas_blasfn slangb;
    flexiblas_blasfn slange;
    flexiblas_blasfn slangt;
    flexiblas_blasfn slanhs;
    flexiblas_blasfn slansb;
    flexiblas_blasfn slansf;
    flexiblas_blasfn slansp;
    flexiblas_blasfn slanst;
    flexiblas_blasfn slansy;
    flexiblas_blasfn slantb;
    flexiblas_blasfn slantp;
    flexiblas_blasfn slantr;
    flexiblas_blasfn slanv2;
    flexiblas_blasfn slapll;
    flexiblas_blasfn slapmr;
    flexiblas_blasfn slapmt;
    flexiblas_blasfn slapy2;
    flexiblas_blasfn slapy3;
    flexiblas_blasfn slaqgb;
    flexiblas_blasfn slaqge;
    flexiblas_blasfn slaqp2;
    flexiblas_blasfn slaqps;
    flexiblas_blasfn slaqr0;
    flexiblas_blasfn slaqr1;
    flexiblas_blasfn slaqr2;
    flexiblas_blasfn slaqr3;
    flexiblas_blasfn slaqr4;
    flexiblas_blasfn slaqr5;
    flexiblas_blasfn slaqsb;
    flexiblas_blasfn slaqsp;
    flexiblas_blasfn slaqsy;
    flexiblas_blasfn slaqtr;
    flexiblas_blasfn slar1v;
    flexiblas_blasfn slar2v;
    flexiblas_blasfn slarf;
    flexiblas_blasfn slarfb;
    flexiblas_blasfn slarfg;
    flexiblas_blasfn slarfgp;
    flexiblas_blasfn slarft;
    flexiblas_blasfn slarfx;
    flexiblas_blasfn slarfy;
    flexiblas_blasfn slargv;
    flexiblas_blasfn slarnv;
    flexiblas_blasfn slarra;
    flexiblas_blasfn slarrb;
    flexiblas_blasfn slarrc;
    flexiblas_blasfn slarrd;
    flexiblas_blasfn slarre;
    flexiblas_blasfn slarrf;
    flexiblas_blasfn slarrj;
    flexiblas_blasfn slarrk;
    flexiblas_blasfn slarrr;
    flexiblas_blasfn slarrv;
    flexiblas_blasfn slartg;
    flexiblas_blasfn slartgp;
    flexiblas_blasfn slartgs;
    flexiblas_blasfn slartv;
    flexiblas_blasfn slaruv;
    flexiblas_blasfn slarz;
    flexiblas_blasfn slarzb;
    flexiblas_blasfn slarzt;
    flexiblas_blasfn slas2;
    flexiblas_blasfn slascl;
    flexiblas_blasfn slasd0;
    flexiblas_blasfn slasd1;
    flexiblas_blasfn slasd2;
    flexiblas_blasfn slasd3;
    flexiblas_blasfn slasd4;
    flexiblas_blasfn slasd5;
    flexiblas_blasfn slasd6;
    flexiblas_blasfn slasd7;
    flexiblas_blasfn slasd8;
    flexiblas_blasfn slasda;
    flexiblas_blasfn slasdq;
    flexiblas_blasfn slasdt;
    flexiblas_blasfn slaset;
    flexiblas_blasfn slasq1;
    flexiblas_blasfn slasq2;
    flexiblas_blasfn slasq3;
    flexiblas_blasfn slasq4;
    flexiblas_blasfn slasq5;
    flexiblas_blasfn slasq6;
    flexiblas_blasfn slasr;
    flexiblas_blasfn slasrt;
    flexiblas_blasfn slassq;
    flexiblas_blasfn slasv2;
    flexiblas_blasfn slaswlq;
    flexiblas_blasfn slaswp;
    flexiblas_blasfn slasy2;
    flexiblas_blasfn slasyf;
    flexiblas_blasfn slasyf_aa;
    flexiblas_blasfn slasyf_rk;
    flexiblas_blasfn slasyf_rook;
    flexiblas_blasfn slatbs;
    flexiblas_blasfn slatdf;
    flexiblas_blasfn slatps;
    flexiblas_blasfn slatrd;
    flexiblas_blasfn slatrs;
    flexiblas_blasfn slatrz;
    flexiblas_blasfn slatsqr;
    flexiblas_blasfn slauu2;
    flexiblas_blasfn slauum;
    flexiblas_blasfn sopgtr;
    flexiblas_blasfn sopmtr;
    flexiblas_blasfn sorbdb;
    flexiblas_blasfn sorbdb1;
    flexiblas_blasfn sorbdb2;
    flexiblas_blasfn sorbdb3;
    flexiblas_blasfn sorbdb4;
    flexiblas_blasfn sorbdb5;
    flexiblas_blasfn sorbdb6;
    flexiblas_blasfn sorcsd;
    flexiblas_blasfn sorcsd2by1;
    flexiblas_blasfn sorg2l;
    flexiblas_blasfn sorg2r;
    flexiblas_blasfn sorgbr;
    flexiblas_blasfn sorghr;
    flexiblas_blasfn sorgl2;
    flexiblas_blasfn sorglq;
    flexiblas_blasfn sorgql;
    flexiblas_blasfn sorgqr;
    flexiblas_blasfn sorgr2;
    flexiblas_blasfn sorgrq;
    flexiblas_blasfn sorgtr;
    flexiblas_blasfn sorm22;
    flexiblas_blasfn sorm2l;
    flexiblas_blasfn sorm2r;
    flexiblas_blasfn sormbr;
    flexiblas_blasfn sormhr;
    flexiblas_blasfn sorml2;
    flexiblas_blasfn sormlq;
    flexiblas_blasfn sormql;
    flexiblas_blasfn sormqr;
    flexiblas_blasfn sormr2;
    flexiblas_blasfn sormr3;
    flexiblas_blasfn sormrq;
    flexiblas_blasfn sormrz;
    flexiblas_blasfn sormtr;
    flexiblas_blasfn spbcon;
    flexiblas_blasfn spbequ;
    flexiblas_blasfn spbrfs;
    flexiblas_blasfn spbstf;
    flexiblas_blasfn spbsv;
    flexiblas_blasfn spbsvx;
    flexiblas_blasfn spbtf2;
    flexiblas_blasfn spbtrf;
    flexiblas_blasfn spbtrs;
    flexiblas_blasfn spftrf;
    flexiblas_blasfn spftri;
    flexiblas_blasfn spftrs;
    flexiblas_blasfn spocon;
    flexiblas_blasfn spoequ;
    flexiblas_blasfn spoequb;
    flexiblas_blasfn sporfs;
    flexiblas_blasfn sposv;
    flexiblas_blasfn sposvx;
    flexiblas_blasfn spotf2;
    flexiblas_blasfn spotrf;
    flexiblas_blasfn spotrf2;
    flexiblas_blasfn spotri;
    flexiblas_blasfn spotrs;
    flexiblas_blasfn sppcon;
    flexiblas_blasfn sppequ;
    flexiblas_blasfn spprfs;
    flexiblas_blasfn sppsv;
    flexiblas_blasfn sppsvx;
    flexiblas_blasfn spptrf;
    flexiblas_blasfn spptri;
    flexiblas_blasfn spptrs;
    flexiblas_blasfn spstf2;
    flexiblas_blasfn spstrf;
    flexiblas_blasfn sptcon;
    flexiblas_blasfn spteqr;
    flexiblas_blasfn sptrfs;
    flexiblas_blasfn sptsv;
    flexiblas_blasfn sptsvx;
    flexiblas_blasfn spttrf;
    flexiblas_blasfn spttrs;
    flexiblas_blasfn sptts2;
    flexiblas_blasfn srscl;
    flexiblas_blasfn ssb2st_kernels;
    flexiblas_blasfn ssbev;
    flexiblas_blasfn ssbev_2stage;
    flexiblas_blasfn ssbevd;
    flexiblas_blasfn ssbevd_2stage;
    flexiblas_blasfn ssbevx;
    flexiblas_blasfn ssbevx_2stage;
    flexiblas_blasfn ssbgst;
    flexiblas_blasfn ssbgv;
    flexiblas_blasfn ssbgvd;
    flexiblas_blasfn ssbgvx;
    flexiblas_blasfn ssbtrd;
    flexiblas_blasfn ssfrk;
    flexiblas_blasfn sspcon;
    flexiblas_blasfn sspev;
    flexiblas_blasfn sspevd;
    flexiblas_blasfn sspevx;
    flexiblas_blasfn sspgst;
    flexiblas_blasfn sspgv;
    flexiblas_blasfn sspgvd;
    flexiblas_blasfn sspgvx;
    flexiblas_blasfn ssprfs;
    flexiblas_blasfn sspsv;
    flexiblas_blasfn sspsvx;
    flexiblas_blasfn ssptrd;
    flexiblas_blasfn ssptrf;
    flexiblas_blasfn ssptri;
    flexiblas_blasfn ssptrs;
    flexiblas_blasfn sstebz;
    flexiblas_blasfn sstedc;
    flexiblas_blasfn sstegr;
    flexiblas_blasfn sstein;
    flexiblas_blasfn sstemr;
    flexiblas_blasfn ssteqr;
    flexiblas_blasfn ssterf;
    flexiblas_blasfn sstev;
    flexiblas_blasfn sstevd;
    flexiblas_blasfn sstevr;
    flexiblas_blasfn sstevx;
    flexiblas_blasfn ssycon;
    flexiblas_blasfn ssycon_3;
    flexiblas_blasfn ssycon_rook;
    flexiblas_blasfn ssyconv;
    flexiblas_blasfn ssyconvf;
    flexiblas_blasfn ssyconvf_rook;
    flexiblas_blasfn ssyequb;
    flexiblas_blasfn ssyev;
    flexiblas_blasfn ssyev_2stage;
    flexiblas_blasfn ssyevd;
    flexiblas_blasfn ssyevd_2stage;
    flexiblas_blasfn ssyevr;
    flexiblas_blasfn ssyevr_2stage;
    flexiblas_blasfn ssyevx;
    flexiblas_blasfn ssyevx_2stage;
    flexiblas_blasfn ssygs2;
    flexiblas_blasfn ssygst;
    flexiblas_blasfn ssygv;
    flexiblas_blasfn ssygv_2stage;
    flexiblas_blasfn ssygvd;
    flexiblas_blasfn ssygvx;
    flexiblas_blasfn ssyrfs;
    flexiblas_blasfn ssysv;
    flexiblas_blasfn ssysv_aa;
    flexiblas_blasfn ssysv_rk;
    flexiblas_blasfn ssysv_rook;
    flexiblas_blasfn ssysvx;
    flexiblas_blasfn ssyswapr;
    flexiblas_blasfn ssytd2;
    flexiblas_blasfn ssytf2;
    flexiblas_blasfn ssytf2_rk;
    flexiblas_blasfn ssytf2_rook;
    flexiblas_blasfn ssytrd;
    flexiblas_blasfn ssytrd_2stage;
    flexiblas_blasfn ssytrd_sb2st;
    flexiblas_blasfn ssytrd_sy2sb;
    flexiblas_blasfn ssytrf;
    flexiblas_blasfn ssytrf_aa;
    flexiblas_blasfn ssytrf_rk;
    flexiblas_blasfn ssytrf_rook;
    flexiblas_blasfn ssytri;
    flexiblas_blasfn ssytri2;
    flexiblas_blasfn ssytri2x;
    flexiblas_blasfn ssytri_3;
    flexiblas_blasfn ssytri_3x;
    flexiblas_blasfn ssytri_rook;
    flexiblas_blasfn ssytrs;
    flexiblas_blasfn ssytrs2;
    flexiblas_blasfn ssytrs_3;
    flexiblas_blasfn ssytrs_aa;
    flexiblas_blasfn ssytrs_rook;
    flexiblas_blasfn stbcon;
    flexiblas_blasfn stbrfs;
    flexiblas_blasfn stbtrs;
    flexiblas_blasfn stfsm;
    flexiblas_blasfn stftri;
    flexiblas_blasfn stfttp;
    flexiblas_blasfn stfttr;
    flexiblas_blasfn stgevc;
    flexiblas_blasfn stgex2;
    flexiblas_blasfn stgexc;
    flexiblas_blasfn stgsen;
    flexiblas_blasfn stgsja;
    flexiblas_blasfn stgsna;
    flexiblas_blasfn stgsy2;
    flexiblas_blasfn stgsyl;
    flexiblas_blasfn stpcon;
    flexiblas_blasfn stplqt;
    flexiblas_blasfn stplqt2;
    flexiblas_blasfn stpmlqt;
    flexiblas_blasfn stpmqrt;
    flexiblas_blasfn stpqrt;
    flexiblas_blasfn stpqrt2;
    flexiblas_blasfn stprfb;
    flexiblas_blasfn stprfs;
    flexiblas_blasfn stptri;
    flexiblas_blasfn stptrs;
    flexiblas_blasfn stpttf;
    flexiblas_blasfn stpttr;
    flexiblas_blasfn strcon;
    flexiblas_blasfn strevc;
    flexiblas_blasfn strevc3;
    flexiblas_blasfn strexc;
    flexiblas_blasfn strrfs;
    flexiblas_blasfn strsen;
    flexiblas_blasfn strsna;
    flexiblas_blasfn strsyl;
    flexiblas_blasfn strti2;
    flexiblas_blasfn strtri;
    flexiblas_blasfn strtrs;
    flexiblas_blasfn strttf;
    flexiblas_blasfn strttp;
    flexiblas_blasfn stzrzf;
    flexiblas_blasfn zbbcsd;
    flexiblas_blasfn zbdsqr;
    flexiblas_blasfn zcgesv;
    flexiblas_blasfn zcposv;
    flexiblas_blasfn zdrscl;
    flexiblas_blasfn zgbbrd;
    flexiblas_blasfn zgbcon;
    flexiblas_blasfn zgbequ;
    flexiblas_blasfn zgbequb;
    flexiblas_blasfn zgbrfs;
    flexiblas_blasfn zgbsv;
    flexiblas_blasfn zgbsvx;
    flexiblas_blasfn zgbtf2;
    flexiblas_blasfn zgbtrf;
    flexiblas_blasfn zgbtrs;
    flexiblas_blasfn zgebak;
    flexiblas_blasfn zgebal;
    flexiblas_blasfn zgebd2;
    flexiblas_blasfn zgebrd;
    flexiblas_blasfn zgecon;
    flexiblas_blasfn zgeequ;
    flexiblas_blasfn zgeequb;
    flexiblas_blasfn zgees;
    flexiblas_blasfn zgeesx;
    flexiblas_blasfn zgeev;
    flexiblas_blasfn zgeevx;
    flexiblas_blasfn zgehd2;
    flexiblas_blasfn zgehrd;
    flexiblas_blasfn zgejsv;
    flexiblas_blasfn zgelq;
    flexiblas_blasfn zgelq2;
    flexiblas_blasfn zgelqf;
    flexiblas_blasfn zgelqt;
    flexiblas_blasfn zgelqt3;
    flexiblas_blasfn zgels;
    flexiblas_blasfn zgelsd;
    flexiblas_blasfn zgelss;
    flexiblas_blasfn zgelsy;
    flexiblas_blasfn zgemlq;
    flexiblas_blasfn zgemlqt;
    flexiblas_blasfn zgemqr;
    flexiblas_blasfn zgemqrt;
    flexiblas_blasfn zgeql2;
    flexiblas_blasfn zgeqlf;
    flexiblas_blasfn zgeqp3;
    flexiblas_blasfn zgeqr;
    flexiblas_blasfn zgeqr2;
    flexiblas_blasfn zgeqr2p;
    flexiblas_blasfn zgeqrf;
    flexiblas_blasfn zgeqrfp;
    flexiblas_blasfn zgeqrt;
    flexiblas_blasfn zgeqrt2;
    flexiblas_blasfn zgeqrt3;
    flexiblas_blasfn zgerfs;
    flexiblas_blasfn zgerq2;
    flexiblas_blasfn zgerqf;
    flexiblas_blasfn zgesc2;
    flexiblas_blasfn zgesdd;
    flexiblas_blasfn zgesv;
    flexiblas_blasfn zgesvd;
    flexiblas_blasfn zgesvdx;
    flexiblas_blasfn zgesvj;
    flexiblas_blasfn zgesvx;
    flexiblas_blasfn zgetc2;
    flexiblas_blasfn zgetf2;
    flexiblas_blasfn zgetrf;
    flexiblas_blasfn zgetrf2;
    flexiblas_blasfn zgetri;
    flexiblas_blasfn zgetrs;
    flexiblas_blasfn zgetsls;
    flexiblas_blasfn zggbak;
    flexiblas_blasfn zggbal;
    flexiblas_blasfn zgges;
    flexiblas_blasfn zgges3;
    flexiblas_blasfn zggesx;
    flexiblas_blasfn zggev;
    flexiblas_blasfn zggev3;
    flexiblas_blasfn zggevx;
    flexiblas_blasfn zggglm;
    flexiblas_blasfn zgghd3;
    flexiblas_blasfn zgghrd;
    flexiblas_blasfn zgglse;
    flexiblas_blasfn zggqrf;
    flexiblas_blasfn zggrqf;
    flexiblas_blasfn zggsvd3;
    flexiblas_blasfn zggsvp3;
    flexiblas_blasfn zgsvj0;
    flexiblas_blasfn zgsvj1;
    flexiblas_blasfn zgtcon;
    flexiblas_blasfn zgtrfs;
    flexiblas_blasfn zgtsv;
    flexiblas_blasfn zgtsvx;
    flexiblas_blasfn zgttrf;
    flexiblas_blasfn zgttrs;
    flexiblas_blasfn zgtts2;
    flexiblas_blasfn zhb2st_kernels;
    flexiblas_blasfn zhbev;
    flexiblas_blasfn zhbev_2stage;
    flexiblas_blasfn zhbevd;
    flexiblas_blasfn zhbevd_2stage;
    flexiblas_blasfn zhbevx;
    flexiblas_blasfn zhbevx_2stage;
    flexiblas_blasfn zhbgst;
    flexiblas_blasfn zhbgv;
    flexiblas_blasfn zhbgvd;
    flexiblas_blasfn zhbgvx;
    flexiblas_blasfn zhbtrd;
    flexiblas_blasfn zhecon;
    flexiblas_blasfn zhecon_3;
    flexiblas_blasfn zhecon_rook;
    flexiblas_blasfn zheequb;
    flexiblas_blasfn zheev;
    flexiblas_blasfn zheev_2stage;
    flexiblas_blasfn zheevd;
    flexiblas_blasfn zheevd_2stage;
    flexiblas_blasfn zheevr;
    flexiblas_blasfn zheevr_2stage;
    flexiblas_blasfn zheevx;
    flexiblas_blasfn zheevx_2stage;
    flexiblas_blasfn zhegs2;
    flexiblas_blasfn zhegst;
    flexiblas_blasfn zhegv;
    flexiblas_blasfn zhegv_2stage;
    flexiblas_blasfn zhegvd;
    flexiblas_blasfn zhegvx;
    flexiblas_blasfn zherfs;
    flexiblas_blasfn zhesv;
    flexiblas_blasfn zhesv_aa;
    flexiblas_blasfn zhesv_rk;
    flexiblas_blasfn zhesv_rook;
    flexiblas_blasfn zhesvx;
    flexiblas_blasfn zheswapr;
    flexiblas_blasfn zhetd2;
    flexiblas_blasfn zhetf2;
    flexiblas_blasfn zhetf2_rk;
    flexiblas_blasfn zhetf2_rook;
    flexiblas_blasfn zhetrd;
    flexiblas_blasfn zhetrd_2stage;
    flexiblas_blasfn zhetrd_hb2st;
    flexiblas_blasfn zhetrd_he2hb;
    flexiblas_blasfn zhetrf;
    flexiblas_blasfn zhetrf_aa;
    flexiblas_blasfn zhetrf_rk;
    flexiblas_blasfn zhetrf_rook;
    flexiblas_blasfn zhetri;
    flexiblas_blasfn zhetri2;
    flexiblas_blasfn zhetri2x;
    flexiblas_blasfn zhetri_3;
    flexiblas_blasfn zhetri_3x;
    flexiblas_blasfn zhetri_rook;
    flexiblas_blasfn zhetrs;
    flexiblas_blasfn zhetrs2;
    flexiblas_blasfn zhetrs_3;
    flexiblas_blasfn zhetrs_aa;
    flexiblas_blasfn zhetrs_rook;
    flexiblas_blasfn zhfrk;
    flexiblas_blasfn zhgeqz;
    flexiblas_blasfn zhpcon;
    flexiblas_blasfn zhpev;
    flexiblas_blasfn zhpevd;
    flexiblas_blasfn zhpevx;
    flexiblas_blasfn zhpgst;
    flexiblas_blasfn zhpgv;
    flexiblas_blasfn zhpgvd;
    flexiblas_blasfn zhpgvx;
    flexiblas_blasfn zhprfs;
    flexiblas_blasfn zhpsv;
    flexiblas_blasfn zhpsvx;
    flexiblas_blasfn zhptrd;
    flexiblas_blasfn zhptrf;
    flexiblas_blasfn zhptri;
    flexiblas_blasfn zhptrs;
    flexiblas_blasfn zhsein;
    flexiblas_blasfn zhseqr;
    flexiblas_blasfn zlabrd;
    flexiblas_blasfn zlacgv;
    flexiblas_blasfn zlacn2;
    flexiblas_blasfn zlacon;
    flexiblas_blasfn zlacp2;
    flexiblas_blasfn zlacpy;
    flexiblas_blasfn zlacrm;
    flexiblas_blasfn zlacrt;
    flexiblas_blasfn zladiv;
    flexiblas_blasfn zlaed0;
    flexiblas_blasfn zlaed7;
    flexiblas_blasfn zlaed8;
    flexiblas_blasfn zlaein;
    flexiblas_blasfn zlaesy;
    flexiblas_blasfn zlaev2;
    flexiblas_blasfn zlag2c;
    flexiblas_blasfn zlags2;
    flexiblas_blasfn zlagtm;
    flexiblas_blasfn zlahef;
    flexiblas_blasfn zlahef_aa;
    flexiblas_blasfn zlahef_rk;
    flexiblas_blasfn zlahef_rook;
    flexiblas_blasfn zlahqr;
    flexiblas_blasfn zlahr2;
    flexiblas_blasfn zlaic1;
    flexiblas_blasfn zlals0;
    flexiblas_blasfn zlalsa;
    flexiblas_blasfn zlalsd;
    flexiblas_blasfn zlamswlq;
    flexiblas_blasfn zlamtsqr;
    flexiblas_blasfn zlangb;
    flexiblas_blasfn zlange;
    flexiblas_blasfn zlangt;
    flexiblas_blasfn zlanhb;
    flexiblas_blasfn zlanhe;
    flexiblas_blasfn zlanhf;
    flexiblas_blasfn zlanhp;
    flexiblas_blasfn zlanhs;
    flexiblas_blasfn zlanht;
    flexiblas_blasfn zlansb;
    flexiblas_blasfn zlansp;
    flexiblas_blasfn zlansy;
    flexiblas_blasfn zlantb;
    flexiblas_blasfn zlantp;
    flexiblas_blasfn zlantr;
    flexiblas_blasfn zlapll;
    flexiblas_blasfn zlapmr;
    flexiblas_blasfn zlapmt;
    flexiblas_blasfn zlaqgb;
    flexiblas_blasfn zlaqge;
    flexiblas_blasfn zlaqhb;
    flexiblas_blasfn zlaqhe;
    flexiblas_blasfn zlaqhp;
    flexiblas_blasfn zlaqp2;
    flexiblas_blasfn zlaqps;
    flexiblas_blasfn zlaqr0;
    flexiblas_blasfn zlaqr1;
    flexiblas_blasfn zlaqr2;
    flexiblas_blasfn zlaqr3;
    flexiblas_blasfn zlaqr4;
    flexiblas_blasfn zlaqr5;
    flexiblas_blasfn zlaqsb;
    flexiblas_blasfn zlaqsp;
    flexiblas_blasfn zlaqsy;
    flexiblas_blasfn zlar1v;
    flexiblas_blasfn zlar2v;
    flexiblas_blasfn zlarcm;
    flexiblas_blasfn zlarf;
    flexiblas_blasfn zlarfb;
    flexiblas_blasfn zlarfg;
    flexiblas_blasfn zlarfgp;
    flexiblas_blasfn zlarft;
    flexiblas_blasfn zlarfx;
    flexiblas_blasfn zlarfy;
    flexiblas_blasfn zlargv;
    flexiblas_blasfn zlarnv;
    flexiblas_blasfn zlarrv;
    flexiblas_blasfn zlartg;
    flexiblas_blasfn zlartv;
    flexiblas_blasfn zlarz;
    flexiblas_blasfn zlarzb;
    flexiblas_blasfn zlarzt;
    flexiblas_blasfn zlascl;
    flexiblas_blasfn zlaset;
    flexiblas_blasfn zlasr;
    flexiblas_blasfn zlassq;
    flexiblas_blasfn zlaswlq;
    flexiblas_blasfn zlaswp;
    flexiblas_blasfn zlasyf;
    flexiblas_blasfn zlasyf_aa;
    flexiblas_blasfn zlasyf_rk;
    flexiblas_blasfn zlasyf_rook;
    flexiblas_blasfn zlat2c;
    flexiblas_blasfn zlatbs;
    flexiblas_blasfn zlatdf;
    flexiblas_blasfn zlatps;
    flexiblas_blasfn zlatrd;
    flexiblas_blasfn zlatrs;
    flexiblas_blasfn zlatrz;
    flexiblas_blasfn zlatsqr;
    flexiblas_blasfn zlauu2;
    flexiblas_blasfn zlauum;
    flexiblas_blasfn zpbcon;
    flexiblas_blasfn zpbequ;
    flexiblas_blasfn zpbrfs;
    flexiblas_blasfn zpbstf;
    flexiblas_blasfn zpbsv;
    flexiblas_blasfn zpbsvx;
    flexiblas_blasfn zpbtf2;
    flexiblas_blasfn zpbtrf;
    flexiblas_blasfn zpbtrs;
    flexiblas_blasfn zpftrf;
    flexiblas_blasfn zpftri;
    flexiblas_blasfn zpftrs;
    flexiblas_blasfn zpocon;
    flexiblas_blasfn zpoequ;
    flexiblas_blasfn zpoequb;
    flexiblas_blasfn zporfs;
    flexiblas_blasfn zposv;
    flexiblas_blasfn zposvx;
    flexiblas_blasfn zpotf2;
    flexiblas_blasfn zpotrf;
    flexiblas_blasfn zpotrf2;
    flexiblas_blasfn zpotri;
    flexiblas_blasfn zpotrs;
    flexiblas_blasfn zppcon;
    flexiblas_blasfn zppequ;
    flexiblas_blasfn zpprfs;
    flexiblas_blasfn zppsv;
    flexiblas_blasfn zppsvx;
    flexiblas_blasfn zpptrf;
    flexiblas_blasfn zpptri;
    flexiblas_blasfn zpptrs;
    flexiblas_blasfn zpstf2;
    flexiblas_blasfn zpstrf;
    flexiblas_blasfn zptcon;
    flexiblas_blasfn zpteqr;
    flexiblas_blasfn zptrfs;
    flexiblas_blasfn zptsv;
    flexiblas_blasfn zptsvx;
    flexiblas_blasfn zpttrf;
    flexiblas_blasfn zpttrs;
    flexiblas_blasfn zptts2;
    flexiblas_blasfn zrot;
    flexiblas_blasfn zspcon;
    flexiblas_blasfn zspmv;
    flexiblas_blasfn zspr;
    flexiblas_blasfn zsprfs;
    flexiblas_blasfn zspsv;
    flexiblas_blasfn zspsvx;
    flexiblas_blasfn zsptrf;
    flexiblas_blasfn zsptri;
    flexiblas_blasfn zsptrs;
    flexiblas_blasfn zstedc;
    flexiblas_blasfn zstegr;
    flexiblas_blasfn zstein;
    flexiblas_blasfn zstemr;
    flexiblas_blasfn zsteqr;
    flexiblas_blasfn zsycon;
    flexiblas_blasfn zsycon_3;
    flexiblas_blasfn zsycon_rook;
    flexiblas_blasfn zsyconv;
    flexiblas_blasfn zsyconvf;
    flexiblas_blasfn zsyconvf_rook;
    flexiblas_blasfn zsyequb;
    flexiblas_blasfn zsymv;
    flexiblas_blasfn zsyr;
    flexiblas_blasfn zsyrfs;
    flexiblas_blasfn zsysv;
    flexiblas_blasfn zsysv_aa;
    flexiblas_blasfn zsysv_rk;
    flexiblas_blasfn zsysv_rook;
    flexiblas_blasfn zsysvx;
    flexiblas_blasfn zsyswapr;
    flexiblas_blasfn zsytf2;
    flexiblas_blasfn zsytf2_rk;
    flexiblas_blasfn zsytf2_rook;
    flexiblas_blasfn zsytrf;
    flexiblas_blasfn zsytrf_aa;
    flexiblas_blasfn zsytrf_rk;
    flexiblas_blasfn zsytrf_rook;
    flexiblas_blasfn zsytri;
    flexiblas_blasfn zsytri2;
    flexiblas_blasfn zsytri2x;
    flexiblas_blasfn zsytri_3;
    flexiblas_blasfn zsytri_3x;
    flexiblas_blasfn zsytri_rook;
    flexiblas_blasfn zsytrs;
    flexiblas_blasfn zsytrs2;
    flexiblas_blasfn zsytrs_3;
    flexiblas_blasfn zsytrs_aa;
    flexiblas_blasfn zsytrs_rook;
    flexiblas_blasfn ztbcon;
    flexiblas_blasfn ztbrfs;
    flexiblas_blasfn ztbtrs;
    flexiblas_blasfn ztfsm;
    flexiblas_blasfn ztftri;
    flexiblas_blasfn ztfttp;
    flexiblas_blasfn ztfttr;
    flexiblas_blasfn ztgevc;
    flexiblas_blasfn ztgex2;
    flexiblas_blasfn ztgexc;
    flexiblas_blasfn ztgsen;
    flexiblas_blasfn ztgsja;
    flexiblas_blasfn ztgsna;
    flexiblas_blasfn ztgsy2;
    flexiblas_blasfn ztgsyl;
    flexiblas_blasfn ztpcon;
    flexiblas_blasfn ztplqt;
    flexiblas_blasfn ztplqt2;
    flexiblas_blasfn ztpmlqt;
    flexiblas_blasfn ztpmqrt;
    flexiblas_blasfn ztpqrt;
    flexiblas_blasfn ztpqrt2;
    flexiblas_blasfn ztprfb;
    flexiblas_blasfn ztprfs;
    flexiblas_blasfn ztptri;
    flexiblas_blasfn ztptrs;
    flexiblas_blasfn ztpttf;
    flexiblas_blasfn ztpttr;
    flexiblas_blasfn ztrcon;
    flexiblas_blasfn ztrevc;
    flexiblas_blasfn ztrevc3;
    flexiblas_blasfn ztrexc;
    flexiblas_blasfn ztrrfs;
    flexiblas_blasfn ztrsen;
    flexiblas_blasfn ztrsna;
    flexiblas_blasfn ztrsyl;
    flexiblas_blasfn ztrti2;
    flexiblas_blasfn ztrtri;
    flexiblas_blasfn ztrtrs;
    flexiblas_blasfn ztrttf;
    flexiblas_blasfn ztrttp;
    flexiblas_blasfn ztzrzf;
    flexiblas_blasfn zunbdb;
    flexiblas_blasfn zunbdb1;
    flexiblas_blasfn zunbdb2;
    flexiblas_blasfn zunbdb3;
    flexiblas_blasfn zunbdb4;
    flexiblas_blasfn zunbdb5;
    flexiblas_blasfn zunbdb6;
    flexiblas_blasfn zuncsd;
    flexiblas_blasfn zuncsd2by1;
    flexiblas_blasfn zung2l;
    flexiblas_blasfn zung2r;
    flexiblas_blasfn zungbr;
    flexiblas_blasfn zunghr;
    flexiblas_blasfn zungl2;
    flexiblas_blasfn zunglq;
    flexiblas_blasfn zungql;
    flexiblas_blasfn zungqr;
    flexiblas_blasfn zungr2;
    flexiblas_blasfn zungrq;
    flexiblas_blasfn zungtr;
    flexiblas_blasfn zunm22;
    flexiblas_blasfn zunm2l;
    flexiblas_blasfn zunm2r;
    flexiblas_blasfn zunmbr;
    flexiblas_blasfn zunmhr;
    flexiblas_blasfn zunml2;
    flexiblas_blasfn zunmlq;
    flexiblas_blasfn zunmql;
    flexiblas_blasfn zunmqr;
    flexiblas_blasfn zunmr2;
    flexiblas_blasfn zunmr3;
    flexiblas_blasfn zunmrq;
    flexiblas_blasfn zunmrz;
    flexiblas_blasfn zunmtr;
    flexiblas_blasfn zupgtr;
    flexiblas_blasfn zupmtr;

} flexiblas_lapack_backend_t;

#ifdef __cplusplus
}
#endif

#endif

