MODULE CSC_COMMON
    USE ISO_C_BINDING
    IMPLICIT NONE


    INTERFACE
        FUNCTION CSC_WTIME_C() BIND(C,name="csc_wtime")
            IMPORT
            REAL(KIND=C_DOUBLE) ::  CSC_WTIME_C
        END FUNCTION CSC_WTIME_C

        FUNCTION CSC_CTIME_C() BIND(C,name="csc_ctime")
            IMPORT
            REAL(KIND=C_DOUBLE) ::  CSC_CTIME_C
        END FUNCTION CSC_CTIME_C

        FUNCTION CSC_CYCLES_C() BIND(C,name="csc_cycles")
            IMPORT
            INTEGER(KIND=C_INT64_T) :: CSC_CYCLES_C
        END FUNCTION CSC_CYCLES_C



    END INTERFACE
CONTAINS
    INCLUDE 'quad.f90'

    DOUBLE PRECISION FUNCTION CSC_WTIME()
        IMPLICIT NONE
        DOUBLE PRECISION TMP

        TMP = CSC_WTIME_C()

        CSC_WTIME = DBLE(TMP)
        RETURN
    END FUNCTION CSC_WTIME

    DOUBLE PRECISION FUNCTION CSC_CTIME()
        IMPLICIT NONE
        DOUBLE PRECISION TMP

        TMP = CSC_CTIME_C()

        CSC_CTIME = DBLE(TMP)
        RETURN
    END FUNCTION CSC_CTIME

    INTEGER FUNCTION CSC_CYCLES()
        IMPLICIT NONE
        INTEGER(C_INT64_T) :: TMP

        TMP = CSC_CYCLES_C()
        CSC_CYCLES = INT(TMP)
        RETURN
    END FUNCTION CSC_CYCLES

    CHARACTER(LEN=25) FUNCTION INT2STR(K)
        INTEGER, INTENT(IN) :: K
        CHARACTER(LEN = 25) :: ST
        WRITE (ST, *) K
        INT2STR = TRIM(ADJUSTL(ST))
    END FUNCTION INT2STR

    CHARACTER(LEN=25) FUNCTION DBLE2STR(K)
        DOUBLE PRECISION, INTENT(IN) :: K
        WRITE (DBLE2STR,'( D15.7 )') K
        DBLE2STR = TRIM(ADJUSTL(DBLE2STR))
    END FUNCTION DBLE2STR

END MODULE CSC_COMMON
