# React Components & Libraries

 - Official website: [`devarchy.com/react`](https://devarchy.com/react)
 - Use devarchy to add a library to the catalog
 - This readme is updated when a Library is approved on Devarchy. (Meaning that all new libraries awaiting for approval are visible only on Devarchy.)

<br/>

#### Contents

- [UI Components](#ui-components)
  - [Table / Data Grid](#table--data-grid)
  - [Infinite Scroll](#infinite-scroll)
  - [Overlay](#overlay)
  - [Notification](#notification)
  - [Tooltip](#tooltip)
  - [Menu](#menu)
  - [Sticky](#sticky)
  - [Tabs](#tabs)
  - [Loader](#loader)
  - [Carousel](#carousel)
  - [Collapse](#collapse)
  - [Chart](#chart)
  - [Tree](#tree)
  - [UI Navigation](#ui-navigation)
  - [Custom Scrollbar](#custom-scrollbar)
  - [Audio / Video](#audio--video)
  - [Map](#map)
  - [Time / Date / Age](#time--date--age)
  - [Photo / Image](#photo--image)
  - [Icons](#icons)
  - [Paginator](#paginator)
  - [Markdown Viewer](#markdown-viewer)
  - [Miscellaneous](#miscellaneous)
  - [Form Components](#form-components)
    - [Date / Time picker](#date--time-picker)
    - [Input Types](#input-types)
    - [Autocomplete](#autocomplete)
    - [Select](#select)
    - [Color Picker](#color-picker)
    - [Toggle](#toggle)
    - [Slider](#slider)
    - [Radio Button](#radio-button)
    - [Type Select](#type-select)
    - [Autosize Input / Textarea](#autosize-input--textarea)
    - [Star Rating](#star-rating)
    - [Drag and Drop](#drag-and-drop)
    - [Sortable List](#sortable-list)
    - [Rich Text Editor](#rich-text-editor)
    - [Markdown Editor](#markdown-editor)
    - [Image Editing](#image-editing)
    - [Form Component Collections](#form-component-collections)
    - [Miscellaneous](#miscellaneous-1)
- [UI Layout](#ui-layout)
- [UI Animation](#ui-animation)
  - [Parallax](#parallax)
- [UI Frameworks](#ui-frameworks)
  - [Responsive](#responsive)
    - [Bootstrap](#bootstrap)
    - [Material Design](#material-design)
  - [Mobile](#mobile)
  - [Component Collections](#component-collections)
  - [Other](#other)
- [UI Utilites](#ui-utilites)
  - [Reporter](#reporter)
    - [Visibility Reporter](#visibility-reporter)
    - [Measurement Reporter](#measurement-reporter)
  - [Device Input](#device-input)
    - [Keyboard Events](#keyboard-events)
    - [Scroll Events](#scroll-events)
    - [Touch Events](#touch-events)
    - [Touch Swipe](#touch-swipe)
    - [Mouse Events](#mouse-events)
  - [Meta Tags](#meta-tags)
  - [Portal](#portal)
  - [Test User Behavior](#test-user-behavior)
- [Code Design](#code-design)
  - [Data Store](#data-store)
  - [Form Logic](#form-logic)
  - [Router](#router)
  - [Props from server](#props-from-server)
  - [Communication with server](#communication-with-server)
  - [CSS / Style](#css--style)
  - [HTML Template](#html-template)
  - [Isomorphic Apps](#isomorphic-apps)
  - [Boilerplate](#boilerplate)
  - [Miscellaneous](#miscellaneous-2)
- [Utilities](#utilities)
  - [i18n](#i18n)
  - [Framework bindings / integrations](#framework-bindings--integrations)
  - [Integrations with Third Party Services](#integrations-with-third-party-services)
- [Performance](#performance)
  - [UI](#ui)
    - [Inspect](#inspect)
    - [Lazy Load](#lazy-load)
  - [App Size](#app-size)
- [Dev Tools](#dev-tools)
  - [Test](#test)
  - [Redux](#redux)
  - [Inspect](#inspect-1)
  - [Miscellaneous](#miscellaneous-3)
- [Miscellaneous](#miscellaneous-4)
  - [Static Website Generator](#static-website-generator)

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

## UI Components

### Table / Data Grid

 - [reactable](https://github.com/glittershark/reactable) - Fast, flexible, and simple data tables in React.
 - [ag-grid](https://github.com/ceolter/ag-grid) - Advanced Data Grid / Data Table supporting Javascript / React / AngularJS / Web Components.
 - [griddle-react](https://github.com/GriddleGriddle/Griddle) - Simple Grid Component written in React.
 - [react-data-components](https://github.com/carlosrocha/react-data-components) - React components for sorting, filtering and pagination of data.
 - [react-bootstrap-table](https://github.com/AllenFang/react-bootstrap-table) - It&#39;s a react table for bootstrap.
 - [react-data-grid](https://github.com/adazzle/react-data-grid) - Excel-like grid component built with React, with editors, keyboard navigation, copy &amp; paste, and the like.
 - [react-pivot](https://github.com/davidguttman/react-pivot) - React-Pivot is a data-grid component with pivot-table-like functionality for data display, filtering, and exploration.
 - [autoresponsive-react](https://github.com/xudafeng/autoresponsive-react) - Auto Responsive Layout Library For React.
 - [reactabular](https://github.com/reactabular/reactabular) - Spectacular tables for React.
 - [fixed-data-table](https://github.com/facebook/fixed-data-table) - A React table component designed to allow presenting thousands of rows of data.
 - [sematable](https://github.com/sematext/sematable) - Client side sorting, pagination, and text filter for redux/react based apps.


### Infinite Scroll

 - [react-lazyload](https://github.com/jasonslyvia/react-lazyload) - Lazyload your Component, Image or anything matters the performance.
 - [react-infinity](https://github.com/nmn/react-infinity) - A UITableView Inspired list and grid display solution with element culling and smooth animations.
 - [react-infinite](https://github.com/seatgeek/react-infinite) - A browser-ready efficient scrolling container based on UITableView.
 - [react-infinite-grid](https://github.com/ggordan/react-infinite-grid) - A React component which renders a grid of elements.
 - [react-list](https://github.com/orgsync/react-list) - A versatile infinite scroll React component.
 - [react-virtualized](https://github.com/bvaughn/react-virtualized) - React components for efficiently rendering large lists and tabular data.


### Overlay

*Display overlay / modal / alert / dialog / lightbox / popup*

 - [react-dock](https://github.com/alexkuz/react-dock) - Resizable dockable react component.
 - [react-overlays](https://github.com/react-bootstrap/react-overlays) - Utilities for creating robust overlay components.
 - [boron](https://github.com/yuanyan/boron) - A collection of dialog animations with React.js.
 - [react-modal2](https://github.com/cloudflare/react-modal2) - Simple modal component for React.
 - [react-modal](https://github.com/reactjs/react-modal) - Accessible modal dialog component for React.
 - [react-skylight](https://github.com/marcio/react-skylight) - A react component for modals and dialogs.
 - [rodal](https://github.com/chenjiahan/rodal) - A React modal with animations.
 - [react-modal-box](https://github.com/sadiqevani/react-modal-box) - React Modal Box Component.
 - [react-aria-modal](https://github.com/davidtheclark/react-aria-modal) - A fully accessible and flexible React modal built according WAI-ARIA Authoring Practices.


### Notification

*Toaster / snackbar — Notify the user with a modeless temporary little popup*

 - [react-notification-system](https://github.com/igorprado/react-notification-system) - A complete and totally customizable component for notifications in React.
 - [react-notification](https://github.com/pburtchaell/react-notification) - Snackbar notifications for React.
 - [react-s-alert](https://github.com/juliancwirko/react-s-alert) - Alerts / Notifications for React with rich configuration options.
 - [react-crouton](https://github.com/xeodou/react-crouton) - A message component for reactjs.
 - [reapop](https://github.com/LouisBarranqueiro/reapop) - A React & Redux notifications system.


### Tooltip

 - [react-tooltip](https://github.com/wwayne/react-tooltip) - React tooltip component.
 - [rc-tooltip](https://github.com/react-component/tooltip) - React Tooltip.
 - [react-portal-tooltip](https://github.com/romainberger/react-portal-tooltip) - Awesome React tooltips.


### Menu

*Menus / sidebars*

 - [react-burger-menu](https://github.com/negomi/react-burger-menu) - An off-canvas sidebar component with a collection of effects and styles using CSS transitions and SVG path animations.
 - [react-sidebar](https://github.com/balloob/react-sidebar) - A sidebar component for React.
 - [react-motion-menu](https://github.com/bokuweb/react-motion-menu) - Motion menu component powered by React Motion.
 - [react-offcanvas](https://github.com/vutran/react-offcanvas) - Off-canvas menus for React.
 - [react-tree-menu](https://github.com/MandarinConLaBarba/react-tree-menu) - A stateless tree menu component for React.
 - [react-metismenu](https://github.com/alpertuna/react-metismenu) - A ready-to-use menu component for React.
 - [react-contextmenu](https://github.com/vkbansal/react-contextmenu) - Context Menu implemented in React.
 - [rc-menu](https://github.com/react-component/menu) - React Menu.


### Sticky

*Fixed headers / scroll-up headers / sticky elements*

 - [react-sticky](https://github.com/captivationsoftware/react-sticky) - &lt;Sticky /&gt; component for awesome React apps.
 - [react-headroom](https://github.com/KyleAMathews/react-headroom) - Hide your header until you need it.
 - [react-listview-sticky-header](https://github.com/cht8687/react-listview-sticky-header) - React listview with sticky section header.
 - [react-sticky-state](https://github.com/soenkekluth/react-sticky-state) - React StickyState Component makes native position:sticky statefull and polyfills the missing sticky browser feature.
 - [react-stickynode](https://github.com/yahoo/react-stickynode) - A performant and comprehensive React sticky.
 - [react-sticky-node](https://github.com/visortelle/react-sticky-node) - Sticky react component.


### Tabs

 - [react-tabs](https://github.com/reactjs/react-tabs) - React tabs component.
 - [react-simpletabs](https://github.com/pedronauck/react-simpletabs) - Just a simple tabs component built with React.
 - [react-tabtab](https://github.com/ctxhou/react-tabtab) - React, tabs.


### Loader

*Loaders / spinners / progress bars — Let the user know that something is loading*

 - [halogen](https://github.com/yuanyan/halogen) - A collection of loading spinners with React.js.
 - [react-ladda](https://github.com/jsdir/react-ladda) - React wrapper for Ladda buttons.
 - [react-progress-button](https://github.com/mathieudutour/react-progress-button) - Simple react.js component for an inline progress indicator.
 - [react-loader](https://github.com/TheCognizantFoundry/react-loader) - React component that displays a spinner via spin.js until your component is loaded.
 - [react-spinkit](https://github.com/KyleAMathews/react-spinkit) - A collection of loading indicators animated with CSS for React.
 - [react-progress-label](https://github.com/wangzuo/react-progress-label) - Progress label component.
 - [react-redux-loading-bar](https://github.com/mironov/react-redux-loading-bar) - Simple Loading Bar for Redux and React.
 - [react-loaders](https://github.com/jonjaques/react-loaders) - Lightweight wrapper around Loaders.css.
 - [react-md-spinner](https://github.com/tsuyoshiwada/react-md-spinner) - Material Design spinner components for React.js.
 - [rc-progress](https://github.com/react-component/progress) - React Progress Bar.
 - [react-block-ui](https://github.com/availity/react-block-ui) - Easy way to block the user from interacting with your UI.


### Carousel

 - [react-slick](https://github.com/akiran/react-slick) - React carousel component.
 - [react-responsive-carousel](https://github.com/leandrowd/react-responsive-carousel) - React.js Responsive Carousel (with Swipe).


### Collapse

 - [react-collapse](https://github.com/nkbt/react-collapse) - Component-wrapper for collapse animation with react-motion for elements with variable (and dynamic) height.
 - [react-accessible-accordion](https://github.com/springload/react-accessible-accordion) - Accessible Accordion component for React.


### Chart

*Display data in charts / graphs / diagrams*

 - [react-chartist](https://github.com/fraserxu/react-chartist) - React component for Chartist.js.
 - [d3-react-squared](https://github.com/bgrsquared/d3-react-squared) - Lightweight event system for (d3) charts and other components for ReactJS.
 - [react-d3-components](https://github.com/codesuki/react-d3-components) - D3 Components for React.
 - [recharts](https://github.com/recharts/recharts) - Redefined chart library built with React and D3.
 - [react-chartjs](https://github.com/reactjs/react-chartjs) - Common react charting components using chart.js.
 - [react-dazzle](https://github.com/Raathigesh/Dazzle) - Dashboards made easy in React JS.
 - [react-vis](https://github.com/uber/react-vis) - Data visualization library based on React and d3.
 - [react-sparkline](https://github.com/KyleAMathews/react-sparkline) - React component for rendering simple sparklines.
 - [react-sparklines](https://github.com/borisyankov/react-sparklines) - Beautiful and expressive Sparklines React component.
 - [rumble-charts](https://github.com/RumbleInc/rumble-js-charts) - React components for building composable and flexible charts.
 - [react-micro-bar-chart](https://github.com/KyleAMathews/react-micro-bar-chart) - React component for micro bar-charts rendered with D3.
 - [react-timeseries-charts](https://github.com/esnet/react-timeseries-charts) - Declarative timeseries charts.
 - [react-google-charts](https://github.com/RakanNimer/react-google-charts) - React-google-charts React component.
 - [victory](https://github.com/FormidableLabs/victory) - Data viz for React.
 - [react-sigmajs](https://github.com/dunnock/react-sigma) - Lightweight but powerful library for drawing network graphs built on top of SigmaJS.
 - [chartify](https://github.com/kirillstepkin/chartify) - React.js plugin for building animated draggable and customizable charts.
 - [react-highcharts](https://github.com/kirjs/react-highcharts) - React-highcharts.
 - [react-trend](https://github.com/unsplash/react-trend) - Simple, elegant spark lines.


### Tree

*Display a tree data structure*

 - [react-treeview](https://github.com/chenglou/react-treeview) - Easy, light, flexible tree view made with React.
 - [react-ui-tree](https://github.com/pqx/react-ui-tree) - React tree component.
 - [react-treebeard](https://github.com/alexcurtis/react-treebeard) - React Tree View Component. Data-Driven, Fast, Efficient and Customisable.


### UI Navigation

*Ways to navigate views*

 - [react-scroll](https://github.com/fisshy/react-scroll) - React scroll component.
 - [react-swipe-views](https://github.com/damusnet/react-swipe-views) - A React Component for binded Tabs and Swipeable Views.


### Custom Scrollbar

 - [react-custom-scrollbars](https://github.com/malte-wessel/react-custom-scrollbars) - React scrollbars component.
 - [react-scrollbar](https://github.com/souhe/reactScrollbar) - Scrollbar component for React.
 - [react-smooth-scrollbar](https://github.com/idiotWu/react-smooth-scrollbar) - React implementation of smooth-scrollbar.
 - [react-gemini-scrollbar](https://github.com/noeldelgado/react-gemini-scrollbar) - React component for custom overlay-scrollbars with native scrolling mechanism.
 - [react-custom-scroll](https://github.com/rommguy/react-custom-scroll) - Easily customize the browser scroll bar with native OS scroll behavior.


### Audio / Video

 - [react-player](https://github.com/CookPete/react-player) - A react component for playing a variety of URLs, including file paths, YouTube, SoundCloud and Vimeo.
 - [react-youtube](https://github.com/troybetz/react-youtube) - React.js powered YouTube player component.
 - [react-soundplayer](https://github.com/soundblogs/react-soundplayer) - Create custom SoundCloud players with React.
 - [react-video](https://github.com/pedronauck/react-video) - React component to load video from Vimeo or Youtube across any device.
 - [react-music](https://github.com/FormidableLabs/react-music) - Make beats with React.
 - [react-dailymotion](https://github.com/u-wave/react-dailymotion) - Dailymotion player component for React.
 - [video-react](https://github.com/video-react/video-react) - A web video player built for the HTML5 world using React library.


### Map

 - [react-gmaps](https://github.com/MicheleBertoli/react-gmaps) - A Google Maps component for React.js.
 - [google-map-react](https://github.com/istarkov/google-map-react) - Universal google map react component, allows render react components on the google map.
 - [react-googlemaps](https://github.com/pieterv/react-googlemaps) - A declarative React interface to Google Maps.
 - [react-leaflet](https://github.com/PaulLeCam/react-leaflet) - React components for Leaflet maps.
 - [react-geosuggest](https://github.com/ubilabs/react-geosuggest) - A React autosuggest for the Google Maps Places API.
 - [react-map-gl](https://github.com/uber/react-map-gl) - A React wrapper for MapboxGL-js and overlay API.
 - [react-mapbox-gl](https://github.com/alex3165/react-mapbox-gl) - A React binding of mapbox-gl-js.


### Time / Date / Age

*Display time / date / age*

 - [react-time](https://github.com/andreypopp/react-time) - Component for React to render relative and/or formatted dates into &lt;time&gt; HTML5 element.
 - [react-timeago](https://github.com/nmn/react-timeago) - A simple time-ago component for ReactJs.
 - [timeago-react](https://github.com/hustcc/timeago-react) - Simple and efficient react component to format date with `*** time ago` statement. eg: '3 hours ago'.


### Photo / Image

*Display images / photos*

 - [react-image-gallery](https://github.com/xiaolin/react-image-gallery) - Responsive image gallery, carousel, image slider react component.
 - [react-images](https://github.com/jossmac/react-images) - A simple lightbox component for displaying an array of images.
 - [react-photo-gallery](https://github.com/neptunian/react-photo-gallery) - Responsive React Photo Gallery.
 - [react-svg-pan-zoom](https://github.com/chrvadala/react-svg-pan-zoom) - A React component that adds pan and zoom features to SVG.
 - [react-image-lightbox](https://github.com/fritz-c/react-image-lightbox) - React lightbox component.
 - [react-intense](https://github.com/brycedorn/react-intense) - A React component for viewing large images up close.


### Icons

*Display icons / icon set / emojis*

 - [react-icons](https://github.com/gorangajic/react-icons) - Svg react icons of popular icon packs using ES6 imports.
 - [react-emoji](https://github.com/banyan/react-emoji) - An emoji mixin for React.
 - [react-emoji-react](https://github.com/conorhastings/react-emoji-react) - A clone of slack emoji reactions in react.


### Paginator

*Display a control element to paginate*

 - [react-paginate](https://github.com/AdeleD/react-paginate) - A ReactJS component that creates a pagination.


### Markdown Viewer

*Display parsed markdow source*

 - [react-markdown](https://github.com/rexxars/react-markdown) - Render Markdown as React components.


### Miscellaneous

 - [react-timesheet](https://github.com/yuanyan/react-timesheet) - Time Sheet Component for React.
 - [react-blur](https://github.com/javierbyte/react-blur) - React component for blurred backgrounds.
 - [react-split-pane](https://github.com/tomkp/react-split-pane) - React split-pane component.
 - [typography](https://github.com/KyleAMathews/typography.js) - A powerful toolkit for building websites with beautiful typography.
 - [react-json-tree](https://github.com/alexkuz/react-json-tree) - React JSON Viewer Component, Extracted from redux-devtools.
 - [react-resizable-and-movable](https://github.com/bokuweb/react-resizable-and-movable) - Resizable and movable component for React.
 - [react-dnr](https://github.com/yongxu/react-DnR) - Dragable and Resizable window build with React.js.
 - [react-resizable-box](https://github.com/bokuweb/react-resizable-box) - Resizable component for React. #reactjs.
 - [react-file-reader-input](https://github.com/ngokevin/react-file-reader-input) - React file input component for complete control over styling and abstraction from file reading.
 - [react-pagespeed-score](https://github.com/cauealves/react-pagespeed-score) - A React component for display a dial-type chart of PageSpeed Insights.
 - [react-autolink](https://github.com/banyan/react-autolink) - An autolink mixin for React.
 - [react-svg-buttons](https://github.com/plouc/react-svg-buttons) - Configurable animated SVG buttons for react.
 - [react-avatar](https://github.com/Sitebase/react-avatar) - Universal React avatar component makes it possible to generate avatars based on user information.
 - [react-joyride](https://github.com/gilbarbara/react-joyride) - Create walkthroughs and guided tours for your ReactJS apps. Now with standalone tooltips!.
 - [material-color-hash](https://github.com/BelkaLab/material-color-hash) - Hash strings to Material UI colors.
 - [react-facebook](https://github.com/CherryProjects/react-facebook) - Facebook components like a Login button, Like, Share, Comments, Page or Embedded Post.




### Form Components

*Let the user enter data*

#### Date / Time picker

*Date picker / time picker / datetime picker / date range picker*

 - [react-datepicker](https://github.com/Hacker0x01/react-datepicker) - A simple and reusable datepicker component for React.
 - [rc-calendar](https://github.com/react-component/calendar) - React Calendar.
 - [react-date-range](https://github.com/Adphorus/react-date-range) - A React component for choosing dates and date ranges.
 - [react-day-picker](https://github.com/gpbl/react-day-picker) - Flexible date picker for React.
 - [react-daterange-picker](https://github.com/onefinestay/react-daterange-picker) - A React based date range picker.
 - [react-yearly-calendar](https://github.com/BelkaLab/react-yearly-calendar) - React.js Yearly Calendar Component.
 - [react-calendar](https://github.com/freiksenet/react-calendar) - A modular toolkit to build calendar-related things in React.
 - [input-moment](https://github.com/wangzuo/input-moment) - React datetime picker powered by momentjs.
 - [react-datetime](https://github.com/YouCanBookMe/react-datetime) - A lightweight but complete datetime picker react component.
 - [react-bootstrap-datetimepicker](https://github.com/quri/react-bootstrap-datetimepicker) - A react.js datetime picker for bootstrap.
 - [react-bootstrap-daterangepicker](https://github.com/skratchdot/react-bootstrap-daterangepicker) - A date/time picker for react (using bootstrap). This is a react port of bootstrap-daterangepicker.
 - [react-big-calendar](https://github.com/intljusticemission/react-big-calendar) - Gcal/outlook like calendar component.
 - [react-date-select](https://github.com/JedWatson/react-date-select) - A React Date Select / Picker Input Component.
 - [react-infinite-calendar](https://github.com/clauderic/react-infinite-calendar) - Infinite scrolling date-picker built with React, with localization, themes, keyboard support, and more.
 - [react-dates](https://github.com/airbnb/react-dates) - An easily internationalizable, mobile-friendly datepicker library for the web.
 - [react-flatpickr](https://github.com/coderhaoxin/react-flatpickr) - Flatpickr for React.


#### Input Types

*Masked inputs, specialized inputs; email / telephone number / credit card / etc.*

 - [react-input-mask](https://github.com/sanniassin/react-input-mask) - Yet another react component for input masking.
 - [react-maskedinput](https://github.com/insin/react-maskedinput) - Masked &lt;input/&gt; React component.
 - [react-text-mask](https://github.com/msafi/text-mask) - Input mask for React, Angular, and vanilla JavaScript. Flexible, robust &amp; tiny.
 - [react-credit-cards](https://github.com/amarofashion/react-credit-cards) - Beautiful credit cards for your payment forms.


#### Autocomplete

*Autosuggest / autocomplete / typeahead*

 - [react-autosuggest](https://github.com/moroshko/react-autosuggest) - WAI-ARIA compliant React autosuggest component.
 - [react-typeahead](https://github.com/fmoo/react-typeahead) - Pure react-based typeahead and typeahead-tokenizer.
 - [react-typeahead-component](https://github.com/ezequiel/react-typeahead-component) - Typeahead, written using the React.js library.


#### Select

 - [react-selectize](https://github.com/furqanZafar/react-selectize) - A Stateless &amp; Flexible Select component for React inspired by Selectize.
 - [react-aria-menubutton](https://github.com/davidtheclark/react-aria-menubutton) - A fully accessible, easily themeable, React-powered menu button.
 - [react-select](https://github.com/JedWatson/react-select) - A Select control built with and for React JS.
 - [react-select-box](https://github.com/instructure-react/react-select-box) - An accessible select box component for React.


#### Color Picker

 - [react-input-color](https://github.com/wangzuo/react-input-color) - React input color component with hsv color picker.
 - [react-color](https://github.com/casesandberg/react-color) - Color Pickers from Sketch, Photoshop, Chrome & more.
 - [coloreact](https://github.com/elrumordelaluz/coloreact) - A tiny Color Picker for React.


#### Toggle

 - [react-toggle](https://github.com/instructure-react/react-toggle) - An elegant, accessible toggle component for React. Also a glorified checkbox.
 - [react-ios-switch](https://github.com/clari/react-ios-switch) - React switch component.


#### Slider

 - [rc-slider](https://github.com/react-component/slider) - React Slider.
 - [react-slider](https://github.com/mpowaga/react-slider) - Slider component for React.


#### Radio Button

 - [react-radio-group](https://github.com/chenglou/react-radio-group) - Better radio buttons.


#### Type Select

*Let the user select something (e.g. a tag) while typing*

 - [react-tagsinput](https://github.com/olahol/react-tagsinput) - A simple react component for inputing tags.
 - [react-tag-input](https://github.com/prakhar1989/react-tags) - A fantastically simple tagging component for your React projects.
 - [react-mentions](https://github.com/effektif/react-mentions) - Mention people in a textarea.
 - [react-tokeninput](https://github.com/instructure-react/react-tokeninput) - Tokeninput component for React.
 - [react-autocomplete-input](https://github.com/yury-dymov/react-autocomplete-input) - Autocomplete input field for React.


#### Autosize Input / Textarea

 - [react-input-autosize](https://github.com/JedWatson/react-input-autosize) - Auto-resizing input field for React.
 - [react-textarea-autosize](https://github.com/andreypopp/react-textarea-autosize) - &lt;textarea /&gt; component for React which grows with content.


#### Star Rating

 - [react-star-rating](https://github.com/cameronroe/react-star-rating) - A simple star rating component built with React.
 - [react-star-rating-input](https://github.com/ikr/react-star-rating-input) - React.js component for entering 0-5 (or more) stars.


#### Drag and Drop

 - [react-draggable](https://github.com/mzabriskie/react-draggable) - React draggable component.
 - [react-dnd-touch-backend](https://github.com/yahoo/react-dnd-touch-backend) - Touch Backend for react-dnd.
 - [react-dropzone](https://github.com/okonet/react-dropzone) - Simple HTML5 drag-drop zone with React.js.
 - [react-dnd](https://github.com/gaearon/react-dnd) - Drag and Drop for React.
 - [react-sortable-pane](https://github.com/bokuweb/react-sortable-pane) - Sortable and resizable pane component for React.
 - [react-dragula](https://github.com/bevacqua/react-dragula) - Drag and drop so simple it hurts.
 - [react-droparea](https://github.com/avocode/react-droparea) - Drag and Drop library for React.


#### Sortable List

*Let the user define an order on a list*

 - [sortablejs](https://github.com/RubaXa/Sortable) - Sortable &mdash; is a JavaScript library for reorderable drag-and-drop lists on modern browsers and touch devices. No jQuery. Supports Meteor, AngularJS, React, Polymer, Knockout and any CSS library, e.g. Bootstrap.
 - [react-anything-sortable](https://github.com/jasonslyvia/react-anything-sortable) - A ReactJS component that can sort any children with touch support and IE8 compatibility.
 - [react-sortable-hoc](https://github.com/clauderic/react-sortable-hoc) - A set of higher-order components to turn any list into an animated, touch-friendly, sortable list.
 - [react-sortable](https://github.com/danielstocks/react-sortable) - A sortable list component built with React.


#### Rich Text Editor

 - [react-quill](https://github.com/zenoamaro/react-quill) - A Quill component for React.
 - [react-ace](https://github.com/securingsincity/react-ace) - React Ace Component.
 - [react-contenteditable](https://github.com/lovasoa/react-contenteditable) - React component for a div with editable contents.
 - [react-codemirror](https://github.com/JedWatson/react-codemirror) - Codemirror Component for React.js.
 - [react-medium-editor](https://github.com/wangzuo/react-medium-editor) - React wrapper for medium-editor.
 - [draft-js](https://github.com/facebook/draft-js) - A React framework for building text editors.
 - [ritzy](https://github.com/ritzyed/ritzy) - Collaborative web-based rich text editor.
 - [megadraft](https://github.com/globocom/megadraft) - Rich Text editor built on top of draft.js.
 - [react-trumbowyg](https://github.com/RD17/react-trumbowyg) - React wrapper for Trumbowyg.
 - [alloyeditor](https://github.com/liferay/alloy-editor) - WYSIWYG editor based on CKEditor with completely rewritten UI.
 - [react-draft-wysiwyg](https://github.com/jpuri/react-draft-wysiwyg) - A Wysiwyg editor build on top of ReactJS and DraftJS.


#### Markdown Editor

 - [react-md-editor](https://github.com/JedWatson/react-md-editor) - React.js Markdown Editor Component.
 - [react-markdown-editor](https://github.com/jrm2k6/react-markdown-editor) - A markdown editor using React/Reflux.


#### Image Editing

*Image manipulation*

 - [react-avatar-cropper](https://github.com/DropsOfSerenity/react-avatar-cropper) - Aiming to be a complete solution for avatar cropping in react.
 - [react-avatar-editor](https://github.com/mosch/react-avatar-editor) - Facebook like, avatar / profile picture component. Resize and crop your uploaded image using a clear user interface.
 - [react-image-crop](https://github.com/DominicTobias/react-image-crop) - A responsive image cropping tool for React.
 - [react-image-cropper](https://github.com/jerryshew/react-image-cropper) - React image crop.


#### Form Component Collections

 - [formsy-react-components](https://github.com/twisty/formsy-react-components) - A set of React JS components for use in a formsy-react form. Markup adheres to Bootstrap 3 form structure.
 - [formsy-material-ui](https://github.com/mbrookes/formsy-material-ui) - A Formsy compatibility wrapper for Material-UI form components.
 - [react-input-enhancements](https://github.com/alexkuz/react-input-enhancements) - Set of enhancements for input control.
 - [react-widgets](https://github.com/jquense/react-widgets) - An &agrave; la carte set of polished, extensible, and accessible inputs built for React.


#### Miscellaneous

 - [react-designer](https://github.com/fatiherikli/react-designer) - Easy to configure, lightweight, editable vector graphics in your react components.
 - [react-images-uploader](https://github.com/aleksei0807/react-images-uploader) - React.js component for uploading images to the server.
 - [react-tabguard](https://github.com/avocode/react-tabguard) - React Tabguard.







## UI Layout

*Components to layout the app's UI*

 - [rgx](https://github.com/jxnblk/rgx) - React grid system based on minimum and maximum widths.
 - [react-flexbox](https://github.com/tcoopman/react-flexbox) - React flexbox implementation.
 - [react-masonry-mixin](https://github.com/eiriklv/react-masonry-mixin) - A React.js mixin for using @desandro&#39;s Masonry.
 - [react-inline-grid](https://github.com/broucz/react-inline-grid) - Predictable flexbox based grid for React.
 - [react-layout-components](https://github.com/rofrischmann/react-layout-components) - Layout Components for React based on Flexbox.
 - [react-grid-layout](https://github.com/STRML/react-grid-layout) - A draggable and resizable grid layout with responsive breakpoints, for React.
 - [react-masonry-component](https://github.com/eiriklv/react-masonry-component) - A React.js component for using @desandro&#39;s Masonry.
 - [react-flexbox-grid](https://github.com/roylee0704/react-flexbox-grid) - A set of React components implementing flexboxgrid with the power of CSS Modules.
 - [react-stonecutter](https://github.com/dantrain/react-stonecutter) - Animated grid layout component for React.
 - [flexbox-react](https://github.com/nachoaIvarez/flexbox-react) Unopinionated, standard compliant flexbox components. You don't need to learn any propietary syntax. If you know how to use flexbox, you know how to use flexbox-react components.
 - [autoresponsive-react](https://github.com/xudafeng/autoresponsive-react) - Auto responsive grid layout library.
 - [golden-layout](https://github.com/deepstreamIO/golden-layout) - A multi-screen javascript Layout manager.
 - [reactwm](https://github.com/stayradiated/reactwm) - A minimal window manager built using React.
 - [react-stack-grid](https://github.com/tsuyoshiwada/react-stack-grid) - Pinterest like layout components for React.js.
 - [react-reflex](https://github.com/leefsmp/Re-Flex) - Flex layout container component for advanced React web applications.
 - [reflexbox](https://github.com/jxnblk/reflexbox) - React flexbox layout and grid system.
 - [hedron](https://github.com/JSBros/hedron) - A no-frills flexbox grid system for React, powered by styled-components.
 - [react-resizer](https://github.com/avocode/react-resizer) - A React component for resizing HTML elements.
 - [m-react-splitters](https://github.com/martinnov92/React-Splitters) - React splitter component, written in TypeScript.







## UI Animation

*Animate transitions*

 - [react-tween-state](https://github.com/chenglou/react-tween-state) - React animation.
 - [react-motion](https://github.com/chenglou/react-motion) - A spring that solves your animation problems.
 - [react-transitive-number](https://github.com/Lapple/react-transitive-number) - React component to apply transition effect to numeric strings, a la old Groupon timers.
 - [react-spark-scroll](https://github.com/gilbox/react-spark-scroll) - Scroll-based actions and animations for react.
 - [react-motion-ui-pack](https://github.com/souporserious/react-motion-ui-pack) - Wrapper component around React Motion for easier UI transitions.
 - [react-magic-move](https://github.com/ryanflorence/react-magic-move) - MagicMove for React.js.
 - [velocity-react](https://github.com/twitter-fabric/velocity-react) - React components for Velocity.js.
 - [react-track](https://github.com/gilbox/react-track) - Track the position of DOM elements. Create cool animations.
 - [rc-animate](https://github.com/react-component/animate) - Anim react element easily.
 - [react-router-transition](https://github.com/maisano/react-router-transition) - Transitions built for react-router, powered by react-motion.
 - [react-gsap-enhancer](https://github.com/azazdeaz/react-gsap-enhancer) - Use the full power of React and GSAP together.
 - [react-mt-svg-lines](https://github.com/moarwick/react-mt-svg-lines) - A React.js wrapper component to animate the line stroke in SVGs.
 - [react-flip-move](https://github.com/joshwcomeau/react-flip-move) - Effortless animation between DOM changes (eg. list reordering) using the FLIP technique.
 - [react.animate](https://github.com/pleasetrythisathome/react.animate) - State animation plugin for react.js.
 - [react-anime](https://github.com/stelatech/react-anime) - A super easy animation library for React.
 - [animakit-rotator](https://github.com/animakit/animakit-rotator) - AnimakitRotator - React component for the 3D rotation of the blocks.
 - [animakit-elastic](https://github.com/animakit/animakit-elastic) - AnimakitElastic - React component for flexible resizing of the blocks.
 - [animakit-expander](https://github.com/animakit/animakit-expander) - AnimakitExpander - React component for the expanding and collapsing of the blocks.
 - [react-tween](https://github.com/clari/react-tween) - Tween animation for React components.
 - [data-driven-motion](https://github.com/tkh44/data-driven-motion) - Easily animate your data in react.
 - [react-web-animation](https://github.com/bringking/react-web-animation) - React components for the Web Animations API -.


### Parallax

 - [react-atv-img](https://github.com/keyanzhang/react-atv-img) - A port of @drewwilson&rsquo;s atvImg (Apple TV 3D parallax effect) library in React.
 - [react-parallax-component](https://github.com/keske/react-parallax-component) - Easiest way to add scroll parallax effect on the component.


## UI Frameworks


### Responsive

*Set of components + responsive layout system*

 - [elemental](https://github.com/elementalui/elemental) - A flexible and beautiful UI framework for React.js.
 - [rctui](https://github.com/Lobos/react-ui) - A collection of components for React.
 - [belle](https://github.com/nikgraf/belle) - Configurable React Components with great UX.
 - [react-uikit-components](https://github.com/otissv/react-uikit-components) - React UIkit Components for the UIKit CSS framework.
 - [searchkit](https://github.com/searchkit/searchkit) - React UI components / widgets. The easiest way to build a great search experience with Elasticsearch.
 - [rebass](https://github.com/jxnblk/rebass) - Configurable React Stateless Functional UI Components.
 - [react-foundation-apps](https://github.com/akiran/react-foundation-apps) - Foundation Apps components built with React.
 - [grommet](https://github.com/grommet/grommet) - The most advanced UX framework for enterprise applications.
 - [@blueprintjs/core](https://github.com/palantir/blueprint) - Core styles & components.
 - [react-foundation](https://github.com/nordsoftware/react-foundation) - Foundation as React components.
 - [semantic-ui-react](https://github.com/Semantic-Org/Semantic-UI-React) - The official Semantic-UI-React integration.
 - [pivotal-ui-react](https://github.com/pivotal-cf/pivotal-ui) - React components based on a custom version of the Bootstrap library.
 - [antd](https://github.com/ant-design/ant-design) - A UI Design Language.


#### Bootstrap

 - [react-bootstrap](https://github.com/react-bootstrap/react-bootstrap) - Bootstrap 3 components built with React.
 - [reactstrap](https://github.com/reactstrap/reactstrap) - Simple React Bootstrap 4 components.


#### Material Design

 - [react-mdl](https://github.com/tleunen/react-mdl) - React Components for Material Design Lite.
 - [react-materialize](https://github.com/react-materialize/react-materialize) - Material design for react, powered by materializecss.
 - [react-toolbox](https://github.com/react-toolbox/react-toolbox) - A set of React components implementing Google&#39;s Material Design specification with the power of CSS Modules.
 - [react-material](https://github.com/BerkeleyTrue/react-material) - Material design components written with React.js and React Style.
 - [material-ui](https://github.com/callemall/material-ui) - React Components that Implement Google&#39;s Material Design.
 - [react-essence](https://github.com/Evo-Forge/Essence) - Essence - The Essential Material Design Framework.


### Mobile

 - [onsenui](https://github.com/OnsenUI/OnsenUI) - Hybrid Mobile App UI Framework for iOS and Material Design with Angular and React Components.
 - [reactionic](https://github.com/reactionic/reactionic) - React Ionic.
 - [touchstonejs](https://github.com/touchstonejs/touchstonejs) - Mobile App Framework powered by React.
 - [antd-mobile](https://github.com/ant-design/ant-design-mobile) - A configurable Mobile UI.


### Component Collections

*Set of components without layout system*

 - [dataminr-react-components](https://github.com/dataminr/react-components) - Collection of reusable React Components and utility functions.
 - [react-components](https://github.com/Khan/react-components) - React components used by Khan Academy.


### Other

 - [react-desktop](https://github.com/gabrielbull/react-desktop) - React UI Components for macOS Sierra and Windows 10.
 - [aframe-react](https://github.com/ngokevin/aframe-react) - Build virtual reality experiences with A-Frame and React.
 - [admin-on-rest](https://github.com/marmelab/admin-on-rest) - A frontend framework for building admin SPAs on top of REST services, using React and Material Design.


## UI Utilites


### Reporter

*Report computed styles*


#### Visibility Reporter

*Report when a component becomes visible/hidden*

 - [react-waypoint](https://github.com/brigade/react-waypoint) - A React component to execute a function whenever you scroll to an element.
 - [react-visibility-sensor](https://github.com/joshwnj/react-visibility-sensor) - Sensor component for React that notifies you when it goes in or out of the window viewport.


#### Measurement Reporter

*Determine and report measurements of an element*

 - [react-measure](https://github.com/souporserious/react-measure) - Compute measurements of a React component.
 - [react-height](https://github.com/nkbt/react-height) - Component-wrapper to determine and report children elements height.
 - [react-height-reporter](https://github.com/berrtech/react-height-reporter) - React component-wrapper detecting height changes of it&#39;s children.
 - [react-dimensions](https://github.com/digidem/react-dimensions) - React higher-order component to get dimensions of container.
 - [react-component-queries](https://github.com/ctrlplusb/react-component-queries) - Provide props to your Components based on their Width and/or Height.
 - [react-sizeme](https://github.com/ctrlplusb/react-sizeme) - Make your React Components aware of their width and height.
 - [react-container-dimensions](https://github.com/okonet/react-container-dimensions) - Wrapper component that detects element resize and passes new dimensions down the tree. Based on.



### Device Input

*Turn user input into actions*

#### Keyboard Events

 - [react-keydown](https://github.com/glortho/react-keydown) - Lightweight keydown wrapper for React components.
 - [react-hotkeys](https://github.com/chrisui/react-hotkeys) - Declarative hotkey and focus area management for React.
 - [react-shortcuts](https://github.com/avocode/react-shortcuts) - Manage keyboard shortcuts from one place.
 - [react-key-handler](https://github.com/ayrton/react-key-handler) - React component to handle keyboard events.

#### Scroll Events

 - [react-scroll-components](https://github.com/jeroencoumans/react-scroll-components) - A set of components that react to page scrolling.

#### Touch Events

 - [react-hammerjs](https://github.com/JedWatson/react-hammerjs) - ReactJS / HammerJS integration. Support touch events in your React app.
 - [react-tappable](https://github.com/JedWatson/react-tappable) - Tappable component for React.

#### Touch Swipe

 - [react-swipe](https://github.com/voronianski/react-swipe) - Swipe.js as a React component.

#### Mouse Events

 - [react-aim](https://github.com/gabrielbull/react-aim) - Determine the cursor aim for triggering mouse events.




### Meta Tags

*Set meta tags, <title>, children of <head>*

 - [react-helmet](https://github.com/nfl/react-helmet) - A document head manager for React.
 - [react-document-title](https://github.com/gaearon/react-document-title) - Declarative, nested, stateful, isomorphic document.title for React.
 - [react-document-meta](https://github.com/kodyl/react-document-meta) - HTML meta tags for React-based apps. Works for both client- and server-side rendering, and has a strict but flexible API.



### Portal

*Render an element at an arbitrary DOM node*

 - [react-portal](https://github.com/tajo/react-portal) - React component for transportation of modals, lightboxes, loading bars... to document.body.
 - [react-layer-stack](https://github.com/fckt/react-layer-stack) - Simple but ubiquitously powerful and agnostic layering system for React. Useful for any kind of windowing/popover/modals/tooltip application.
 - [react-gateway](https://github.com/cloudflare/react-gateway) - Render React DOM into a new context (aka "Portal").




### Test User Behavior

*A/B tests, experiments, ...*

 - [react-ab](https://github.com/olahol/react-ab) - Simple declarative and universal A/B testing component for React.
 - [react-experiments](https://github.com/HubSpot/react-experiments) - React components for implementing UI experiments.










## Code Design

*Libraries that help with code design*


### Data Store

*Data flow / data management / data stores / components state / data flow*

 - [react-redux](https://github.com/reactjs/react-redux) - Official React bindings for Redux.
 - [fluorine-lib](https://github.com/philpl/fluorine) - Reactive state and side effect management for React using a single stream of actions.
 - [redux-batched-actions](https://github.com/tshelburne/redux-batched-actions) - Redux higher order reducer + action to reduce actions under a single subscriber notification.
 - [react-i13n](https://github.com/yahoo/react-i13n) - A performant, scalable and pluggable approach to instrumenting your React application.
 - [shasta](https://github.com/shastajs/shasta) - Dead simple + opinionated toolkit for building redux/react applications.
 - [react-redux-provide](https://github.com/loggur/react-redux-provide) - Bridges the gap between Redux and the declarative nature of GraphQL/Relay. Share, manipulate, and replicate application state across any number of components.
 - [redux-batched-subscribe](https://github.com/tappleby/redux-batched-subscribe) - Store enhancer for which allows batching subscribe notifications.
 - [reflux](https://github.com/reflux/refluxjs) - A simple library for uni-directional dataflow application architecture with React extensions inspired by Flux.
 - [fluxxor](https://github.com/BinaryMuse/fluxxor) - Flux architecture tools for React.
 - [fluxible](https://github.com/yahoo/fluxible) - A pluggable container for universal flux applications.
 - [alt](https://github.com/goatslacker/alt) - Isomorphic flux implementation.
 - [baobab-react](https://github.com/Yomguithereal/baobab-react) - React integration for Baobab.
 - [reselect](https://github.com/reactjs/reselect) - Selector library for Redux.
 - [react-controllables](https://github.com/matthewwithanm/react-controllables) - Easily create controllable components.
 - [recompose](https://github.com/acdlite/recompose) - A React utility belt for function components and higher-order components.
 - [redux-ui](https://github.com/tonyhb/redux-ui) - Easy UI state management for react redux.
 - [redux](https://github.com/reactjs/redux) - Predictable state container for JavaScript apps.
 - [mobx-react](https://github.com/mobxjs/mobx-react) - React bindings for MobX. Create fully reactive components.
 - [cerebral](https://github.com/cerebral/cerebral) - A state controller with its own debugger.
 - [kea](https://github.com/mariusandra/kea) - High level architecture for React apps.


### Form Logic

 - [react-jsonschema-form](https://github.com/mozilla-services/react-jsonschema-form) - A React component for building Web forms from JSONSchema.
 - [react-validation-mixin](https://github.com/jurassix/react-validation-mixin) - Simple validation mixin (HoC) for React.
 - [newforms](https://github.com/insin/newforms) - INACTIVE] Isomorphic form-handling for React.
 - [formsy-react](https://github.com/christianalfoni/formsy-react) - A form input builder and validator for React JS.
 - [redux-form](https://github.com/erikras/redux-form) - A Higher Order Component using react-redux to keep form state in a Redux store.
 - [winterfell](https://github.com/andrewhathaway/Winterfell) - Generate complex, validated and extendable JSON-based forms in React.
 - [react-redux-form](https://github.com/davidkpiano/react-redux-form) - Create forms easily in React with Redux.
 - [tcomb-form](https://github.com/gcanti/tcomb-form) - Forms library for react.
 - [plexus-form](https://github.com/AppliedMathematicsANU/plexus-form) - A dynamic form component for react using JSON-Schema.
 - [cerebral-module-forms](https://github.com/cerebral/cerebral-module-forms) - A forms handler for Cerebral.


### Router

 - [react-router](https://github.com/reactjs/react-router) - A complete routing library for React.
 - [react-router-component](https://github.com/STRML/react-router-component) - Declarative router component for React.
 - [redux-router](https://github.com/acdlite/redux-router) - Redux bindings for React Router &ndash; keep your router state inside your Redux store.
 - [react-router-scroll](https://github.com/taion/react-router-scroll) - React Router scroll management.
 - [universal-router](https://github.com/kriasoft/universal-router) - A simple middleware-style router for isomorphic JavaScript web apps.
 - [rrtr](https://github.com/taion/rrtr) - A complete routing solution for React.js.
 - [react-router-redux](https://github.com/reactjs/react-router-redux) - Ruthlessly simple bindings to keep react-router and redux in sync.
 - [react-breadcrumbs](https://github.com/svenanders/react-breadcrumbs) - Automatic breadcrumbs for React-Router.
 - [monorouter](https://github.com/matthewwithanm/monorouter) - An isomorphic JS router.
 - [cerebral-module-router](https://github.com/cerebral/cerebral-module-router) - An opinionated URL change handler for Cerebral.


### Props from server

*Component properties asynchronously fetched over the network*

 - [react-async](https://github.com/andreypopp/react-async) - Asynchronously fetch data for React components.
 - [redux-async-connect](https://github.com/Rezonans/redux-async-connect) - It allows you to request async data, store them in redux state and connect them to your react component.
 - [async-props](https://github.com/ryanflorence/async-props) - Co-located data loading for React Router.
 - [react-router-relay](https://github.com/relay-tools/react-router-relay) - Relay integration for React Router.
 - [redux-connect](https://github.com/makeomatic/redux-connect) - Provides decorator for resolving async props in react-router, extremely useful for handling server-side rendering in React.
 - [react-resolver](https://github.com/ericclemmons/react-resolver) - Async rendering &amp; data-fetching for universal React applications.
 - [react-refetch](https://github.com/heroku/react-refetch) - A simple, declarative, and composable way to fetch data for React components.
 - [redial](https://github.com/markdalgleish/redial) - Universal data fetching and route lifecycle management for React etc.


### Communication with server

 - [adrenaline](https://github.com/gyzerok/adrenaline) - Simple Relay alternative.
 - [react-transmit](https://github.com/RickWong/react-transmit) - Relay-inspired library based on Promises instead of GraphQL.
 - [apollo-client](https://github.com/apollostack/apollo-client) - A simple caching client for any GraphQL server and UI framework.
 - [react-apollo](https://github.com/apollostack/react-apollo) - React data container for the Apollo Client.
 - [react-relay](https://github.com/facebook/relay) - Relay is a JavaScript framework for building data-driven React applications.
 - [cerebral-module-http](https://github.com/cerebral/cerebral-module-http) - HTTP module for Cerebral.


### CSS / Style

 - [react-responsive](https://github.com/contra/react-responsive) - Media queries in react for responsive design.
 - [react-css-modules](https://github.com/gajus/react-css-modules) - Seamless mapping of class names to CSS modules inside of React components.
 - [aphrodite](https://github.com/Khan/aphrodite) - It&#39;s inline styles, but they work!.
 - [postcss-js](https://github.com/postcss/postcss-js) - PostCSS for React Inline Styles, Free Style and other CSS-in-JS.
 - [react-inline-css](https://github.com/RickWong/react-inline-css) - Write CSS inside your React components!.
 - [classnames](https://github.com/JedWatson/classnames) - A simple javascript utility for conditionally joining classNames together.
 - [react-container-query](https://github.com/d6u/react-container-query) - Modular responsive component.
 - [react-look](https://github.com/rofrischmann/react-look) - Advanced &amp; Dynamic Component Styling for React and React Native. Ships with powerful Plugins, Mixins and Developer Tools.
 - [stilr](https://github.com/kodyl/stilr) - Encapsulated styling for your javascript components with all the power of javascript and CSS combined.
 - [react-css-components](https://github.com/andreypopp/react-css-components) - Define React presentational components with CSS.
 - [inline-style-prefixer](https://github.com/rofrischmann/inline-style-prefixer) - Run-time Autoprefixer for Inline Style Objects.
 - [radium](https://github.com/FormidableLabs/radium) - A set of tools to manage inline styles on React elements.
 - [styled-components](https://github.com/styled-components/styled-components) - Visual primitives for the component age.


### HTML Template

 - [jsx-control-statements](https://github.com/AlexGilleran/jsx-control-statements) - Neater If and For for React JSX.
 - [react-templates](https://github.com/wix/react-templates) - Light weight templates for react.
 - [hyperx](https://github.com/substack/hyperx) - Tagged template string virtual dom builder.


### Isomorphic Apps

 - [hypernova](https://github.com/airbnb/hypernova) - A service for server-side rendering your JavaScript views.
 - [react-server](https://github.com/redfin/react-server) - React framework with server render for blazing fast page load and seamless transitions between pages in the browser.
 - [webpack-isomorphic-tools](https://github.com/halt-hammerzeit/webpack-isomorphic-tools) - Server-side rendering for your Webpack-built applications (e.g. React).
 - [isomorphic-relay](https://github.com/denvned/isomorphic-relay) - Adds server side rendering support to React Relay.
 - [rill](https://github.com/rill-js/rill) - Universal web application framework.
 - [isomorphic-style-loader](https://github.com/kriasoft/isomorphic-style-loader) - Isomorphic CSS style loader for Webpack.


### Boilerplate

*Scaffold / starter kit / Yeoman generator / stack ensemble / seed*

 - [create-react-app](https://github.com/facebookincubator/create-react-app) - Create React apps with no build configuration.
 - [redux-cli](https://github.com/SpencerCDixon/redux-cli) - An opinionated CLI for building redux/react apps quicker.
 - [reactuate](https://github.com/reactuate/reactuate) - React/Redux stack (not a boilerplate kit).
 - [essential-react](https://github.com/pheuter/essential-react) - A minimal skeleton for building testable React apps using Babel.
 - [gluestick](https://github.com/TrueCar/gluestick) - GlueStick is a command line interface for quickly developing universal web applications using React and Redux.
 - [relay-fullstack](https://github.com/lvarayut/relay-fullstack) - Relay Starter Kit - Integrated with Relay, GraphQL, Express, ES6/ES7, JSX, Webpack, Babel, Material Design Lite, and PostCSS.
 - [universal-redux](https://github.com/bdefore/universal-redux) - An npm package that lets you jump right into coding React and Redux with universal (isomorphic) rendering. Only manage Express setups or Webpack configurations if you want to.
 - [nwb](https://github.com/insin/nwb) - CLI tool and devDependency for React apps &amp; components and npm modules.
 - [react-redux-universal-hot-example](https://github.com/erikras/react-redux-universal-hot-example) - A starter boilerplate for a universal webapp using express, react, redux, webpack, and react-transform.
 - [generator-starhackit](https://github.com/FredericHeem/starhackit) - StarHackIt: React/Redux + Node full-stack starter kit with authentication and authorization, data backed by SQL.
 - [react-isomorphic-starterkit](https://github.com/RickWong/react-isomorphic-starterkit) - Create an isomorphic React app in less than 5 minutes.
 - [generator-react-webpack](https://github.com/react-webpack-generators/generator-react-webpack) - Yeoman generator for ReactJS and Webpack.
 - [electron-react-boilerplate](https://github.com/chentsulin/electron-react-boilerplate) - Live editing development on desktop app.
 - [reactpack](https://github.com/olahol/reactpack) - Build your react apps with one command and one `npm i`.
 - [react-hot-boilerplate](https://github.com/gaearon/react-hot-boilerplate) - Minimal live-editing boilerplate for your next ReactJS project.
 - [generator-flux-on-rails](https://github.com/alexfedoseev/generator-flux-on-rails) - Scaffolder of universal Flux / Redux app, backed by Rails API.
 - [roc](https://github.com/rocjs/roc) - Modern Application Development Ecosystem.
 - [react-redux-starter-kit](https://github.com/davezuko/react-redux-starter-kit) - Get started with React, Redux, and React-Router!.
 - [redux-webpack-es6-boilerplate](https://github.com/nicksp/redux-webpack-es6-boilerplate) - A starter project for modern React apps with Redux.
 - [react-boilerplate](https://github.com/mxstbr/react-boilerplate) - Quick packager-agnostic boilerplate for React modules using JSX.


### Miscellaneous

 - [redux-auth-patch](https://github.com/lynndylanhurley/redux-auth) - Complete token authentication system for react + redux that supports isomorphic rendering.
 - [redux-search](https://github.com/treasure-data/redux-search) - Redux bindings for client-side search.
 - [react-inlinesvg](https://github.com/matthewwithanm/react-inlinesvg) - An SVG loader component for ReactJS.
 - [tcomb-react](https://github.com/gcanti/tcomb-react) - Alternative syntax for PropTypes.










## Utilities

 - [react-faux-dom](https://github.com/Olical/react-faux-dom) - DOM like structure that renders to React.
 - [react-translate-component](https://github.com/martinandert/react-translate-component) - A component for React that utilizes the Counterpart module to provide multi-lingual/localized text content.
 - [qrcode.react](https://github.com/zpao/qrcode.react) - A &lt;QRCode/&gt; component for use with React.
 - [react-media](https://github.com/ReactTraining/react-media) - A CSS media query component for React.
 - [react-children-utilities](https://github.com/fernandopasik/react-children-utilities) - Extended utils for React.Children.


### i18n

*Internationalization / L10n / localization / translation*

 - [react-intl](https://github.com/yahoo/react-intl) - Internationalize React apps. This library provides React components and an API to format dates, numbers, and strings, including pluralization and handling translations.
 - [react-i18next](https://github.com/i18next/react-i18next) - Internationalization for react done right. Using the i18next i18n ecosystem.
 - [react-translate-maker](https://github.com/CherryProjects/react-translate-maker) - Universal internationalization (i18n) open source library for React.
 - [react-globalize](https://github.com/globalizejs/react-globalize) - Bringing the i18n functionality of Globalize, backed by CLDR, to React.


### Framework bindings / integrations

 - [reactfire](https://github.com/firebase/reactfire) - ReactJS mixin for easy Firebase integration.
 - [react-famous](https://github.com/pilwon/react-famous) - React bridge to Famo.us.
 - [backbone-react-component](https://github.com/magalhas/backbone-react-component) - A bit of nifty glue that automatically plugs your Backbone models and collections into your React components, on the browser and server.
 - [elm-react-component](https://github.com/KtorZ/elm-react-component) - A React component which wraps an Elm module to be used in a React application.
 - [react-three-renderer](https://github.com/toxicFork/react-three-renderer) - Render into a three.js canvas using React.
 - [gl-react](https://github.com/ProjectSeptemberInc/gl-react) - OpenGL / WebGL bindings for React to implement complex effects over images and content, in the descriptive VDOM paradigm.
 - [react-d3-library](https://github.com/react-d3-library/react-d3-library) - Open source library for using D3 in React.
 - [gl-react-dom](https://github.com/ProjectSeptemberInc/gl-react-dom) - WebGL bindings for React to implement complex effects over images and content, in the descriptive VDOM paradigm.
 - [react-on-rails](https://github.com/shakacode/react_on_rails) - Integration of React + Webpack + Rails to build Universal (Isomorphic) Apps.
 - [react-backbone](https://github.com/jhudson8/react-backbone) - Backbone-aware mixins for react and a whole lot more.
 - [react-swf](https://github.com/syranide/react-swf) - Shockwave Flash Player component for React.
 - [react-localstorage](https://github.com/STRML/react-localstorage) - Simple componentized localstorage implementation for Facebook&#39;s React.
 - [reactive-elements](https://github.com/PixelsCommander/ReactiveElements) - Allows to use React.js component as HTML element (web component).
 - [react-elm-components](https://github.com/evancz/react-elm-components) - Write React components in Elm.


### Integrations with Third Party Services

 - [react-stripe-checkout](https://github.com/azmenak/react-stripe-checkout) - Load stripe&#39;s checkout.js as a react component. Easiest way to use checkout with React.
 - [react-google-analytics](https://github.com/hzdg/react-google-analytics) - Google analytics component.
 - [react-recaptcha](https://github.com/appleboy/react-recaptcha) - A react.js reCAPTCHA for Google.
 - [redux-segment](https://github.com/rangle/redux-segment) - Segment.io analytics integration for redux.
 - [react-ga](https://github.com/react-ga/react-ga) - React Google Analytics Module.














## Performance

### UI

 - [react-fastclick](https://github.com/JakeSidSmith/react-fastclick) - Fast Touch Events for React.
 - [react-static-container](https://github.com/reactjs/react-static-container) - Renders static content efficiently by allowing React to short-circuit the reconciliation process.
 - [react-canvas](https://github.com/Flipboard/react-canvas) - High performance &lt;canvas&gt; rendering for React components.
 - [inferno](https://github.com/trueadm/inferno) - An extremely fast, React-like JavaScript library for building modern user interfaces.

#### Inspect

 - [why-did-you-update](https://github.com/garbles/why-did-you-update) - Puts your console on blast when React is making unnecessary updates.
 - [react-perf-tool](https://github.com/RamonGebben/react-perf-tool) - Debug performance of your React application.
 - [react-render-visualizer](https://github.com/redsunsoft/react-render-visualizer) - Render visualizer for ReactJS.

#### Lazy Load

 - [react-lazyload](https://github.com/jasonslyvia/react-lazyload) - Lazyload your Component, Image or anything matters the performance.
 - [react-infinity](https://github.com/nmn/react-infinity) - A UITableView Inspired list and grid display solution with element culling and smooth animations.
 - [react-infinite](https://github.com/seatgeek/react-infinite) - A browser-ready efficient scrolling container based on UITableView.
 - [react-infinite-grid](https://github.com/ggordan/react-infinite-grid) - A React component which renders a grid of elements.
 - [react-virtualized](https://github.com/bvaughn/react-virtualized) - React components for efficiently rendering large lists and tabular data.
 - [react-lazy-load](https://github.com/loktar00/react-lazy-load) - React component that renders children elements when they enter the viewport.

### App Size

 - [babel-plugin-transform-react-remove-prop-types](https://github.com/oliviertassinari/babel-plugin-transform-react-remove-prop-types) - Remove unnecessary React propTypes from the production build.
 - [react-lite](https://github.com/Lucifier129/react-lite) - An implementation of React that optimizes for small script size.








## Dev Tools

### Test

 - [ui-harness](https://github.com/philcockfield/ui-harness) - Create, isolate and test modular UI components in React.
 - [redux-test-recorder](https://github.com/conorhastings/redux-test-recorder) - A redux middleware to automatically generate tests for reducers through ui interaction.
 - [legit-tests](https://github.com/Legitcode/tests) - Chainable, easy to read, React testing library.
 - [unexpected-react](https://github.com/bruderstein/unexpected-react) - Plugin for [unexpected]( to enable testing the full React virtual DOM, and also the shallow renderer.
 - [chai-enzyme](https://github.com/producthunt/chai-enzyme) - Chai.js assertions and convenience functions for testing React Components with enzyme.
 - [react-unit](https://github.com/pzavolinsky/react-unit) - Lightweight unit test library for ReactJS.
 - [enzyme](https://github.com/airbnb/enzyme) - JavaScript Testing utilities for React.
 - [redux-ava](https://github.com/sotojuan/redux-ava) - Write AVA tests for redux pretty quickly.
 - [carte-blanche](https://github.com/carteb/carte-blanche) - An isolated development space with integrated fuzz testing for your components. See them individually, explore them in different states and quickly and confidently develop them.
 - [jest-cli](https://github.com/facebook/jest) - Painless JavaScript Testing.



### Redux

 - [redux-devtools-inspector](https://github.com/alexkuz/redux-devtools-inspector) - Another Redux DevTools Monitor.
 - [redux-devtools-chart-monitor](https://github.com/romseguy/redux-devtools-chart-monitor) - A chart monitor for Redux DevTools.
 - [redux-devtools-dock-monitor](https://github.com/gaearon/redux-devtools-dock-monitor) - A resizable and movable dock for Redux DevTools monitors.
 - [redux-devtools-filterable-log-monitor](https://github.com/bvaughn/redux-devtools-filterable-log-monitor) - Filterable tree view monitor for Redux DevTools.
 - [redux-devtools-log-monitor](https://github.com/gaearon/redux-devtools-log-monitor) - The default monitor for Redux DevTools with a tree view.
 - [remote-redux-devtools](https://github.com/zalmoxisus/remote-redux-devtools) - Redux DevTools remotely.
 - [redux-devtools](https://github.com/gaearon/redux-devtools) - DevTools for Redux with hot reloading, action replay, and customizable UI.



### Inspect

 - [react-inspector](https://github.com/xyc/react-inspector) - Power of Browser DevTools inspectors right inside your React app.
 - [react-json-inspector](https://github.com/Lapple/react-json-inspector) - React JSON inspector component.
 - [reactotron](https://github.com/reactotron/reactotron) - A CLI and OS X app for inspecting your React JS and React Native apps.



### Miscellaneous

 - [react-atellier](https://github.com/scup/atellier) - The smartest way to share interactive components with your team.
 - [standard-react](https://github.com/feross/standard) - JavaScript Standard Style Guide.
 - [cosmos-js](https://github.com/skidding/cosmos) - DX tool for designing truly encapsulated React components.
 - [react-heatpack](https://github.com/insin/react-heatpack) - A &#39;heatpack&#39; command for quick React development with webpack hot reloading.
 - [mighty-react-snippets](https://github.com/nicksp/mighty-react-snippets) - Crafty React and Redux ES6 snippets for Atom Editor.
 - [react-styleguidist](https://github.com/sapegin/react-styleguidist) - React style guide generator.









## Miscellaneous

 - [structor](https://github.com/ipselon/structor) - An advanced GUI editor for React.
 - [react-blessed](https://github.com/Yomguithereal/react-blessed) - A react renderer for blessed.
 - [react-komik](https://github.com/sonnylazuardi/react-komik) - ReactJS based comic strip creator using fabric.js canvas rendering.
 - [mozaik](https://github.com/plouc/mozaik) - Moza&iuml;k is a tool based on nodejs / react / d3 / stylus to easily craft beautiful dashboards.
 - [htmltojsx](https://github.com/reactjs/react-magic) - Automatically AJAXify plain HTML with the power of React. It&#39;s magic!.
 - [react-bash](https://github.com/zackargyle/react-bash) - A configurable/extendable bash terminal React component.
 - [html-to-react-components](https://github.com/roman01la/html-to-react-components) - Extract annotated portions of HTML into React components as separate modules.


### Static Website Generator

 - [gatsby](https://github.com/gatsbyjs/gatsby) - Transform plain text into dynamic blogs and websites using React.js.
 - [phenomic](https://github.com/MoOx/phenomic) - Modern static* website generator based on the React and Webpack ecosystem.
 - [sitegen](https://github.com/andreypopp/sitegen) - Generate websites by composing React components.
