<h1 align="center">
	<br>
	<img width="200" src="https://cdn.rawgit.com/sindresorhus/awesome/master/media/logo.svg" alt="awesome">
	<br>
</h1>

[![Build Status](https://api.travis-ci.org/sdmg15/Best-websites-a-programmer-should-visit.svg?branch=master)](https://travis-ci.org/sdmg15/Best-websites-a-programmer-should-visit)

# Best-websites-a-programmer-should-visit
Some useful websites for programmers.

When learning CS, there are some useful sites you must know to get always informed in order to do your technologies even better and learn new things. Here is a non exhaustive list of some sites you should visit. This list will get updated as soon as I can get another link, but you can also contribute by adding those you know :wink:

**Note** : [Chinese Version](https://github.com/tuteng/Best-websites-a-programmer-should-visit-zh)

<h3>Index</h3>
<ul>
<li><a href="#when-you-get-stuck">When you get stuck</a></li>
<li><a href="#news">News</a></li>
<li><a href="#magazines">Magazines</a></li>
<li><a href="#coding-practice-for-beginners">Coding practice for beginners</a></li>
<li><a href="#cryptocurrency">Cryptocurrency</a></li>
<li><a href="#for-those-who-want-to-start-a-small-project-but-cant-find-the-ideas">For those who want to start a small project but can't find the ideas</a></li>
<li><a href="#general-coding-advice">General Coding advice</a></li>
<li><a href="#coding-style">Coding Style</a></li>
<li><a href="#general-tools">General Tools</a></li>
<li><a href="#interview-preparation">Interview Preparation</a></li>
<li><a href="#documentaries">Documentaries</a></li>
<li><a href="#moocs-for-learning-something-new">MOOCs for learning something new</a></li>
<li><a href="#sites-related-to-your-preferred-programming-language-for-me-java">Sites related to your preferred programming language (For me Java)</a></li>
<li><a href="#learn-ai">Learn AI</a></li>
<li><a href="#seminar--research-writing--talks-etc">Seminar , research writing , talks etc</a></li>
<li><a href="#everything-in-one-place">Everything in one place</a></li>
<li><a href="#youtube-channels">YouTube Channels</a></li>
<li><a href="#good-articles">Good Articles</a></li>
<li><a href="#bash-and-shell-scripting">Bash and Shell scripting</a></li>
<li><a href="#podcasts">Podcasts</a></li>
<li><a href="#building-a-simple-compilerinterpreter">Building a Simple Compiler/Interpreter</a></li>
<li><a href="#watch-others-code">Watch others code</a></li>
<li><a href="#tutorials">Tutorials</a></li>
<li><a href="#what-should-a-programmer-know">What should a programmer know</a></li>
<li><a href="#competitive-programming">Competitive programming</a></li>
<li><a href="#computer-books">Computer Books</a></li>
<li><a href="#video-tutorials">Video Tutorials</a></li>
<li><a href="#online-compiler-and-sharing-code-snippets">Online Compiler and Sharing Code snippets</a></li>
<li><a href="#blogs-of-developers">Blogs of Developers</a></li>
<li><a href="#for-improving-your-english">For improving your English</a></li>
<li><a href="#when-you-get-bored-from-cs-related-stuff">When you get bored from CS related stuff</a></li>
<li><a href="#open-source-websites">Open Source Websites</a></li>
<li><a href="#internships">Internships</a></li>
<li><a href="#jobs">Jobs</a></li>
</ul>

## When you get stuck
- [Codementor](https://www.codementor.io) : A mentorship community to learn from fellow developers via live 1:1 help and more.
- [devRant](https://www.devrant.io) : Community where you can rant and release your stress
- [Learn Anything](https://learn-anything.xyz) : Community curated knowledge graph of best paths for learning anything
- [Quora](https://www.quora.com) : A place to share knowledge and better understand the world
- [Stack Overflow](https://stackoverflow.com) : subscribe to their weekly newsletter and any other topic which you find interesting


## News
- [ACM TechNews](http://technews.acm.org) : TechNews
- [Stratechery](https://stratechery.com) : Stratechery by Ben Thompson
- [AlternativeTo](https://alternativeto.net) : Crowdsourced software recommendations
- [Ars Technica](https://arstechnica.com) : posts unique quality articles
- [Better Dev Links](https://betterdev.link) : Weekly links to help you become a better developer
- [DevOpsLinks](http://devopslinks.com) : An online community of thousands of developers and IT experts interested in DevOps
- [GSMArena.com](http://www.gsmarena.com) : news related to latest mobile phones and android.
- [Hacker News Digest](https://hndigest.com) : curated automatically, delivered as frequently as you want
- [Hacker News](https://news.ycombinator.com) : news aggregator for programmers where civility is king, try a newsletter to get top news to your inbox:
- [Hacker Newsletter](http://www.hackernewsletter.com) : curated by hand, delivered weekly
- [Hacker Noon](https://hackernoon.com) : How hackers start their afternoons.
- [High Scalability](http://highscalability.com) : Success stories of various companies on their apps, infra scaling.
- [Lobsters](https://lobste.rs) : Lobsters is a technology-focused community centered around link aggregation and discussion.
- [product hunt](https://www.producthunt.com) : Discover your next favorite thing
- [Recode](https://www.recode.net) : Tech news that focuses on the business of Silicon Valley
- [Reddit.com/r/programming](https://www.reddit.com/r/programming/) : Subreddit with aggregated tech news and articles
- [Slashdot](https://slashdot.org) : News, Social news (Originally "News for Nerds. Stuff that Matters")
- [Stack Share](https://stackshare.io) : Technical stack sharing site for various companies
- [TechCrunch](https://techcrunch.com) : dedicated to obsessively profiling startups, reviewing new Internet products, and breaking tech news
- [The DEV Community](https://dev.to) : Where programmers share ideas and help each other grow.
- [The Verge](https://www.theverge.com) : More product oriented tech news
- [XDA](https://www.xda-developers.com) : Android Developers News

## Magazines
- [MIT Technology Review](https://www.technologyreview.com/magazine/) : MIT's tech review magazine.
- [Nautilus](http://nautil.us) : NewYorker for tech.
- [LWN](https://lwn.net) : Weekly news coverage of opensource technologies, programming, etc. ( Originally Linux Weekly News).


## Coding practice for beginners
- [Cave of programming](https://caveofprogramming.com) : Learn to program, Upgrade your skills.
- [Codeacademy](https://www.codecademy.com) : Learn to code interactively, for free.
- [CodeAbbey - a place where everyone can master programming](http://www.codeabbey.com) : Best place to begin with problems that start at the easiest and gradually increase difficulty with each problem.
- [Exercism.io](http://exercism.io) : download and solve practice problems in over 30 different languages, and share your solution with others.
- [freeCodeCamp](https://www.freecodecamp.org) : Learn to code and build projects for nonprofits. Build your full stack web development portfolio today
- [karan/Projects-Solutions](https://github.com/karan/Projects-Solutions) : Solutions to most of the problems in the link above
- [Lod - Cloud](http://lod-cloud.net) : The Linking Open Data cloud diagram
- [Programming by Doing](http://programmingbydoing.com) : very good site for those who want to start with absolute basics
- [Reddit.com/r/dailyprogrammer](https://www.reddit.com/r/dailyprogrammer/) : interesting programming challenges where you can learn from looking at other's code , even if you are not able to solve code you can look at how others solved.
- [People Can Program](https://www.peoplecanprogram.com) : The most user-friendly code learning application on the internet.
- [Programming Tasks](http://rosettacode.org/wiki/Category:Programming_Tasks) : large collection of small programs
- [Vim adventures](https://vim-adventures.com) : Learn VIM by playing
- [Pramp](https://www.pramp.com) : It's your turn to be the interviewer. when done, click on the swap roles button on the left
- [Paqmind](http://paqmind.com) : Guides and challenges to learn programming
- [treehouse](https://teamtreehouse.com) : The fast, easy, and affordable way to build your skills.

## CryptoCurrency
- [What Cryptocurrency  enthusiasts won't tell](http://www.ofnumbers.com/2017/09/21/eight-things-cryptocurrency-enthusiasts-probably-wont-tell-you/) : Eight Things Cryptocurrency Enthusiasts Probably Won’t Tell You
- [Blockchain Basics](https://www.sitepen.com/blog/2017/09/21/blockchain-basics/) : Great introduction to blockchain

## For those who want to start a small project but can't find the ideas
- [freeCodeCamp | React project ideas](https://medium.freecodecamp.org/every-time-you-build-a-to-do-list-app-a-puppy-dies-505b54637a5d?gi=c786640fbd11) : 27 fun app ideas you can build while learning React.
- [martyr2s-mega-project-ideas-list](http://www.dreamincode.net/forums/topic/78802-martyr2s-mega-project-ideas-list/) : contains about 125 project ideas from beginner to intermediate level.
- [karan/Projects](https://github.com/karan/Projects) : a large collection of small projects for beginners with
- [Wrong "big projects" for beginners](http://rodiongork.tumblr.com/post/108155476418/wrong-big-projects-for-beginners) : How to choose where to start
- [vicky002/1000-Projects](https://github.com/vicky002/1000_Projects) : Mega List of practical projects that one can solve in any programming language!


## General Coding advice
- [10-ways-to-be-a-better-developer](https://stephenhaunts.files.wordpress.com/2014/04/10-ways-to-be-a-better-developer.png) : Ways to become a better dev!
- [Code Review Best Practices](https://www.kevinlondon.com/2015/05/05/code-review-best-practices.html) : Kevin London's blog
- [Design Patterns](https://sourcemaking.com/design_patterns) : Design Patterns explained in detail with examples.
- [How to become a programmer, or the art of Googling well](https://okepi.wordpress.com/2014/08/21/how-to-become-a-programmer-or-the-art-of-googling-well/) : How to become a programmer, or the art of Googling well
- [JS Project Guidelines](https://github.com/wearehive/project-guidelines) : A set of best practices for JavaScript projects.
- [Learn to Code With Me](https://learntocodewith.me) : A comprehensive site resource by Laurence Bradford for developers who aims to build a career in the tech world
- [Lessons From A Lifetime Of Being A Programmer](http://thecodist.com/article/lessons_from_a_lifetime_of_being_a_programmer) : The Codist Header Lessons From A Lifetime Of Being A Programmer  
- [Programming Principles](https://webpro.github.io/programming-principles/) : Categorized overview of Programming Principles & Patterns
- [Software design pattern](https://en.wikipedia.org/wiki/Software_design_pattern) : The entire collection of Design Patterns.
- [Things I Wish Someone Had Told Me When I Was Learning How to Code — Free Code Camp](https://medium.freecodecamp.com/things-i-wish-someone-had-told-me-when-i-was-learning-how-to-code-565fc9dcb329?gi=fc6d0a309be ) : What I’ve learned from teaching others
- [What every computer science major should know](http://matt.might.net/articles/what-cs-majors-should-know/) : The Principles of Good Programming
- [Working as a Software Developer](https://henrikwarne.com/2012/12/12/working-as-a-software-developer/) : Henrik Warne's blog


## Coding Style
- [Airbnb JS Style Guide](https://github.com/airbnb/javascript) : A mostly reasonable approach to JavaScript
- [Airbnb Ruby Style Guide](https://github.com/airbnb/ruby) : A ruby style guide by Airbnb
- [Ruby coding style guide](https://github.com/bbatsov/ruby-style-guide) : A community-driven Ruby coding style guide
- [Angular 1 Style Guide](https://github.com/johnpapa/angular-styleguide/tree/master/a1) : Officially endorsed style guide by John Pappa
- [CS 106B Coding Style Guide](http://stanford.edu/class/archive/cs/cs106b/cs106b.1158/styleguide.shtml) : must see for those who create spaghetti
- [Debugging Faqs](http://www.umich.edu/~eecs381/generalFAQ/Debugging.html) : Check out how to debug your program
- [Directory of CS Courses (many with online lectures)](https://github.com/prakhar1989/awesome-courses) : Another online CS courses
- [Directory of Online CS Courses](https://github.com/ossu/computer-science) : Free online CS courses
- [Good C programming habits. • /r/C_Programming](https://www.reddit.com/r/C_Programming/comments/1vuubw/good_c_programming_habits/) : C programming habits to adopt
- [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html)
- [How to Report Bugs Effectively](https://www.chiark.greenend.org.uk/~sgtatham/bugs.html) : Want to report a bug but you don't how? Check out this post
- [What are some bad coding habits you would recommend a beginner avoid getting into?](https://www.reddit.com/r/learnprogramming/comments/1i4ds4/what_are_some_bad_coding_habits_you_would/) : Bad habits to avoid when you get start
- [PEP8 - Style Guide for Python Code](https://www.python.org/dev/peps/pep-0008/) : Style Guide for Python Code
- [Standard JS Style Guide](https://standardjs.com) : JavaScript style guide, with linter & automatic code fixer
- [Google Python Style Guide](https://google.github.io/styleguide/pyguide.html) : Google Python Style Guide
- [Aurelia Style Guide](https://github.com/behzad888/Aurelia-styleguide) : An Aurelia style guide by Behzad Abbasi(Behzad888)


## General Tools
- [CodePad](https://codepad.remoteinterview.io/DDCUYLAEYS) : Quickly Conduct Coding Interviews and Phone Screen Interviews.
- [CodePen](https://codepen.io) : Front End Developer Playground & Code Editor in the Browser
- [Devicons](http://vorillaz.github.io/devicons/#/main) : Cheatsheet for devs icons
- [regex101](https://regex101.com) : Online regex tester and debugger: PHP, PCRE, Python, Golang and JavaScript
- [regexr](https://regexr.com) : Another online tool to learn, build & test Regular Expressions
- [Wit AI](https://wit.ai) : Natural Language for Developers
- [Seymour](https://harc.github.io/seymour-live2017) : Live Programming for the Classroom
- [Code share](https://codeshare.io) : Share code in real-time with other developers
- [Solid Tools for Developers](https://soliddevtools.com) : Online debugging tools for developers and system administrators
- [OS Query](https://osquery.io/) : Easily ask questions about your Linux, Windows, and macOS infrastructure

## Bash and Shell scripting  
- [Advanced Bash-Scripting Guide](http://tldp.org/LDP/abs/html/) : An in-depth exploration of the art of shell scripting
- [Bash Guide for Beginners](http://www.tldp.org/LDP/Bash-Beginners-Guide/html/) : Bash Guide for Beginners Machtelt Garrels
- [Bash Programming](http://tldp.org/HOWTO/Bash-Prog-Intro-HOWTO.html) : by Mike G mikkey at dynamo.com.ar
- [Bash Reference Manual](https://www.gnu.org/software/bash/manual/bashref.html) : Bash Reference Manual
- [BashGuide](http://mywiki.wooledge.org/BashGuide) : BashGuide - Greg's Wiki
- [Conquering the Command Line](http://conqueringthecommandline.com/book/frontmatter) : Unix and Linux Commands for Developers
- [Airbon OS](https://www.airbornos.com) :  Private Google Docs Alternative

## Interview Preparation
- [/r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/20ahfq/heres_a_pretty_big_list_of_programming_interview/) : Here's a pretty big list of programming interview questions I compiled while studying for big 4 interviews. I think you guys will find it useful!
- [10 Frequently asked SQL Query Interview Questions](http://www.java67.com/2013/04/10-frequently-asked-sql-query-interview-questions-answers-database.html)
- [A Collection of Quant Riddles With Answers](http://puzzles.nigelcoldwell.co.uk)
- [Algorithm design canvas](https://www.hiredintech.com/algorithm-design))
- [Aptitude Questions and Answers](http://www.indiabix.com) : Quant and aptitude preparation
- [A site for technical interview questions, brain teasers, puzzles, quizzles](https://www.techinterview.org) : whatever the heck those are) and other things that make you think!
- [BeehYve](https://www.beehyve.io) : Student crowdsourced resources for any topic
- [Big collection of interview preparation links • /r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/2lzc4h/big_collection_of_interview_preparation_links/)
- [Big-O Algorithm Complexity Cheat Sheet](http://bigocheatsheet.com/#)
- [BIG O Misconceptions](http://ssp.impulsetrain.com/big-o.html)
- [Bitwise tricks](https://gist.github.com/dideler/2365607)
- [ChiperSoft/InterviewThis](https://github.com/Twipped/InterviewThis) : questions to ask during on a interview to know more about the company.
- [Code Project](https://www.codeproject.com) : For those who code!
- [Core Java Interview questions - Interview question on each topic](http://javahonk.com/core-java-interview-questions/)
- [C PUZZLES, Some interesting C problems](http://www.gowrikumar.com/c/index.php)
- [CS9: Problem-Solving for the CS Technical Interview](http://web.stanford.edu/class/cs9/)
- [Delightful Puzzles](http://gurmeet.net/puzzles/)
- [Determining the big-O runtimes of these different loops?](https://stackoverflow.com/questions/11094330/determining-the-big-o-runtimes-of-these-different-loops) : really good stackoverflow question that covers basics of calculating runtime complexity.
- [five-essential-phone-screen-questions - steveyegge2](https://sites.google.com/site/steveyegge2/five-essential-phone-screen-questions)
- [Freshers Interviews](http://placementsindia.blogspot.com)
- [GeeksforGeeks | A computer science portal for geeks](http://www.geeksforgeeks.org) : also subscribe to their feeds to get links to their new articles.
- [github.com/odino/interviews](https://github.com/odino/interviews) : list of important questions for interview
- [Give your résumé a face lift](http://www.lifeclever.com/give-your-resume-a-face-lift/)
- [Guide to Tech Interviews](https://www.kchodorow.com/blog/2013/02/28/guide-to-tech-interviews/)
- [Here's How to Prepare for Tech Interviews • /r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/1jov24/heres_how_to_prepare_for_tech_interviews/)
- [How to Answer "Tell Me a Little About Yourself" | The Art of Manliness](http://www.artofmanliness.com/2016/01/05/tell-me-a-little-about-yourself/)
- [How to Answer the Toughest 40 Job Interview Questions | ICS Job Portal](http://www.icsjobportal.com/blog/job-interview-questions)
- [How to Break Into the Tech Industry - a Guide to Job Hunting and Tech Interviews](http://haseebq.com/how-to-break-into-tech-job-hunting-and-interviews)
- [How to interview](http://kelukelu.me/interview/index.html)
- [How to prepare for an interview - 1](http://se7so.blogspot.com/2014/01/how-to-prepare-for-interview-1.html)
- [IIT Delhi Placement Experience](http://placement-iit2013.blogspot.com)
- [samwincott/Internship-Guide](https://github.com/samwincott/Internship-Guide) : An aggregrate of links related to internships.
- [Interviewing At Jane Street](https://blog.janestreet.com/interviewing-at-jane-street/) : Interviewing At Jane Street
- [Interview Archives - Java Honk](http://javahonk.com/category/interview/)
- [Job Interview: How to Ace a Job Interview | The Art of Manliness](http://www.artofmanliness.com/2012/08/06/how-to-ace-a-job-interview/)
- [Job interviews News, Videos, Reviews and Gossip - Lifehacker](https://lifehacker.com/tag/job-interviews)
- [Job Interview Questions and Best Answers](https://www.thebalance.com/job-interview-questions-and-answers-2061204)
- [kimberli/interviews](https://github.com/kimberli/interviews) : study sheet for Interview
- [Mission-peace/interview problems](https://github.com/mission-peace/interview/wiki) : A large collection of coding interview problems
- [Pramp | A free on demand interview practice platform for Software Engineers](https://www.pramp.com/ref/gt1) : Practice coding interviews with real peers
- [Problems | LeetCode OJ](https://leetcode.com/problemset/algorithms/) : Coding practice for interviews
- [Programmer And Software Interview Questions Answers](http://www.programmerinterview.com)
- [Reddit.com/user/ashish2199/m/puzzles](https://www.reddit.com/user/ashish2199/m/puzzles/) : Logic Puzzles
- [SQL interview questions](https://www.jitbit.com/news/181-jitbits-sql-interview-questions/) : great SQL test
- [SQL Joins explained using venn diagram](http://stevestedman.com/wp-content/uploads/VennDiagram1.pdf)
- [svozniuk/java-interviews](https://github.com/svozniuk/java-interviews) : Java interview questions
- [The 25 most difficult HR questions](http://www.datsi.fi.upm.es/~frosal/docs/25mdq.html)
- [Top 10 Algorithms for Coding Interview](https://www.programcreek.com/2012/11/top-10-algorithms-for-coding-interview/) : Algorithms for Coding Interview
- [Unix / Linux Cheat Sheet](http://cheatsheetworld.com/programming/unix-linux-cheat-sheet/)
- [Unsolicited_advice_for_job_seekers_and_employers](https://www.reddit.com/r/india/comments/1clgdj/unsolicited_advice_for_job_seekers_and_employers/)
- [Visualising Data Structures and Algorithms through Animation](https://visualgo.net/en)
- [We Help Coders Get Hired](https://www.hiredintech.com/app) : website offering courses on system design, interview strategies, soft skills etc
- [what_are_your_goto_questions_for_the_do_you_have?](https://www.reddit.com/r/cscareerquestions/comments/209rkq/what_are_your_goto_questions_for_the_do_you_have/)
- [Why You Make Less Money • /r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/1b8wa3/why_you_make_less_money/)
- [wu :: riddles(hard)](https://www.ocf.berkeley.edu/~wwu/riddles/hard.shtml) : logic puzzles and riddles


## Documentaries
- [Ask Me Anything](https://www.youtube.com/watch?v=1fqxMuPmGak) : Gayle Laakmann McDowell (author of Cracking the Coding Interview)
- [Breaking the Code](https://www.youtube.com/watch?v=S23yie-779k) : Biography of Alan Turing
- [Cracking The Code Interview](https://www.youtube.com/watch?v=4NIb9l3imAo) : Cracking the Code Interview
- [Cracking the Coding Interview](https://www.youtube.com/watch?v=Eg5-tdAwclo) : Cracking the Coding Interview, Fullstack Speaker Series
- [Download: The True Story of the Internet](https://www.youtube.com/playlist?list=PL_IlIlrxhtPMqW4b0-v8OgLvFZQes6SoZ) : Play-list of discovery channel documentary on browser wars, dot com bubble and more.
- [Harvard CS50 - Asymptotic Notation (video)](https://www.youtube.com/watch?v=iOq5kSKqeR4) : Asymptotic Notation explained by Harvard
- [How does CPU execute program (video)](https://www.youtube.com/watch?v=42KTvGYQYnA) : Take a look at how a CPU executes programs
- [Machine Code Instructions (video)](https://www.youtube.com/watch?v=Mv2XQgpbTNE) : Code instructions
- Machine that Changed the World - a very good documentary about history of computers
  - Part 1 is unavailable for free streaming due to widespread copyright claims.
  - [Part 2: Inventing the Future](https://www.youtube.com/watch?v=0iPiYxjsYKk)
  - [Part 3: The Paperback Computer](https://www.youtube.com/watch?v=d7DKVfOXr54)
  - [Part 4: The Thinking Machine](https://www.youtube.com/watch?v=enWWlx7-t0k)
  - [Part 5: The World at Your Fingertips](https://www.youtube.com/watch?v=fLLXiP7diEo)
- [Mechanical Computer (All Parts)](https://www.youtube.com/watch?v=s1i-dnAH9Y4) : a very good video from 1950s explaining how mechanical computers used to work without all the modern day electronics.
- [Project Code Rush](https://www.youtube.com/watch?v=a-49a_CjH0M) : The Beginnings of Netscape / Mozilla Documentary
- [Teach Yourself Computer Science](https://teachyourselfcs.com) : Teach Yourself Computer Science
- [The Code](https://www.youtube.com/watch?v=XMm0HsmOTFI) : Story of Linux documentary
- [Triumph of the Nerds](https://www.youtube.com/playlist?list=PLn-Y3vvQbmHO5WUcBdIWqiUfNawhC1cn3) : Play-list


## MOOCs for learning something new
- [Class Central](https://www.class-central.com) : a directory of 100,000+ student reviews of thousands of MOOCs.
- [Computer Science Resources](https://docs.google.com/spreadsheets/d/1BD8BJJUNaX63m2QmySWMGDp71nx4W4MyyiIBlfMoN3Q/htmlview?sle=true#) : list of MOOCs for autodidacts
- [Coursera.org](https://www.coursera.org) : Take the world's best courses, online.
- [CS50](https://www.youtube.com/user/cs50tv/videos) : A set of goods tutorials from cs50
- [edX](https://www.edx.org) : Free Online Courses, Advance Your Career, Improve Your Life.
- [Kadenze | Creative Programming](https://www.kadenze.com/courses?subjects%5B%5D=7) : Programming courses focused on art and creativity
- [MIT OCW Electrical Engineering and Computer Science](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/)
- [MOOC.fi](http://mooc.fi/english.html) : Free online courses from the University of Helsinki
- [NPTEL](http://nptel.ac.in) : Free online courses by IIT with certificates
- [prakhar1989/awesome-CS-courses](https://github.com/prakhar1989/awesome-courses/blob/master/README.md) : List containing large amount of CS courses


## Sites related to your preferred programming language (For me Java)
- [Best books for learning java must read](https://javahungry.blogspot.com/2014/02/best-books-for-learning-java-must-read.html) : Get basics of Java
- [Bjarne Stroustrup's C++ Style and Technique FAQ](http://www.stroustrup.com/bs_faq2.html) : The C++ FAQ
- [Bjarne Stroustrup's FAQ](http://www.stroustrup.com/bs_faq.html) : The C++ FAQ
- [C++11 - the new ISO C++ standard](http://www.stroustrup.com/C++11FAQ.html) : The C++11 FAQ
- [Compilers (video)](https://www.youtube.com/playlist?list=PLO9y7hOkmmSGTy5z6HZ-W4k2y8WXF7Bff) : A set of videos on how the GC works
- [Deep Dive Java](https://www.infoq.com/presentations/garbage-collection-benefits) : Garbage Collection is Good!
- [Free Online Chapters of Inside the Java Virtual Machine by Bill Venners](http://www.artima.com/insidejvm/ed2/index.html) : Java Corner
- [How Garbage Collection Works](https://www.dynatrace.com/resources/ebooks/javabook/how-garbage-collection-works/) : Java memory management
- [Implementation of Algorithms and Data Structures, Interview Questions and Answers](https://github.com/sherxon/AlgoDS)
- [IntelliJ Keyboard Shortcuts](https://www.jetbrains.com/help/idea/keyboard-shortcuts-you-cannot-miss.html) : Keyboard shortcuts to enhance your productivity when working in IntelliJ.
- [Java Corner at Artima.com](http://www.artima.com/java/index.html) : Java Corner at Artima.com
- [Java Lecture Notes](http://www.cafeaulait.org/course/) : Java Student's Resource
- [Java Off Heap](http://www.javaoffheap.com) : Java Off the Heap house
- [Java Revisited](http://javarevisited.blogspot.com) : good for learning about Java Language and interview preparation.
- [Java-source](http://www.java-source.net) : Java source
- [Java Visualizer](http://www.cs.princeton.edu/~cos126/java_visualize/) : helps visualize references, values of variables, etc
- [JournalDev - Java, Java EE, Android, Web Development Tutorials](https://www.journaldev.com) : Java, Java EE, Android, Web Development Tutorials
- [Learning Java](http://chimera.labs.oreilly.com/books/1234000001805/index.html) : a free online textbook for learning Java
- [Netbeans Keyboard Shortcuts](https://netbeans.org/project_downloads/usersguide/shortcuts-80.pdf) : Keyboard shortcuts to enhance your productivity when working in Netbeans.
- [Search Open Source Java API](http://www.docjar.com) : view source of java library and learn how things are implemented.
- [The C++ Programming Language](http://www.stroustrup.com/C++.html) : The C++ Programming Language.
- [The Java Memory Model](http://www.cs.umd.edu/~pugh/java/memoryModel/): The Java Memory Model
- [The Java™ Tutorials](https://docs.oracle.com/javase/tutorial/) : The best tutorials for Java.
- [Understanding JVM Internals](http://www.cubrid.org/blog/understanding-jvm-internals) : Understanding JVM Internals
- [what-is-garbage-collection](https://plumbr.eu/handbook/what-is-garbage-collection) : Demystify the garbage collection
- [JavaWorld](https://www.javaworld.com) : Welcome to Javaworld
- [XyzWs Java FAQs](http://www.xyzws.com/javafaq/page/1) : large collection of java interview questions


## Learn AI
- [fast.ai](http://course.fast.ai) : Free practical *deep learning* course for coders without grad-level maths!
- [grakn.ai](https://grakn.ai) : The Database for AI
- [Robots that learn](https://blog.openai.com/robots-that-learn/) : Robots that Learn
- [Unsupervised Sentiment Neuron](https://blog.openai.com/unsupervised-sentiment-neuron/) : Unsupervised Sentiment Neuron
- [What's the difference between AI- DP and ML?](https://blogs.nvidia.com/blog/2016/07/29/whats-difference-artificial-intelligence-machine-learning-deep-learning-ai/) : Difference artificial intelligence, machine-learning, deep-learning-ai
- [TensorFlow](https://www.tensorflow.org) : An open-source software library for Machine Intelligence
- [Scikit-learn](http://scikit-learn.org) : A Python module for machine learning build on top of SciPy
- [DeepLearning.ai](https://www.deeplearning.ai) : Deep Learning course by Andrew Ng, Founder of coursera
- [Coding the History of Deep Learning](http://blog.floydhub.com/coding-the-history-of-deep-learning/) : Coding the History of Deep Learning
- [Serpent AI](https://github.com/SerpentAI/SerpentAI) : Game Agent Framework. Helping you create AIs / Bots to play any game you own! BETA
- [Blog Floydhub](https://blog.floydhub.com/colorizing-b&w-photos-with-neural-networks/) : Colorizing B&W Photos with Neural Networks


## Seminar , research writing , talks etc
- [Advice on Research and Writing](http://www.cs.cmu.edu/~mleone/how-to.html) : A collection of advice about how to do research and how to communicate effectively (primarily for computer scientists).
- [PHD MS Articles](http://www.cse.iitd.ac.in/~srsarangi/articles.html) : articles and views
- [Seminar and reports](https://www.cse.iitb.ac.in/~ranade/communicationskills.html) : Everyone must read this tiny book before writing the seminar report
- [Latex reference](http://latex.knobs-dials.com) : Arbitrary reference
- [Begin Latex in minutes](https://github.com/LewisVo/Begin-Latex-in-minutes) : Brief Intro to LaTeX for beginners that helps you use LaTeX with ease
- [Lshort](https://tobi.oetiker.ch/lshort/lshort.pdf) : The Not So Short Introduction to LATEX2ε


## Everything in one place
- [reddit.com/user/ashish2199/m/cs_student_subs](https://www.reddit.com/user/ashish2199/m/cs_student_subs/) : a multisubreddit of all subreddits of topics related to computer science and programming.
- [Websites a programmer should visit](https://www.quora.com/What-are-the-best-websites-a-programmer-should-visit/answer/Ashish-Padalkar?srid=OH96) : Response on Quora by ashish2199
- [Moocha](https://www.moocha.io) : Search online courses from edX, Coursera, Udacity, & more
- [Rico's cheatsheets](https://devhints.io) : A set of good cheatsheets
- [API Documentation](http://devdocs.io) : A one-place well known API Documentation with searchable interface


## YouTube Channels
- [C++Now (BoostCon)](https://www.youtube.com/channel/UC5e__RG9K3cHrPotPABnrwg) : C++Now (previously BoostCon) conference
- [code::dive conference](https://www.youtube.com/channel/UCU0Rt8VHO5-YNQXwIjkf-1g) : code::dive conference organized by NOKIA Wrocław Technology Center
- [Coding Blocks](https://www.youtube.com/user/codingblocks) : Tutorials, how to's, tips and tricks
- [Computerphile](https://www.youtube.com/user/Computerphile/videos) : Must watch for every CS student
- [ComputerHistory](https://www.youtube.com/user/ComputerHistory/videos) : for those who like to know how we reached where we are.
- [CppCon](https://www.youtube.com/user/CppCon/videos?shelf_id=0&view=0&sort=dd) : C++ Conference
- [Facebook Developers](https://www.youtube.com/user/FacebookDevelopers/videos)
- [Google Developers](https://www.youtube.com/user/GoogleDevelopers/videos)
- [GoogleTechTalks](https://www.youtube.com/user/GoogleTechTalks/videos) : videos on trending topics and cool stuff happening in the tech industry.
- [Gynvael Coldwin](https://www.youtube.com/user/GynvaelEN) : Awesome reverse engineering and hacking(CTF) videocasts. Every wednesday are new live streams.
- [HowToBecomeTV](https://www.youtube.com/user/HowToBecomeTV/videos) : contains good interviews of developers and people related to tech industry.
- [Java](https://www.youtube.com/user/java/videos) : talks related to java
- [JavaOne](https://www.youtube.com/channel/UCdDhYMT2USoLdh4SZIsu_1g/videos) : Java Conference
- [Meeting C++ YT Kanalseite](https://www.youtube.com/user/MeetingCPP/videos) : Talks on C++
- [Netflix UI Engineering](https://www.youtube.com/channel/UCGGRRqAjPm6sL3-WGBDnKJA/videos) : great videos to watch for web developers, mobile developers and those interested in some of Netflix's tech stack
- [O'Reilly](https://www.youtube.com/user/OreillyMedia/videos) : interviews and talks of world's best technical writers.
- [Placement Grid](https://www.youtube.com/user/PlacementGrid/videos) : Interview and campus placement experience
- [Scott Meyers: Past Talks](http://www.aristeia.com/presentations.html)
- [Siraj Raval](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A) : Artificial Intelligence and deep learning tutorials videos
- [ThinMatrix](https://www.youtube.com/user/ThinMatrix/videos) : blogs and tutorials developer making a 3d game in Java using opengl
- [thoughtbot](https://www.youtube.com/user/ThoughtbotVideo/videos) : talks on various topics
- [Traversy Media](https://www.youtube.com/user/TechGuyWeb/videos) :Web development and programming
- [yegor256](https://www.youtube.com/user/technoparkcorp/videos)
- [GOTO Conference](https://www.youtube.com/user/GotoConferences) : tech talks from the GOTO Conference by Developers for Developers


## Good Articles
- [40 Keys Computer Science Concepts Explained In Layman’s Terms](http://carlcheo.com/compsci)
- [A Gentle Introduction To Graph Theory](https://dev.to/vaidehijoshi/a-gentle-introduction-to-graph-theory)
- [A programmer friendly language that compiles to Lua.](http://moonscript.org)
- [A Software Developer’s Reading List](https://stevewedig.com/2014/02/03/software-developers-reading-list/) : Some good books and links in there.
- [Code a TCP/IP stack](http://www.saminiir.com/lets-code-tcp-ip-stack-5-tcp-retransmission/) : Let's code a TCP/IP stack, 5: TCP Retransmission
- [Codewords.recurse](https://codewords.recurse.com/issues/four/the-language-of-choice) : The language of choice
- [Data structure and Algorithms](https://techiedelight.quora.com/500-Data-Structures-and-Algorithms-practice-problems-and-their-solutions) : List of some algorithms and datastructure with their solutions.
- [Dive into the byte code](https://www.wikiwand.com/en/Java_bytecode)
- [Expectations of a Junior Developer](http://blog.thefirehoseproject.com/posts/expectations-of-a-junior-developer/)
- [Linux Inside](https://0xax.gitbooks.io/linux-insides/content/Booting/linux-bootstrap-1.html)
- [List of algorithms](https://www.wikiwand.com/en/List_of_algorithms)
- [Step by Step Guide to Database Normalization](https://www.databasestar.com/normalization-in-dbms/): A guide to database normalization.
- [The Key To Accelerating Your Coding Skills](http://blog.thefirehoseproject.com/posts/learn-to-code-and-be-self-reliant/)
- [Unicode](https://www.joelonsoftware.com/2003/10/08/the-absolute-minimum-every-software-developer-absolutely-positively-must-know-about-unicode-and-character-sets-no-excuses/)
- [We are reinventing the retail industry through innovative technology](http://multithreaded.stitchfix.com)
- [What every programmer absolutely, positively needs to know about encodings and character sets to work with text](http://kunststube.net/encoding/)
- [What every programmer should know about memory - PDF](http://futuretech.blinkenlights.nl/misc/cpumemory.pdf)
- [Why fast pages are important](https://fly.io/articles/why-fast-pages-are-important/) : Why App Speed Matters, Revenue
- [qotoqot - improving-focus](https://qotoqot.com/blog/improving-focus/) : How I got to 200 productive hours a month
- [Pixel Beat - Unix](http://www.pixelbeat.org/docs/unix-parallel-tools.html) : Parallel processing with unix tools
- [Learning Vim](https://hackernoon.com/learning-vim-what-i-wish-i-knew-b5dca186bef7) : What I Wish I Knew
- [Write a Kernel](http://arjunsreedharan.org/post/82710718100/kernel-101-lets-write-a-kernel) : Kernel 101 – Let’s write a Kernel

## Podcasts
- [Coding Blocks](http://www.codingblocks.net) : A podcast covering topics such as best programming practices, design patterns, coding for performance, object oriented coding, database design and implementation, tips, tricks and a whole lot of other things.
- [Developer On Fire](http://developeronfire.com/episodes) : A podcast that shares the humanity of developers and tells stories of some of the amazing people in software, hosted by Dave Rael.
- [Developer Tea](https://spec.fm/podcasts/developer-tea) : A podcast for developers designed to fit inside your tea break.
- [Front End Happy Hour](http://frontendhappyhour.com) : A podcast featuring a panel of Software Engineers from Netflix, Evernote, Atlassian & LinkedIn talking over drinks about all things Front End development.
- [Full Stack Radio](http://www.fullstackradio.com) : Everything from product design and user experience to unit testing and system administration.
- [Groovy Podcast](http://groovypodcast.podbean.com) : A podcast dedicated to the Groovy programming language and its ecosystem.
- [IPhreaks](https://devchat.tv/iphreaks) : A weekly group discussion about iOS development and related technology by development veterans. We discuss Apple, tools, practices, and code.
- [JavaScript Jabber](https://devchat.tv/js-jabber) : A weekly discussion about JavaScript, front-end development, community, careers, and frameworks.
- [Learn To Code With Me Podcast](https://learntocodewith.me/podcast/) : A Season by season of tech podcast episodes by Laurence Bradford with topics ranging from Career in Tech to lessons in doing tech business
- [MS Dev Show](http://msdevshow.com) : Jason Young and Carl Schweitzer talk about the latest in developer news covering topics such as the Azure cloud, Windows, Windows Phone, Visual Studio, and cross-platform development using the Microsoft platform.
- [React Native Radio](https://devchat.tv/react-native-radio) : A weekly discussion of the tools, techniques, and technologies used to build mobile applications with JavaScript and React.
- [Software Engineering Daily](https://softwareengineeringdaily.com) : A daily technical interview about software topics.
- [Software Engineering Radio](http://www.se-radio.net) : A podcast targeted at the professional software developer. The goal is to be a lasting educational resource, not a newscast.
- [Syntax](https://syntax.fm) : A Tasty Treats Podcast for Web Developers by Wes Bos & Scott Tolinski.
- [The Bike Shed](http://bikeshed.fm) : Guests discuss their development experience and challenges with Ruby, Rails, JavaScript, and others.
- [The Changelog](https://changelog.com/podcast) : A weekly conversation that gets to the heart of open source technologies and the people who create them.
- [The Cynical Developer](https://cynicaldeveloper.com) : A podcast that aims to help you to improve your development knowledge and career, through explaining the latest and greatest in development technology and providing you with what you need to succeed as a developer. Covering Desktop, web and mobile development, mainly around the .Net Stack but often looking into other software and frameworks.


## Building a Simple Compiler/Interpreter
- [:snowman: Possibly the smallest compiler ever](https://github.com/thejameskyle/the-super-tiny-compiler) : This is an ultra-simplified example of all the major pieces of a modern compiler written in easy to read JavaScript.
- [Awesome Compilers](http://aalhour.com/awesome-compilers/) : Curated list of awesome resources on Compilers, Interpreters and Runtimes.
- [Growing a compiler](http://www.cs.dartmouth.edu/~mckeeman/cs48/mxcom/gem/html/GrowingCompiler.html) : Learn how to grow a compiler
- [Let’s Build A Simple Interpreter. Part 1.](https://ruslanspivak.com/lsbasi-part1/) : Try to demystify compilers by building one
- [Resources for Amateur Compiler Writers](http://c9x.me/compile/bib/) : Resources for Amateur Compiler Writers
- [Structure and Interpretation of Computer Programs](https://sarabander.github.io/sicp/html/index.xhtml) : Structure and Interpretation of Computer Programs
- [Writing My First Compiler](https://dev.to/fcpauldiaz/writing-my-first-compiler) : Write out your first compiler
- [An Intro to Compilers](https://nicoleorchard.com/blog/compilers) : How to Speak to Computers, Pre-Siri
- [Write your own compiler](http://staff.polito.it/silvano.rivoira/HowToWriteYourOwnCompiler.htm) : How to write your own compiler



## Tutorials
- [A Hacker's Guide to Git](https://wildlyinaccurate.com/a-hackers-guide-to-git/) : for those wanting to learn git with a solid foundation
- [Best Of - Gustavo Duarte](http://duartes.org/gustavo/blog/best-of/) : contains articles on various topics
- [CMSI 281: Data Structures](http://cs.lmu.edu/~ray/classes/dsa/) : light weight introduction to DS
- [Collecting all the cheat sheets](http://overapi.com) : cheat sheets for lots of programming languages
- [C Programming](http://users.cs.cf.ac.uk/Dave.Marshall/C/CE.html)
- [Data Structures and Algorithms by John Morris](http://oopweb.com/Algorithms/Documents/PLDS210/VolumeFrames.html) : another good source with code and its analysis
- [Deep C](https://www.slideshare.net/olvemaudal/deep-c) : very good presentation on C language
- [Design Patterns: Elements of Reusable Object-Oriented Software](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented/dp/0201633612) : aka the "Gang Of Four" book, or GOF
- [Dynamic programming - PrismoSkills](http://prismoskills.appspot.com/lessons/Dynamic_Programming/Chapter_01_-_Introduction.jsp) : very good resource if want to learn how to solve DP problems.
- [Git from the inside out](https://maryrosecook.com/blog/post/git-from-the-inside-out)
- [Head First Design Patterns](https://www.amazon.com/Head-First-Design-Patterns-Brain-Friendly/dp/0596007124)
- [How to Program in C++](http://cs.fit.edu/~mmahoney/cse2050/how2cpp.html) : Good resource for revising C++ topics and STL
- [http://www.mysqltutorial.org/](http://www.mysqltutorial.org)
- [indradhanush tutotials](https://indradhanush.github.io/blog/writing-a-unix-shell-part-3/) : Writing a Unix Shell
- [Introduction to C Programming](http://www.le.ac.uk/users/rjm1/cotter/index.htm)
- [Learn UNIX in 10 minutes](http://freeengineer.org/learnUNIXin10minutes.html)
- [Learning the shell.](http://linuxcommand.org)
- [Linux Journey](https://linuxjourney.com) : good site for learning linux
- [Linux Tutorial](https://ryanstutorials.net/linuxtutorial/) : good resource for learning Linux
- [More about Github-flavored markdown](https://guides.github.com/features/mastering-markdown/)
- [MySQL Essentials](http://www.techotopia.com/index.php/MySQL_Essentials)
- [Open Data Structures](http://opendatastructures.org) : Excellent resource for learning about DS and algos, provides code in various languages C++, Java and pseudocode.
- [OS Course Notes](https://www2.cs.uic.edu/~jbell/CourseNotes/OperatingSystems/) : Chapter wise course notes according to Galvin's book
- [Programming, Web Development, and DevOps news, tutorials and tools for beginners to experts](https://dzone.com)
- [SQL (Structured Query Language) in one page : SQL.SU](http://www.cheat-sheets.org/sites/sql.su/) : a very good SQL cheat sheet
- [Subtle | Poor Man's CI](https://www.subtle.press/course/poor-mans-ci) : Learn how continuous integration platforms work under the hood, by building one of your own on top of git with Node.js
- [TCP/IP Illustrated Series](https://en.wikipedia.org/wiki/TCP/IP_Illustrated)
- [The Bash Guide](http://guide.bash.academy) : very good guide for learning the Bash Shell
- [The Descent to C](https://www.chiark.greenend.org.uk/~sgtatham/cdescent/) : for those moving to C from some higher programming language like java or python.
- [The Linux Command Line: A Complete Introduction](https://www.amazon.com/Linux-Command-Line-Complete-Introduction/dp/1593273894)
- [The Unix Programming Environment](http://product.half.ebay.com/The-UNIX-Programming-Environment-by-Brian-W-Kernighan-and-Rob-Pike-1983-Other/54385&tg=info)
- [TopCoder Tutorials](https://www.topcoder.com/community/data-science/data-science-tutorials/)
- [Tutorialspoint](https://www.tutorialspoint.com) : Text and Video Tutorials for UPSC, IAS, PCS, Civil Services, Banking, Aptitude, Questions, Answers, Explanation, Interview, Entrance, Exams, Solutions
- [UNIX and Linux System Administration Handbook, 4th Edition](https://www.amazon.com/UNIX-Linux-System-Administration-Handbook/dp/0131480057)
- [VimTutor+](https://vimtutorplus.herokuapp.com/exercise/1) : Learn VIM from the browser.
- [W3Schools Online Web Tutorials](https://www.w3schools.com)
- [Unix Shell](https://www.dartmouth.edu/~rc/classes/ksh/print_pages.shtml) : Unix shell scripting with ksh/bash
- [Snap SVG](http://snapsvg.io) : The JavaScript SVG library for the modern web
- [vim.rtorr](https://vim.rtorr.com) : Vim Cheat Sheet
- [Open Vim](http://www.openvim.com/tutorial.html) :  Interactive Vim tutorials
- [Algorithm Using Dynamic Programming and A](http://thume.ca/2017/06/17/tree-diffing/) : Designing a Tree Diff Algorithm Using Dynamic Programming and A*
- [Learn Python](https://www.learnpython.org) : Free Interactive Python Tutorial
- [C++17](https://www.viva64.com/en/b/0533/) : A guide of C++17
- [The Bash Academy](http://www.bash.academy) : The Bash Academy is an initiative to promote the bash shell language and educate people on its use.
- [Learn Shell Programming](http://learnshell.org) : This website is intended for everyone who wishes to learn programming with Unix/Linux shell interpreters.
- [Java tutorial](https://hackr.io/tutorials/learn-java) : A programming community & a great place to find the best online programming courses and tutorials.

## Watch others code
- [LiveEdu.tv](https://www.liveedu.tv) : screencast of people building application, websites, games, etc.
- [Twitch.tv](https://www.twitch.tv/communities/programming) : The programming community of twitch.


## What should a programmer know
- [GitHub.com Build software better, together](https://github.com) : Place to showcase your project and collaborate with others. (Must know Git in order to use it effectively)
- [Gitlab offers free unlimited (private) repositories and unlimited collaborators](https://about.gitlab.com)
- [Programmer Competency Matrix](http://sijinjoseph.com/programmer-competency-matrix/) : article for knowing what our level as a programmer is.


## Competitive programming
- [Topic Wise Problem For Competitive Programmer](https://a2oj.com/categories) : Topic wise Practise Problem
- [Archived Problems - Project Euler](https://projecteuler.net/archives) : Problems Archives
- [Art of Problem Solving](https://artofproblemsolving.com) : Is math class too easy for you? You've come to the right place!
- [CodeChef](https://www.codechef.com) : The only programming contests Web 2.0 platform
- [Codefights](https://codefights.com) : Test your coding skills
- [Codeforces](http://codeforces.com) : Programming Competition,Programming Contest,Online Computer Programming
- [Codewars](https://www.codewars.com) : Rank up by completing code kata
- [Codility](https://codility.com) : Verify and improve coding skills
- [Codingame](https://www.codingame.com/start) : Learn coding through games and challenges!
- [Facebook Hacker Cup](https://www.facebook.com/hackercup/) : Facebook's Programming Contest, past problems solutions and FAQ
- [Google Code Jam Practice and](https://code.google.com/codejam/past-contests) : past contest problems for practice
- [HackerEarth - Programming challenges and Developer jobs](https://www.hackerearth.com)
- [HackerRank](https://www.hackerrank.com) : Practice coding. Compete. Find jobs.
- [PKU ACM ICPC Practice problems](http://poj.org/problemlist) : Judge online for ACMACPC
- [Sphere Online Judge (SPOJ)](http://www.spoj.com) : Become a true programming master Learn how to code and build efficient algorithms
- [Topcoder](https://www.topcoder.com) : Deliver Faster through Crowdsourcing
- [URI Online Judge](https://www.urionlinejudge.com.br/judge/en/register) : Practice coding, Compete and be a better coder.
- [UVa Online Judge](https://uva.onlinejudge.org) : hundreds of problems supporting multiple languages.
- [WakaTime](https://wakatime.com) : leaderboards of coding metrics collected via editor plugins


## Computer Books
- [Become a Programmer, Motherfucker (list of books)](http://programming-motherfucker.com/become.html) : Exhaustive list of books from Zed A. Shaw.
- [Best books for GATE CSE](http://gatecse.in/best-books-for-gatecse/)
- [cses.fi/book.html](https://cses.fi/book.html)
- [github.com/vhf/free-programming-books](https://github.com/EbookFoundation/free-programming-books/blob/master/free-programming-books.md) : More than 500 free ebooks on almost any language you can think of
- [GitBook](https://www.gitbook.com) : GitBook helps your team write, collaborate and publish content online.
- [Data Science course](https://jakevdp.github.io/PythonDataScienceHandbook/) : Python Data Science Handbook


## Video Tutorials
- [codedamn](https://www.youtube.com/channel/UCJUmE61LxhbhudzUugHL2wQ/videos) : front end web dev tutorials
- [Code School](https://www.codeschool.com) : A PluralSight Company and an Interactive learning destination for aspiring and experienced Developers
- [CodingMadeEasy](https://www.youtube.com/user/CodingMadeEasy/videos) : C++ tutorials
- [CS1: Higher Computing - Richard Buckland UNSW](https://www.youtube.com/playlist?list=PL6B940F08B9773B9F) : a very good introductory CS course
- [Derek Banas](https://www.youtube.com/user/derekbanas/videos) : good quality tutorials
- [Design and Analysis of Algorithms](http://openclassroom.stanford.edu/MainFolder/CoursePage.php?course=IntroToAlgorithms)
- [DevTips](https://www.youtube.com/user/DevTipsForDesigners/videos) : web dev tutorials
- [FreeCourses](https://freecourses.github.io) : Free courses about programming
- [Kathryn Hodge](https://www.youtube.com/channel/UC4DwZ2VXM2KWtzHjVk9M_xg/videos) : Has good videos for beginners
- [mycodeschool](https://www.youtube.com/user/mycodeschool/videos) : Data structures and algorithms tutorials
- [Pluralsight](https://www.pluralsight.com) : Learn Software Development, DevOps and Data Science through multiple short courses
- [thenewboston](https://www.youtube.com/user/thenewboston/videos) : good but with too much talk as compared to actual content
- [Tushar Roy](https://www.youtube.com/user/tusharroy2525/videos) : Algorithm and Data structure tutorial by an Indian Youtuber.
- [Vim Tutorial Videos - Flarfnoogins](http://derekwyatt.org/vim/tutorials/index.html) : good video tutorial for learning vim
- [XDA-University - Helping You Learn Android Development](https://forum.xda-developers.com/general/xda-university)
- [Khan Academy](https://www.khanacademy.org/computing/computer-science) : learn about computer science for free
- [Functional programming](https://www.youtube.com/watch?v=1PhArSujR_A) : John Carmack on Functional Programming (2013)
- [Video about vims](https://vimeo.com/album/2838732) : A serie of tutorials about Vim


## Online Compiler and Sharing Code snippets
- [CodePad](https://codepad.remoteinterview.io) : Code editor to try, test and run 25+ languages
- [Codesandbox.io](https://codesandbox.io) : CodeSandbox makes it easier to create, share and reuse React projects with others.
- [Godbolt.org](https://godbolt.org) : Excellent tool for exploring the assembly output of different compilers with and without optimization.
- [Ideone.com](https://ideone.com) : online compiler and debugging tool for more than 60 programming languages
- [JSFiddle](https://jsfiddle.net) : Test your JavaScript, CSS, HTML or CoffeeScript with online code editor
- [Pastebin.com](https://pastebin.com)
- [C9.io](https://c9.io) : Your development environment, in the cloud
- [Github Gist](https://gist.github.com) : Instantly share code, notes, and snippets.


## Blogs of Developers
- [Algo-Geeks](http://algo-geeks.blogspot.com) : Programming Puzzles, Math Tricks, Algorithms etc
- [Andy Heathershaw](https://www.andyheathershaw.uk) : Personal website and blog of software developer Andy Heathershaw
- [Antonio081014's Algorithms Codes](http://code.antonio081014.com) : The world is under the RULE.  
- [Archives — Ask a Manager](http://www.askamanager.org/archives) : HR related stuff
- [Armin Ronacher's Thoughts and Writings](http://lucumr.pocoo.org) : blog on Python and open source
- [blog.might.net](http://matt.might.net/articles/) : the blog of might dot net
- [Brendon Gregg - Linux Kernel Dev](http://www.brendangregg.com) : the blog of Brendon D. Gregg
- [Clean Coder Blog](http://blog.cleancoder.com) : blog of author of book "Clean Code"
- [CodeAhoy](https://codeahoy.com) : Blog on software and human factors. 100% Tested on Humans.
- [CoderGears Blog Insights from](http://www.codergears.com/Blog/) : the CoderGears Team
- [Coding Geek - A blog about IT, programming and Java](http://coding-geek.com) : A blog about IT, programming and Java
- [Coding Horror](https://blog.codinghorror.com) : one the best coding blog
- [CSE Blog](http://www.cseblog.com) : quant, math, computer science puzzles
- [Daedtech.com](https://www.daedtech.com) : Stories about software
- [Dan Dreams of Coding](https://dandreamsofcoding.com)
- [Daniel Lemire's Blog](https://lemire.me/blog/) : Daniel Lemire's blog
- [Eli Bendersky](http://eli.thegreenplace.net) : everything from Python to LLVM
- [Geek Land](https://avidullu.wordpress.com) : My precious collectibles
- [HackerEarth Blog](http://blog.hackerearth.com) : The hackerearth blog
- [IT Enthusiast](http://rodiongork.tumblr.com) : IT Enthusiast
- [Joel on Software](https://www.joelonsoftware.com) : The blog of the CEO of StackOverflow
- [Late Developer](https://latedev.wordpress.com) :  Random thoughts of an old C++ guy
- [1ucasvb's laboriginal math and physics visualization](http://1ucasvb.tumblr.com) : Lucas Vieira Barbosa's lab original math and physics visualization
- [Math ∩ Programming](https://jeremykun.com) : Math ∩ Programming
- [My Tech Interviews](http://www.mytechinterviews.com) : PREPARE FOR A TECHNICAL INTERVIEW
- [Paul Graham Essays](http://www.paulgraham.com/articles.html) : Paul Grahan Essays
- [Programming Blog](http://www.yegor256.com) : programming blog of Yegor Bugayenko
- [Programming in the 21st Century](http://prog21.dadgum.com) : programming in the twenty-first century
- [rudhakar Rayavaram](http://sudhakar.online) : Sudhakar Rayavaram Blog's
- [Runhe Tian Coding Practice](https://tianrunhe.wordpress.com) : Technical interview questions from Apple, Google, Facebook, Amazon and Microsoft
- [Small Programming Challenges and Puzzles](https://www.nayuki.io/category/programming) : Project Nayuki
- [stevehanov.ca](http://stevehanov.ca/blog/) : I know how to make and sell software online, and I can share my tips with you.
- [Takipi Blog](http://blog.takipi.com) : mainly focuses on Java and JVM languages
- [WildMl](http://www.wildml.com) : A blog for machine learning.
- [XDA - Android Developer Forum](https://forum.xda-developers.com) : Android Open Source Developers Forum


## For improving your English
- [Englishclub.com/learn-english](https://www.englishclub.com/learn-english.htm)
- [Guide to Grammar and Writing](http://grammar.ccc.commnet.edu/grammar/) : for those who want to improve their english language skills
- [Punctuation and Capitalization Rules](http://www.grammarbook.com/english_rules.asp)
- [Purdue University Online Writing Lab (OWL)](https://owl.english.purdue.edu)
- [Quia - English](https://www.quia.com/shared/english/)


## When you get bored from CS related stuff
- [Barcroft TV](https://www.youtube.com/user/barcroftmedia/featured) : Daily short documentaries about the incredible variety of people that make up the world
- [Big Think](https://www.youtube.com/user/bigthink/videos) : Expert driven, actionable, educational content, featuring experts ranging from Bill Clinton to Bill Nye
- [ColdFusion](https://www.youtube.com/user/coldfustion/videos) : Past, present, and future of technology
- [CrashCourse](https://www.youtube.com/user/crashcourse/videos) : small courses on various subjects
- [Every Frame a Painting](https://www.youtube.com/user/everyframeapainting/videos) : High quality analysis of films and filmmaking
- [National Geographic](https://www.youtube.com/user/NationalGeographic/videos) : High volume of high quality content from all over the world
- [r/ProgrammerHumor](https://www.reddit.com/r/ProgrammerHumor/) : Subreddit dedicated to exactly what it sounds like
- [Reddit the front page of the internet](https://www.reddit.com) : Where free time goes to die
- [Ridddle](https://www.youtube.com/user/VineMontanaTV/videos) : A youtube channel about science, mainly, but not only, the universe and space.
- [SciShow](https://www.youtube.com/user/scishow/videos) : Answers to interesting questions that you've always wondered about
- [SmarterEveryDay](https://www.youtube.com/user/destinws2/videos) : Lots of amazing scientific information about the world around us, usually captured with a high-speed camera
- [TED](https://www.youtube.com/user/TEDtalksDirector/videos) : Great talks about technology, entertainment, and design
- [TestTube News](https://www.youtube.com/user/TestTubeNetwork/videos) : Interesting information about news from around the world
- [How to live for long time ?](http://www.bbc.com/future/story/20170601-the-secret-to-a-long-and-healthy-life-eat-less) : The secret of longevity
- [Vsauce](https://www.youtube.com/user/Vsauce/videos) : The best youtube channel
- [Ox A cuk](http://www.ox.ac.uk/research/research-in-conversation/how-live-happy-life/dr-bronwyn-tarr#) : How to live a happy life
- [lonelyspeck](https://www.lonelyspeck.com/the-milky-way-in-los-angeles-light-pollution/) : Expose to the Right for Astrophotography in Light Pollution – Palos Verdes, Los Angeles, California

## Open Source Websites
- [Open Hatch](https://openhatch.org) : OpenHatch is a non-profit dedicated to matching prospective free software contributors with communities, tools, and education.
- [Source Forge](https://sourceforge.net) : SourceForge hosts nearly 280,000 projects (at last count). It serves more than 2 million downloads a day and includes apps and tools in a wide variety of categories.
- [Google Code](https://code.google.com/projecthosting) : Google offers free hosting for open source projects using the Subversion or Mercurial version control systems. It offers 2 GB of storage, integrated code review tools, a wiki, and an issue tracker. The Google Code site also provides links to Google's many publicly available APIs and other developer tools.
- [Launch Pad](https://launchpad.net) : Maintained by Canonical, LaunchPad is particularly targeted at projects that run on Ubuntu. It provides hosting for more than 21,000 projects that use the Bazaar version control system.
- [Google Open Source](https://opensource.google.com) : Google Open Source
- [Red Hat Developer](https://developers.redhat.com) : The world's leading provider of open source solutions
- [Open Source](https://opensource.com) : Open Source
- [Google Summer of Code](https://summerofcode.withgoogle.com) : Google Summer of Code is a global program focused on bringing more student developers into open source software development. Students work with an open source organization on a 3 month programming project during their break from school.
- [Open Source Web Design](http://www.oswd.org) : Open Source Web Design is a platform for sharing standards-compliant free web design templates. We give web publishers a voice through good design.
- [Mozilla Winter of Security](https://wiki.mozilla.org/Security/Automation/Winter_Of_Security_2016) : The Winter of Security (MWOS) is a program organized by Mozilla's Security teams to involve students with Security projects. Students who have to perform a semester project as part of their university curriculum can apply to one of the MWOS project.
- [Eclipse Lab](http://www.eclipse.org/org/foundation/eclipselabs/faq.php) : Eclipse Labs is a community of open source projects that build technology based on the Eclipse platform. It provides the infrastructure services typically required by open source projects, such as code repositories, bug tracking, project web sites/wiki. Eclipse Labs is hosted by Google Code Project Hosting, so it will be very familiar to developers already using Google Code Project Hosting.
- [Bit Bucket](https://bitbucket.org) : Like GitHub, BitBucket hosts both public and private projects. On this site, open source projects and private projects with fewer than five users are free. It hosts more than 48,000 repositories, many of which are searchable on the site.
- [Media Wiki](https://www.mediawiki.org/wiki/MediaWiki) : MediaWiki is a free software open source wiki package written in PHP, originally for use on Wikipedia. It is now also used by several other projects of the non-profit Wikimedia Foundation and by many other wikis, including this website, the home of MediaWiki.
- [Code Curiosity](https://codecuriosity.org) : CodeCuriosity is a platform that encourages contributions to open source. Everyone is rewarded for their efforts, no matter how big or small they are.
- [Code Triage](https://www.codetriage.com) : Help out your favorite open source projects and become a better developer while doing it.
- [Issue Hub](http://issuehub.io) : Contribute to Open Source. Search issue labels to find the right project for you
- [Up for Grabs](http://up-for-grabs.net) : This is a list of projects which have curated tasks specifically for new contributors. These are a great way to get started with a project, or to help share the load of working on open source projects.
- [First Timers Only](http://www.firsttimersonly.com) : Contributing to open source for the first time can be scary and a little overwhelming. Perhaps you’re a Code Newbie or maybe you’ve been coding for a while but haven’t found a project you felt comfortable contributing to.
- [Your First PR](http://yourfirstpr.github.io) : Your First PR helps you get started contributing to Open Source by showcasing great starter issues on GitHub and elsewhere.

## Internships

- [Internshala](https://internshala.com) : You can search internships here according to your skill sets for your interested location. It also helps you in getting a good PPO offer from the company.
- [Chegg](http://www.chegg.com) : It is an awesome resource for finding internships, scholarships, tutors, etc.
- [Letsintern](https://www.letsintern.com) : Get a smart and challenging internship for you from the LetsIntern. 

## Jobs

- [Paysa](https://www.paysa.com) : Paysa helps you in finding new and interesting jobs according to your wish.
- [Instahyre](https://www.instahyre.com) : Your dream job is now here. Showcase
  yourself to a curated list of top companies. Complete privacy and no spacm.
- [The Muse](https://www.themuse.com) : Find everything you need to succeed from dream jobs to career advice. You can do a lot here on The Muse like exploring companies, browsing jobs, career advice,  discover careers,  career coaching. Try it.
- [Mentat](https://thementat.com) : Get your dream job 10x faster. Never apply
  for a job ever again, talk directly to decision makers and hiring managers.
- [IAESTE](http://iaesteunitedstates.org) : Find more and amazing international internships
  and jobs.
- [Who is Hiring](https://whoishiring.io) : An awesome resource for searching,
  filtering and finding new and attractive jobs according to your needs and
  interests.
- [Indeed](https://www.indeed.com) : Find internation jobs on Indeed and get a market salary for your dedication and devotion.
- [Glassdoor](https://www.glassdoor.co.in) : Find the job that's right for you. Search all the open positions on the web. Get your own personalized salary estimate. 
- [ZipRecruiter](https://www.ziprecruiter.com) : The Smartest Way to Get Hired.
- [Undercover Recruiter](https://theundercoverrecruiter.com) : Become Recruiter,
  Candidate or Employer. You can get your job easily here.

- [SimplyHired](https://www.simplyhired.com) : Simply Hired is a free job search engine (and mobile app) that takes the hassle out of getting hired and provides you with all the information you need to make a sound career move.
- [CareerBuilder](https://hiring.careerbuilder.com) : CareerBuilder is one of the largest job boards, providing job listings, resume posting, and career advice and resources to job seekers.
- [Dice](https://www.dice.com) : Dice is the leading site for tech job seekers. You can search by company, job title, keyword, employment type, and location.
 


### Special Thanks
- Please consider a github star if you find this useful and/or consider making a contribution.
- A special thanks to Ashish Padalkar (@ashish2199) for contributing a great amount of data and structure to the initial repository [Original Post](https://www.quora.com/How-to-Create-a-Blog-2/answer/Ashish-Padalkar?srid=OH96).
