/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef IQP_H
#define IQP_H

#include <ctime>
#include "constant.h"
#include "vec.h"
#include "urtree.h"
#include "treels.h"
#include "clusterarr.h"
#include "interface.h"

/**
	Important Quartet Puzzling Class
*/
class IQP {
public :
	int nSeq_;
	int nRep_;
	double probDel_;
	ClusterArr bestClusterArr_;


	/**
	we will init all things here before starting testing this method with data
	*/
	void init ();

	/**
		optimize parameters at final step
	*/
	double tuneFineParameter (int nIter, UrTree &bestTree);

	void optPam ();

	double escape (Vec<int> &orderNdNoLs, UrTree &tree, UrTree &bestTree, ClusterArr &bestClusterArr);

	double escapeLocalOpt (CommonParameters &params, InputParameters &in_pam, UrTree &bestTree, Vec<char> &conTree,  
		time_t &beginTime_);

	void        loadTreeLs (CommonParameters &params, const char *treeLsFileName, ClusterArr &bestClusterArr, ClusterArr &allCluArr,
	                        UrTree &bestTree, int &nImpTree, const char *predictionFileName, double &last_progTime);

	void        loadTreeFile (CommonParameters &params, const char *treeFileName, ClusterArr &bestClusterArr, ClusterArr &allCluArr,
	                        UrTree &bestTree, int &nImpTree, const char *predictionFileName, double &last_progTime);

}; //end of class;


#endif

