/***************************************************************************
 *                                                                         *
 *   constants.h (begin: Feb 20 2003)                                      *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/



#ifndef CONSTANT_H
#define CONSTANT_H
#ifdef HAVE_CONFIG_H
#  include <../config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string>

using namespace std;

/*
The Constants.h contains all constant values for whole project.
Every constant values MUST BE declared here.
 
...Being specified more
*/

/*IN ORDER TO REDUCE THE SOURCE CODES, SOME COMMOM ABBREVIATIONS ARE USED
alignment                      : ali
branch                         : br
list                           : ls
JukeCantor69Model              : JK69M
kimura80Model                  : K2P
equalInputModel                : F81M
hasegawa85Model                : HKY85M
felsenstein84Model             : F84M
tamuraNei93Model               : TM93M
generalReversibleModel         : GRM
internal                       : in
external                       : ex
array                          : arr
node                           : nd
likelihood                     : li;
optimize, optimal              : opt
unroot                         : ur
quartetTree                    : qtree
puzlle                         : puz
sequence                       : seq
utility                        : utl
transition                     : ts
transversion                   : tv
interation                     : it
pattern                        : ptn
dimension                      : dim
EPSILON                        : EPS
value                          : val
Substitution                   : sub
vector                         : vec
number                         : num
length                         : len
increase, increament           : inc
decrease, decreament           : dec
compute                        : cmp
parametter                     : pam
frequence                      : frq
active                         : act
small                          : s
middle                         : m
great                          : g
left                           : l
right                          : r
binary                         : bi
distance                       : dis
remain                         : rem
estimate                       : est
interation                     : it
negative                       : neg
child                          : chi
parrent                        : par
structure                      : str
current                        : cur
approximate                    : app
substitution                   : sub
instantaneous                  : ins
coefficient                    : cof
purine                         : purine (A, G)
pyrimidine                     : pyri (C, T)
average                        : ave
quartet                        : qua (q)
position                       : pos
descendant                     : des
pointer                        : poi
similar                        : sim
height                         : hei
small                          : sma
great                          : gre
company                        : com
 
*/

const int NUM_CAN_STATE = 62;

enum BASE  {BASE_A, BASE_C, BASE_T, BASE_G, BASE_AC, BASE_AG, BASE_AT, BASE_CG, BASE_CT, BASE_GT, BASE_CGT, BASE_AGT, BASE_ACT, BASE_ACG};

enum STATE {STATE_A, STATE_R, STATE_N, STATE_D, STATE_C, STATE_Q, STATE_E, STATE_G,
            STATE_H, STATE_I, STATE_L, STATE_K, STATE_M, STATE_F, STATE_P, STATE_S, STATE_T,
            STATE_W, STATE_Y, STATE_V};
const int BS_UNKNOWN = NUM_CAN_STATE - 1;

enum MODEL {HKY85, TN93, GTR, WAG, JTT, VT, MtREV24, Blosum62, Dayhoff, rtREV, AA_USER,
	Codon_GY94, Codon_YN98, Codon_Pedersen98, Codon_GTR, Codon_PosRate, 
	Codon_NY98, UNDEF_MODEL};

enum EX_IN {EX, IN};
enum OPT_STATUS {APPRO, COMPLETE};
enum NEWICK_TREE_STATUS {WRONG_BRACKET_ORDER, NEWICK_TREE_FORM, MISSING_OPEN_BRACKET, MISSING_CLOSE_BRACKET, MISSING_FIRST_OPEN_BRACKET, MISSING_LAST_CLOSE_BRACKET, MISSING_COLON};
enum DRAW_TREE_TYPE {NON_BR_LEN, BR_LEN};
enum BR_DIR {StG, GtS};

enum DATA_TYPE {NUCLEOTIDE, AMINO_ACID, CODON};
enum RATE_TYPE {UNIFORM, SITE_SPECIFIC, GAMMA};

enum PAM_TYPE {ESTIMATE, USER_DEFINED, EQUAL, REAL, SIMULATION, F1x4, F3x4, CODON_TABLE, UNDEF_PAM };
enum MODEL_PAM_TYPE {TS_TV, TS_AG, TS_CT, TV_AC, TV_AT, TV_CG, TV_GT, TS_TV_RATIO, PY_PU_RATIO, 
	V_PARM, NS_SY_RATIO, CPG_RATIO, POS3_RATIO, POS2_RATIO, NS_SY_RATIO_PROB};
enum STOPPING_TYPE {YES, YES_MIN_ITER, YES_MAX_ITER, NO};


const int SMALL_DATA_SET = 101;
//const int  MAX_ITERATION = 100000;
const int  START_PREDICTION = 4;

const char BAD_MEMORY_ACCESS[] = "Accessed out of array. Please check the input data or contact the authors!!!";


#ifdef HAVE_CONFIG_H
const char PRO_VERSION[] = VERSION;
#else
const char PRO_VERSION[] = "3.3.BETA1";
#endif

const char MEMORY_LOCATION[] = "Out of memory!!!";


const char BAD_ASSIGNMENT[] = "Can not perform matrix A = matrix B while their rows and columns are different";

const char BAD_CMP_LI[] = "Negative likelihood!";

const char NEWICK_TREE_ALIGNMENT_ERROR[] = "the newick tree form and the alignment is not adaptive";

const char OUT_GRP_ND_ERROR[] = "The out group node is improper...";

const int MAX_SEQ_NAME_LEN = 1000;

const int NUM_BASE = 4;
const int NUM_AMINO = 20;

/**
	maximum 61 Codon 
*/
const int NUM_CODON = 61;


//the number of ANSSI character set
const int NUM_CHAR = 256;

const int FILENAME_LEN = 1000;


//the last control charater
const int LAST_CONTROL_CHAR = 32;

//the maximum neighbor nodes of an internal nodes
const int MAX_NUM_NEI_ND = 3;

//the maximum number childrent of a internal node
const int MAX_NUM_CHI = 3;


/*if baseNo1 + baseNo2 = TRANSITION_SIGN, it means that baseNo1 and baseNo2 are
either purine or phyrimidine
*/

const int TS_SIGN = 3;

//the INCREMENT is for vector template
const int INC = 16;

//the maximum number of sequences
//const int MAX_NUM_SEQ = 20005;
//const int MAX_NUM_CLUSTER = MAX_NUM_SEQ * 400;
//const int MAX_NUM_SEQ = 200;
//const int MAX_NUM_CLUSTER = MAX_NUM_SEQ * 2;

const int MAX_NUM_REP       = 31;

//the max number of positive pattern
//const int MAX_NUM_PTN  = 100100;
//const int MAX_NUM_SITE = 100000;

//the max number of rate for heterogeneity
const int MAX_NUM_RATE = 32;

//the mean of substitution rate (muy)
const double MEAN_SUB_RATE = 1.0;

const int INFINITIVE = 1000000000;

//#define USE_LONG_DOUBLE

#ifdef USE_LONG_DOUBLE
typedef long double LDOUBLE;
#else
typedef double LDOUBLE;
#endif

const LDOUBLE MIN_EXP = 200;

//const LDOUBLE MIN_EXP_VAL = exp (-MIN_EXP);

//the is the maximum length of a line in the alignment file
//const int MAX_LINE_LEN = 100000;

//the maximum newich tree form length

const int MAX_NEWICK_TREE_LEN = 100000;

const double ZERO = 0.000000001;

//the limits of branch length
const double MAX_BR_LEN = 90.00; /* upper limit on branch length */
const double MIN_BR_LEN = 0.000001; /* lower limit on branch length */


/* error in branch length, using for optimizing the branch length be Brent method
for the pair sequences optimizing*/
const double EPS_OPT_PAIR_SEQ_BR	= 0.000001;

/* error in branch length, using for optimizing the branch length be Brent method
for the quartet optimizing*/
const double EPS_OPT_UR_TREE_BR	    = 0.000001;

const double EPS_GAMMA_SHAPE_ERROR =  0.001; /*using for optimizing parameters */
const double EPS_MODEL_PAM_ERROR      =  0.0001; /*using for optimizing parameters */
const double EPS_MODEL_FUNC_ERROR      = 0.000001; /*using for optimizing parameters */


/* maximum number of iterations of smoothing using
for maximizing all brances of the unrooted tree*/
const int MAX_IT_UR_BR = 100;

//the optimal urooted tree error, using for (*opt) function
const double BR_DIF_ERROR = 0.00001;

//using for optimizing parameters
const int MAX_IT_UR_BR_PAM_OPT = 5;

const double MIN_FRQ                = 0.0001;
const double MIN_FRQ_DIF            = 0.00002;

const double MIN_STATE_FRQ = 0.0001;  /* lower limit on base frequencies = 0.01% */

const double MIN_RATE = 0.00001; //all variable rates should be greater than MIN_RATE

//the limits of tsTvRatio, using for optimizing tsTvRatio
const double MAX_TS_TV_RATIO = 200.0;
const double MIN_TS_TV_RATIO = 0.2;

const double MAX_PY_PU_RATIO = 200.0;
const double MIN_PY_PU_RATIO = 0.2;

const double MIN_GEN_PAM = 0.0001;
const double MAX_GEN_PAM = 99.0;

const double MIN_V_PARM = 5.0;
const double MAX_V_PARM = 300.0;

const double MIN_NS_SY_RATIO = 0.0001;
const double MAX_NS_SY_RATIO = 50.0;

// max number of classes for Ns/Sy ratio
const int MAX_NUM_CLASS = 8;


//using for optimizing shape parameters of discrete gamma distribution
const double MIN_GAMMA_SHAPE = 0.01;
const double MAX_GAMMA_SHAPE = 100.0;
const double GAMMA_SHAPE_ERROR = 0.1;
const double EPS_LOGLI_SITE_SPECIFIC_RATE_OPT = 0.01;
const double MAX_IT_TREE_SITE_SPECIFIC_RATE_OPT = 10;
const int MAX_IT_SITE_SPECIFIC_RATE_OPT = 100;

const double MIN_PTN_RATE = 0.000001;
const double MAX_PTN_RATE = 100.0;
const double EPS_PTN_ERROR = 0.001;

const double MAX_NUM_IT_ONE_PAR = 10;

//using for drawing the tree
const int NUM_ABSTRACT_BR_LEN_CLASS = 3;

//using for drawing the tree
const int MIN_ABSTRACT_BR_LEN = 4;

enum SUFFIX_TYPE {SUF_MAIN, SUF_BIONJ, SUF_TREEFILE, SUF_TREELS, SUF_DIST, SUF_BOOTSAMPLE, SUF_BOOTTREE, SUF_CONTREE, SUF_SPLITS,
	SUF_CHECKPOINT, SUF_PREDICTION, SUF_SITELH, SUF_PATLH, SUF_SITERATE, SUF_NNI_LH, SUF_NNI_TREE};

// append the prefix and the required suffix to get the resulting string
void getOutFileName(SUFFIX_TYPE suf, string &str);

//#define PARALLEL
//#define TIME_MONITOR

#ifdef PARALLEL

extern int mpi_myrank; // rank of the current process
extern int mpi_size;   // total number of processes
extern int mpi_master_rank; // rank of the master process

extern long p_randn; // used for random number generator
extern long p_rand;  // used for random number generator

const int TAG_TREE = 10;

bool stopSignalCome();

#endif // PARALLEL

inline bool isMasterProc() {
#ifdef PARALLEL
	return mpi_myrank == mpi_master_rank;
#else
	return true;
#endif
}

inline bool isSlaveProc() {
#ifdef PARALLEL
	return mpi_myrank != mpi_master_rank;
#else
	return false;
#endif
}


void Finalize(int exit_code);

inline bool isCodonModel(MODEL model) {
	return (model == Codon_GY94) || (model == Codon_YN98) || (model == Codon_Pedersen98)
		|| (model == Codon_GTR) || (model == Codon_PosRate) || model == (Codon_NY98);
}

#endif

