/***************************************************************************
 *   Copyright (C) 2004 by Johan Maes - ON4QZ                              *
 *   on4qz@telenet.be                                                      *
 *   https://www.qsl.net/o/on4qz                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "filterparam.h"

// blIIR  Chebyshev , Bandpass
// localSamplingrate = 12000.000000
// order = 5
// Gain = 2036425.679557
// corner 1 frequency = 1050.000000
// corner 2 frequency = 1350.000000
//Ripple = -0.500000
//
// Coefficients - Zeroes:

const double   z_sync_bp1200[SYNCBPNUMZEROES+1]=
{
   -1,
   0,
   5,
   0,
   -10,
   0,
   10,
   0,
   -5,
   0,
   1
};

// Coefficients - Poles:
const double p_sync_bp1200[SYNCBPNUMPOLES]=
{
   -0.831817910877518,
   6.85329606025959,
   -26.8908359757093,
   65.6092480501218,
   -109.804607920169,
   131.449412799425,
   -113.926185682315,
   70.6269190815051,
   -30.0337194770908,
   7.94140204949823
};


// blIIR  Chebyshev , Bandpass
// localSamplingrate = 12000.000000
// order = 5
// Gain = 15076908.367168
// corner 1 frequency = 1800.000000
// corner 2 frequency = 2000.000000
//Ripple = -0.500000
//
// Coefficients - Zeroes:
const double   z_sync_bp1900[SYNCBPNUMZEROES+1]=
{
   -1,
   0,
   5,
   0,
   -10,
   0,
   10,
   0,
   -5,
   0,
   1
};

// Coefficients - Poles:
const double p_sync_bp1900[SYNCBPNUMPOLES]=
{
   -0.884464188125815,
   4.87624242095327,
   -15.2761784976064,
   31.8153803961565,
   -48.8249394648661,
   56.3978258278011,
   -50.0386421945956,
   33.4168689665783,
   -16.4440455988144,
   5.3795643525748
};


// lowpass filter behind bandpass filtered 1200/1900 rectified signal

// blFIR  Raised cosine
// localSamplingrate = 12000.000000
// number of taps = 51
// corner frequency = 60.000000
// beta = 0.500000
// window applied

//Coefficients:
const double z_sync_lp[SYNCLPTAPS]=
{
   0.0709758137267032,
   0.0749055576922912,
   0.0853770124142637,
   0.102401580582652,
   0.125870220418465,
   0.15555364366766,
   0.191104840125237,
   0.232063905872449,
   0.277865105220761,
   0.32784605019439,
   0.381258837238035,
   0.437282939660174,
   0.495039617009869,
   0.553607569953433,
   0.612039541987672,
   0.669379548107438,
   0.724680395819437,
   0.777021156006875,
   0.825524240300093,
   0.869371747846272,
   0.907820757593518,
   0.940217262158108,
   0.966008465629866,
   0.984753199754177,
   0.996130250148994,
   0.999944425798935,
   0.996130250148994,
   0.984753199754177,
   0.966008465629866,
   0.940217262158108,
   0.907820757593518,
   0.869371747846272,
   0.825524240300093,
   0.777021156006875,
   0.724680395819437,
   0.669379548107438,
   0.612039541987672,
   0.553607569953433,
   0.495039617009869,
   0.437282939660174,
   0.381258837238035,
   0.32784605019439,
   0.277865105220761,
   0.232063905872449,
   0.191104840125237,
   0.15555364366766,
   0.125870220418465,
   0.102401580582652,
   0.0853770124142637,
   0.0749055576922912,
   0.0709758137267032
};




 // blFIR  Raised cosine
 // localSamplingrate = 12000.000000
 // number of taps = 181
 // corner frequency = 600.000000
 // beta = 0.750000
 // window applied
 // demodulator frequency = 1900.000000
 //Coefficients:
  const double videoFilterCoefFIR[VIDEOFIRNUMTAPS]=
 {
    -5.95079099057804e-10,
    2.61594114263829e-06,
    3.07729445250339e-06,
    1.13346812319689e-06,
    -2.81039541066542e-06,
    -7.71403862925782e-06,
    -1.20902779206499e-05,
    -1.43480585720805e-05,
    -1.32321049757815e-05,
    -8.25642905210925e-06,
    -8.8690505641396e-10,
    9.85490870415174e-06,
    1.88370834684704e-05,
    2.43089145306048e-05,
    2.43023278940623e-05,
    1.83229993522338e-05,
    7.85321630695235e-06,
    -3.68955136329723e-06,
    -1.16535011354391e-05,
    -1.14292066221272e-05,
    -8.56425709155406e-10,
    2.26937879393592e-05,
    5.31013029640608e-05,
    8.44693399972315e-05,
    0.000108437566877532,
    0.000117516745719292,
    0.000107804015822502,
    8.10619160782521e-05,
    4.53200756323171e-05,
    1.34836012044786e-05,
    4.67663404802913e-10,
    1.63077977096724e-05,
    6.63373159783328e-05,
    0.000143602388130073,
    0.000231167770515414,
    0.000305100922643006,
    0.000340960709772466,
    0.000321776690478599,
    0.00024516504372674,
    0.000127040816986674,
    3.07474299002907e-09,
    -9.41572318815693e-05,
    -0.000116551026159502,
    -4.48417913051135e-05,
    0.000115715984449913,
    0.000328008733459506,
    0.000528359700943291,
    0.000641639760490251,
    0.000603309341113929,
    0.000382667745394857,
    5.07420985957315e-09,
    -0.000469217752322882,
    -0.000907327495708766,
    -0.00118411058956563,
    -0.00119735462753749,
    -0.000913688724887437,
    -0.000396724829308208,
    0.000189401487028102,
    0.000607970575897167,
    0.000607729096403849,
    4.04354956239952e-09,
    -0.00126468871755123,
    -0.0030447073080987,
    -0.0050026587472757,
    -0.00666218441709886,
    -0.00752559482438273,
    -0.00723379086110548,
    -0.00573280278322614,
    -0.00339989003366721,
    -0.00108070804009379,
    -4.47539616976694e-10,
    -0.00153133221611757,
    -0.00684316096120548,
    -0.0164729300340849,
    -0.0299100809708232,
    -0.0452851334961788,
    -0.0592593190702364,
    -0.0671852210265427,
    -0.0635655234097977,
    -0.0427809457400524,
    -5.79017893606645e-09,
    0.0678656067027252,
    0.161324303280179,
    0.277750017046145,
    0.411240997967613,
    0.552962972340781,
    0.691968966816512,
    0.816404845411836,
    0.914937426323293,
    0.978195191561545,
    0.999999991829453,
    0.978195191561545,
    0.914937426323293,
    0.816404845411835,
    0.691968966816512,
    0.552962972340781,
    0.411240997967613,
    0.277750017046145,
    0.161324303280179,
    0.0678656067027251,
    -5.7901789909994e-09,
    -0.0427809457400526,
    -0.0635655234097978,
    -0.0671852210265427,
    -0.0592593190702365,
    -0.0452851334961789,
    -0.0299100809708232,
    -0.0164729300340851,
    -0.0068431609612055,
    -0.00153133221611756,
    -4.47539662828152e-10,
    -0.00108070804009387,
    -0.00339989003366724,
    -0.00573280278322617,
    -0.0072337908611055,
    -0.00752559482438273,
    -0.00666218441709888,
    -0.00500265874727575,
    -0.00304470730809871,
    -0.00126468871755125,
    4.04354947839136e-09,
    0.000607729096403787,
    0.000607970575897167,
    0.000189401487028064,
    -0.000396724829308279,
    -0.000913688724887445,
    -0.00119735462753749,
    -0.00118411058956567,
    -0.000907327495708759,
    -0.000469217752322886,
    5.07420985335003e-09,
    0.000382667745394851,
    0.000603309341113924,
    0.000641639760490234,
    0.000528359700943286,
    0.000328008733459503,
    0.000115715984449906,
    -4.48417913051266e-05,
    -0.000116551026159501,
    -9.41572318815944e-05,
    3.07474298592771e-09,
    0.000127040816986674,
    0.000245165043726731,
    0.000321776690478589,
    0.000340960709772462,
    0.000305100922643003,
    0.000231167770515413,
    0.000143602388130061,
    6.63373159783267e-05,
    1.63077977096627e-05,
    4.6766337918414e-10,
    1.34836012044776e-05,
    4.53200756322965e-05,
    8.10619160782543e-05,
    0.000107804015822502,
    0.000117516745719295,
    0.000108437566877516,
    8.44693399972232e-05,
    5.31013029640469e-05,
    2.26937879393536e-05,
    -8.56425709045839e-10,
    -1.14292066221334e-05,
    -1.16535011354395e-05,
    -3.68955136329843e-06,
    7.85321630695073e-06,
    1.83229993522318e-05,
    2.43023278940613e-05,
    2.43089145306041e-05,
    1.88370834684694e-05,
    9.85490870414851e-06,
    -8.86905056186294e-10,
    -8.25642905211096e-06,
    -1.32321049757817e-05,
    -1.43480585720802e-05,
    -1.20902779206511e-05,
    -7.71403862925922e-06,
    -2.81039541066544e-06,
    1.13346812319585e-06,
    3.07729445250303e-06,
    2.61594114263834e-06,
    -5.95079099262779e-10
 };




  //==========================================================
  // rFIR
  // localSamplingrate = 48000.000000
  // number of taps = 121
  // Band0 Lower=0.000000, Upper=2700.000000, Desired=1.000000, Weight=1.000000
  // Band1 Lower=3500.000000, Upper=23999.000000, Desired=0.000000, Weight=1.000000
  //Coefficients:
   const  FILTERPARAMTYPE wfFilterCoef[TXWFNUMTAPS]=
  {
     0.00116433,
     -0.00494437,
     -0.00227196,
     -0.00162745,
     -0.00119222,
     -0.000602408,
     0.000154827,
     0.000987978,
     0.00175857,
     0.00231978,
     0.00254186,
     0.00234367,
     0.0017027,
     0.000677718,
     -0.000595763,
     -0.00192037,
     -0.00307107,
     -0.0038171,
     -0.00398386,
     -0.00346983,
     -0.00228737,
     -0.000567514,
     0.00145033,
     0.00344646,
     0.00506842,
     0.00599002,
     0.00597109,
     0.00490811,
     0.00286844,
     9.73674e-05,
     -0.00300691,
     -0.00594212,
     -0.00817976,
     -0.00925143,
     -0.00883636,
     -0.00682964,
     -0.00339026,
     0.00106452,
     0.00589068,
     0.0103035,
     0.0134903,
     0.0147392,
     0.0135693,
     0.00983817,
     0.00380649,
     -0.00385039,
     -0.0120879,
     -0.0196086,
     -0.0250088,
     -0.0269742,
     -0.0244494,
     -0.0168371,
     -0.004072,
     0.0132752,
     0.034055,
     0.0566447,
     0.0790638,
     0.0992571,
     0.115295,
     0.12561,
     0.129165,
     0.12561,
     0.115295,
     0.0992571,
     0.0790638,
     0.0566447,
     0.034055,
     0.0132752,
     -0.004072,
     -0.0168371,
     -0.0244494,
     -0.0269742,
     -0.0250088,
     -0.0196086,
     -0.0120879,
     -0.00385039,
     0.00380649,
     0.00983817,
     0.0135693,
     0.0147392,
     0.0134903,
     0.0103035,
     0.00589068,
     0.00106452,
     -0.00339026,
     -0.00682964,
     -0.00883636,
     -0.00925143,
     -0.00817976,
     -0.00594212,
     -0.00300691,
     9.73674e-05,
     0.00286844,
     0.00490811,
     0.00597109,
     0.00599002,
     0.00506842,
     0.00344646,
     0.00145033,
     -0.000567514,
     -0.00228737,
     -0.00346983,
     -0.00398386,
     -0.0038171,
     -0.00307107,
     -0.00192037,
     -0.000595763,
     0.000677718,
     0.0017027,
     0.00234367,
     0.00254186,
     0.00231978,
     0.00175857,
     0.000987978,
     0.000154827,
     -0.000602408,
     -0.00119222,
     -0.00162745,
     -0.00227196,
     -0.00494437,
     0.00116433
  };


   // blFIR  Hilbert
   // localSamplingrate = 12000.000000
   // number of taps = 153
   // corner frequency = 1000.000000
   // beta = 0.500000
   // window applied
   //Coefficients:
    const FILTERPARAMTYPE drmHilbertCoef[DRMHILBERTTAPS]=
   {
      0,
      0.00107190601522455,
      0,
      0.00114428127836931,
      0,
      0.00126465142463967,
      0,
      0.00143657040680006,
      0,
      0.00166370297755838,
      0,
      0.00194984843584138,
      0,
      0.00229897112682306,
      0,
      0.00271523918124115,
      0,
      0.00320307336657778,
      0,
      0.00376720843252962,
      0,
      0.00441277001061758,
      0,
      0.00514537103613413,
      0,
      0.00597123289056438,
      0,
      0.00689733814551449,
      0,
      0.00793162411788592,
      0,
      0.00908322970767581,
      0,
      0.0103628126183723,
      0,
      0.0117829607223439,
      0,
      0.0133587310729627,
      0,
      0.015108364544715,
      0,
      0.0170542460109686,
      0,
      0.0192242138609088,
      0,
      0.0216533762307932,
      0,
      0.0243866781537711,
      0,
      0.027482608550733,
      0,
      0.0310186849032487,
      0,
      0.035099797177604,
      0,
      0.0398713166388587,
      0,
      0.0455404799655691,
      0,
      0.0524128630218771,
      0,
      0.0609580273296193,
      0,
      0.0719357553084729,
      0,
      0.0866599865154828,
      0,
      0.10761465561151,
      0,
      0.140125234561542,
      0,
      0.198041949770117,
      0,
      0.332155822226347,
      0,
      0.999607048858159,
      0,
      -0.999607048858159,
      0,
      -0.332155822226347,
      0,
      -0.198041949770117,
      0,
      -0.140125234561542,
      0,
      -0.10761465561151,
      0,
      -0.0866599865154828,
      0,
      -0.0719357553084729,
      0,
      -0.0609580273296193,
      0,
      -0.0524128630218771,
      0,
      -0.0455404799655691,
      0,
      -0.0398713166388587,
      0,
      -0.035099797177604,
      0,
      -0.0310186849032487,
      0,
      -0.027482608550733,
      0,
      -0.0243866781537711,
      0,
      -0.0216533762307932,
      0,
      -0.0192242138609088,
      0,
      -0.0170542460109686,
      0,
      -0.015108364544715,
      0,
      -0.0133587310729627,
      0,
      -0.0117829607223439,
      0,
      -0.0103628126183723,
      0,
      -0.00908322970767581,
      0,
      -0.00793162411788592,
      0,
      -0.00689733814551449,
      0,
      -0.00597123289056438,
      0,
      -0.00514537103613413,
      0,
      -0.00441277001061758,
      0,
      -0.00376720843252962,
      0,
      -0.00320307336657778,
      0,
      -0.00271523918124115,
      0,
      -0.00229897112682306,
      0,
      -0.00194984843584138,
      0,
      -0.00166370297755838,
      0,
      -0.00143657040680006,
      0,
      -0.00126465142463967,
      0,
      -0.00114428127836931,
      0,
      -0.00107190601522455,
      0
   };



DSPFLOAT calculateGain(const DSPFLOAT *fp,unsigned int len)
{
	unsigned int i;
	DSPFLOAT fs=0.;
	for(i=0;i<len;i++)
		{
			fs+=fp[i];
		}
	return fs;
}

//sfilters filterStruct[NUMRXFILTERS]=
//{
////	{"800 Hz",narrowRX,1900},
////	{"1000 Hz",wideRX,1900},
//   {"600Hz Video",wide600Hz,1700},
////   {"600Hz Video",wide600Hz,1700},

//};

