# cache2k version 0.21 release notes

## Possible breakages

  * none

## New and Noteworthy

  * Rewrote internal locking schema. When an entry is fetched from the CacheSource it is not done within
    synchronized block any more. Instead the entry in locked and unlocked again when the entry operation is finished.
    The previous approach was bad, since the state of an entry could not be changed when a longer operation is in 
    progress. 

## Fixes and Improvements

  * Exceptions: Add the expiry time to the string of the propagated exception. This way an exception gets an almost unique 
    identifier and it becomes obvious when cached exceptions become rethrown multiple times or whether it is a new one.
  * Exceptions: Optionally write caught exceptions from source to the debug log (Tunable.logSourceExceptions)
  * Fix possible inconsistency between lastModification and value in CacheEntry
  * Together with the new locking schema, a lot of bugs in the storage layer were fixed. Storage/persistence is
    more stable yet, but still not declared ready for production use.

## API Changes and new methods

  * Cache.close() and CacheManager.close(), deprecated: Cache.destroy() and CacheManager.destroy()
  * Cache.getEntry()
  * Cache.contains()
