/**
 *  beep plugin for the Video Disk Recorder 
 *
 *  status.h  -  status monitor class
 *
 *  (c) 2004 - 2007 Andreas Brachold <vdr07 AT deltab de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */

#ifndef _NOTIFYBEEP_STATUS_H_
#define _NOTIFYBEEP_STATUS_H_

#include <vdr/status.h>


class cStatusNotifyBeep : public cStatus
{
private:
  void beep(unsigned int nFreq, unsigned int nDuration) const;  
protected:
  virtual void ChannelSwitch(const cDevice *Device, int ChannelNumber);
  virtual void Recording(const cDevice *Device, const char *Name, const char *FileName, bool On);
  virtual void Replaying(const cControl *Control, const char *Name, const char *FileName, bool On);
  virtual void SetVolume(int Volume, bool Absolute);
  virtual void OsdClear();
  virtual void OsdTitle(const char *Title);
  virtual void OsdStatusMessage(const char *Message);
  virtual void OsdHelpKeys(const char *Red, const char *Green, const char *Yellow, const char *Blue);
  virtual void OsdItem(const char *Text, int Index);
  virtual void OsdCurrentItem(const char *Text);
  virtual void OsdTextItem(const char *Text, bool Scroll);
  virtual void OsdChannel(const char *Text);
  virtual void OsdProgramme(time_t PresentTime, const char *PresentTitle, const char *PresentSubtitle, time_t FollowingTime, const char *FollowingTitle, const char *FollowingSubtitle);

public:
  cStatusNotifyBeep();
  virtual ~cStatusNotifyBeep();

  void notify() const;
};

#endif
