/**
 *  beep plugin for the Video Disk Recorder 
 *
 *  setup.c  -  Setup
 *
 *  (c) 2004 - 2008 Andreas Brachold <vdr07 AT deltab de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */

#include <string.h>
#include <stdlib.h>
#include "setup.h"


cNotifyBeepSetup NotifyBeepSetup;

// Some Limits
const int cNotifyBeepSetup::freq_min = 1;
const int cNotifyBeepSetup::freq_max = 10000;
const int cNotifyBeepSetup::duration_min = 1;
const int cNotifyBeepSetup::duration_max = 10000;


cNotifyBeepSetup::cNotifyBeepSetup(void) {
  active = true;
  freq = 444;
  duration = 333;
  strncpy(NotifyBeepSetup.console,"/dev/console",sizeof(NotifyBeepSetup.console));
  onshutdown = 1;
  oneditprocess = 1;
  onanymessage = 0;
}

cNotifyBeepSetup::~cNotifyBeepSetup(void)
{
}
