// Copyright 2019 Drone.IO Inc. All rights reserved.
// Use of this source code is governed by the Drone Non-Commercial License
// that can be found in the LICENSE file.

// +build !oss

package logs

import "testing"

func TestKey(t *testing.T) {
	tests := []struct {
		bucket string
		prefix string
		result string
	}{
		{
			bucket: "test-bucket",
			prefix: "drone/logs",
			result: "/drone/logs/1",
		},
		{
			bucket: "test-bucket",
			prefix: "/drone/logs",
			result: "/drone/logs/1",
		},
	}
	for _, test := range tests {
		s := &s3store{
			bucket: test.bucket,
			prefix: test.prefix,
		}
		if got, want := s.key(1), test.result; got != want {
			t.Errorf("Want key %s, got %s", want, got)
		}
	}
}
