// Copyright 2019 Drone.IO Inc. All rights reserved.
// Use of this source code is governed by the Drone Non-Commercial License
// that can be found in the LICENSE file.

// +build !oss

package core

import (
	"testing"
)

func TestValidateUser(t *testing.T) {
	tests := []struct {
		user *User
		err  error
	}{
		{
			user: &User{Login: ""},
			err:  errUsernameLen,
		},
		{
			user: &User{Login: "©"}, // non ascii character
			err:  errUsernameChar,
		},
		{
			user: &User{Login: "소주"}, // non ascii character
			err:  errUsernameChar,
		},
		{
			user: &User{Login: "foo/bar"},
			err:  errUsernameChar,
		},
		{
			user: &User{Login: "this-is-a-really-really-really-really-long-username"},
			err:  errUsernameLen,
		},
		{
			user: &User{Login: "octocat"},
			err:  nil,
		},
		{
			user: &User{Login: "octocat.with.dot"},
			err:  nil,
		},
		{
			user: &User{Login: "OctO-Cat_01"},
			err:  nil,
		},
	}
	for i, test := range tests {
		got := test.user.Validate()
		if got == nil && test.err == nil {
			continue
		}
		if got == nil && test.err != nil {
			t.Errorf("Expected error: %q at index %d", test.err, i)
			continue
		}
		if got != nil && test.err == nil {
			t.Errorf("Unexpected error: %q at index %d", got, i)
			continue
		}
		if got, want := got.Error(), test.err.Error(); got != want {
			t.Errorf("Want error %q, got %q at index %d", want, got, i)
		}
	}
}
