/*
 * Decompiled with CFR 0.152.
 */
package charm.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;

public class Toolbar
extends Panel
implements MouseListener,
MouseMotionListener {
    private int curTool;
    private int nTools;
    private int tw;
    private int th;
    private Image tools;
    private Label status;
    private String[] toolDesc;
    private String savedStatus = "";

    public Toolbar(URL imageURL, int tw_, int th_, int nTools_, Label status_, String[] toolDesc_) {
        this.tw = tw_;
        this.th = th_;
        this.nTools = nTools_;
        this.curTool = 0;
        this.tools = null;
        try {
            this.tools = Toolkit.getDefaultToolkit().getImage(imageURL);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.tools, 0);
            tracker.waitForID(0);
        }
        catch (Exception E) {
            System.out.println("Error loading toolbar image " + imageURL);
            E.printStackTrace();
        }
        this.status = status_;
        this.toolDesc = toolDesc_;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.tw, this.th * this.nTools);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.tw, this.th * this.nTools);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.tw, 30000);
    }

    public void setTool(int t) {
        if (t != this.curTool) {
            this.curTool = t;
            this.repaint(20L);
        }
    }

    public int getTool() {
        return this.curTool;
    }

    private int toTool(MouseEvent evt) {
        int t = evt.getY() / this.th;
        if (t >= this.nTools) {
            return -1;
        }
        return t;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        if (this.toolDesc == null || this.toTool(evt) == -1) {
            this.status.setText("");
        } else {
            this.status.setText(this.toolDesc[this.toTool(evt)]);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.toTool(evt) != -1) {
            this.setTool(this.toTool(evt));
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.savedStatus = this.status.getText();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.status.setText(this.savedStatus);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        int w = dim.width;
        int h = dim.height;
        for (int t = 0; t < this.nTools; ++t) {
            int srcX = 0;
            int srcY = t * this.th;
            int destX = 0;
            int destY = t * this.th;
            if (t == this.curTool) {
                srcX += this.tw;
            }
            g.drawImage(this.tools, destX, destY, destX + this.tw, destY + this.th, srcX, srcY, srcX + this.tw, srcY + this.th, null);
        }
        g.setColor(Color.lightGray);
        g.fillRect(0, this.nTools * this.th, w, h);
    }
}

