/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.Consumer;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import java.util.Vector;

public class PConsumer
extends Consumer {
    private PList finalList;
    private String lastComment;
    private PList dest = null;
    private Vector destStack = new Vector();

    public PList getList() {
        return this.finalList;
    }

    private void applyComment(PAbstract p) {
        if (this.lastComment != null) {
            p.setName(this.lastComment);
            this.lastComment = null;
        }
    }

    private void destPush() {
        if (this.dest != null) {
            this.destStack.addElement(this.dest);
        }
        this.dest = new PList();
        this.applyComment(this.dest);
    }

    private void destPop() {
        PList oldDest = this.dest;
        int top = this.destStack.size() - 1;
        if (top >= 0) {
            this.dest = (PList)this.destStack.elementAt(top);
            this.destStack.removeElementAt(top);
            if (oldDest != null) {
                this.dest.add(oldDest);
            }
        } else {
            this.finalList = this.dest;
            this.dest = null;
        }
    }

    private void add(PAbstract obj) {
        this.applyComment(obj);
        if (this.dest != null) {
            this.dest.add(obj);
        }
    }

    @Override
    public void listComment(String cmt) {
        this.lastComment = cmt;
    }

    @Override
    public void listSync(int syncCode) {
        switch (syncCode) {
            case 1898971136: {
                this.destPush();
                break;
            }
            case 1915748352: {
                this.destPop();
                break;
            }
            case 0x71100000: {
                this.destPush();
                this.destPush();
                this.dest = null;
                break;
            }
            case 1913651200: {
                this.destPop();
                this.destPop();
                break;
            }
            case 1897922560: {
                this.destPush();
                this.destPush();
                break;
            }
            case 0x72200000: {
                this.destPop();
                this.destPop();
                break;
            }
            case 0x79000000: {
                PList oldDest = this.dest;
                this.dest = new PList();
                this.dest.setName(oldDest.getName());
                break;
            }
            case 1880227840: {
                break;
            }
            case 0x70110000: {
                this.destPop();
                this.listComment("[" + this.dest.size() + "]");
                this.destPush();
                break;
            }
        }
    }

    @Override
    public void listByte(byte[] data) {
        this.add(new PString(data));
    }

    @Override
    public void listInt(int[] data) {
        this.add(new PNative(data));
    }

    @Override
    public void listFloat(float[] data) {
        this.add(new PNative(data));
    }

    @Override
    public void listLong(long[] data) {
        this.add(new PNative(data));
    }

    @Override
    public void listDouble(double[] data) {
        this.add(new PNative(data));
    }
}

