/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.ParDebug;
import charm.debug.PasswordDialog;
import charm.debug.event.NotifyEvent;
import charm.debug.preference.Execution;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.ClosedByInterruptException;
import javax.swing.SwingUtilities;

public abstract class ServThread
extends Thread {
    String hostName = null;
    String portno = null;
    ParDebug mainThread = null;
    volatile int flag;
    static final int maxChunk = 51200;
    public FileWriter debugOutput;
    public static String infoStr;
    boolean terminating;

    public ServThread(ParDebug d) {
        this.mainThread = d;
        this.flag = 0;
        this.terminating = false;
    }

    abstract String getNextOutput(StringBuffer var1) throws Exception;

    public void terminate() {
        this.terminating = true;
    }

    @Override
    public void run() {
        try {
            System.out.println("ServThread started");
            try {
                String outline;
                do {
                    StringBuffer outlinechunk = new StringBuffer();
                    outline = this.getNextOutput(outlinechunk);
                    this.process(outlinechunk);
                } while (outline != null);
                System.out.println("ServThread terminated");
                this.flag = 2;
            }
            catch (Exception e) {
                System.out.println("Failed to print");
                e.printStackTrace();
            }
            if (this.isInterrupted()) {
                System.out.println("Disconnecting from parallel program");
            } else {
                System.out.println("Finished running parallel program");
            }
            Runnable doWorkRunnable = new Runnable(){

                @Override
                public void run() {
                    ServThread.this.mainThread.quitProgram();
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error in ServThread. Exception caught");
        }
    }

    void process(StringBuffer outlinechunk) {
        int cpdStart;
        while ((cpdStart = outlinechunk.indexOf("CPD: ")) != -1) {
            int cpdEnd = outlinechunk.indexOf("\n", cpdStart + 1);
            String outline = outlinechunk.substring(cpdStart + 5, cpdEnd);
            outlinechunk.delete(cpdStart, cpdEnd + 1);
            int pe = Integer.parseInt(outline.substring(0, outline.indexOf(32)));
            outline = outline.substring(outline.indexOf(32) + 1);
            this.mainThread.setStatusMessage(outline);
            int type = 0;
            int begin = 0;
            if (outline.indexOf("BP", 0) != -1) {
                type = 1;
                begin = 3;
            } else if (outline.indexOf("Freeze") != -1) {
                type = 4;
                begin = 7;
            } else if (outline.indexOf("Abort") != -1) {
                type = 2;
                begin = 6;
            } else if (outline.indexOf("Signal") != -1) {
                type = 3;
                begin = 7;
            } else if (outline.indexOf("Cross") != -1) {
                type = 5;
                begin = 6;
            } else {
                System.out.println("ServThread: error while processing string '" + outline + "'");
            }
            Notify doWorkRunnable = new Notify(new NotifyEvent(type, pe, outline.substring(begin)));
            SwingUtilities.invokeLater(doWorkRunnable);
        }
        if (outlinechunk.length() > 0) {
            System.out.println("Parallel program printed: " + outlinechunk.toString());
            this.mainThread.displayProgramOutput(outlinechunk.toString());
        }
    }

    public int getFlag() {
        return this.flag;
    }

    public class Notify
    implements Runnable {
        private NotifyEvent e;

        public Notify(NotifyEvent e_) {
            this.e = e_;
        }

        @Override
        public void run() {
            ServThread.this.mainThread.notify(this.e);
        }
    }

    public static class File
    extends ServThread {
        BufferedReader prout;

        public File(ParDebug d, java.io.File f, boolean wait) {
            super(d);
            while (wait) {
                try {
                    this.prout = new BufferedReader(new FileReader(f));
                    System.out.println(this.prout);
                    wait = false;
                }
                catch (FileNotFoundException e) {
                    if (wait) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e1) {}
                        continue;
                    }
                    System.out.println("Could not open file \"" + f + "\"");
                }
            }
        }

        @Override
        String getNextOutput(StringBuffer outlinechunk) throws Exception {
            String outline;
            boolean foundPort = false;
            do {
                if ((outline = this.prout.readLine()) == null) continue;
                if (!foundPort) {
                    if (outline.indexOf("ccs: Server IP =", 0) != -1) {
                        int nameStart = outline.indexOf("Server IP = ", 0);
                        int nameEnd = outline.indexOf(",", nameStart += 12);
                        this.hostName = outline.substring(nameStart, nameEnd);
                        int portStart = outline.indexOf("Server port = ", 0);
                        int portEnd = outline.indexOf("$", 0);
                        this.portno = outline.substring(portStart += 14, portEnd - 1);
                        foundPort = true;
                        this.flag = 1;
                    }
                    if (outline.indexOf("Password:", 0) != -1) {
                        System.out.println("Password requested");
                        char[] passwd = null;
                        new PasswordDialog(passwd);
                        System.out.println(passwd);
                    }
                }
                outlinechunk.append(outline + "\n");
            } while (!this.terminating && (this.prout.ready() && outlinechunk.length() < 51200 || outlinechunk.length() == 0));
            return outline;
        }
    }

    public static class CCS
    extends ServThread {
        CcsServer server;

        public CCS(ParDebug d, Execution e) {
            super(d);
            String[] args = new String[2];
            args[0] = e.hostname;
            if (e.ccshost != null && e.ccshost.length() > 0) {
                args[0] = e.ccshost;
            }
            args[1] = e.port;
            this.server = CcsServer.create(args, false);
            System.out.println("Created CCSserver");
            try {
                this.server.sendRequest("redirect stdio", 0);
            }
            catch (IOException e1) {
                System.out.println("redirect stdio request failed");
            }
        }

        @Override
        String getNextOutput(StringBuffer outlinechunk) {
            try {
                CcsServer.Request r = this.server.sendRequest("fetch stdio", 0);
                byte[] resp = this.server.recvResponse(r);
                System.out.println("reply fetch stdio: " + new String(resp));
                if (resp != null) {
                    outlinechunk.append(new String(resp));
                    return new String(resp);
                }
                return null;
            }
            catch (ClosedByInterruptException ce) {
                System.out.println("Socket closed by interrupt");
                return null;
            }
            catch (IOException e) {
                System.out.println("Exception while fetching stdio");
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class Charmrun
    extends ServThread {
        Process p = null;
        BufferedReader prout;
        BufferedReader prerr;

        public Charmrun(ParDebug d, Process par) {
            super(d);
            this.p = par;
            this.prout = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            this.prerr = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
        }

        @Override
        String getNextOutput(StringBuffer outlinechunk) throws Exception {
            String outline;
            boolean foundPort = false;
            while ((outline = this.prout.readLine()) != null) {
                if (!foundPort) {
                    if (outline.indexOf("ccs: Server IP =", 0) != -1) {
                        int nameStart = outline.indexOf("Server IP = ", 0);
                        int nameEnd = outline.indexOf(",", nameStart += 12);
                        this.hostName = outline.substring(nameStart, nameEnd);
                        int portStart = outline.indexOf("Server port = ", 0);
                        int portEnd = outline.indexOf("$", 0);
                        this.portno = outline.substring(portStart += 14, portEnd - 1);
                        foundPort = true;
                        this.flag = 1;
                    }
                    if (outline.indexOf("Password:", 0) != -1) {
                        System.out.println("Password requested");
                        char[] passwd = null;
                        new PasswordDialog(passwd);
                        System.out.println(passwd);
                    }
                }
                while (this.prerr.ready()) {
                    outline = outline + "\n" + this.prerr.readLine();
                }
                outlinechunk.append(outline + "\n");
                if (this.prout.ready() && outlinechunk.length() < 51200) continue;
            }
            return outline;
        }
    }
}

