<a name="v0.2.0"></a>
# [v0.2.0](https://github.com/rhysd/path-slash/releases/tag/v0.2.0) - 05 Jul 2022

- **BREAKING:** `to_slash` and `to_slash_lossy` return `Cow<'_, str>` instead of `String`. Now heap allocation hapnens only when path separator is replaced. On Unix-like OS, almost all heap allocations can be removed by this change. Migrating from 0.1 to 0.2 is easy by adding `Cow::into_owned` call. (#9)
  ```rust
  use path_slash::PathExt as _;

  // 0.1
  let s: Option<String> = Path::new("/a/b").to_slash();
  let s: String = Path::new("/a/b").to_slash_lossy();
  // 0.2
  let s: Option<String> = Path::new("/a/b").to_slash().map(Cow::into_owned);
  let s: String = Path::new("/a/b").to_slash_lossy().into_owned();
  ```
  API changes are as follows:
  - 0.1.5
    - `Path::to_slash(&self) -> Option<String>`
    - `Path::to_slash_lossy(&self) -> String`
  - 0.2.0
    - `Path::to_slash(&self) -> Option<Cow<'_, Path>>`
    - `Path::to_slash_lossy(&self) -> Cow<'_, Path>`
- **BREAKING:** Fix inconsistency on Windows and on Unix-like OS in terms of trailing slash in path. Now a trailing slash in path is always preserved. (#10)
  ```rust
  // 0.1
  #[cfg(target_os = "windows")]
  assert_eq!(Path::new(r"\a\b\").to_slash_lossy(), "/a/b"); // Trailing slash is removed
  #[cfg(not(target_os = "windows"))]
  assert_eq!(Path::new(r"\a\b\").to_slash_lossy(), "/a/b/"); // Trailing slash is preserved

  // 0.2
  #[cfg(target_os = "windows")]
  assert_eq!(Path::new(r"\a\b\").to_slash_lossy(), "/a/b/"); // Trailing slash is preserved
  #[cfg(not(target_os = "windows"))]
  assert_eq!(Path::new(r"\a\b\").to_slash_lossy(), "/a/b/"); // Trailing slash is preserved
  ```
- New API `path_slash::CowExt` is added to extend `Cow<'_, Path>`. Methods to convert slash paths to `Cow<'_, Path>` are available. It is useful to avoid heap allocation as much as possible comparing with `PathBufExt`.  See [the API document](https://docs.rs/path-slash/latest/path_slash/trait.CowExt.html) for more details. (#9)
  ```rust
  use path_slash::CowExt as _;
  let p = Cow::from_slash("foo/bar/piyo.txt"); // Heap allocation only happens on Windows

  #[cfg(target_os = "windows")]
  assert_eq!(p, Cow::Owned(PathBuf::from(r"foo\bar\piyo.txt")));
  #[cfg(not(target_os = "windows"))]
  assert_eq!(p, Cow::Borrowed(Path::new("foo/bar/piyo.txt")));
  ```
  All methods added by importing `CowExt` are as follows:
  - `Cow::<Path>::from_slash(s: &str) -> Self`
  - `Cow::<Path>::from_slash_lossy(s: &OsStr) -> Self`
  - `Cow::<Path>::from_backslash(s: &str) -> Self`
  - `Cow::<Path>::from_backslash_lossy(s: &OsStr) -> Self`
- More tests are added. Now [the line coverage](https://app.codecov.io/gh/rhysd/path-slash) is 100%.
  - UTF-16 test cases for native encoding on Windows
  - All error cases including broken UTF-8 and UTF-16 sequences

[Changes][v0.2.0]


<a name="v0.1.5"></a>
# [v0.1.5](https://github.com/rhysd/path-slash/releases/tag/v0.1.5) - 29 Jun 2022

- Add new APIs to convert backslash paths to `PathBuf`. (#8, thanks @picobyte)
  - `PathBuf::from_backslash` converts `&str` into `PathBuf` with replacing `\` on non-Windows OS
  - `PathBuf::from_backslash` converts `&OsStr` into `PathBuf` with replacing `\` on non-Windows OS

[Changes][v0.1.5]


<a name="v0.1.4"></a>
# [v0.1.4](https://github.com/rhysd/path-slash/releases/tag/v0.1.4) - 15 Jan 2021

- Fix a final letter of paths with some verbatim prefixes was removed (#5)

[Changes][v0.1.4]


<a name="v0.1.3"></a>
# [v0.1.3](https://github.com/rhysd/path-slash/releases/tag/v0.1.3) - 01 Jul 2020

- Fix documentation (#4)

[Changes][v0.1.3]


<a name="v0.1.2"></a>
# [0.1.2 (v0.1.2)](https://github.com/rhysd/path-slash/releases/tag/v0.1.2) - 16 Jun 2020

- **Fix:** Root path separator was doubled when the path contains Windows driver letter. For example, when `C:/foo` was given, `to_slash` converted it to `C:\\foo`. In this version it converts it to `C:\foo` correctly.
- **Improve:** Remove a redundant allocation at calling `to_slash()` method.

[Changes][v0.1.2]


[v0.2.0]: https://github.com/rhysd/path-slash/compare/v0.1.5...v0.2.0
[v0.1.5]: https://github.com/rhysd/path-slash/compare/v0.1.4...v0.1.5
[v0.1.4]: https://github.com/rhysd/path-slash/compare/v0.1.3...v0.1.4
[v0.1.3]: https://github.com/rhysd/path-slash/compare/v0.1.2...v0.1.3
[v0.1.2]: https://github.com/rhysd/path-slash/tree/v0.1.2

 <!-- Generated by https://github.com/rhysd/changelog-from-release -->
