/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.BlankDataDerivType;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataDataDerivType;
import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SingleDataDerivType;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValueDataDerivType;
import com.thaiopensource.relaxng.impl.ValuePattern;

class DataDerivTypeFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;

    DataDerivTypeFunction(ValidatorPatternBuilder validatorPatternBuilder) {
        this.builder = validatorPatternBuilder;
    }

    static DataDerivType dataDerivType(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern) {
        return (DataDerivType)pattern.apply(validatorPatternBuilder.getDataDerivTypeFunction());
    }

    @Override
    public Object caseOther(Pattern pattern) {
        return new SingleDataDerivType();
    }

    @Override
    public DataDerivType caseRef(RefPattern refPattern) {
        return this.apply(refPattern.getPattern());
    }

    @Override
    public Object caseAfter(AfterPattern afterPattern) {
        Pattern pattern = afterPattern.getOperand1();
        DataDerivType dataDerivType = this.apply(afterPattern.getOperand1());
        if (!pattern.isNullable()) {
            return dataDerivType;
        }
        return dataDerivType.combine(new BlankDataDerivType());
    }

    private Object caseBinary(BinaryPattern binaryPattern) {
        return this.apply(binaryPattern.getOperand1()).combine(this.apply(binaryPattern.getOperand2()));
    }

    @Override
    public Object caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    @Override
    public Object caseGroup(GroupPattern groupPattern) {
        return this.caseBinary(groupPattern);
    }

    @Override
    public Object caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    @Override
    public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.apply(oneOrMorePattern.getOperand());
    }

    @Override
    public Object caseList(ListPattern listPattern) {
        return InconsistentDataDerivType.getInstance();
    }

    @Override
    public Object caseValue(ValuePattern valuePattern) {
        return new ValueDataDerivType(valuePattern.getDatatype());
    }

    @Override
    public Object caseData(DataPattern dataPattern) {
        if (dataPattern.allowsAnyString()) {
            return new SingleDataDerivType();
        }
        return new DataDataDerivType(dataPattern.getDatatype());
    }

    @Override
    public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
        if (dataExceptPattern.allowsAnyString()) {
            return this.apply(dataExceptPattern.getExcept());
        }
        return new DataDataDerivType(dataExceptPattern.getDatatype()).combine(this.apply(dataExceptPattern.getExcept()));
    }

    private DataDerivType apply(Pattern pattern) {
        return this.builder.getPatternMemo(pattern).dataDerivType();
    }
}

