/* $Id: luminance.c,v 1.3 2005/05/21 22:42:22 cegger Exp $
******************************************************************************

   Generic color default library implementation

   Copyright (C) 2001 Christoph Eggerg	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/


#include <stdlib.h>

#include "config.h"
#include "color.h"


/* ATTENTION:
 *
 * This computation assumes that the luminance spectral weighting can be
 * formed as a linear combination of the scanner curves, and assumes that the
 * component signals represent linear-light. Either or both of these
 * conditions can be relaxed to some extent depending on the application.
 */


ggi_float GGI_color_GetLuminance(ggi_visual_t vis, const gcp_pixel pix)
{
	gcp_RGBAcolor rgba;
	ggi_float r,g,b,y;

/* Formula:
 *
 *  Y = 0.212671 * R + 0.715160 * G + 0.072169 * B;
 */

	gcpUnmapRGBAPixel(vis, pix, &rgba);

	r = (ggi_float)rgba.r / 65536.0f;
	g = (ggi_float)rgba.g / 65536.0f;
	b = (ggi_float)rgba.b / 65536.0f;

	y = 0.212671 * r + 0.715160 * g + 0.072169 * b;

	return y;
}	/* GGI_color_GetLuminance */
