Gem::Specification.new do |s|

  s.name              = 'mailshears'
  s.version           = '0.1.0'
  s.platform          = Gem::Platform::RUBY
  s.authors           = ['Michael Orlitzky']
  s.email             = ['michael@orlitzky.com']
  s.homepage          = 'https://michael.orlitzky.com/code/mailshears.xhtml'
  s.summary           = 'Prune unused mail directories.'
  s.description       = <<-EOF
    Managing a mail system with virtual users is annoying. The
    authoritative database of users is stored in one table, but every
    other piece of software keeps its own database of users.

    If you're using PostfixAdmin to manage your users, what happens when
    you delete a user? Chances are, nothing happens: mail directories are
    left behind, webmail preferences are saved, address books become
    orphaned. That's what mailshears was designed to fix. It cleans up
    after you remove a user or domain.

    Another stupidly difficult task is renaming a single email
    account. It's easy to move the user in one database, but then all of
    the remaining filesystem directories and databases need to be updated
    as well. Since these two tasks are related, mailshears does them both.
  EOF

  s.license           = 'AGPL-3.0-or-later'
  s.required_rubygems_version = '>= 1.3.6'

  # If you have runtime dependencies, add them here
  s.add_runtime_dependency 'pg', '~> 1.2'

  # The list of files to be contained in the gem. We can obtain it
  # from git as long as we remember that this magic will happen and we
  # don't add any files in weird locations or build the gem before
  # running `git add`.
  s.files       = `git ls-files`.split("\n")
  s.executables = ['mailshears']

  s.require_path = 'lib'

end
