require 'pg'

require 'common/roundcube_plugin'
require 'rm/rm_plugin'

# Handle removal of Roundcube users from its database. Roundcube has
# no concept of domains.
#
class RoundcubeRm

  include RoundcubePlugin
  include RmPlugin

  # Remove *user* from the Roundcube database. This should remove him
  # from _every_ table in which he is referenced. Fortunately the
  # Roundcube developers were nice enough to include DBMS-specific
  # install and upgrade scripts, so Postgres can take advantage of ON
  # DELETE triggers.
  #
  # @param user [User] the user to remove.
  #
  def remove_user(user)
    raise NonexistentUserError.new(user.to_s()) if not user_exists(user)

    # Get the primary key for this user in the "users" table.
    user_id = self.get_user_id(user)

    # Thanks to the ON DELETE triggers, this will remove all child
    # records associated with user_id too.
    sql_query = 'DELETE FROM users WHERE user_id = $1::int;'

    connection = PG::Connection.new(@db_hash)

    begin
      connection.sync_exec_params(sql_query, [user_id])
    ensure
      # Make sure the connection gets closed even if the query explodes.
      connection.close()
    end
  end

end
