# Class methods for the creation and manipulation of our command-line
# user interface.
#
class UserInterface

  # Construct a usage string showing how to invoke the program.
  #
  # @param program_name [String] the name of this program, used to
  #   construct the usage string.
  #
  # @return [String] a string showing the format of a correct program
  #   invocation.
  #
  def self.usage(program_name)
    return "#{program_name} [--help] [prune | rm <target> | mv <src> <dst>]"
  end


  # Construct the header that precedes our other output. An example is,
  #
  #   mailshears, 2015-11-06 09:57:06 -0500 (Plugin: PrunePlugin)
  #   ------------------------------------------------------------
  #
  # @param program_name [String] the name of this program, to appear
  #   in the header.
  #
  # @param plugin_name [String] the name of the mode (prune, mv, etc.)
  #   plugin that is being run.
  #
  # @return [String] a string containing the output header.
  #
  def self.make_header(program_name, plugin_name)
    header = "#{program_name}, "

    current_time = Time.now()
    if current_time.respond_to?(:iso8601)
      # Somehow this method is missing on some machines.
      header += current_time.iso8601.to_s()
    else
      # Fall back to whatever this looks like.
      header += current_time.to_s()
    end

    header += ' (Plugin: ' + plugin_name + ")\n"

     # Underline the header, accounting for the newline.
    header += '-' * (header.size() - 1)

    return header
  end


end
