require 'common/errors'

# A class representing a syntactically valid domain. Essentially, the
# part after the "@" in an email address. Once constructed, you can be
# sure that it's valid.
#
class Domain

  # @domain contains the String representation of this domain.
  @domain = nil


  # Initialize this Domain object. If the domain is invalid, then an
  # {InvalidDomainError} will be raised containing the reason
  # why the domain is invalid.
  #
  # @param domain [String] the string representation of this domain.
  #
  def initialize(domain)
    if domain.empty? then
      msg = "domain cannot be empty"
      raise InvalidDomainError.new(msg)
    end

    @domain = domain
  end


  # Convert this domain to a String.
  #
  # @return [String] the string representation of this Domain.
  #
  def to_s()
    return @domain
  end


  # Check if this Domain is equal to some other Domain. The comparison
  # is based on their String representations.
  #
  # @param other [Domain] the Domain object to compare me to.
  #
  # @return [Boolean] If *self* and *other* have equal String
  #   representations, then true is returned. Otherwise, false is
  #   returned.
  #
  def ==(other)
    return self.to_s() == other.to_s()
  end


  # Compare two Domain objects for sorting purposes. The comparison
  # is based on their String representations.
  #
  # @param other [Domain] the Domain object to compare me to.
  #
  # @return [0,1,-1] a trinary indicator of how *self* relates to *other*,
  #   obtained by performing the same comparison on the String
  #   representations of *self* and *other*.
  #
  def <=>(other)
    return self.to_s() <=> other.to_s()
  end
end
