/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class AttributedStringSerializer
implements SerializeMethod {
    public void writeObject(Object o, ObjectOutputStream stream) throws IOException {
        AttributedString as = (AttributedString)o;
        AttributedCharacterIterator aci = as.getIterator();
        StringBuffer plainStr = new StringBuffer(100);
        char current = aci.first();
        while (current != '\uffff') {
            plainStr = plainStr.append(current);
            current = aci.next();
        }
        stream.writeObject(plainStr.toString());
        current = aci.first();
        int begin = aci.getBeginIndex();
        while (current != '\uffff') {
            stream.writeChar(current);
            int limit = aci.getRunLimit();
            stream.writeInt(limit - begin);
            HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>(aci.getAttributes());
            stream.writeObject(atts);
            current = aci.setIndex(limit);
        }
        stream.writeChar(65535);
    }

    public Object readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        String plainStr = (String)stream.readObject();
        AttributedString result = new AttributedString(plainStr);
        char c = stream.readChar();
        int start = 0;
        while (c != '\uffff') {
            int limit = stream.readInt();
            Map atts = (Map)stream.readObject();
            result.addAttributes(atts, start, limit);
            start = limit;
            c = stream.readChar();
        }
        return result;
    }

    public Class getObjectClass() {
        return AttributedString.class;
    }
}

