/* Defines LITTLE_ENDIAN_DETECTED if system follows little endian byte order
   scheme. Does not define anything if endianess could not be determined. */

#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__)
#  include <sys/endian.h>
#  if defined(_BYTE_ORDER) && defined(_LITTLE_ENDIAN)
#    if _BYTE_ORDER == _LITTLE_ENDIAN
#      define LITTLE_ENDIAN_DETECTED
#    endif
#  else
#    warning Could not determine endianess on BSD platform, revert to fail safe.
#  endif
#elif defined(__linux__)
#  include <endian.h>
#  if defined(__BYTE_ORDER) && defined(__LITTLE_ENDIAN)
#    if __BYTE_ORDER == __LITTLE_ENDIAN
#      define LITTLE_ENDIAN_DETECTED
#    endif
#  else
#    warning Could not determine endianess on Linux platform, revert to fail safe.
#  endif
#else
#  warning Could not determine endianess, revert to fail safe.
#endif
