#
# Keys, buttons and event bindings...
#
# $Id: bind.tcl,v 1.21 2011/02/17 15:20:12 rader Exp $
#

###############################################################################
## Widget used for the display...

proc DisplayBindings { } {
  global task_id task_startstop

  bind .t.lb <Key-a>            { Prompt "add:" }
  bind .t.lb <Key-A>            { Prompt "annotate $task_id:" }
  bind .t.lb <Key-b>            { Prompt "depends $task_id:" }
  bind .t.lb <Key-B>            { set cur_task_cmd "blocked"; Refresh "new-report" }
  bind .t.lb <Key-c>            { Prompt "description $task_id:" }
  bind .t.lb <Key-C>            { Prompt "depends $task_id:" }
  bind .t.lb <Key-d>            { ExecCommand "$task_id done" }
  bind .t.lb <Key-D>            { Prompt "due-date $task_id:" }
  bind .t.lb <Key-f>            { Prompt "filter:" }
  bind .t.lb <Key-g>            { Prompt "grep:" }
  bind .t.lb <Key-G>            { MoveCursor }
  bind .t.lb <Key-h>            { ExecCommand "$task_id priority:H" }
  bind .t.lb <Key-H>            { Refresh "high" }
  bind .t.lb <Key-i>            { DisplayInfo } 
  bind .t.lb <Key-j>            { Refresh "line-down" }
  bind .t.lb <Key-k>            { Refresh "line-up" }
  bind .t.lb <Key-l>            { ExecCommand "$task_id priority:L" }
  bind .t.lb <Key-L>            { Refresh "low" }
  bind .t.lb <Key-m>            { ExecCommand "$task_id priority:M" }
  bind .t.lb <Key-M>            { Refresh "middle" }
  bind .t.lb <Key-n>            { ExecCommand "$task_id priority:" }
  bind .t.lb <Key-N>            { Prompt "denotate $task_id:" }
  bind .t.lb <Key-o>            { Prompt "log:" }
  bind .t.lb <Key-O>            { set cur_task_cmd "overdue"; Refresh "new-report" }
  bind .t.lb <Key-p>            { Prompt "project $task_id:" }
  bind .t.lb <Key-P>            { set cur_task_cmd "projects"; Refresh "new-report" }
  bind .t.lb <Key-q>            { ReturnToPrevReport }
  bind .t.lb <Key-R>            { set cur_task_cmd "recurring"; Refresh "new-report" }
  bind .t.lb <Key-s>            { ExecCommand "$task_startstop $task_id" }
  bind .t.lb <Key-S>            { set cur_task_cmd "summary"; Refresh "new-report" }
  bind .t.lb <Key-t>            { Prompt "tag $task_id:" } 
  bind .t.lb <Key-T>            { set cur_task_cmd "tags"; Refresh "new-report" }
  bind .t.lb <Key-u>            { StartUndo }
  bind .t.lb <Key-w>            { Prompt "wait $task_id:" }
  bind .t.lb <Key-W>            { set cur_task_cmd "waiting"; Refresh "new-report" }
  bind .t.lb <Key-x>            { ReturnToPrevReport }
  bind .t.lb <Key-X>            { ExecCommand "rc.confirmation=no $task_id delete" }
  bind .t.lb <Key-colon>        { Prompt ":" }
  bind .t.lb <Key-question>     { HelpScreen }
  bind .t.lb <Key-space>        { Refresh "line-down"; break }
  bind .t.lb <Key-Down>         { Refresh "line-down" }
  bind .t.lb <Key-Escape>       { ReturnToPrevReport }
  bind .t.lb <Key-Next>         { Refresh "page-down"; break }
  bind .t.lb <Key-Prior>        { Refresh "page-up"; break }
  bind .t.lb <Key-Return>       { HandleEnterKey } 
  bind .t.lb <Key-Tab>          { break }
  bind .t.lb <Key-Up>           { Refresh "line-up" }
  bind .t.lb <Configure>        { Resize }
  bind .t.lb <Control-b>        { Refresh "page-up" } 
  bind .t.lb <Control-c>        { exit }
  bind .t.lb <Control-f>        { Refresh "page-down" } 
  bind .t.lb <Control-l>        { Refresh "new-report" }
  bind .t.lb <ButtonPress-1>    { break }
  bind .t.lb <ButtonRelease-1>  { break }
  bind .t.lb <ButtonPress-2>    { break }
  bind .t.lb <ButtonRelease-2>  { PasteIntoEntryWidget; break }
  bind .t.lb <ButtonPress-3>    { break }
  bind .t.lb <ButtonRelease-3>  { break }
  bind .t.lb <Motion>           { break } 
  bind .t.lb <Key>              { ParseOtherKeys %K }
  # these two are untested: unable to generate the events...
  bind .t.lb <<Paste>>          { PasteIntoEntryWidget; break }
  bind .t.lb <<PasteSelection>> { PasteIntoEntryWidget; break }
}

###############################################################################
## Widget used for text entry...

proc EntryBindings { } {
  bind .t.ent <Control-c>         { exit }
  bind .t.ent <Control-j>         { ExecPromptedCommand } 
  bind .t.ent <Control-m>         { ExecPromptedCommand } 
  bind .t.ent <Control-u>         { .t.ent delete 0 end; break }
  bind .t.ent <Control-w>         { .t.ent delete [tk::EntryPreviousWord %W insert] insert }
  bind .t.ent <Control-BackSpace> { break } ;# that old habit
  bind .t.ent <Key-Escape>        { DisablePrompt }
  bind .t.ent <Key-Return>        { ExecPromptedCommand } 
  bind .t.ent <Key-Tab>           { .t.ent insert end "\t"; break }
}

###############################################################################
## Handle enter...

proc HandleEnterKey { } {
  global display_mode cur_task_cmd prev_display_mode

  #puts "HandleEnterKey $cur_task_cmd $display_mode"
  if { [regexp {^proj} $cur_task_cmd] || [regexp {^sum} $cur_task_cmd] } { 
    set prev_display_mode $cur_task_cmd
    DisplayProject
    return
  }
  DisplayInfo
}

###############################################################################
## Handle keys/events not explicitly bound...

proc ParseOtherKeys { k } {
  global entered_num prev_k

  # cache num for "NG" cursor movement...
  if { [regexp {^[0-9]+$} $k] } {
    set entered_num "$entered_num$k"
    return
  }
  # "ZZ"... 
  if { $k == "Z" } {
    if { $prev_k == "Z" } { exit }
    set prev_k $k
    return
  }
  set prev_k $k
  # ignore unknown keys...
  if { $k == "??" } { return }
  # ignore modifier keys...
  if { [regexp {^Alt} $k] } { return }
  if { [regexp {^Control} $k] } { return }
  if { [regexp {^Menu} $k] } { return }
  if { [regexp {^Mod} $k] } { return }
  if { [regexp {^Meta} $k] } { return }
  if { [regexp {^Shift} $k] } { return }
  if { [regexp {^Super} $k] } { return }
  Bell
}

###############################################################################
## Bind the function keys...

proc FunctionKeyBindings { } { 
  global rc

  if { $rc(bind.f1) != "" }  { 
    bind .t.lb <Key-F1>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f1); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f2) != "" }  { 
    bind .t.lb <Key-F2>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f2); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f3) != "" }  { 
    bind .t.lb <Key-F3>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f3); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f4) != "" }  { 
    bind .t.lb <Key-F4>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f4); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f5) != "" }  { 
    bind .t.lb <Key-F5>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f5); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f6) != "" }  { 
    bind .t.lb <Key-F6>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f6); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f7) != "" }  { 
    bind .t.lb <Key-F7>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f7); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f8) != "" }  { 
    bind .t.lb <Key-F8>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f8); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f9) != "" }  { 
    bind .t.lb <Key-F9>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f9); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f10) != "" }  { 
    bind .t.lb <Key-F10>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f10); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f11) != "" }  { 
    bind .t.lb <Key-F11>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f11); ExecPromptedCommand 
    }
  }
  if { $rc(bind.f12) != "" }  { 
    bind .t.lb <Key-F12>  { 
      Prompt ":"; .t.ent configure -state normal; .t.ent insert end $rc(bind.f12); ExecPromptedCommand 
    }
  }

}

