#
# Usage... 
#
# $Id: usage.tcl,v 1.21 2011/02/17 15:21:39 rader Exp $
#

proc Usage { } {
  puts "
Usage: vittk \[ARGS\]
    --background COLOR    use COLOR for the background (-bg COLOR)
    --commands            print a listing of vittk commands and exit (-c)
    --data DIR            use DIR instead of ~/.task (-ds DIR)
    --debug               print lots of debugging information (-d)
    --fontname FONT       use FONT for the font (-fn FONT)
    --foreground COLOR    use COLOR for the foreground (-fg COLOR)
    --geometry ROWSxCOLS  specifies the size of the window (-geom ROWSxCOLS)
    --help                display this help and exit (-h)
    --ignore-exit-status  ignore the exit status from "task" (-i)
                          (a hack for non-UTF-8 environments)
    --report SPEC         set the default report to SPEC (-r SPEC)
    --taskrc FILE         use FILE instead of ~/.taskrc (-t FILE)
"
}

proc CommandLineHelp { } {
  global cols rows system_task_cmd feedback_wait swipe 
  global color_bg font
puts "
VITtk Commands:
    a DESCRIPTION  add task
    A ANNOTATION   add ANNOTATION 
    b ID           dependent (blocked on) ID
    B              display blocked report (dependent children)
    c DESCRIPTION  change DESCRIPTION 
    C ID           dependent (child of) ID
    d              mark task done
    D DATE         set the due-date to DATE
    f KEYWORDS     filter KEYWORDS
    g REGEX        \"grep\" using tcl/tk REGEX
    G              go to last line
    1G             go to line 1
    NG             go to line N
    h              set priority H
    i              display task info
    l              set priority L
    m              set priority M
    n              set priority none
    N STRING       denotate annotations matching STRING
    o DESCRIPTION  create task with DESCRIPTION and mark done (log)
    O              display overdue report
    p PROJECT      set PROJECT
    P              display projects report
    q              quit current report, return to default report
    R              display recurring repoert
    s              start/stop task
    S              display summary report
    t TAG          set TAG
    T              display tags report
    u              undo last change
    w              set wait 
    W              display waiting report
    x              exit current report, return to default report
    X              delete task
    ZZ             exit vittk
    :help          display all help
    :help KEYWORD  display help filtered by KEYWORD
    :s/OLD/NEW/    substitute OLD for NEW in description
    :N COMMAND     run COMMAND on task N
    :REPORT        display REPORT
    :quit          exit vittk
    \\n            display task info

Navigation: 
    G              go to last line
    1G             go to first line
    H              go to window top (high)
    k or Up        task up
    j or Down      task down
    L              go to window bottom (low)
    M              go to window middle
    ^b or PgUp     page up
    ^f or PgDn     page down
    ^l             refresh report output

Command Line:
    ^h             erase character
    ^u             erase line
    ^w             erase word
"
}

