#
# Ahh, refreshing...
#
# $Id: refresh.tcl,v 1.27 2011/02/17 17:00:13 rader Exp $
#

proc Refresh { type } {
  global display_mode cur_task_cmd prev_task_cmd task_args task_id swipe debug
  global rows cols win_size win_cur win_start
  global color_bg_selection color_fg_selection color_fg_info
  global header body color_body count_str error_mode pending completed complete 
  global column_one_type column_one_width help_view
  global converg ver

  #--------------------
  # new report...
  if { $type == "new-report" } {
     if { $debug } { puts "Refresh: NewReport..." }
    .t.ent configure -state disabled
    .t.lb configure -state normal
    .t.lb delete 0.0 end
    .t.lb configure -state disabled
    NewReport 
    update idletasks
    after $swipe
    if { $debug } { puts "Refresh: ...done with NewReport" }
  }

  if { $debug } { puts "Refresh: type=$type display_mode=$display_mode" }

  #--------------------
  # changes...
  set old_win_start $win_start
  set new_win_start $win_start
  set old_win_cur $win_cur
  set new_win_cur $win_cur
  if { $type == "line-last" } {
    set new_win_start [expr [array size body] - $win_size + 1]
    set new_win_cur [expr $win_size + 0]
    if { $new_win_start < 1 } { set new_win_start 1 }
    if { $new_win_cur > [array size body] } { set new_win_cur [expr [array size body]]}
    set old_win_cur $new_win_cur ;# not a scroll
  } elseif { $type == "line-down" } {
    incr new_win_cur 
  } elseif { $type == "line-up" } {
    set new_win_cur [expr $new_win_cur - 1]
  } elseif { $type == "page-up" } {
     # vi paging is pure genius...
     if { $new_win_start > 1 && [expr $new_win_start - $win_size] < 1 } { 
       set new_win_start 1
       set new_win_cur [expr $new_win_start + 1]
       if { $new_win_cur > [array size body] } { 
         set $new_win_cur 1
       }
     } elseif { [expr $new_win_start + $new_win_cur - $win_size] > 0 } { 
       set new_win_start [expr $new_win_start - $win_size]
       if { $new_win_start < 1 } { set new_win_start 1 }
     } else {
       if { $debug } { puts "Refresh: page-up failed: attempt to scroll over the top case 0" } 
       Bell
       return
     }
  } elseif { $type == "page-down" } {
    if { [expr $new_win_start + $new_win_cur + $win_size] <= [array size body] } { 
      set new_win_start [expr $new_win_start + $win_size]
    } elseif { [expr $new_win_start + $win_size - 2] <= [array size body] } { 
      set new_win_start [expr $new_win_start + $win_size - 2]
      if { [expr $new_win_start + $new_win_cur - 2] > [array size body] } { 
        set new_win_cur 1
      }
    } elseif { $new_win_start < [array size body] } { 
      set new_win_start [array size body] 
      set new_win_cur 1
    } else {
      if { $debug } { puts "Refresh: page-up failed: attempt to scroll off the bottom 0" } 
      Bell
      return
    }
  } elseif { $type == "high" } {
    set new_win_cur 1
  } elseif { $type == "low" } {
    if { [array size body] < $win_size } { 
      set new_win_cur [array size body]
    } else {
      set new_win_cur $win_size
    }
  } elseif { $type == "middle" } {
    if { [array size body] < $win_size } { 
      set new_win_cur [expr [array size body] / 2]
    } else {
      set new_win_cur [expr $win_size / 2]
    }
  }

  #--------------------
  # bounds...
  if { $new_win_cur < 1 && $new_win_start <= 1 } { 
    # at top...
    if { $type != "new-report" } { 
      if { $debug } { puts "Refresh: $type failed: attempt to scroll over the top case 1" } 
      Bell
      return;
    }
    set new_win_cur 1
    set new_win_start 1
  }
  if { $new_win_cur < 1 } {
    # scroll up...
    set new_win_cur 1
    set new_win_start [expr $new_win_start - 1]
  }
  if { $new_win_cur > $win_size } {
    # scroll down...
    set new_win_cur $win_size
    incr new_win_start
  }
  if { [expr $new_win_start + $new_win_cur] > [expr [array size body] + 1] } {
    # at bottom...
    if { $type != "new-report" } { 
      Bell
      if { $debug } { puts "Refresh: $type failed: attempt to scroll off the bottom case 1" } 
      return
    }
    set new_win_start 1
    set new_win_cur 1
  }

  #--------------------
  # parse...
  if { ! $error_mode } {
    set task_id 0;
    set oddeven 0;

    # parse the obvious...
    set ttype(0) "task"
    set id(0) 0
    for { set i 1 } { $i <= [array size body] } { incr i } {

      # id...
      if { [regexp {^ *([0-9]+) +} $body($i) junk tid] } {
        set id($i) $tid
      } else { 
        set id($i) $id([expr $i - 1])
      }

      # display...
      if { $i >= $new_win_start && $i < [expr $new_win_start + $win_size] } {
        set display($i) 1
      } else {
        set display($i) 0
      }
      # FIXME... fold into above blocks...
      if { $display_mode == "burndown" } {
        set display($i) 1
      }

      # type... 
      set col1 [string range $body($i) 0 $column_one_width]
      if { [regexp {^ +$} $col1] && $column_one_type != "Year" } { ;# hack for :history
        set ttype($i) "anno"
      } else {
        set ttype($i) "task" ;# not anno, really
        incr oddeven
      }
    }
    set ttype($i) "task" ;# so checking for annos at bottom is cleaner

    # adjust cur...
    if { $new_win_cur < $old_win_cur } { 
      # line up...
      set j [expr $new_win_start + $new_win_cur - 1]
      while { $j > 0 && $ttype($j) == "anno" } { 
        set j [expr $j - 1]
        set new_win_cur [expr $new_win_cur - 1]
      }
      if { $ttype([expr $old_win_start + $old_win_cur -1]) == "anno" } {
        # started on ano, so line up one more to next task...
        set new_win_cur [expr $new_win_cur - 1]
      }
    } elseif { $new_win_cur > $old_win_cur } {
      # line down...
      set j [expr $new_win_start + $new_win_cur]
      while { $j <= [array size body] && $ttype($j) == "anno" } {
        incr j
        incr new_win_cur
      }
      if { $ttype([expr $old_win_start + $old_win_cur]) == "anno" } {
        # started on ano, so line down one more to next task...
        incr new_win_cur
      }
      if { $new_win_cur > [array size body] } { 
        if { $debug } { puts "Refresh: $type failed: attempt to scroll off the bottom case 2" }
        Bell
        return
      }
    }

    # select cur...
    for { set i 1 } { $i <= [array size body] } { incr i } {
      if { $i == [expr $new_win_start + $new_win_cur - 1] } {
        set select($i) 1
        set task_id $id($i)
      } else {
        set select($i) 0
      }
    }
 
    # select annos up...
    if { $ttype([expr $new_win_start + $new_win_cur - 1]) == "anno" } { 
      set j [expr $new_win_start + $new_win_cur - 1]
      while { $j > 0 && $ttype($j) == "anno" } {
        set j [expr $j - 1]
        set select($j) 1
      }
    }

    # select annos down...
    set j [expr $new_win_start + $new_win_cur]
    while { $j <= [array size body] && $ttype($j) == "anno" } {
      set select($j) 1
      incr j
    }

    # don't scroll up when displaying one task with anno...
    if { $new_win_cur < 1 && $new_win_start == 1 && $type == "line-up" } {
      if { $debug } { puts "Refresh: $type failed: attempt to scroll up over the top case 2" }
      Bell
      return
    }

    # observed under very unique conditions...
    # apparently when paging and line 3 is an anno...
    # see ~/..task-off-by-one-2...
    if { $new_win_cur < 1 } {
      set new_win_cur 1
      set select($new_win_start) 1
    }

    set win_cur $new_win_cur
    set win_start $new_win_start

  }

  #--------------------
  # debug screen data...
  if { $debug && ! $error_mode } {
    for { set i 1 } { $i <= [array size body] } { incr i } {
      set istr [format "%-3d" $i]
      set idstr [format "%-3d" $id($i)]
      if { $i == [expr $win_cur + $win_start] } { set c 1 } else { set c 0 }
      if { $display($i) } { puts "Refresh: line=$istr cur=$c sel=$select($i) id=$idstr txt=\"$body($i)\"" }
    }
    puts "Refresh: display_mode=$display_mode win_start=$win_start win_cur=$win_cur task_id=$task_id count_str=\"$count_str\""
  }

  .t.lb configure -state normal

  #--------------------
  # display header...
  .t.lb delete 0.0 end
  if { $display_mode == "help" } { 
    set lstr "VITtk v${ver}: $help_view"
  } else { 
    set lstr "VITtk v${ver}: task $cur_task_cmd"
  }
  set llen [string length $lstr]
  set rlen [expr $cols - 1 - $llen]
  set rstr [format "%${rlen}s" "$pending tasks pending"]
  .t.lb insert end "$lstr $rstr\n" ctag_header
  set rstr [format "%${cols}s" "$completed tasks completed"]
  .t.lb insert end "$rstr\n" ctag_header
  .t.lb insert end " $header(1)\n" ctag_header

  InsertOverstrike $header(2)

  #--------------------
  # display body...
  set j 1
  for { set i 1 } { $i <= [array size body] } { incr i } {
    if { $display($i) } {
      if { $select($i) == 1 && ! [regexp {^cal} $cur_task_cmd] } {
        ColorizedInsert selection-bar $color_body($i)
      } else { 
        ColorizedInsert text $color_body($i)
      }
      incr j
    }
  }
  while { $j <= $win_size } { .t.lb insert end "\n"; incr j; }

  #--------------------
  # display footer...
  if { $error_mode } {
    .t.lb insert end "\n"
  } else { 
    if { [regexp {^info} $cur_task_cmd] || [regexp {^pro} $cur_task_cmd] || 
         [regexp {^stats} $cur_task_cmd] || [regexp {^su} $cur_task_cmd] } { 
      set rstr ""
    } else { 
      set rstr "$count_str$complete"
    }
    set llen [string length $rstr]
    set rlen [expr $cols - 1 - $llen]
    set num_lines [array size body]
    set num_pgs [expr ($num_lines - 1) / $win_size + 1]
    set cur_pg [expr [expr $win_start + $win_cur - 2]  / $win_size + 1]
    set str [format "%${rlen}s" "page $cur_pg of $num_pgs"]
    .t.lb insert end "$rstr $str\n" ctag_footer
  }
  incr j

  if { $display_mode == "report" } {
    set llen [string length $converg]
    set rlen [expr $cols - 1 - $llen]
    if { $task_id == 0 } {
      set rstr [format "%${rlen}s" "no task selected"] ;# not reached?
    } else {
      set rstr [format "%${rlen}s" "task $task_id selected"]
    }
    .t.lb insert end "$converg $rstr" ctag_footer
  }

  .t.lb configure -state disabled

  #--------------------
  # undo...
  if { $display_mode == "undo" } { 
    PromptYN "Revert to the previous state? (y/n) "
  }

}

