#
# Prompts...
#
# $Id: prompt.tcl,v 1.4 2011/02/17 16:01:37 rader Exp $
#

###############################################################################
## Start prompted commands...

proc Prompt { p } {
  global prompt after_id default_task_cmd cur_task_cmd task_id

  if { $task_id == 0 && $p != "add:" && $p != "log:" && $p != ":" } { 
    if { $p != "filter:" || $p != "grep:" && ![regexp {^com} $cur_task_cmd] } {  
      Bell
      return 
    }
  }

  after cancel $after_id
  .t.ent configure -state normal
  .t.ent delete 0 end
 
  # auto-fill via caller...
  if { [regexp {^: +(.*)} $p junk c] } {
    set p ":"
    .t.ent insert end "$c "
  }

  # auto-fill report spec...
  if { $p == "add:" && [regexp "^$default_task_cmd +(.*:.*)" $cur_task_cmd junk a] } {
    .t.ent insert end "$a "
  }

  set prompt $p
  focus .t.ent 
}

###############################################################################
## Remove prompts...

proc DisablePrompt { } {
  global prompt entered_num

  set entered_num ""
  set prompt ""
  .t.ent delete 0 end
  .t.ent configure -state disabled
  update idletasks
  focus .t.lb 
}

###############################################################################
## Yes/no prompt...

proc PromptYN { p } {
  global prompt after_id

  after cancel $after_id
  .t.ent configure -state normal
  .t.ent delete 0 end

  set prompt $p
  update idletasks
  focus .t.ent 

}


