/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "PowerUp.h"
#include "Player.h"

#ifndef M_2PI
#define M_2PI 6.28318
#endif

PowerUp::PowerUp(){
	s=0;
	s.y=3.0f;
	bouncecycle=0;
	spincycle=0;
	nature=POWERUP_NONE;
	spawneffect=maxspawneffect=500.0f;
	collideradius=3.0f;
	collideradius2=9.0f;
	done=0;
	game=NULL;
}

PowerUp::~PowerUp(){
}

void PowerUp::Update()
{
	bouncecycle+=game->dtf*0.005f;
	if(bouncecycle>M_2PI)
		bouncecycle-=M_2PI;

	spincycle+=game->dtf*0.005f;
	if(spincycle>M_2PI)
		spincycle-=M_2PI;

	if(spawneffect){
		spawneffect-=game->dtf;
		if(spawneffect<0)
			spawneffect=0;
	}

	Vector d;
	d=game->player->s-s;
	if(d.Mag2()<game->player->collideradius2+collideradius2+2*game->player->collideradius*collideradius && game->player->alive){
		game->player->GivePowerUp(nature);
		done=1;
	}
}
