/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/

/*
* A little documentation is in order.  To use this menu, construct it with:
*
*char* itemlabels[] - a NULL TERMINATED array of strings - {"foo","bar",NULL}
*menufunc itemfunctions[] - MENU_QUIT,MENU_FLOAT.  You'll get returned whichever of these was selected from Menu::Happen()
*	and in the case of MENU_FLOAT etc, they tell MenuItems how to behave.
*void* itemtargets[] - pointers to the values that will be altered by MENU_FLOAT entries, etc.
*Visual* newvisual - a Visual that's had InitGL called.
*
*Then call Menu::Happen().  Do what you will with the return value (MENU_QUIT,MENU_QUITFULL)...
*
*Don't forget to set solidbackground - 0 if you're during gameplay, 1 otherwise
*You'll need to have created a Visual, and a Game for the visual.  Sorry.  We really only use the
*Visual for resource (texture) management.
*
*
*/

#ifndef MENU_H
#define MENU_H

#include "Visual.h"
#include "SDL_ttf.h"


typedef enum{
	MENU_QUITFULL,
	MENU_QUIT,
	MENU_CONTINUE,
	MENU_FLOAT,
	MENU_FLOATONE,
	MENU_STRING,
	MENU_BOOL,
	MENU_SUB1,
	MENU_SUB2,
	MENU_SUB3,
	MENU_SUB4,
	MENU_SUB5,
	MENU_SUB6,
	MENU_NOSELECT,
	MENU_NONE
} menufunc;

class MenuItem;

class Menu{
public:
	int selection;
	void Arrange(int width,int height);
	void Up();
	void Down();
	void Draw();
	void HandleClick(int x,int y);
	void HandleMotion(int x,int y);
	void HandleEvents();
	void Select(int newselection);
	menufunc Happen();
	Menu(char* itemlabels[],menufunc itemfunctions[],void* itemtargets[],Visual* newvisual);
	~Menu();
	int solidbackground;
	TTF_Font* font;
	Visual* visual;
private:
	int done;
	int itemcount;
	MenuItem* item;
	int viewportx, viewporty;
	struct {int x;int y;} mouse;


};

#endif //MENU_H
