/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchMatch;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ConstructorLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.FieldLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.LocalVariableLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.LocalVariablePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.OrLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageDeclarationLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.core.runtime.CoreException;

public abstract class PatternLocator
implements IIndexConstants {
    protected int matchMode;
    protected boolean isCaseSensitive;
    protected boolean isEquivalentMatch;
    protected boolean isErasureMatch;
    protected boolean mustResolve;
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int INACCURATE_MATCH = 1;
    public static final int POSSIBLE_MATCH = 2;
    public static final int ACCURATE_MATCH = 3;
    public static final int ERASURE_MATCH = 4;
    public static final int COMPILATION_UNIT_CONTAINER = 1;
    public static final int CLASS_CONTAINER = 2;
    public static final int METHOD_CONTAINER = 4;
    public static final int FIELD_CONTAINER = 8;
    public static final int ALL_CONTAINER = 15;
    public static final int RAW_MASK = 48;
    public static final int RULE_MASK = 48;

    public static PatternLocator patternLocator(SearchPattern pattern) {
        switch (pattern.kind) {
            case 1: {
                return new PackageReferenceLocator((PackageReferencePattern)pattern);
            }
            case 2: {
                return new PackageDeclarationLocator((PackageDeclarationPattern)pattern);
            }
            case 4: {
                return new TypeReferenceLocator((TypeReferencePattern)pattern);
            }
            case 8: {
                return new TypeDeclarationLocator((TypeDeclarationPattern)pattern);
            }
            case 16: {
                return new SuperTypeReferenceLocator((SuperTypeReferencePattern)pattern);
            }
            case 32: {
                return new ConstructorLocator((ConstructorPattern)pattern);
            }
            case 64: {
                return new FieldLocator((FieldPattern)pattern);
            }
            case 128: {
                return new MethodLocator((MethodPattern)pattern);
            }
            case 256: {
                return new OrLocator((OrPattern)pattern);
            }
            case 512: {
                return new LocalVariableLocator((LocalVariablePattern)pattern);
            }
        }
        return null;
    }

    public static char[] qualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, IIndexConstants.ONE_STAR, '.');
        }
        return qualificationPattern == null ? CharOperation.concat(IIndexConstants.ONE_STAR, simpleNamePattern) : CharOperation.concat(qualificationPattern, simpleNamePattern, '.');
    }

    public static char[] qualifiedSourceName(TypeBinding binding) {
        ReferenceBinding type;
        if (binding instanceof ReferenceBinding && (type = (ReferenceBinding)binding).isLocalType()) {
            return type.isMemberType() ? CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), type.sourceName(), '.') : CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), new char[]{'.', '1', '.'}, type.sourceName());
        }
        return binding != null ? binding.qualifiedSourceName() : null;
    }

    public PatternLocator(SearchPattern pattern) {
        int matchRule = pattern.getMatchRule();
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.isErasureMatch = (matchRule & 0x10) != 0;
        this.isEquivalentMatch = (matchRule & 0x20) != 0;
        this.matchMode = matchRule & 7;
        this.mustResolve = pattern.mustResolve;
    }

    protected char[] getQualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, IIndexConstants.ONE_STAR, '.');
        }
        if (qualificationPattern == null) {
            return simpleNamePattern;
        }
        return CharOperation.concat(qualificationPattern, simpleNamePattern, '.');
    }

    protected char[] getQualifiedSourceName(TypeBinding binding) {
        TypeBinding type;
        TypeBinding typeBinding = type = binding instanceof ArrayBinding ? ((ArrayBinding)binding).leafComponentType : binding;
        if (type instanceof ReferenceBinding) {
            if (type.isLocalType()) {
                return CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), new char[]{'.', '1', '.'}, binding.sourceName());
            }
            if (type.isMemberType()) {
                return CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), binding.sourceName(), '.');
            }
        }
        return binding != null ? binding.qualifiedSourceName() : null;
    }

    protected TypeBinding getTypeNameBinding(int index) {
        return null;
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(ConstructorDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    protected int matchContainer() {
        return 15;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this.matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this.isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this.isCaseSensitive);
                }
                case 2: {
                    if (!this.isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this.isCaseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchesTypeReference(char[] pattern, TypeReference type) {
        if (pattern == null) {
            return true;
        }
        if (type == null) {
            return true;
        }
        char[][] compoundName = type.getTypeName();
        char[] simpleName = compoundName[compoundName.length - 1];
        int dimensions = type.dimensions() * 2;
        if (dimensions > 0) {
            int length = simpleName.length;
            char[] result = new char[length + dimensions];
            System.arraycopy(simpleName, 0, result, 0, length);
            int i = length;
            int l = result.length;
            while (i < l) {
                result[i++] = 91;
                result[i++] = 93;
            }
            simpleName = result;
        }
        return this.matchesName(pattern, simpleName);
    }

    protected int matchLevel(ImportReference importRef) {
        return 0;
    }

    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        int level = this.resolveLevel(binding);
        if (level >= 1) {
            this.matchReportImportRef(importRef, binding, locator.createImportHandle(importRef), level == 3 ? 0 : 1, locator);
        }
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (locator.encloses(element)) {
            this.matchReportReference(importRef, element, accuracy, locator);
        }
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        SearchMatch match = null;
        int referenceType = this.referenceType();
        int offset = reference.sourceStart;
        switch (referenceType) {
            case 4: {
                match = locator.newPackageReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 7: {
                match = locator.newTypeReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 8: {
                match = locator.newFieldReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 9: {
                boolean isConstructor = reference instanceof ExplicitConstructorCall;
                boolean isSynthetic = isConstructor ? ((ExplicitConstructorCall)reference).isImplicitSuper() : false;
                match = locator.newMethodReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, isConstructor, isSynthetic, reference);
                break;
            }
            case 14: {
                match = locator.newLocalVariableReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            }
        }
        if (match != null) {
            locator.report(match);
        }
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IJavaElement element, int accuracy, int length, MatchLocator locator) {
        return locator.newDeclarationMatch(element, accuracy, reference.sourceStart, length);
    }

    protected int referenceType() {
        return 0;
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        return 0;
    }

    protected int refineAccuracy(int accuracy, ParameterizedTypeBinding parameterizedBinding, char[][][] patternTypeArguments, MatchLocator locator) {
        if (locator.unitScope == null) {
            return accuracy;
        }
        return this.refineAccuracy(accuracy, parameterizedBinding, patternTypeArguments, false, 0, locator);
    }

    /*
     * Unable to fully structure code
     */
    int refineAccuracy(int accuracy, ParameterizedTypeBinding parameterizedBinding, char[][][] patternTypeArguments, boolean isPatternSourceType, int depth, MatchLocator locator) {
        block43: {
            patternTypeArgsLength = patternTypeArguments == null || depth >= patternTypeArguments.length || patternTypeArguments[depth] == null ? 0 : patternTypeArguments[depth].length;
            argumentsBinding = parameterizedBinding.arguments;
            typeArgumentsLength = argumentsBinding == null ? 0 : argumentsBinding.length;
            refinedAccuracy = accuracy;
            if (patternTypeArgsLength == typeArgumentsLength) {
                if (patternTypeArgsLength == 0) {
                    if (isPatternSourceType && refinedAccuracy <= 1) {
                        refinedAccuracy |= 48;
                    }
                } else if (isPatternSourceType) {
                    refinedAccuracy |= 16;
                    refinedAccuracy &= -33;
                }
            } else {
                if (patternTypeArgsLength == 0) {
                    if ((patternTypeArguments == null || depth < patternTypeArguments.length) && refinedAccuracy <= 1) {
                        refinedAccuracy |= 48;
                    }
                    return refinedAccuracy;
                }
                if (typeArgumentsLength == 0) {
                    if (refinedAccuracy <= 1) {
                        refinedAccuracy |= 48;
                    }
                    return refinedAccuracy;
                }
                return -1;
            }
            if (isPatternSourceType) break block43;
            i = 0;
            while (i < typeArgumentsLength) {
                argumentBinding = argumentsBinding[i];
                patternTypeArgument = patternTypeArguments[depth][i];
                patternWildcard = patternTypeArgument[0];
                patternTypeName = patternTypeArgument;
                patternWildcardKind = -1;
                block0 : switch (patternWildcard) {
                    case '*': {
                        if (argumentBinding.isWildcard()) {
                            wildcardBinding = (WildcardBinding)argumentBinding;
                            if (wildcardBinding.kind == 0) break;
                        }
                        if (refinedAccuracy >= 16) break;
                        refinedAccuracy |= 32;
                        break;
                    }
                    case '+': {
                        patternWildcardKind = 1;
                        patternTypeName = CharOperation.subarray(patternTypeArgument, 1, patternTypeArgument.length);
                        ** GOTO lbl46
                    }
                    case '-': {
                        patternWildcardKind = 2;
                        patternTypeName = CharOperation.subarray(patternTypeArgument, 1, patternTypeArgument.length);
                    }
lbl46:
                    // 3 sources

                    default: {
                        patternTypeName = Signature.toCharArray(patternTypeName);
                        patternBinding = locator.getType(patternTypeArgument, patternTypeName);
                        if (patternBinding == null) {
                            if (!argumentBinding.isWildcard()) break;
                            wildcardBinding = (WildcardBinding)argumentBinding;
                            if (wildcardBinding.kind == 0) {
                                if (refinedAccuracy >= 16) break;
                                refinedAccuracy |= 32;
                                break;
                            }
                            refinedAccuracy |= 16;
                            break;
                        }
                        block5 : switch (patternWildcard) {
                            case '*': {
                                if (refinedAccuracy >= 16) break block0;
                                refinedAccuracy |= 32;
                                break block0;
                            }
                            case '+': {
                                if (argumentBinding.isWildcard()) {
                                    wildcardBinding = (WildcardBinding)argumentBinding;
                                    if (wildcardBinding.kind == patternWildcardKind && wildcardBinding.bound == patternBinding) break block0;
                                    switch (wildcardBinding.kind) {
                                        case 1: {
                                            if (wildcardBinding.bound != null && !wildcardBinding.bound.isCompatibleWith(patternBinding)) break block5;
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                        case 2: {
                                            break;
                                        }
                                        case 0: {
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                    }
                                    break;
                                }
                                if (!argumentBinding.isCompatibleWith(patternBinding)) break;
                                if (refinedAccuracy >= 16) break block0;
                                refinedAccuracy |= 32;
                                break block0;
                            }
                            case '-': {
                                if (argumentBinding.isWildcard()) {
                                    wildcardBinding = (WildcardBinding)argumentBinding;
                                    if (wildcardBinding.kind == patternWildcardKind && wildcardBinding.bound == patternBinding) break block0;
                                    switch (wildcardBinding.kind) {
                                        case 1: {
                                            break;
                                        }
                                        case 2: {
                                            if (wildcardBinding.bound != null && !patternBinding.isCompatibleWith(wildcardBinding.bound)) break block5;
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                        case 0: {
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                    }
                                    break;
                                }
                                if (!patternBinding.isCompatibleWith(argumentBinding)) break;
                                if (refinedAccuracy >= 16) break block0;
                                refinedAccuracy |= 32;
                                break block0;
                            }
                            default: {
                                if (argumentBinding.isWildcard()) {
                                    wildcardBinding = (WildcardBinding)argumentBinding;
                                    switch (wildcardBinding.kind) {
                                        case 1: {
                                            if (wildcardBinding.bound != null && !patternBinding.isCompatibleWith(wildcardBinding.bound)) break block5;
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                        case 2: {
                                            if (wildcardBinding.bound != null && !wildcardBinding.bound.isCompatibleWith(patternBinding)) break block5;
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                        case 0: {
                                            if (refinedAccuracy >= 16) break block0;
                                            refinedAccuracy |= 32;
                                            break block0;
                                        }
                                    }
                                    break;
                                }
                                if (argumentBinding == patternBinding) break block0;
                            }
                        }
                        return 16;
                    }
                }
                ++i;
            }
        }
        if ((enclosingType = parameterizedBinding.enclosingType()) != null && (enclosingType.isParameterizedType() || enclosingType.isRawType())) {
            return this.refineAccuracy(refinedAccuracy, (ParameterizedTypeBinding)enclosingType, patternTypeArguments, isPatternSourceType, depth + 1, locator);
        }
        return refinedAccuracy;
    }

    public int resolveLevel(Binding binding) {
        return 1;
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, TypeBinding binding) {
        TypeBinding type;
        char[] qualifiedPattern = this.getQualifiedPattern(simpleNamePattern, qualificationPattern);
        int level = this.resolveLevelForType(qualifiedPattern, binding);
        if (level == 3 || binding == null) {
            return level;
        }
        boolean match = false;
        TypeBinding typeBinding = type = binding instanceof ArrayBinding ? ((ArrayBinding)binding).leafComponentType : binding;
        if (type.isMemberType() || type.isLocalType()) {
            match = qualificationPattern != null ? CharOperation.match(qualifiedPattern, this.getQualifiedSourceName(binding), this.isCaseSensitive) : CharOperation.match(qualifiedPattern, binding.sourceName(), this.isCaseSensitive);
        } else if (qualificationPattern == null) {
            match = CharOperation.match(qualifiedPattern, this.getQualifiedSourceName(binding), this.isCaseSensitive);
        }
        return match ? 3 : 0;
    }

    protected int resolveLevelForType(char[] qualifiedPattern, TypeBinding type) {
        if (qualifiedPattern == null) {
            return 3;
        }
        if (type == null) {
            return 1;
        }
        if (type.isTypeVariable()) {
            return 0;
        }
        char[] qualifiedPackageName = type.qualifiedPackageName();
        char[] qualifiedSourceName = PatternLocator.qualifiedSourceName(type);
        char[] fullyQualifiedTypeName = qualifiedPackageName.length == 0 ? qualifiedSourceName : CharOperation.concat(qualifiedPackageName, qualifiedSourceName, '.');
        return CharOperation.match(qualifiedPattern, fullyQualifiedTypeName, this.isCaseSensitive) ? 3 : 0;
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[][][] patternTypeArguments, int depth, TypeBinding type) {
        ReferenceBinding enclosingType;
        int level = this.resolveLevelForType(simpleNamePattern, qualificationPattern, type);
        if (level == 0) {
            return 0;
        }
        if (type == null || patternTypeArguments == null || patternTypeArguments.length == 0 || depth >= patternTypeArguments.length || patternTypeArguments[depth] == null) {
            return level;
        }
        int impossible = this.isErasureMatch ? 4 : 0;
        boolean isRawType = type.isRawType();
        if (type.isGenericType()) {
            TypeVariableBinding[] typeVariables = null;
            if (type instanceof SourceTypeBinding) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)type;
                typeVariables = sourceTypeBinding.typeVariables;
            } else if (type instanceof BinaryTypeBinding) {
                BinaryTypeBinding binaryTypeBinding = (BinaryTypeBinding)type;
                if (this.mustResolve) {
                    typeVariables = binaryTypeBinding.typeVariables();
                }
            }
            if (typeVariables == null || typeVariables.length == 0) {
                return 0;
            }
            int length = patternTypeArguments[depth].length;
            if (typeVariables.length != length) {
                return 0;
            }
            return level;
        }
        if (isRawType) {
            return level;
        }
        if (!type.isParameterizedType()) {
            return 0;
        }
        ParameterizedTypeBinding paramTypeBinding = (ParameterizedTypeBinding)type;
        if (paramTypeBinding.arguments != null) {
            int length = patternTypeArguments[depth].length;
            if (paramTypeBinding.arguments.length != length) {
                return 0;
            }
            int i = 0;
            while (i < length) {
                char[] patternTypeArgument = patternTypeArguments[depth][i];
                TypeBinding argTypeBinding = paramTypeBinding.arguments[i];
                block0 : switch (patternTypeArgument[0]) {
                    case '*': 
                    case '-': {
                        break;
                    }
                    case '+': {
                        patternTypeArgument = CharOperation.subarray(patternTypeArgument, 1, patternTypeArgument.length);
                    }
                    default: {
                        patternTypeArgument = Signature.toCharArray(patternTypeArgument);
                        if (!this.isCaseSensitive) {
                            patternTypeArgument = CharOperation.toLowerCase(patternTypeArgument);
                        }
                        boolean patternTypeArgHasAnyChars = CharOperation.contains(new char[]{'*', '?'}, patternTypeArgument);
                        if (argTypeBinding.isWildcard()) {
                            WildcardBinding wildcardBinding = (WildcardBinding)argTypeBinding;
                            switch (wildcardBinding.kind) {
                                case 1: {
                                    if (patternTypeArgHasAnyChars) {
                                        return impossible;
                                    }
                                }
                                case 0: {
                                    break block0;
                                }
                            }
                            ReferenceBinding boundBinding = (ReferenceBinding)wildcardBinding.bound;
                            if (CharOperation.match(patternTypeArgument, boundBinding.shortReadableName(), this.isCaseSensitive) || CharOperation.match(patternTypeArgument, boundBinding.readableName(), this.isCaseSensitive)) break;
                            if (patternTypeArgHasAnyChars) {
                                return impossible;
                            }
                            boundBinding = boundBinding.superclass();
                            while (boundBinding != null) {
                                if (CharOperation.equals(patternTypeArgument, boundBinding.shortReadableName(), this.isCaseSensitive) || CharOperation.equals(patternTypeArgument, boundBinding.readableName(), this.isCaseSensitive) || (boundBinding.isLocalType() || boundBinding.isMemberType()) && CharOperation.match(patternTypeArgument, boundBinding.sourceName(), this.isCaseSensitive)) break block0;
                                boundBinding = boundBinding.superclass();
                            }
                            return impossible;
                        }
                        if (CharOperation.match(patternTypeArgument, argTypeBinding.shortReadableName(), this.isCaseSensitive) || CharOperation.match(patternTypeArgument, argTypeBinding.readableName(), this.isCaseSensitive) || (argTypeBinding.isLocalType() || argTypeBinding.isMemberType()) && CharOperation.match(patternTypeArgument, argTypeBinding.sourceName(), this.isCaseSensitive)) break;
                        if (patternTypeArgHasAnyChars) {
                            return impossible;
                        }
                        ReferenceBinding refBinding = null;
                        if (argTypeBinding.isArrayType()) {
                            TypeBinding leafBinding = ((ArrayBinding)argTypeBinding).leafComponentType;
                            if (!leafBinding.isBaseType()) {
                                refBinding = (ReferenceBinding)leafBinding;
                            }
                        } else if (!argTypeBinding.isBaseType()) {
                            refBinding = (ReferenceBinding)argTypeBinding;
                        }
                        if (refBinding != null) {
                            refBinding = refBinding.superclass();
                            while (refBinding != null) {
                                if (CharOperation.equals(patternTypeArgument, refBinding.shortReadableName(), this.isCaseSensitive) || CharOperation.equals(patternTypeArgument, refBinding.readableName(), this.isCaseSensitive) || (refBinding.isLocalType() || refBinding.isMemberType()) && CharOperation.match(patternTypeArgument, refBinding.sourceName(), this.isCaseSensitive)) break block0;
                                refBinding = refBinding.superclass();
                            }
                        }
                        return impossible;
                    }
                }
                ++i;
            }
        }
        if ((enclosingType = paramTypeBinding.enclosingType()) != null && enclosingType.isParameterizedType() && depth < patternTypeArguments.length && qualificationPattern != null) {
            char[] enclosingQualificationPattern;
            int lastDot;
            char[] enclosingSimpleNamePattern = lastDot == -1 ? qualificationPattern : CharOperation.subarray(qualificationPattern, lastDot + 1, qualificationPattern.length);
            int enclosingLevel = this.resolveLevelForType(enclosingSimpleNamePattern, enclosingQualificationPattern = (lastDot = CharOperation.lastIndexOf('.', qualificationPattern)) == -1 ? null : CharOperation.subarray(qualificationPattern, 0, lastDot), patternTypeArguments, depth + 1, enclosingType);
            if (enclosingLevel == impossible) {
                return impossible;
            }
            if (enclosingLevel == 0) {
                return 0;
            }
        }
        return level;
    }

    public String toString() {
        return "SearchPattern";
    }
}

