/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IMemberFinder;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class InterTypeMemberFinder
implements IMemberFinder {
    private List interTypeFields = new ArrayList();
    private List interTypeMethods = new ArrayList();
    public SourceTypeBinding sourceTypeBinding;

    public FieldBinding getField(SourceTypeBinding sourceTypeBinding, char[] fieldName, InvocationSite site, Scope scope) {
        FieldBinding retField = sourceTypeBinding.getFieldBase(fieldName, true);
        if (this.interTypeFields.isEmpty()) {
            return retField;
        }
        int fieldLength = fieldName.length;
        int len = this.interTypeFields.size();
        for (int i = 0; i < len; ++i) {
            FieldBinding field = (FieldBinding)this.interTypeFields.get(i);
            if (field.name.length != fieldLength || !CharOperation.prefixEquals(field.name, fieldName)) continue;
            retField = this.resolveConflicts(sourceTypeBinding, retField, field, site, scope);
        }
        return retField;
    }

    private FieldBinding resolveConflicts(SourceTypeBinding sourceTypeBinding, FieldBinding retField, FieldBinding field, InvocationSite site, Scope scope) {
        if (retField == null) {
            return field;
        }
        if (site != null) {
            if (!field.canBeSeenBy(sourceTypeBinding, site, scope)) {
                return retField;
            }
            if (!retField.canBeSeenBy(sourceTypeBinding, site, scope)) {
                return field;
            }
        }
        return new ProblemFieldBinding(retField.declaringClass, retField.name, 3);
    }

    private boolean isVisible(MethodBinding m1, ReferenceBinding s) {
        if (m1.declaringClass == s) {
            return true;
        }
        if (m1.isPublic()) {
            return true;
        }
        if (!m1.isPrivate()) {
            return m1.declaringClass.getPackage() == s.getPackage();
        }
        return false;
    }

    public MethodBinding[] getMethods(SourceTypeBinding sourceTypeBinding, char[] selector) {
        MethodBinding[] orig = sourceTypeBinding.getMethodsBase(selector);
        if (this.interTypeMethods.isEmpty()) {
            return orig;
        }
        ArrayList<MethodBinding> ret = new ArrayList<MethodBinding>(Arrays.asList(orig));
        int len = this.interTypeMethods.size();
        for (int i = 0; i < len; ++i) {
            MethodBinding method = (MethodBinding)this.interTypeMethods.get(i);
            if (!CharOperation.equals(selector, method.selector)) continue;
            ret.add(method);
        }
        if (ret.isEmpty()) {
            return TypeConstants.NoMethods;
        }
        return ret.toArray(new MethodBinding[ret.size()]);
    }

    public MethodBinding getExactMethod(SourceTypeBinding sourceTypeBinding, char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        MethodBinding ret = sourceTypeBinding.getExactMethodBase(selector, argumentTypes, refScope);
        int len = this.interTypeMethods.size();
        for (int i = 0; i < len; ++i) {
            MethodBinding im = (MethodBinding)this.interTypeMethods.get(i);
            if (!this.matches(im, selector, argumentTypes)) continue;
            return im;
        }
        return ret;
    }

    private boolean matches(MethodBinding m1, MethodBinding m2) {
        return this.matches(m1, m2.selector, m2.parameters);
    }

    private boolean matches(MethodBinding method, char[] selector, TypeBinding[] argumentTypes) {
        if (!CharOperation.equals(selector, method.selector)) {
            return false;
        }
        int argCount = argumentTypes.length;
        if (method.parameters.length != argCount) {
            return false;
        }
        TypeBinding[] toMatch = method.parameters;
        for (int p = 0; p < argCount; ++p) {
            if (toMatch[p] == argumentTypes[p]) continue;
            return false;
        }
        return true;
    }

    public void addInterTypeField(FieldBinding binding) {
        this.interTypeFields.add(binding);
    }

    public void addInterTypeMethod(MethodBinding binding) {
        if (this.isVisible(binding, this.sourceTypeBinding)) {
            MethodBinding[] baseMethods = this.sourceTypeBinding.methods;
            int len = baseMethods.length;
            for (int i = 0; i < len; ++i) {
                MethodBinding b = baseMethods[i];
                if (!this.matches(binding, b)) continue;
                if (b.sourceMethod() != null) {
                    b.sourceMethod().binding = null;
                }
                this.sourceTypeBinding.removeMethod(i);
                break;
            }
        }
        this.interTypeMethods.add(binding);
    }
}

