/*
 Copyright (c) 1995-2021  by Arkkra Enterprises.
 All rights reserved.

 Redistribution and use in source and binary forms,
 with or without modification, are permitted provided that
 the following conditions are met:

 1. Redistributions of source code must retain
 the above copyright notice, this list of conditions
 and the following DISCLAIMER.

 2. Redistributions in binary form must reproduce the above
 copyright notice, this list of conditions and
 the following DISCLAIMER in the documentation and/or
 other materials provided with the distribution.

 3. Any additions, deletions, or changes to the original files
 must be clearly indicated in accompanying documentation,
 including the reasons for the changes,
 and the names of those who made the modifications.

	DISCLAIMER

 THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _SSVUSED_H
#define _SSVUSED_H

/*
 * This file contains the array subscript definitions for the used[] array
 * of an SSV struct. An SSV contains parameters associated with a
 * Score, Staff, or Voice.  The used[] array is a set of flags which say
 * whether a given parameter is actually populated in the SSV instance.
 * In the "score" SSV, all used flags are always set true.  In SSVs for
 * a staff or voice, a "used" flag is only set to true if the user
 * specified a value for the parameter in that staff or voice context.
 *
 * The actual values are machine-generated so they get automatically
 * renumbered if parameters are added or deleted or rearranged.
 *
 * We try to put things that are logically similar close together in
 * this list, but they could be in any order, other than that NUMFLDS
 * _must_ be last.
 */

#define	SCALE_FACTOR		(0)
#define	UNITS			(1)
#define	PAGEHEIGHT		(2)
#define	PAGEWIDTH		(3)
#define	PANELSPERPAGE		(4)
#define	MAXSCORES		(5)
#define	MAXMEASURES		(6)
#define	SLASHESBETWEEN		(7)
#define	TOPMARGIN		(8)
#define	BOTMARGIN		(9)
#define	LEFTMARGIN		(10)
#define	RIGHTMARGIN		(11)
#define	FLIPMARGINS		(12)
#define	INDENTRESTART		(13)
#define	RESTCOMBINE		(14)
#define	FIRSTPAGE		(15)
#define	NUMSTAFF		(16)
#define	MINSCSEP		(17)
#define	MAXSCSEP		(18)
#define	MINSCPAD		(19)
#define	MAXSCPAD		(20)
#define	BRACELIST		(21)
#define	BRACKLIST		(22)
#define	BARSTLIST		(23)
#define	SUBBARSTYLE		(24)
#define	TIME			(25)
#define	DIVISION		(26)
#define	ENDINGSTYLE		(27)
#define	ALIGNLABELS		(28)
#define	GRIDSATEND		(29)
#define	MEASNUM			(30)
#define	MEASNUMFAMILY		(31)
#define	MEASNUMFONT		(32)
#define	MEASNUMSIZE		(33)
#define	MEASNUMSTYLE		(34)
#define	BRACKETREPEATS		(35)
#define	PACKFACT		(36)
#define	PACKEXP			(37)
#define	LEFTSPACE		(38)
#define	WARN			(39)
#define	PRINTKEYMAP		(40)
#define	A4FREQ			(41)
#define	TUNING			(42)
#define	ACCTABLE		(43)
#define	STAFFSCALE		(44)
#define	VISIBLE			(45)
#define	STAFFLINES		(46)
#define	GRIDSWHEREUSED		(47)
#define	GRIDSCALE		(48)
#define	GRIDFRET		(49)
#define	MINGRIDHEIGHT		(50)
#define	NUMBERMRPT		(51)
#define	NUMBERMULTRPT		(52)
#define	PRINTMULTNUM		(53)
#define	RESTSYMMULT		(54)
#define	VSCHEME			(55)
#define	VCOMBINE		(56)
#define	PRINTEDTIME		(57)
#define	SHARPS			(58)
#define	CANCELKEY		(59)
#define	TRANSPOSITION		(60)
#define	ADDTRANSPOSITION	(61)
#define	USEACCS			(62)
#define	CARRYACCS		(63)
#define	CLEF			(64)
#define	REHSTYLE		(65)
#define	REPEATDOTS		(66)
#define	FONTFAMILY		(67)
#define	FONT			(68)
#define	SIZE			(69)
#define	REHFAMILY		(70)
#define	REHFONT			(71)
#define	REHSIZE			(72)
#define	LYRICSFAMILY		(73)
#define	LYRICSFONT		(74)
#define	LYRICSSIZE		(75)
#define	LYRICSALIGN		(76)
#define	SYLPOSITION		(77)
#define	MINALIGNSCALE		(78)
#define	MINSTSEP		(79)
#define	STAFFPAD		(80)
#define	ABOVEORDER		(81)
#define	BELOWORDER		(82)
#define	BETWEENORDER		(83)
#define	PEDSTYLE		(84)
#define	ALIGNPED		(85)
#define	CHORDDIST		(86)
#define	DIST			(87)
#define	DYNDIST			(88)
#define	LYRICSDIST		(89)
#define	CHORDTRANSLATION	(90)
#define	LABEL			(91)
#define	LABEL2			(92)
#define	LABELKEYMAP		(93)
#define	ENDINGKEYMAP		(94)
#define	REHEARSALKEYMAP		(95)
#define	DEFAULTKEYMAP		(96)
#define	WITHKEYMAP		(97)
#define	TEXTKEYMAP		(98)
#define	LYRICSKEYMAP		(99)
#define	BEAMSTLIST		(100)
#define	BEAMSLOPE		(101)
#define	TUPLETSLOPE		(102)
#define	PAD			(103)
#define	STEMLEN			(104)
#define	BEAMSHORT		(105)
#define	MAXPROSHORT		(106)
#define	BEGPROSHORT		(107)
#define	ENDPROSHORT		(108)
#define	MIDLINESTEMFLOAT	(109)
#define	DEFOCT			(110)
#define	NOTEINPUTDIR		(111)
#define	TIMEUNIT		(112)
#define	SWINGUNIT		(113)
#define	WITHFAMILY		(114)
#define	WITHFONT		(115)
#define	WITHSIZE		(116)
#define	ALIGNRESTS		(117)
#define	RELEASE			(118)
#define	ONTHELINE		(119)
#define	TABWHITEBOX		(120)
#define	NOTEHEADS		(121)
#define	EMPTYMEAS		(122)
#define	EXTENDLYRICS		(123)
#define	CUE			(124)
#define	DEFAULTPHRASESIDE	(125)
#define	NUMFLDS			(126)

#endif
