{-# LANGUAGE DeriveDataTypeable #-}

module CommandLine (
  Args(..),
  get_args )
where

import System.Console.CmdArgs (
  Data,
  (&=),
  cmdArgs,
  def,
  details,
  help,
  program,
  summary )


-- Get the version from Cabal.
import Paths_email_validator ( version )
import Data.Version ( showVersion )


data Args = Args { accept_a :: Bool,
                   rfc5322 :: Bool }
  deriving   (Show, Data)

description :: String
description = "Perform naive validation of email addresses."

program_name :: String
program_name = "email-validator"

my_summary :: String
my_summary = program_name ++ "-" ++ (showVersion version)

accept_a_help :: String
accept_a_help =
  "Accept an 'A' record for the domain instead of requiring an MX record."

rfc5322_help :: String
rfc5322_help =
  "Validate according to RFC 5322 (incredibly lenient)."

arg_spec :: Args
arg_spec =
    Args { accept_a    = def &=            help accept_a_help,
           rfc5322     = def &=            help rfc5322_help }
      &= program program_name
      &= summary my_summary
      &= details [description]



get_args :: IO Args
get_args = cmdArgs arg_spec
