/*
 * Decompiled with CFR 0.152.
 */
package gd.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

class XMLReader
extends Reader {
    private static final String ASCII = "ASCII";
    private static final String UTF16B = "UTF-16BE";
    private static final String UTF16L = "UTF-16BE";
    private static final String UTF8 = "UTF-8";
    InputStream input;
    String encoding = null;
    StringBuffer buffer = new StringBuffer();
    boolean lastWasD = false;
    int bufpos = 0;

    XMLReader(InputStream inputStream) {
        this.input = inputStream;
    }

    XMLReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.input = inputStream;
        this.setEncoding(string);
    }

    public void close() throws IOException {
        this.buffer = null;
        this.input = null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void push(char c) {
        this.buffer.insert(this.bufpos, c);
    }

    public void push(String string) {
        this.buffer.insert(this.bufpos, string);
    }

    public int read() throws IOException {
        int n = this.underlyingRead();
        if (this.lastWasD && n == 10) {
            return this.underlyingRead();
        }
        if (n == 13) {
            this.lastWasD = true;
            return 10;
        }
        this.lastWasD = false;
        return n;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) break;
            cArray[n + n3] = (char)n4;
            ++n3;
        }
        return n3;
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        if ((string = string.intern()) == null) {
            throw new UnsupportedEncodingException();
        }
        if (string == "UTF-16") {
            string = "UTF-16BE";
        }
        if (string != ASCII && string != "UTF-16BE" && string != "UTF-16BE" && string != UTF8) {
            throw new UnsupportedEncodingException();
        }
        this.encoding = string;
    }

    int underlyingRead() throws IOException {
        int n;
        int n2;
        int n3;
        if (this.encoding == null) {
            n3 = this.input.read();
            n2 = this.input.read();
            if (n3 == 255 && n2 == 254) {
                this.encoding = "UTF-16BE";
            } else if (n3 == 254 && n2 == 255) {
                this.encoding = "UTF-16BE";
            } else {
                int n4;
                n = this.input.read();
                int n5 = (n3 << 24) + (n2 << 16) + (n << 8) + (n4 = this.input.read());
                this.encoding = n5 == 60 ? null : (n5 == 0x3C000000 ? null : (n5 == 15360 ? null : (n5 == 0x3C0000 ? null : (n5 == 3932223 ? "UTF-16BE" : (n5 == 1006649088 ? "UTF-16BE" : (n5 == 1010792557 ? UTF8 : (n5 == 1282385812 ? null : UTF8)))))));
                this.buffer.insert(this.bufpos, (char)n4);
                this.buffer.insert(this.bufpos, (char)n);
                this.buffer.insert(this.bufpos, (char)n2);
                this.buffer.insert(this.bufpos, (char)n3);
            }
        }
        if (this.bufpos < this.buffer.length()) {
            n3 = this.buffer.charAt(this.bufpos++);
            if (this.bufpos == this.buffer.length()) {
                this.bufpos = 0;
                this.buffer.setLength(0);
            }
            return n3;
        }
        if (this.encoding == ASCII) {
            return this.input.read();
        }
        if (this.encoding == "UTF-16BE" || this.encoding == "UTF-16BE") {
            n3 = this.input.read();
            if (n3 == -1) {
                return -1;
            }
            n2 = this.input.read();
            if (n2 == -1) {
                throw new IOException("unexpected EOS");
            }
            return this.encoding == "UTF-16BE" ? n3 << 8 + n2 : n2 << 8 + n3;
        }
        if (this.encoding == UTF8) {
            n3 = this.input.read();
            if (n3 < 127) {
                return n3;
            }
            n2 = this.input.read();
            if (n2 == -1) {
                throw new IOException("unexpected EOS");
            }
            if (n3 >> 5 == 6) {
                n3 &= 0x1F;
                if (n2 >> 6 != 2) {
                    throw new IOException("bad character code");
                }
                return n3 << 6 + (n2 &= 0x3F);
            }
            n = this.input.read();
            if (n == -1) {
                throw new IOException("unexpected EOS");
            }
            if (n3 >> 4 == 14) {
                n3 &= 0xF;
                if (n2 >> 6 != 2) {
                    throw new IOException("bad character code");
                }
                n2 &= 0x3F;
                if (n >> 6 != 2) {
                    throw new IOException("bad character code");
                }
                return n3 << 12 + n2 << 6 + (n &= 0x3F);
            }
            throw new IOException("bad character code");
        }
        throw new IOException("untrapped illegal encoding");
    }
}

