/*
 * Decompiled with CFR 0.152.
 */
package megamek.test;

import gd.xml.ParseException;
import gd.xml.XMLParser;
import gd.xml.XMLResponder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class TinyXMLTest
implements XMLResponder {
    private String filename;
    private String prefix;

    public TinyXMLTest(String string, String string2) {
        this.filename = string2;
        this.prefix = "  ";
        try {
            XMLParser xMLParser = new XMLParser();
            if (string.equals("xml")) {
                xMLParser.parseXML((XMLResponder)this);
            }
            if (string.equals("dtd")) {
                xMLParser.parseDTD((XMLResponder)this);
            }
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
        }
    }

    public void recordNotationDeclaration(String string, String string2, String string3) throws ParseException {
        System.out.print(this.prefix + "!NOTATION: " + string);
        if (string2 != null) {
            System.out.print("  pubID = " + string2);
        }
        if (string3 != null) {
            System.out.print("  sysID = " + string3);
        }
        System.out.println("");
    }

    public void recordEntityDeclaration(String string, String string2, String string3, String string4, String string5) throws ParseException {
        System.out.print(this.prefix + "!ENTITY: " + string);
        if (string2 != null) {
            System.out.print("  value = " + string2);
        }
        if (string3 != null) {
            System.out.print("  pubID = " + string3);
        }
        if (string4 != null) {
            System.out.print("  sysID = " + string4);
        }
        if (string5 != null) {
            System.out.print("  notation = " + string5);
        }
        System.out.println("");
    }

    public void recordElementDeclaration(String string, String string2) throws ParseException {
        System.out.print(this.prefix + "!ELEMENT: " + string);
        System.out.println("  content = " + string2);
    }

    public void recordAttlistDeclaration(String string, String string2, boolean bl, String string3, String string4, String string5) throws ParseException {
        System.out.print(this.prefix + "!ATTLIST: " + string);
        System.out.print("  attr = " + string2);
        System.out.print("  type = " + (bl ? "NOTATIONS " : "") + string3);
        System.out.print("  def. modifier = " + string4);
        System.out.println(string5 == null ? "" : "  def = " + bl);
    }

    public void recordDoctypeDeclaration(String string, String string2, String string3) throws ParseException {
        System.out.print(this.prefix + "!DOCTYPE: " + string);
        if (string2 != null) {
            System.out.print("  pubID = " + string2);
        }
        if (string3 != null) {
            System.out.print("  sysID = " + string3);
        }
        System.out.println("");
        this.prefix = "";
    }

    public void recordDocStart() {
    }

    public void recordDocEnd() {
        System.out.println("");
        System.out.println("Parsing finished without error");
    }

    public void recordElementStart(String string, Hashtable hashtable) throws ParseException {
        System.out.println(this.prefix + "Element: " + string);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            System.out.print(this.prefix);
            String string2 = "";
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                System.out.print(string2 + k + " = " + hashtable.get(k));
                string2 = ", ";
            }
            System.out.println("");
        }
        this.prefix = this.prefix + "  ";
    }

    public void recordElementEnd(String string) throws ParseException {
        this.prefix = this.prefix.substring(2);
    }

    public void recordPI(String string, String string2) {
        System.out.println(this.prefix + "*" + string + " PI: " + string2);
    }

    public void recordCharData(String string) {
        System.out.println(this.prefix + string);
    }

    public void recordComment(String string) {
        System.out.println(this.prefix + "*Comment: " + string);
    }

    public InputStream getDocumentStream() throws ParseException {
        try {
            return new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("could not find the specified file");
        }
    }

    public InputStream resolveExternalEntity(String string, String string2, String string3) throws ParseException {
        if (string3 != null) {
            File file = new File(new File(this.filename).getParent(), string3);
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ParseException("file not found (" + file + ")");
            }
        }
        return null;
    }

    public InputStream resolveDTDEntity(String string, String string2, String string3) throws ParseException {
        return this.resolveExternalEntity(string, string2, string3);
    }
}

