/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class GrappleAttackAction
extends PhysicalAttackAction {
    private static final long serialVersionUID = -4178252788550426489L;

    public GrappleAttackAction(int n, int n2) {
        super(n, n2);
    }

    public GrappleAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        return GrappleAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        return GrappleAttackAction.toHit(iGame, n, targetable, 0);
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        Mech mech;
        int n3;
        boolean bl;
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("tacops_grappling")) {
            return new ToHitData(Integer.MAX_VALUE, "grappling attack not allowed");
        }
        String string = GrappleAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null && !string.equals("Locked in Grapple")) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        if (!iGame.getOptions().booleanOption("friendly_fire") && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
            return new ToHitData(Integer.MAX_VALUE, "A friendly unit can never be the target of a direct attack.");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = entity.getElevation() + iHex.getElevation();
        int n5 = targetable.getElevation() + iHex2.getElevation();
        if (!(entity instanceof BipedMech) && !(entity instanceof Protomech) || !(targetable instanceof Mech) && !(targetable instanceof Protomech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only biped mechs can grapple 'Mechs and Protomechs");
        }
        Entity entity2 = (Entity)targetable;
        boolean bl2 = bl = entity.getGrappled() != -1 && !entity.isGrappleAttacker();
        if (n2 == 0) {
            if (entity.isLocationBad(5) || entity.isLocationBad(4)) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (!entity.hasWorkingSystem(7, 4) || !entity.hasWorkingSystem(7, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder missing/destroyed");
            }
        } else if (n2 == 2) {
            if (entity.isLocationBad(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (!entity.hasWorkingSystem(7, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder missing/destroyed");
            }
        } else {
            if (entity.isLocationBad(4)) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (!entity.hasWorkingSystem(7, 4)) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder missing/destroyed");
            }
        }
        if ((n3 = entity.getPosition().distance(targetable.getPosition())) != 1 && !bl) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (Math.abs(n4 - n5) > entity.getMaxElevationChange()) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (!bl && !Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (((Entity)targetable).isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is prone");
        }
        if (!bl) {
            for (Mounted mounted : entity.getWeaponList()) {
                if (!mounted.isUsedThisRound()) continue;
                return new ToHitData(Integer.MAX_VALUE, "Fired weapons");
            }
        }
        int n6 = entity.getGrappled();
        int n7 = entity2.getGrappled();
        if ((n6 != -1 || n7 != -1) && n6 != targetable.getTargetId() && entity2.isGrappleAttacker()) {
            return new ToHitData(Integer.MAX_VALUE, "Already grappled");
        }
        int n8 = entity.getCrew().getPiloting();
        ToHitData toHitData = new ToHitData(n8, "base");
        GrappleAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (entity instanceof Mech && n2 == 0) {
            if (!entity.hasWorkingSystem(8, 5)) {
                toHitData.addModifier(2, "Left upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 5)) {
                toHitData.addModifier(2, "Left lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 5)) {
                toHitData.addModifier(1, "Left hand actuator destroyed");
            }
            if (!entity.hasWorkingSystem(8, 4)) {
                toHitData.addModifier(2, "Right upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 4)) {
                toHitData.addModifier(2, "Right lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 4)) {
                toHitData.addModifier(1, "Right hand actuator destroyed");
            }
            if (entity.hasFunctionalArmAES(4) && entity.hasFunctionalArmAES(5)) {
                toHitData.addModifier(-1, "AES modifer");
            }
        } else if (entity instanceof Mech && n2 == 1) {
            if (!entity.hasWorkingSystem(8, 4)) {
                toHitData.addModifier(2, "Right upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 4)) {
                toHitData.addModifier(2, "Right lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 4)) {
                toHitData.addModifier(1, "Right hand actuator destroyed");
            }
            if (entity.hasFunctionalArmAES(4)) {
                toHitData.addModifier(-1, "AES modifer");
            }
        } else {
            if (!entity.hasWorkingSystem(8, 5)) {
                toHitData.addModifier(2, "Left upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 5)) {
                toHitData.addModifier(2, "Left lower arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, 5)) {
                toHitData.addModifier(1, "Left hand actuator destroyed");
            }
            if (entity.hasFunctionalArmAES(5)) {
                toHitData.addModifier(-1, "AES modifer");
            }
        }
        if (n2 != 0 && entity instanceof Mech && (mech = (Mech)entity).hasTSM() && mech.heat >= 9 && (!(entity2 instanceof Mech) || !((Mech)entity2).hasTSM() || ((Mech)entity2).hasTSM() && entity2.heat < 9)) {
            toHitData.addModifier(-2, "TSM Active Bonus");
        }
        int n9 = entity2.getWeightClass() - entity.getWeightClass();
        if (entity2 instanceof Protomech && !(entity instanceof Protomech)) {
            n9 = entity.getWeightClass() * -1;
        } else if (entity instanceof Protomech && !(entity2 instanceof Protomech)) {
            n9 = entity2.getWeightClass();
        } else if (entity2 instanceof Protomech && entity instanceof Protomech) {
            n9 = 0;
        }
        if (n9 != 0) {
            toHitData.addModifier(n9, "Weight class difference");
        }
        return toHitData;
    }
}

