/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmorHandlesTank;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Report;
import megamek.common.Team;
import megamek.common.VTOL;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tank
extends Entity
implements Serializable {
    private static final long serialVersionUID = -857210851169206264L;
    protected boolean m_bHasNoTurret = false;
    protected boolean m_bTurretLocked = false;
    protected boolean m_bTurretJammed = false;
    protected boolean m_bTurretEverJammed = false;
    private int m_nTurretOffset = 0;
    private int m_nStunnedTurns = 0;
    private boolean m_bImmobile = false;
    private boolean m_bImmobileHit = false;
    private int burningLocations = 0;
    protected int movementDamage = 0;
    private boolean minorMovementDamage = false;
    private boolean moderateMovementDamage = false;
    private boolean heavyMovementDamage = false;
    private boolean infernoFire = false;
    private ArrayList<Mounted> jammedWeapons = new ArrayList();
    protected boolean engineHit = false;
    public static final int LOC_BODY = 0;
    public static final int LOC_FRONT = 1;
    public static final int LOC_RIGHT = 2;
    public static final int LOC_LEFT = 3;
    public static final int LOC_REAR = 4;
    public static final int LOC_TURRET = 5;
    public static final int CRIT_NONE = -1;
    public static final int CRIT_DRIVER = 0;
    public static final int CRIT_WEAPON_JAM = 1;
    public static final int CRIT_WEAPON_DESTROYED = 2;
    public static final int CRIT_STABILIZER = 3;
    public static final int CRIT_SENSOR = 4;
    public static final int CRIT_COMMANDER = 5;
    public static final int CRIT_CREW_KILLED = 6;
    public static final int CRIT_CREW_STUNNED = 7;
    public static final int CRIT_CARGO = 8;
    public static final int CRIT_ENGINE = 9;
    public static final int CRIT_FUEL_TANK = 10;
    public static final int CRIT_AMMO = 11;
    public static final int CRIT_TURRET_JAM = 12;
    public static final int CRIT_TURRET_LOCK = 13;
    public static final int CRIT_TURRET_DESTROYED = 14;
    private static final int[] NUM_OF_SLOTS = new int[]{25, 25, 25, 25, 25, 25};
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RS", "LS", "RR", "TU"};
    public static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Turret"};
    private int sensorHits = 0;
    private int stabiliserHits = 0;
    private boolean driverHit = false;
    private boolean commanderHit = false;
    private boolean driverHitPS = false;
    private boolean commanderHitPS = false;
    private boolean crewHitPS = false;

    @Override
    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public boolean hasNoTurret() {
        return this.m_bHasNoTurret;
    }

    public void setHasNoTurret(boolean bl) {
        this.m_bHasNoTurret = bl;
    }

    @Override
    public int getWalkMP(boolean bl, boolean bl2) {
        int n;
        int n2 = this.getOriginalWalkMP();
        n2 = Math.max(0, n2 - this.getCargoMpReduction());
        if (null != this.game && (n = this.game.getPlanetaryConditions().getMovementMods(this)) != 0) {
            n2 = Math.max(n2 + n, 0);
        }
        if (this.hasModularArmor()) {
            --n2;
        }
        if (bl) {
            n2 = this.applyGravityEffectsOnMP(n2);
        }
        return n2;
    }

    public boolean isTurretLocked() {
        return this.m_bTurretLocked || this.m_bTurretJammed;
    }

    public boolean isTurretJammed() {
        return this.m_bTurretJammed;
    }

    @Override
    public int locations() {
        return this.m_bHasNoTurret ? 5 : 6;
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return !this.m_bHasNoTurret && !this.isTurretLocked();
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        return !this.isTurretLocked();
    }

    @Override
    public int clipSecondaryFacing(int n) {
        return n;
    }

    @Override
    public void setSecondaryFacing(int n) {
        if (!this.isTurretLocked()) {
            super.setSecondaryFacing(n);
            if (!this.m_bHasNoTurret) {
                this.m_nTurretOffset = n - this.getFacing();
            }
        }
    }

    @Override
    public void setFacing(int n) {
        super.setFacing(n);
        if (this.isTurretLocked()) {
            int n2 = (n + this.m_nTurretOffset + 6) % 6;
            super.setSecondaryFacing(n2);
        }
    }

    public boolean isStabiliserHit(int n) {
        return (this.stabiliserHits & 1 << n) == 1 << n;
    }

    public void setStabiliserHit(int n) {
        this.stabiliserHits |= 1 << n;
    }

    public int getSensorHits() {
        return this.sensorHits;
    }

    public void setSensorHits(int n) {
        this.sensorHits = n;
    }

    public boolean isDriverHit() {
        return this.driverHit;
    }

    public void setDriverHit(boolean bl) {
        this.driverHit = bl;
    }

    public boolean isCommanderHit() {
        return this.commanderHit;
    }

    public void setCommanderHit(boolean bl) {
        this.commanderHit = bl;
    }

    public boolean isDriverHitPS() {
        return this.driverHitPS;
    }

    public void setDriverHitPS(boolean bl) {
        this.driverHitPS = bl;
    }

    public boolean isCommanderHitPS() {
        return this.commanderHitPS;
    }

    public void setCommanderHitPS(boolean bl) {
        this.commanderHitPS = bl;
    }

    public boolean isCrewHitPS() {
        return this.crewHitPS;
    }

    public void setCrewHitPS(boolean bl) {
        this.crewHitPS = bl;
    }

    public boolean isMovementHit() {
        return this.m_bImmobile;
    }

    public boolean isMovementHitPending() {
        return this.m_bImmobileHit;
    }

    public void immobilize() {
        this.m_bImmobileHit = true;
        this.setOriginalWalkMP(0);
    }

    @Override
    public boolean isImmobile() {
        if (this.game.getOptions().booleanOption("no_immobile_vehicles")) {
            return super.isImmobile();
        }
        return super.isImmobile() || this.m_bImmobile;
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(33)) {
            return true;
        }
        if (iHex.containsTerrain(11) && this.doomedInSpace()) {
            return true;
        }
        switch (this.movementMode) {
            case 3: {
                return iHex.terrainLevel(1) > 1 || iHex.terrainLevel(2) > 0 && !iHex.containsTerrain(17) || iHex.containsTerrain(5) || iHex.terrainLevel(8) > 1 || iHex.terrainLevel(3) > 1;
            }
            case 4: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(3) || iHex.terrainLevel(2) > 0 && !iHex.containsTerrain(17) || iHex.containsTerrain(4) || iHex.containsTerrain(8) || iHex.containsTerrain(5) || iHex.terrainLevel(18) > 1 || iHex.terrainLevel(21) == 2;
            }
            case 5: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(5) || iHex.terrainLevel(8) > 1 || iHex.terrainLevel(3) > 1;
            }
            case 7: 
            case 8: {
                return iHex.terrainLevel(2) <= 0 || iHex.containsTerrain(17);
            }
            case 9: {
                return iHex.terrainLevel(2) <= 0;
            }
            case 15: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(22);
            }
        }
        return false;
    }

    public void lockTurret() {
        this.m_bTurretLocked = true;
    }

    public void jamTurret() {
        this.m_bTurretEverJammed = true;
        this.m_bTurretJammed = true;
    }

    public void unjamTurret() {
        this.m_bTurretJammed = false;
    }

    public boolean isTurretEverJammed() {
        return this.m_bTurretEverJammed;
    }

    public int getStunnedTurns() {
        return this.m_nStunnedTurns;
    }

    public void setStunnedTurns(int n) {
        this.m_nStunnedTurns = n;
    }

    public void stunCrew() {
        this.m_nStunnedTurns = this.m_nStunnedTurns == 0 ? 2 : ++this.m_nStunnedTurns;
    }

    @Override
    public void applyDamage() {
        this.m_bImmobile |= this.m_bImmobileHit;
    }

    @Override
    public void newRound(int n) {
        super.newRound(n);
        if (this.m_nStunnedTurns > 0) {
            --this.m_nStunnedTurns;
        }
        if (!this.m_bTurretLocked) {
            this.setSecondaryFacing(this.getFacing());
        }
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Cruised";
            }
            case 2: {
                return "Flanked";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case -2: {
                return "S";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "F";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    @Override
    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.getType() instanceof WeaponType && mounted.getType().hasFlag(0x1000000000L)) {
            return 0;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: {
                if (this.game.getOptions().booleanOption("tacops_vehicle_arcs")) {
                    return 11;
                }
            }
            case 5: {
                if (this.game.getOptions().booleanOption("tacops_vehicle_arcs")) {
                    return 25;
                }
                return 1;
            }
            case 2: {
                if (this.game.getOptions().booleanOption("tacops_vehicle_arcs")) {
                    return 21;
                }
                return 6;
            }
            case 3: {
                if (this.game.getOptions().booleanOption("tacops_vehicle_arcs")) {
                    return 20;
                }
                return 5;
            }
            case 4: {
                if (this.game.getOptions().booleanOption("tacops_vehicle_arcs")) {
                    return 22;
                }
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() == 5;
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.m_bHasNoTurret || n == 8;
        int n7 = 0;
        if (n2 == 0 && this.isHullDown() && !bl3) {
            n6 = 5;
        }
        if (n2 == 2) {
            n6 = 3;
            bl = true;
            n7 = 2;
        } else if (n2 == 3) {
            n6 = 2;
            bl = true;
            n7 = 2;
        } else if (n2 == 1) {
            n6 = 4;
            n7 = 1;
            bl2 = true;
        }
        if (this.game.getOptions().booleanOption("tacops_vehicle_effective")) {
            n7 = 0;
        }
        HitData hitData = new HitData(n6);
        boolean bl4 = false;
        if (n3 != -1 && n4 != 0 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            hitData = new HitData(n3, n2 == 1, true);
            bl4 = true;
        }
        if (!bl4) {
            switch (Compute.d6(2)) {
                case 2: {
                    hitData.setEffect(1);
                    break;
                }
                case 3: {
                    hitData.setEffect(2);
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 4: {
                    hitData.setEffect(2);
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 5: {
                    hitData = bl ? new HitData(1, false, 2) : (bl2 ? new HitData(3, false, 2) : new HitData(3, false, 2));
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    if (!bl || this.game.getOptions().booleanOption("tacops_vehicle_effective")) break;
                    hitData.setEffect(1);
                    break;
                }
                case 9: {
                    if (this.game.getOptions().booleanOption("tacops_vehicle_effective")) {
                        if (bl) {
                            hitData = new HitData(4);
                            break;
                        }
                        if (bl2) {
                            hitData = new HitData(2);
                            break;
                        }
                        hitData = new HitData(3);
                        break;
                    }
                    hitData = bl ? new HitData(4, false, 2) : (bl2 ? new HitData(2, false, 2) : new HitData(3, false, 2));
                    hitData.setMotiveMod(n7);
                    break;
                }
                case 10: {
                    if (bl3) break;
                    hitData = new HitData(5);
                    break;
                }
                case 11: {
                    if (bl3) break;
                    hitData = new HitData(5);
                    break;
                }
                case 12: {
                    if (bl3) {
                        hitData.setEffect(1);
                        break;
                    }
                    hitData = new HitData(5, false, 1);
                }
            }
        }
        if (n == 3) {
            hitData.setEffect(hitData.getEffect() | 1);
        }
        return hitData;
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return -1;
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false, false);
    }

    @Override
    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n;
        Object object;
        Object object2;
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x200000000000L)) continue;
            n2 += mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
        }
        d2 += (double)(this.getTotalArmor() + n2) * 2.5;
        d2 += (double)this.getTotalInternal() * 1.5;
        double d4 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            EquipmentType equipmentType = mounted.getType();
            if (mounted.isDestroyed() || (!(equipmentType instanceof WeaponType) || !equipmentType.hasFlag(0x800000L) && !equipmentType.hasFlag(0x1000000000L)) && (!(equipmentType instanceof AmmoType) || ((AmmoType)equipmentType).getAmmoType() != 14) && (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x80000000000L) && !equipmentType.hasFlag(0x800000L) && !equipmentType.hasFlag(0x100000000000L))) continue;
            d4 += equipmentType.getBV(this);
        }
        d2 += d4;
        switch (this.getMovementMode()) {
            case 3: {
                d = 0.9;
                break;
            }
            case 4: {
                d = 0.8;
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                d = 0.7;
                break;
            }
            case 7: {
                d = 0.6;
                break;
            }
            default: {
                d = 0.6;
            }
        }
        d2 *= d;
        double d5 = Compute.getTargetMovementModifier(this.getRunMP(false, true), this instanceof VTOL, this instanceof VTOL).getValue();
        int n3 = Compute.getTargetMovementModifier(this.getJumpMP(), true, false).getValue();
        double d6 = 1.0 + Math.max(d5, (double)n3) / 10.0;
        d2 *= d6;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        boolean bl3 = this.hasTargComp();
        HashMap<Object, Double> hashMap = new HashMap<Object, Double>();
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            double d10 = weaponType.getBV(this);
            if (mounted.isDestroyed() || weaponType.hasFlag(0x800000L) || weaponType.hasFlag(0x1000000000L)) continue;
            if (mounted.getLinkedBy() != null && ((Mounted)(object2 = mounted.getLinkedBy())).getType() instanceof MiscType && ((Mounted)object2).getType().hasFlag(512L)) {
                d10 *= 1.2;
            }
            if (mounted.getLinkedBy() != null && ((Mounted)(object2 = mounted.getLinkedBy())).getType() instanceof MiscType && ((Mounted)object2).getType().hasFlag(0x1000000000000L)) {
                d10 *= 1.15;
            }
            if (weaponType.hasFlag(1L) && bl3) {
                d10 *= 1.25;
            }
            if (mounted.getLocation() == 4) {
                d9 += d10;
            } else if (mounted.getLocation() == 1) {
                d8 += d10;
            } else {
                d7 += d10;
            }
            if (weaponType.hasFlag(131072L) && weaponType.getAmmoType() != 46 || weaponType.hasFlag(16384L) || weaponType.hasFlag(2048L) || weaponType.getAmmoType() == -1) continue;
            object2 = weaponType.getAmmoType() + ":" + weaponType.getRackSize();
            if (!hashMap.containsKey(object2)) {
                hashMap.put(object2, weaponType.getBV(this));
                continue;
            }
            hashMap.put(object2, weaponType.getBV(this) + (Double)hashMap.get(object2));
        }
        if (d8 > d9) {
            d7 += d8;
            d7 += d9 * 0.5;
        } else {
            d7 += d9;
            d7 += d8 * 0.5;
        }
        double d11 = 0.0;
        double d12 = 0.0;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        object2 = new ArrayList();
        for (Mounted object3 : this.getAmmo()) {
            String string;
            Player player;
            AmmoType ammoType = (AmmoType)object3.getType();
            if (object3.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || object3.getLocation() == -1) continue;
            if ((ammoType.getMunitionType() == 524288L || ammoType.getMunitionType() == 0x2000000000L) && (player = this.getOwner()) != null) {
                if (player.hasTAG()) {
                    d12 += ammoType.getBV(this);
                } else if (player.getTeam() != 0 && this.game != null) {
                    object = this.game.getTeams();
                    while (object.hasMoreElements()) {
                        Team team = (Team)object.nextElement();
                        if (team.getId() != player.getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d12 += ammoType.getBV(this);
                        break;
                    }
                }
            }
            if (!((ArrayList)object2).contains(string = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                ((ArrayList)object2).add(string);
            }
            if (!hashMap2.containsKey(string)) {
                hashMap2.put(string, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(string, ammoType.getBV(this) + (Double)hashMap2.get(string));
        }
        Iterator<Mounted> iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            String string = (String)((Object)iterator.next());
            if (!hashMap2.containsKey(string) || !hashMap.containsKey(string)) continue;
            if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                d11 += ((Double)hashMap.get(string)).doubleValue();
                continue;
            }
            d11 += ((Double)hashMap2.get(string)).doubleValue();
        }
        d7 += d11;
        double d13 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            object = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || ((EquipmentType)object).hasFlag(0x80000000000L) || ((EquipmentType)object).hasFlag(0x800000L) || ((EquipmentType)object).hasFlag(0x100000000000L) || ((EquipmentType)object).hasFlag(1024L)) continue;
            d13 += ((MiscType)object).getBV(this);
        }
        d7 += d13;
        double d10 = Math.pow(1.0 + ((double)this.getRunMP(false, true) + (double)Math.round((double)this.getJumpMP(false) / 2.0) - 5.0) / 10.0, 1.2);
        d10 = (double)Math.round(d10 * 100.0) / 100.0;
        d3 = (d7 += (double)(this.getWeight() / 2.0f)) * d10;
        double d14 = 0.0;
        d14 += d12;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.c3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) && !bl && this.game != null) {
            n = 0;
            n += this.calculateBattleValue(true, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n += entity.calculateBattleValue(true, true);
            }
            n = (int)((double)n * 0.05);
            d14 += (double)n;
        }
        n = (int)Math.round(d2 + d3 + d14);
        double d15 = 1.0;
        if (!bl2) {
            d15 = this.crew.getBVSkillMultiplier();
        }
        int n4 = (int)Math.round((double)n * d15);
        if (bl) {
            return n;
        }
        return n4;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        IHex iHex;
        if (this.movementDamage > 0) {
            pilotingRollData.addModifier(this.movementDamage, "Steering Damage");
        }
        if (this.commanderHit) {
            pilotingRollData.addModifier(1, "commander injured");
        }
        if (this.driverHit) {
            pilotingRollData.addModifier(2, "driver injured");
        }
        if (null != (iHex = this.game.getBoard().getHex(this.getPosition())) && this.getMovementMode() == 4 && iHex.terrainLevel(18) == 1) {
            pilotingRollData.addModifier(1, "thin snow");
        }
        if (this.getCrew().getOptions().booleanOption("vdni") && !this.getCrew().getOptions().booleanOption("bvdni")) {
            pilotingRollData.addModifier(-1, "VDNI");
        }
        if (this.hasModularArmor()) {
            pilotingRollData.addModifier(1, "Modular Armor");
        }
        return pilotingRollData;
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7035);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        return this.getRunMP(bl, bl2);
    }

    @Override
    public int getHeatCapacity() {
        return 999;
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    public void autoSetInternal() {
        int n = (int)Math.ceil((double)this.weight / 10.0);
        this.initializeInternal(-1, 0);
        for (int i = 1; i < this.locations(); ++i) {
            this.initializeInternal(n, i);
        }
    }

    @Override
    public int getMaxElevationChange() {
        return 1;
    }

    @Override
    public int getMaxElevationDown() {
        if (this.getElevation() > 0 && this.getMovementMode() == 15) {
            return 50;
        }
        return super.getMaxElevationDown();
    }

    @Override
    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 1; bl && i < 5; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    @Override
    public void restore() {
        super.restore();
    }

    @Override
    public boolean canCharge() {
        return super.canCharge() && (!this.game.getOptions().booleanOption("no_hover_charge") || 5 != this.getMovementMode()) && 15 != this.getMovementMode() && this.getStunnedTurns() <= 0;
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public int getArmorType() {
        return this.armorType;
    }

    @Override
    public void setArmorType(int n) {
        this.armorType = n;
    }

    @Override
    public int getStructureType() {
        return this.structureType;
    }

    @Override
    public void setStructureType(int n) {
        this.structureType = n;
    }

    public int getSuspensionFactor() {
        switch (this.movementMode) {
            case 5: {
                if (this.weight <= 10.0f) {
                    return 40;
                }
                if (this.weight <= 20.0f) {
                    return 85;
                }
                if (this.weight <= 30.0f) {
                    return 130;
                }
                if (this.weight <= 40.0f) {
                    return 175;
                }
                return 235;
            }
            case 8: {
                if (this.weight <= 10.0f) {
                    return 60;
                }
                if (this.weight <= 20.0f) {
                    return 105;
                }
                if (this.weight <= 30.0f) {
                    return 150;
                }
                if (this.weight <= 40.0f) {
                    return 195;
                }
                if (this.weight <= 50.0f) {
                    return 255;
                }
                if (this.weight <= 60.0f) {
                    return 300;
                }
                if (this.weight <= 70.0f) {
                    return 345;
                }
                if (this.weight <= 80.0f) {
                    return 390;
                }
                if (this.weight <= 90.0f) {
                    return 435;
                }
                return 480;
            }
            case 7: 
            case 9: {
                return 30;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 20;
            }
            case 6: {
                if (this.weight <= 10.0f) {
                    return 50;
                }
                if (this.weight <= 20.0f) {
                    return 95;
                }
                return 140;
            }
            case 15: {
                if (this.weight <= 15.0f) {
                    return 45;
                }
                if (this.weight <= 30.0f) {
                    return 80;
                }
                if (this.weight <= 45.0f) {
                    return 115;
                }
                if (!(this.weight <= 80.0f)) break;
                return 140;
            }
        }
        return 0;
    }

    @Override
    public double getCost() {
        double d;
        double d2 = 0.0;
        Engine engine = this.getEngine();
        d2 += (double)((float)(engine.getBaseCost() * engine.getRating()) * this.weight) / 75.0;
        double d3 = Math.ceil((double)this.weight * 0.05 * 2.0) / 2.0;
        d2 += 10000.0 * d3;
        d2 += (double)this.weight / 10.0 * 10000.0;
        double d4 = engine.getWeightFreeEngineHeatSinks();
        int n = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.hasFlag(4L) || weaponType.hasFlag(8L)) {
                n += weaponType.getHeat();
                d6 += (double)weaponType.getTonnage(this) / 10.0;
            }
            if (this.hasNoTurret() || mounted.getLocation() != 5) continue;
            d5 += (double)weaponType.getTonnage(this) / 10.0;
        }
        d6 = Math.ceil(d6 * 10.0) / 10.0;
        if (engine.isFusion()) {
            d6 = 0.0;
        }
        d5 = Math.ceil(d5 * 2.0) / 2.0;
        d2 += 20000.0 * d6;
        d2 += 2000.0 * Math.max(0.0, (double)n - d4);
        d2 += d5 * 5000.0;
        d2 += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        switch (this.movementMode) {
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                d = (double)this.weight / 10.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        d2 = this.movementMode != 6 ? (d2 += d * 20000.0) : (d2 += d * 40000.0);
        d2 += (double)this.getWeaponsAndEquipmentCost();
        double d7 = 1.0;
        switch (this.movementMode) {
            case 5: 
            case 9: {
                d7 += (double)this.weight / 50.0;
                break;
            }
            case 8: {
                d7 += (double)this.weight / 75.0;
                break;
            }
            case 4: 
            case 7: {
                d7 += (double)this.weight / 200.0;
                break;
            }
            case 3: {
                d7 += (double)this.weight / 100.0;
                break;
            }
            case 6: {
                d7 += (double)this.weight / 30.0;
            }
        }
        return Math.round(d2 * d7);
    }

    @Override
    public boolean doomedInVacuum() {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getType() instanceof MiscType && mounted.getType().hasFlag(8192L)) {
                return false;
            }
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x8000000000L)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doomedOnGround() {
        return false;
    }

    @Override
    public boolean doomedInAtmosphere() {
        return true;
    }

    @Override
    public boolean doomedInSpace() {
        return true;
    }

    @Override
    public boolean canGoHullDown() {
        return this.game.getOptions().booleanOption("tacops_hull_down");
    }

    public void setOnFire(boolean bl) {
        this.infernoFire |= bl;
        this.burningLocations = (1 << this.locations()) - 1;
        this.extinguishLocation(0);
    }

    public boolean isOnFire() {
        return this.burningLocations != 0 || this.infernos.isStillBurning();
    }

    public boolean isInfernoFire() {
        return this.infernoFire;
    }

    public boolean isLocationBurning(int n) {
        int n2 = 1 << n;
        return (this.burningLocations & n2) == n2;
    }

    public void extinguishLocation(int n) {
        int n2 = ~(1 << n);
        this.burningLocations &= n2;
    }

    public void extinguishAll() {
        this.burningLocations = 0;
        this.infernoFire = false;
        this.infernos.clear();
    }

    public void addMovementDamage(int n) {
        switch (n) {
            case 1: {
                if (this.minorMovementDamage) break;
                this.minorMovementDamage = true;
                this.movementDamage += n;
                break;
            }
            case 2: {
                if (this.moderateMovementDamage) break;
                this.moderateMovementDamage = true;
                this.movementDamage += n;
                break;
            }
            case 3: {
                if (this.heavyMovementDamage) break;
                this.heavyMovementDamage = true;
                this.movementDamage += n;
            }
        }
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
        if (engine.engineValid) {
            this.setOriginalWalkMP(this.calculateWalk());
        }
    }

    protected int calculateWalk() {
        return (this.getEngine().getRating() + this.getSuspensionFactor()) / (int)this.weight;
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }

    @Override
    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        super.addEquipment(mounted, n, bl);
        this.addCritical(n, new CriticalSlot(1, this.getEquipmentNum(mounted), true, mounted));
    }

    public int getCriticalEffect(int n, int n2) {
        if (n > 12) {
            n = 12;
        }
        if (n < 6) {
            return -1;
        }
        block36: for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                n = 6;
            }
            if (n2 == 1) {
                switch (n) {
                    case 6: {
                        if (!this.crew.isDead() && !this.crew.isDoomed()) {
                            if (!this.isDriverHit()) {
                                return 0;
                            }
                            if (!this.isCommanderHit()) {
                                return 7;
                            }
                            return 6;
                        }
                    }
                    case 7: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            for (Mounted mounted : this.getWeaponList()) {
                                if (mounted.getLocation() != n2) continue;
                                return 3;
                            }
                        }
                    }
                    case 9: {
                        if (this.getSensorHits() < 4) {
                            return 4;
                        }
                    }
                    case 10: {
                        if (!this.crew.isDead() && !this.crew.isDoomed()) {
                            if (!this.isCommanderHit()) {
                                return 5;
                            }
                            if (!this.isDriverHit()) {
                                return 7;
                            }
                            return 6;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 12: {
                        if (this.crew.isDead() || this.crew.isDoomed()) break;
                        return 6;
                    }
                }
                continue;
            }
            if (n2 == 4) {
                switch (n) {
                    case 6: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 7: {
                        if (this.getLoadedUnits().size() > 0) {
                            return 8;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            for (Mounted mounted : this.getWeaponList()) {
                                if (mounted.getLocation() != n2) continue;
                                return 3;
                            }
                        }
                    }
                    case 9: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 10: {
                        if (!this.engineHit) {
                            return 9;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getAmmo()) {
                            if (mounted.isDestroyed() || mounted.isHit()) continue;
                            return 11;
                        }
                    }
                    case 12: {
                        if (this.getEngine().isFusion() && !this.engineHit) {
                            return 9;
                        }
                        if (this.getEngine().isFusion()) break;
                        return 10;
                    }
                }
                continue;
            }
            if (n2 == 5) {
                switch (n) {
                    case 6: {
                        if (!this.isStabiliserHit(n2)) {
                            for (Mounted mounted : this.getWeaponList()) {
                                if (mounted.getLocation() != n2) continue;
                                return 3;
                            }
                        }
                    }
                    case 7: {
                        if (!this.isTurretLocked()) {
                            return 12;
                        }
                    }
                    case 8: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed()) continue;
                            return 1;
                        }
                    }
                    case 9: {
                        if (!this.isTurretLocked()) {
                            return 13;
                        }
                    }
                    case 10: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getAmmo()) {
                            if (mounted.isDestroyed() || mounted.isHit()) continue;
                            return 11;
                        }
                    }
                    case 12: {
                        return 14;
                    }
                }
                continue;
            }
            switch (n) {
                case 6: {
                    if (this.getLoadedUnits().size() > 0) {
                        return 8;
                    }
                }
                case 7: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                        return 1;
                    }
                }
                case 8: {
                    if (!this.crew.isDead() && !this.crew.isDoomed()) {
                        if (this.isCommanderHit() && this.isDriverHit()) {
                            return 6;
                        }
                        return 7;
                    }
                }
                case 9: {
                    if (!this.isStabiliserHit(n2)) {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2) continue;
                            return 3;
                        }
                    }
                }
                case 10: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                        return 2;
                    }
                }
                case 11: {
                    if (!this.engineHit) {
                        return 9;
                    }
                }
                case 12: {
                    if (this.getEngine().isFusion() && !this.engineHit) {
                        return 9;
                    }
                    if (this.getEngine().isFusion()) continue block36;
                    return 10;
                }
            }
        }
        return -1;
    }

    @Override
    public void setOmni(boolean bl) {
        super.setOmni(bl);
        if (bl && !this.hasBattleArmorHandles()) {
            this.addTransporter(new BattleArmorHandlesTank());
        }
    }

    @Override
    public boolean canSpot() {
        return super.canSpot() && this.getStunnedTurns() == 0;
    }

    public void addJammedWeapon(Mounted mounted) {
        this.jammedWeapons.add(mounted);
    }

    public ArrayList<Mounted> getJammedWeapons() {
        return this.jammedWeapons;
    }

    public void engineHit() {
        this.engineHit = true;
        this.immobilize();
        this.lockTurret();
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (!weaponType.hasFlag(131072L)) continue;
            mounted.setBreached(true);
        }
    }

    @Override
    public boolean hasModularArmor() {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isDestroyed() || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModularArmor(int n) {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getLocation() != n || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTotalCommGearTons() {
        return 1 + this.getExtraCommGearTons();
    }

    @Override
    public int getHQIniBonus() {
        int n = super.getHQIniBonus();
        if (this.stabiliserHits > 0 && this.mpUsedLastRound > 0 || this.commanderHit) {
            return 0;
        }
        return n;
    }

    @Override
    public boolean hasArmoredEngine() {
        for (int i = 0; i < this.getNumberOfCriticals(0); ++i) {
            CriticalSlot criticalSlot = this.getCritical(0, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != 3) continue;
            return criticalSlot.isArmored();
        }
        return false;
    }
}

